/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.util.comm.channels;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.eclipse.fordiac.ide.util.comm.channels.IIecReceivable;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_ANY;
import org.eclipse.fordiac.ide.util.comm.exceptions.CommException;

public abstract class CChannel {
    private static final String INVALID_ID = "INVALID_ID";

    public static CChannel register(String channelID, IIecReceivable receiver) throws CommException {
        return null;
    }

    public static int getPort(String id) throws CommException {
        int n = id.indexOf(58);
        if (n <= 0 || n == id.length() - 1) {
            throw new CommException(INVALID_ID);
        }
        try {
            return Integer.valueOf(id.substring(n + 1));
        }
        catch (NumberFormatException numberFormatException) {
            throw new CommException(INVALID_ID);
        }
    }

    public static InetAddress getInetAddress(String id) throws CommException {
        int n = id.indexOf(58);
        if (n <= 0) {
            throw new CommException(INVALID_ID);
        }
        try {
            return InetAddress.getByName(id.substring(0, n));
        }
        catch (UnknownHostException unknownHostException) {
            throw new CommException(INVALID_ID);
        }
    }

    public abstract void deregister() throws CommException;

    public abstract List<IEC_ANY> receiveFrom() throws IOException, CommException;
}

