/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.util.comm.channels;

import java.util.HashMap;
import java.util.List;
import org.eclipse.fordiac.ide.util.comm.channels.CChannel;
import org.eclipse.fordiac.ide.util.comm.channels.ChannelFactory;
import org.eclipse.fordiac.ide.util.comm.channels.IIecReceivable;
import org.eclipse.fordiac.ide.util.comm.channels.tcp.TCPChannel;
import org.eclipse.fordiac.ide.util.comm.channels.udp.UDPChannel;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_ANY;
import org.eclipse.fordiac.ide.util.comm.exceptions.CommException;

public class ChannelManager {
    private static ChannelManager manager;
    private static HashMap<String, CChannel> channels;

    static {
        channels = new HashMap();
    }

    private ChannelManager() {
    }

    public static ChannelManager getInstance() {
        if (manager == null) {
            manager = new ChannelManager();
        }
        return manager;
    }

    public CChannel getChannel(String channelID) {
        return channels.get(channelID);
    }

    public boolean existsChannel(String channelID) {
        return channels.get(channelID) != null;
    }

    public void register(String channelID, int channelType, IIecReceivable Receiver) throws CommException {
        if (this.existsChannel(channelID)) {
            throw new CommException("Channel already in use.");
        }
        channels.put(channelID, ChannelFactory.getChannel(channelID, channelType, Receiver));
    }

    public void deregister(String channelID) throws CommException {
        CChannel channel = this.getChannel(channelID);
        if (channel == null) {
            throw new CommException("No Such Channel.");
        }
        channel.deregister();
        channels.remove(channelID);
    }

    public static void send(String channelID, int channelType, List<IEC_ANY> Data) throws CommException {
        switch (channelType) {
            case 0: {
                UDPChannel.send(channelID, Data);
                break;
            }
            case 1: {
                CChannel channel = channels.get(channelID);
                if (channel == null || !(channel instanceof TCPChannel)) break;
                ((TCPChannel)channel).send(Data);
            }
        }
    }
}

