/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemconfiguration.editor;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.fordiac.ide.gef.DiagramEditorWithFlyoutPalette;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.SystemConfiguration;
import org.eclipse.fordiac.ide.systemconfiguration.editor.SysConfTemplateTransferDropTargetListener;
import org.eclipse.fordiac.ide.systemconfiguration.editor.SystemConfPaletteFactory;
import org.eclipse.fordiac.ide.systemconfiguration.editor.SystemConfigurationContextMenueProvider;
import org.eclipse.fordiac.ide.systemconfiguration.editparts.SystemConfEditPartFactory;
import org.eclipse.fordiac.ide.systemmanagement.ISystemEditor;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.fordiac.ide.util.PersistableUntypedEditorInput;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.ui.IEditorInput;

public class SystemConfigurationEditor
extends DiagramEditorWithFlyoutPalette
implements ISystemEditor {
    private SystemConfiguration sysConf;

    protected EditPartFactory getEditPartFactory() {
        return new SystemConfEditPartFactory((GraphicalEditor)this, this.getZoomManger());
    }

    protected ContextMenuProvider getContextMenuProvider(ScrollingGraphicalViewer viewer, ZoomManager zoomManager) {
        return new SystemConfigurationContextMenueProvider((EditPartViewer)viewer, zoomManager, this.getActionRegistry());
    }

    protected TransferDropTargetListener createTransferDropTargetListener() {
        return new SysConfTemplateTransferDropTargetListener((EditPartViewer)this.getViewer(), this.getSystem());
    }

    public SystemConfiguration getModel() {
        return this.sysConf;
    }

    protected void setModel(IEditorInput input) {
        if (input instanceof PersistableUntypedEditorInput) {
            PersistableUntypedEditorInput untypedInput = (PersistableUntypedEditorInput)input;
            Object content = untypedInput.getContent();
            if (content instanceof SystemConfiguration) {
                this.sysConf = (SystemConfiguration)content;
                if (input.getName() != null) {
                    this.setPartName(input.getName());
                }
            }
            super.setModel((IEditorInput)untypedInput);
        }
    }

    public AutomationSystem getSystem() {
        return (AutomationSystem)this.sysConf.eContainer();
    }

    public void doSave(IProgressMonitor monitor) {
        SystemManager.INSTANCE.saveSystem(this.getSystem());
        this.getCommandStack().markSaveLocation();
        this.firePropertyChange(257);
    }

    protected FlyoutPaletteComposite.FlyoutPreferences getPalettePreferences() {
        return SystemConfPaletteFactory.createPalettePreferences();
    }

    protected PaletteRoot getPaletteRoot() {
        if (this.getModel() != null && this.getSystem() != null) {
            return SystemConfPaletteFactory.createPalette(this.getSystem());
        }
        return new PaletteRoot();
    }

    public void selectDevice(Device refDev) {
        EditPart editPart = (EditPart)this.getViewer().getEditPartRegistry().get(refDev);
        this.getViewer().select(editPart);
        this.getViewer().reveal(editPart);
    }

    public void doSaveAs() {
    }
}

