/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.monitoring;

import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.monitoring.communication.TCPCommunicationObject;
import org.eclipse.fordiac.ide.monitoring.preferences.PreferenceConstants;
import org.eclipse.fordiac.ide.systemmanagement.Activator;

class DevicePolling
implements Runnable {
    private final AutomationSystem system;
    private final Device device;
    private final TCPCommunicationObject commObj;
    private final Thread thread;
    private boolean running = true;

    public DevicePolling(AutomationSystem system, Device device, TCPCommunicationObject commObj) {
        this.system = system;
        this.device = device;
        this.commObj = commObj;
        this.thread = new Thread(this);
    }

    public Thread getThread() {
        return this.thread;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    @Override
    public void run() {
        if (this.commObj != null) {
            int pollingIntervall = PreferenceConstants.getPollingInterval();
            while (this.running) {
                try {
                    Thread.sleep(pollingIntervall);
                }
                catch (InterruptedException e) {
                    Activator.getDefault().logError(e.getMessage(), (Exception)e);
                }
                if (this.commObj.isConnected()) {
                    this.commObj.sendReq(this.system, this.device);
                    this.commObj.queryBreakpoints(this.system, this.device);
                    continue;
                }
                this.running = false;
            }
        }
    }
}

