/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.Palette.AdapterTypePaletteEntry;
import org.eclipse.fordiac.ide.model.data.BaseType1;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterConnection;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFB;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFBType;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.Annotation;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableObject;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.DataConnection;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.ECC;
import org.eclipse.fordiac.ide.model.libraryElement.ECState;
import org.eclipse.fordiac.ide.model.libraryElement.ECTransition;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.EventConnection;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.I4DIACElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Mapping;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.Segment;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.SystemConfiguration;
import org.eclipse.fordiac.ide.model.libraryElement.TypedConfigureableObject;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

public enum Annotations {
    GEN;


    public InterfaceList getInterfaceList(AdapterType at) {
        return at.getAdapterFBType().getInterfaceList();
    }

    public AdapterFBType getPlugType(AdapterType adapterType) {
        AdapterFBType temp = (AdapterFBType)EcoreUtil.copy((EObject)adapterType.getAdapterFBType());
        ArrayList<Event> inputEvents = new ArrayList<Event>((Collection<Event>)temp.getInterfaceList().getEventOutputs());
        for (Event event : inputEvents) {
            event.setIsInput(true);
        }
        ArrayList<Event> outputEvents = new ArrayList<Event>((Collection<Event>)temp.getInterfaceList().getEventInputs());
        for (Event event : outputEvents) {
            event.setIsInput(false);
        }
        ArrayList<VarDeclaration> inputVars = new ArrayList<VarDeclaration>((Collection<VarDeclaration>)temp.getInterfaceList().getOutputVars());
        for (VarDeclaration varDecl : inputVars) {
            varDecl.setIsInput(true);
        }
        ArrayList<VarDeclaration> outputVars = new ArrayList<VarDeclaration>((Collection<VarDeclaration>)temp.getInterfaceList().getInputVars());
        for (VarDeclaration varDecl : outputVars) {
            varDecl.setIsInput(false);
        }
        temp.getInterfaceList().getEventInputs().clear();
        temp.getInterfaceList().getEventOutputs().clear();
        temp.getInterfaceList().getInputVars().clear();
        temp.getInterfaceList().getOutputVars().clear();
        temp.getInterfaceList().getEventInputs().addAll(inputEvents);
        temp.getInterfaceList().getEventOutputs().addAll(outputEvents);
        temp.getInterfaceList().getInputVars().addAll(inputVars);
        temp.getInterfaceList().getOutputVars().addAll(outputVars);
        return temp;
    }

    public AdapterFBType getSocketType(AdapterType at) {
        return (AdapterFBType)EcoreUtil.copy((EObject)at.getAdapterFBType());
    }

    public AutomationSystem getAutomationSystem(Application a) {
        return (AutomationSystem)a.eContainer();
    }

    public FBNetworkElement getSourceElement(Connection c) {
        return c.getSource() != null ? c.getSource().getFBNetworkElement() : null;
    }

    public FBNetworkElement getDestinationElement(Connection c) {
        return c.getDestination() != null ? c.getDestination().getFBNetworkElement() : null;
    }

    public boolean isResourceConnection(Connection c) {
        return c.getSourceElement() != null && c.getSourceElement().getFbNetwork() != null ? c.getSourceElement().getFbNetwork().eContainer() instanceof Resource : false;
    }

    public FBNetwork getFBNetwork(Connection c) {
        return (FBNetwork)c.eContainer();
    }

    public void checkifConnectionBroken(Connection c) {
        if (!c.isResourceConnection()) {
            Resource sourceRes = c.getSourceElement() != null ? c.getSourceElement().getResource() : null;
            Resource destinationRes = c.getDestinationElement() != null ? c.getDestinationElement().getResource() : null;
            c.setBrokenConnection(sourceRes != null && !sourceRes.equals(destinationRes) || destinationRes != null && !destinationRes.equals(sourceRes));
        }
    }

    public AutomationSystem getAutomationSystem(Device d) {
        return d.getSystemConfiguration().getAutomationSystem();
    }

    public SystemConfiguration getSystemConfiguration(Device d) {
        return (SystemConfiguration)d.eContainer();
    }

    public Resource getResourceNamed(Device d, String name) {
        for (Resource res : d.getResource()) {
            if (!res.getName().equals(name)) continue;
            return res;
        }
        return null;
    }

    public boolean isStartState(ECState ecs) {
        if (ecs.eContainer() != null) {
            return ecs.equals(((ECC)ecs.eContainer()).getStart());
        }
        return false;
    }

    public String getConditionText(ECTransition ect) {
        String retVal = new String();
        Event event = ect.getConditionEvent();
        String expression = ect.getConditionExpression();
        if (event != null) {
            retVal = event.getName();
        }
        if (expression != null) {
            if (expression.equals("1")) {
                retVal = expression;
            } else if (!expression.equals("")) {
                retVal = String.valueOf(retVal) + "[" + expression + "]";
            }
        }
        return retVal;
    }

    public ECC getECC(ECTransition ecTransition) {
        return (ECC)ecTransition.eContainer();
    }

    public boolean isResourceFB(FB fb) {
        if (fb.getFbNetwork().eContainer() instanceof Resource) {
            return fb.getMapping() == null || fb.equals(fb.getMapping().getFrom());
        }
        return false;
    }

    public boolean isResourceTypeFB(FB fb) {
        return false;
    }

    public Resource getResource(FBNetworkElement fbne) {
        if (fbne.getFbNetwork() != null && fbne.getFbNetwork().eContainer() instanceof Resource) {
            return (Resource)fbne.getFbNetwork().eContainer();
        }
        if (fbne.isMapped()) {
            return fbne.getMapping().getTo().getResource();
        }
        return null;
    }

    public IInterfaceElement getInterfaceElement(FBNetworkElement fbne, String name) {
        if (fbne.getInterface() != null) {
            return fbne.getInterface().getInterfaceElement(name);
        }
        return null;
    }

    public FBNetworkElement getOpposite(FBNetworkElement fbne) {
        if (fbne.isMapped()) {
            return fbne == fbne.getMapping().getFrom() ? fbne.getMapping().getTo() : fbne.getMapping().getFrom();
        }
        return null;
    }

    public FBNetwork getFbNetwork(FBNetworkElement fbne) {
        return fbne.eContainer() instanceof FBNetwork ? (FBNetwork)fbne.eContainer() : null;
    }

    public void checkConnections(FBNetworkElement fbne) {
        for (IInterfaceElement element : fbne.getInterface().getAllInterfaceElements()) {
            for (Connection conn : element.getInputConnections()) {
                conn.checkIfConnectionBroken();
            }
            for (Connection conn : element.getOutputConnections()) {
                conn.checkIfConnectionBroken();
            }
        }
    }

    public boolean isMapped(FBNetworkElement fbne) {
        return fbne.getMapping() != null;
    }

    public EList<IInterfaceElement> getAllInterfaceElements(InterfaceList il) {
        BasicEList retVal = new BasicEList();
        retVal.addAll(il.getEventInputs());
        retVal.addAll(il.getEventOutputs());
        retVal.addAll(il.getInputVars());
        retVal.addAll(il.getOutputVars());
        retVal.addAll(il.getPlugs());
        retVal.addAll(il.getSockets());
        return retVal;
    }

    public Event getEvent(InterfaceList il, String name) {
        for (Event event : il.getEventInputs()) {
            if (!event.getName().equals(name)) continue;
            return event;
        }
        for (Event event : il.getEventOutputs()) {
            if (!event.getName().equals(name)) continue;
            return event;
        }
        return null;
    }

    public VarDeclaration getVariable(InterfaceList il, String name) {
        for (VarDeclaration var : il.getInputVars()) {
            if (!var.getName().equals(name)) continue;
            return var;
        }
        for (VarDeclaration var : il.getOutputVars()) {
            if (!var.getName().equals(name)) continue;
            return var;
        }
        return null;
    }

    public IInterfaceElement getInterfaceElement(InterfaceList il, String name) {
        IInterfaceElement element = il.getEvent(name);
        if (element == null) {
            element = il.getVariable(name);
        }
        if (element == null) {
            element = il.getAdapter(name);
        }
        return element;
    }

    public FBNetworkElement getFBNetworkElement(InterfaceList il) {
        return il.eContainer() instanceof FBNetworkElement ? (FBNetworkElement)il.eContainer() : null;
    }

    public AdapterDeclaration getAdapter(InterfaceList il, String name) {
        for (AdapterDeclaration adapt : il.getPlugs()) {
            if (!adapt.getName().equals(name)) continue;
            return adapt;
        }
        for (AdapterDeclaration adapt : il.getSockets()) {
            if (!adapt.getName().equals(name)) continue;
            return adapt;
        }
        return null;
    }

    public AutomationSystem getAutomationSystem(Mapping m) {
        return m.eContainer() != null ? (AutomationSystem)m.eContainer() : null;
    }

    public AutomationSystem getAutomationSystem(Resource r) {
        AutomationSystem system = null;
        if (r.getDevice() != null) {
            system = r.getDevice().getAutomationSystem();
        }
        return system;
    }

    public void addConnection(FBNetwork fbn, Connection connection) {
        if (connection instanceof EventConnection) {
            fbn.getEventConnections().add((Object)((EventConnection)connection));
        }
        if (connection instanceof DataConnection) {
            fbn.getDataConnections().add((Object)((DataConnection)connection));
        }
        if (connection instanceof AdapterConnection) {
            fbn.getAdapterConnections().add((Object)((AdapterConnection)connection));
        }
    }

    public void removeConnection(FBNetwork fbn, Connection connection) {
        if (connection instanceof EventConnection) {
            fbn.getEventConnections().remove((Object)connection);
        }
        if (connection instanceof DataConnection) {
            fbn.getDataConnections().remove((Object)connection);
        }
        if (connection instanceof AdapterConnection) {
            fbn.getAdapterConnections().remove((Object)connection);
        }
    }

    public boolean isApplicationNetwork(FBNetwork fbn) {
        return fbn.eContainer() instanceof Application;
    }

    public boolean isSubApplicationNetwork(FBNetwork fbn) {
        return fbn.eContainer() instanceof SubApp;
    }

    public boolean isResourceNetwork(FBNetwork fbn) {
        return fbn.eContainer() instanceof Resource;
    }

    public boolean isCFBTypeNetwork(FBNetwork fbn) {
        return fbn.eContainer() instanceof CompositeFBType;
    }

    public AutomationSystem getAutomationSystem(FBNetwork fbn) {
        if (fbn.isApplicationNetwork() || fbn.isSubApplicationNetwork()) {
            return fbn.getApplication().getAutomationSystem();
        }
        if (fbn.isResourceNetwork()) {
            return ((Resource)fbn.eContainer()).getAutomationSystem();
        }
        if (fbn.isCFBTypeNetwork()) {
            return ((CompositeFBType)fbn.eContainer()).getPaletteEntry().getGroup().getPallete().getAutomationSystem();
        }
        return null;
    }

    public Application getApplication(FBNetwork fbn) {
        if (fbn.isApplicationNetwork()) {
            return (Application)fbn.eContainer();
        }
        if (fbn.isSubApplicationNetwork() && ((SubApp)fbn.eContainer()).getFbNetwork() != null) {
            return ((SubApp)fbn.eContainer()).getFbNetwork().getApplication();
        }
        return null;
    }

    public FB getFBNamed(FBNetwork fbn, String name) {
        for (FBNetworkElement element : fbn.getNetworkElements()) {
            if (!(element instanceof FB) || !element.getName().equals(name)) continue;
            return (FB)element;
        }
        return null;
    }

    public SubApp getSubAppNamed(FBNetwork fbn, String name) {
        for (FBNetworkElement element : fbn.getNetworkElements()) {
            if (!(element instanceof SubApp)) continue;
            if (element.getName().equals(name)) {
                return (SubApp)element;
            }
            SubApp retVal = ((SubApp)element).getSubAppNetwork().getSubAppNamed(name);
            if (retVal == null) continue;
            return retVal;
        }
        return null;
    }

    public FBNetworkElement getElementNamed(FBNetwork fbn, String name) {
        for (FBNetworkElement element : fbn.getNetworkElements()) {
            if (!element.getName().equals(name)) continue;
            return element;
        }
        return null;
    }

    public Device getDeviceNamed(AutomationSystem as, String name) {
        if (as.getSystemConfiguration() != null) {
            return as.getSystemConfiguration().getDeviceNamed(name);
        }
        return null;
    }

    public Application getApplicationNamed(AutomationSystem as, String name) {
        for (Application app : as.getApplication()) {
            if (!app.getName().equals(name)) continue;
            return app;
        }
        return null;
    }

    public boolean isArray(VarDeclaration vd) {
        return vd.getArraySize() > 0;
    }

    public void setAttribute(ConfigurableObject object, String attributeName, String type, String value, String comment) {
        Attribute attribute = this.getAttribute(object, attributeName);
        if (attribute == null) {
            attribute = LibraryElementFactory.eINSTANCE.createAttribute();
            attribute.setName(attributeName);
            attribute.setValue(value);
            attribute.setType(BaseType1.getByName(type));
            attribute.setComment(comment);
            object.getAttributes().add((Object)attribute);
        } else {
            attribute.setValue(value);
        }
    }

    public String getAttributeValue(ConfigurableObject object, String attributeName) {
        Attribute a = this.getAttribute(object, attributeName);
        if (a != null) {
            return a.getValue();
        }
        return null;
    }

    public Attribute getAttribute(ConfigurableObject object, String attributeName) {
        if (attributeName == null) {
            return null;
        }
        for (Attribute attribute : object.getAttributes()) {
            if (!attribute.getName().equalsIgnoreCase(attributeName)) continue;
            return attribute;
        }
        return null;
    }

    public VarDeclaration getDataSource(DataConnection dc) {
        return (VarDeclaration)dc.getSource();
    }

    public VarDeclaration getDataDestination(DataConnection dc) {
        return (VarDeclaration)dc.getDestination();
    }

    public Event getEventSource(EventConnection ec) {
        return (Event)ec.getSource();
    }

    public Event getEventDestination(EventConnection ec) {
        return (Event)ec.getDestination();
    }

    public AdapterDeclaration getAdapterSource(AdapterConnection ac) {
        return (AdapterDeclaration)ac.getSource();
    }

    public AdapterDeclaration getAdapterDestination(AdapterConnection ac) {
        return (AdapterDeclaration)ac.getDestination();
    }

    public FBNetworkElement getFBNetworkElement(IInterfaceElement iie) {
        return iie.eContainer() instanceof InterfaceList ? ((InterfaceList)iie.eContainer()).getFBNetworkElement() : null;
    }

    public VarDeclaration getVarDeclaration(Value v) {
        return (VarDeclaration)v.eContainer();
    }

    public AutomationSystem getAutomationSystem(SystemConfiguration sc) {
        return (AutomationSystem)sc.eContainer();
    }

    public Segment getSegmentNamed(SystemConfiguration sc, String name) {
        for (Segment segment : sc.getSegments()) {
            if (!segment.getName().equals(name)) continue;
            return segment;
        }
        return null;
    }

    public Device getDeviceNamed(SystemConfiguration sc, String name) {
        for (Device device : sc.getDevices()) {
            if (!device.getName().equals(name)) continue;
            return device;
        }
        return null;
    }

    public boolean isResourceTypeFB() {
        return true;
    }

    public Annotation createAnnotation(I4DIACElement i4e, String name) {
        Annotation annotation = LibraryElementFactory.eINSTANCE.createAnnotation();
        annotation.setName(name);
        i4e.getAnnotations().add((Object)annotation);
        return annotation;
    }

    public void removeAnnotation(I4DIACElement i4e, Annotation a) {
        i4e.getAnnotations().remove((Object)a);
    }

    public String getTypeName(TypedConfigureableObject tco) {
        return tco.getPaletteEntry().getLabel();
    }

    public LibraryElement getType(TypedConfigureableObject tco) {
        if (tco.getPaletteEntry() != null) {
            return tco.getPaletteEntry().getType();
        }
        return null;
    }

    public boolean isSocket(AdapterFB afb) {
        return !afb.isPlug();
    }

    public FBType getType(AdapterFB afb) {
        AdapterFBType retVal = null;
        if (afb.getPaletteEntry() != null && afb.getPaletteEntry() instanceof AdapterTypePaletteEntry && afb.getAdapterDecl() != null) {
            retVal = afb.isPlug() ? ((AdapterTypePaletteEntry)afb.getPaletteEntry()).getAdapterType().getPlugType() : ((AdapterTypePaletteEntry)afb.getPaletteEntry()).getAdapterType().getSocketType();
        }
        return retVal;
    }

    public boolean isPlug(AdapterFB afb) {
        return !afb.getAdapterDecl().isIsInput();
    }
}

