/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.forte_lua;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.fordiac.ide.export.forte_lua.filter.AdapterFilter;
import org.eclipse.fordiac.ide.export.forte_lua.filter.BasicFBFilter;
import org.eclipse.fordiac.ide.export.forte_lua.filter.CompositeFBFilter;
import org.eclipse.fordiac.ide.export.utils.ExportException;
import org.eclipse.fordiac.ide.export.utils.IExportFilter;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.xtext.xbase.lib.Extension;

public class ForteLuaExportFilter
implements IExportFilter {
    @Extension
    private BasicFBFilter basicFBFilter = new BasicFBFilter();
    @Extension
    private AdapterFilter adapterFilter = new AdapterFilter();
    @Extension
    private CompositeFBFilter compositeFBFilter = new CompositeFBFilter();

    public void export(IFile typeFile, String destination, boolean forceOverwrite) throws ExportException {
        throw new UnsupportedOperationException("Require a library element to work on");
    }

    public void export(IFile typeFile, String destination, boolean forceOverwrite, LibraryElement type) throws ExportException {
        boolean _matched = false;
        if (type instanceof BasicFBType) {
            _matched = true;
            System.out.println(this.basicFBFilter.lua((BasicFBType)type));
        }
        if (!_matched && type instanceof CompositeFBType) {
            _matched = true;
            System.out.println(this.compositeFBFilter.lua((CompositeFBType)type));
        }
        if (!_matched && type instanceof AdapterType) {
            _matched = true;
            System.out.println(this.adapterFilter.lua((AdapterType)type));
        }
        if (!_matched) {
            String _name = type.eClass().getName();
            String _plus = "Unknown library element type " + _name;
            throw new UnsupportedOperationException(_plus);
        }
    }

    public String createLUA(LibraryElement type) {
        boolean _matched = false;
        if (type instanceof BasicFBType) {
            _matched = true;
            return String.valueOf(this.basicFBFilter.lua((BasicFBType)type));
        }
        if (!_matched && type instanceof CompositeFBType) {
            _matched = true;
            return String.valueOf(this.compositeFBFilter.lua((CompositeFBType)type));
        }
        if (!_matched && type instanceof AdapterType) {
            _matched = true;
            return String.valueOf(this.adapterFilter.lua((AdapterType)type));
        }
        String _name = type.eClass().getName();
        String _plus = "Unknown library element type " + _name;
        throw new UnsupportedOperationException(_plus);
    }

    public String getExportFilterName() {
        return "FORTE Lua";
    }

    public String getExportFilterDescription() {
        return "FORTE Lua Export";
    }

    public List<String> getWarnings() {
        return Collections.emptyList();
    }

    public List<String> getErrors() {
        return this.basicFBFilter.getErrors();
    }

    public List<String> getInfos() {
        return Collections.emptyList();
    }
}

