/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.forte_lua.filter;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.export.forte_lua.filter.LuaConstants;
import org.eclipse.fordiac.ide.export.forte_lua.filter.LuaUtils;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.STAlgorithm;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.structuredtext.parser.antlr.StructuredTextParser;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.AdapterVariable;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.ArrayVariable;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.AssignmentStatement;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.BinaryExpression;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.BinaryOperator;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.BoolLiteral;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.Call;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.CaseClause;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.CaseStatement;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.Constant;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.ContinueStatement;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.ElseClause;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.ElseIfClause;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.ExitStatement;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.Expression;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.ForStatement;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.IfStatement;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.IntLiteral;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.LocalVariable;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.PrimaryVariable;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.RealLiteral;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.RepeatStatement;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.ReturnStatement;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.Statement;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.StatementList;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.StringLiteral;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.StructuredTextAlgorithm;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.UnaryExpression;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.UnaryOperator;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.WhileStatement;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parser.IParser;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.LazyStringInputStream;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Pure;

public class STAlgorithmFilter {
    private static final URI SYNTHETIC_FB_URI = URI.createFileURI((String)"__synthetic.xtextfbt");
    private static final URI SYNTHETIC_ST_URI = URI.createFileURI((String)"__synthetic.st");
    private static final IResourceServiceProvider SERVICE_PRIVIDER = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(SYNTHETIC_ST_URI);
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private List<String> errors = new ArrayList<String>();

    public String lua(STAlgorithm alg) {
        IParseResult parseResult;
        block3: {
            try {
                ResourceSet resourceSet = (ResourceSet)SERVICE_PRIVIDER.get(ResourceSet.class);
                Resource fbResource = resourceSet.createResource(SYNTHETIC_FB_URI);
                EObject fbCopy = EcoreUtil.copy((EObject)EcoreUtil.getRootContainer((EObject)alg));
                fbResource.getContents().add((Object)fbCopy);
                Resource _createResource = resourceSet.createResource(SYNTHETIC_ST_URI);
                XtextResource resource = (XtextResource)_createResource;
                String _text = alg.getText();
                LazyStringInputStream _lazyStringInputStream = new LazyStringInputStream(_text);
                Pair _mappedTo = Pair.of((Object)XtextResource.OPTION_RESOLVE_ALL, (Object)Boolean.TRUE);
                resource.load((InputStream)_lazyStringInputStream, Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{_mappedTo})));
                parseResult = resource.getParseResult();
                boolean _hasSyntaxErrors = parseResult.hasSyntaxErrors();
                if (!_hasSyntaxErrors) break block3;
                Functions.Function1 _function = it -> it.getSyntaxErrorMessage().getMessage();
                Iterables.addAll(this.errors, (Iterable)IterableExtensions.map((Iterable)parseResult.getSyntaxErrors(), (Functions.Function1)_function));
                return null;
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
        EObject _rootASTElement = parseResult.getRootASTElement();
        StructuredTextAlgorithm stalg = (StructuredTextAlgorithm)_rootASTElement;
        Set usedAdapterVariables = IteratorExtensions.toSet((Iterator)Iterators.filter((Iterator)EcoreUtil.getAllProperContents((EObject)stalg, (boolean)true), AdapterVariable.class));
        Functions.Function1 _function_1 = it -> it.getVar();
        Functions.Function1 _function_2 = it -> {
            EObject _rootContainer = EcoreUtil.getRootContainer((EObject)it);
            return _rootContainer instanceof FBType;
        };
        Set usedFBVariables = IteratorExtensions.toSet((Iterator)IteratorExtensions.filter((Iterator)IteratorExtensions.map((Iterator)Iterators.filter((Iterator)EcoreUtil.getAllProperContents((EObject)stalg, (boolean)true), PrimaryVariable.class), (Functions.Function1)_function_1), (Functions.Function1)_function_2));
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _luaFBVariablesPrefix = LuaConstants.luaFBVariablesPrefix(usedFBVariables);
        _builder.append((Object)_luaFBVariablesPrefix);
        _builder.newLineIfNotEmpty();
        CharSequence _luaFBAdapterVariablesPrefix = LuaConstants.luaFBAdapterVariablesPrefix(usedAdapterVariables);
        _builder.append((Object)_luaFBAdapterVariablesPrefix);
        _builder.newLineIfNotEmpty();
        CharSequence _luaStructuredTextAlgorithm = this.luaStructuredTextAlgorithm(stalg);
        _builder.append((Object)_luaStructuredTextAlgorithm);
        _builder.newLineIfNotEmpty();
        CharSequence _luaFBVariablesSuffix = LuaConstants.luaFBVariablesSuffix(usedFBVariables);
        _builder.append((Object)_luaFBVariablesSuffix);
        _builder.newLineIfNotEmpty();
        CharSequence _luaFBAdapterVariablesSuffix = LuaConstants.luaFBAdapterVariablesSuffix(usedAdapterVariables);
        _builder.append((Object)_luaFBAdapterVariablesSuffix);
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public CharSequence lua(BasicFBType fb, String expression) {
        IParseResult parseResult;
        block3: {
            try {
                ResourceSet resourceSet = (ResourceSet)SERVICE_PRIVIDER.get(ResourceSet.class);
                Resource fbResource = resourceSet.createResource(SYNTHETIC_FB_URI);
                BasicFBType fbCopy = (BasicFBType)EcoreUtil.copy((EObject)fb);
                fbResource.getContents().add((Object)fbCopy);
                Resource _createResource = resourceSet.createResource(SYNTHETIC_ST_URI);
                XtextResource resource = (XtextResource)_createResource;
                IParser _parser = resource.getParser();
                StructuredTextParser parser = (StructuredTextParser)_parser;
                LazyStringInputStream _lazyStringInputStream = new LazyStringInputStream(expression);
                ParserRule _expressionRule = parser.getGrammarAccess().getExpressionRule();
                Pair _mappedTo = Pair.of((Object)"PARSER_RULE", (Object)_expressionRule);
                resource.load((InputStream)_lazyStringInputStream, Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{_mappedTo})));
                parseResult = resource.getParseResult();
                boolean _hasSyntaxErrors = parseResult.hasSyntaxErrors();
                if (!_hasSyntaxErrors) break block3;
                Functions.Function1 _function = it -> it.getSyntaxErrorMessage().getMessage();
                Iterables.addAll(this.errors, (Iterable)IterableExtensions.map((Iterable)parseResult.getSyntaxErrors(), (Functions.Function1)_function));
                return null;
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
        EObject _rootASTElement = parseResult.getRootASTElement();
        Expression expr = (Expression)_rootASTElement;
        return this.luaExpression(expr);
    }

    private CharSequence luaStructuredTextAlgorithm(StructuredTextAlgorithm alg) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _luaLocalVariables = this.luaLocalVariables((List<VarDeclaration>)alg.getLocalVariables());
        _builder.append((Object)_luaLocalVariables);
        _builder.newLineIfNotEmpty();
        CharSequence _luaStatementList = this.luaStatementList(alg.getStatements());
        _builder.append((Object)_luaStatementList);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence luaLocalVariables(List<VarDeclaration> variables) {
        StringConcatenation _builder = new StringConcatenation();
        for (VarDeclaration variable : variables) {
            _builder.append("local ");
            CharSequence _luaVariable = LuaConstants.luaVariable(variable);
            _builder.append((Object)_luaVariable);
            CharSequence _luaLocalVariableInitializer = this.luaLocalVariableInitializer(variable);
            _builder.append((Object)_luaLocalVariableInitializer);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private CharSequence luaLocalVariableInitializer(VarDeclaration variable) {
        String _switchResult = null;
        boolean _matched = false;
        if (variable instanceof LocalVariable) {
            boolean _notEquals;
            Constant _initialValue = ((LocalVariable)variable).getInitialValue();
            boolean bl = _notEquals = !Objects.equal((Object)_initialValue, null);
            if (_notEquals) {
                _matched = true;
                StringConcatenation _builder = new StringConcatenation();
                _builder.append(" ");
                _builder.append("= variable.initialValue.luaExpression");
                _switchResult = _builder;
            }
        }
        if (!_matched) {
            _switchResult = "";
        }
        return _switchResult;
    }

    private CharSequence luaStatementList(StatementList list) {
        StringConcatenation _builder = new StringConcatenation();
        EList _statements = list.getStatements();
        for (Statement stmt : _statements) {
            CharSequence _luaStatement = this.luaStatement(stmt);
            _builder.append((Object)_luaStatement);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private CharSequence _luaStatement(Statement stmt) {
        EClass _eClass = stmt.eClass();
        String _plus = _eClass + " not supported";
        throw new UnsupportedOperationException(_plus);
    }

    private CharSequence _luaStatement(AssignmentStatement stmt) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _luaExpression = this.luaExpression((Expression)stmt.getVariable());
        _builder.append((Object)_luaExpression);
        _builder.append(" = ");
        CharSequence _luaExpression_1 = this.luaExpression(stmt.getExpression());
        _builder.append((Object)_luaExpression_1);
        return _builder;
    }

    private CharSequence _luaStatement(Call stmt) {
        return this.luaExpression((Expression)stmt);
    }

    private CharSequence _luaStatement(ReturnStatement stmt) {
        return "return";
    }

    private CharSequence _luaStatement(IfStatement stmt) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("if ");
        CharSequence _luaExpression = this.luaExpression(stmt.getExpression());
        _builder.append((Object)_luaExpression);
        _builder.append(" then");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        CharSequence _luaStatementList = this.luaStatementList(stmt.getStatments());
        _builder.append((Object)_luaStatementList, "  ");
        _builder.newLineIfNotEmpty();
        EList _elseif = stmt.getElseif();
        for (ElseIfClause elseif : _elseif) {
            _builder.append("elseif ");
            CharSequence _luaExpression_1 = this.luaExpression(elseif.getExpression());
            _builder.append((Object)_luaExpression_1);
            _builder.append(" then");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            CharSequence _luaStatementList_1 = this.luaStatementList(elseif.getStatements());
            _builder.append((Object)_luaStatementList_1, "  ");
            _builder.newLineIfNotEmpty();
        }
        ElseClause _else = stmt.getElse();
        boolean bl = _notEquals = !Objects.equal((Object)_else, null);
        if (_notEquals) {
            _builder.append("else");
            _builder.newLine();
            _builder.append("  ");
            CharSequence _luaStatementList_2 = this.luaStatementList(stmt.getElse().getStatements());
            _builder.append((Object)_luaStatementList_2, "  ");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("end");
        return _builder;
    }

    private CharSequence _luaStatement(CaseStatement stmt) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("local function case(val)");
        _builder.newLine();
        _builder.append("  ");
        EList _case = stmt.getCase();
        boolean _hasElements = false;
        for (CaseClause clause : _case) {
            if (!_hasElements) {
                _hasElements = true;
                _builder.append("if ", "  ");
            } else {
                _builder.appendImmediate((Object)"\nelseif ", "  ");
            }
            CharSequence _luaCaseClause = this.luaCaseClause(clause);
            _builder.append((Object)_luaCaseClause, "  ");
        }
        _builder.newLineIfNotEmpty();
        ElseClause _else = stmt.getElse();
        boolean bl = _notEquals = !Objects.equal((Object)_else, null);
        if (_notEquals) {
            _builder.append("  ");
            _builder.append("else");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("  ");
            CharSequence _luaStatementList = this.luaStatementList(stmt.getElse().getStatements());
            _builder.append((Object)_luaStatementList, "    ");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("  ");
        _builder.append("end");
        _builder.newLine();
        _builder.append("end");
        _builder.newLine();
        _builder.append("case(");
        CharSequence _luaExpression = this.luaExpression(stmt.getExpression());
        _builder.append((Object)_luaExpression);
        _builder.append(")");
        return _builder;
    }

    private CharSequence luaCaseClause(CaseClause clause) {
        StringConcatenation _builder = new StringConcatenation();
        EList _case = clause.getCase();
        boolean _hasElements = false;
        for (Constant value : _case) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)" or ", "");
            }
            _builder.append("val == ");
            CharSequence _luaExpression = this.luaExpression((Expression)value);
            _builder.append((Object)_luaExpression);
        }
        _builder.append(" then");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        CharSequence _luaStatementList = this.luaStatementList(clause.getStatements());
        _builder.append((Object)_luaStatementList, "  ");
        return _builder;
    }

    private CharSequence _luaStatement(ExitStatement stmt) {
        return "break";
    }

    private CharSequence _luaStatement(ContinueStatement stmt) {
        return "continue";
    }

    private CharSequence _luaStatement(ForStatement stmt) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("for ");
        CharSequence _luaExpression = this.luaExpression((Expression)stmt.getVariable());
        _builder.append((Object)_luaExpression);
        _builder.append(" = ");
        CharSequence _luaExpression_1 = this.luaExpression(stmt.getFrom());
        _builder.append((Object)_luaExpression_1);
        _builder.append(", ");
        CharSequence _luaExpression_2 = this.luaExpression(stmt.getTo());
        _builder.append((Object)_luaExpression_2);
        Expression _by = stmt.getBy();
        boolean bl = _tripleNotEquals = _by != null;
        if (_tripleNotEquals) {
            _builder.append(", ");
            CharSequence _luaExpression_3 = this.luaExpression(stmt.getBy());
            _builder.append((Object)_luaExpression_3);
        }
        _builder.append(" do");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        CharSequence _luaStatementList = this.luaStatementList(stmt.getStatements());
        _builder.append((Object)_luaStatementList, "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("end");
        return _builder;
    }

    private CharSequence _luaStatement(WhileStatement stmt) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("while ");
        CharSequence _luaExpression = this.luaExpression(stmt.getExpression());
        _builder.append((Object)_luaExpression);
        _builder.append(" do");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        CharSequence _luaStatementList = this.luaStatementList(stmt.getStatements());
        _builder.append((Object)_luaStatementList, "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("end");
        return _builder;
    }

    private CharSequence _luaStatement(RepeatStatement stmt) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("repeat");
        _builder.newLine();
        _builder.append("  ");
        CharSequence _luaStatementList = this.luaStatementList(stmt.getStatements());
        _builder.append((Object)_luaStatementList, "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("until ");
        CharSequence _luaExpression = this.luaExpression(stmt.getExpression());
        _builder.append((Object)_luaExpression);
        return _builder;
    }

    private CharSequence _luaExpression(Expression expr) {
        EClass _eClass = expr.eClass();
        String _plus = _eClass + " not supported";
        throw new UnsupportedOperationException(_plus);
    }

    private CharSequence _luaExpression(BinaryExpression expr) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("(");
        CharSequence _luaExpression = this.luaExpression(expr.getLeft());
        _builder.append((Object)_luaExpression);
        _builder.append(" ");
        String _luaBinaryOperator = this.luaBinaryOperator(expr.getOperator());
        _builder.append(_luaBinaryOperator);
        _builder.append(" ");
        CharSequence _luaExpression_1 = this.luaExpression(expr.getRight());
        _builder.append((Object)_luaExpression_1);
        _builder.append(")");
        return _builder;
    }

    private String luaBinaryOperator(BinaryOperator op) {
        String _switchResult = null;
        if (op != null) {
            switch (op) {
                case OR: {
                    _switchResult = "or";
                    break;
                }
                case XOR: {
                    _switchResult = "~";
                    break;
                }
                case AND: {
                    _switchResult = "and";
                    break;
                }
                case EQ: {
                    _switchResult = "==";
                    break;
                }
                case NE: {
                    _switchResult = "~=";
                    break;
                }
                case LT: {
                    _switchResult = "<";
                    break;
                }
                case LE: {
                    _switchResult = "<=";
                    break;
                }
                case GT: {
                    _switchResult = ">";
                    break;
                }
                case GE: {
                    _switchResult = ">=";
                    break;
                }
                case ADD: {
                    _switchResult = "+";
                    break;
                }
                case SUB: {
                    _switchResult = "-";
                    break;
                }
                case MUL: {
                    _switchResult = "*";
                    break;
                }
                case DIV: {
                    _switchResult = "/";
                    break;
                }
                case MOD: {
                    _switchResult = "%";
                    break;
                }
                case POWER: {
                    _switchResult = "^";
                    break;
                }
            }
        }
        return _switchResult;
    }

    private CharSequence _luaExpression(UnaryExpression expr) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("(");
        String _luaUnaryOperator = this.luaUnaryOperator(expr.getOperator());
        _builder.append(_luaUnaryOperator);
        _builder.append(" ");
        CharSequence _luaExpression = this.luaExpression(expr.getExpression());
        _builder.append((Object)_luaExpression);
        _builder.append(")");
        return _builder;
    }

    private String luaUnaryOperator(UnaryOperator op) {
        String _switchResult = null;
        if (op != null) {
            switch (op) {
                case MINUS: {
                    _switchResult = "-";
                    break;
                }
                case PLUS: {
                    _switchResult = "+";
                    break;
                }
                case NOT: {
                    _switchResult = "not";
                    break;
                }
            }
        }
        return _switchResult;
    }

    private CharSequence _luaExpression(BoolLiteral expr) {
        return Boolean.toString(expr.isValue());
    }

    private CharSequence _luaExpression(IntLiteral expr) {
        return Long.toString(expr.getValue());
    }

    private CharSequence _luaExpression(RealLiteral expr) {
        return Double.toString(expr.getValue());
    }

    private CharSequence _luaExpression(StringLiteral expr) {
        return LuaUtils.luaString(expr.getValue());
    }

    private CharSequence _luaExpression(ArrayVariable expr) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _luaExpression = this.luaExpression((Expression)expr.getArray());
        _builder.append((Object)_luaExpression);
        EList _index = expr.getIndex();
        boolean _hasElements = false;
        for (Expression index : _index) {
            if (!_hasElements) {
                _hasElements = true;
                _builder.append("[");
            } else {
                _builder.appendImmediate((Object)"][", "");
            }
            _builder.append("(");
            CharSequence _luaExpression_1 = this.luaExpression(index);
            _builder.append((Object)_luaExpression_1);
            _builder.append(") + 1");
        }
        if (_hasElements) {
            _builder.append("]");
        }
        return _builder;
    }

    private CharSequence _luaExpression(AdapterVariable expr) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _luaAdapterVariable = LuaConstants.luaAdapterVariable(expr.getVar().getName(), expr.getAdapter().getName());
        _builder.append((Object)_luaAdapterVariable);
        return _builder;
    }

    private CharSequence _luaExpression(PrimaryVariable expr) {
        return LuaConstants.luaVariable(expr.getVar());
    }

    private CharSequence luaStatement(Statement stmt) {
        if (stmt instanceof AssignmentStatement) {
            return this._luaStatement((AssignmentStatement)stmt);
        }
        if (stmt instanceof Call) {
            return this._luaStatement((Call)stmt);
        }
        if (stmt instanceof CaseStatement) {
            return this._luaStatement((CaseStatement)stmt);
        }
        if (stmt instanceof ContinueStatement) {
            return this._luaStatement((ContinueStatement)stmt);
        }
        if (stmt instanceof ExitStatement) {
            return this._luaStatement((ExitStatement)stmt);
        }
        if (stmt instanceof ForStatement) {
            return this._luaStatement((ForStatement)stmt);
        }
        if (stmt instanceof IfStatement) {
            return this._luaStatement((IfStatement)stmt);
        }
        if (stmt instanceof RepeatStatement) {
            return this._luaStatement((RepeatStatement)stmt);
        }
        if (stmt instanceof ReturnStatement) {
            return this._luaStatement((ReturnStatement)stmt);
        }
        if (stmt instanceof WhileStatement) {
            return this._luaStatement((WhileStatement)stmt);
        }
        if (stmt != null) {
            return this._luaStatement(stmt);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(stmt).toString());
    }

    private CharSequence luaExpression(Expression expr) {
        if (expr instanceof IntLiteral) {
            return this._luaExpression((IntLiteral)expr);
        }
        if (expr instanceof RealLiteral) {
            return this._luaExpression((RealLiteral)expr);
        }
        if (expr instanceof AdapterVariable) {
            return this._luaExpression((AdapterVariable)expr);
        }
        if (expr instanceof ArrayVariable) {
            return this._luaExpression((ArrayVariable)expr);
        }
        if (expr instanceof BoolLiteral) {
            return this._luaExpression((BoolLiteral)expr);
        }
        if (expr instanceof PrimaryVariable) {
            return this._luaExpression((PrimaryVariable)expr);
        }
        if (expr instanceof StringLiteral) {
            return this._luaExpression((StringLiteral)expr);
        }
        if (expr instanceof BinaryExpression) {
            return this._luaExpression((BinaryExpression)expr);
        }
        if (expr instanceof UnaryExpression) {
            return this._luaExpression((UnaryExpression)expr);
        }
        if (expr != null) {
            return this._luaExpression(expr);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(expr).toString());
    }

    @Pure
    public List<String> getErrors() {
        return this.errors;
    }
}

