/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ide.utils;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.ExtendedMessageFormat;
import org.apache.commons.lang3.text.FormatFactory;
import org.eclipse.epp.internal.logging.aeri.ide.l10n.LogMessages;
import org.eclipse.epp.internal.logging.aeri.ide.utils.ProjectsFormat;
import org.eclipse.epp.logging.aeri.core.ILink;
import org.eclipse.epp.logging.aeri.core.ILinkable;
import org.eclipse.epp.logging.aeri.core.util.Logs;

public class Formats {
    private static final CustomFormatFactory FACTORY = new CustomFormatFactory();
    private static final Map<String, CustomFormatFactory> REGISTRY = ImmutableMap.of((Object)"link", (Object)FACTORY, (Object)"links", (Object)FACTORY, (Object)"projects", (Object)FACTORY);

    public static String format(String pattern, Object ... args) {
        pattern = StringUtils.defaultString((String)pattern, (String)"null");
        try {
            return new ExtendedMessageFormat(pattern, REGISTRY).format((Object)args);
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.WARN_FORMATTING_FAILED, (Throwable)e, (Object[])new Object[]{pattern, args, e.getMessage()});
            return pattern;
        }
    }

    private static final class CustomFormatFactory
    implements FormatFactory {
        private CustomFormatFactory() {
        }

        public Format getFormat(String name, String arguments, Locale locale) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            List properties = Splitter.on((char)';').omitEmptyStrings().trimResults().splitToList((CharSequence)StringUtils.defaultString((String)arguments));
            for (String property : properties) {
                List split = Splitter.on((char)'=').omitEmptyStrings().trimResults().splitToList((CharSequence)property);
                builder.put((Object)((String)split.get(0)), (Object)(split.size() > 1 ? (String)split.get(1) : String.valueOf(true)));
            }
            ImmutableMap args = builder.build();
            switch (name) {
                case "link": {
                    return new LinkFormat((Map)args);
                }
                case "links": {
                    return new LinkCollectionFormat((Map)args);
                }
                case "projects": {
                    return new ProjectsFormat((Map<String, String>)args);
                }
            }
            return null;
        }
    }

    private static class LinkCollectionFormat
    extends Format {
        private final Map<String, String> args;

        private LinkCollectionFormat(Map<String, String> args) {
            this.args = args;
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            Collection list = null;
            Map map = null;
            if (obj instanceof Collection) {
                list = (Collection)obj;
                ImmutableMap.Builder b = ImmutableMap.builder();
                for (ILink link : list) {
                    b.put((Object)link.getRel(), (Object)link);
                }
                map = b.build();
            } else if (obj instanceof ILink) {
                ILink link = (ILink)obj;
                map = ImmutableMap.of((Object)link.getRel(), (Object)link);
            } else if (obj instanceof Map) {
                map = (Map)obj;
            } else if (obj instanceof ILinkable) {
                map = ((ILinkable)obj).getLinks().map();
            } else {
                return toAppendTo;
            }
            list = map.values();
            LinkFormat format = new LinkFormat(this.args);
            ArrayList strings = Lists.newArrayList();
            for (ILink link : list) {
                String string = format.format(link);
                strings.add(string);
            }
            String separator = StringUtils.defaultString((String)this.args.get("separator"), (String)" ");
            String res = Joiner.on((String)separator).join((Iterable)strings);
            return toAppendTo.append(res);
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            return null;
        }
    }

    private static class LinkFormat
    extends Format {
        private final Map<String, String> args;

        private LinkFormat(Map<String, String> args) {
            this.args = args;
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            String key;
            ILink link = null;
            if (obj instanceof ILink) {
                link = (ILink)obj;
            } else if (obj instanceof Map) {
                key = this.args.get("rel");
                link = (ILink)((Map)obj).get(key);
            } else if (obj instanceof ILinkable) {
                key = this.args.get("rel");
                link = (ILink)((ILinkable)obj).getLinks().get((Object)key);
            } else {
                return toAppendTo;
            }
            if (link == null) {
                return toAppendTo.append("null");
            }
            if (this.useBrackets()) {
                toAppendTo.append('[');
            }
            String title = StringUtils.defaultString((String)this.args.get("title"), (String)link.getTitle());
            toAppendTo.append("<a href=\"").append(link.getHref()).append("\">").append(title).append("</a>");
            if (this.useBrackets()) {
                toAppendTo.append(']');
            }
            return toAppendTo;
        }

        private boolean useBrackets() {
            return "true".equals(this.args.get("brackets"));
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            return null;
        }
    }
}

