/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.router;

import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.fordiac.ide.gef.FixedAnchor;
import org.eclipse.fordiac.ide.gef.figures.HideableConnection;
import org.eclipse.fordiac.ide.gef.policies.AdjustConnectionEditPolicy;
import org.eclipse.fordiac.ide.gef.router.BendpointPolicyRouter;
import org.eclipse.fordiac.ide.model.CoordinateConverter;
import org.eclipse.fordiac.ide.model.libraryElement.ConnectionRoutingData;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.gef.EditPolicy;

public class MoveableRouter
extends BendpointConnectionRouter
implements BendpointPolicyRouter {
    public static final int MIN_CONNECTION_FB_DISTANCE_SCREEN = 12;
    public static final double MIN_CONNECTION_FB_DISTANCE_IEC61499 = MoveableRouter.fromScreen(12);
    private static final int DOUBLE_MIN_CONNECTION_FB_DISTANCE_SCREEN = 24;
    private static final double DOUBLE_MIN_CONNECTION_FB_DISTANCE_IEC61499 = MoveableRouter.fromScreen(24);
    private static final PrecisionPoint START_POINT = new PrecisionPoint();
    private static final PrecisionPoint END_POINT = new PrecisionPoint();

    public void route(Connection conn) {
        HideableConnection hconn;
        PointList points = conn.getPoints();
        points.removeAllPoints();
        if (conn instanceof HideableConnection && (hconn = (HideableConnection)conn).getModel() != null) {
            MoveableRouter.handleHideableConnection(hconn, points);
        } else {
            MoveableRouter.setStartEndPoints(conn, MoveableRouter.needsSwap(conn));
            points.addPoint((Point)START_POINT);
            MoveableRouter.setCreationBendPoints((Point)START_POINT, (Point)END_POINT, points);
        }
        points.addPoint((Point)END_POINT);
        conn.setPoints(points);
    }

    private static void handleHideableConnection(HideableConnection conn, PointList points) {
        MoveableRouter.setStartEndPoints((Connection)conn, false);
        points.addPoint((Point)START_POINT);
        org.eclipse.fordiac.ide.model.libraryElement.Connection model = conn.getModel();
        if (MoveableRouter.invalidOneSegmentConnection(model.getRoutingData())) {
            ConnectionRoutingData newRoutingData = MoveableRouter.setCreationBendPoints((Point)START_POINT, (Point)END_POINT, points);
            model.setRoutingData(newRoutingData);
        } else {
            if (model.getRoutingData().isNeedsValidation()) {
                MoveableRouter.valdidateConnectionRoutingParams(model.getRoutingData(), (Point)START_POINT, (Point)END_POINT);
                model.getRoutingData().setNeedsValidation(false);
            }
            MoveableRouter.createBendPointList((Point)START_POINT, (Point)END_POINT, model.getRoutingData(), points);
        }
    }

    private static boolean invalidOneSegmentConnection(ConnectionRoutingData routingData) {
        return routingData.is1SegementData() && (MoveableRouter.START_POINT.y != MoveableRouter.END_POINT.y || MoveableRouter.START_POINT.x > MoveableRouter.END_POINT.x);
    }

    private static boolean needsSwap(Connection conn) {
        ConnectionAnchor connectionAnchor = conn.getSourceAnchor();
        if (connectionAnchor instanceof FixedAnchor) {
            FixedAnchor fixedAnchor = (FixedAnchor)connectionAnchor;
            return fixedAnchor.isInput();
        }
        return false;
    }

    private static void setStartEndPoints(Connection conn, boolean needsSwap) {
        if (needsSwap) {
            END_POINT.setLocation(conn.getSourceAnchor().getLocation(conn.getSourceAnchor().getReferencePoint()));
            START_POINT.setLocation(conn.getTargetAnchor().getLocation(conn.getTargetAnchor().getReferencePoint()));
        } else {
            START_POINT.setLocation(conn.getSourceAnchor().getLocation(conn.getSourceAnchor().getReferencePoint()));
            END_POINT.setLocation(conn.getTargetAnchor().getLocation(conn.getTargetAnchor().getReferencePoint()));
        }
        conn.translateToRelative((Translatable)START_POINT);
        conn.translateToRelative((Translatable)END_POINT);
    }

    private static ConnectionRoutingData setCreationBendPoints(Point sourceP, Point destP, PointList points) {
        ConnectionRoutingData routingData = LibraryElementFactory.eINSTANCE.createConnectionRoutingData();
        MoveableRouter.valdidateConnectionRoutingParams(routingData, sourceP, destP);
        MoveableRouter.createBendPointList(sourceP, destP, routingData, points);
        return routingData;
    }

    private static void createBendPointList(Point sourceP, Point destP, ConnectionRoutingData routingData, PointList points) {
        if (!routingData.is1SegementData()) {
            points.addPoint(sourceP.x + MoveableRouter.toScreen(routingData.getDx1()), sourceP.y);
            if (routingData.is3SegementData()) {
                points.addPoint(sourceP.x + MoveableRouter.toScreen(routingData.getDx1()), destP.y);
            } else {
                points.addPoint(sourceP.x + MoveableRouter.toScreen(routingData.getDx1()), sourceP.y + MoveableRouter.toScreen(routingData.getDy()));
                points.addPoint(destP.x - MoveableRouter.toScreen(routingData.getDx2()), sourceP.y + MoveableRouter.toScreen(routingData.getDy()));
                points.addPoint(destP.x - MoveableRouter.toScreen(routingData.getDx2()), destP.y);
            }
        }
    }

    private static void valdidateConnectionRoutingParams(ConnectionRoutingData routingData, Point sourceP, Point destP) {
        if (routingData.is1SegementData()) {
            MoveableRouter.validate1SegmentConn(routingData, sourceP, destP);
        } else if (sourceP.y == destP.y && !MoveableRouter.requires5SegementConnection(sourceP, destP)) {
            routingData.setDx1(0.0);
        } else if (routingData.is3SegementData()) {
            MoveableRouter.validate3SegmentConn(routingData, sourceP, destP);
        } else {
            MoveableRouter.validate5SegmentConn(routingData, sourceP, destP);
        }
    }

    private static void validate1SegmentConn(ConnectionRoutingData routingData, Point sourceP, Point destP) {
        if (sourceP.y != destP.y || MoveableRouter.requires5SegementConnection(sourceP, destP)) {
            if (MoveableRouter.requires5SegementConnection(sourceP, destP)) {
                MoveableRouter.generateInitial5SegmentParams(routingData, sourceP, destP);
            } else {
                MoveableRouter.generateInitial3SegmentParams(routingData, sourceP, destP);
            }
        }
    }

    private static void validate3SegmentConn(ConnectionRoutingData routingData, Point sourceP, Point destP) {
        if (MoveableRouter.requires5SegementConnection(sourceP, destP)) {
            MoveableRouter.generateInitial5SegmentParams(routingData, sourceP, destP);
        } else if (sourceP.x + MoveableRouter.toScreen(routingData.getDx1()) > destP.x - 12) {
            routingData.setDx1(MoveableRouter.fromScreen(destP.x - sourceP.x - 12));
        }
    }

    private static void validate5SegmentConn(ConnectionRoutingData routingData, Point sourceP, Point destP) {
        if (!MoveableRouter.requires5SegementConnection(sourceP, destP)) {
            routingData.setDx2(0.0);
            routingData.setDy(0.0);
            MoveableRouter.generateInitial3SegmentParams(routingData, sourceP, destP);
        }
    }

    private static void generateInitial3SegmentParams(ConnectionRoutingData routingData, Point sourceP, Point destP) {
        routingData.setDx1(MoveableRouter.fromScreen((destP.x - sourceP.x) / 2));
    }

    private static void generateInitial5SegmentParams(ConnectionRoutingData routingData, Point sourceP, Point destP) {
        routingData.setDx1(MIN_CONNECTION_FB_DISTANCE_IEC61499);
        routingData.setDx2(MIN_CONNECTION_FB_DISTANCE_IEC61499);
        routingData.setDy(MoveableRouter.fromScreen((destP.y - sourceP.y) / 2));
        if (Math.abs(routingData.getDy()) < 0.01) {
            routingData.setDy(DOUBLE_MIN_CONNECTION_FB_DISTANCE_IEC61499);
        }
    }

    private static boolean requires5SegementConnection(Point sourceP, Point destP) {
        return sourceP.x >= destP.x - 24;
    }

    @Override
    public EditPolicy getBendpointPolicy(Object modelObject) {
        if (modelObject instanceof org.eclipse.fordiac.ide.model.libraryElement.Connection) {
            org.eclipse.fordiac.ide.model.libraryElement.Connection conn = (org.eclipse.fordiac.ide.model.libraryElement.Connection)modelObject;
            return new AdjustConnectionEditPolicy(conn);
        }
        return null;
    }

    private static int toScreen(double val) {
        return CoordinateConverter.INSTANCE.iec61499ToScreen(val);
    }

    private static double fromScreen(int val) {
        return CoordinateConverter.INSTANCE.screenToIEC61499(val);
    }
}

