/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.sort;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Properties;
import org.eclipse.nebula.widgets.nattable.persistence.IPersistable;
import org.eclipse.nebula.widgets.nattable.sort.ISortModel;
import org.eclipse.nebula.widgets.nattable.sort.SortDirectionEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortStatePersistor<T>
implements IPersistable {
    private static final Logger LOG = LoggerFactory.getLogger(SortStatePersistor.class);
    public static final String PERSISTENCE_KEY_SORTING_STATE = ".SortHeaderLayer.sortingState";
    private final ISortModel sortModel;

    public SortStatePersistor(ISortModel sortModel) {
        this.sortModel = sortModel;
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        StringBuilder builder = new StringBuilder();
        for (int columnIndex : this.sortModel.getSortedColumnIndexes()) {
            SortDirectionEnum sortDirection = this.sortModel.getSortDirection(columnIndex);
            int sortOrder = this.sortModel.getSortOrder(columnIndex);
            builder.append(columnIndex);
            builder.append(":");
            builder.append(sortDirection.toString());
            builder.append(":");
            builder.append(sortOrder);
            builder.append("|");
        }
        String result = builder.toString();
        if (result != null && result.length() > 0) {
            properties.put(prefix + PERSISTENCE_KEY_SORTING_STATE, result);
        } else {
            properties.remove(prefix + PERSISTENCE_KEY_SORTING_STATE);
        }
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        this.sortModel.clear();
        Object savedValue = properties.get(prefix + PERSISTENCE_KEY_SORTING_STATE);
        if (savedValue == null) {
            return;
        }
        try {
            String savedState = savedValue.toString();
            String[] sortedColumns = savedState.split("\\|");
            ArrayList<SortState> stateInfo = new ArrayList<SortState>();
            String[] stringArray = sortedColumns;
            int n = sortedColumns.length;
            int n2 = 0;
            while (n2 < n) {
                String token = stringArray[n2];
                stateInfo.add(this.getSortStateFromString(token));
                ++n2;
            }
            Collections.sort(stateInfo, Comparator.comparingInt(state -> state.sortOrder));
            for (SortState state2 : stateInfo) {
                this.sortModel.sort(state2.columnIndex, state2.sortDirection, true);
            }
        }
        catch (Exception ex) {
            this.sortModel.clear();
            LOG.error("Error while restoring sorting state: {}", (Object)ex.getLocalizedMessage(), (Object)ex);
        }
    }

    protected SortState getSortStateFromString(String token) {
        String[] split = token.split(":");
        int columnIndex = Integer.parseInt(split[0]);
        SortDirectionEnum sortDirection = SortDirectionEnum.valueOf(split[1]);
        int sortOrder = Integer.parseInt(split[2]);
        return new SortState(columnIndex, sortDirection, sortOrder);
    }

    protected class SortState {
        public int columnIndex;
        public SortDirectionEnum sortDirection;
        public int sortOrder;

        public SortState(int columnIndex, SortDirectionEnum sortDirection, int sortOrder) {
            this.columnIndex = columnIndex;
            this.sortDirection = sortDirection;
            this.sortOrder = sortOrder;
        }
    }
}

