/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.api.util;

public final class FileUtil {
    private static final String[] WINDOWS_RESERVED_FILE_AND_FOLDER_NAME = new String[]{"com1", "com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9", "con", "nul", "prn"};
    private static final int WINDOWS_FILENAME_MAX_LENGTH = 255;
    private static final char[] ILLEGAL_CHARACTERS;
    private String filename;
    private InvalidFilenameError error;

    static {
        char[] cArray = new char[15];
        cArray[0] = 47;
        cArray[1] = 10;
        cArray[2] = 13;
        cArray[3] = 9;
        cArray[5] = 12;
        cArray[6] = 96;
        cArray[7] = 63;
        cArray[8] = 42;
        cArray[9] = 92;
        cArray[10] = 60;
        cArray[11] = 62;
        cArray[12] = 124;
        cArray[13] = 34;
        cArray[14] = 58;
        ILLEGAL_CHARACTERS = cArray;
    }

    public FileUtil(String filename) {
        this.filename = filename;
        this.error = InvalidFilenameError.NO_ERROR;
    }

    public boolean isValid() {
        boolean valid = false;
        if (this.containsIllegalCharacter(this.filename)) {
            this.error = InvalidFilenameError.ILLEGAL_CHARACTERS;
        } else if (this.isAReservedFilename(this.filename)) {
            this.error = InvalidFilenameError.RESERVED_FILENAME;
        } else if (this.exceedMaxLength(this.filename)) {
            this.error = InvalidFilenameError.MAX_LENGTH;
        } else {
            valid = true;
        }
        return valid;
    }

    private boolean containsIllegalCharacter(String file) {
        char[] cArray = ILLEGAL_CHARACTERS;
        int n = ILLEGAL_CHARACTERS.length;
        int n2 = 0;
        while (n2 < n) {
            Character illegalChar = Character.valueOf(cArray[n2]);
            if (file.indexOf(illegalChar.charValue()) != -1) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isAReservedFilename(String file) {
        String[] stringArray = WINDOWS_RESERVED_FILE_AND_FOLDER_NAME;
        int n = WINDOWS_RESERVED_FILE_AND_FOLDER_NAME.length;
        int n2 = 0;
        while (n2 < n) {
            String reservedFilename = stringArray[n2];
            if (reservedFilename.equals(file)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean exceedMaxLength(String file) {
        return file.length() > 255;
    }

    public InvalidFilenameError getError() {
        return this.error;
    }

    public String getValidFilename() {
        String newFilename = this.removeIllegalCharacters();
        while (this.isAReservedFilename(newFilename)) {
            newFilename = newFilename.concat("-");
        }
        while (this.exceedMaxLength(newFilename)) {
            newFilename = newFilename.substring(0, newFilename.length() - 2);
        }
        return newFilename;
    }

    private String removeIllegalCharacters() {
        String safe = this.filename;
        char[] cArray = ILLEGAL_CHARACTERS;
        int n = ILLEGAL_CHARACTERS.length;
        int n2 = 0;
        while (n2 < n) {
            Character illegalChar = Character.valueOf(cArray[n2]);
            if (safe.indexOf(illegalChar.charValue()) != -1) {
                safe = safe.replace(illegalChar.charValue(), '-');
            }
            ++n2;
        }
        return safe;
    }

    public static enum InvalidFilenameError {
        NO_ERROR,
        ILLEGAL_CHARACTERS,
        RESERVED_FILENAME,
        MAX_LENGTH;

    }
}

