/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.interactors;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableFB;
import org.eclipse.fordiac.ide.model.libraryElement.Demultiplexer;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.impl.ConfigurableFBManagement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;

public class ForteTypeNameCreator {
    public static String getForteTypeName(TypeEntry entry) {
        return ForteTypeNameCreator.convertFullTypeNameToFORTE(entry.getFullTypeName());
    }

    public static String getForteTypeName(FBNetworkElement fb) {
        if (fb != null && fb.getTypeEntry() != null) {
            if (fb instanceof ConfigurableFB) {
                ConfigurableFB confFB = (ConfigurableFB)fb;
                return ForteTypeNameCreator.getConfigureFBType(confFB);
            }
            return ForteTypeNameCreator.getTypeName(fb);
        }
        return "";
    }

    private static String getTypeName(FBNetworkElement fb) {
        return ForteTypeNameCreator.convertFullTypeNameToFORTE(fb.getFullTypeName());
    }

    private static String getConfigureFBType(ConfigurableFB confFB) {
        DataType dt = confFB.getDataType();
        Object typeName = ForteTypeNameCreator.getTypeName((FBNetworkElement)confFB);
        if (dt != null) {
            Demultiplexer demux;
            typeName = (String)typeName + "_1" + ForteTypeNameCreator.convertFullTypeNameToFORTE(PackageNameHelper.getFullTypeName((LibraryElement)dt));
            if (confFB instanceof Demultiplexer && ForteTypeNameCreator.isConfigured(demux = (Demultiplexer)confFB)) {
                typeName = (String)typeName + "____" + ConfigurableFBManagement.buildVisibleChildrenString((EList)demux.getMemberVars());
            }
        }
        return typeName;
    }

    private static boolean isConfigured(Demultiplexer demux) {
        EObject eObj = demux.eContainer().eContainer();
        if (eObj instanceof Resource) {
            return ((Demultiplexer)demux.getOpposite()).isIsConfigured();
        }
        return demux.isIsConfigured();
    }

    private static String convertFullTypeNameToFORTE(String fullTypeName) {
        return fullTypeName;
    }

    private ForteTypeNameCreator() {
        throw new UnsupportedOperationException("Helper class should not be instantiated!");
    }
}

