/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.testing;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.elk.core.AbstractLayoutProvider;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.testing.IWhiteBoxTestable;

public class TestController {
    private final String layoutAlgorithmId;
    private IWhiteBoxTestable currentLayoutProvider;
    private Set<ILayoutExecutionListener> listeners = new LinkedHashSet<ILayoutExecutionListener>();

    public TestController(String layoutAlgorithmId) {
        this.layoutAlgorithmId = layoutAlgorithmId;
    }

    public String getTargetAlgorithmId() {
        return this.layoutAlgorithmId;
    }

    public boolean targets(LayoutAlgorithmData algorithmData) {
        return algorithmData.getId().equals(this.layoutAlgorithmId);
    }

    public void install(AbstractLayoutProvider layoutProvider) {
        if (this.currentLayoutProvider != null) {
            throw new IllegalStateException("Test controller may be installed on only one layout provider at a time");
        }
        if (!(layoutProvider instanceof IWhiteBoxTestable)) {
            throw new IllegalArgumentException("Test controllers can only be installed on white-box testable layout algorithms");
        }
        this.currentLayoutProvider = (IWhiteBoxTestable)((Object)layoutProvider);
        this.currentLayoutProvider.setTestController(this);
    }

    public void uninstall() {
        if (this.currentLayoutProvider != null) {
            this.currentLayoutProvider.setTestController(null);
            this.currentLayoutProvider = null;
        }
    }

    public void notifyProcessorReady(Object graph, ILayoutProcessor<?> processor) {
        for (ILayoutExecutionListener listener : this.listeners) {
            listener.layoutProcessorReady(processor, graph, false);
        }
    }

    public void notifyProcessorFinished(Object graph, ILayoutProcessor<?> processor) {
        for (ILayoutExecutionListener listener : this.listeners) {
            listener.layoutProcessorFinished(processor, graph, false);
        }
    }

    public void notifyRootProcessorReady(Object graph, ILayoutProcessor<?> processor) {
        for (ILayoutExecutionListener listener : this.listeners) {
            listener.layoutProcessorReady(processor, graph, true);
        }
    }

    public void notifyRootProcessorFinished(Object graph, ILayoutProcessor<?> processor) {
        for (ILayoutExecutionListener listener : this.listeners) {
            listener.layoutProcessorFinished(processor, graph, true);
        }
    }

    public void addLayoutExecutionListener(ILayoutExecutionListener listener) {
        this.listeners.add(listener);
    }

    public void removeLayoutExecutionListener(ILayoutExecutionListener listener) {
        this.listeners.add(listener);
    }

    public static interface ILayoutExecutionListener {
        public void layoutProcessorReady(ILayoutProcessor<?> var1, Object var2, boolean var3);

        public void layoutProcessorFinished(ILayoutProcessor<?> var1, Object var2, boolean var3);
    }
}

