#define NAME     "ProcessIcon"
#define REVISION "21"

/* Programmheader

        Name:           ProcessIcon
        Author:         SDI
        Distribution:   PD
        Description:    processes .info files
        Compileropts:   -
        Linkeropts:     -l amiga

 1.0   01.93.97 : first version
 1.1   03.03.97 : options KILLSTACKSIZE, KILLDEFTOOL, VIEW
 1.2   05.03.97 : added SIT and CIT options
 1.3   29.03.97 : not existing TO produces icon
 1.4   13.06.97 : lots of changes, renamed from CopyIconImage
 1.5   14.06.97 : added more data to VIEW option
 1.6   01.07.97 : fixed problem with DrawerData
 1.7   09.11.97 : added UNSNAP function
 1.8   05.02.98 : IMGSRC became REFICON, added CII instead of autocopy
 1.9   01.09.98 : better VIEW output
 1.10  08.05.99 : added REMAP option
 1.11  21.09.99 : KTT removes entry totally
 1.12  11.10.99 : add SSS option
 1.13  05.11.99 : added NewIcon support
 1.14  09.11.99 : added OS3.5 support, better source, removed global variables,
	program got multi-reentrant
 1.15  10.11.99 : little bug fix
 1.16  15.11.99 : added MAKECI
 1.17  21.11.99 : bug-fix
 1.18  27.11.99 : added SHOWTYPE
 1.19  29.11.99 : Fixed II2CI, SHOWTYPE
 1.20  25.01.02 : fiex MAKECI for NewIcons
 1.21  02.02.02 : added ROM2CI option
*/

#include <proto/dos.h>
#include <proto/icon.h>
#include <proto/exec.h>
#include <proto/graphics.h>
#include <exec/memory.h>
#include <workbench/icon.h>
#define SDI_TO_ANSI
#include "SDI_ASM_STD_protos.h"
#include "SDI_defines.h"

#define PARAM (STRPTR)  "ICON/A,REFICON,VIEW/S,OPT=OPTIMIZE/S,"         \
                        "US=UNSNAP/S,REMAP/S,SHOWTYPE/S,"               \
                        "NI2CI/S,MWB2CI/S,ROM2CI/S,II2CI/S,MAKECI/S,"   \
                        "SBP=SETBITPLANES/N,SDT=SETDEFTOOL,"            \
                        "SIT=SETICONTYPE,SSS=SETSTACKSIZE/N,"           \
                        "ST1=SETTRANSPARENT1/N,ST2=SETTRANSPARENT2/N,"	\
                        "SXP=SETXPOS/N,SYP=SETYPOS/N,"                  \
                        "KCI=KILLCOLORICON/S,"                          \
                        "KDD=KILLDRAWERDATA/S,KDT=KILLDEFTOOL/S,"       \
                        "KII=KILLICONIMAGE/S,KNI=KILLNEWICON/S,"        \
                        "KSS=KILLSTACKSIZE/S,KTT=KILLTOOLTYPES/S,"      \
                        "CCI=COPYCOLORICON/S,"                          \
                        "CDD=COPYDRAWERDATA/S,CDT=COPYDEFTOOL/S,"       \
                        "CII=COPYICONIMAGE/S,CIT=COPYICONTYPE/S,"       \
                        "CNI=COPYNEWICON/S,CSS=COPYSTACKSIZE/S,"        \
                        "CTT=COPYTOOLTYPES/S"
struct Args {
    STRPTR      icon;
    STRPTR      reficon;
    ULONG       view;
    ULONG       optimize;
    ULONG       unsnap;
    ULONG       remap;
    ULONG	showtype;
    ULONG       ni2ci;
    ULONG       mwb2ci;
    ULONG       rom2ci;
    ULONG       ii2ci;
    ULONG       makeci;
    ULONG *     setbitplanes;
    STRPTR      setdeftool;
    STRPTR      seticontype;
    ULONG *     setstacksize;
    LONG *	settransparent1;
    LONG *      settransparent2;
    ULONG *     setxpos;
    ULONG *     setypos;
    ULONG       killcoloricon;
    ULONG       killdrawerdata;
    ULONG       killdeftool;
    ULONG       killiconimage;
    ULONG       killnewicon;
    ULONG       killstacksize;
    ULONG       killtooltypes;
    ULONG       copycoloricon;
    ULONG       copydrawerdata;
    ULONG       copydeftool;
    ULONG       copyiconimage;
    ULONG       copyicontype;
    ULONG       copynewicon;
    ULONG       copystacksize;
    ULONG       copytooltypes;
};

const STRPTR IconTypeRecog[] = {0, "Disk", "Drawer", "Tool", "Project", "Garbage", "Device", "Kick", "AppIcon"};
const UBYTE NewIconTXT[] = "*** DON'T EDIT THE FOLLOWING LINES!! ***";
const UWORD KIIData[] = {0xF000,0xF000,0xF000,0xF000};
const struct Image KIIImage = {0, 0, 4, 4, 1, (UWORD *) &KIIData, 1, 0, 0};
const UBYTE MagicWBPalette[8 * 3] = {
  0x96,0x96,0x96, 0x00,0x00,0x00, 0xFF,0xFF,0xFF, 0x3D,0x65,0xA2,
  0x79,0x79,0x79, 0xAE,0xAE,0xAE, 0xAA,0x92,0x7D, 0xFF,0xAA,0x96
};
const UBYTE Default8Palette[8 * 3] = {
  0xAA,0xAA,0xAA, 0x00,0x00,0x00, 0xFF,0xFF,0xFF, 0x65,0x8A,0xBA,
  0xEF,0x45,0x45, 0x55,0xDF,0x55, 0x00,0x45,0xDF, 0xEF,0x9A,0x00
};
const UBYTE RomIconsPalette[16*3] = {
  0x95,0x95,0x95, 0x00,0x00,0x00, 0xFF,0xFF,0xFF, 0x3B,0x67,0xA2,
  0x7B,0x7B,0x7B, 0xAF,0xAF,0xAF, 0xAA,0x90,0x7C, 0xFF,0xA9,0x97,
  0x00,0x00,0xFF, 0x32,0x32,0x32, 0x60,0x80,0x60, 0xE2,0xD1,0x77,
  0xFF,0xD4,0xCB, 0x7A,0x60,0x48, 0xD2,0xD2,0xD2, 0xE5,0x5D,0x5D
};

static void RemapImage(struct Image *im)
{
  ULONG w, i, j, k, d;
  UWORD *ptr;

  w = (im->Width+15)>>4; /* divide by 16 */
  ptr = im->ImageData;

  if(im->Depth == 1)
  {
    for(i = 0; i < im->Height; ++i)
    {
      for(j = 0; j < w; ++j)
        ptr[i*w + j] ^= 0xFFFF;
      if((k = (w<<4) - im->Width))
      {
        /* clear last unused bits */
        ptr[i*w + j - 1] &= (0xFFFF >> k) << k;
      }
    }
  }
  else
  {
    for(i = 0; i < im->Height; ++i)
    {
      for(j = 0; j < w; ++j)
      {
        k = ptr[i*w + j] ^ ptr[(im->Height + i)*w + j];
        for(d = 2; d < im->Depth; ++d)
          k &= (~ptr[(im->Height*d +i)*w + j]);
        ptr[i*w + j] ^= k;
        ptr[(im->Height + i)*w + j] ^= k;
      }
      if((k = (w<<4) - im->Width))
      {
        /* clear last unused bits */
        ptr[i*w + j - 1] &= (0xFFFF >> k) << k;
        ptr[(im->Height + i)*w + j - 1] &= (0xFFFF >> k) << k;
      }
    }
  }
}

#define TESTGROUP(a, b, c)      if((a && (b || c)) || (b && c)) ++argerr

#define TYPE_STANDARD   0
#define TYPE_NEWICON    1
#define TYPE_NEWICON35  2
#define TYPE_OS35       3
#define TYPE_BOTHCOLOR  4

ULONG dowork(struct Args *args, struct Library *IconBase, ULONG os35mode)
{
  ULONG ret = RETURN_FAIL, s;
  struct DiskObject *dobj;

  if((dobj = (os35mode ? GetIconTags(args->icon,
  ICONGETA_FailIfUnavailable, FALSE, ICONGETA_GetPaletteMappedIcon, FALSE, TAG_DONE) :
  GetDiskObjectNew(args->icon))))
  {
    struct DiskObject *dobjdrw; 
    if((dobjdrw = GetDefDiskObject(WBDRAWER)))
    {
      struct DiskObject *dobjsrc = 0;

      if(!args->reficon || (dobjsrc = (os35mode ?
      GetIconTags(args->reficon, ICONGETA_GetPaletteMappedIcon, FALSE, TAG_DONE) : GetDiskObject(args->reficon))))
      {
        STRPTR *tooltypes;
        UBYTE *imageBuffer[2] = {0, 0};
        
        if((tooltypes = (STRPTR *) AllocVec(1000*sizeof(STRPTR), MEMF_CLEAR)))
        {
          ULONG type = TYPE_STANDARD;
          STRPTR *tt, t, t2;

          if((tt = (STRPTR *) dobj->do_ToolTypes))
          {
            while(*tt)
            {
              if((**tt == ' ') && tt[1] && !strcmp(tt[1], (STRPTR) NewIconTXT))
                type = TYPE_NEWICON;
              ++tt;
            }
          }

          if(os35mode)
          {
            LONG p = 0, n = 0;
          
            IconControl(dobj, ICONCTRLA_IsPaletteMapped, &p, ICONCTRLA_IsNewIcon, &n, TAG_DONE);
            if(p) type = TYPE_OS35;
            if(n) type = TYPE_NEWICON35;
            if(p && n) type = TYPE_BOTHCOLOR;
          }

	  if(args->makeci)
	  {
	    switch(type)
	    {
	    case TYPE_STANDARD: args->ii2ci = 1; break;
	    case TYPE_NEWICON: case TYPE_NEWICON35: args->ni2ci = 1; break;
	    case TYPE_BOTHCOLOR: args->killnewicon = 1; break;
	    }
	  }

	  if(args->showtype)
	  {
            switch(type)
            {
              case TYPE_BOTHCOLOR: t = "OS3.5 + NewIcon"; break;
              case TYPE_NEWICON: case TYPE_NEWICON35: t = "NewIcon"; break;
              case TYPE_OS35: t = "OS3.5 Icon"; break;
              default: t = "Standard"; break;
            }
            Printf("%-15s - %s\n", t, args->icon);
            ret = RETURN_OK;
	  }
          else if(args->view)
          {
            switch(type)
            {
              case TYPE_BOTHCOLOR: t = "OS3.5 + NewIcon"; break;
              case TYPE_NEWICON: case TYPE_NEWICON35: t = "NewIcon"; break;
              case TYPE_OS35: t = "OS3.5 Icon"; break;
              default: t = "Standard"; break;
            }

            if(type == TYPE_NEWICON)
            {
              t2 = "YES, NEWICON";

              if((**dobj->do_ToolTypes == ' ') && *(dobj->do_ToolTypes[1]) &&
              !strcmp(dobj->do_ToolTypes[1], (STRPTR) NewIconTXT))
                t2 = "YES - EMPTY, NEWICON";
            }
            else if(type == TYPE_NEWICON35 || type == TYPE_BOTHCOLOR)
            {
              t2 = "YES, NEWICON";

              if(!(*dobj->do_ToolTypes))
                t2 = "YES - EMPTY, NEWICON";
            }
            else if(dobj->do_ToolTypes)
            {
              if(!(*dobj->do_ToolTypes))
                t2 = "YES - EMPTY";
              else
                t2 = "YES";
            }
            else
              t2 = "NO";

            Printf("Name: %s\nType: %s\n  SS: %ld\n  IT: %s\n  BP: %ld,%ld\n  SZ: ",
              args->icon, t, dobj->do_StackSize, IconTypeRecog[dobj->do_Type],
              ((struct Image *)dobj->do_Gadget.GadgetRender)->Depth,
              (dobj->do_Gadget.SelectRender ?
              ((struct Image *)dobj->do_Gadget.SelectRender)->Depth : 0));
            Printf(dobj->do_CurrentX == NO_ICON_POSITION ? "NOPOS" : "x=%3ld",
              dobj->do_CurrentX);
            Printf(dobj->do_CurrentY == NO_ICON_POSITION ? ", NOPOS" : ", y=%3ld",
              dobj->do_CurrentY);
            Printf(", w=%3ld, h=%3ld\n  DT: (%s) %s\n",
              dobj->do_Gadget.Width, dobj->do_Gadget.Height,
              (dobj->do_DefaultTool ? "YES" : "NO"), dobj->do_DefaultTool);
            
            if(type == TYPE_OS35 || type == TYPE_BOTHCOLOR)
            {
	      LONG t1 = -1, t2 = -1, fr = 0, w = 0, h = 0, i2, s1, s2;

              IconControl(dobj, ICONCTRLA_GetTransparentColor1, &t1, TAG_DONE);
              IconControl(dobj, ICONCTRLA_GetPaletteSize1, &s1, TAG_DONE);
              IconControl(dobj, ICONCTRLA_GetPaletteSize2, &s2, TAG_DONE);
              IconControl(dobj, ICONCTRLA_GetTransparentColor2, &t2, TAG_DONE);
              IconControl(dobj, ICONCTRLA_GetImageData2, &i2, TAG_DONE);
              IconControl(dobj, ICONCTRLA_GetFrameless, &fr, TAG_DONE);
              IconControl(dobj, ICONCTRLA_GetWidth, &w, TAG_DONE);
              IconControl(dobj, ICONCTRLA_GetHeight, &h, TAG_DONE);

	      Printf("  CI -Width      : %3ld\n  CI -Height     : %3ld\n"
	      "  CI -Borderless : %s\n  CI -NumImages  : %3ld\n  CI1-Transparent: ",
	      w, h, fr ? "YES" : "NO",i2 ? 2 : 1);
	      
	      Printf(t1 == -1 ? "NO" : "%3ld", t1);
	      Printf("\n  CI1-NumColors  : %3ld\n", s1);
	      if(i2)
	      {
                Printf("  CI2-Transparent: ");
	        Printf(t2 == -1 ? "NO" : "%3ld", t2);
                Printf("\n  CI2-NumColors  : %3ld\n", s2);
              }
            }

            Printf("  TT: (%s)\n", t2);

            if((tt = (STRPTR *) dobj->do_ToolTypes))
            {
              while(*tt)
              {
                if((**tt == ' ') && tt[1] && !strcmp(tt[1], (STRPTR) NewIconTXT))
                  break;
                else
                  Printf("  %s\n", *(tt++));
              }
            }
            ret = RETURN_OK;

#ifdef DEBUG
  Printf("NextGadget:   $%08lx\n", dobj->do_Gadget.NextGadget);
  Printf("LeftEdge:     %4ld\n", dobj->do_Gadget.LeftEdge);
  Printf("TopEdge:      %4ld\n", dobj->do_Gadget.TopEdge);
  Printf("Width:        %4ld\n", dobj->do_Gadget.Width);
  Printf("Height:       %4ld\n", dobj->do_Gadget.Height);
  Printf("Flags:        $%04lx\n", dobj->do_Gadget.Flags);
  Printf("Activation:   $%04lx\n", dobj->do_Gadget.Activation);
  Printf("GadgetType:   %4ld\n", dobj->do_Gadget.GadgetType);
  Printf("GadgetRender: $%08lx\n", dobj->do_Gadget.GadgetRender);
  Printf("SelectRender: $%08lx\n", dobj->do_Gadget.SelectRender);
  Printf("GadgetText:   $%08lx\n", dobj->do_Gadget.GadgetText);
  Printf("MutualExclude:%4ld\n", dobj->do_Gadget.MutualExclude);
  Printf("SpecialInfo:  $%08lx\n", dobj->do_Gadget.SpecialInfo);
  Printf("GadgetID:     %4ld\n", dobj->do_Gadget.GadgetID);
  Printf("UserData:     $%08lx\n", dobj->do_Gadget.UserData);
  if(dobj->do_Gadget.Flags & GFLG_GADGIMAGE)
  {
    struct Image *i;
    
    i = (struct Image *) dobj->do_Gadget.GadgetRender;
    Printf("LeftEdge:     %4ld\n", i->LeftEdge);
    Printf("TopEdge:      %4ld\n", i->TopEdge);
    Printf("Width:        %4ld\n", i->Width);
    Printf("Height:       %4ld\n", i->Height);
    Printf("Depth:        %4ld\n", i->Depth);
    Printf("ImageData:    $%08lx\n", i->ImageData);
    Printf("PlanePick:    %2ld\n", i->PlanePick);
    Printf("PlaneOnOff:   %2ld\n", i->PlaneOnOff);
    Printf("NextImage:    $%08lx\n", i->NextImage);
  }
#endif
          }
          else
          {
            if(args->copyiconimage)
            {
              if(dobj->do_CurrentX != NO_ICON_POSITION && dobj->do_CurrentY != NO_ICON_POSITION)
              {
                dobj->do_CurrentX += (dobj->do_Gadget.Width>>1) - (dobjsrc->do_Gadget.Width>>1);
                dobj->do_CurrentY += dobj->do_Gadget.Height - dobjsrc->do_Gadget.Height;
                /* 'down middle position' of gadget should be same after image copy */
              }
              dobj->do_Gadget = dobjsrc->do_Gadget;       /* copy gadget structures */
            }

            if(args->copytooltypes || args->copynewicon)
            {
              s = 0;
              if((tt = (STRPTR *) (args->copytooltypes ? dobjsrc : dobj)->do_ToolTypes))
              {
                 while(*tt && !((**tt == ' ') && tt[1] && !strcmp(tt[1], (STRPTR) NewIconTXT)))
                  tooltypes[s++] = *(tt++);
              }
              if((tt = (STRPTR *) (args->copynewicon ? dobjsrc : dobj)->do_ToolTypes))
              {
                while(*tt && !((**tt == ' ') && tt[1] && !strcmp(tt[1], (STRPTR) NewIconTXT)))
                  ++tt;
                while(*tt)
                  tooltypes[s++] = *(tt++);
              }
              dobj->do_ToolTypes = (char **) (s ? tooltypes : 0);
            }

            if(args->seticontype)
            {
              s = 0;

              while(++s <= WBAPPICON && stricmp(IconTypeRecog[s], args->seticontype))
                ;
              if(s <= WBAPPICON)
                dobj->do_Type = s;

              if(!(dobj->do_DrawerData && (dobj->do_Type == WBDISK ||
              dobj->do_Type == WBGARBAGE || dobj->do_Type == WBDRAWER)))
                dobj->do_DrawerData = dobjdrw->do_DrawerData;
            }

            if(args->remap)
            {
              RemapImage((struct Image *) dobj->do_Gadget.GadgetRender);
              if(dobj->do_Gadget.SelectRender)
                RemapImage((struct Image *) dobj->do_Gadget.SelectRender);
            }

            if(args->setbitplanes)
            {
              ((struct Image *) dobj->do_Gadget.GadgetRender)->Depth = *args->setbitplanes;
              if(dobj->do_Gadget.SelectRender)
                ((struct Image *) dobj->do_Gadget.SelectRender)->Depth = *args->setbitplanes;
            }

            if(args->copydeftool)         dobj->do_DefaultTool = dobjsrc->do_DefaultTool;
            if(args->copyicontype)        dobj->do_Type = dobjsrc->do_Type;
            if(args->copystacksize)       dobj->do_StackSize = dobjsrc->do_StackSize;
            if(args->copydrawerdata)      dobj->do_DrawerData = dobjsrc->do_DrawerData;
           if(args->setxpos)             dobj->do_CurrentX = *args->setxpos;
            if(args->setypos)             dobj->do_CurrentY = *args->setypos;
            if(args->setstacksize)        dobj->do_StackSize = *args->setstacksize;
            if(args->setdeftool)          dobj->do_DefaultTool = args->setdeftool;
            if(args->unsnap)              dobj->do_CurrentX = dobj->do_CurrentY = NO_ICON_POSITION;
            if(args->killstacksize)       dobj->do_StackSize = 0;
            if(args->killdeftool)         dobj->do_DefaultTool = 0;

            if(args->killdrawerdata)
            {
                   dobj->do_DrawerData = dobjdrw->do_DrawerData;
              if(dobj->do_Type != WBDISK && dobj->do_Type != WBGARBAGE && dobj->do_Type != WBDRAWER)
                dobj->do_DrawerData = 0;
            }

            if(args->killnewicon && (tt = (STRPTR *) dobj->do_ToolTypes))
            {
              while(*tt)
              {
                if((**tt == ' ') && tt[1] && !strcmp(tt[1], (STRPTR) NewIconTXT))
                  *tt = 0;
                else
                  ++tt;
              }
            }

            if(args->killtooltypes && (tt = (STRPTR *) dobj->do_ToolTypes))
            {
              s = 0;
              while(*tt && !((**tt == ' ') && tt[1] && !strcmp(tt[1], (STRPTR) NewIconTXT)))
                ++tt;
              while(*tt)
                tooltypes[s++] = *(tt++);
              dobj->do_ToolTypes = (char **) (s ? tooltypes : 0);
            }

            if(args->copycoloricon)
            {
              LONG t1=-1, t2=-1, s1=0, s2=0, fr=0, w=0, h=0, wo = 0, ho = 0;
              struct ColorRegister *c1=0, *c2=0;
              UBYTE *i1=0, *i2=0;
              UBYTE as=0;

              IconControl(dobjsrc, ICONCTRLA_GetTransparentColor1, &t1, TAG_DONE);
              IconControl(dobjsrc, ICONCTRLA_GetTransparentColor2, &t2, TAG_DONE);
              IconControl(dobjsrc, ICONCTRLA_GetPalette1, &c1, TAG_DONE);
              IconControl(dobjsrc, ICONCTRLA_GetPalette2, &c2, TAG_DONE);
              IconControl(dobjsrc, ICONCTRLA_GetPaletteSize1, &s1, TAG_DONE);
              IconControl(dobjsrc, ICONCTRLA_GetPaletteSize2, &s2, TAG_DONE);
              IconControl(dobjsrc, ICONCTRLA_GetImageData1, &i1, TAG_DONE);
              IconControl(dobjsrc, ICONCTRLA_GetImageData2, &i2, TAG_DONE);
              IconControl(dobjsrc, ICONCTRLA_GetFrameless, &fr, TAG_DONE);
              IconControl(dobjsrc, ICONCTRLA_GetAspectRatio, &as, TAG_DONE);
              IconControl(dobjsrc, ICONCTRLA_GetWidth, &w, TAG_DONE);
              IconControl(dobjsrc, ICONCTRLA_GetHeight, &h, TAG_DONE);

              if(!IconControl(dobj, ICONCTRLA_GetWidth, &wo, TAG_DONE))
                wo =dobj->do_Gadget.Width;
              if(!IconControl(dobj, ICONCTRLA_GetHeight, &ho, TAG_DONE))
                ho = dobj->do_Gadget.Height;
              if(dobj->do_CurrentX != NO_ICON_POSITION && dobj->do_CurrentY != NO_ICON_POSITION)
              {
                dobj->do_CurrentX += (wo>>1) - (w>>1);
                dobj->do_CurrentY += ho - h;
                /* 'down middle position' of gadget should be same after image copy */
              }

              IconControl(dobj, ICONCTRLA_SetAspectRatio, as, TAG_DONE);
              IconControl(dobj, ICONCTRLA_SetWidth, w, TAG_DONE);
              IconControl(dobj, ICONCTRLA_SetHeight, h, TAG_DONE);
              IconControl(dobj, ICONCTRLA_SetPaletteSize1, s1, TAG_DONE);
              IconControl(dobj, ICONCTRLA_SetPaletteSize2, s2, TAG_DONE);
              IconControl(dobj, ICONCTRLA_SetPalette1, c1, TAG_DONE);
              IconControl(dobj, ICONCTRLA_SetPalette2, c2, TAG_DONE);
              IconControl(dobj, ICONCTRLA_SetImageData1, i1, TAG_DONE);
              IconControl(dobj, ICONCTRLA_SetImageData2, i2, TAG_DONE);
              IconControl(dobj, ICONCTRLA_SetFrameless, fr, TAG_DONE);
              IconControl(dobj, ICONCTRLA_SetTransparentColor1, t1, TAG_DONE);
              IconControl(dobj, ICONCTRLA_SetTransparentColor2, t2, TAG_DONE);
              type = TYPE_OS35;
            }

            if(args->mwb2ci || args->ii2ci || args->rom2ci) /* made from code by Olaf Barthel */
            {
              struct Image *image[2];
              struct GfxBase *GfxBase;

              image[0] = (struct Image *)dobj->do_Gadget.GadgetRender;
              image[1] = (struct Image *)dobj->do_Gadget.SelectRender;

              if((GfxBase = (struct GfxBase *) OpenLibrary("graphics.library", 37)))
              {
                struct RastPort rp;
                struct BitMap bm;
                LONG pixelsPerImage, pageSize, x, y, i, j;
                UBYTE *p;
                PLANEPTR plane;

                for(j = 0; j < 2 && image[j]; ++j)
                {
                  pixelsPerImage = (LONG)image[j]->Width * (LONG)image[j]->Height;
                  if((imageBuffer[j] = AllocVec(pixelsPerImage, MEMF_ANY)))
                  {
		    if(args->rom2ci)
		    {
                      if(image[j]->Depth > 4)
                        image[j]->Depth = 4;
		    }
		    else
		    {
                      if(image[j]->Depth > 3)
                        image[j]->Depth = 3;
                    }

                    InitRastPort(&rp);
                    rp.BitMap = &bm;

                    memset(&bm, 0, sizeof(struct BitMap));
                    bm.BytesPerRow = RASSIZE(image[j]->Width,1);
                    bm.Rows        = image[j]->Height;
                    bm.Depth       = image[j]->Depth;
                    pageSize = RASSIZE(image[j]->Width,image[j]->Height);
                    plane = (PLANEPTR)image[j]->ImageData;

                    for(i = 0; i < image[j]->Depth; ++i)
                    {
                      bm.Planes[i] = plane;
                      plane += pageSize;
                    }

                    p = imageBuffer[j];
                    for(y = 0; y < image[j]->Height ; y++)
                    {
                      for(x = 0; x < image[j]->Width ; x++)
                        (*p++) = ReadPixel(&rp,x,y);
                    }
                  }
                }

		if(args->rom2ci)
		  p = (UBYTE *) RomIconsPalette;
		else
		  p = (UBYTE *) (args->mwb2ci ? MagicWBPalette : Default8Palette);

                IconControl(dobj, ICONCTRLA_SetWidth, image[0]->Width, ICONCTRLA_SetHeight, image[0]->Height,
                ICONCTRLA_SetAspectRatio, PACK_ICON_ASPECT_RATIO(1,1), ICONCTRLA_SetImageData1, imageBuffer[0],
                ICONCTRLA_SetPaletteSize1, 1<<(image[0]->Depth), ICONCTRLA_SetPalette1, p, TAG_DONE);

                if(image[1])
                {
                  IconControl(dobj, ICONCTRLA_SetImageData2, imageBuffer[1], ICONCTRLA_SetPaletteSize2,
                  1<<(image[1]->Depth), ICONCTRLA_SetPalette2, p, TAG_DONE);
                }
                type = TYPE_OS35;
                CloseLibrary((struct Library *) GfxBase);
              }
            } /* args->mwb2ci || args->ii2ci || args->rom2ci */

	    if(os35mode)
	    {
	      if(args->settransparent1) IconControl(dobj, ICONCTRLA_SetTransparentColor1, *args->settransparent1, TAG_DONE);
	      if(args->settransparent2) IconControl(dobj, ICONCTRLA_SetTransparentColor2, *args->settransparent2, TAG_DONE);
	    }

            if(args->killiconimage)
            {
              if(dobj->do_CurrentX != NO_ICON_POSITION && dobj->do_CurrentY != NO_ICON_POSITION
              && type == TYPE_STANDARD)
              {
                dobj->do_CurrentX += (dobj->do_Gadget.Width>>1) - 2;
                dobj->do_CurrentY += dobj->do_Gadget.Height - 5;
                /* 'down middle position' of gadget should be same after image replace */
              }
              dobj->do_Gadget.LeftEdge = dobj->do_Gadget.TopEdge = 50;
              dobj->do_Gadget.Width = dobj->do_Gadget.Height = 4;
              dobj->do_Gadget.Flags = GFLG_GADGIMAGE;
              dobj->do_Gadget.GadgetRender = (APTR) &KIIImage;
              dobj->do_Gadget.SelectRender = 0;
            }

            if(args->optimize)
            {
              if(dobj->do_Type != WBDISK && dobj->do_Type != WBPROJECT)
                dobj->do_DefaultTool = 0;
              if(dobj->do_Type != WBPROJECT && dobj->do_Type != WBTOOL)
                dobj->do_ToolTypes = 0;
              if(dobj->do_Type != WBDISK && dobj->do_Type != WBGARBAGE && dobj->do_Type != WBDRAWER)
                dobj->do_DrawerData = 0;
              if(dobj->do_ToolTypes && !(*dobj->do_ToolTypes))
                dobj->do_ToolTypes = 0;
            }

            if(os35mode)
            {
              if(PutIconTags(args->icon, dobj, ICONPUTA_NotifyWorkbench, TRUE, ICONPUTA_PreserveOldIconImages,
              FALSE, args->killnewicon ? ICONPUTA_DropNewIconToolTypes : TAG_IGNORE, TRUE, 
              args->killcoloricon ? ICONPUTA_DropChunkyIconImage : TAG_IGNORE, TRUE,
              args->optimize ? ICONPUTA_OptimizeImageSpace : TAG_IGNORE, TRUE,
              args->killiconimage ? ICONPUTA_DropPlanarIconImage :  TAG_IGNORE, TRUE, TAG_DONE))
                ret = RETURN_OK;
            }
            else if(PutDiskObject(args->icon, dobj))
              ret = RETURN_OK;
          } /* !args->view */

          if(imageBuffer[0])
            FreeVec(imageBuffer[0]);
          if(imageBuffer[1])
            FreeVec(imageBuffer[1]);
          FreeVec(tooltypes);
        } /* allocate tooltype temp array */
        if(dobjsrc)
          FreeDiskObject(dobjsrc);
      } /* open reficon */
      FreeDiskObject(dobjdrw);
    } /* open drawer disk object */
    FreeDiskObject(dobj);
  } /* open DiskObject */
  return ret;
}

LONG main(void)
{
  struct RDArgs *rda;
  struct Args args;
  struct Args argse;
  LONG ret = RETURN_FAIL, os35;

  memset(&args, 0, sizeof(struct Args));
  if((rda = ReadArgs(PARAM, (LONG *) &args, 0)))
  {
    struct Library *IconBase;
    if((IconBase = OpenLibrary("icon.library", 37)))
    {
      ULONG argerr = 0;

      TESTGROUP(0,                args.killcoloricon,   args.copycoloricon);
      TESTGROUP(0,                args.killdrawerdata,  args.copydrawerdata);
      TESTGROUP(args.setdeftool,  args.killdeftool,     args.copydeftool);
      TESTGROUP(0,                args.killiconimage,   args.copyiconimage);
      TESTGROUP(args.seticontype, 0,                    args.copyicontype);
      TESTGROUP(0,                args.killnewicon,     args.copynewicon);
      TESTGROUP(args.setstacksize,args.killstacksize,   args.copystacksize);
      TESTGROUP(0,                args.killtooltypes,   args.copytooltypes);

      TESTGROUP(args.ni2ci,       args.ii2ci,           args.mwb2ci);

      if((args.makeci || args.rom2ci) && (args.ii2ci || args.mwb2ci || args.ni2ci))
        ++argerr;

      if((args.rom2ci && args.makeci))
        ++argerr;

      if(args.unsnap && (args.setxpos || args.setypos))
        ++argerr;

      if(IconBase->lib_Version < 44 && (args.ni2ci || args.ii2ci || args.killcoloricon || args.copycoloricon
      || args.mwb2ci))
      {
        Printf("You need icon.library V44 or better for the CI options.\n");
       ++argerr;
      }

      if((args.ni2ci || args.mwb2ci || args.ii2ci) && (args.killcoloricon || args.copycoloricon))
        ++argerr;

      if(args.killnewicon && args.ni2ci)
        ++argerr;
      
      if(!args.reficon && (args.copydrawerdata || args.copydeftool || args.copyiconimage || args.copyicontype ||
      args.copynewicon || args.copystacksize || args.copytooltypes))
        ++argerr;

      if(argerr || (args.setbitplanes && args.killiconimage))
        SetIoErr(ERROR_TOO_MANY_ARGS);
      else
      {
        ULONG s;

        s = strlen(args.icon);
        if(!strncmp(args.icon+s-5, ".info",5))
          args.icon[s-5] = 0;
        if(args.reficon)
        {
          s = strlen(args.reficon);
          if(!strncmp(args.reficon+s-5, ".info",5))
          args.reficon[s-5] = 0;
        }

        os35 = IconBase->lib_Version >= 44 ? 1 : 0;
        if(!(ret = dowork(&args, IconBase, os35)))
        {
          if(!args.view && os35 && args.copynewicon)
          {
            memset(&argse, 0, sizeof(struct Args));
            argse.icon = args.icon;
            argse.reficon = args.reficon;
            argse.copynewicon = 1;
            ret = dowork(&argse, IconBase, 0);
          }
          if(!args.view && !args.showtype && args.ni2ci)
          {
            struct DiskObject *dobj;

            if((dobj = GetIconTags(args.icon, TAG_DONE)))
            {
              if(PutIconTags(args.icon, dobj, ICONPUTA_NotifyWorkbench, TRUE,
              ICONPUTA_DropNewIconToolTypes, TRUE, TAG_DONE));
                ret = RETURN_OK;
              FreeDiskObject(dobj);
            }
          }
        }
      } /* argument checks */
      CloseLibrary(IconBase);
    } /* open icon.library */
    FreeArgs(rda);
  } /* ReadArgs */
  if(ret)
    PrintFault(IoErr(), 0);
  return ret;
}

