#ifndef MAKE_ID
#define MAKE_ID(a,b,c,d) ((ULONG) (a)<<24 | (ULONG) (b)<<16 | (ULONG) (c)<<8 | (ULONG) (d))
#endif

/* Libraries */
#include <libraries/mui.h>
#include <libraries/gadtools.h> /* for Barlabel in MenuItem */
#include <libraries/asl.h>
#include <exec/memory.h>

/* Prototypes */
#include <proto/muimaster.h>
#include <proto/exec.h>
#include <proto/alib.h>
#include <proto/intuition.h>

#include "FinderV3GUI.h"

struct ObjApp * CreateApp(void)
{
	struct ObjApp * Object;

	APTR	MNlabel1Project, MNlabel1About, MNlabel1AboutMUI, MNlabel1BarLabel0, MNlabel1BarLabel1, MNlabel1Hide;
	APTR	MNlabel1Quit, MainMenuList, MainMenuSave, MainMenuBarLabel1, MainMenuPrint;
	APTR	MainRoot, ListGroup, StringGroup, DrawerGroup, DrawerLabel, obj_aux0;
	APTR	obj_aux1, ButtonGroup, AboutRoot, LogoImage;
   APTR  ConfigGroup, caselabel, recurselabel;
   APTR  Space_0, Space_1;

	if (!(Object = AllocVec(sizeof(struct ObjApp),MEMF_PUBLIC|MEMF_CLEAR)))
		return(NULL);

   Space_0 = HVSpace;

   Space_1 = HVSpace;

	Object->STR_AboutText = "\033cV3.1\n\033cby Chris Jones\n1997 Dynamic Software\nAll Rights Reserved.\n\n"
	"Update and AROS port by AROS Development Team\n\nPlease consult the docs for more info.";

	Object->FileList = ListObject,
		MUIA_Frame, MUIV_Frame_ReadList,
		MUIA_List_ConstructHook, MUIV_List_ConstructHook_String,
		MUIA_List_DestructHook, MUIV_List_DestructHook_String,
      MUIA_List_Title, " ",
	End;

	Object->FileList = ListviewObject,
		MUIA_HelpNode, "Usage",
		MUIA_Listview_Input, FALSE,
		MUIA_Listview_List, Object->FileList,
	End;

	ListGroup = GroupObject,
		MUIA_HelpNode, "Usage",
		MUIA_Frame, MUIV_Frame_Group,
		MUIA_FrameTitle, "Files found:",
		Child, Object->FileList,
	End;

	Object->STR_DrawerPopup = StringObject, MUIA_String_MaxLen, 80, End;

	Object->DrawerPopup = PopButton(MUII_PopDrawer);

	Object->DrawerPopup = PopaslObject,
		MUIA_HelpNode, "Usage",
		MUIA_Weight, 80,
		MUIA_ControlChar, 'd',
		MUIA_Popasl_Type, 0,
		MUIA_Popstring_String, Object->STR_DrawerPopup,
		MUIA_Popstring_Button, Object->DrawerPopup,
         ASLFR_TitleText, "Please choose a drawer to search...",
         ASLFR_DrawersOnly, TRUE,
	End;

	DrawerLabel = TextObject,
		MUIA_Text_PreParse, "\033r",
		MUIA_Text_Contents, "Drawer:",
		MUIA_Weight, 20,
		MUIA_ControlChar, 'd',
		MUIA_InnerLeft, 0,
		MUIA_InnerRight, 0,
	End;

	DrawerGroup = GroupObject,
		MUIA_HelpNode, "Usage",
		MUIA_Group_Horiz, TRUE,
		Child, DrawerLabel,
		Child, Object->DrawerPopup,
	End;

	Object->PatternStr = StringObject,
		MUIA_Frame, MUIV_Frame_String,
      MUIA_Weight, 80,
		MUIA_ControlChar, 'p',
		MUIA_HelpNode, "Usage",
      MUIA_String_MaxLen, 80,
	End;

	obj_aux1 = TextObject,
      MUIA_Text_PreParse, "\033r",
      MUIA_Text_Contents, "Pattern:",
      MUIA_Weight, 20,
      MUIA_ControlChar, 'p',
      MUIA_InnerLeft, 0,
      MUIA_InnerRight, 0,
   End;

	obj_aux0 = GroupObject,
		MUIA_Group_Columns, 2,
		Child, obj_aux1,
		Child, Object->PatternStr,
	End;

	StringGroup = GroupObject,
		MUIA_HelpNode, "Usage",
		Child, DrawerGroup,
		Child, obj_aux0,
	End;

	Object->FindBut = SimpleButton("_Find");

	Object->QuitBut = SimpleButton("_Quit");

	ButtonGroup = GroupObject,
		MUIA_HelpNode, "Usage",
		MUIA_Frame, MUIV_Frame_Group,
		MUIA_FrameTitle, "Actions:",
		MUIA_Group_Columns, 2,
		Child, Object->FindBut,
		Child, Object->QuitBut,
	End;

   caselabel = Label("Case sensitive");

   Object->casecheck = MUI_MakeObject(MUIO_Checkmark, NULL); 

   recurselabel = Label("Recursive");

   Object->recursecheck = MUI_MakeObject(MUIO_Checkmark, NULL);
   SetAttrs(Object->recursecheck, MUIA_Selected, TRUE, TAG_END);
   
   ConfigGroup = GroupObject,
      MUIA_HelpNode, "Usage",
      MUIA_Group_Horiz, TRUE,
      MUIA_Frame, MUIV_Frame_Group,
      MUIA_FrameTitle, "Search options:",
      Child, Space_0,
      Child, caselabel,
      Child, Object->casecheck,
      Child, recurselabel,
      Child, Object->recursecheck,
      Child, Space_1,
   End;

	MainRoot = GroupObject,
		Child, ListGroup,
      Child, ConfigGroup,
		Child, StringGroup,
		Child, ButtonGroup,
	End;

	MNlabel1About = MenuitemObject,
		MUIA_Menuitem_Title, "About...",
		MUIA_Menuitem_Shortcut, "?",
	End;

	MNlabel1AboutMUI = MenuitemObject,
		MUIA_Menuitem_Title, "About MUI...",
		MUIA_Menuitem_Shortcut, "M",
	End;

	MNlabel1BarLabel0 = MUI_MakeObject(MUIO_Menuitem, NM_BARLABEL, 0, 0, 0);

   MNlabel1BarLabel1 = MUI_MakeObject(MUIO_Menuitem, NM_BARLABEL, 0, 0, 0);

   MNlabel1Hide = MenuitemObject,
      MUIA_Menuitem_Title, "Hide",
      MUIA_Menuitem_Shortcut, "H",
   End;

	MNlabel1Quit = MenuitemObject,
		MUIA_Menuitem_Title, "Quit",
		MUIA_Menuitem_Shortcut, "Q",
	End;

	MNlabel1Project = MenuitemObject,
		MUIA_Menuitem_Title, "Project",
		MUIA_Family_Child, MNlabel1About,
		MUIA_Family_Child, MNlabel1AboutMUI,
		MUIA_Family_Child, MNlabel1BarLabel0,
      MUIA_Family_Child, MNlabel1Hide,
      MUIA_Family_Child, MNlabel1BarLabel1,
		MUIA_Family_Child, MNlabel1Quit,
	End;

	MainMenuSave = MenuitemObject,
		MUIA_Menuitem_Title, "Save",
		MUIA_Menuitem_Shortcut, "S",
	End;

	MainMenuBarLabel1 = MUI_MakeObject(MUIO_Menuitem, NM_BARLABEL, 0, 0, 0);

	MainMenuPrint = MenuitemObject,
		MUIA_Menuitem_Title, "Print",
		MUIA_Menuitem_Shortcut, "P",
	End;

	MainMenuList = MenuitemObject,
		MUIA_Menuitem_Title, "List",
		MUIA_Family_Child, MainMenuSave,
		MUIA_Family_Child, MainMenuBarLabel1,
		MUIA_Family_Child, MainMenuPrint,
	End;

	Object->MainMenu = MenustripObject,
		MUIA_Family_Child, MNlabel1Project,
		MUIA_Family_Child, MainMenuList,
	End;

	Object->MainWin = WindowObject,
		MUIA_Window_Title, "Finder V3.1",
		MUIA_Window_Menustrip, Object->MainMenu,
		MUIA_Window_ID, MAKE_ID('0', 'W', 'I', 'N'),
		MUIA_Window_AppWindow, TRUE,
		WindowContents, MainRoot,
	End;

	Object->AboutText = TextObject,
		MUIA_Background, MUII_TextBack,
		MUIA_Frame, MUIV_Frame_Text,
		MUIA_Text_Contents, Object->STR_AboutText,
		MUIA_Text_SetMin, TRUE,
	End;

	LogoImage = ImageObject,
		MUIA_Image_Spec, "5:PROGDIR:FinderLogo.iff",
		MUIA_Image_FreeVert, TRUE,
		MUIA_Image_FreeHoriz, TRUE,
		MUIA_FixHeight, 30,
		MUIA_FixWidth, 55,
	End;

	Object->OkButton = SimpleButton("_Continue");

	AboutRoot = GroupObject,
		MUIA_Background, MUII_RequesterBack,
      Child, LogoImage,
		Child, Object->AboutText,
		Child, Object->OkButton,
	End;

	Object->AboutWin = WindowObject,
		MUIA_Window_Title, "About Finder V3.1",
		MUIA_Window_ID, MAKE_ID('1', 'W', 'I', 'N'),
		MUIA_Window_CloseGadget, FALSE,
		MUIA_Window_SizeGadget, FALSE,
		MUIA_Window_NoMenus, TRUE,
		WindowContents, AboutRoot,
	End;

	Object->App = ApplicationObject,
		MUIA_Application_Author, "Chris Jones",
		MUIA_Application_Base, "FINDER",
		MUIA_Application_Title, "Finder V3.1",
		MUIA_Application_Version, "$VER: Finder 3.1 (06.03.2009)",
		MUIA_Application_Copyright, "Dynamic Software",
		MUIA_Application_Description, "File Finder",
      MUIA_Application_HelpFile, "HELP:FinderV3.guide",
		SubWindow, Object->MainWin,
		SubWindow, Object->AboutWin,
	End;


	if (!Object->App)
	{
		FreeVec(Object);
		return(NULL);
	}

	DoMethod(MNlabel1About,
		MUIM_Notify, MUIA_Menuitem_Trigger, MUIV_EveryTime,
		Object->AboutWin,
		3,
		MUIM_Set, MUIA_Window_Open, TRUE
		);

	DoMethod(MNlabel1AboutMUI,
		MUIM_Notify, MUIA_Menuitem_Trigger, MUIV_EveryTime,
      MUIV_Notify_Application, 2, MUIM_Application_AboutMUI,
      Object->MainWin
		);

	DoMethod(MNlabel1Quit,
		MUIM_Notify, MUIA_Menuitem_Trigger, MUIV_EveryTime,
		Object->App,
		2,
		MUIM_Application_ReturnID, MUIV_Application_ReturnID_Quit
		);

	DoMethod(MainMenuSave,
		MUIM_Notify, MUIA_Menuitem_Trigger, MUIV_EveryTime,
		Object->App,
		2,
		MUIM_Application_ReturnID, SaveList
		);

	DoMethod(MainMenuPrint,
		MUIM_Notify, MUIA_Menuitem_Trigger, MUIV_EveryTime,
		Object->App,
		2,
		MUIM_Application_ReturnID, PrintList
		);

   DoMethod(MNlabel1Hide,
      MUIM_Notify, MUIA_Menuitem_Trigger, MUIV_EveryTime,
      Object->App,
      3,
      MUIM_Set, MUIA_Application_Iconified, TRUE
      );

   DoMethod(Object->FindBut,
      MUIM_Notify, MUIA_Pressed, FALSE,
      Object->App,
      2,
      MUIM_Application_ReturnID, FindPressed
      );

	DoMethod(Object->MainWin,
		MUIM_Notify, MUIA_Window_CloseRequest, TRUE,
		Object->App,
		2,
		MUIM_Application_ReturnID, MUIV_Application_ReturnID_Quit
		);

	DoMethod(Object->QuitBut,
		MUIM_Notify, MUIA_Pressed, FALSE,
		Object->App,
		2,
		MUIM_Application_ReturnID, MUIV_Application_ReturnID_Quit
		);

#if 0
	DoMethod(Object->MainWin,
		MUIM_Window_SetCycleChain,
		Object->DrawerPopup,
		Object->PatternStr,
      Object->FileList,
		0
		);
#endif

	DoMethod(Object->OkButton,
		MUIM_Notify, MUIA_Pressed, FALSE,
		Object->AboutWin,
		3,
		MUIM_Set, MUIA_Window_Open, FALSE
		);

#if 0
	DoMethod(Object->AboutWin,
		MUIM_Window_SetCycleChain, Object->OkButton,
		0
		);
#endif

   set(Object->casecheck,
      MUIA_InputMode, MUIV_InputMode_Toggle
      );

   set(Object->recursecheck,
      MUIA_InputMode, MUIV_InputMode_Toggle
      );

	set(Object->MainWin,
		MUIA_Window_Open, TRUE
		);


	return(Object);
}

void DisposeApp(struct ObjApp * object)
{
	MUI_DisposeObject(object->App);
	FreeVec(object);
}
