#include "globalstuff.h"
#include "protos.h"


/* When NULL passed, the call comes from prefsWin, otherwise from a memo window */
void handle_menu( struct Memo *memo, UWORD code) {

    struct Window *win;
    struct Node *node;
    struct MenuItem* item;

    UWORD menuCode, menuNumber, itemNumber;

    if ( memo != NULL )
        win = memo->window;
    else
        win = prefsWin;

    /* Loop over all the menu selections in the menu code */
    for ( menuCode = code; menuCode != MENUNULL; menuCode = item->NextSelect )
    {
        item = ItemAddress( win->MenuStrip, menuCode);

        /* Extract the menu number and menu item number from the menu code */
        menuNumber = MENUNUM(menuCode);
        itemNumber = ITEMNUM(menuCode);

        /* Now decide what to do based on what menu item was selected */
        switch(menuNumber)
        {
            case 0:  /* 1st menu */
                switch(itemNumber)
                {
                    case NEWMEMO: {
                        mx = 0;
                        my = 0;

                        if ( get_lines( NULL ) > 0 )
                            open_newMemo();
                    } break;

                    case CLOSETHIS: {
                        if ( memo == NULL )
                            killPrefsWindow = TRUE;
                        else
                            killMemo = TRUE;
                    } break;

                    case ABOUT:
                        prompt( win, versionString, "Have Fun! :)" );
                        DisplayBeep( NULL );
                        break;
                    
                    case SAVE:
                        if ( count > 0 )
                            save_memos( fileName );
                        break;
                    
                    case SAVEQUIT: {
                        if ( count > 0 )
                            save_memos( fileName );

                        if ( memo == NULL )
                            killPrefsWindow = TRUE;

                        killAllMemos = TRUE;
                    } break;
                    
                    case EDIT:

                        /* Allow edit only when triggered from a Memo window */
                        if ( memo != NULL ) {
                            DisplayBeep( NULL );
                            editMode = TRUE;
                            memoToEdit = memo;

                            if ( !prefsWin )
                                open_prefsWindow();

                        }
                        break;

                    case QUIT: {
                        if ( memo == NULL )
                            killPrefsWindow = TRUE;

                        killAllMemos = TRUE;
                    } break;

                }

        } // switch-case

    }
}


/* Show a message */
BOOL prompt( struct Window *window, STRPTR title, STRPTR msg ) {

    struct EasyStruct easyStruct = {
        sizeof (struct EasyStruct),
        0,
        "",
        "",
        "OK",
    };

    easyStruct.es_Title = title;
    easyStruct.es_TextFormat = msg;

    if ( EasyRequest( window, &easyStruct, NULL, NULL ) != 0 ) {
        return TRUE;
    }

    return FALSE;
}

