/* $VER: 19.05.03 */

#include "globalstuff.h"
#include "protos.h"

#include <string.h>

/* Handle the IDCMP messages */
void handle_IDCMP() {

    struct IntuiMessage *intuiMsg;
    struct Message      *msg;
    struct Node         *node;
    struct Memo         *memoNode;
    struct Window       *win;

    ULONG                id, n = 0;
    ULONG                timerMask = 0, winPortMask = 0, sigs = 0;

    waiting = FALSE, editMode = FALSE;

    while (!quit)
    {

        if (timer) {

            timerMask = 1UL << timerPort->mp_SigBit;

            if ( !waiting ) {
                timeRequest->tr_node.io_Command = TR_ADDREQUEST;
                timeRequest->tr_time.tv_secs = DELAY;
                timeRequest->tr_time.tv_micro = 0;

                SendIO( (struct IORequest *)timeRequest );

                waiting = TRUE;
            }
        }

        winPortMask = 1UL << winPort->mp_SigBit;

        /* Wait for something to happen: */
        sigs = Wait( winPortMask | timerMask );

        if ( (sigs & winPortMask) ) {

            //while ( intuiMsg = (struct IntuiMessage *)GetMsg(winPort) )
            while ( (intuiMsg = GT_GetIMsg(winPort)) )
            {

                win = intuiMsg->IDCMPWindow;
                id = (ULONG) win->UserData;

                /* Look for corresponding memo node */
                node = memoList.lh_Head;
                while ( node->ln_Succ ) {

                    memoNode = (struct Memo *) node;

                    if ( memoNode->window == win )
                        break;

                    node = node->ln_Succ;
                }

                /* Msg from preferences window */
                if ( /*(node->ln_Succ == NULL) ||*/ (id == 1) ) {
                    //DPUTS( "prefs" );
                    handle_prefsWin( intuiMsg );
                } else if ( id > 1 ) {
                    handle_memoWin( intuiMsg, memoNode, win );
                } else {
                    DPUTS( "WTF?" );
                }

                /* Reply before possible deleting node and window */
                GT_ReplyIMsg( intuiMsg );
                //ReplyMsg( &(intuiMsg->ExecMessage) );

                if ( killMemo ) {
                    delete_memo( memoNode );
                    killMemo = FALSE;
                    if (count == 0)
                        quit = TRUE;
                }

                /* Destroy preferences window */
                if (killPrefsWindow) {
                    ClearMenuStrip( prefsWin );
                    CloseWindowSafely( prefsWin );
                    prefsWin = NULL;
                    killPrefsWindow = FALSE;
                    if ( count == 0 )
                        quit = TRUE;

                }

            } /* while() */

        } /* if() */

        /* Handle Timer */
        if ( waiting && timer && (sigs & timerMask) ) {

            while ( ( msg = (struct Message *) GetMsg( timerPort ) ) )
                timerMask = 0;

            handle_timer();
            waiting = FALSE;

        }

        /* Destroy all Memo windows */
        if (killAllMemos) {
            node = memoList.lh_Head;
            while ( node->ln_Succ ) {
                memoNode = (struct Memo *) node;
                node = node->ln_Succ;
                delete_memo( memoNode );
            }

            if ( count == 0 )
                quit = TRUE;        
        }

        /* Drawing double borders onto active Memo seemed to be a problem
                - I hope this solves it
        */
        if ( n == count )
            doubleBorders = TRUE;

    } // while

} /* handle_IDCMP() */


/* Handle IDCMP for preferences window */
void handle_prefsWin( struct IntuiMessage *intuiMsg ) {

    LONG                 sl1, sl2, t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, checked, content;
    struct Gadget       *gad;
    struct Gadget       *gadget = intuiMsg->IAddress;
    ULONG class = intuiMsg->Class;
    UWORD code = intuiMsg->Code;

    switch( class ) {

        case IDCMP_ACTIVEWINDOW:
            ActivateGadget( gadgetList->NextGadget, prefsWin, NULL);
        break;

        case IDCMP_GADGETUP:

            switch( gadget->GadgetID ) {

                case HOURSLIDER:
                        hours = code;
                    break;

                case MINUTESLIDER:
                        minutes = code;
                    break;

                case MEMOCOLOR:
                        memoColor = code;
                    break;

                case TEXTCOLOR:
                        textColor = code;
                    break;

                case TOGGLEALARM:
                    GT_GetGadgetAttrs(gadget, prefsWin, NULL,
                        GTCB_Checked, (LONG)&checked, TAG_DONE);
                        if ((BOOL)checked) {
                            alarm = TRUE;
                        }
                        else
                            alarm = FALSE;
                    break;

                case OKBUTTON:
                    gad = gadgetList->NextGadget;
                    while ( gad != NULL) {

                        switch ( gad->GadgetID ) {

                            case TEXT0:
                                GT_GetGadgetAttrs(gad, prefsWin, NULL,
                                    GTST_String, (ULONG)&t0, TAG_DONE);
                                    strcpy( text[0], (STRPTR)t0 );
                            break;


                            case TEXT1:
                                GT_GetGadgetAttrs(gad, prefsWin, NULL,
                                    GTST_String, (ULONG)&t1, TAG_DONE);
                                    strcpy( text[1], (STRPTR)t1 );
                            break;

                            case TEXT2:
                                GT_GetGadgetAttrs(gad, prefsWin, NULL,
                                    GTST_String, (ULONG)&t2, TAG_DONE);
                                    strcpy( text[2], (STRPTR)t2 );
                            break;

                            case TEXT3:
                                GT_GetGadgetAttrs(gad, prefsWin, NULL,
                                    GTST_String, (ULONG)&t3, TAG_DONE);
                                    strcpy( text[3], (STRPTR)t3 );
                            break;

                            case TEXT4:
                                GT_GetGadgetAttrs(gad, prefsWin, NULL,
                                    GTST_String, (ULONG)&t4, TAG_DONE);
                                    strcpy( text[4], (STRPTR)t4 );
                            break;

                            case TEXT5:
                                GT_GetGadgetAttrs(gad, prefsWin, NULL,
                                    GTST_String, (ULONG)&t5, TAG_DONE);
                                    strcpy( text[5], (STRPTR)t5 );
                            break;

                            case TEXT6:
                                GT_GetGadgetAttrs(gad, prefsWin, NULL,
                                    GTST_String, (ULONG)&t6, TAG_DONE);
                                    strcpy( text[6], (STRPTR)t6 );
                            break;

                            case TEXT7:
                                GT_GetGadgetAttrs(gad, prefsWin, NULL,
                                    GTST_String, (ULONG)&t7, TAG_DONE);
                                    strcpy( text[7], (STRPTR)t7 );
                            break;

                            case TEXT8:
                                GT_GetGadgetAttrs(gad, prefsWin, NULL,
                                    GTST_String, (ULONG)&t8, TAG_DONE);
                                    strcpy( text[8], (STRPTR)t8 );
                            break;

                            case TEXT9:
                                GT_GetGadgetAttrs(gad, prefsWin, NULL,
                                    GTST_String, (ULONG)&t9, TAG_DONE);
                                    strcpy( text[9], (STRPTR)t9 );
                            break;

                        }

                        gad = gad->NextGadget;
                    }

                    mx = 0;
                    my = 0;

                    if ( get_lines( NULL ) > 0 ) {
                        if (!editMode)
                            open_newMemo();
                        else {
                            edit_memo( memoToEdit );
                            editMode = FALSE;
                        }
                    }

                break;

                case SHOWCONTENT:
                    GT_GetGadgetAttrs(gadget, prefsWin, NULL, GTCB_Checked, (LONG)&content, TAG_DONE);
                    if ((BOOL)content)
                    {
                        showContent = TRUE;
                    } else {
                        showContent = FALSE;
                    }

                    break;

            }
            break;


        case IDCMP_REFRESHWINDOW:
            GT_BeginRefresh(prefsWin);
            GT_EndRefresh(prefsWin, TRUE);
            break;

        case IDCMP_MENUPICK:
            handle_menu( NULL, code );
        break;

        case IDCMP_CLOSEWINDOW:
            DPUTS("QUIT");
            killPrefsWindow = TRUE;
        break;

    } /* switch-case */

} /* handle_prefsWin()*/



/* Handle IDCMP for a memo window */
void handle_memoWin( struct IntuiMessage *intuiMsg, struct Memo *memoNode, struct Window *win) {

    ULONG class = intuiMsg->Class;
    UWORD code = intuiMsg->Code;
    
    static WORD x, y;
    static BOOL dragging = FALSE;

    switch( class ) {

        case IDCMP_REFRESHWINDOW:
            update_memo( memoNode );
        break;

        case IDCMP_MOUSEBUTTONS:
            switch( code ) {

                case SELECTDOWN:
                    x = intuiMsg->MouseX;
                    y = intuiMsg->MouseY;
                    dragging = TRUE;
                break;

                case SELECTUP:
                    ChangeWindowBox(win, screen->MouseX-x, screen->MouseY-y, win->Width, win->Height);
                    dragging = FALSE;
                break;

            } /* switch-case */
        break;

        case IDCMP_ACTIVEWINDOW:
            SetAPen(win->RPort, memoNode->textColor);

            /* Avoid the same back/foreground color! */
            if (memoNode->memoColor == memoNode->textColor)
                SetDrMd(win->RPort, COMPLEMENT);

            Move(win->RPort, 0, 0);
            Draw(win->RPort, win->Width-1, 0);
            Draw(win->RPort, win->Width-1, win->Height-1);
            Draw(win->RPort, 0, win->Height-1);
            Draw(win->RPort, 0, 1);

            SetDrMd(win->RPort, 0);

        break;

        case IDCMP_INACTIVEWINDOW:
            SetAPen(win->RPort, memoNode->memoColor);

            Move(win->RPort, 0, 0);
            Draw(win->RPort, win->Width-1, 0);
            Draw(win->RPort, win->Width-1, win->Height-1);
            Draw(win->RPort, 0, win->Height-1);
            Draw(win->RPort, 0, 1);

        break;

        case IDCMP_VANILLAKEY:

            switch( (UBYTE)code ) {

                case 's':
                case 'S':
                    if ( count > 0 )
                        save_memos( fileName );
                break;

                case 'z':
                case 'Z':
                    if (!memoNode->zipped) {
                        ChangeWindowBox(win, win->LeftEdge, win->TopEdge, ZIPWIDTH, ZIPHEIGHT);
                        memoNode->zipped = TRUE;
                    } else {
                        ChangeWindowBox(win, win->LeftEdge, win->TopEdge, memoNode->origWidth, memoNode->origHeight);
                        memoNode->zipped = FALSE;
                    }
                break;

                case 'q':
                case 'Q':
                    killMemo = TRUE;
                break;

                case 'n':
                case 'N':
                    if (!prefsWin)
                        open_prefsWindow();
                break;

                case 'b':
                case 'B':
                    WindowToBack(win);
                break;

                case 'f':
                case 'F':
                    WindowToFront(win);
                break;

                case 'e':
                case 'E':
                    
                    editMode = TRUE;
                    memoToEdit = memoNode;

                    if (!prefsWin)
                        open_prefsWindow();

                break;

                case '1':
                    MoveWindow(win, -8, 8);
                break;

                case '2':
                    MoveWindow(win, 0, 8);
                break;

                case '3':
                    MoveWindow(win, 8, 8);
                break;

                case '4':
                    MoveWindow(win, -8, 0);
                break;

                case '6':
                    MoveWindow(win, 8, 0);
                break;

                case '7':
                    MoveWindow(win, -8, -8);
                break;

                case '8':
                    MoveWindow(win, 0, -8);
                break;

                case '9':
                    MoveWindow(win, 8, -8);
                break;

                default:
                break;

            } /* switch-case*/
        break;


        case IDCMP_RAWKEY:

            switch ( (UBYTE) code ) {

                case CURSORUP:
                    MoveWindow(win, 0, -1);
                    break;

                case CURSORDOWN:
                    MoveWindow(win, 0, 1);
                    break;

                case CURSORLEFT:
                    MoveWindow(win, -1, 0);
                    break;

                case CURSORRIGHT:
                    MoveWindow(win, 1, 0);
                    break;

            } /* switch-case*/

        break;

        case IDCMP_MENUPICK:
            handle_menu( memoNode, code );
        break;

        case IDCMP_MOUSEMOVE:
            if ( dragging && showContent ) /* 'solid' window movement :) */
                ChangeWindowBox(win, screen->MouseX-x, screen->MouseY-y, win->Width, win->Height);
            
            break;

    } /* switch-case */

} /* handle_memoWin() */


/* Check for possible alarm */
void handle_timer() {

    struct Node *node;
    struct Memo *memoNode;

    UBYTE timeBuffer[6] = "00:00\0";

    GetSysTime( &tvSystem );
    Amiga2Date( (ULONG)tvSystem.tv_secs, &cdSystem );

    node = memoList.lh_Head;
    while ( node->ln_Succ ) {

        memoNode = (struct Memo *)node;

        if ( memoNode->alarm ) {

//           printf("Memo %lx has alarm set on %d:%d\n", (LONG)memoNode, (WORD)(memoNode->hours), (WORD)(memoNode->minutes));

            if ( ( cdSystem.hour == memoNode->hours ) &&
               ( cdSystem.min == memoNode->minutes ) ) {

                WindowToFront(memoNode->window);
                DisplayBeep( NULL );
//              printf("***ALARM! %lx***\n", (LONG)memoNode);

                /* Create a requester*/
                sprintf( timeBuffer, "%2d:%2d", (WORD)memoNode->hours, (WORD)memoNode->minutes);
                prompt( memoNode->window, "Memo Alarm!", timeBuffer );
                    
                memoNode->alarm = FALSE;
            }

        }

         node = node->ln_Succ; /* Next.. */
    } /* while */

}
