program fileOP;
{$MODE OBJFPC} {$H+}
uses sysutils, exec, AmigaDOS;

const
  template: pchar = 'COMMAND/A,OPTION(S)/A,HELP/K';

var
  fh: AmigaDOS.fileHandle;
  cmdStr: String;


procedure doHelp; //display some help for the command, it is also the roadmap.
Begin
WriteLn('');
WriteLn(paramStr(0));
WriteLn(': OPEN <mode> <filename>');
WriteLn(': CLOSE <handle>');
WriteLn(': READ <handle> <length> <fromPos>');
WriteLn(': WRITE <handle> <fromPos> <string>');
WriteLn(': SEEK <handle> <position> <offset mode>');
WriteLn(': IS <command>');
WriteLn('');
WriteLn('');
WriteLn('fileOP USAGE:');
WriteLn('');
WriteLn('  fileOP: OPEN <mode> <filename>               -  Open a file and return a handle for file.');
WriteLn('    set fh `fileOP OPEN NEW "text"`            -  ');
WriteLn('    modes are NEW, OLD, READWRITE              -  ');
WriteLn('                                           NEW - a new file is created, if a file exists it is erased');
WriteLn('                                           OLD - an existing file is opened');
WriteLn('                                     READWRITE - an existing file is opened otherwise a new one is created');
WriteLn('');
WriteLn('  fileOP: CLOSE <handle>                       -  close a file referenced by handle retrived from');
WriteLn('    fileOP CLOSE $fh                           -  OPEN');
WriteLn('');
WriteLn('  fileOP: READ <handle> <length>               -  read from file referenced by handle, number of');
WriteLn('    set sin `fileOP READ $fh 3`                -  chars actually read');
WriteLn('                                               -  will set fopResult to number of chars read');
WriteLn('                                               -  will write string to Shell CON:');
WriteLn('');
WriteLn('  fileOP: WRITE <handle> <string>              -  write to file referenced by handle, string to be');
WriteLn('    fileOP WRITE $fh "the new fox in town..."  -  be written');
WriteLn('                                               -  will set fopResult to number of chars written');
WriteLn('                                               -  will write number of chars written to Shell CON:');
WriteLn('');
WriteLn('  fileOP: SEEK <handle> <pos> <offs>           -  change the current position in file and reads');
WriteLn('                                               -  the current position, return position in file');
WriteLn('                                               -  before SEEK was called, position may be positive');
WriteLn('                                               -  or negative. Offset modes are CURRENT, BEGINNING');
WriteLn('                                               -  END.');
WriteLn('  fileOP SEEK $fh 0 "CURRENT"');
WriteLn('    will return current position in file');
WriteLn('');
WriteLn('  fileOP IS <DIRECTIVE>                        - allow for certain tests');
WriteLn('                                   INTERACTIVE - test to see if fileOP is bound to an interactive device');
WriteLn('    fileOP IS INTERACTIVE');
WriteLn('      will return 0 if interactive');
WriteLn('');
WriteLn('  Notes');
WriteLn('      1: in case of an error fileOP <COMMAND> will set fopResult to -1, if not stated otherwise');
WriteLn('      2: fopResult is only valid until next fileOperation call, when it may be overwritten');
WriteLn('');
WriteLn('  WARNING - on invalid handle your computer will most likely crash - WARNING');

End;

// Helper routines
function setLocalVar(sKey, sValue:String):LongInt;
Begin
  result:=LongInt(AmigaDOS.setVar( PChar(sKey), PChar(sValue), Length(sValue), GVF_LOCAL_ONLY ));
End;

function strToHandle(sHandle:string):AmigaDOS.filehandle;
var
  code: word;
Begin
    Val(sHandle, LongInt(fh), code);
    If code = 0 Then result:=AmigaDOS.fileHandle(fh) Else Result:=AmigaDOS.filehandle(-1);
End;


// core routines
function fopIS(sDirective:String):LongInt;
Begin
  Result:=-1;
  sDirective:=upperCase(sDirective);
  IF sDirective:='INTERACTIVE' Then
  Begin
    Result:=AmigaDOS.isInterActive(fh)
  End;

End;

function fopWrite(sHandle, sText: String): LongInt;
var
  P: Pchar;
Begin
  Result:=0;
  fh:=strToHandle(sHandle);
  IF fh <> AmigaDOS.fileHandle(-1) Then
  Begin
    P:=StrAlloc(Length(sText)+1);
    IF (StrPCopy(P, sText) = P) Then
    Begin
      Result:=DOSWrite(fh, P, Length(sText));
      StrDispose(P);
      setLocalVar('fopResult', IntToStr(Result));
    End;
  End;
  WriteLn(IntToStr(Result));
End;

function fopRead(sHandle, sLength:String):Integer;
var
  iLen: Integer;
  iErr: LongInt;
  code: Word;
  buf: PChar;
  sLen: String;
Begin
   Result:=-1;
   Val(sLength, iLen, code);
   IF code = 0 Then
   Begin
     fh:=strToHandle(sHandle);
     IF fh <> AmigaDOS.fileHandle(-1) Then
     Begin
       buf:=StrAlloc(iLen+1);
       result:=DOSRead(fh, buf, iLen+1);
       sLen:=IntToStr(result);
       setLocalVar('fopResult', sLen);
       buf[iLen]:=#0;
       WriteLn(StrPas(buf));
       StrDispose(buf);
     End; //if fh <>
   End; //If code
End;

function fopSeek(sHandle:String; sPos, sMode: String): Integer;
var
   iPos, iMode: Integer;
   code: word;
Begin
   Result:=-1;
   Val(sPos, iPos, code);
   IF code = 0 Then
   Begin
     fh:=strToHandle(sHandle);
     if fh <> AmigaDOS.fileHandle(-1) Then
     Begin
     sMode:=UpperCase(sMode);
       IF sMode = 'BEGINNING' Then iMode:=AmigaDOS.OFFSET_BEGINNING;
       IF sMode = 'CURRENT' Then iMode:=AmigaDOS.OFFSET_CURRENT;
       IF sMode = 'END' Then iMode:=AmigaDOS.OFFSET_END;
       Result:=DOSSeek(fh, ipos, iMode);
     End;
   End;
   writeLn(IntToStr(Result));
End;

function fopClose(sHandle: String): Boolean;
Begin
   fh:=strToHandle(sHandle);
   if fh <> AmigaDOS.fileHandle(-1) Then FileClose(LongInt(fh));
   writeLn(IntToStr(-1));
End;


function fopOpen(sMode, sFile:String): LongInt;
var
  iMode: Integer;
  P: PChar;
Begin
  iMode:=0;
    sMODE:=upperCase(sMode);
    IF sMode = 'NEW' Then iMode:= 1006;
    IF sMode = 'OLD' Then iMode:= 1005;
    IF sMode = 'READWRITE' Then iMode:= 1004;

    IF iMode <> 0 THEN
    Begin
      P:=StrAlloc(Length(sFile)+1);
      IF (StrPCopy(P, sFile) = P) Then
      Begin
        Result:=LongInt(DOSOpen(P, iMode));
        StrDispose(P);
      End;
    End;
    IF Result = 0 Then Result:= -1;
    WriteLn(IntToStr(Result));
End;

Begin //Main
  if paramStr(1) = '' Then Halt ;
  if paramStr(1) = '?' Then
  Begin
    WriteLn(template);
  End;

  cmdStr:=upperCase(paramStr(1));

  if cmdStr = 'HELP' Then doHelp;
  if cmdStr = 'OPEN' Then halt(LongInt(fopOpen(paramStr(2), paramStr(3))));
  if cmdStr = 'WRITE' Then halt(fopWrite(paramStr(2), paramStr(3)));
  if cmdStr = 'CLOSE' Then halt(LongInt(fopClose(paramStr(2))));
  if cmdStr = 'SEEK' Then halt(fopSeek(paramStr(2), paramStr(3), paramStr(4)));
  if cmdStr = 'READ' Then halt(fopRead(paramStr(2){fh}, paramStr(3){len}));
  if cmdStr = 'IS' Then halt(fopIS(paramStr(2)));
End.
