#!/bin/sh
# PI.sh

# #!/usr/local/bin/dash
# #!/bin/sh
# #!/bin/bash
# #!/bin/ksh
# #!/bin/zsh

# PI to the default 15 decimal places.
# 3.141592653589793

clear
echo 'Start...'
echo ''
echo 'Using integer maths only and fully POSIX compliant!'

# Nilakantha's series...
echo "Nilakantha Series: PI=3+(4/(2x3x4))-(4/(4x5x6))+(4/(6x7x8))-(4/(8x9x10))+..."
echo ''
PI_APPROX=3000000000000000
SWITCH_SIGN=1
POLARITY=0
K=2
LOOP=0
while [ ${LOOP} -le 21000 ]
do
	if [ ${PI_APPROX} -eq 3141592653589793 ]
	then
		break
	fi
	if [ $(( POLARITY%2 )) -eq 0 ]
	then
		SWITCH_SIGN="1"
	else
		SWITCH_SIGN="-1"
	fi
	PI_APPROX=$(( PI_APPROX+(1*(SWITCH_SIGN))*(4000000000000000/(K*(K+1)*(K+2))) ))
	POLARITY=$(( POLARITY+1 ))
	K=$(( K+2 ))
	LOOP=$(( LOOP+1 ))
done
printf "64 bit; PI to 15 decimal places = %.15f...\n" "${PI_APPROX}e-15"
echo "Number of loops = ${LOOP}."
echo ''
echo 'Stop...'

