/*-----------------------------------------------------------------------*/
/*
 CPU  Stress test 
 (Gunnar von Boehn) Feel free to do with the code what you want.

 The test is small but stresses the following CPU features:
 - DataCache
 - Conditional Code execution / Branch prediction
 - Loop acceleration  
 - Memory Hazard Detection

 = These are all important CPU features that are stressed.
 The test was taken from the internal test cases of the APOLLO CPU project.


 Compile with O2 
 E.g: gcc -o sort -O2 sortbench.c
 
 */
# include <stdio.h>
# include <stdlib.h>
# include <float.h>
# include <sys/time.h>
# define HLINE "-------------------------------------------------------------\n"



int count[32]={ 524799,2098175,4720127,8390655,
          13109759,18877439,25693695,33558527,
          42471935,52433919,63444479,75503615,
          88611327,102767615,117972479,134225919,
          151527935,169878527,189277695,209725439,
          231221759,253766655,277360127,302002175,
          327692799,354431999,382219775,411056127,
          440941055,471874559,503856639,536887295};


 
double mysecond() {
        struct timeval tp;
        struct timezone tzp;
        int i;

        i = gettimeofday(&tp,&tzp);
        return ( (double) tp.tv_sec + (double) tp.tv_usec * 1.e-6 );
}

/* 
 68K Code
  loop2:
       move.l  D2,D1        ;                                           1  -  
       move.l  (a0)+,D2      ; 2nd value in register D2     		1  1                      
       cmp.l   D1,D2        ; Compare values                            2  1 
       bge     noswap       ; Branch if greater than or equal to        3  -         
 doswap:
       exg     D1,D2        ;                                   	3  1
 noswap:
       move.l  D1,-8(a0)    ; Store 1st ordered values                  4  1            
       subq.l  #1,D6
       bge     d6,loop2     ; inner loop   				4  1
*/

void sort(int * data, int size){
    int D6,D7,D1,D2,D3; int * A0;   
    D7 = size-2;
loop1:
    A0 = data;
    D6 = D7;
    D2 = *A0++;
loop2:
    D1 = D2;
    D2 = *A0++;
    if( D1>D2 ){
      D3=D1; D1=D2; D2=D3;
    }
    *(A0-2) = D1;
    D6--; if( D6 > -1) goto loop2;
    *(A0-1) = D2;
    D7--; if( D7 > -1) goto loop1;
}

void bench(int size1){
    int i; double time1, time2;
    int * data;
    int * A0,A1;
    int size=size1*1024;
    int loops, loopsmax;

    data =malloc(size*4); // Malloc anough for array between 1KB to  64KB
    time1= mysecond(); 

    loopsmax=count[31]/count[size1-1];
    for(loops=loopsmax; loops>0 ; loops--){

      A0 = data;
      for (i=size; i>0 ; i--){
        *A0++=i;
      }
      sort(data, size);
    }
    time2= mysecond(); 

    printf("%2i K Element :  %6.2f MB/sec\n",size/1024, loopsmax*count[size1-1]/1024*8/(time2-time1)/1024 );
    free(data);
}
main() {
    int i;

    printf(HLINE);
    printf("SORTBENCH 1.1 (Gunnar von Boehn)\n");
    printf("Its a CPU benchmark that stresses CPU, DCache and branch prediction.\n");
    printf(HLINE);

    for (i=1; i<=32; i=i*2){
       bench(i);
    }
}
