#ifndef ZUNECALC_H
#define ZUNECALC_H

/*
**       $Filename: ZuneCalc.h $
**       $Release: 1 $
**       $Revision: 1.0 $
**       $Date: 10/11/09 $
**
**       (C) Copyright 2009 Yannick Erb
**       All Rights Reserved
*/

/*----------------------------------------------------------------------------*/
/*    Includes & Defines                                                      */
/*----------------------------------------------------------------------------*/

#include <math.h>                         /* standard C includes */
#include <stdio.h>
#include <string.h>

#include <exec/types.h>                   /* Amiga includes */
#include <libraries/mui.h>
#include <utility/hooks.h>

#include <clib/alib_protos.h>             /* C prototypes */
#include <proto/exec.h>                   /* Amiga prototypes */
#include <proto/muimaster.h>

#define MaxChars 11                 /* maximum number of characters in buffer */
#define BufferSize 100               /* the buffer is actually somewhat bigger */
                             /* in order to catch any overflow from sprintf() */

#define MAKEID(a,b,c,d) ((ULONG)(a)<<24|(ULONG)(b)<<16|(ULONG)(c)<<8|(ULONG)(d))
#ifndef __AROS__
#define ASM __saveds __asm
#define REG(x) register __ ## x
#endif

#define EQUALS 0L
#define PLUS 1L                   /* constants for use in 'switch' statements */
#define MINUS 2L                  /* and so on */
#define MULTIPLY 3L
#define DIVIDE 4L
#define SQRT 5L
#define SQUARE 6L
#define NEGATE 7L
#define ID_PI 8L
#define ID_RECALL 9L
#define ID_MEMPLUS 10L
#define ID_MEMMINUS 11L
#define ID_CLEAR 12L
#define ID_ALLCLEAR 13L
#ifdef __AROS__
#define PI 3.14159265359
#define CMDID 0
#else
#define CMDID 3
#endif

/*----------------------------------------------------------------------------*/
/*    Protos                                                                  */
/*----------------------------------------------------------------------------*/

int main(void);
static BOOL MakeMUIApp(void);
static APTR MakeButton(UBYTE *, UBYTE);
#ifndef __AROS__
static ASM void ProcessDigit(REG(a2) APTR, REG(a1) UBYTE *);
static ASM void DoOperation(REG(a2) APTR, REG(a1) ULONG *);
#else
AROS_UFP3(void, ProcessDigit,
AROS_UFPA(struct Hook *, h, A0),
AROS_UFPA(APTR, Object, A2),
AROS_UFPA(UBYTE *, Digit, A1));

AROS_UFP3(void, DoOperation,
AROS_UFPA(struct Hook *, h, A0),
AROS_UFPA(APTR , Object, A2),
AROS_UFPA(ULONG *, Operator, A1));
#endif
static void ClearBuffer(void);
static void DoError(void);
#ifndef __AROS__
static void UpdateDisplay(long do                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    