
; ----------------------------------------

; $VER: XFR tools startup v1 m68k source

; 2001 by PseudoDOS/silva@psi5.com
; (C) Andreas G. Szabo all rights reserved

; ----------------------------------------

		incdir	"include:"
		include	exec/funcdef.i
		include	"lvo.i"
		include	"f:xfr.i"
		include	"f:xfr_lib.i"
		include	"silva/easy.i"
		include	"exec/libraries.i"
		include	exec/exec_lib.i
		include	"dos/dosextens.i"
		include	"dos/dos_lib.i"
		include	"workbench/startup.i"


		section startup,code

		pushm	d0/a0

		move.l	4.w,a6

		; get wbmsg

		sub.l   a1,a1
		jsr	_LVOFindTask(a6)
		lea	_task(pc),a0
		move.l	d0,(a0)
		move.l	d0,a4
		tst.l	pr_CLI(a4)
		bne.b	.fromcli
		lea	pr_MsgPort(a4),a0
		jsr	_LVOWaitPort(A6)
		lea	pr_MsgPort(a4),a0
		jsr	_LVOGetMsg(A6)
		lea	wbmsg(pc),a0
		move.l	d0,(a0)
		beq.b	.fromcli
		addq.l	#8,a7
		lea	defaultargs(pc),a2
		moveq	#2,d2
		bra.b	.opendos

.fromcli	popm	d2/a2

		; open dos

.opendos	lea	doslibname(pc),a1
		moveq	#0,d0
		jsr	_LVOOpenLibrary(a6)
		lea	_dosbas(pc),a0
		move.l	d0,(a0)
		beq	ende

		move.l	d0,a6

		IFD	LEAVEARGLINEFEED_ASOFV37

		cmp.w	#37,LIB_VERSION(a6)
		bge.b	.console

		ENDC

		clr.b   -1(a2,d2.w)	; finish argline with NULL-byte
					; for lower os versions

.console	; output console window

		jsr	_LVOInput(a6)
		lea	inhandle(pc),a0
		move.l	d0,(a0)
		jsr	_LVOOutput(a6)
		lea	outhandle(pc),a0
		move.l	d0,(a0)
		bne.b	.outok
		move.l	wbmsg(pc),d0
		beq.b	.defcon
		move.l	d0,a0
		move.l	sm_ToolWindow(a0),d1
		beq.b	.defcon
		move.l	d1,a0
		tst.b	(a0)
		beq.b	.defcon
		bra.b	.opencon
.defcon		lea	conname(pc),a0
		move.l	a0,d1
.opencon	move.l	#1006,d2
		jsr	_LVOOpen(a6)
		lea	conhandle(pc),a0
		move.l	d0,(a0)
		beq	.closedos
		lea	outhandle(pc),a0
		move.l	d0,(a0)+
		move.l	d0,(a0)+
.outok
		move.l	outhandle(pc),d1
		jsr	_LVOIsInteractive(a6)
		lea	isinteractive(pc),a0
		move.w	d0,(a0)

		jsr	Program

		move.l	_dosbas(pc),a6
		move.l	conhandle(pc),d3
		beq.b	.closedos
		lea	txt_mayclose(pc),a0
		bsr	print
.anykey_lp	move.l	d3,d1
		moveq	#50,d2	; 50 microsekunden auf zeichen warten
		jsr	_LVOWaitForChar(a6)
		tst.w	d0
		beq.b	.anykey_lp
		;bsr	inputs	; flush input
		move.l	conhandle(pc),d1
		jsr	_LVOClose(a6)

.closedos	move.l	a6,a1
		move.l	$4.w,a6
		jsr	_LVOCloseLibrary(a6)

		move.l	wbmsg(pc),d2
		beq.b   ende
		jsr	_LVOForbid(a6)
		move.l  d2,a1
		jsr	_LVOReplyMsg(a6)

ende		move.l	_errorcode(pc),d0
		rts

wbmsg		dc.l	0

_errorcode	dc.l	0
_task		dc.l	0
_dosbas		dc.l	0
conhandle	dc.l	0
outhandle	dc.l	0
inhandle	dc.l	0

isinteractive	dc.w	0

defaultargs	dc.b	"?",$a,0
doslibname	dc.b	"dos.library",0
conname		dc.b	"RAW:////XFR tools/CLOSE",0
txt_mayclose	dc.b	"[any key or close]",0
		even

		;section	prog,code

		IFD	REQUESTXFRVERSION
XFRVERSION	SET	REQUESTXFRVERSION
		ENDC

Program
		; open xfr.library

		move.l	4.w,a6
		lea	libname(pc),a1
		moveq	#XFRVERSION,d0
		jsr	_LVOOpenLibrary(a6)
		lea	_xfrbas(pc),a0
		move.l	d0,(a0)
		beq.b	.noxfr
		move.l	d0,a6

		IFND	NOTITLE

		lea	txt_whiteonblue(pc),a0
		bsr	style

		lea	isinteractive(pc),a0
		tst.w	(a0)
		beq.b	.libverstring

		bsw	xfrBB_NEXTRUN,xfrB_flags(a6)
		bne.b	.toolverstring

.libverstring	move.l	LIB_IDSTRING(a6),a0
		bsr	print

.toolverstring	lea	XFRTOOL_VERSTRING(pc),a0
		bsr	print

		lea	txt_normcol(pc),a0
		bsr	style
		bsr	newline

		ENDC

		bsr	XFRTOOL_PROGRAM

.closexfr	move.l	_xfrbas(pc),a1
		move.l	xfrB_sysbase(a1),a6
		jsr	_LVOCloseLibrary(a6)
		bra.b	.rts

.noxfr		lea	txt_nolib(pc),a0
		bsr	print

.rts		rts

libname		XFRNAME
txt_nolib	dc.b	"Please insert xfrmaster.library >= v",$30+XFRVERSION," into libs:",0
txt_whiteonblue	dc.b	$9b,"0;32;43m",0
txt_normcol	dc.b	$1b,"[0m",0
txt_bold	dc.b	$9b,"1;31m",0
txt_blue	dc.b	$9b,"0;33m",0
txt_white	dc.b	$9b,"0;32m",0
txt_underlined	dc.b	$1b,"[4m",0
txt_3linesup	dc.b	$b,$b,$b,0
txt_newline	dc.b	$a,0
		even

printi		;do only print on screen
		push	a0
		lea	isinteractive(pc),a0
		tst.w	(a0)
		pop	a0
		beq.b	nodo

print		bsr.b	printc

newline		pushm	d0-d3/a0/a1/a6
		move.l	_dosbas(pc),a6
		lea	txt_newline(pc),a0
		move.l	a0,d2
		move.l	outhandle(pc),d1
		moveq	#1,d3
		jsr	_LVOWrite(a6)
		popm	d0-d3/a0/a1/a6
nodo		rts

printfmt	bsr.b	printfmtc
		bra.b	newline

printfmtc	movem.l	a1-a4,-(a7)
		move.l	a7,a1
		bsr.b	printfc
		movem.l	(a7)+,a1-a4
		rts

printf		bsr.b	printfc	
		bra.b	newline

style		; test interactivity
		push	a0
		lea	isinteractive(pc),a0
		tst.w	(a0)
		pop	a0
		beq.b	nodo

printc		; a0 null terminated string
		pushm	d0-d3/a0/a1/a6
		move.l	a0,d2
		moveq	#-1,d0
.size		tst.b	(a0)+
		dbeq	d0,.size
		not.l	d0
		beq.b	.null
		move.l	d0,d3
		move.l  outhandle(pc),d1
		beq.b	.null
		move.l	_dosbas(pc),a6
		jsr	_LVOWrite(a6)
.null		popm	d0-d3/a0/a1/a6
		rts

printfc		; a0 *string, a1 *datasream
		pushm	d0-d1/a0-a2/a6
		move.l	_xfrbas(pc),a6
		jsr	_LVOxfrStringFormat(a6)
		tst.l	d0
		beq.b	.notext
		move.l	d0,a0
		bsr	printc
		move.l	a0,a1
		jsr	_LVOxfrMFree(a6)
.notext		popm	d0-d1/a0-a2/a6
		rts

_xfrbas		dc.l	0

;xfrtool:	; program follows here in main file
		; after including this startup code
