
; ----------------------------------------

; $VER: XFR tools v1 m68k source

;	xfrscan

; 2001 by PseudoDOS/silva@psi5.com
; (C) Andreas G. Szabo all rights reserved

; ----------------------------------------

		incdir	"include:"
		include	"dos/dos.i"
		include	"workbench/startup.i"
		include	"dos/dosextens.i"
		include	"exec/tasks.i"
LEAVEARGLINEFEED_ASOFV37

		include	"f:xfrtools_startup.asm"

			dc.b	"$VER: "
XFRTOOL_VERSTRING

			; pay attention for size ----------------->"

	dc.b	"xfrscan 1.3, 4/2003, (C) Andreas G. Szabo         ",0
	even


; some notes:
;
; erstedatei              142234 OK

;   modul1                  4323 generic Amiga Tracker
;   infotext......................................................
;
;   modul2                   123 Startrekker 8 channels
;
; zweitedatei		   31234 Future Composer 1.4
; drittedatei             236541 <=======------>


XFRTOOL_PROGRAM
		; we get	a6	*xfrbase
		;		_xfrbas	*xfrbase
		;	print		a0 *string
		;	newline
		;	printfmt	a0 *string, a1-a4 subcontent
		;	printc		same as print without newline
		;	printtab	like printc with d0 tabsize
		;	style		interactive output sensitive printc

		lea	args_array,a4
		bsr.b	.prog

		tst.w	break(a4)
		beq.b	.rts

		lea	txt_break(pc),a0
		bra	print

.prog		move.l	wbmsg(pc),d0
		beq.b	.fromcli

		move.l	d0,a0
		move.l	sm_NumArgs(a0),d3
		move.l	sm_ArgList(a0),a3
		subq.l	#2,d3		; if there are more than 1 icons
		bmi.b	.wbusage	; selected, then (1=0 for counter)
		addq.l	#8,a3		; skip the program itself
.wbarg_lp	move.l	(a3)+,d7	; wa_Lock
		move.l	(a3)+,a2	; wa_Name
		pushm	d3/a3
		tst.b	(a2)
		bne.b	.wb_file
		bsr.b	.fileinfo	; this is for wb dir icons
		bra.b	.wbarg_lpc
.wb_file	move.l	d7,d1		; this is allways the dir lock
		move.l	_dosbas(pc),a6
		jsr	_LVOCurrentDir(a6)	; this is a file
		bsr.b	.lockit
.wbarg_lpc	popm	d3/a3
		tst.w	break(a4)
		bne.b	.rts
		dbf	d3,.wbarg_lp
.rts		rts
.wbusage	lea	.txt_wb(pc),a0
.print		bra	print

.usage		; print usage

		lea	.txt_usage(pc),a0
		bra.b	.print

.sourcenotready	dc.b	"Error: source %s not ready.",$a,0
.destnotready	dc.b	"Error: destination directory %s not ready.",$a,0

.txt_wb		dc.b	"Select xfrscan together with other file "
		dc.b	"and directory icon(s) in order to xfrscan them "
		dc.b	"or use xfrscan from shell.",$a
		dc.b	$a
		dc.b	"At wb usage of in this version of xfrscan you can "
		dc.b	"only list the found contents. Use from shell to save them.",$a
		dc.b	$a

.txt_usage	dc.b	"xfrscan <source> [<source2> ...] [to <destination>]",$a
		dc.b	$a
		dc.b	"     <source>: file(s) and/or directory(s), may be mixed",$a
		dc.b	"<destination>: save directory (no destination = verbose)",$a
		dc.b	$a
		;dc.b	"Warning! ZAP mode does delete all source files! If input is",$a
		;dc.b	"a directory, _everything_ in it will be DELETED!",$a
		;dc.b	$a
		dc.b	"With E or EXCLUDE you may add a name pattern of files that",$a
		dc.b	"must not be scanned.",$a
		dc.b	$a
		dc.b	"Alternative sources may be DISK <drivenum>, CHIP or FAST.",$a
		dc.b	$a
.args_template	dc.b	"SOURCES/M,E=EXCLUDE/K,DISK=DRIVE/K/N,CHIP=CHIPMEM/K/S,FAST=FASTMEM/K/S,RAM=MEMORY=MEM/K/S,TO=SAVETO,D=DEEP/K/S,H=HYBRID/K/S,ODD/K/S,P=PCSTYLENAMES/K/S,OVERWRITE/K/S,COMPACT/K/S",0
		even

 STRUCTURE	myargs,0
		APTR	a_files
		APTR	a_exclude
		ULONG	a_drive
		ULONG	a_chipmem
		ULONG	a_fastmem
		ULONG	a_memory
		APTR	a_dest
		ULONG	a_deep
		ULONG	a_hybrid
		ULONG	a_odd
		ULONG	a_endfix
		ULONG	a_overwrite
		;ULONG	a_zap
		ULONG	a_compact
		UWORD	break
		UWORD	dirhasfiles
		ULONG	numdel
		ULONG	filesize
		ULONG	filename

.fromcli	cmp.b	#"?",(a2)
		beq.b	.usage

		tst.b	(a2)
		beq.b	.incurrentdir

		; read command line args

		lea	.args_template(pc),a0
		move.l	a0,d1
		moveq	#0,d3

;.readargs	may go(sub) here from wb to oltypes

		; rdargs = ReadArgs(d1 template, d2 array, d3 NULL)
		; FreeArgs(d1 rdargs)

		move.l	_dosbas(pc),a6

		include	"exec/libraries.i"

		cmp.w	#37,LIB_VERSION(a6)
		blt.b	.lockit

		move.l	a4,d2

		jsr	_LVOReadArgs(a6)

		push	d0

		lea	saveobject_tags(pc),a0
		move.l	a_endfix(a4),pcstyle_flag-saveobject_tags(a0)
		move.l	a_overwrite(a4),overwrite_flag-saveobject_tags(a0)

		move.l	a_dest(a4),d1
		beq.b	.odd

		moveq	#ACCESS_READ,d2
		move.l	_dosbas(pc),a6
		jsr	_LVOLock(a6)
		move.l	d0,destlock
		bne.b	.odd

		lea	.destnotready(pc),a0
		move.l	a_dest(a4),a1
		bsr	printdoserr_io
		bra.b	.freeargs

.odd		move.l	_xfrbas(pc),a6

		tst.w	a_odd(a4)
		beq.b	.disk
		btw	xfrBB_ODDCPU,xfrB_flags(a6)
		bne.b	.disk
		lea	error_cpu(pc),a0
		bsr	print
		bra.b	.unlockif

.disk		move.l	a_drive(a4),d0
		beq.b	.memory
		move.l	d0,a0
		move.l	(a0),d0
		move.l	d0,a1
		lea	reading_drive(pc),a0
		bsr	printfmtc
		tst.w	isinteractive
		bne.b	.create_disk
		bsr	newline
.create_disk	moveq	#xfrOBJECT_DISK,d1
		jsr	_LVOxfrCreateObject(a6)
		lea	txt_cr(pc),a0
		bsr	style
		tst.l	d0
		ble.b	.doscan_disk
		move.l	d0,a0
		move.l	xfrO_size(a0),filesize(a4)
		move.l	xfrO_name(a0),filename(a4)
.doscan_disk	bsr	DoScan
		bra.b	.unlockif

.memory		tst.l	a_memory(a4)
		beq.b	.chipmem
		moveq	#xfrOBJECT_RAM,d1
		bsr.b	.create_mem
		bra.b	.unlockif

.chipmem	tst.l	a_chipmem(a4)
		beq.b	.fastmem
		moveq	#xfrOBJECT_CHIPMEM,d1
		bsr.b	.create_mem

		tst.w	break(a4)
		bne.b	.unlockif

		tst.l	a_fastmem(a4)
		beq.b	.unlockif
		moveq	#xfrOBJECT_CHIPMEM,d1
		bra.b	.create_mem


.fastmem	tst.l	a_fastmem(a4)
		beq.b	.excl
		moveq	#xfrOBJECT_FASTMEM,d1
		bsr.b	.create_mem
		bra.b	.unlockif

.create_mem	jsr	_LVOxfrCreateObject(a6)

		move.l	d0,d1
		ble.b	.doscan_mem
.mems_loop	tst.w	break(a4)
		bne.b	.mems_rts
		move.l	d0,a0

		move.l	xfrO_next(a0),d1
		clr.l	xfrO_next(a0)

		move.l	xfrO_size(a0),d3
		move.l	d3,filesize(a4)
		push	d0
		move.l	xfrO_start(a0),d2
		add.l	d2,d3
		movem.l	d2/d3,-(a7)
		move.l	xfrO_name(a0),-(a7)
		move.l	a7,a1
		lea	txt_namegimmick(pc),a0
		jsr	_LVOxfrStringFormat(a6)
		lea	12(a7),a7
		move.l	d0,filename(a4)
		pop	d0
.doscan_mem	push	d1
		bsr	DoScan
		pop	d0
		bgt.b	.mems_loop
.mems_rts	rts

.excl		move.l	a_exclude(a4),d1
		beq.b	.exclude_ok

		move.l	d1,a0
		moveq	#0,d3
.lenlp		addq.w	#1,d3
		cmp.b	#"+",(a0)
		bne.b	.test0
		move.b	#$7c,(a0)
.test0		tst.b	(a0)+
		bne.b	.lenlp
		add.l	d3,d3
		addq.l	#4,d3
		move.l	d3,d0
		jsr	_LVOxfrMAlloc(a6)

		move.l	d0,parsed
		beq.b	.exclude_ok

		move.l	d0,d2

		move.l	_dosbas(pc),a6
		jsr	_LVOParsePatternNoCase(a6)
		tst.l	d0
		bge.b	.exclude_ok

		lea	pattern_error(pc),a0
		bsr	print
		bra.b	.fertig
.exclude_ok

.sources	move.l	a_files(a4),d1
		bne.b	.files

		bsr.b	.incurrentdir
		bra.b	.fertig

.files		move.l	d1,a3
		moveq	#0,d1

.schlaufe	move.l	(a3)+,d0
		beq.b	.fertig

		bset	#1,d1
		bne.b	.title
		tst.l	(a3)
		beq.b	.notitle
.title		move.l	d0,a1
		lea	txt_title(pc),a0
		bsr	printfmt
.notitle
		move.l	d0,a2
		pushm	d1/a3
		bsr.b	.lockit
		popm	d1/a3

		tst.w	break(a4)
		bne.b	.fertig

		tst.l	(a3)
		beq.b	.fertig
		bsr	newline
		bra.b	.schlaufe

.fertig		;move.l	numdel(a4),d0
		;beq.b	.unlockif
		;lea	num_del(pc),a0
		;move.l	d0,a1
		;bsr	printfmt

.unlockif	move.l	destlock,d1
		beq.b	.freeparsed
		move.l	_dosbas(pc),a6
		jsr	_LVOUnLock(a6)

.freeparsed	move.l	parsed,d0
		beq.b	.freeargs
		move.l	d0,a1
		move.l	_xfrbas(pc),a6
		jsr	_LVOxfrMFree(a6)

.freeargs	pop	d1
		beq.b	.rts1
		move.l	_dosbas(pc),a6
		jmp	_LVOFreeArgs(a6)

.lockit		; comes here from both shell and wb for each input file
		; or dir except shell currentdir

		move.l	a2,d1

		move.l	_dosbas(pc),a6
		moveq	#ACCESS_READ,d2
		jsr	_LVOLock(a6)
		move.l	d0,d7
		beq	.dirnotready

		bsr	.fileinfo

		move.l	d7,d1
		move.l	_dosbas(pc),a6
		jmp	_LVOUnLock(a6)

.rts1		rts

.dirnotready	lea	.sourcenotready(pc),a0
		move.l	a2,a1
		bra	printdoserr_io

.incurrentdir	move.l	_task(pc),a0
		move.l	pr_CurrentDir(a0),d7

.fileinfo	move.l	#fib_SIZEOF,d0
		move.l	_xfrbas(pc),a6
		jsr	_LVOxfrMAlloc(a6)
		move.l	d0,d5
		beq	.rts1

		move.l	d7,d1
		move.l	d5,d2
		move.l	d5,a5
		move.l	_dosbas(pc),a6
		jsr	_LVOExamine(a6)
		tst.l	d0
		beq.b	.ioerror

		tst.l	fib_DirEntryType(a5)
		bgt.b	.scan_dir

		lea	fib_FileName(a5),a0
		move.l	a0,filename(a4)
		move.l	fib_Size(a5),filesize(a4)
		bsr	proc_file

		bra.b	.freefib

.scan_dir	move.l	destlock,d2
		beq.b	.intodir
		move.l	d7,d1

		jsr	_LVOSameLock(a6)
		cmp.l	#LOCK_SAME,d0
		bne.b	.intodir

		move.l	a_dest(a4),a1
		lea	txt_locksame(pc),a0
		bsr	printfmt
		bra.b	.freefib

.intodir	move.l	d7,d1
		jsr	_LVOCurrentDir(a6)
		push	d0

.files_loop	move.l	d7,d1
		move.l	a5,d2
		move.l	_dosbas(pc),a6
		jsr	_LVOExNext(a6)
		tst.l	d0
		beq.b	.ioerror_dir
		tst.l	fib_DirEntryType(a5)	; Verzeichnis?
		bgt.b	.files_loop

		lea	fib_FileName(a5),a2
		move.l	a2,filename(a4)
		move.l	fib_Size(a5),filesize(a4)
		bsr	proc_file

		move.w	#-1,dirhasfiles(a4)

		;tst.w	break(a4)brauchts nur wenn noch maus
		;bne.b	.leavedir stop wre zb oder bei fehler

		move.l	_task(pc),a1
		btl	SIGBREAKB_CTRL_C,TC_SIGRECVD(a1)
		beq.b	.files_loop

		move.w	#-1,break(a4)
		bra.b	.leavedir

.ioerror_dir	jsr	_LVOIoErr(a6)

		cmp.l	#ERROR_NO_MORE_ENTRIES,d0
		bne.b	.doserr_dir

		tst.w	dirhasfiles(a4)
		bne.b	.leavedir
		lea	no_files(pc),a0
		bsr	print
		bra.b	.leavedir

.doserr_dir	bsr	printdoserr

.leavedir	pop	d1
		move.l	_dosbas(pc),a6
		jsr	_LVOCurrentDir(a6)

		clr.w	dirhasfiles(a4)
		bra.b	.freefib

.ioerror	jsr	_LVOIoErr(a6)

		cmp.l	#ERROR_NO_MORE_ENTRIES,d0
		beq.b	.freefib

		bsr	printdoserr

.freefib	move.l	a5,a1
		move.l	_xfrbas(pc),a6
		jmp	_LVOxfrMFree(a6)

proc_file	; when it is a pathed name, the wohle filename with path
		; comes in a2 because its not simple to lock unto its dir;
		; when it is but a file name it is also in a2;
		; fib_FileName(a5) is allways name only

		;push	a2
		;bsr.b	.work_on_file
		;pop	d1

		; then maybe delete file

		;tst.l	a_zap(a4)
		;beq.b	.rts

		;addq.l	#1,numdel(a4)

		;move.l	_dosbas(pc),a6
		;jmp	_LVODeleteFile(a6)

.work_on_file	; exclude pattern names, needs 1564 bytes of stack !
		; (stack check is done by dos)

		move.l	parsed,d1
		beq.b	.scanfile
		move.l	filename(a4),a0
		move.l	a0,d2
		move.l	_dosbas(pc),a6
		jsr	_LVOMatchPatternNoCase(a6)
		tst.l	d0
		beq.b	.pterr

.rts		rts		; want a "rne" instruction code

.pterr		jsr	_LVOIoErr(a6)
		tst.l	d0
		beq.b	.scanfile

		lea	pattern_error(pc),a0
		bra	print

.scanfile	move.l	a2,a0

		; create object

		moveq	#0,d0
		moveq	#xfrOBJECT_FILE,d1
		move.l	_xfrbas(pc),a6
		jsr	_LVOxfrCreateObject(a6)

DoScan		; list item to scan
		bsr	printitemline
		;^does not change d0^

		push	d0
		ble.b	.error

		move.l	d0,a1

		lea	scanhook(pc),a2

		moveq	#xfrMODEF_HOOK,d1

		tst.l	a_odd(a4)
		beq.b	.noOdd
		bset	#xfrMODEB_SCANODD,d1
.noOdd
		tst.l	a_hybrid(a4)
		bne.b	.hybrid
		tst.l	a_deep(a4)
		beq.b	.normal
		bset	#xfrMODEB_DEEP,d1
		bra.b	.normal
.hybrid		bset	#xfrMODEB_HYBRID,d1
.normal		jsr	_LVOxfrScan(a6)
		move.l	(a7),a2	;*object

		tst.w	isinteractive
		beq.b	.what
		lea	txt_cr(pc),a0
		bsr	printc
		bsr	printitemline

.what		tst.l	d0
		bne.b	.error

		lea	txt_ready(pc),a0	; (can be OK with xvs)
		tst.l	xfrO_firstchild(a2)
		bne.b	.report
		lea	txt_nothing(pc),a0
		bra.b	.report

.error		cmp.w	#xfrRETURN_SCANSTOP,d0
		bne.b	.ifdos
		move.w	#-1,break(a4)

.ifdos		cmp.w	#xfrERROR_DOS,d0
		bne.b	.getertext

		sub.l	a0,a0
		bsr	printdoserr_io
		bra.b	.list

.getertext	jsr	_LVOxfrGetErrorText(a6)
		move.l	d0,a0

.report		; write information behind scanned file

		bsr	print

		; list contents found

.list		moveq	#1,d2		; activate blank line

		move.l	xfrO_firstchild(a2),d0
		beq.b	.free
.child_loop	move.l	d0,a2

		tst.l	a_compact(a4)
		bne.b	.foundline

		tst.w	d2		; test for blank line nice
		beq.b	.foundline

		moveq	#0,d2
	; uncomment to get blank lines between contents
	;	bsr	newline

.foundline	; make and print found line

		move.l	a7,a3
		move.l	_xfrbas(pc),a6
		move.l	xfrB_defaultname(a6),-(a7)
		tst.w	xfrO_state(a2)
		bmi.b	.sel_template
		move.l	xfrO_name(a2),d0
		beq.b	.sel_template
		move.l	d0,(a7)
.sel_template	lea	txt_foundcolumn(pc),a0
		move.l	xfrO_size(a2),-(a7)
		bgt.b	.mode
		addq.l	#4,a7
		lea	txt_foundcolumn_unknownsize(pc),a0
.mode		pea	txt_null(pc)
		btw	xfrOB_BYDEEP,xfrO_flags(a2)
		beq.b	.format
		lea	txt_deep(pc),a1
		move.l	a1,(a7)
.format		move.l	xfrO_format(a2),a1
		move.l	xfrF_short(a1),-(a7)
		move.l	a7,a1
		bsr	printf
		move.l	a3,a7

.info		; eventually print info

		btw	xfrOB_ERRORTEXT,xfrO_flags(a2)
		bne.b	.list_error
		move.l	xfrO_text(a2),d0
		beq.b	.list_error
		move.l	d0,a1
		lea	txt_margin(pc),a0
		bsr	printfmt
		moveq	#1,d2		; activate blank line

.list_error	; eventually print error

		move.w	xfrO_state(a2),d0
		bge.b	.save
		tst.l	destlock
		bne.b	.save
		btw	xfrOB_ERRORTEXT,xfrO_flags(a2)
		beq.b	.getetx
		move.l	xfrO_text(a2),a1
		bra.b	.list_printerr
.getetx		move.l	_xfrbas(pc),a6
		jsr	_LVOxfrGetErrorText(a6)
		move.l	d0,a1
.list_printerr	lea	txt_error(pc),a0
		bsr	printfmt
		moveq	#1,d2		; activate blank line

.save		move.l	destlock,d1	; default do not save anything 
		beq.b	.nextchild

		move.l	_dosbas(pc),a6
		jsr	_LVOCurrentDir(a6)
		push	d0

		sub.l	a0,a0
		move.l	a2,a1
		push	a2
		lea	saveobject_tags(pc),a2
		move.l	_xfrbas(pc),a6
		jsr	_LVOxfrSaveObjectTagList(a6)
		pop	a2

		tst.w	d0
		bge.b	.to_olddir

		moveq	#1,d2		; activate blank line

		lea	txt_saveerror(pc),a0

		btw	xfrOB_ERRORTEXT,xfrO_flags(a2)
		bne.b	.save_custerr

		cmp.w	#xfrERROR_DOS,d0
		bne.b	.xfrsaverr

		bsr.b	printdoserr_io

		bra.b	.to_olddir

.save_custerr	bsr	printc
		move.l	xfrO_text(a2),a0
		bsr	print
		bra.b	.to_olddir

.xfrsaverr	bsr	printc
		jsr	_LVOxfrGetErrorText(a6)
		move.l	d0,a0
		bsr	print

.to_olddir	pop	d1
		move.l	_dosbas(pc),a6
		jsr	_LVOCurrentDir(a6)

.nextchild	move.l	xfrO_next(a2),d0
		bne.b	.child_loop

		tst.l	a_compact(a4)
		bne.b	.free
		bsr	newline

.free		pop	d0
		ble.b	.rts
		move.l	d0,a1
		move.l	_xfrbas(pc),a6
		jmp	_LVOxfrFreeObjects(a6)

.rts		rts

printdoserr_io	; wenn a0 NULL kein text davor; a1 darf %s sein
		pushm	a0/a1
		move.l	_dosbas(pc),a6
		jsr	_LVOIoErr(a6)
		popm	d1/a1
		tst.l	d1
		beq.b	printdoserr
		move.l	d1,a0
		bsr	printfmtc
printdoserr	; d0 DOS errorcode
		cmp.w	#36,LIB_VERSION(a6)
		bge.b	.printfault
		move.l	d0,a1
		lea	txt_ioerr(pc),a0
		bra	printfmt
.printfault	move.l	d0,d1
		moveq	#0,d2
		jmp	_LVOPrintFault(a6)

printitemline	move.l	filesize(a4),-(a7)
		move.l	filename(a4),-(a7)
		lea	txt_filecolumn(pc),a0
		move.l	a7,a1
		bsr	printfc
		addq.l	#8,a7
		rts

scanhook	subq.w	#1,da_time
		beq.b	.checkbreak
		rts

.break		moveq	#xfrRETURN_SCANSTOP,d0
		rts

.checkbreak	move.l	_task(pc),a1
		btl	SIGBREAKB_CTRL_C,TC_SIGRECVD(a1)
		bne.b	.break

.rota		move.w	#2000,da_time
		lea	rota(pc),a1
		move.w	da_num-rota(a1),d1
		lea	txt_pos(pc),a0
		bsr	style
		lea	(a1,d1.w),a0
		bsr	style
		addq.w	#2,d1
		cmp.w	#8,d1
		blt.b	.back
		moveq	#0,d1
.back		move.w	d1,da_num-rota(a1)
		rts

rota		dc.b	$5c,0
		dc.b	"|",0
		dc.b	"/",0
		dc.b	"-",0
da_num		dc.w	0
da_time		dc.w	2000
txt_pos		dc.b	$d,$9b,"49",$43,0

saveobject_tags	dc.l	XFR_OVERWRITE
overwrite_flag	dc.l	0
		dc.l	XFR_ADDNUMBER,-1
		dc.l	XFR_FIXNAME,-1
		dc.l	XFR_PCSTYLENAME
pcstyle_flag	dc.l	0
		dc.l	TAG_END

reading_drive	dc.b	"reading drive %ld...",0
no_files	dc.b	"no files",0
num_del		dc.b	"%ld files deleted",0
error_cpu	dc.b	"Byte step only with 68020+ CPU/emulation.",0
pattern_error	dc.b	"Error: exclude pattern failed.",0
txt_locksame	dc.b	"Error: cannot scan directory %s equals destination.",0
txt_title	dc.b	"processing %s",0
txt_filecolumn	dc.b	"%-39s %8ld ",0
txt_namegimmick	dc.b	"%s $%lx-$%lx",0
txt_ready	dc.b	"found contents:",0		; OK with xvs
txt_nothing	dc.b	"nothing found",0
txt_foundcolumn	dc.b	" %-30s %6s %8ld %s",0
txt_foundcolumn_unknownsize	dc.b	" %-30s %6s  unknown %s",0
txt_deep	dc.b	"(DEEP)",0
txt_margin	dc.b	"  %s",0
txt_error	dc.b	"  Error: %s",0
txt_saveerror	dc.b	"  NOT SAVED. ",0
txt_ioerr	dc.b	"DOS i/o error #%ld",0
txt_break	dc.b	"*** user break ***",0
txt_cr		dc.b	$d
txt_null	dc.b	0
		even

		section	"data",bss

destlock	dc.l	0
parsed		dc.l	0
args_array	blk.l	13,0
		dc.w	0	; break
		dc.w	0	; dirhasfiles
		dc.l	0	; numdel
		dc.l	0	; filesize
		dc.l	0	; filename

		END
