
; ----------------------------------------

; $VER: XFR tools v1 m68k source

;	xfrlist

; 2001 by PseudoDOS/silva@psi5.com
; (C) Andreas G. Szabo all rights reserved

; ----------------------------------------

		incdir	"include:"
		include	"dos/dos.i"
		include	"workbench/startup.i"
		include	"dos/dosextens.i"
LEAVEARGLINEFEED_ASOFV37
		include	"f:xfrtools_startup.asm"

			dc.b	"$VER: "
XFRTOOL_VERSTRING

	; -------------- maintain size --------------------------->"

	dc.b	"xfrlist 1.3, 7/2004, (C) Andreas G. Szabo         ",0
	even

XFRTOOL_PROGRAM
		; we get	a6	*xfrbase
		;		_xfrbas	*xfrbase
		;	print		a0 *string
		;	newline
		;	printfmt	a0 *string, a1-a4 subcontent
		;	printc		same as print without newline
		;	printtab	like printc with d0 tabsize
		;	style		interactive output sensitive printc
		;	printf		a1* datastream

		lea	args_array(pc),a4

		; lister

		move.l	wbmsg(pc),d0
		beq.b	.fromcli

		move.l	d0,a0
		move.l	sm_NumArgs(a0),d3
		move.l	sm_ArgList(a0),a3
		subq.l	#2,d3		; if there are more than 1 icons
		bmi.b	.wbusage	; selected, then (1=0 for counter)
		addq.l	#8,a3		; skip the program itself
.wbarg_lp	move.l	(a3)+,d7	; wa_Lock
		move.l	(a3)+,a2	; wa_Name
		pushm	d3/a3
		tst.b	(a2)
		bne.b	.wb_singlefile
		bsr.b	.list
		bra.b	.wbarg_lpc
.wb_singlefile	move.l	d7,d1
		move.l	_dosbas(pc),a6
		jsr	_LVOCurrentDir(a6)
		bsr.b	.lockit
.wbarg_lpc	popm	d3/a3
		dbf	d3,.wbarg_lp
		rts
.wbusage	lea	.txt_wb(pc),a0
.print		bra	print


 STRUCTURE	myargs,0		; globals structure here
		APTR	a_files
		ULONG	a_brombeere
		ULONG	a_text
		UWORD	break
		APTR	filename


.fromcli	lea	.usagetxt(pc),a0
		cmp.b	#"?",(a2)
		beq.b	.print

		tst.b	(a2)
		beq.b	.incurrentdir

		; read command line args

		lea	.args_template(pc),a0
		move.l	a0,d1
		moveq	#0,d3

;.readargs	may go(sub) here from wb to oltypes

		; rdargs = ReadArgs(d1 template, d2 array, d3 NULL)
		; FreeArgs(d1 rdargs)

		move.l	_dosbas(pc),a6

		include	"exec/libraries.i"

		cmp.w	#37,LIB_VERSION(a6)
		blt.b	.compat

		move.l	a4,d2

		jsr	_LVOReadArgs(a6)

		push	d0

		move.l	a_files(a4),d1
		bne.b	.files

		bsr.b	.incurrentdir
		bra.b	.fertig

.files		move.l	d1,a3
		moveq	#0,d1

.schlaufe	move.l	(a3)+,d0
		beq.b	.fertig

		bset	#1,d1
		bne.b	.title
		tst.l	(a3)
		beq.b	.notitle
.title		move.l	d0,a1
		lea	.txt_title(pc),a0
		bsr	printfmt
.notitle
		move.l	d0,a2
		pushm	d1/a3
		bsr.b	.lockit
		popm	d1/a3

		tst.w	break(a4)
		bne.b	.fertig

		tst.l	(a3)
		beq.b	.fertig
		bsr	newline
		bra.b	.schlaufe

.fertig		pop	d1
		beq.b	.rts
		move.l	_dosbas(pc),a6
		jmp	_LVOFreeArgs(a6)

.compat		cmp.b	#$22,(a2)
		bne.b	.lockit

		addq.l	#1,a2
		move.l	a2,a0
.toend		tst.b	(a0)+
		bne.b	.toend
		clr.b	-2(a0)

.lockit		move.l	a2,d1

		move.l	_dosbas(pc),a6
		moveq	#ACCESS_READ,d2
		jsr	_LVOLock(a6)
		move.l	d0,d7
		beq	.dirnotready

		bsr	.list

		move.l	d7,d1
		move.l	_dosbas(pc),a6
		jmp	_LVOUnLock(a6)

.rts		rts


.dirnotready	lea	.txt(pc),a0
		move.l	a2,a1
		bra	printfmt

.txt		dc.b	"Directory %s not ready.",0
.txt_wb		dc.b	"Select xfrlist together with other file "
		dc.b	"and directory icon(s) in order to xfrlist them "
		dc.b	"or use xfrlist from shell:",$a
		dc.b	$a
.usagetxt	dc.b	"xfrlist [<source>] [<source2> ...]",$a
		dc.b	$a
		dc.b	"Where a source may be directory or file.",$a
		dc.b	$a
.args_template	dc.b	"DIRECTORY/M,BROMBEERE/K/S,TEXT/K/S",0
.txt_title	dc.b	"processing %s",0
		even

.incurrentdir	move.l	_task(pc),a0
		move.l	pr_CurrentDir(a0),d7

.list		move.l	#fib_SIZEOF,d0
		move.l	_xfrbas(pc),a6
		jsr	_LVOxfrMAlloc(a6)
		move.l	d0,d5
		beq	.rts

		move.l	d7,d1
		move.l	d5,d2
		move.l	d5,a5
		move.l	_dosbas(pc),a6
		jsr	_LVOExamine(a6)
		tst.l	d0
		beq.b	.ioerror

		tst.l	fib_DirEntryType(a5)
		bgt.b	.list_dir

		move.l	a2,a0
		bsr	.list_file

		bra.b	.freefib

.list_dir	move.l	d7,d1
		jsr	_LVOCurrentDir(a6)
		push	d0

.files_loop	move.l	d7,d1
		move.l	d5,d2
		move.l	_dosbas(pc),a6
		jsr	_LVOExNext(a6)
		tst.l	d0
		beq.b	.ioerror_dir
		tst.l	fib_DirEntryType(a5)	; Verzeichnis?
		bgt.b	.files_loop

		lea	fib_FileName(a5),a0
		bsr	.list_file

		move.l	_task(pc),a1
		btl	SIGBREAKB_CTRL_C,TC_SIGRECVD(a1)
		beq.b	.files_loop

		lea	txt_userbreak(pc),a0
		bsr	print
		move.w	#-1,break(a4)

		bra.b	.leavedir

.ioerror_dir	jsr	_LVOIoErr(a6)

		cmp.l	#ERROR_NO_MORE_ENTRIES,d0
		beq.b	.leavedir

		lea	_errorcode(pc),a0
		move.l	d0,(a0)

.leavedir	pop	d1
		move.l	_dosbas(pc),a6
		jsr	_LVOCurrentDir(a6)

		bra.b	.freefib

.ioerror	jsr	_LVOIoErr(a6)

		cmp.l	#ERROR_NO_MORE_ENTRIES,d0
		beq.b	.freefib

		lea	_errorcode(pc),a0
		move.l	d0,(a0)

.freefib	move.l	d5,a1
		move.l	_xfrbas(pc),a6
		jmp	_LVOxfrMFree(a6)

.list_file	move.l	a0,filename(a4)
		tst.l	a_brombeere(a4)
		beq.b	.minfile
.wholefile	moveq	#xfrOBJECT_FILE,d1
		bra.b	.readfile
.minfile	moveq	#xfrOBJECT_MINFILE,d1
.readfile	moveq	#0,d0
		move.l	_xfrbas(pc),a6
		jsr	_LVOxfrCreateObject(a6)
		push	d0
		ble.b	.error

		move.l	d0,a1
		move.l	d0,a2
		moveq	#xfrMODEF_HYBRID,d1
		jsr	_LVOxfrIdentify(a6)
		tst.l	d0
		bgt.b	.report

		cmp.w	#xfrERROR_OUTOFDATA,d0
		bne	.size_errors

		pop	a1
		jsr	_LVOxfrFreeObjects(a6)
		move.l	filename(a4),a0
		bra	.wholefile

.size_errors	cmp.w	#xfrERROR_SIZELARGER,d0
		beq.b	.report

		cmp.w	#xfrERROR_MISSINGEND,d0
		beq.b	.report

.error		pea	txt_null(pc)
		tst.l	d0
		beq.b	.unknown
		jsr	_LVOxfrGetErrorText(a6)
		move.l	d0,-(a7)
		bra.b	.tell_sizeok
.unknown	pea	txt_null(pc)
		bra.b	.tell_sizeok

.report		move.w	xfrO_flags(a2),d0
		btst	#xfrOB_BYDEEP,d0
		beq.b	.byplain
		pea	txt_deep(pc)
		bra.b	.tell
.byplain	pea	txt_null(pc)
.tell		move.l	xfrO_format(a2),a1
		move.l	xfrF_short(a1),-(a7)
		move.l	xfrO_size(a2),d0	; d0 calculated size

	; zero indicates that size could not be calculated
	; (format flag xfrFF_SIZE is meant as an attempt will be done
	; but the flag alone does not ensure that we really get it)

		bne	.has_size
		lea	txt_dirline_ns(pc),a0
		bra	.tell_nosize

.has_size	move.l	fib_Size(a5),d1		; d1 file size
		cmp.l	d0,d1
		beq.b	.tell_sizeok
		move.l	d0,-(a7)	; push calcluated size on stack
		cmp.l	d0,d1
		blt.b	.size_lesser
		add.l	#256,d0
		cmp.l	d0,d1
		bgt.b	.much_greater
		pea	txt_greater(pc)
		bra.b	.tell_size
.much_greater	pea	txt_muchgreater(pc)
		bra.b	.tell_size
.size_lesser	sub.l	#256,d0
		cmp.l	d0,d1
		blt.b	.much_lesser
		pea	txt_lesser(pc)
		bra.b	.tell_size
.much_lesser	pea	txt_muchlesser(pc)
.tell_size	lea	txt_dirline(pc),a0
		moveq	#1,d6
		bra.b	.tell_std

.tell_sizeok	lea	txt_dirlineA(pc),a0
.tell_nosize	moveq	#0,d6

.tell_std	move.l	fib_Size(a5),-(a7)
		pea	fib_FileName(a5)

		move.l	a7,a1
		bsr	printf
		lea	4*4(a7),a7
		tst.w	d6
		beq.b	.stackok
		lea	2*4(a7),a7
.stackok
		tst.l	(a7)	; no object because of error -> no text
		ble.b	.ntext	; unknown object allways has xfrO_text empty
		move.l	xfrO_text(a2),d0
		beq.b	.ntext
		lea	txt_text(pc),a0
		bsr	printc
		move.l	d0,a0
		bsr	print
.ntext
		; BROMBEERE list samples

		tst.l	a_brombeere(a4)
		beq.b	.bbok
		move.l	(a7),a1
		tst.w	xfrO_state(a1)
		beq.b	.bbok
		jsr	_LVOxfrExtract(a6)
		tst.l	d0
		beq.b	.bbok
		bgt.b	.bblist
		cmp.l	#xfrERROR_FORMAT,d0
		beq.b	.bbok
		jsr	_LVOxfrGetErrorText(a6)
		move.l	d0,a0
		bsr	print
		bra.b	.bbok
.bblist		lea	txt_sample(pc),a3
		tst.l	a_text(a4)
		beq.b	.bb
		lea	txt_samtext(pc),a3
.bb		move.l	(a7),a2
		move.l	xfrO_firstchild(a2),d0
		beq.b	.bbok
.bbloop		move.l	d0,a2
		move.l	xfrO_size(a2),-(a7)
		move.l	xfrO_name(a2),-(a7)
		move.l	a3,a0
		move.l	a7,a1
		bsr	printfc
		lea	2*4(a7),a7
		move.l	xfrO_next(a2),d0
		bne.b	.bbloop
		bsr	newline
.bbok	
		pop	d0
		ble.b	.rts
		move.l	d0,a1
		;move.l	_xfrbas(pc),a6
		jmp	_LVOxfrFreeObjects(a6)

txt_userbreak	dc.b	"*** user break ***",0
txt_dirline	dc.b	"%-27s %8ld %s %ld %s%s",0
txt_dirlineA	dc.b	"%-27s %8ld %s%s",0
			; %-24.24.s
txt_dirline_ns	dc.b	"%-27s %8ld (no size) %s%s",0
txt_sample	dc.b	"%s %ld, ",0
txt_samtext	dc.b	"%s ",0
;txt_space	dc.b	" ",0
;txt_continued	dc.b	"",0
txt_greater	dc.b	">",0
txt_lesser	dc.b	"<",0
txt_muchgreater	dc.b	$9b,"1;32m",">",$1b,"[0m",0
txt_muchlesser	dc.b	$9b,"1;32m","<",$1b,"[0m",0
txt_null	dc.b	0
txt_deep	dc.b	" (DEEP)",0
txt_text	dc.b	"text: ",0
		even

args_array	dc.l	0	; dir here
		dc.l	0	; brombeere flag
		dc.l	0	; text flag
		dc.w	0	; break
		dc.l	0	; filename

		END
