
; ----------------------------------------

; $VER: XFR tools v1 m68k source

;	xfrlibinfo

; 2001 by PseudoDOS/silva@psi5.com
; (C) Andreas G. Szabo all rights reserved

; ----------------------------------------

		include	"f:xfrtools_startup.asm"

			dc.b	"$VER: "
XFRTOOL_VERSTRING

	dc.b	"xfrlibinfo 1.3, 7/2004, (C) Andreas G. Szabo      ",0
	even

XFRTOOL_PROGRAM
		; we get	a6	*xfrbase
		;		_xfrbas	*xfrbase
		;	print		a0 *string
		;	newline
		;	printfmt	a0 *string, a1-a4 subcontent
		;	printc		same as print without newline
		;	printtab	like printc with d0 tabsize
		;	style		interactive output sensitive printc

		cmp.b	#"?",(a2)
		bne.b	.options

		; usage

		lea	txt_usage(pc),a0
		bsr	print
		lea	note_formats(pc),a0
		bsr	print
		lea	note_usefull(pc),a0
		bsr	print
		bsr	newline
		lea	note_command_c(pc),a0
		bsr	print
		lea	note_clients(pc),a0
		bsr	print
		lea	note_usefull(pc),a0
		bra	print

.options	move.l	a2,a0			; argument
		move.l	a2,a1

		; dechiffre options

		moveq	#0,d0

.find_option	move.b	d0,d1
		move.b	(a0)+,d0
		beq.b	.command
		cmp.b	#"-",d0
		bne.b	.find_option

		; check after

		move.b	(a0)+,d0
		beq.b	.command

		; only nothing or space before option sign

		tst.b	d1
		beq.b	.options_loop
		cmp.b	#" ",d1
		bne.b	.command

		; set name end (can and may be)

		move.b	#1,-3(a0)

		moveq	#0,d1
.options_loop	cmp.b	#"f",d0
		bne.b	.false_option
		moveq	#-1,d1

		move.b	(a0)+,d0
		beq.b	.set_options
		cmp.b	#" ",d0
		bne.b	.options_loop

		; in argstr skip to after options when there was a space

		move.l	a0,a1

.set_options	lea	options(pc),a0
		move.b	d1,(a0)
		bra.b	.command

.false_option	lea	txt_falseopt(pc),a0
		clr.l	-(a7)
		move.l	a7,a1
		move.b	d0,(a1)
		bsr	printfmt
		addq.l	#4,a7
		rts

.command	; dechiffre command and forward rest of argument

		move.l	a2,a0

		; it may be at the end

.to_end		tst.b	(a0)+
		bne.b	.to_end
		subq.l	#3,a0
		cmp.l	a2,a0
		blt.b	.check_at_start
		cmp.b	#" ",(a0)+
		bne.b	.check_at_start
		move.b	(a0),d0

		; set name end (can and may be)

		move.b	#1,-(a0)

		move.l	a2,a0

		; may be .switch_command, .skip_postspace jumped from
		; here does skip spaces that are before name

		bra.b	.switch_command

.check_at_start	move.l	a2,a0

.skip_prespace	move.b	(a0)+,d0
		beq.b	.default
		cmp.b	#" ",d0
		beq.b	.skip_prespace

		; end after single char, may be a command, go switch

		tst.b	(a0)
		beq.b	.switch_command

		; non-space chars after char,
		; then is not a command, go default

		cmp.b	#" ",(a0)
		bne.b	.default

		; when the option was after command before name,
		; skip to name from after option

		cmp.l	a1,a2
		beq.b	.skip_postspace
		move.l	a1,a0

.skip_postspace	tst.b	(a0)
		beq.b	.switch_command
		cmp.b	#" ",(a0)+
		beq.b	.skip_postspace

		subq.l	#1,a0

.switch_command	cmp.b	#"c",d0
		bne.b	.default

		move.l	a0,a2
		bra.b	clients

.default	bra	formats

clients		tst.b	(a2)
		beq.b	.all

		move.l	xfrB_clients(a6),d3
.find_loop	move.l	d3,a5

		move.l	xfrC_filename(a5),a3
		bsr	matchpart
		bne	.find_next

		lea	txt_underlined(pc),a0
		bsr	style

		lea	.title_client(pc),a0
		bsr	print

		lea	txt_normcol(pc),a0
		bsr	style

		bsr	printclientfile
		sub.l	a1,a1
		move.w	xfrC_version(a5),a1
		lea	txt_clientver(pc),a0
		bsr	printfmt
		bsr	newline

		move.l	xfrC_short(a5),d0
		beq.b	.novers
		lea	txt_clientvers(pc),a0
		bsr	printc
		move.l	d0,a0
		bsr	print
.novers
		move.l	xfrC_long(a5),a0
		move.l	a0,d0
		bne.b	.long
		lea	txt_noinfo(pc),a0
.long		bra	print


.find_next	move.l	xfrC_next(a5),d3
		bne.b	.find_loop

.all		lea	.title_clientsu(pc),a0
		lea	.txt_clientsu(pc),a1

		tst.w	isinteractive
		bne.b	.printtitle

		lea	.title_clients(pc),a0
		lea	.txt_clients(pc),a1

.printtitle	bsr	printfmt

		move.l	xfrB_clients(a6),d3
.clients_loop	move.l	d3,a5

		bsr	printclient

		move.l	_task(pc),a1
		btl	SIGBREAKB_CTRL_C,TC_SIGRECVD(a1)
		beq.b	.nextclient
		lea	txt_break(pc),a0
		bsr	print
		bra.b	.clients_end

.nextclient	move.l	xfrC_next(a5),d3
		bne.b	.clients_loop

.clients_end	bsr	newline

		lea	note_clients(pc),a0
		bsr	printi
		lea	note_usefull(pc),a0
		bra	printi

.title_client	dc.b	"client info:",$a,0
.txt_clients	dc.b	"clients are:",0
.title_clients	dc.b	"%-36sversion:",$a,0
.txt_clientsu	dc.b	$1b,"[4m","clients are:",$1b,"[0m",0
.title_clientsu	dc.b	"%-44s",$1b,"[4m","version:",$1b,"[0m",$a,0
txt_clientline	dc.b	"%-41s%3ld",0
		even


printclientfile	lea	txt_filename(pc),a0
		bsr	printc

		lea	txt_white(pc),a0
		bsr	style

		move.l	xfrC_filename(a5),a1

		tst.l	xfrC_id(a5)
		bne.b	.extern

		lea	txt_internpath(pc),a0
		bra.b	.print

.extern		lea	txt_path(pc),a0

.print		bsr	printfmt

		lea	txt_normcol(pc),a0
		bra	style

printclient	lea	xfrC_filename(a5),a1

		tst.l	xfrC_id(a5)
		bne.b	.extern

		lea	txt_internpath(pc),a0
		bra.b	.print

.extern		lea	txt_path(pc),a0

.print		jsr	_LVOxfrStringFormat(a6)
		tst.l	d0
		beq	style
		move.l	d0,a1
		sub.l	a2,a2
		move.w	xfrC_version(a5),a2
		lea	txt_clientline(pc),a0
		bsr	printfmt
		jmp	_LVOxfrMFree(a6)

matchpart	; a2	*part
		; a3	*string
		;>d0	eq matched
.m_loop		move.l	a3,a1
		move.l	a2,a0		; argument
.m_lp1		move.b	(a0)+,d0
		beq.b	.end_of_name

		; skip a quotation mark

		cmp.b	#$22,d0
		beq.b	.m_lp1

		; $1 is end of name as set from option or command parse

		cmp.b	#1,d0
		beq.b	.end_of_name

.option_is_end	; option in argstr is end of name in argstr

		cmp.b	#" ",d0
		bne.b	.read_dest
		cmp.b	#"-",(a0)
		beq.b	.end_of_name

.read_dest	move.b	(a1)+,d1	; read defined name
		beq	.not_matched

		cmp.b	#"a",d0		; align case
		blt.b	.case
		cmp.b	#"z",d0
		bgt.b	.case
		bclr	#5,d0
.case		cmp.b	#"a",d1
		blt.b	.comp
		cmp.b	#"z",d1
		bgt.b	.comp
		bclr	#5,d1
.comp		cmp.b	d0,d1		; compare two chars
		beq.b	.m_lp1

		; with full name option (-f) a name may match only
		; from the beginning (thats part of what full means)

		tst.b	options
		bne.b	.not_matched

		addq.l	#1,a3		; nchste position im zielstring
		bra.b	.m_loop

.end_of_name	tst.b	(a1)
		beq.b	.matched

		tst.b	options
		bne.b	.not_matched

.matched	moveq	#0,d0
		rts
.not_matched	moveq	#-1,d0
		rts


formats		tst.b	(a2)
		beq.b	.all

		move.l	xfrB_formats(a6),d3
.find_loop	move.l	d3,a5

		move.l	xfrF_short(a5),a3
		bsr	matchpart
		bne	.find_next

		lea	txt_underlined(pc),a0
		bsr	style

		lea	.title_format(pc),a0
		bsr	print

		lea	txt_normcol(pc),a0
		bsr	style

		lea	txt_bold(pc),a0
		bsr	style

		bsr	.printformat
		bsr	newline

		move.l	xfrF_id(a5),d0
		beq.b	.noid
		lea	.formatid(pc),a0
		bsr	printc
		lea	txt_white(pc),a0
		bsr	style
		move.l	d0,a0
		bsr	print
		lea	txt_normcol(pc),a0
		bsr	style
.noid
		lea	.point(pc),a0
		lea	.nullstring(pc),a1
		move.l	a1,a2
		move.l	a1,a3
		move.l	a1,a4
		move.l	xfrF_prefix(a5),d1
		beq.b	.noprefix
		move.l	d1,a1
		move.l	a0,a2
.noprefix	move.l	xfrF_postfix(a5),d2
		beq.b	.nopostfix
		move.l	d2,a4
		move.l	a0,a3
.nopostfix	or.l	d2,d1
		beq.b	.nofix
		lea	.defaultname(pc),a0
		bsr	printc
		lea	txt_white(pc),a0
		bsr	style
		lea	.nametemplate(pc),a0
		bsr	printfmt
		lea	txt_normcol(pc),a0
		bsr	style
.nofix
		push	a5
		move.l	xfrF_client(a5),a5
		bsr	printclientfile
		pop	a5

		bsr	newline
		move.l	xfrF_long(a5),a0
		move.l	a0,d0
		bne.b	.long
		lea	txt_noinfo(pc),a0
.long		bra	print


.find_next	move.l	xfrF_nextformat(a5),d3
		bne.b	.find_loop

.all		lea	txt_underlined(pc),a0
		bsr	style

		lea	.title_formats(pc),a0
		bsr	print

		lea	txt_normcol(pc),a0
		bsr	style

		move.l	xfrB_formats(a6),d3
.formats_loop	move.l	d3,a5

		bsr	.printformat

		move.l	_task(pc),a1
		btl	SIGBREAKB_CTRL_C,TC_SIGRECVD(a1)
		beq.b	.nextformat
		lea	txt_break(pc),a0
		bsr	print
		bra.b	.formats_end

.nextformat	move.l	xfrF_nextformat(a5),d3
		bne.b	.formats_loop

.formats_end	bsr	newline

		lea	.hiscore(pc),a0
		move.l	xfrB_hiscore(a6),a1
		bsr	printfmt

		bsr	newline

		lea	note_formats(pc),a0
		bsr	printi
		lea	note_usefull(pc),a0
		bsr	printi
		lea	note_command_c(pc),a0
		bra	printi


.printformat	move.l	xfrF_short(a5),a1
		lea	.txt_column(pc),a0
		bsr	printfmtc

		lea	txt_normcol(pc),a0
		bsr	style

		move.w	xfrF_flags(a5),d1

		tst.l	xfrF_check(a5)
		beq.b	.ncheck
		lea	.check(pc),a0
		bsr	printc
.ncheck
		tst.l	xfrF_scan(a5)
		beq.b	.nscan
		lea	.scan(pc),a0
		bsr	printc
.nscan
		tst.l	xfrF_deepcheck(a5)
		beq.b	.ndeepcheck
		lea	.deepcheck(pc),a0
		bsr	printc
.ndeepcheck
		tst.l	xfrF_deepscan(a5)
		beq.b	.ndeepscan
		lea	.deepscan(pc),a0
		bsr	printc
.ndeepscan
		btst	#xfrFB_SIZE,d1
		beq.b	.nsize
		lea	.size(pc),a0
		bsr	printc
.nsize
		btst	#xfrFB_NAME,d1
		beq.b	.nname
		lea	.name(pc),a0
		bsr	printc
.nname
		btst	#xfrFB_TEXT,d1
		beq.b	.ntext
		lea	.info(pc),a0
		bsr	printc
.ntext
		tst.l	xfrF_patch(a5)
		beq.b	.npatch
		lea	.patch(pc),a0
		bsr	printc
.npatch
		tst.l	xfrF_convert(a5)
		beq.b	.nconvert
		lea	.convert(pc),a0
		bsr	printc
.nconvert
		tst.l	xfrF_extract(a5)
		beq.b	.nextract
		lea	.extract(pc),a0
		bsr	printc
.nextract
		tst.l	xfrF_id(a5)
		beq.b	.nid
		lea	.id(pc),a0
		bsr	printc
.nid
		move.l	xfrF_client(a5),a0
		tst.l	xfrC_id(a0)
		bne.b	.ninternal
		lea	txt_internal(pc),a0
		bsr	printc
.ninternal
		bra	newline


.title_format	dc.b	"format info",$a,0
.title_formats	dc.b	"supported formats:",$a,0
.txt_column	dc.b	"%-30s",0
.check		dc.b	"CHECK ",0
.scan		dc.b	"SCAN ",0
.deepcheck	dc.b	"DEEPCHECK ",0
.deepscan	dc.b	"DEEPSCAN ",0
.size		dc.b	"SIZE ",0
.name		dc.b	"NAME ",0
.info		dc.b	"INFO ",0
.patch		dc.b	"PATCH ",0
.convert	dc.b	"CONVERT ",0
.extract	dc.b	"EXTRACT ",0
.id		dc.b	"ID ",0
.defaultname	dc.b	"default name fix: ",0
.formatid	dc.b	"exported as (ID): ",0
.hiscore	dc.b	"%ld formats",0
.nametemplate	dc.b	"%s%s#?%s%s",0
.nullstring	dc.b	0
.point		dc.b	".",0

txt_usage	dc.b	"xfrlibinfo [<command>] [<name>] [<option>]",$a,0
txt_falseopt	dc.b	"Error: false option -%s.",0 
note_clients	dc.b	"Add a partial client name to see client details.",0
note_formats	dc.b	"Add a partial format name as argument to see format details.",0
note_command_c	dc.b	"Use command 'c' to see all clients list.",0
note_usefull	dc.b	"Use a full name and  option '-f' when it has not been found.",0
txt_filename	dc.b	"client file path: ",0
txt_path	dc.b	"libs:xfr/%s",0
txt_internpath	dc.b	"libs:%s "
txt_internal	dc.b	"(internal)",0
txt_clientver	dc.b	"client version  : %ld",0
txt_clientvers	dc.b	"version string: ",0
txt_clientcreds	dc.b	"client credits: ",0
txt_noinfo	dc.b	"no additional information available",0
txt_break	dc.b	"*** user break ***",0

options		dc.b	0
		even

		END
