
		incdir	"include:"
		include	exec/types.i
		include	exec/funcdef.i
		include	exec/exec_lib.i
		include	"lvo.i"
		include	"misc/DeliPlayer232.i"
		include	"silva/easy.i"
		include	dos/dos.i
		include	dos/dos_lib.i
		include	intuition/intuition.i
		include	intuition/intuitionbase.i
		include	intuition/screens.i
		include	"libraries/asl.i"
		include	"libraries/asl_lib.i"
		include	libraries/gadtools_lib.i
		include	libraries/gadtools.i
		include	exec/memory.i
		include	exec/tasks.i
		include	"f:xfr.i"
		include	f:xfr_lib.i

DELION_VER	=	1
DELION_REV	=	2

PROGRESS_WIDTH	=	220
PROGRESS_HEIGHT	=	22

FILEREQ_WIDTH	=	300
FILEREQ_HEIGHT	=	400

LOGO_WIDTH	=	132
LOGO_HEIGHT	=	19

		BITDEF	exfr,hybrid,0
		BITDEF	exfr,odd,1
		BITDEF	exfr,pcs,2
		BITDEF	exfr,nameu,3
		BITDEF	exfr,nofix,4

	PLAYERHEADER GenieTagArray

	dc.b	"$VER: "
	dc.b	"Delitracker XFR Genie v",$30+DELION_VER,".",$30+DELION_REV
	dc.b	" (4/2003) by silva@psi5.com",0
	even

GenieTagArray
	dc.l	DTP_RequestDTVersion,17	; this genie needs at least DT 2.07
	dc.l	DTP_RequestKickVersion,37
	dc.l	DTP_PlayerVersion,DELION_VER<<17+DELION_REV
	dc.l	DTP_PlayerName,GName	; Geniename
	dc.l	DTP_Creator,CName	; Creator
	dc.l	DTP_Description,Desc	; Description
	dc.l	DTP_DeliBase,delibase	; DeliBase will be stored there
	dc.l	DTP_Process,Begin	; startup code for the genie
	dc.l	DTP_Priority,0		; default task priority
	dc.l	DTP_StackSize,4096	; default stack size
	dc.l	DTP_MsgPort,DeliPort	; port where DT will send commands
	dc.l	DTP_Convert,ConvertMod	; Conversion routine
	dc.l	DTP_FormatName,FormName	; name of original moduleformat
	dc.l	DTP_UserConfig,UConfig	; delitracker config genie button
	;dc.l	DTP_Appear,Appear	; show interface
	;dc.l	DTP_Disappear,Disappear	; hide interface
	dc.l	TAG_DONE

CName	dc.b	"m.on christmas 2002 by silva@psi5.com,",$a
	dc.b	"master of PseudoDOS Group",0
Desc	dc.b	"rip with eXternal Format Rippers",$a
	dc.b	"by Andreas G. Szabo / PseudoDOS",$a
	dc.b	"http://www.psi5.com/~silva/afilter/",0
ReqTi	dc.b	"Delitracker "
GName	dc.b	"XFR Genie v",$30+DELION_VER,".",$30+DELION_REV,0
libname	XFRNAME
	even

 STRUCTURE	globals,0
	ULONG	g_pbdelaycount	; must be offset 0
					; +1, if pbdelay refresh and clear
	APTR	g_task
	APTR	g_delibase
	APTR	g_xfrbase
	APTR	g_DeliPort
	APTR	g_formname
	APTR	g_object
	APTR	g_this
	APTR	g_easy			; struct
	UWORD	g_quitflag
	APTR	g_menustrip
	LABEL	g_progresswindow
	APTR	g_window		; configwin, sonst progresswindow
					; ab PROGRESS_WIDTH*step bytes
					; mglich, ab x*soviel sinnvol
					; (speedup fr kurze files, bei 
					;  denen das progress fenster
					;  ohne eine p.bar nur fr kaum
					;  bemerkbare zeit sichtbar wre)
	APTR	g_progresswindowrp
	ULONG	g_pbdelay		; totalsize/step/PROGRESS_WIDTH
					; (sizes > ca 16mb need a div.l for
					;  a delay greater than 65535)
	UWORD	g_pbdonewidth		; +1, except if found, add (set to)
					; foundsize/step/pbdelay (.l), add
					; rest to (set to) pbdelaycount,
					; compare result with pbdelay and
					; if greater sub pbdelay and add
					; 1 to pbdonewidth (or use donesize
					; incl foundsize instead of
					; foundsize, use sets instead of
					; adds and no compare fix needed),
					; then refresh (scanned) or
					; refresh before that (postition)
	UBYTE	g_pwsigbit
	UBYTE	g_options
	APTR	g_configobject
	APTR	g_deliscreen
	APTR	g_visualinfo
	APTR	g_aslfilerequester
	STRUCT	g_parameters,80
	STRUCT	g_drawer,256
	STRUCT	g_filename,256

; ------------------------------------------------------------------------
; Genie Process used to have xfrmaster.library open while the genie
; is active and can also do some all around initialisations

Begin		lea	genieglobals,a4
		move.l	g_delibase(a4),a5
		lea	libname(pc),a1
		moveq	#XFRVERSION,d0
		move.l	4.w,a6
		jsr	_LVOOpenLibrary(a6)
		move.l	d0,g_xfrbase(a4)
		bne.b	.find_task

		sub.l	a0,a0
		lea	es_update(pc),a1
		sub.l	a2,a2
		move.l	dtg_IntuitionBase(a5),a6
		jmp	_LVOEasyRequestArgs(a6)


.find_task	sub.l	a1,a1
		jsr	_LVOFindTask(a6)
		move.l	d0,g_task(a4)

		lea	save_requester_tags(pc),a0
		moveq	#ASL_FileRequest,d0
		move.l	dtg_AslBase(a5),a6
		jsr	_LVOAllocAslRequest(a6)
		move.l	d0,g_aslfilerequester(a4)
		beq	.close_xfr

		; settings

		move.l	dtg_DOSBase(a5),a6

		lea	configenv(pc),a0
		move.l	a0,d1
		lea	configpath(pc),a0
		move.l	a0,d2
		moveq	#80,d3
		moveq	#0,d4
		jsr	_LVOGetVar(a6)
		lea	configpath(pc),a0
		move.l	a0,d1
		lea	configname(pc),a0
		move.l	a0,d2

		moveq	#80,d3
		jsr	_LVOAddPart(a6)

		lea	configpath(pc),a0

		moveq	#0,d0
		moveq	#xfrOBJECT_FILE,d1
		move.l	g_xfrbase(a4),a6
		jsr	_LVOxfrCreateObject(a6)
		tst.l	d0
		bgt.b	.set_cfg

.make_cfg	moveq	#xfrOBJECT_BUFFER,d1
		moveq	#1,d0
		move.l	g_xfrbase(a4),a6
		jsr	_LVOxfrCreateObject(a6)
		tst.l	d0
		ble.b	.wait_again

.set_cfg	move.l	d0,g_configobject(a4)
		move.l	d0,a0
		move.w	#xfrRETURN_YES,xfrO_state(a0)
		move.l	xfrO_start(a0),a0
		move.b	(a0),d1

		move.b	d1,g_options(a4)	; ist ntig

		move.b	d1,d0
		and.b	#CHECKED>>8,d0
		lea	m_hybrid_sel(pc),a0
		or.b	d0,(a0)
		lsr.b	#1,d1
		move.b	d1,d0
		and.b	#CHECKED>>8,d0
		lea	m_odd_sel(pc),a0
		or.b	d0,(a0)

		btw	xfrBB_ODDCPU,xfrB_flags(a6)
		bne.b	.pcs
		eor.w	#ITEMENABLED,(a0)

.pcs		lsr.b	#1,d1
		move.b	d1,d0
		and.b	#CHECKED>>8,d0
		lea	m_pcs_sel(pc),a0
		or.b	d0,(a0)
		lsr.b	#1,d1
		move.b	d1,d0
		and.b	#CHECKED>>8,d0
		lea	m_nameu_sel(pc),a0
		or.b	d0,(a0)
		lsr.b	#1,d1
	;	move.b	d1,d0
		and.b	#CHECKED>>8,d1
		lea	m_nofix_sel(pc),a0
		or.b	d1,(a0)

		; handle signals and messages

.wait_again	move.l	#SIGBREAKF_CTRL_C,d0		; quit on CTRL-C

		move.l	g_DeliPort(a4),a0
		move.b	MP_SIGBIT(a0),d1		; DeliMask holen
		bset.l	d1,d0

		move.l	4.w,a6
		jsr	_LVOWait(a6)			; Schlaf gut

		push	d0

.if_msg		move.l	g_DeliPort(a4),d0			; get command-port
		beq.s	.if_quit	; wie kann der da nicht da sein?
					; code aber vom deliwizard, peter
					; oder frank fragen
		move.l	d0,a0
		jsr	_LVOGetMsg(a6)
		tst.l	d0				; Msg da ?
		beq.s	.if_quit			; Nein !
		move.l	d0,-(sp)			; store ^Msg
		move.l	d0,a0
		move.l	DTMN_Function(a0),a0		; get CMD
		jsr	(a0)				; Befehl ausfhren
		move.l	(sp)+,a1			; restore ^Msg
		move.l	d0,DTMN_Result(a1)		; set Result
		move.l	4.w,a6
		jsr	_LVOReplyMsg(a6)		; return to sender
		bra.b	.if_msg

.if_quit	pop	d0

		btst.l	#SIGBREAKB_CTRL_C,d0		; CTRL-C signal ?
		beq.b	.wait_again

		move.l	g_aslfilerequester(a4),a0
		move.l	dtg_AslBase(a5),a6
		jsr	_LVOFreeAslRequest(a6)

.close_xfr	move.l	g_xfrbase(a4),a1
		move.l	4.w,a6
		jmp	_LVOCloseLibrary(a6)


; file requester tags ----------------------------------------------------

save_requester_tags	dc.l	ASLFR_Flags1,FRF_DOSAVEMODE+FRF_PRIVATEIDCMP+FRF_DOPATTERNS
			dc.l	ASLFR_InitialDrawer,drawer_buffer
			dc.l	ASLFR_InitialFile,filename_buffer
			dc.l	ASLFR_Screen
save_requester_screen	dc.l	0
			dc.l	ASLFR_InitialWidth
			dc.w	0
save_requester_width	dc.w	FILEREQ_WIDTH
			dc.l	ASLFR_InitialHeight
			dc.w	0
save_requester_height	dc.w	FILEREQ_HEIGHT
			dc.l	ASLFR_InitialTopEdge
			dc.w	0
save_requester_top	dc.w	0
			dc.l	ASLFR_InitialLeftEdge
			dc.w	0
save_requester_left	dc.w	0
			dc.l	ASLFR_InitialPattern,file_pattern
			dc.l	TAG_DONE


; new window tags --------------------------------------------------------

options_window_tags	dc.l	WA_InnerWidth,132
			dc.l	WA_InnerHeight,19
			dc.l	WA_IDCMP,IDCMP_CLOSEWINDOW+IDCMP_MENUPICK+IDCMP_MENUHELP
			dc.l	WA_Title,OptWinTitle
			dc.l	WA_NewLookMenus,-1
			dc.l	WA_MenuHelp,-1
			dc.l	TAG_MORE,common_window_tags

progress_window_tags	dc.l	WA_BusyPointer,-1
			dc.l	WA_InnerWidth,PROGRESS_WIDTH	;*3
			dc.l	WA_InnerHeight,PROGRESS_HEIGHT
			dc.l	WA_IDCMP,IDCMP_CLOSEWINDOW
			dc.l	WA_Title,ReqTi

common_window_tags	dc.l	WA_DragBar,-1
			dc.l	WA_CloseGadget,-1
			dc.l	WA_SmartRefresh,-1
			dc.l	WA_AutoAdjust,-1
			dc.l	WA_DepthGadget,-1
			dc.l	WA_Activate,-1
			dc.l	WA_Left
			dc.w	0
window_left		dc.w	0
			dc.l	WA_Top
			dc.w	0
window_top		dc.w	0
			dc.l	WA_GimmeZeroZero,-1
			dc.l	WA_PubScreen
window_screen		dc.l	0
			dc.l	TAG_END

; gui related stuff

GTOptionsMenu	dc.b	NM_TITLE,0
		dc.l	OptMenuName,0
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
		dc.l	txt_hybrid,0
m_hybrid_sel	dc.w	CHECKIT | MENUTOGGLE
		dc.l	0,exfrB_hybrid

		dc.b	NM_ITEM,0
		dc.l	txt_odd,0
m_odd_sel	dc.w	CHECKIT | MENUTOGGLE
		dc.l	0,exfrB_odd

		dc.b	NM_ITEM,0
		dc.l	txt_pcnames,0
m_pcs_sel	dc.w	CHECKIT | MENUTOGGLE
		dc.l	0,exfrB_pcs

		dc.b	NM_ITEM,0
		dc.l	txt_nameu,0
m_nameu_sel	dc.w	CHECKIT | MENUTOGGLE
		dc.l	0,exfrB_nameu

		dc.b	NM_ITEM,0
		dc.l	txt_nofix,0
m_nofix_sel	dc.w	CHECKIT | MENUTOGGLE
		dc.l	0,exfrB_nofix

		dc.b	NM_ITEM,0
		dc.l	NM_BARLABEL,0
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
		dc.l	txt_saveopts,0
		dc.w	0
		dc.l	0,-1	; <- mark this as save options

		dc.b	NM_END,0
	;	dc.l	0,0		try zap this
	;	dc.w	0
	;	dc.l	0,0

MenuTags	dc.l	GTMN_NewLookMenus,1
		dc.l	TAG_DONE	

; user configuration -----------------------------------------------------

rts_1		rts

UConfig		lea	options_window_tags(pc),a2
		moveq	#LOGO_WIDTH/2,d2
		moveq	#LOGO_HEIGHT/2,d3
		bsr	openwindow	; does it incl pos and locking

		move.l	a2,g_window(a4)
		beq	rts_1

	; use gadtools to make menu

		; obtain visual info (der letzte macht die tr zu)

		move.l	dtg_GadToolsBase(a5),a6

		move.l	g_deliscreen(a4),a0
		suba.l	a1,a1
		jsr	_LVOGetVisualInfoA(a6)
		move.l	d0,g_visualinfo(a4)
		beq	.close_window

		; make and layout menu

		lea	GTOptionsMenu(pc),a0		; make menus
		sub.l	a1,a1
		jsr	_LVOCreateMenusA(a6)
		move.l	d0,g_menustrip(a4)
		beq.s	.free_visual

		move.l	d0,a0				; align menus
		move.l	g_visualinfo(a4),a1
		lea	MenuTags(pc),a2
		jsr	_LVOLayoutMenusA(a6)
		tst.l	d0
		beq.s	.free_menu

	; use intuition to insert menu strip into window

		move.l	dtg_IntuitionBase(a5),a6

		move.l	g_window(a4),a2

		move.l	a2,a0
		move.l	g_menustrip(a4),a1
		jsr	_LVOSetMenuStrip(a6)

	; draw the logo into the window

		move.l	wd_RPort(a2),a0

		lea	vampirelogo(pc),a1
		moveq	#0,d0
		move.l	d0,d1
		jsr	_LVODrawImage(a6)

	; exec intuition message processing

		clr.w	g_quitflag(a4)

.wait_again	move.l	wd_UserPort(a2),a0
		move.l	4.w,a6
		jsr	_LVOWaitPort(a6)

.get_again	move.l	wd_UserPort(a2),a0
		jsr	_LVOGetMsg(a6)
		tst.l	d0
		beq	.if_quit

		push	d0

		move.l	d0,a1
		move.l	im_Class(a1),d2

		cmp.l	#IDCMP_CLOSEWINDOW,d2
		bne	.else
		move.w	#-1,g_quitflag(a4)
		bra	.replymsg

.else		cmp.l	#IDCMP_MENUHELP,d2
		bne.b	.if_menupick
		sub.l	a0,a0
		lea	es_menuhelp(pc),a1
		sub.l	a2,a2
		move.l	dtg_IntuitionBase(a5),a6
		jsr	_LVOEasyRequestArgs(a6)
		bra	.replymsg

.if_menupick	cmp.l	#IDCMP_MENUPICK,d2
		bne.b	.replymsg

		move.w	im_Code(a1),d0
		move.l	g_menustrip(a4),a0
		move.l	dtg_IntuitionBase(a5),a6
		jsr	_LVOItemAddress(a6)
		tst.l	d0
		beq	.replymsg

		move.l	d0,a0
		tst.l	mi_SIZEOF(a0)
		bge.b	.optious

		; save options

		move.l	g_xfrbase(a4),a6
		move.l	g_configobject(a4),d0
		beq	.replymsg
		move.l	d0,a1
		move.l	xfrO_start(a1),a0
		move.b	g_options(a4),(a0)
		lea	configpath(pc),a0
		jsr	_LVOxfrSaveObject(a6)
		bra	.replymsg

.optious	; optious items

		move.l	g_menustrip(a4),a0
		move.l	mu_FirstItem(a0),a0

		moveq	#0,d0
		moveq	#4,d3

.item_loop	move.b	mi_Flags(a0),d1
		GTMENUITEM_USERDATA	a0,d2
		and.b	#CHECKED>>8,d1
		beq	.next_item
		bset	d2,d0
.next_item	move.l	mi_NextItem(a0),a0
		dbf	d3,.item_loop

		move.b	d0,g_options(a4)

	; release the message

.replymsg	pop	a1
		move.l	4.w,a6
		jsr	_LVOReplyMsg(a6)
		move.l	g_window(a4),a2
		bra	.get_again

.if_quit	tst.w	g_quitflag(a4)
		beq	.wait_again

; feedback menu options into newmenu

		moveq	#CHECKED>>8,d3
		not.b	d3
		move.b	g_options(a4),d1
		move.b	d1,d0
		and.b	#CHECKED>>8,d0
		lea	m_hybrid_sel(pc),a0
		move.b	(a0),d2
		and.b	d3,d2
		or.b	d0,d2
		move.b	d2,(a0)
		lsr.b	#1,d1
		move.b	d1,d0
		and.b	#CHECKED>>8,d0
		lea	m_odd_sel(pc),a0
		move.b	(a0),d2
		and.b	d3,d2
		or.b	d0,d2
		move.b	d2,(a0)
		lsr.b	#1,d1
		move.b	d1,d0
		and.b	#CHECKED>>8,d0
		lea	m_pcs_sel(pc),a0
		move.b	(a0),d2
		and.b	d3,d2
		or.b	d0,d2
		move.b	d2,(a0)
		lsr.b	#1,d1
		move.b	d1,d0
		and.b	#CHECKED>>8,d0
		lea	m_nameu_sel(pc),a0
		move.b	(a0),d2
		and.b	d3,d2
		or.b	d0,d2
		move.b	d2,(a0)
		lsr.b	#1,d1
	;	move.b	d1,d0
		and.b	#CHECKED>>8,d1
		lea	m_nofix_sel(pc),a0
		move.b	(a0),d2
		and.b	d3,d2
		or.b	d1,d2
		move.b	d2,(a0)

; clean this up, free menus, visual info and close window

		move.l	dtg_IntuitionBase(a5),a6
		move.l	g_window(a4),a0
		jsr	_LVOClearMenuStrip(a6)

.free_menu	move.l	dtg_GadToolsBase(a5),a6

		move.l	g_menustrip(a4),a0
		jsr	_LVOFreeMenus(a6)

.free_visual	move.l	g_visualinfo(a4),a0
		jsr	_LVOFreeVisualInfo(a6)

.close_window	move.l	dtg_IntuitionBase(a5),a6
		move.l	g_window(a4),a0
		jmp	_LVOCloseWindow(a6)


openwindow	; subroutine used for both config and progress window

		move.l	dtg_LockScreen(a5),a0
		jsr	(a0)
		move.l	d0,g_deliscreen(a4)
		beq	.fail

	;	move.l	ib_ActiveScreen	alternative

		move.l	dtg_IntuitionBase(a5),a6

		move.l	a2,a1
		lea	common_window_tags(pc),a2

		move.l	ib_MouseY(a6),d1
		sub.w	d2,d1
		move.w	d1,window_left-common_window_tags(a2)
		swap	d1
		sub.w	d3,d1
		move.w	d1,window_top-common_window_tags(a2)

		move.l	g_deliscreen(a4),window_screen-common_window_tags(a2)
		sub.l	a0,a0
		jsr	_LVOOpenWindowTagList(a6)

		move.l	d0,a2

		tst.l	g_deliscreen(a4)
		beq.b	rts_1
		move.l	dtg_UnlockScreen(a5),a0
		jmp	(a0)

.fail		sub.l	a2,a2
		rts

; ------------------------------------------------------------------------
; ripfunction using convert feature of delitracker to scan the loaded
; file and return the first found data that has a size
; gets *buffer in dtg_ChkData, the size in dtg_ChkSize

ConvertMod	; copy save directory into our buffer

		move.l	dtg_DirArrayPtr(a5),a0
		lea	g_drawer(a4),a1
.cpy_d		move.b	(a0)+,(a1)+
		bne.b	.cpy_d

		; make xfrObject for shared buffer

		move.l	g_xfrbase(a4),a6

		moveq	#xfrOBJECT_EMPTY,d1
		jsr	_LVOxfrCreateObject(a6)
		move.l	d0,g_object(a4)
		bgt	.scan

		moveq	#-1,d0
		rts

.scan		push	d0

		moveq	#0,d1		; default no scanhook

		; progress bar precalculation

		move.l	#PROGRESS_WIDTH,d1
		move.l	dtg_ChkSize(a5),d0

		btst	#exfrB_odd,g_options(a4)
		bne	.full
		lsR.l	#1,d0
.full
		; make progress stuff just for sizes/step >= PROGRESS_WIDTH
		; divul dividend must be greater or equal to divisor
		cmp.l	d1,d0
		blt	.init_object

		bsr	divul
		move.l	d0,g_pbdelay(a4)
		move.l	d0,g_pbdelaycount(a4)
		clr.w	g_pbdonewidth(a4)

		; progress window

		lea	progress_window_tags(pc),a2
		move.w	#PROGRESS_WIDTH/2,d2
		move.w	#PROGRESS_HEIGHT/2,d3

		bsr	openwindow	; windowpointer returns in a2

		pop	a1

		move.l	a2,g_window(a4)
		beq.b	.cancel

		push	a1

		; store proper sigbit for scanhook break

		move.l	wd_RPort(a2),g_progresswindowrp(a4)
		move.l	wd_UserPort(a2),a0
		move.b	MP_SIGBIT(a0),g_pwsigbit(a4)

		; init progress bar color

		move.l	g_progresswindowrp(a4),a1
		move.l	dtg_GfxBase(a5),a6
		moveq	#3,d0
		jsr	_LVOSetAPen(a6)

		pop	a1

		; init scanhook

		moveq	#xfrMODEF_HOOK,d1
		lea	scanhook(pc),a2
		move.l	a4,d2	

.init_object	; init object

		move.l	dtg_ChkSize(a5),xfrO_size(a1)
		move.l	dtg_ChkData(a5),xfrO_start(a1)
		or.w	#xfrOF_SHARED,xfrO_flags(a1)

		; init scan

	;	or.w	#xfrMODEF_SCANODD+xfrMODEF_HYBRID,d1

		move.b	g_options(a4),d0
		btst	#exfrB_hybrid,d0
		beq.b	.if_odd
		or.w	#xfrMODEF_HYBRID,d1
.if_odd		btst	#exfrB_odd,d0
		beq.b	.do_scan
		or.w	#xfrMODEF_SCANODD,d1

.do_scan	move.l	g_xfrbase(a4),a6
		jsr	_LVOxfrScan(a6)
		push	d0

		; close progress window

		move.l	g_progresswindow(a4),d0
		beq	.nowindow
		clr.l	g_progresswindow(a4)
		move.l	d0,a0
		move.l	dtg_IntuitionBase(a5),a6
		jsr	_LVOCloseWindow(a6)
.nowindow
		pop	d0
		bmi.b	.cancel

		cmp.w	#xfrRETURN_SCANSTOP,d0
		bne.b	.found

		; scan stop 


.found		; first found

		move.l	g_object(a4),a0
		move.l	xfrO_firstchild(a0),d0
		beq	.cancel

.work_obj	move.l	d0,a3
		move.l	a3,g_this(a4)

		lea	g_filename(a4),a0		; blank filename
		clr.b	(a0)

		bsr	initreportreq

.rep_again	sub.l	a0,a0
		move.l	g_easy(a4),a1
		sub.l	a2,a2
		lea	g_parameters(a4),a3
		move.l	dtg_IntuitionBase(a5),a6
		jsr	_LVOEasyRequestArgs(a6)

		tst.w	d0
		ble	.cancel
		move.l	g_this(a4),a0
		tst.w	xfrO_state(a0)
		bgt.b	.normal_answer

	; uncomment this line to allow play for faulty findings
	; (must be uncommented in the report generation also, see
	; some pages below)
	;	bra.b	.normal_answer

		; error case answer

		subq.w	#1,d0
		bne.b	.if_prevnext

		lea	g_parameters+40(a4),a3
		move.l	g_this(a4),a0
		move.l	xfrO_format(a0),a0
		movem.l	xfrF_short(a0),d0/d1
		move.l	xfrF_client(a0),a0
		movem.l	xfrC_short(a0),d2/d4
		move.l	xfrC_filename(a0),d3
		movem.l	d0-d4,(a3)
		sub.l	a0,a0
		lea	es_infos(pc),a1
		sub.l	a2,a2
		move.l	dtg_IntuitionBase(a5),a6
		jsr	_LVOEasyRequestArgs(a6)
		tst.w	d0
		beq.b	.cancel
		bra	.rep_again

		; normal case answer

.normal_answer	subq.w	#1,d0
		beq.b	.play
		subq.w	#1,d0
		beq.b	.save
		subq.w	#1,d0
		beq.b	.format
.if_prevnext	subq.w	#1,d0
		bne.b	.next
		move.l	g_object(a4),a1
		move.l	xfrO_firstchild(a1),a1
		cmp.l	a0,a1			; g_this,first
		bne.b	.find_prev

.next		move.l	xfrO_next(a0),d0
		bra	.work_obj

.find_prev	move.l	a1,d0
		move.l	xfrO_next(a1),a1
		cmp.l	a0,a1			; g_this,nexts to prev
		bne.b	.find_prev
		bra	.work_obj

.save		bsr	savefinding

		bra.b	.rep_again

.format		lea	g_parameters+40(a4),a3
		move.l	g_this(a4),a0
		move.l	xfrO_format(a0),a2
		movem.l	xfrF_short(a2),d0/d1
		movem.l	d0/d1,(a3)
		lea	es_format(pc),a1
		tst.l	xfrF_patch(a2)
		beq	.if_hasconvonly
		lea	gad_format_p(pc),a0
		tst.l	xfrF_convert(a2)
		beq	.set_formatgads
		lea	gad_format_b(pc),a0
		bra	.set_formatgads
.if_hasconvonly	tst.l	xfrF_convert(a2)
		beq	.format_req
		lea	gad_format_c(pc),a0
.set_formatgads	move.l	a0,es_GadgetFormat(a1)
.format_req	sub.l	a0,a0
		push	a2
		sub.l	a2,a2
		move.l	dtg_IntuitionBase(a5),a6
		jsr	_LVOEasyRequestArgs(a6)
		pop	a0

		tst.w	d0
		ble	.restore_line1

		move.l	g_xfrbase(a4),a6
		move.l	g_this(a4),a1

		subq.w	#1,d0
		beq.b	.fopts_what

.convert	; convert

		jsr	_LVOxfrConvert(a6)

		lea	txt_ntconverted(pc),a0
		tst.l	d0
		ble	.get_fopterror

		; attach object to tail of findings and go init report
		; >> help indicate conversion by not setting parent <<

		move.l	g_this(a4),a0
.find_last	move.l	xfrO_next(a0),d1
		beq	.found_last
		move.l	d1,a0
		bra	.find_last
.found_last	move.l	d0,xfrO_next(a0)

		bra	.work_obj

.fopts_what	tst.l	xfrF_convert(a0)
		bne	.convert

		; patch

		jsr	_LVOxfrPatch(a6)

		lea	txt_patched(pc),a0
		tst.w	d0
		bgt	.set_foptresult
		lea	txt_notpatched(pc),a0
.get_fopterror	beq	.set_foptresult
		jsr	_LVOxfrGetErrorText(a6)
		move.l	d0,a0
.set_foptresult	move.l	a0,g_parameters(a4)
		bra	.rep_again

.play		move.l	xfrO_format(a0),a1
		btw	xfrFB_SOUNDFORMAT,xfrF_flags(a1)
		bne.b	.issound

		sub.l	a0,a0
		lea	es_notplay(pc),a1
		sub.l	a2,a2
		lea	g_parameters+4(a4),a3
		move.l	dtg_IntuitionBase(a5),a6
		jsr	_LVOEasyRequestArgs(a6)

.restore_line1	move.l	g_this(a4),a1
		move.l	xfrO_format(a1),a1
		bsr	format_class
		move.l	d1,g_parameters(a4)
		bra	.rep_again

.issound	move.l	xfrF_short(a1),g_formname(a4)
		move.l	xfrO_size(a0),d0
		move.l	d0,d3
		move.l	xfrO_start(a0),d2
		moveq	#MEMF_CHIP,d1
		move.l	dtg_AllocListData(a5),a0
		jsr	(a0)
		tst.l	d0
		beq.b	.cancel

		move.l	d0,a1
		move.l	d2,a0
		move.l	d3,d0
		move.l	4.w,a6
		jsr	_LVOCopyMem(a6)

		moveq	#0,d0
		bra.b	.free

.no_chipmem

.cancel		moveq	#-1,d0
.free		push	d0
		move.l	g_object(a4),a1
		move.l	g_xfrbase(a4),a6
		jsr	_LVOxfrFreeObjects(a6)
		pop	d0
		rts


; SCAN HOOK FOR GROWING PROGRESS BAR AND ABORT ---------------------------

scanhook	; the accurate and fast progress bar method with a refresh
		; done every precalculated step of bytes for a pixel and
		; intermediate recalcs with a blockfill for found sizes

		lea	genieglobals,a2
		tst.w	d1
		bgt	.recalc
.delay		subq.l	#1,(a2)	; g_pbdelaycount must be here offset 0
		beq	.addone
		rts

.recalc		; found something, skip size if any

		move.l	xfrCom_lastfound(a4),a1
		move.l	xfrO_size(a1),d2
		beq	.delay	; if no size, continue counting delay

		add.l	xfrO_start(a1),d2
		move.l	xfrCom_object(a4),a1
		sub.l	xfrO_start(a1),d2

		btst	#exfrB_odd,g_options(a2)
		bne	.full
		lsR.l	#1,d2
.full
		move.l	g_pbdelay(a2),d1
		cmp.l	d1,d2	; if donesize/step < pbdelay
		blt	.setcounter
		move.l	d2,d0
		bsr	divul
		subq.w	#1,d0
		move.w	d0,g_pbdonewidth(a2)

		; write rest as remaining delay counter
		move.l	g_pbdelay(a2),d1
		bsr	mulul
		sub.l	d0,d2
		beq	.resetcounter	; if restless, reset and refresh

		bsr	.setcounter

.refresh_block	; refresh block

		pushm	a5/a6
		move.l	g_delibase(a2),a5
		move.l	dtg_GfxBase(a5),a6
		move.l	g_progresswindowrp(a2),a1
		moveq	#0,d0
		move.w	d0,d1
		move.w	g_pbdonewidth(a2),d2
		subq.w	#1,d2
		move.w	#PROGRESS_HEIGHT-1,d3
		jsr	_LVORectFill(a6)

		bra	.check_break

.resetcounter	; reset counter

		move.l	g_pbdelay(a2),g_pbdelaycount(a2)
		bra	.refresh_block

.setcounter	; still lesser done than the first full counter

		move.l	d2,g_pbdelaycount(a2)
		rts

.addone		; grow progressbar by one pixel

		move.w	g_pbdonewidth(a2),d0
		add.w	#1,g_pbdonewidth(a2)

		; reset counter

		move.l	g_pbdelay(a2),g_pbdelaycount(a2)

		; draw one more pixel coulmn to progressbar width

		pushm	a5/a6
		move.l	g_delibase(a2),a5
		move.l	dtg_GfxBase(a5),a6
		move.l	g_progresswindowrp(a2),a1
		moveq	#0,d1
		push	d0
		jsr	_LVOMove(a6)
		pop	d0
		move.w	#PROGRESS_HEIGHT-1,d1
		move.l	g_progresswindowrp(a2),a1
		jsr	_LVODraw(a6)

.check_break	;move.l	dtg_DOSBase(a5),a6	; see what test
		;moveq	#100,d1
		;jsr	_LVODelay(a6)

		popm	a5/a6

		moveq	#0,d0	; continue scan

		; check for windowclose

		move.l	g_task(a2),a1
		move.l	TC_SIGRECVD(a1),d3	; maybe can be done just
		move.b	g_pwsigbit(a2),d2	; with tst.l TC_SIGRECVD(a1)
		btst	d2,d3			; and then bne direct
		bne.b	.break			; (only thing can happen)
		rts


.break		; flush CLOSEWINDOW idcmp message if present

		push	a6
		move.l	4.w,a6
		move.l	g_progresswindow(a2),a0
		move.l	wd_UserPort(a0),a0
		jsr	_LVOGetMsg(a6)
		tst.l	d0
		beq.b	.restore_a6
		move.l	d0,a1
		jsr	_LVOReplyMsg(a6) ; return to sender
.restore_a6	pop	a6

		; set XFR abort return code

		moveq	#xfrRETURN_SCANSTOP,d0
		rts


; FINDINGS REPORT INITIALISATION -----------------------------------------

initreportreq	; choose and init easystruct for findings reports and
		; make it with gads according to current finding that
		; will be displayed from the data list of all findings

		lea	gads(pc),a2
		move.w	xfrO_state(a3),d0

	; uncomment this line to allow play allways
	; (must be done in the choice func some pages above also)
	;	bra.b	.normal_case

		bgt.b	.normal_case
		addq.l	#4,a2			; switch to error variants
		lea	es_found_error(pc),a1	; use fault requester
		move.l	a1,g_easy(a4)

		; set error case parameters

		move.l	g_xfrbase(a4),a6
		jsr	_LVOxfrGetErrorText(a6)
	
		lea	txt_normal(pc),a0
		btw	xfrOB_BYDEEP,xfrO_flags(a3)
		beq.b	.set_modestring
		lea	txt_deep(pc),a0
.set_modestring	move.l	a0,d1

		; calc occurence offset or tell size

		move.l	g_object(a4),a0
		tst.l	xfrO_parent(a3)
		bne	.err_offset
		cmp.l	a0,a3
		beq	.err_offset
		move.l	xfrO_size(a3),d2
		bra	.err_s_o_set
.err_offset	move.l	xfrO_start(a3),d2
		sub.l	xfrO_start(a0),d2
.err_s_o_set	move.l	d2,d3
		move.l	xfrO_format(a3),a0
		move.l	xfrF_short(a0),d4
		move.l	xfrF_client(a0),a0
		move.l	xfrC_short(a0),d5

		movem.l	d0-d5,g_parameters(a4)
		bra.b	.choose_gads

.normal_case	; choose normal case easy struct and set parameters

		lea	es_found(pc),a1
		move.l	xfrO_size(a3),d4	; get size parameter
		bne.b	.set_easy
		lea	es_found_nosize(pc),a1
		move.l	g_object(a4),a0
		move.l	xfrO_start(a0),d4
		add.l	xfrO_size(a0),d4	; set all rest of bytes
		sub.l	xfrO_start(a3),d4	; as size for sizeless
		move.l	d4,xfrO_size(a3)	; finding
.set_easy	move.l	a1,g_easy(a4)
		move.l	xfrO_format(a3),a0
		move.l	xfrF_short(a0),d2
		bsr	format_class
		move.l	xfrO_name(a3),d3
		beq	.is_unnamed
		move.l	d3,a0
		tst.b	(a0)
		bne.b	.set_normal_p
.is_unnamed	move.l	g_xfrbase(a4),a1
		move.l	xfrB_defaultname(a1),a0
		move.l	a0,d3
.set_normal_p	movem.l	d1-d4,g_parameters(a4)

.choose_gads	move.l	g_object(a4),a0		; first child as a
		cmp.l	xfrO_firstchild(a0),a3	; reference for list pos
		beq.b	.first
		addq.l	#8,a2			; switch to prev variant
		addq.l	#8,a2
		tst.l	xfrO_next(a3)
		beq.b	.set_gads
		addq.l	#8,a2			; switch to both variant
		bra.b	.set_gads
.first		tst.l	xfrO_next(a3)
		beq.b	.set_gads
		addq.l	#8,a2			; switch to next variant
.set_gads	move.l	g_easy(a4),a1
		move.l	(a2),es_GadgetFormat(a1)
		rts

format_class	lea	txt_xfrhave(pc),a1	; eXternal F. R. have ...
		btw	xfrFB_SOUNDFORMAT,xfrF_flags(a0)
		bne.b	.set_result
		lea	txt_xfrhaveelse(pc),a1
.set_result	move.l	a1,d1
		rts

adjust_pos  ;	move.w	d1,d2
		lsr.w	#1,d1
		sub.w	d1,d0
;		bge.b	.fix_pos
;		clr.w	d0
;.fix_pos	sub.w	d2,d3	; does only work if window size fits
;		cmp.w	d3,d0	; on screen
;		ble.b	.set_pos
;		move.w	d3,d0
.set_pos	rts

savefinding	; open a file requester and save finding, in case of
		; an error or cancel set appropriate new first line
		; for the findings report requester

		lea	g_filename(a4),a1
		tst.b	(a1)
		bne.b	.hasname

		move.l	g_parameters+8(a4),d1
		move.l	g_this(a4),a2
		btst	#exfrB_nameu,g_options(a4)
		beq.b	.name_ok
		move.l	xfrO_name(a2),d0
		beq.b	.use_load_name
		move.l	d0,a0
		tst.b	(a0)
		bne.b	.name_ok
.use_load_name	move.l	dtg_FileArrayPtr(a5),d1
.name_ok	move.l	xfrO_format(a2),a2
		btst	#exfrB_nofix,g_options(a4)
		beq.b	.set_fixmode
		sub.l	a2,a2			; <- opt no fixing a2 NULL
.set_fixmode	moveq	#0,d2
		btst	#exfrB_pcs,g_options(a4)
		beq.b	.amiganame
		moveq	#-1,d2
.amiganame	moveq	#0,d3
		move.l	g_xfrbase(a4),a6
		jsr	_LVOxfrFixName(a6)
.hasname	
		; file requester

		move.l	g_aslfilerequester(a4),a3
		move.l	dtg_AslBase(a5),a6

		move.l	dtg_IntuitionBase(a5),a0
		move.l	ib_ActiveScreen(a0),a0	; a0 screen
		move.l	sc_MouseY(a0),d0
	;	move.l	sc_Width(a0),d3

	;	swap	d3

		lea	save_requester_tags(pc),a1
		move.l	a0,save_requester_screen-save_requester_tags(a1)

		move.w	save_requester_width-save_requester_tags(a1),d1
		bsr	adjust_pos
		move.w	d0,save_requester_left-save_requester_tags(a1)

		swap	d0
	;	swap	d3

		move.w	save_requester_height-save_requester_tags(a1),d1
		bsr	adjust_pos
		move.w	d0,save_requester_top-save_requester_tags(a1)

		move.l	a3,a0
		jsr	_LVOAslRequest(a6)

		; feedback dimensions, file and drawer

		lea	save_requester_tags(pc),a1
		move.w	fr_Width(a3),save_requester_width-save_requester_tags(a1)
		lea	save_requester_tags(pc),a1
		move.w	fr_Height(a3),save_requester_height-save_requester_tags(a1)

		move.l	fr_Drawer(a3),a0
		lea	g_drawer(a4),a1
.cpy_drawer	move.b	(a0)+,(a1)+
		bne.b	.cpy_drawer

		move.l	fr_File(a3),a0
		lea	g_filename(a4),a1
.cpy_name	move.b	(a0)+,(a1)+
		bne.b	.cpy_name

		tst.l	d0
		beq	.not_saved

		; save object

		lea	g_drawer(a4),a2
		tst.b	(a2)
		beq.b	.save_object
		move.l	a2,d1
		moveq	#ACCESS_READ,d2
		move.l	dtg_DOSBase(a5),a6
		jsr	_LVOLock(a6)
		move.l	d0,d3
		beq.b	.doserr
		move.l	d0,d1
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d4

.save_object	lea	g_filename(a4),a0
		move.l	g_xfrbase(a4),a6
		move.l	g_this(a4),a1
		jsr	_LVOxfrSaveObject(a6)

		push	d0

		tst.b	(a2)
		beq.b	.if_saved
		move.l	dtg_DOSBase(a5),a6
		move.l	d4,d1
		jsr	_LVOCurrentDir(a6)
		move.l	d3,d1
		jsr	_LVOUnLock(a6)

.if_saved	; return can only be + or - nit null, the tagless func
		; does allways overwrite
		pop	d0
		bmi.b	.xfrsaveerr

		lea	text_saved(pc),a2
		bra.b	.set_savestate
.doserr		moveq	#xfrERROR_DOS,d0
.xfrsaveerr	move.l	g_xfrbase(a4),a6
		jsr	_LVOxfrGetErrorText(a6)
		move.l	d0,a2
		bra.b	.set_savestate
.not_saved	lea	text_notsaved(pc),a2
.set_savestate	move.l	a2,g_parameters(a4)

		rts

; longword division and multiplication -----------------------------------

; D0.L = D0.L / D1.L unsigned

; this divison routine apparantly fails with a div by zero
; when d1 is greater than d0

divul		MOVEM.L	D2/D3,-(SP)
		SWAP	D1
		TST.W	D1
		BNE.B	.long_divisor
		SWAP	D1

		; fall 1: divisor in d1 <= 65535

		MOVE.W	D1,D3
		MOVE.W	D0,D2
		CLR.W	D0
		SWAP	D0
		DIVU.W	D3,D0
		MOVE.L	D0,D1
		SWAP	D0
		MOVE.W	D2,D1
		DIVU.W	D3,D1
		MOVE.W	D1,D0
		CLR.W	D1
		SWAP	D1
.rausda		MOVEM.L	(SP)+,D2/D3
		RTS

.long_divisor	SWAP	D1

		; fall 2: divisor in d1 > 65535

		MOVE.L	D1,D3
		MOVE.L	D0,D1
		CLR.W	D1
		SWAP	D1
		SWAP	D0
		CLR.W	D0
		MOVEQ	#16-1,D2
.duloop		ADD.L	D0,D0
		ADDX.L	D1,D1
		CMP.L	D1,D3
		BHI.B	.dublah
		SUB.L	D3,D1
		ADDQ.W	#1,D0
.dublah		DBRA	D2,.duloop
		bra	.rausda


mulul		; d0.l = d0.l * d1.l, d1 wird gendert 

		cmp.l	d0,d1
		bgt.s	.Mul32
		exg	d0,d1
.Mul32		movem.l	d2-d3,-(a7)
		moveq	#31,d2
		moveq	#0,d3
.Mul1		tst.l	d1
		beq.s	.Mul2
		lsr.l	#1,d1
		bcc.s	.Mul3
		add.l	d0,d3
.Mul3		add.l	d0,d0
		dbf	d2,.Mul1
.Mul2		move.l	d3,d0
		movem.l	(a7)+,d2-d3
		rts

; requesters defintions --------------------------------------------------

es_found	dc.l	EasyStruct_SIZEOF
		dc.l	0
		dc.l	ReqTi
		dc.l	reqtext
		dc.l	0
es_found_nosize	dc.l	EasyStruct_SIZEOF
		dc.l	0
		dc.l	ReqTi
		dc.l	reqtext_nosize
		dc.l	0
es_format	dc.l	EasyStruct_SIZEOF
		dc.l	0
		dc.l	ReqTi
		dc.l	reqtext_format
		dc.l	gad_format
es_found_error	dc.l	EasyStruct_SIZEOF
		dc.l	0
		dc.l	ReqTi
		dc.l	reqtext_error
		dc.l	0
es_infos	dc.l	EasyStruct_SIZEOF
		dc.l	0
		dc.l	ReqTi
		dc.l	reqtext_infos
		dc.l	gad_infos
es_update	dc.l	EasyStruct_SIZEOF
		dc.l	0
		dc.l	ReqTi
		dc.l	reqtext_update
		dc.l	gad_quit
es_menuhelp	dc.l	EasyStruct_SIZEOF
		dc.l	0
		dc.l	ReqTi
		dc.l	reqtext_menuhlp
		dc.l	gad_closehelp
es_notplay	dc.l	EasyStruct_SIZEOF
		dc.l	0
		dc.l	ReqTi
		dc.l	reqtext_notplay
		dc.l	gad_okaye

gads		dc.l	gad_one,gad_one_e
		dc.l	gad_next,gad_next_e
		dc.l	gad_prev,gad_prev_e
		dc.l	gad_both,gad_both_e

txt_xfrhave	dc.b	"eXternal Format Rippers have found a Module.",0
txt_xfrhaveelse	dc.b	"eXternal Format Rippers have found something",$a
		dc.b	"alternative. A Text, Picture, Binary or else.",0
reqtext		dc.b	"%s",$a,$a
		dc.b	"format: %s",$a
		dc.b	"name: %s",$a
		dc.b	"size: %ld bytes",$a,$a
		dc.b	"Replaying does cancel the finding(s).",0
reqtext_nosize	dc.b	"%s",$a,$a
		dc.b	"format: %s",$a
		dc.b	"name: %s",$a
		dc.b	"size: unknown",$a,$a
		dc.b	"All rest of %ld bytes will be used and",$a
		dc.b	"maybe playing wont work unless you save the",$a
		dc.b	"Datas and cut them right at the end first.",$a,$a
		dc.b	"Trying replay does cancel the finding(s).",0
reqtext_format	dc.b	"%s",$a,$a
		dc.b	"%s",0
txt_patched	dc.b	"The datas have been successfully patched.",0
txt_notpatched	dc.b	"Nothing to patch (maybe allready patched).",0
;txt_converted	dc.b	"The datas have been successfully converted.",0
txt_ntconverted	dc.b	"Nothing to convert.",0
reqtext_error	dc.b	"eXternal Format Rippers have encountered a problem.",$a,$a
		dc.b	"Fault: %s",$a,$a
		dc.b	"Checkmode: %s,    Offset or Size: $%lx (%ld)",$a,$a
		dc.b	"Format: %s",$a
		dc.b	"Client: %s",$a,$a
		dc.b	"For common cosmetic and safety reasons any further access to this",$a
		dc.b	"findings is not enabled here. Please contact the author of the named",$a
		dc.b	"XFR client or check out the more infos first.",0
reqtext_notplay	dc.b	"You cannot play %s",$a
		dc.b	"with Delitracker.",0
reqtext_infos	dc.b	"Format: %s",$a,$a
		dc.b	"%s",$a,$a
		dc.b	"Client: %s",$a
		dc.b	"Client File: %s",$a,$a
		dc.b	"%s",0
txt_normal	dc.b	"normal",0
txt_deep	dc.b	"extreme",0
reqtext_update	dc.b	"Please insert the XFR >=v",$30+XFRVERSION," into your libs:",$a
		dc.b	$a
		dc.b	"You can find it on the Amiga Filterium HP:",$a,$a
		dc.b	"       http://www.psi5.com/~silva/afilter/",$a,$a
		dc.b	"or in the aminet directorys.",0
		dc.b	"if you want the the PseudoDOS newsletter.",0
reqtext_menuhlp	dc.b	"Menue Help",$a
		dc.b	$a
		dc.b	"hybrid mode",$a
		dc.b	"ON: flat+deep checking, OFF: flat checking",$a,$a
		dc.b	"odd addresses",$a
		dc.b	"ON: scan every byte, OFF: every second byte",$a,$a
		dc.b	"pc-style naming",$a
		dc.b	"ON: module.mod, OFF: mod.module",$a,$a
		dc.b	"name unnamed",$a
		dc.b	"ON: use load name, OFF: save as unnamed",$a,$a
		dc.b	"take care and have fun",0
text_notsaved	dc.b	"The File has NOT been saved.",0
text_saved	dc.b	"The File has been successfully saved.",0
gad_one		dc.b	"play|save|format|cancel",0 ; or format / opts
gad_next	dc.b	"play|save|format|next|cancel",0
gad_both	dc.b	"play|save|format|prev|next|cancel",0
gad_prev	dc.b	"play|save|format|prev|cancel",0
gad_format	dc.b	"return to findings",0
gad_format_p	dc.b	"patch|return to findings",0
gad_format_b	dc.b	"patch|convert|return to findings",0
gad_format_c	dc.b	"convert|return to findings",0
gad_one_e	dc.b	"more infos|cancel",0
gad_next_e	dc.b	"more infos|next|cancel",0
gad_both_e	dc.b	"more infos|prev|next|cancel",0
gad_prev_e	dc.b	"more infos|prev|cancel",0
gad_infos	dc.b	"return to findings|cancel",0
gad_okaye	dc.b	"okay|joke|right",0
gad_closehelp	dc.b	"close help",0
gad_quit	dc.b	"quit genie",0

; other text

OptWinTitle	dc.b	"pick menu",0
OptMenuName	dc.b	"options",0
txt_saveopts	dc.b	"save options",0
txt_hybrid	dc.b	'hybrid mode',0
txt_odd		dc.b	'odd addresses',0
txt_nameu	dc.b	"name unnamed",0
txt_pcnames	dc.b	"pc-style naming",0
txt_nofix	dc.b	"no name fixing",0	; bei name found kein add
						; load name ganz lassen
						; (off: replace load fix)
file_pattern	dc.b	'~(#?.info)',0
configname	dc.b	"DeliXFR-settings",0
configenv	dc.b	"ENV:DeliConfig",0
configpath	dc.b	"PROGDIR:DeliConfig",0
		blk.b	120+1,0

		even

vampirelogo	dc.w	0			; short	Leftedge
		dc.w	0			; short	TopEdge
		dc.w	132			; short	Width
		dc.w	19			; short	Height
		dc.w	2			; short	Depth
		dc.l	vampirelogo_gfx		; aptr	ImageData
		dc.b	%11			; ubyte	PlanePick
		dc.b	0			; ubyte	PlaneOnOf
		dc.l	0			; aptr	NextImage

		section	"data",bss

genieglobals	dc.l	0	; pbdelaycount
		dc.l	0	; task
delibase	dc.l	0
libbase		dc.l	0
DeliPort	dc.l	0
FormName	dc.l	0
		dc.l	0	; xfrobject
		dc.l	0	; this
		dc.l	0	; easy
		dc.w	0	; quitflag
		dc.l	0	; menustrip
		dc.l	0	; progress window
		dc.l	0	; progress window rastport
		dc.l	0	; pbdelay
		dc.w	0	; pbdonewidth
		dc.b	0	; g_pwsigbit
		dc.b	0	; options
		dc.l	0	; optionsobject
		dc.l	0	; delitracker screen
		dc.l	0	; visualinfo
		dc.l	0	; g_aslfilerequester
		blk.l	20,0	; parameter space (longs)
drawer_buffer	blk.b	256,0
filename_buffer	blk.b	256,0

		section	"image",data_c

vampirelogo_gfx	dc.w	$0000,$7800,$0000,$0000,$0000,$0000
		dc.w	$0000,$0000,$0000,$0000,$8000,$0000
		dc.w	$0000,$0000,$0000,$0000,$0000,$0000
		dc.w	$0005,$0000,$0000,$0008,$0000,$0000
		dc.w	$0000,$0000,$0000,$0008,$0000,$0000
		dc.w	$0008,$0000,$0000,$0000,$0000,$0000
		dc.w	$003C,$4000,$0000,$0020,$0000,$0000
		dc.w	$4000,$0000,$0000,$0048,$4000,$F801
		dc.w	$0000,$0000,$0000,$7800,$01E0,$0000
		dc.w	$018C,$43E0,$8C03,$0040,$0000,$0000
		dc.w	$000C,$C710,$0000,$0004,$2C30,$F804
		dc.w	$0000,$0000,$0000,$060D,$84E0,$0000
		dc.w	$0004,$2818,$6004,$0080,$0008,$086F
		dc.w	$0386,$0700,$0000,$0004,$1808,$3E84
		dc.w	$0100,$041C,$7C38,$C084,$03F0,$0000
		dc.w	$0004,$1008,$0004,$0000,$8626,$8610
		dc.w	$3086,$0000,$0000,$0006,$0000,$0000
		dc.w	$0206,$8121,$0310,$3080,$0000,$0000
		dc.w	$0000,$0000,$0004,$0408,$C1A1,$000D
		dc.w	$C180,$0110,$1000,$0000,$0000,$0004
		dc.w	$0808,$E0A0,$0008,$0000,$0111,$1000
		dc.w	$FF2F,$E0F8,$3F06,$300F,$9840,$0008
		dc.w	$0000,$0111,$2000,$3186,$318C,$6002
		dc.w	$C000,$0000,$0008,$0000,$0091,$4000
		dc.w	$3F06,$318C,$3E01,$8000,$0000,$0000
		dc.w	$0000,$0050,$8000,$3006,$318C,$0300
		dc.w	$0000,$0000,$0000,$0000,$0031,$0000
		dc.w	$30BF,$E0F8,$BE00,$0000,$0000,$0000
		dc.w	$0000,$0011,$0000,$0000,$0000,$0000
		dc.w	$0000,$0000,$0000,$0000,$0000,$0000
		dc.w	$0000,$3C00,$0000,$0000,$0000,$0000
		dc.w	$0000,$0000,$0000,$0000,$4000,$0000
		dc.w	$0000,$0000,$0000,$0000,$0000,$0000
		dc.w	$0002,$8000,$0000,$0004,$0000,$0000
		dc.w	$0000,$0000,$0000,$0000,$0000,$0000
		dc.w	$0004,$0000,$0000,$0000,$0000,$0000
		dc.w	$0016,$2000,$0000,$0010,$0000,$0000
		dc.w	$0000,$0000,$0000,$0020,$2000,$7000
		dc.w	$8000,$0000,$0000,$3C00,$00E0,$0000
		dc.w	$00C2,$01C0,$0601,$8020,$0000,$0000
		dc.w	$0002,$6308,$0000,$0002,$1600,$1C02
		dc.w	$0000,$0000,$0000,$0000,$C070,$0000
		dc.w	$0002,$0404,$0002,$0040,$0000,$0007
		dc.w	$0143,$0000,$0000,$0002,$0C04,$1F42
		dc.w	$0080,$0008,$380C,$4040,$01F8,$0000
		dc.w	$0000,$0804,$0002,$0000,$4212,$4008
		dc.w	$0843,$0000,$0000,$0003,$0000,$0000
		dc.w	$0103,$0010,$8180,$1840,$0223,$E000
		dc.w	$0000,$0000,$0002,$0204,$0050,$8006
		dc.w	$E0C0,$0222,$2000,$FF2F,$E0F8,$3F00
		dc.w	$0400,$6010,$0004,$0000,$0222,$4000
		dc.w	$3186,$318C,$6001,$1807,$CC20,$0004
		dc.w	$0000,$0122,$8000,$3F06,$318C,$3E00
		dc.w	$6000,$0000,$0004,$0000,$00A3,$0000
		dc.w	$3006,$318C,$0300,$C000,$0000,$0000
		dc.w	$0000,$0042,$0000,$30BF,$E0F8,$BE00
		dc.w	$0000,$0000,$0000,$0000,$0022,$0000
		dc.w	$0000

; Delitracker XFR Genie end
		END
