
		incdir	"include:"
		include	exec/types.i
		include	exec/funcdef.i
		include	exec/exec_lib.i
		include	"lvo.i"
		include	"dos/dos_lib.i"
		include	"misc/eagleplayer.i"
		include	"misc/eagleplayerengine.i"
		include	"misc/EaglePlayerRipper.i"
		include	"misc/DeliPlayer.i"
		include	"silva/easy.i"
		include	dos/dos.i
		include	intuition/intuition.i
		include	"f:xfr.i"
		include	f:xfr_lib.i

EAGLEXFR_VER	=	1
EAGLEXFR_REV	=	0
VERYEAR		=	2002
VERMONTH	=	12
VERDAY		=	23

EAGLEXFRVERSTR	MACRO

		dc.b	"IgelXFR v1 (12/2002) by silva@psi5.com",$a,$a

		dc.b	"rip with eXternal Format Rippers ",$a
		dc.b	"by Andreas G. Szabo / PseudoDOS",$a,$a

		dc.b	"http://www.psi5.com/~silva/afilter/",0

		ENDM


; EagleXFR commandos vom menu (jetzt keine)

	;	ENUM	EPNr_FirstExternal
	;	EITEM	ItemNr_

; EagleXFR option bits im oberten byte von EUT_Special

		BITDEF	exfr,hybrid,0
		BITDEF	exfr,odd,1
		BITDEF	exfr,pcs,2

; EagleXFR locale text nummern nach letztem bekannten
; aus den eagle includes

		ENUM	LNrE_ER_SecurityGadgets+1
		EITEM	LNrE_XFR_hybrid
		EITEM	LNrE_XFR_odd
		EITEM	LNrE_XFR_pcnames

;	ULONG	EUS_Jmp			;bra.s (bra.b) to the real start of the
;					;userprogram (usually direct after this
;					;struct	(MUST be a BRA.W !!!!!)
EUS_Structure	moveq	#-1,d0
		rts
;	STRUCT	EUS_Identifier,8	;Identifier "EPEngine"
;					;Eagleplayer can use this (Ampifiers)
		EUSN_Identifier				;EUS_Identifier
;	APTR	EUS_Next		;Don`t Use !!! only for Eagleplayer
		dc.l	0				;EUS_Next
;	UWORD	EUS_UserNr		;don`t change, only for Eagleplayer
		dc.w	0				;EUS_Usernr
;	APTR	EUS_EPBase		;Pointer to the Eagleplayerglobals
EPBase		dc.l	0				;EUS_EPBase
;	APTR	EUS_FreeTable
		dc.l	0				;EUS_FreeTable
;	APTR	EUS_TaskAdr		;if zero=kein Task
		dc.l	0				;EUS_TaskAdr = NULL
;	APTR	EUS_Unused1		;Future use (don't change)
		dc.l	0				;EUS_UnUsed1
;	APTR	EUS_Unused2		;Future use (don't change)
		dc.l	0				;EUS_UnUsed2
;	APTR	EUS_SpecialJumpTab	;private Jumptab (e.g Amplifiers)
		dc.l	0
;	APTR	EUS_TagList
		dc.l	TagListe			;EUS_Taglist
;	UWORD	EUS_Ticks		;Ticks for Interrupt (0=no Interrupt)
		dc.w	0				;EUS_Ticks
;	UWORD	EUS_TickCounter
		dc.w	0				;EUS_TickCounter
;	ULONG	EUS_TickFlags
		dc.l	0				;EUS_TickFlags
;	ULONG	EUS_MsgFlags
		dc.l	0 ;USMB_Configuration!USMB_SaveConfig
;	APTR	EUS_PName		;Processname of this Engine
;					;e.g. 'Analyzer.Task'
		dc.l	Engine_Name
;	APTR	EUS_Creator		;Creatorname e.g. "BUGGS" or "Eagleeye"
		dc.l	Creator_Name
;	APTR	EUS_AboutEngine		;tells something about this Engine.
		dc.l	About_Engine
;	UWORD	EUS_KickStart		;min Kickversion 0=All , 37 = OS 2.0
		dc.w	0
;	ULONG	EUS_EPVersion		;min. EagleplayerVersion
		dc.l	11
;	UWORD	EUS_Version		;Engine. Version	eg. 37 \not very
		dc.w	EAGLEXFR_VER
;	UWORD	EUS_Revision		;Engine. Revision eg.175 /important
		dc.w	EAGLEXFR_REV
;	APTR	EUS_UserName		;Name for PullDownMenu (max.14 Chars)
		dc.l	Engine_Name			;EUS_Username
;	UWORD	EUS_WinX		;User-Window X-Position
		dc.w	0				;EUS_WinX
;	UWORD	EUS_WinY		;User-Window Y-Position
		dc.w	0				;EUS_WinY
;	UWORD	EUS_Flags		;Flags (Iconify/ZipWindow,Window Open),
;					;see below
		dc.w	0 ;EUSF_Zipwin ;<- fenster zu, offen -> EUSF_Activate
;	ULONG	EUS_Special		;SpecialInfos (e.g. AnalyzerMode)
Options		dc.l	0
;	ULONG	EUS_Special2		;SpecialInfos (e.g. Windowsize)
		dc.l	0
;	ULONG	EUS_Special3		;more SpecialInfos
		dc.l	0
;	ULONG	EUS_CreatorDate		;Creatordate (e.g 14.b 6.b 1993.w)
		dc.b	VERDAY,VERMONTH
		dc.w	VERYEAR
;	UBYTE	EUS_Priority		;TaskPriority of Engine
		dc.b	0
;	UBYTE	EUS_Type		;Userprogramtype (0=unknown)
		dc.b	EUTY_Ripper
;	UWORD	EUS_Reserved2		;set zero, don`t change
		dc.w	0
;	ULONG	EUS_AMIDNr		;ID Kennung des Amplifiers,darf nur einmal vorkommen
		dc.l	0
;	ULONG	EUS_Reserved4		;set zero, don`t change
		dc.l	0
;	ULONG	EUS_AMUPSStruct		;set zero, don`t change
		dc.l	0
;	ULONG	EUS_Reserved6		;set zero, don`t change
		dc.l	0				;EUS_Reserved6

		ifne	(*-EUS_Structure)-EUS_SizeOF
		fail	Engine header SIZEOF mismatch.
		endc

		dc.b	"$VER: "
About_Engine	EAGLEXFRVERSTR
Engine_Name	dc.b	"EagleXFR",0
Creator_Name	dc.b	"PseudoDOS/silva@psi5.com",0
xfrlibname	XFRNAME
txt_hybrid	dc.b	'hybrid mode',0
txt_odd		dc.b	'odd addresses',0
txt_pcnames	dc.b	"pc-style naming",0
txt_scanning	dc.b	'XFR scanning %s',0
txt_xfrhave	dc.b	"eXternal Format Rippers have found a module.",0
txt_saved	dc.b	"The module has been successfully saved.",0
txt_notsaved	dc.b	"The module has NOT been saved.",0
msg_found	dc.b	'%s',$A,$A
		dc.b	'Formatname: %s',$A
		dc.b	'Modulename: %s',$A
		dc.b	'Filesize  : %ld bytes',$A,$A
		dc.b	'Please select your option.',0
msg_foundnosize	dc.b	'%s',$A,$A
		dc.b	'Formatname: %s',$A
		dc.b	'Modulename: %s',$A
		dc.b	'Filesize  : unknown (all rest will be saved)',$A,$A
		dc.b	'Please select your option.',0
txt_dowhat	dc.b	'_Play|_Continue|_Save|C_ancel',0
txt_dowhatlast	dc.b	'_Play|_Save|C_ancel',0
		even
TagListe:
		dc.l	EUT_InitEngine,FirstInit
		dc.l	EUT_ExitEngine,ExitEngine
		dc.l	EUT_Ripp,Ripp
		;dc.l	EUT_RippSegment,RippSegment
		dc.l	EUT_RippCont,RippCont
		;dc.l	EUT_RippExt,RippExt
		dc.l	EUT_EPSubItems,EP_Menu
		dc.l	EUT_Command,Commando
		dc.l	EUT_LocaleTable,LocaleTable
		;dc.l	EUT_SpecialinfoLNr,$302a ; ist das eine localenr?
						; $302a von Eagleripper
		dc.l	EUT_FreeRipperstruct,free_object
		dc.l	0

LocaleTable
;		dc.w	$302F
;		dc.l	txt_scanning
;lbL000ECC	dc.l	0
;		dc.w	$3032
;		dc.l	txt_unnamed
;lbL000ED6	dc.l	0
;		dc.w	$3030
;		dc.l	msg_found
;lbL000EE0	dc.l	0
;		dc.w	$3031
;		dc.l	msg_foundnosize
;lbL000EEA	dc.l	0
;		dc.w	$3033
;		dc.l	txt_dowhat
;lbL000EF4	dc.l	0

		dc.w	9
		dc.l	0
tpr_savereqtitle	dc.l	0

		dc.w	$A
		dc.l	0
tpr_save	dc.l	0
		; ende
		dc.w	0


; EagleXFR menu items und 

EP_Menu		; activate

		dc.l	.line			;Next
		dc.w	0			;Left Edge
		dc.w	0			;Verti Pos.
		dc.w	0			;Width-Size (Negationbreite)
		dc.w	10			;Hight-Size
		dc.w	$5B
		dc.l	0
		dc.l	.ActivateIText
		dc.l	0
		dc.b	0
		ds.b	7
		dc.l	0			*Kick2.04
.ActivateIText	dc.b	0,3
		ds.w	2
		dc.w	1
		dc.l	0			*Topaz80
		dc.l	0			*Active.MSG (filled by EP)
		dc.l	0
		dc.w	EPNr_MainWindow
		dc.w	LNr_Active

.line		; separator

		dc.l	.hybrid			;Next
		dc.w	0			;Left Edge
		dc.w	0			;Verti Pos.
		dc.w	0			;Width-Size (Negationbreite)
		dc.w	6			;Hight-Size
		dc.w	$c0
		dc.l	0
		dc.l	.BarlabelImage
		dc.l	0
		dc.b	0
		ds.b	7
		dc.l	0			*Kick2.04
.BarlabelImage	dc.b	0,2			*FronPen/BackPen
		dc.w	2,0			*DrawMode/KludgeFill // LeftEdge
		dc.w	2			*TopEdge
		dc.l	0			*Font
		dc.l	1			*ITIText
		dc.l	0			*NextText
		dc.w	0			*EPNr
		dc.w	0			*LocaleNr

		; options

.hybrid		dc.l	m_odd
		dc.l	0
		dc.l	10
m_hybrid_sel	dc.b	0
		dc.b	$5B
		dc.b	0
		dc.b	0
		dc.b	0
		dc.b	0
		dc.l	m_hybrid_text
		blk.b	16,0
m_hybrid_text	dc.l	$30000
		dc.l	1
		dc.l	0
		dc.l	txt_hybrid
		dc.l	0
		dc.w	0
		dc.w	LNrE_XFR_hybrid

m_odd		dc.l	m_pcs		; next
		dc.w	0		; left edge
		dc.w	0		; top edge
		dc.w	0		; width
		dc.w	10		; height
m_odd_sel	dc.w	$5b		; flags
		dc.l	0		; mutualexclude
		dc.l	m_txt_odd	; itemfill
		dc.l	0		; selectfill
		dc.b	0,0		; command, pad
		dc.l	0		; subitem
		dc.w	0		; nextselect
		dc.l	0
m_txt_odd	dc.l	$30000
		dc.l	1
		dc.l	0
		dc.l	txt_odd
		dc.l	0
		dc.w	0		; kein commando
		dc.w	LNrE_XFR_odd

m_pcs		dc.l	0		; next
		dc.w	0		; left edge
		dc.w	0		; top edge
		dc.w	0		; width
		dc.w	10		; height
m_pcs_sel	dc.w	$5b		; flags
		dc.l	0		; mutualexclude
		dc.l	m_txt_pcs	; itemfill
		dc.l	0		; selectfill
		dc.b	0,0		; command, pad
		dc.l	0		; subitem
		dc.w	0		; nextselect
		dc.l	0
m_txt_pcs	dc.l	$30000
		dc.l	1
		dc.l	0
		dc.l	txt_pcnames
		dc.l	0
		dc.w	0		; kein commando
		dc.w	LNrE_XFR_pcnames

* Input: d0=EPNr_Nummer
*	 Rest = Parameter
* Output:d0=Error oder NULL

; ich brauche jetz keine, aber mit (leerer) routine kommt die gleich
; meldung wie bei eagleripper (command done) und ganz ohne routine 
; kommt "STRING ERROR"

Commando:
;		cmp.w	#EPNr_EngineItemCommand,d0
;		bne.b	.null

		; vom menu

		move.w	m_pcs_sel(pc),d0
		and.w	#CHECKED,d0
		lsl.w	#1,d0
		move.w	m_odd_sel(pc),d1
		and.w	#CHECKED,d1
		or.w	d1,d0
		lsl.w	#1,d0
		move.w	m_hybrid_sel(pc),d1
		and.w	#CHECKED,d1
		or.w	d1,d0
	;	lsl.w	#1,d0

		lea	Options(pc),a0
		move.w	d0,(a0)

;		cmp.w	#ItemNr_,d2
;		bne.b	.if_

;.if_		cmp.w	#ItemNr_,d2
;		bne.b	.null

.null		moveq	#0,d0
		rts


; return NULL oder Error

FirstInit	pushm	d1-a6
		moveq	#XFRVERSION,d0
		lea	xfrlibname(pc),a1
		move.l	$4.w,a6
		jsr	_LVOOpenLibrary(a6)
		tst.l	d0
		beq.b	.return_err
		lea	libbase(pc),a0
		move.l	d0,(a0)
		move.l	d0,a6

		; settings

		move.w	Options(pc),d1
		move.w	d1,d0
		and.w	#CHECKED,d0
		lea	m_hybrid_sel(pc),a0
		or.w	d0,(a0)
		lsr.w	#1,d1
		move.w	d1,d0
		and.w	#CHECKED,d0
		lea	m_odd_sel(pc),a0
		or.w	d0,(a0)

		btw	xfrBB_ODDCPU,xfrB_flags(a6)
		bne.b	.pcs
		eor.w	#ITEMENABLED,(a0)

.pcs		lsr.w	#1,d1
	;	move.w	d1,d0
		and.w	#CHECKED,d1
		lea	m_pcs_sel(pc),a0
		or.w	d1,(a0)

		moveq	#0,d0
.return		popm	d1-a6
		rts
.return_err	; v: get update requester

		moveq	#EPR_UnknownError,d0
		bra.b	.return

libbase		dc.l	0

ExitEngine	pushm	d1-a6
		move.l	libbase(pc),a1
		move.l	$4.w,a6
		jsr	_LVOCloseLibrary(a6)
		moveq	#0,d0
		popm	d1-a6
		rts


*------------------- Ripperstruct (returned bei EUT_Ripp) --------------------*
; (from EaglePlayerRipper.i is needed for all eagleplayer
;  ripper engines, though this has not been well documented as the
;  file is made mainly of eagleripper specific definitions)

;	STRUCTURE EagleRipper,0
;	APTR	ERPSS_Position			*while ripping
;	APTR	ERPSS_MemStart			*Start ripping
;	ULONG	ERPSS_MemSize			*Size ripping
;	APTR	ERPSS_Segment			*Start of first Segment
;	APTR	ERPSS_CurrentSegmentPosition
;	APTR	ERPSS_CurrentSegmentSize
;	APTR	ERPSS_Tags
;	APTR	ERPSS_Formatname
;	APTR	ERPSS_Modulename
;	APTR	ERPSS_Comment
;	APTR	ERPSS_FilePtr			*current Adr
;	LONG	ERPSS_FileSize
;	LONG	ERPSS_FileNr
;	LONG	ERPSS_EngineNr			*filled by Eagleplayer
;	LONG	ERPSS_FormatId			*private for Ripper
;	LONG	ERPSS_Ripperstruct		*private for Ripper
;	LONG	ERPSS_Private1			*private for Ripper
;	LONG	ERPSS_Private2			*private for Ripper
;	LONG	ERPSS_Private3			*private for Ripper
;	LABEL	ERPSS_SizeOf			*to be extended!

; ERPSS_Ripperstruct is named ambiguous with the EagleRipper structure
; itself (especially its commented title) but this time is the the
; private-to-engine part of the stuff.

*-----------------------------------------------------------------------------*
* Input: a0=StartMemAdr
*	 d0=MemSize
*	 a1=FileName
* Output:d0=Error oder NULL
*	 a0=ModuleStart
*	 d1=ModuleSize
*	 a1=RipperStruct		(only Read)
*-----------------------------------------------------------------------------*

Ripp		pushm	d2-d7/a2-a6
		movem.l	d0/a0/a1,-(a7)

		; make ripeprstruct and xfrObject for shared buffer

		move.l	libbase(pc),a6

		move.l	#ERPSS_SizeOf+256+256,d0
		jsr	_LVOxfrMAlloc(a6)
		tst.l	d0
		beq.b	.err_mem

		; init file path name buffer

		move.l	d0,a3
		lea	ERPSS_SizeOf(a3),a0
		move.l	a0,ERPSS_Private2(a3)	; filepath space
		lea	256(a0),a0
		move.l	a0,ERPSS_Private3(a3)	; filename space

		moveq	#xfrOBJECT_EMPTY,d1
		jsr	_LVOxfrCreateObject(a6)
		move.l	d0,ERPSS_Ripperstruct(a3)
		bne.b	.scan

		; no object

		move.l	a3,a1
		jsr	_LVOxfrMFree(a6)

.err_mem	lea	12(a7),a7
		moveq	#EPR_NotEnoughMem,d0
		bra.b	raus

.scan		move.l	EPBase(pc),a4
		lea	txt_scanning(pc),a0
		lea	8(a7),a1
		push	d0
		jsr	ENPP_InitDisplay(a4)
		pop	a1	; hier kommt a1

		move.l	(a7)+,d0
		move.l	d0,xfrO_size(a1)
		move.l	d0,ERPSS_MemSize(a3)
		move.l	(a7)+,d0
		move.l	d0,xfrO_start(a1)
		move.l	d0,ERPSS_Position(a3)
		move.l	d0,ERPSS_MemStart(a3)
		moveq	#xfrOF_SHARED,d0
		or.w	d0,xfrO_flags(a1)

		addq.l	#4,a7

		moveq	#xfrMODEF_HOOK,d1
		lea	scanhook(pc),a2
		;move.l	

		move.b	Options(pc),d0
		btst	#exfrB_hybrid,d0
		beq.b	.if_odd
		or.w	#xfrMODEF_HYBRID,d1
.if_odd		btst	#exfrB_odd,d0
		beq.b	.do_scan
		or.w	#xfrMODEF_SCANODD,d1

.do_scan	jsr	_LVOxfrScan(a6)
		push	d0

		jsr	ENPP_RemoveDisplay(a4)

		pop	d0
		bge.b	.if_found

		moveq	#EPR_UnknownError,d0
		bra.b	err_free

.if_found	; first found

		move.l	ERPSS_Ripperstruct(a3),a0
		move.l	xfrO_firstchild(a0),d0

get_next	tst.l	d0
		beq.b	.no
		move.l	d0,a1
		move.l	xfrO_next(a1),d0
		tst.w	xfrO_state(a1)
		ble.b	get_next	; v: report errored results

		move.l	d0,ERPSS_Private1(a3)

		; reset name buffer so that new name is copied
		move.l	ERPSS_Private3(a3),a0
		clr.b	(a0)

		lea	txt_xfrhave(pc),a2
		move.l	a2,d5

.req_again	lea	msg_found(pc),a2

		move.l	xfrO_size(a1),d1
		bne.b	.get_start

		lea	msg_foundnosize(pc),a2
		move.l	ERPSS_Ripperstruct(a4),a0
		move.l	xfrO_start(a0),d1
		add.l	xfrO_size(a0),d1
		sub.l	xfrO_start(a1),d1
		move.l	d1,xfrO_size(a1)
		moveq	#-1,d1		; to eagleplayer found no size

.get_start	move.l	xfrO_format(a1),a5
		move.l	xfrF_short(a5),d3
		move.l	d3,ERPSS_Formatname(a3)
		move.l	xfrO_text(a1),ERPSS_Comment(a3)
		move.l	xfrO_name(a1),d4
		bne.b	.set_name
		move.l	xfrB_defaultname(a6),d4
.set_name	move.l	d4,ERPSS_Modulename(a3)

		move.l	a2,EPG_ARG1(a4)
		move.l	EPG_PubScreen(a4),EPG_ARG2(a4)
		moveq	#-1,d2
		move.l	d2,EPG_ARG3(a4)
		lea	txt_dowhat(pc),a2
		tst.l	ERPSS_Private1(a3)
		bne.b	.set_opts
		lea	txt_dowhatlast(pc),a2
.set_opts	move.l	a2,EPG_ARG4(a4)
		clr.l	EPG_ARG5(a4)
		move.l	d1,-(a7)	; size
		move.l	d4,-(a7)	; name
		move.l	d3,-(a7)	; format
		move.l	d5,-(a7)
		move.l	a7,EPG_ARG6(a4)
		move.l	d2,EPG_ARG7(a4)
		clr.l	EPG_ARG8(a4)
		moveq	#8,d2
		move.l	d2,EPG_ARGN(a4)
		pushm	d1/a1
		jsr	ENPP_TextRequest(a4)
		popm	d1/a1
		lea	16(a7),a7

		move.l	ERPSS_Private1(a3),d0

		move.l	EPG_ARG1(a4),d2
		subq.l	#1,d2
		beq.b	.play
		tst.l	ERPSS_Private1(a3)
		beq.b	.if_save
		subq.l	#1,d2
		beq.b	get_next
.if_save	subq.l	#1,d2
		beq.b	.save
		subq.l	#1,d2
		beq.b	.abort

		moveq	#EPR_CantOpenWin,d0	
		bra.b	err_free


.abort		moveq	#EPR_Functionaborted,d0
		bra.b	err_free

.save		move.l	tpr_savereqtitle,EPG_ARG1(a4)
		move.l	ERPSS_Private2(a3),EPG_ARG2(a4)
		push	a1

		move.l	xfrO_format(a1),a2

		move.l	ERPSS_Private3(a3),a1
		move.l	a1,EPG_ARG3(a4)
		tst.b	(a1)
		bne.b	.hasname

		move.l	ERPSS_Modulename(a3),d1
		moveq	#0,d2
		move.w	m_pcs_sel(pc),d0
		and.w	#CHECKED,d0
		beq.b	.nonumber
		moveq	#-1,d2
.nonumber	moveq	#0,d3
		jsr	_LVOxfrFixName(a6)

.hasname	clr.l	EPG_ARG4(a4)
		clr.l	EPG_ARG5(a4)
		move.l	tpr_save(pc),EPG_ARG6(a4)
		moveq	#6,d0
		move.l	d0,EPG_ARGN(a4)
		move.l	$84(a4),a0
		jsr	(a0)

		move.l	EPG_ARG1(a4),d0
		beq.b	.notsaved
		
		move.l	ERPSS_Private2(a3),a2
		tst.b	(a2)
		beq.b	.save_object
		move.l	a2,d1
		moveq	#ACCESS_READ,d2
		move.l	dtg_DOSBase(a4),a6
		jsr	_LVOLock(a6)
		move.l	d0,d3
		beq.b	.doserr
		move.l	d0,d1
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d4

.save_object	move.l	ERPSS_Private3(a3),a0
		move.l	libbase(pc),a6
		move.l	(a7),a1
		jsr	_LVOxfrSaveObject(a6)

		push	d0

		tst.b	(a2)
		beq.b	.if_saved
		move.l	dtg_DOSBase(a4),a6
		move.l	d4,d1
		jsr	_LVOCurrentDir(a6)
		move.l	d3,d1
		jsr	_LVOUnLock(a6)

.if_saved	pop	d0
		bmi.b	.xfrsaveerr

		lea	txt_saved(pc),a2
		bra.b	.set_savestate
.doserr		moveq	#xfrERROR_DOS,d0
.xfrsaveerr	move.l	libbase(pc),a6
		jsr	_LVOxfrGetErrorText(a6)
		move.l	d0,a2
		bra.b	.set_savestate
.notsaved	lea	txt_notsaved(pc),a2
.set_savestate	move.l	a2,d5
		pop	a1
		bra.b	.req_again

.play		move.l	xfrO_start(a1),a0
		move.l	a0,ERPSS_FilePtr(a3)	;	*current Adr
		move.l	d1,ERPSS_FileSize(a3)
		moveq	#1,d2
		move.l	d2,ERPSS_FileNr(a3) ; ?ext

		; return ripper structure

		move.l	a3,a1
		moveq	#0,d0
		bra.b	raus

.no		moveq	#EPR_UnknownFormat,d0
err_free	push	d0
		move.l	ERPSS_Ripperstruct(a3),a1
		jsr	_LVOxfrFreeObjects(a6)
		move.l	a3,a1
		jsr	_LVOxfrMFree(a6)
		pop	d0
raus		popm	d2-d7/a2-a6
		rts

;	EITEM	EUT_RippCont		*Fhrt die Suche nach Modulen fort.
;					*Input: a0=Ripperstruct
;					*Output:d0=Error oder NULL
;					*	d1=ModuleSize
;					*	a0=Modulestart
;					*	a1=Ripperstruct (read only)

RippCont	pushm	d2-d7/a2-a6
		move.l	libbase(pc),a6
		moveq	#EPR_FatalError,d0
		move.l	a0,d1	; tst
		beq.b	raus
		move.l	a0,a3
		move.l	ERPSS_Private1(a3),d0
		move.l	EPBase(pc),a4
		bra.b	get_next

;just notes
;				; the average progress bar method, much
;				; more simple and takes much more time,
;				; so only done constantly every xth pos
;	UWORD	g_16bitdivisor		; totalsize multiplied by 2 for
;	UBYTE	g_numberofrols		; numberofrols times after a swap
;					; until bit 15 is set

scanhook	; allways draw last step (updates also every 65536st
		; round; commented out because ep 2.01 seems to be
		; buggy not to draw anything for the last few prth.)

		; past op, you never get the values for after the last
		; step, which were needed to get a full bar from only
		; the postition you get in a0, so in that before last
		; situation d6 and d7 is what?

		;cmp.l	d7,d6
		;ble.b	.update

		; update every 256*4 calls (is * 2 bytes in even mode)

		subq.b	#1,xfrCom_hookdata(a4)
		beq.b	.step2
.rts		rts
.step2		addq.b	#1,xfrCom_hookdata+1(a4)
		cmp.b	#5,xfrCom_hookdata+1(a4)
		blt.b	.rts
		clr.b	xfrCom_hookdata+1(a4)

.update		; calc per-thousands of done in relatio to size
		;
		; done * 1000 / size

		move.l	a0,d0			; current position
		move.l	xfrCom_object(a4),a1
		sub.l	xfrO_start(a1),d0
		move.l	xfrO_size(a1),d1

		swap	d0			; done
		swap	d1			; size
.NextBit:	btst	#15,d1
		bne.s	.LastOne
		rol.l	#1,d0
		rol.l	#1,d1
		bra.s	.NextBit

.LastOne:	and.l	#$ffff,d0
		beq	.check_stop		; starting with a size >
						; 65535 and doubles a
						; growing ammount of done
						; bytes means 0 here
				; nervertheless goes into FillDisplay()
				; to catch an a possible user break

		mulu	#1000,d0
		divu	d1,d0

		; same value no redraw

		cmp.w	xfrCom_hookdata+2(a4),d0
		beq.b	.no_redraw
		move.w	d0,xfrCom_hookdata+2(a4)

		; redraw / ceck for break

.check_stop	move.l	EPBase(pc),a0
		jsr	ENPP_FillDisplay(a0)

		tst.l	d0
		bne.s	.stop

.no_redraw	moveq	#0,d0
		rts
.stop		moveq	#xfrRETURN_SCANSTOP,d0
		rts


free_object	; gets a0 *ripperstructure (? xfrObject oder EPRSS_R..?)

		pushm	d2-d7/a2-a6
		move.l	a0,d0
		beq.b	.return
		move.l	a0,a3

		move.l	libbase(pc),a6
		move.l	ERPSS_Ripperstruct(a3),d0
		beq.b	.free_rs
		move.l	d0,a1
		jsr	_LVOxfrFreeObjects(a6)
.free_rs	move.l	a3,a1
		jsr	_LVOxfrMFree(a6)
.return		popm	d2-d7/a2-a6
		rts


; EagleXFR
		END
