;@database xfr.i

	IFND LIBRARIES_XFR_I
LIBRARIES_XFR_I	SET	1

; $VER: xfr.library   eXternal Format Rippers
;
; -----------------------------------------------------
; m68k assembler includefile and developer informations
; -----------------------------------------------------
;
; version 2.2 (4/12/2003) by PseudoDOS silva@psi5.com
; version 3 (10/2009) by Andreas G. Szabo
;
; (C) Andreas G. Szabo all rights reserved


	IFND EXEC_TYPES_I
	include "exec/types.i"
	ENDC
	IFND EXEC_LIBRARIES_I
	include "exec/libraries.i"
	ENDC
	IFND UITLITY_TAGITEM_I
	include	"utility/tagitem.i"
	ENDC

XFRVERSION	SET	3

XFRNAME		MACRO
		dc.b	"xfrmaster.library",0
		ENDM


XFRLIST_END	EQU	0


; note: all strings must be terminated with 0,
;
;       except the optional magic 4 bytes f.e. "M.K."
;	that are placed directly in the structures as
;	a long word

;	the "v:" in the comments is to remind me for possible
;	update ideas for annother version of xfr, that i had


;@node "main"
;	structures
;
;	@{" xfrBase " Link "xfrbase"}
;	@{" " Link ""}
;	@{" " Link ""}
;	@{" " Link ""}
;
;	@{" " Link ""}
;
;@endnode
;@node "xfrbase"

; XFR library base
; ----------------

 STRUCTURE	xfrBase,LIB_SIZE

	; all here is READ ONLY

	UWORD	xfrB_flags	; see below

	ULONG	xfrB_sysbase	; *execbase, you should use this instead
				; of $4 in a client (!)
	ULONG	xfrB_dosbase	; you may use this, so do not need
				; to open dos.library

	ULONG	xfrB_minbytes	; this is the minimum of a partial file
				; that must be in memory for Identify()
				; of objects with xfrOF_MINIMAL set;
				; files that are smaller in total are
				; allways welcome

	ULONG	xfrB_hiscore	; the number of detectable formats

	APTR	xfrB_clients	; all loaded xfrClient
	APTR	xfrB_formats	; all xfrFormat(s) linked via
				; xfrF_nextformat

	APTR	xfrB_checkers	; PRIVATE maybe changes in future version,
				; do not use
	APTR	xfrB_checkers_d ; ...
	APTR	xfrB_scanners	; ...
	APTR	xfrB_scanners_d ; ...
	APTR	xfrB_defaultname	; STRPTR default filename
	LABEL	xfrB_SIZEOF

; xfrBase.xfrB_flags

	BITDEF	xfrB,ODDCPU,0	; the cpu is able to r/w odd adr
	BITDEF	xfrB,NEXTRUN,15 ; PRIVATE

;@endnode


; memory objects
; --------------

; object structure that marks or holds a range of data in memory
; or within annother objects range

 STRUCTURE	xfrObject,0

	; the followin entrys can be set after xfrCreateObject(EMPTY)

	LABEL	xfrO_adr
	APTR	xfrO_start		; ptr to the memory
	LABEL	xfrO_len
	APTR	xfrO_size		; lenght of the memory/range

	APTR	xfrO_buffersize		; size for custom allocated buffer

	APTR	xfrO_position		; for scan, rescan and continue

				; If the scan stops for some reason, xfr
				; stores the reached position here and
				; you may call xfrScan() again to let it
				; continue. From the program you may also
				; write here a position where a scan
				; should continue or a rescan should start.

				; Rescan is simply a term for the case if
				; xfr found something falsely and you want
				; these to be ignored in a second pass.
				; Just change the state of the falsely
				; found object(s) (childs) to the matching
				; state value (see returncodes), copy the
				; xfrO_position from the first faulty
				; child to xfrO_position of its parent
				; and call xfrScan() on that parent object
				; again.

	UWORD	xfrO_flags		; see below

	ULONG	xfrO_user		; for YOUR own purposes,
					; will be ignored by xfr and clients

	; all the following will be set by XFR and its Clients
	; and are READ ONLY if not specially mentioned else somewhere

	APTR	xfrO_format		; ptr to an xfrFormat structure
	APTR	xfrO_custom		; may be freely used by program

	LABEL	xfrO_error
	WORD	xfrO_state		; see returncodes >>

	APTR	xfrO_name		; these strings allocated by XFR
	LABEL	xfrO_value		; n/i
	APTR	xfrO_text		;  xfrFreeObjects()

	APTR	xfrO_parent		; memory/object that this one
					; is part of

	APTR	xfrO_next		; next object
					; this can be annother found thing
					; or annother part of a found thing
xfrO_nextchild	EQU	xfrO_next


	APTR	xfrO_firstchild		; first object that belongs to
					; this one somehow

					; case 1:

					; after xfdScan() and if this is
					; the input object the found objects
					; will start from here

					; case 2:

					; if this object is a found object
					; from the list described in case 1
					; or if it is an identified object
					; by xfrIdentify() then a list of
					; secondary parts that belong to this
					; object starts here

					; if xfrMODEF_GETINFO was used, the
					; parts that are subparts are
					; marked by xfrOF_EXTERN

	APTR	xfrO_extcom		; PRIVATE to CLIENT, optional to
					; carry information to _extrip

	APTR	xfrO_comment		; comment of file loaded / to save

	ULONG	xfrO_seglist		; if set, this object is a header to others linked via
					; xfrO_next
	LABEL	xfrO_SIZEOF


; xfrObject.xfrO_flags

	BITDEF	xfrO,SHARED,0		; with this bit the buffer memory
					; of this object will NOT be freed
					; by xfrFreeObjects()

					; (program may set this)

	BITDEF	xfrO,EXTERN,1		; this object marks a separate
					; memory range (f.e. tfmx samples)
					; that must be saved as annoter
					; file

	BITDEF	xfrO,MODIFIED,3		; the memory of start/size was
					; modified by a client,
					; this is supposed to be set after
					; a call to xfrPatch()

	BITDEF	xfrO,BYDEEP,4		; detected by a deep recognition
					; routine (in either xfrMODE_DEEP
					; or xfrMODE_HYBRID)

	BITDEF	xfrO,MINIMAL,6		; buffer is the minimal portion
					; of a file (offset 0)

	BITDEF	xfrO,DEFAULTNAME,8	; the name is not a name from a
					; module but a default name given
					; by the ripper

	BITDEF	xfrO,ERRORTEXT,9	; client may put a pointer to an
					; error text into xfrO_text in
					; case of an error; then set the
					; xfrO_state to an XFR error code
					; (xfrERROR_FAIL for not defined)
					; and set this bit;
					; (this bit is defined because in
					;  case of an error the xfrO_text
					;  field may contain crap but it
					;  may be used for an error text)

	BITDEF	xfrO,NAMEALLOC,10
	BITDEF	xfrO,TEXTALLOC,11

	BITDEF	xfrO,MEMORY,12		; this object holds a memory range
					; this is info to app e.g. when it
					; wont eor-code or save whole mem

;	BITDEF	xfrO,INFO,		; n/i
;	BITDEF	xfrO,VALUE,		; n/i

	; PRIVATE

	BITDEF	xfrO,RESULTDONE,15


; modes for xfrCreateObject()

; XFR object structure only, see guide for how to apply a custom buffer

xfrOBJECT_EMPTY		= 0


; with auto-allocated and freed buffer, see guide for how to keep the
; buffer when freeing the object

xfrOBJECT_BUFFER	= 1
				

; for chipmem you do get a single object as in allmost any other case,
; too, containing the area of chipmem as xfrO_start and xfrO_size;
; the xfrOF_SHARED bit has been set and you may free this object normally
; (as in amithon f.e. there are more than one chipram areas, the chipram
; area used here will allways be the one starting at $0 and its size
; defined by MaxLocMem of execbase. this is the ram area formerly known
; as _the_ chip memory)

xfrOBJECT_CHIPRAM	= 2
xfrOBJECT_CHIPMEM	EQU	xfrOBJECT_CHIPRAM


; for fastmem its the same except you do get a linked objects via
; xfrO_next, one for each fast memory area, where every object you must
; scan extra; then you may free all together by freeing the first

xfrOBJECT_FASTRAM	= 3
xfrOBJECT_FASTMEM	EQU	xfrOBJECT_FASTRAM


; same way as for fastmem you can get all ram areas at once, inclusive
; and starting with all chip ram areas, this time all defined by the
; exec memory list (and thus _not_ starting accurately at $0)

xfrOBJECT_RAM		= 8


xfrOBJECT_KICKROM	= 4	; for hackers


xfrOBJECT_FILE		= 5	; does xfrOBJECT_BUFFER and read a file
				; into
xfrOBJECT_MINFILE	= 6	; does xfrOBJECT_BUFFER and read the
				; minimal portion of a file into;
				; only works for xfrIdentify() and for
				; some formats it doesnt work at all
xfrOBJECT_DISK		= 7	; read all tracks from a disk in a drive

xfrOBJECT_LOADSEG	= 9	; try open and relocate program


; modes for xfrScan(), xfrIdentify()
;
; They are copied to xfrCom_modeflags, from where a client may
; read them (or test em there).

xfrMODE_PLAIN		= 0		; only simple checks,
					; only even addr in Scan()

	BITDEF	xfrMODE,DEEP,0		; use the deep recogniton routines
					; (can take much more time)

					; DEEP is not meant to find every-
					; thing. some formats may only be
					; found in normal mode. DEEP may
					; be used as annother pass.

	BITDEF	xfrMODE,SCANODD,1	; processor compatibility
					; is checked by XFR and
					; you can also check the ODDCPU
					; flag in xfrBase before

					; do _not_ use this when you know
					; all data of interest to be at
					; even addresses.
					; Not using this does approximately
					; halve scan time.

	BITDEF	xfrMODE,HOOK,2		; use a hook routine in the scan,
					; see doc at xfrScan() for specs

	BITDEF	xfrMODE,HYBRID,3	; combined use of normal and
					; deep scan recognition routines;
					; overrides the DEEP mode as it
					; does normal recognition _and_
					; deep recognition in same pass

					; (the DEEP bit is toggled on for
					;  deep turns in xfrCom_modeflags,
					;  so the deep call is indicated
					;  with xfrMODE?_DEEP in any mode
					;  for a case where you use the
					;  same part of program code from
					;  both normal and deep entrys)

; n/i	BITDEF	xfrMODE,NORARE,		; exclude rare formats, scan
;					; will be remarkably faster
;					; if there are many of them
; n/i	BITDEF	xfrMODE,NONRELYABLE,	; do also involve formats that
;					; cannot be relyably found or
; tell me why you need these features	; that usually produce false
					; results or that miss the sizes
					; calculations

	; others are set by XFR automatedly

	BITDEF	xfrMODE,MINIMAL,6	; processing a minimal portion
					; of a file

	BITDEF	xfrMODE,SCAN,15		; read only: now is a scan done,
					; flag is set by xfrScan()

	; a client may read all above flags from xfrCom_modeflags


;-------------------------------------------------------------------------
; tags for xfrSaveObject()


	ENUM	TAG_USER

; first follows a tag, then its parameter/type and description


	EITEM	XFR_OVERWRITE	; BOOL

; overwrite a file if exists.


	EITEM	XFR_ADDNUMBER	; BOOL

; add and increase a number for any existing file like this: if "filename"
; exists, filename would be "filename (1)". if filename (1) existsts,
; filename would be "filename (2)" and so on. This does override the
; XFR_OVERWRITE tag.


	EITEM	XFR_FIXNAME	; BOOL

; append pre and post fixes from the object format to the name


	EITEM	XFR_PCSTYLENAME	; BOOL

; use pc style suffix order. this tag is directly passed to xfrFixName()
; but does only work if the fixname tag is also passed TRUE


	EITEM	XFR_FILENAME	; STRPTR

; override object or passed name by this name


	EITEM	XFR_DEFAULTNAME	; STRPTR

; use this default name when the object itself has no name set
; (the default defaultname is "unnamed")


;-------------------------------------------------------------------------
; memory types for xfrMalloc() and xfrCreateObject():

; with/for xfr you can allocate either from any available memory
; or especially from chipmem. per default the memory is cleared
; by exec, optionally this can be turned of. there is no separate
; method for forced fastmem allocation.

; These modes here work in a very different way than known from exec.
; If the buffer for the object or the memory to allocate has to
; have a defined size and you also need one or more of the types from
; below, you have to combine your requested size with these type(s).
; My xfr-memory-type definers use the high bits 31 and 30 as seen in
; the game lotus esprit turbochallenge and some lucasarts adventures.
; So you may do the combining by using a logical OR. You can also do it
; by a bset instruction or similar, _BUT_,
; the _addition_ of xfrMALLOCF_NOCLEAR may produce false results.


xfrMALLOC_PUBLIC	= 0	; any available memory
				; (has _no_ "F" or "B" in the name)

xfrMALLOC_ANY	EQU	xfrMALLOC_PUBLIC
xfrMALLOC_PUB	EQU	xfrMALLOC_PUBLIC

	BITDEF	xfrMALLOC,NOCLEAR,31	; xfrMALLOCF_NOCLEAR
					; this is faster but allocated
					; memory may be filled with crap;
					; (this is automatically used at
					;  xfrCreateObject() with
					;  xfrOBJECT_FILE, xfrOBJECT_DISK
					;  and xfrOBJECT_MINFILE)

	BITDEF	xfrMALLOC,CHIPMEM,30	; xfrMALLOCF_CHIPMEM
					; (at xfrCreateObject() you may
					;  load into chipmem a file or
					;  disk type object)

					; [bit 30 is same meaning at
					;  dos hunk types]
xfrMALLOC_SIZEMASK	= $3fffffff
xfrMALLOC_TYPEMASK	= $c0000000



; return codes / errors / object state in xfrO_state
; --------------------------------------------------

xfrRETURN_NO		=	0	; default
xfrRETURN_YES		=	1

xfrRETURN_SCANSTOP	=	2	; by the hook


; v: maybe define the above 1 and 2 as bit 0 and 1 so that a scan
;    can return with a bit signaling that xfr found something and
;    the other signaling the had been stopped (break)
;    ersma sehn das wie extract und extscan funktioniert und ob
;    man dann noch den returncode von scan in das parent objekt
;    schreiben kann


; negative values are an errorcode / error-state of objects

; The error codes now mainly are only of interest to the program-side.
; Except for FAIL and MEMORY you must not and do not need to set the
; error code from -1 to -12 from your client. FAIL is an emergency code
; and MEMORY must be set when it is out. More down the text passage are
; other error codes that may be set from within a client

xfrERROR_CPU		= -1	; odd adr attempted on even-only cpu,
				; to prevent this, read the flag
				; xfrBF_ODDCPU in xfr library base
				; before using xfrMODEF_ODD
xfrERROR_MEMORY		= -2	; memory allocation failed,
				; in some internal cases this does
				; STOP an ongoing scan (!)
xfrERROR_FAIL		= -3	; something went wrong,
				; cannot describe details but
				; maybe they are obvious
xfrERROR_OBJECT		= -4	; object of wrong type or state
xfrERROR_FORMAT		= -5	; format does not support function
xfrERROR_DOS		= -6	; for CreateObject( _FILE),
				; program can do an IOErr()
				; to get the details
xfrERROR_MODE		= -7	; mode mismatch or illegal;
				; may also happen when trying create
				; an object of a type that does not exist
xfrERROR_VERSION	= -8	; current version of xfr
				; does not support what prg
				; requested it to do
				; (I guess this never happens)
xfrERROR_NODISK		= -9	; no disk in drive
xfrERROR_DISK		= -10	; disk error
xfrERROR_NOSIZE		= -11	; no data size
xfrERROR_POSITION	= -12	; scan position beyond range
				; (when set or changed by program)

; Do _not_ use the next three in your client. they are set automatedly by
; XFR when no other code has been returned by your client. Also #-15 is
; ambigous in meaning. XFR cannot distinguish the reason for the size
; difference, wether it is because there are bytes missing or because the
; calculation is false. Its up to the user to decide how it is meant and
; to the programmer for debugging purposes.

xfrERROR_SIZELARGER	= -15	; calculated size larger than data
xfrERROR_SIZENEGATIVE	= -16	; calculated size negative
xfrERROR_START		= -13	; calculated start beyond range

; When you know better the reason in your client, you may set the next two
; error codes from there. This is the case for formats that you can surely
; and allmost surely recognize with a machine.

xfrERROR_MISSINGEND	= -17	; missing bytes at end of data
xfrERROR_MISSINGSTART	= -14	; missing bytes at start

xfrERROR_FALSEMATCH		; PRIVATE



xfrERROR_OUTOFDATA	= -18

; Can only happen at xfrIdentify() and means the program may free
; the xfrOBJECT_MINFILE and reload the whole file with xfrOBJECT_FILE
; and call xfrIdentify() again.
;
; See also: xfr_developer.guide -> xfrIdentify() 
;
; for making of clients:
;
; Your client has allmost identified (XFR_CHECK) a format, but e.g. to
; calculate the size you need the whole file to be in memory and
; the xfrCom_modeflags -> xfrMODEB_MINIMAL  indicates, that only a
; minimum portion of the file is present.
;
; So then client must return xfrERROR_OUTOFDATA to signal the program
; to may load the entire file into memory and to call xfrIdentify()
; again later.
;
; The case xfrMODEB_MINIMAL only can happen in XFR_CHECK. A scan goes
; allways with the whole file.
;
; Examples: XFRC_Oktalyzer.asm, XFRC_SoundMon.asm
;
; DANGER: a client may only return this error if the format could be
; recognized at least significantly.




xfrERROR_RETURNCODE	= -19	; PRIVATE


; external client related definitions
; -----------------------------------

; an external client is a header and one or more linked taglists of
; format/ripper defintions


XFRCLIENTID	MACRO
		dc.b	"XFRC"
		ENDM

XFRCLIENTHEADER	MACRO
		moveq	#-1,d0	; enable execution telling object
		rts		; not executable
		XFRCLIENTID
		dc.w	XFRVERSION

		; the following constants and labels must be
		; defined in the client sourcecode
		; in order to use this macro there

		dc.w	XFRCLIENT_VERSION	; constant
		dc.l	XFRCLIENT_SHORT		; label: client verstring
		dc.l	XFRCLIENT_LONG		; label: client credits
		dc.l	XFRCLIENT_FIRSTFORMAT	; label: format taglist
		dc.l	XFRCLIENT_IMPORTLIST	; label: formats table
		dc.l	0	; place for *filename after load
		ENDM

 STRUCTURE	xfrClient,0
	ULONG	xfrC_next	; ...RTS, also used internally for linking
	STRUCT	xfrC_id,4	; see above XFRCLIENTID

	UWORD	xfrC_libversion	; minimal XFRVERSION of xfr.library

	UWORD	xfrC_version	; version number of this client

	APTR	xfrC_short	; this client name / version / author
				; which usually is also the content of the
				; version string without the $VER:
				; (f.e. for "found by: ..." msg in a prg)
	APTR	xfrC_long	; long info usage, author contact
				; where to get more info, sources, etc
				; may be multiple lines, may use $a linefeeds

				; --------------------------------------
	APTR	xfrC_firstsub	; first ripper definition in this client
				; --------------------------------------

	ULONG	xfrC_importlist	; see formats table below

	APTR	xfrC_filename	; of this client on disk, SET BY XFR

	LABEL	xfrC_SIZEOF


; XFRCLIENT_IMPORTLIST / formats table
;
; importing formats has the effect of your in-client routines knowing
; the address of a certain xfrFormat without searching for it by name
;
; below is an example how the list is made. left is a label from where
; your in-client routine will read the pointer to the format. in the
; place of the pointer to the format is a pointer to the exported id-
; string of the format to import. ya may see the id-strings with the
; supplied utility "xfrlibinfo" and the shell command
; "xfrlibinfo <whole or partial format name>". F.e. to make a client
; that can extract samples from a module i recommend to import the raw
; sample format, as these cannot be auto-identified yet, maybe never.
;
;format_a		dc.l	format_a_id
;format_b		...			; additional entrys
;			...			; may be there
;			dc.l	XFRLIST_END
;
;format_a_id		dc.b	"sample",0
			even

; when you want to import a format that does _not_ export itself by an
; id, you need to contact the author of the client ("xfrlibinfo"). This
; helps (forces) coordinating developement and you have lesser to type
; in your sourcecodes. Just pick the format you want to import from the
; displayed list of "xfrlibinfo", then type "xfrlibinfo <partial name>"
; to the shell. Now pick the displayed client name and type "xfrlibinfo 
; c <partial client name>". Then watch the lines.


;;; a format as available in xfrO_format or xfrB_formats / xfrB_deeps

;	NOTE: in a client do only use the --Taglists-- below
;	      to define formats (!)

 STRUCTURE	xfrFormat,0
	APTR	xfrF_nextformat	; used internally for linking

	APTR	xfrF_reserved1
	APTR	xfrF_reserved2

	APTR	xfrF_client	; NULL (leave this empty)
				; the library does put a ptr to the
				; originating xfr_Client here so that
				; the prg can find xfrC_short/long

	APTR	xfrF_id		; opt. export id of a format; is a
				; unique oneword name for this format,
				; like "executable" to make this format
				; able to be identified by other clients
				; or the prg

				; this is necessary if this format is a
				; major format class like f.e. "iff" or
				; "exe", so that other clients could
				; refer to the recognition abilities of
				; this one

	APTR	xfrF_short	; single line up to ~30 chars of
				; format name and version,
				; can be combination with author name
				; like 'Ben Daglish' or 'Jochen Hippel TFMX'
				; OR very short description if no name

	APTR	xfrF_long	; special format information,
				; detailed authors, nostalgy
				; may be multiple lines, may use $a linefeeds

	UWORD	xfrF_flags	; see belowst

	APTR	xfrF_prefix	; pointer to null-terminated "mod",0 etc
	APTR	xfrF_postfix	; f.e. NT for Startrekker AM data files
				; or iff for iff files

				; !: write both prefix and postfix
				;    without a point '.' here

	; all fields below are lesser informational, except you wanted
	; to know which functions are present

	APTR	xfrF_major
	ULONG	xfrF_minbytes
	ULONG	xfrF_reserved3	; RESERVED, do not use

	ULONG	xfrF_magic	; a typical WORD<<16 or LONGWORD;
				; for example $4E710000 for a
				; format that has a static $4e71
				; somewhere you know or somthing
				; longword like "M.K." (Tracker)
				; (a longword with zero in the
				;  lower word like $????0000 works
				;  as $????, the zero word ignored)

				; magic means: only call routine
				; if this matched, is NULL to let
				; xfr use the recognition routines
				; allways, but if something static
				; is in a format then do use a magic
				; to get a rocket speed up

				; a magic alone has only an effect
				; when a recognition routine is also
				; there to verify the guess

	ULONG	xfrF_offset	; f.e. $438 where "M.K." is;
				; may be NULL (=at_start)

				; offset MUST be _EVEN_ (!) in this ver.
				; --------------------------------------

	APTR	xfrF_check	; usually identify type only	
				; (after magic matched, ensure
				; that its really what it looks like)

	APTR	xfrF_deepcheck	; some more time needed here

	APTR	xfrF_scan	; same as above for the xfrScan() function,
	APTR	xfrF_deepscan	; may be set to the same code to allow scan
				; for this format or may even set to an own
				; code for scan purposes

		; the above check-/deeproutines may supply the real start
		; in xfrCom_start if it differs from current pos,
		; and if the detected format is different from the current,
		; e.g. a custom format, they may deposit a pointer to an
		; xfrFormat structure in  xfrCom_format. in most cases
		; this is not needed. if your scanroutine detected annother
		; format than its own tags describe, have a look at
		; XFR_STOREPTR at the tags for clients. You may make
		; format defintions, that have no scan routines at all,
		; but can be used alternatively by other formats.

	APTR	xfrF_extract	; get each sample or other content

				; this is a routine where
				; the certain fields of xfrCom_...
				; are filled and then xfrResult()
				; is called once for each content
				; item (usually sample),
				; (the xfrCom structure is clear for
				; annother item after a call)

	APTR	xfrF_patch	; routine for fixes f.e. RTE to RTS
	APTR	xfrF_convert	; converter routine, converts f.e. to
				; a common or custom format

	APTR	xfrF_nextcheck	; PRIVATE may be changes with future
	APTR	xfrF_nextcheck_d ;version, do not use
	APTR	xfrF_nextscan	; ..
	APTR	xfrF_nextscan_d	; ..

	; down from here n/i

	APTR	xfrF_extscan	; secondary part(s) riproutine,
				; f.e. samplesearch,
				; a routine that does check an adr and
				; makes an xfrResult if found something
				; (may set _format to a non-linked
				; xfrF_structure for .fix, etc)
;	ULONG	xfrF_extcomsize ; size of client-private structure that can
				 ; carry information to _extrip
; 	?	extinit
;	APTR	xfrF_extfree	; optional routine to free some custom data
				; (NOT the extending structure itself!)
	LABEL	xfrF_SIZEOF


; xfrF_flags

	; these must be set with the XFR_FLAGS tag

	BITDEF	xfrF,SIZE,0		; length can be calculated
	BITDEF	xfrF,NAME,1		; modulename is supported
	BITDEF	xfrF,TEXT,2		; additional infotext is supported

;	BITDEF	relyable	n/i
;		rare		n/i

	BITDEF	xfrF,SOUNDFORMAT,8	; this is a sound format


	; others are private to XFR, leave them alone

	BITDEF	xfrF,MAJOR,14		; PRIVATE, set by XFR for formats
					; that are inherited by minors
	BITDEF	xfrF,IGNORE,15		; PRIVATE, its off or its a minor


; tags for the format definitions in a client, see the
; xfrFormat structure above for more descriptions on each;
; see the developer guide on howto make recognition routines

	ENUM	TAG_USER

; multiple formats may be in a client if they need to share anything;
; so next is just a pointer to annother taglist

	EITEM	XFR_NEXTFORMAT

; pointer to very short id-string (or the formatname also); signals
; the format may be shared by other clients in some way

	EITEM	XFR_EXPORTID

; the next two are pointers to informational strings; please visit the
; homepage if you havent studied the naming and describing guidelines
; there (there may be also updates you dont know)

	EITEM	XFR_FORMATNAME
	EITEM	XFR_DESCRIPTION	; optional

	EITEM	XFR_FLAGS	; see definitions for xfrF_flags above
	EITEM	XFR_MAJORID	; n/i

; the next two are something like "mod"; write such to the prefix rather
; than to the postfix for amiga-style naming of formats; postfix is only
; for definite fix-at-the-end formats like "iff" or is an addition to
; prefix like "mod.illuminatus.NT" for startrekker AM data files.

	EITEM	XFR_PREFIX
	EITEM	XFR_POSTFIX

	EITEM	XFR_MAGICWORD	; either a word
	EITEM	XFR_MAGICLONG	; or a longword (do use only one of them)

XFR_MAGIC	EQU	XFR_MAGICLONG

	EITEM	XFR_OFFSET	; must be even or not used (=zero)

	EITEM	XFR_CHECK
	EITEM	XFR_SCAN
	EITEM	XFR_DEEPCHECK
	EITEM	XFR_DEEPSCAN
	EITEM	XFR_EXTRACT
XFR_EXTRACTOR	EQU	XFR_EXTRACT
	EITEM	XFR_EXTSCAN
	EITEM	XFR_PATCH
XFR_PATCHER	EQU	XFR_PATCH
	EITEM	XFR_CONVERT
XFR_CONVERTER	EQU	XFR_CONVERT

	EITEM	XFR_FORMATPTR	; followed by an address where to xfr
				; does store the address of this format
				; when it is inititalised as a structure

				; You may make format defintions, that
				; have no scan routines at all, but can
				; be used alternatively by other formats.

XFR_STOREPTR	EQU	XFR_FORMATPTR	; which name
XFR_PUTPTR	EQU	XFR_STOREPTR	; do you
XFR_PUTPOINTER	EQU	XFR_FORMATPTR	; like best?

; do use the next one to define the minimal bytes (from start) of a data
; that are needed to recognize it and to calc its proper size. the tag
; yet also defines the minimal total size of data to may be this format
; (maybe annother tag must be used for that in future ver);
; With XFR_MINBYTES set, the format is allowed for an xfrOBJECT_MINFILE.
; Then pay attention for xfrMODE?_MINFILE in check/deepcheck when
; comparing for really missing bytes a and of a data.

	EITEM	XFR_MINBYTES		; , long minimal_bytes


; clientside communication structure follows
;
; 	asm note: accessible for clients through xfrCom_...(a4)

 STRUCTURE	xfrCom,0

	; INTERNAL / READ ONLY

	APTR	xfrCom_object		; the object that is worked on;
					; f.e. this is the object that is
					; scanned or beeing identified
	APTR	xfrCom_lastfound	; last created (found) *object in
					; a scan stored here for scanhook
	APTR	xfrCom_MemStart		; low boundary of memory range
	APTR	xfrCom_MemSize		; size of allowed memory range
	APTR	xfrCom_MemEnd		; high boundary of memory range
					; (these boundarys and size are
					;  taken from the outermost root
					;  object allways and may be
					;  beyound the area of the object
					;  that is actually worked on)
	APTR	xfrCom_RemainStart	; end address of last found data;
					; (this is just behind the last
					;  found module or thingy)
	ULONG	xfrCom_RemainSize	; number of remaining bytes counted
					; from RemainStart to ObjectEnd
	APTR	xfrCom_RemainEnd	; usually O_start+O_size of the
					; object that is worked on, but may
					; be of its parent object in some
					; cases where itself had no size;
					; may be also the start of a next
					; found object in a n/i rescan

	UWORD	xfrCom_modeflags	; see modes for Scan()/Identify()
	APTR	xfrCom_hookcode		; as optionally supplied by the
	APTR	xfrCom_hookdata		; prg to xfrScan()

	ULONG	xfrCom_reserved1
	ULONG	xfrCom_reserved2
	ULONG	xfrCom_reserved3
	ULONG	xfrCom_reserved4
	ULONG	xfrCom_reserved5

	; CLIENTS: put return values into the following fields
	;
	;	asm note: accessible through xfrCom_...(a4)

	APTR	xfrCom_start		;<address where module/data starts
	APTR	xfrCom_size		;<its size in bytes
	APTR	xfrCom_end		;<optionally instead of len
	APTR	xfrCom_format		;<see xfrFormat and XFR_STOREPTR
	APTR	xfrCom_name		;<nae e.g. of the module
	ULONG	xfrCom_namelen		;<leave this empty if the name
					; is terminated by zero
	APTR	xfrCom_text		;<infotext e.g. in the module
	ULONG	xfrCom_textlen		;<leave this empty if the text
					; is terminated by zero 
	WORD	xfrCom_flags		;<for xfrOF_NAMEALLOC / _TEXTALLOC

	LABEL	xfrCom_SIZEOF


; end of includefile here  --- Zak McKracken 4 president! ---

	ENDC
