
#include <proto/exec.h>
#include <proto/dos.h>
#include <proto/pngflux.h>
#include <proto/intuition.h>

struct Library *PngfluxBase;

int main (void)

{
struct RDArgs *rdargs = NULL;
struct {
	char *file;
	} args;

if (!(PngfluxBase = OpenLibrary (PNGFLUXNAME,PNGFLUXVERSION)))
	{
	Printf (PNGFLUXNAME " is missing.\n");
	return (RETURN_FAIL);
	}

if (rdargs = ReadArgs ("FILE/A",(APTR)&args,NULL))
	{
	struct PNGFObject *obj;

	if (obj = pngfLoad (args.file))
		{
		struct Window *win;
		UBYTE *array;

		array = pngfGetAttr (obj,PNGFA_ARGBDATA);

		Printf ("RGB array = 0x%lx\n",array);

		if (win = OpenWindowTags (NULL,
				WA_Flags, WFLG_CLOSEGADGET | WFLG_DRAGBAR | WFLG_DEPTHGADGET | WFLG_ACTIVATE | WFLG_NOCAREREFRESH,
				WA_IDCMP, IDCMP_VANILLAKEY | IDCMP_CLOSEWINDOW,
				TAG_END))
			{
			BOOL cont = TRUE;
			long i;

			for (i = 0; i < obj->pfo_Width && i < obj->pfo_Height && i < win->GZZWidth/12 && i < win->GZZHeight/9; i += 2)
				pngfDrawClip (obj,win->RPort,win->BorderLeft + 12*i,win->BorderTop + 9*i,i/2,i/2,obj->pfo_Width - i,obj->pfo_Height - i);

			do	{
				struct IntuiMessage *imsg;

				if (Wait ((1L << win->UserPort->mp_SigBit) | SIGBREAKF_CTRL_C) & SIGBREAKF_CTRL_C)
					cont = FALSE;

				while (imsg = (struct IntuiMessage *) GetMsg (win->UserPort))
					{
					switch (imsg->Class)
						{
					case IDCMP_VANILLAKEY:
						if (imsg->Code == 0x1b) /* Esc */
							cont = FALSE;
						break;
					case IDCMP_CLOSEWINDOW:
						cont = FALSE;
						break;
						}
					ReplyMsg ((struct Message *) imsg);
					}
				}
			while (cont);

			CloseWindow (win);
			}

		FreeVec (obj);
		}
	else
		PrintFault (IoErr(),args.file);

	FreeArgs (rdargs);
	}
else
	{
	PrintFault (IoErr(),NULL);
	return (RETURN_FAIL);
	}

CloseLibrary (PngfluxBase);
return (RETURN_OK);
}

