/*
**      $VER: StartUp.c 40.66 (8.2.97)
**
**      Library startup-code and function table definition
**
**      (C) Copyright 2007 Andreas R. Kleinert
**      All Rights Reserved.
*/

#define __USE_SYSBASE

#include <exec/types.h>
#include <exec/memory.h>
#include <exec/libraries.h>
#include <exec/execbase.h>
#include <exec/resident.h>
#include <exec/initializers.h>

#include <proto/exec.h>

#include <iptcdata/iptcdatabase.h>

#define IPTCDATA_IPTCDATA_H
#include "iptcdata.h"

extern ULONG __saveds __stdargs L_OpenLibs(void);
extern void  __saveds __stdargs L_CloseLibs(void);

struct IptcDataBase * __saveds __asm InitLib( register __a6 struct ExecBase *sysbase,
                    register __a0 struct SegList       *seglist,
                    register __d0 struct IptcDataBase *exb);
struct IptcDataBase * __saveds __asm OpenLib( register __a6 struct IptcDataBase *IptcDataBase);
struct SegList * __saveds __asm CloseLib( register __a6 struct IptcDataBase *IptcDataBase);
struct SegList * __saveds __asm ExpungeLib( register __a6 struct IptcDataBase *exb);
ULONG __saveds __asm ExtFuncLib(void);

LONG __saveds __asm LibStart(void)
{
 return(-1);
}

extern APTR FuncTab [];
extern struct MyDataInit DataTab;

struct InitTable                       /* do not change */
{
 ULONG              LibBaseSize;
 APTR              *FunctionTable;
 struct MyDataInit *DataTable;
 APTR               InitLibTable;
} InitTab =
{
 sizeof(struct IptcDataBase),
 &FuncTab[0],
 &DataTab,
 InitLib
};

APTR FuncTab [] =
{
 OpenLib,
 CloseLib,
 ExpungeLib,
 ExtFuncLib,

 IPTC_Open,
 IPTC_Close,
 IPTC_FindTag,
 IPTC_OpenBuf,

 (APTR) ((LONG)-1)
};


extern struct IptcDataBase *IptcDataBase;

struct IptcDataBase * __saveds __asm InitLib( register __a6 struct ExecBase      *sysbase,
                    register __a0 struct SegList       *seglist,
                    register __d0 struct IptcDataBase *exb)
{
 IptcDataBase = exb;

 IptcDataBase->ipb_SysBase = sysbase;
 IptcDataBase->ipb_SegList = seglist;

 if(L_OpenLibs()) return(IptcDataBase);

 L_CloseLibs();

 return(NULL);
}

struct IptcDataBase * __saveds __asm OpenLib( register __a6 struct IptcDataBase *IptcDataBase)
{
 IptcDataBase->ipb_LibNode.lib_OpenCnt++;

 IptcDataBase->ipb_LibNode.lib_Flags &= ~LIBF_DELEXP;

 return(IptcDataBase);
}

struct SegList * __saveds __asm CloseLib( register __a6 struct IptcDataBase *IptcDataBase)
{
 IptcDataBase->ipb_LibNode.lib_OpenCnt--;

 if(!IptcDataBase->ipb_LibNode.lib_OpenCnt)
  {
   if(IptcDataBase->ipb_LibNode.lib_Flags & LIBF_DELEXP)
    {
     return( ExpungeLib(IptcDataBase) );
    }
  }

 return(NULL);
}

struct SegList * __saveds __asm ExpungeLib( register __a6 struct IptcDataBase *exb)
{
 struct IptcDataBase *IptcDataBase = exb;
 struct SegList       *seglist;

 if(!IptcDataBase->ipb_LibNode.lib_OpenCnt)
  {
   ULONG negsize, possize, fullsize;
   UBYTE *negptr = (UBYTE *) IptcDataBase;

   seglist = IptcDataBase->ipb_SegList;

   Remove((struct Node *)IptcDataBase);

   L_CloseLibs();

   negsize  = IptcDataBase->ipb_LibNode.lib_NegSize;
   possize  = IptcDataBase->ipb_LibNode.lib_PosSize;
   fullsize = negsize + possize;
   negptr  -= negsize;

   FreeMem(negptr, fullsize);

   #ifdef __MAXON__
   CleanupModules();
   #endif

   return(seglist);
  }

 IptcDataBase->ipb_LibNode.lib_Flags |= LIBF_DELEXP;

 return(NULL);
}

ULONG __saveds __asm ExtFuncLib(void)
{
 return(NULL);
}

struct IptcDataBase *IptcDataBase = NULL;


#ifdef __SASC

ULONG XCEXIT       = NULL;  /* these symbols may be referenced by    */
ULONG _XCEXIT      = NULL;  /* some functions of sc.lib, but should  */
ULONG ONBREAK      = NULL;  /* never be used inside a shared library */
ULONG _ONBREAK     = NULL;
ULONG base         = NULL;
ULONG _base        = NULL;
ULONG ProgramName  = NULL;
ULONG _ProgramName = NULL;
ULONG StackPtr     = NULL;
ULONG _StackPtr    = NULL;
ULONG oserr        = NULL;
ULONG _oserr       = NULL;
ULONG OSERR        = NULL;
ULONG _OSERR       = NULL;

void __regargs __chkabort(void) { }  /* a shared library cannot be    */
void __regargs _CXBRK(void)     { }  /* CTRL-C aborted when doing I/O */

#endif /* __SASC */
