/*
**      $VER: exifdata.c 37.5 (24.1.97)
**
**      Demo functions for exifdata.library
**
**      (C) Copyright 1996-97 Andreas R. Kleinert
**      All Rights Reserved.
*/

#define __USE_SYSBASE

#include <exec/types.h>
#include <exec/memory.h>

#include <proto/exec.h>

#include "exifdata.h"

#include <stdio.h>

extern void __saveds __stdargs TS_Msg(char *text);

struct Library *MathIeeeDoubBasBase   = NULL;
struct Library *MathIeeeDoubTransBase = NULL;

struct ExifHandle * __saveds EXIF_XOpen(UBYTE *filename, ULONG *exerr);

struct ExifHandle * __saveds __asm EXIF_Open( register __a0 UBYTE *filename, register __a1 ULONG *exerr)
{
 struct ExifHandle *eh;

 ObtainSemaphore(&ExifSemaphore);

 eh = EXIF_XOpen(filename, exerr);

 ReleaseSemaphore(&ExifSemaphore);

 return(eh);
}

struct ExifHandle * __saveds EXIF_XOpen(UBYTE *filename, ULONG *exerr)
{
 struct ExifHandle *eh = N;

 *exerr = EXERR_NO_ERROR;

 eh = AllocVec(sizeof(struct ExifHandle), MEMF_CLEAR);
 if(eh)
  {
   eh->eh_MathDT = MathIeeeDoubBasBase   = (APTR) OpenLibrary("mathieeedoubbas.library", 1);
   eh->eh_MathDB = MathIeeeDoubTransBase = (APTR) OpenLibrary("mathieeedoubtrans.library", 1);

   if(eh->eh_MathDT && eh->eh_MathDB)
    {
     eh->eh_ExifData = exif_data_new_from_file(filename);
     if(eh->eh_ExifData)
      {
       ExifData *ed = eh->eh_ExifData;

       if(!ed->size)
        {
         eh->eh_FreeFlag = TRUE;

         *exerr = EXERR_NO_DATA;
        }

      }else *exerr = EXERR_NO_FILE;

    }else *exerr = EXERR_NO_MATH;

   if(*exerr) {  EXIF_Close(eh); eh = N; }

  }else *exerr = EXERR_NO_MEMORY;

 return(eh);
}

void __saveds __asm EXIF_Close(register __a0 struct ExifHandle *eh)
{
 ExifData *ed;

 if(!eh) return;

 if(eh->eh_MathDB) CloseLibrary(eh->eh_MathDB);
 if(eh->eh_MathDT) CloseLibrary(eh->eh_MathDT);

 ed = (APTR) eh->eh_ExifData;
 if(ed)
  {
   if(eh->eh_FreeFlag) exif_data_free(ed);
    else               exif_data_unref(ed);
  }

 memset(eh, 0, sizeof(struct ExifHandle)); // destroy fully

 FreeVec(eh);
}

ULONG __saveds EXIF_XFindTag(struct ExifHandle *eh, LONG tag, UBYTE *buffer, ULONG buflen);

ULONG __saveds __asm EXIF_FindTag(register __a0 struct ExifHandle *eh, register __d0 LONG tag, register __a1 UBYTE *buffer, register __d1 ULONG buflen)
{
 ULONG ret = EXERR_NO_ERROR;

 ObtainSemaphore(&ExifSemaphore);

 if(eh)
  {
   MathIeeeDoubBasBase   = eh->eh_MathDT;
   MathIeeeDoubTransBase = eh->eh_MathDB;

   if(!eh->eh_MathDT || !eh->eh_MathDB) ret = EXERR_NO_MATH; // actually not possible
  }

 if(!ret) ret = EXIF_XFindTag(eh, tag, buffer, buflen);

 ReleaseSemaphore(&ExifSemaphore);

 return(ret);
}

ULONG __saveds EXIF_XFindTag(struct ExifHandle *eh, LONG tag, UBYTE *buffer, ULONG buflen)
{
 ExifData  *exifData;
 ExifEntry *extag;
 ULONG i, binary = FALSE;;

 if(!eh)     return(EXERR_NO_POINTER);
 if(!buffer) return(EXERR_NO_POINTER);
 if(!buflen) return(EXERR_NO_SPACE);

 if((buflen > 13) && (!strcmp(buffer, "\x6\x6\x6BINARY\x6\x6\x6"))) binary = TRUE;

 buffer[0] = (UBYTE) 0;

 exifData = (APTR) eh->eh_ExifData;
 if(!exifData) return(EXERR_NO_DATA);

 for(i=0, extag=N; (!extag) && i<EXIF_IFD_COUNT; i++) extag=exif_content_get_entry(exifData->ifd[i], (int) tag);

 if(!extag) return(EXERR_NO_TAG);

 if(extag->size > buflen-1) return(EXERR_NO_SPACE); // this is not really accurate, but under SAS/C snprintf() does not work

 if(binary)
  { 
   ULONG *size = (ULONG *) buffer;

   if(extag->size > buflen-9) return(EXERR_NO_SPACE);

   *size++ = extag->size;
   *size++ = 0L;

   CopyMem(extag->data, buffer+9, extag->size);
   buffer[9+extag->size] = (UBYTE) 0;
  }else
  {
   exif_entry_get_value(extag, buffer, buflen-1);

   if(   tag == EXIF_TAG_GPS_LATITUDE
      || tag == EXIF_TAG_GPS_LONGITUDE
      || tag == EXIF_TAG_GPS_ALTITUDE)
    {
     ExifByteOrder en;
     ExifRational v_rat[3];
     ULONG len;
     UBYTE gpsbuf[64];

     if(extag->format != EXIF_FORMAT_RATIONAL)    { buffer[0] = 0; return(EXERR_NO_CONTENT); }
     if(!extag->parent || !extag->parent->parent) { buffer[0] = 0; return(EXERR_NO_CONTENT); }

     en = exif_data_get_byte_order(extag->parent->parent);

     v_rat[0] = exif_get_rational(extag->data,    en);
     v_rat[1] = exif_get_rational(extag->data+8,  en);
     v_rat[2] = exif_get_rational(extag->data+16, en);

     sprintf(gpsbuf, "%2.2lf %2.2lf' %2.2lf''", (double)v_rat[0].numerator / (double)v_rat[0].denominator,
                                               (double)v_rat[1].numerator / (double)v_rat[1].denominator,
                                               (double)v_rat[2].numerator / (double)v_rat[2].denominator);

     len = strlen(gpsbuf)+1;
     if(buflen >= len) strcpy(buffer, gpsbuf);
    }else
    {
     buffer[buflen-1] = (UBYTE) 0;
    }
  }

 if(!buffer[0]) return(EXERR_NO_CONTENT);

 return(EXERR_NO_ERROR);
}

struct ExifHandle * __saveds EXIF_XOpenBuf(UBYTE *buffer, ULONG buflen, ULONG *exerr);

struct ExifHandle * __saveds __asm EXIF_OpenBuf( register __a0 UBYTE *buffer, register __d0 ULONG buflen, register __a1 ULONG *exerr)
{
 struct ExifHandle *eh;

 ObtainSemaphore(&ExifSemaphore);

 eh = EXIF_XOpenBuf(buffer, buflen, exerr);

 ReleaseSemaphore(&ExifSemaphore);

 return(eh);
}

struct ExifHandle * __saveds EXIF_XOpenBuf(UBYTE *buffer, ULONG buflen, ULONG *exerr)
{
 struct ExifHandle *eh = N;

 *exerr = EXERR_NO_ERROR;

 eh = AllocVec(sizeof(struct ExifHandle), MEMF_CLEAR);
 if(eh)
  {
   eh->eh_MathDT = MathIeeeDoubBasBase   = (APTR) OpenLibrary("mathieeedoubbas.library", 1);
   eh->eh_MathDB = MathIeeeDoubTransBase = (APTR) OpenLibrary("mathieeedoubtrans.library", 1);

   if(eh->eh_MathDT && eh->eh_MathDB)
    {
     eh->eh_ExifData = exif_data_new_from_data(buffer, buflen);

     if(eh->eh_ExifData)
      {
       ExifData *ed = eh->eh_ExifData;

       if(!ed->size)
        {
         eh->eh_FreeFlag = TRUE;

         *exerr = EXERR_NO_DATA;
        }

      }else *exerr = EXERR_NO_DATA;

    }else *exerr = EXERR_NO_MATH;

   if(*exerr) {  EXIF_Close(eh); eh = N; }

  }else *exerr = EXERR_NO_MEMORY;

 return(eh);
}
