/*
**      $VER: StartUp.c 40.66 (8.2.97)
**
**      Library startup-code and function table definition
**
**      (C) Copyright 2007 Andreas R. Kleinert
**      All Rights Reserved.
*/

#define __USE_SYSBASE

#include <exec/types.h>
#include <exec/memory.h>
#include <exec/libraries.h>
#include <exec/execbase.h>
#include <exec/resident.h>
#include <exec/initializers.h>

#include <proto/exec.h>

#include <exifdata/exifdatabase.h>

#define EXIFDATA_EXIFDATA_H
#include "exifdata.h"

extern ULONG __saveds __stdargs L_OpenLibs(void);
extern void  __saveds __stdargs L_CloseLibs(void);

struct ExifDataBase * __saveds __asm InitLib( register __a6 struct ExecBase *sysbase,
                    register __a0 struct SegList       *seglist,
                    register __d0 struct ExifDataBase *exb);
struct ExifDataBase * __saveds __asm OpenLib( register __a6 struct ExifDataBase *ExifDataBase);
struct SegList * __saveds __asm CloseLib( register __a6 struct ExifDataBase *ExifDataBase);
struct SegList * __saveds __asm ExpungeLib( register __a6 struct ExifDataBase *exb);
ULONG __saveds __asm ExtFuncLib(void);

LONG __saveds __asm LibStart(void)
{
 return(-1);
}

extern APTR FuncTab [];
extern struct MyDataInit DataTab;

struct InitTable                       /* do not change */
{
 ULONG              LibBaseSize;
 APTR              *FunctionTable;
 struct MyDataInit *DataTable;
 APTR               InitLibTable;
} InitTab =
{
 sizeof(struct ExifDataBase),
 &FuncTab[0],
 &DataTab,
 InitLib
};

APTR FuncTab [] =
{
 OpenLib,
 CloseLib,
 ExpungeLib,
 ExtFuncLib,

 EXIF_Open,
 EXIF_Close,
 EXIF_FindTag,
 EXIF_OpenBuf,

 (APTR) ((LONG)-1)
};


extern struct ExifDataBase *ExifDataBase;

struct ExifDataBase * __saveds __asm InitLib( register __a6 struct ExecBase      *sysbase,
                    register __a0 struct SegList       *seglist,
                    register __d0 struct ExifDataBase *exb)
{
 ExifDataBase = exb;

 ExifDataBase->exb_SysBase = sysbase;
 ExifDataBase->exb_SegList = seglist;

 if(L_OpenLibs()) return(ExifDataBase);

 L_CloseLibs();

 return(NULL);
}

struct ExifDataBase * __saveds __asm OpenLib( register __a6 struct ExifDataBase *ExifDataBase)
{
 ExifDataBase->exb_LibNode.lib_OpenCnt++;

 ExifDataBase->exb_LibNode.lib_Flags &= ~LIBF_DELEXP;

 return(ExifDataBase);
}

struct SegList * __saveds __asm CloseLib( register __a6 struct ExifDataBase *ExifDataBase)
{
 ExifDataBase->exb_LibNode.lib_OpenCnt--;

 if(!ExifDataBase->exb_LibNode.lib_OpenCnt)
  {
   if(ExifDataBase->exb_LibNode.lib_Flags & LIBF_DELEXP)
    {
     return( ExpungeLib(ExifDataBase) );
    }
  }

 return(NULL);
}

struct SegList * __saveds __asm ExpungeLib( register __a6 struct ExifDataBase *exb)
{
 struct ExifDataBase *ExifDataBase = exb;
 struct SegList       *seglist;

 if(!ExifDataBase->exb_LibNode.lib_OpenCnt)
  {
   ULONG negsize, possize, fullsize;
   UBYTE *negptr = (UBYTE *) ExifDataBase;

   seglist = ExifDataBase->exb_SegList;

   Remove((struct Node *)ExifDataBase);

   L_CloseLibs();

   negsize  = ExifDataBase->exb_LibNode.lib_NegSize;
   possize  = ExifDataBase->exb_LibNode.lib_PosSize;
   fullsize = negsize + possize;
   negptr  -= negsize;

   FreeMem(negptr, fullsize);

   #ifdef __MAXON__
   CleanupModules();
   #endif

   return(seglist);
  }

 ExifDataBase->exb_LibNode.lib_Flags |= LIBF_DELEXP;

 return(NULL);
}

ULONG __saveds __asm ExtFuncLib(void)
{
 return(NULL);
}

struct ExifDataBase *ExifDataBase = NULL;


#ifdef __SASC

ULONG XCEXIT       = NULL;  /* these symbols may be referenced by    */
ULONG _XCEXIT      = NULL;  /* some functions of sc.lib, but should  */
ULONG ONBREAK      = NULL;  /* never be used inside a shared library */
ULONG _ONBREAK     = NULL;
ULONG base         = NULL;
ULONG _base        = NULL;
ULONG ProgramName  = NULL;
ULONG _ProgramName = NULL;
ULONG StackPtr     = NULL;
ULONG _StackPtr    = NULL;
ULONG oserr        = NULL;
ULONG _oserr       = NULL;
ULONG OSERR        = NULL;
ULONG _OSERR       = NULL;

void __regargs __chkabort(void) { }  /* a shared library cannot be    */
void __regargs _CXBRK(void)     { }  /* CTRL-C aborted when doing I/O */

#endif /* __SASC */
