/*

Directory Opus 5
Original APL release version 5.82
Copyright 1993-2012 Jonathan Potter & GP Software

This program is free software; you can redistribute it and/or
modify it under the terms of the AROS Public License version 1.1.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
AROS Public License for more details.

The release of Directory Opus 5 under the GPL in NO WAY affects
the existing commercial status of Directory Opus for Windows.

For more information on Directory Opus for Windows please see:

                 http://www.gpsoft.com.au

*/

#include "dopus.h"

MenuData
	dopus_menus[]={

		// Project
		{NM_TITLE,0,MSG_PROJECT_MENU,0},
		{NM_ITEM,MENU_BACKDROP,MSG_BACKDROP_MENU,CHECKIT|MENUTOGGLE|MENUFLAG_USE_SEQ|MENUFLAG_MAKE_SEQ('B')},
		{NM_ITEM,MENU_EXECUTE,MSG_EXECUTE_MENU,MENUFLAG_USE_SEQ|MENUFLAG_MAKE_SEQ('E')},
		{NM_ITEM,0,(ULONG)NM_BARLABEL,0},
		{NM_ITEM,MENU_ABOUT,MSG_ABOUT_MENU,MENUFLAG_USE_SEQ|MENUFLAG_MAKE_SEQ('?')},
		{NM_ITEM,MENU_HELP,MSG_HELP_MENU,0},
		{NM_ITEM,MENU_KEYFINDER,MSG_KEYFINDER_MENU,0},
		{NM_ITEM,0,(ULONG)NM_BARLABEL,0},
		{NM_ITEM,MENU_HIDE,MSG_HIDE_MENU,MENUFLAG_USE_SEQ|MENUFLAG_MAKE_SEQ('H')},
		{NM_ITEM,MENU_QUIT,MSG_QUIT_MENU,MENUFLAG_USE_SEQ|MENUFLAG_MAKE_SEQ('Q')},

		// Lister
		{NM_TITLE,0,MSG_WINDOW_MENU,0},
		{NM_ITEM,MENU_NEW_LISTER,MSG_NEW_LISTER_MENU,MENUFLAG_USE_SEQ|MENUFLAG_MAKE_SEQ('N')},
		{NM_ITEM,MENU_OPEN_PARENT,MSG_OPEN_PARENT_MENU,0},
		{NM_ITEM,0,(ULONG)NM_BARLABEL,0},
		{NM_ITEM,MENU_LISTER_CLOSE,MSG_CLOSE_LISTER_MENU,MENUFLAG_USE_SEQ|MENUFLAG_MAKE_SEQ('K')},
		{NM_ITEM,MENU_CLOSE_ALL,MSG_CLOSE_ALL_MENU,0},
		{NM_ITEM,0,(ULONG)NM_BARLABEL,0},
		{NM_ITEM,MENU_LISTER_SOURCE,MSG_LISTER_SOURCE,0},
		{NM_ITEM,MENU_LISTER_DEST,MSG_LISTER_DEST,0},
		{NM_ITEM,MENU_LISTER_OFF,MSG_LISTER_OFF,0},
		{NM_ITEM,0,(ULONG)NM_BARLABEL,0},
		{NM_ITEM,MENU_LISTER_LOCK_SOURCE,MSG_LISTER_LOCK_SOURCE,0},
		{NM_ITEM,MENU_LISTER_LOCK_DEST,MSG_LISTER_LOCK_DEST,0},
		{NM_ITEM,MENU_LISTER_UNLOCK,MSG_LISTER_UNLOCK,0},
		{NM_ITEM,MENU_LISTER_UNLOCK_ALL,MSG_LISTER_UNLOCK_ALL,0},
		{NM_ITEM,0,(ULONG)NM_BARLABEL,0},
		{NM_ITEM,MENU_EDIT_LISTER,MSG_EDIT_MENU,0},
		{NM_ITEM,MENU_LISTER_BUTTONS,MSG_LISTER_BUTTONS_MENU,MENUFLAG_USE_SEQ|MENUFLAG_MAKE_SEQ('1')},
		{NM_ITEM,MENU_LISTER_MENU,MSG_LISTER_MENU_MENU,MENUFLAG_USE_SEQ|MENUFLAG_MAKE_SEQ('2')},
		{NM_ITEM,0,(ULONG)NM_BARLABEL,0},
		{NM_ITEM,0,MSG_TILE_MENU,0},
			{NM_SUB,MENU_TILE_HORIZ,MSG_TILE_HORIZ_MENU,MENUFLAG_USE_SEQ|MENUFLAG_MAKE_SEQ('-')},
			{NM_SUB,MENU_TILE_VERT,MSG_TILE_VERT_MENU,MENUFLAG_USE_SEQ|MENUFLAG_MAKE_SEQ('=')},
		{NM_ITEM,MENU_CASCADE,MSG_CASCADE_MENU,MENUFLAG_USE_SEQ|MENUFLAG_MAKE_SEQ('\\')},
		{NM_ITEM,0,(ULONG)NM_BARLABEL,0},
		{NM_ITEM,MENU_LISTER_SNAPSHOT,MSG_ICON_SNAPSHOT_LISTER,0},
		{NM_ITEM,MENU_LISTER_UNSNAPSHOT,MSG_ICON_UNSNAPSHOT_MENU,0},
		{NM_ITEM,0,(ULONG)NM_BARLABEL,0},
		{NM_ITEM,MENU_LISTER_VIEW,MSG_LISTER_VIEW,0},
			{NM_SUB,MENU_LISTER_VIEW_NAME,MSG_LISTER_VIEW_NAME,CHECKIT|MENUFLAG_AUTO_MUTEX|MENUFLAG_USE_SEQ|MENUFLAG_MAKE_SEQ('[')},
			{NM_SUB,MENU_LISTER_VIEW_ICON,MSG_LISTER_VIEW_ICON,CHECKIT|MENUFLAG_AUTO_MUTEX|MENUFLAG_USE_SEQ|MENUFLAG_MAKE_SEQ(']')},
			{NM_SUB,MENU_LISTER_ICON_ACTION,MSG_LISTER_ICON_ACTION,CHECKIT|MENUFLAG_AUTO_MUTEX|MENUFLAG_USE_SEQ|MENUFLAG_MAKE_SEQ('\'')},
			{NM_SUB,0,(ULONG)NM_BARLABEL,0},
			{NM_SUB,MENU_LISTER_SHOW_ALL,MSG_LISTER_SHOW_ALL,CHECKIT|MENUTOGGLE|MENUFLAG_USE_SEQ|MENUFLAG_MAKE_SEQ(';')},

		// Icons
		{NM_TITLE,MENU_ICON_MENU,MSG_ICONS_MENU,0},
		{NM_ITEM,MENU_ICON_NEW,MSG_ICONS_NEW_MENU,0},
			{NM_SUB,MENU_ICON_MAKEDIR,MSG_ICONS_MAKEDIR_MENU,MENUFLAG_USE_SEQ|MENUFLAG_MAKE_SEQ('D')},
			{NM_SUB,MENU_GROUP_NEW,MSG_ICONS_NEWGROUP_MENU,MENUFLAG_USE_SEQ|MENUFLAG_MAKE_SEQ('G')},
			{NM_SUB,MENU_COMMAND_NEW,MSG_ICONS_NEWCOMMAND_MENU,0},
		{NM_ITEM,MENU_ICON_OPEN,MSG_ICON_OPEN_MENU,MENUFLAG_USE_SEQ|MENUFLAG_MAKE_SEQ('O')},
		{NM_ITEM,MENU_ICON_INFO,MSG_ICON_INFO_MENU,MENUFLAG_USE_SEQ|MENUFLAG_MAKE_SEQ('I')},
		{NM_ITEM,0,(ULONG)NM_BARLABEL,0},
		{NM_ITEM,MENU_ICON_SNAPSHOT,MSG_ICON_SNAPSHOT_MENU,0},
			{NM_SUB,MENU_ICON_SNAPSHOT_ICON,MSG_ICON_SNAPSHOT_ICONS,MENUFLAG_USE_SEQ|MENUFLAG_MAKE_SEQ('S')},
			{NM_SUB,MENU_ICON_SNAPSHOT_WINDOW,MSG_ICON_SNAPSHOT_LISTER,MENUFLAG_USE_SEQ|MENUFLAG_MAKE_SEQ('W')},
			{NM_SUB,0,(ULONG)NM_BARLABEL,0},
			{NM_SUB,MENU_ICON_SNAPSHOT_ALL,MSG_ICON_SNAPSHOT_ALL,MENUFLAG_USE_SEQ|MENUFLAG_MAKE_SEQ('Y')},
		{NM_ITEM,MENU_ICON_UNSNAPSHOT,MSG_ICON_UNSNAPSHOT_MENU,MENUFLAG_USE_SEQ|MENUFLAG_MAKE_SEQ('U')},
		{NM_ITEM,MENU_ICON_LEAVE_OUT,MSG_ICON_LEAVE_OUT_MENU,MENUFLAG_USE_SEQ|MENUFLAG_MAKE_SEQ('L')},
		{NM_ITEM,MENU_ICON_PUT_AWAY,MSG_ICON_PUT_AWAY_MENU,MENUFLAG_USE_SEQ|MENUFLAG_MAKE_SEQ('P')},
		{NM_ITEM,0,(ULONG)NM_BARLABEL,0},
		{NM_ITEM,MENU_ICON_SELECT_ALL,MSG_ICON_SELECT_ALL_MENU,MENUFLAG_USE_SEQ|MENUFLAG_MAKE_SEQ('A')},
		{NM_ITEM,MENU_ICON_CLEANUP,MSG_ICON_CLEANUP,MENUFLAG_USE_SEQ|MENUFLAG_MAKE_SEQ('.')},
//		{NM_ITEM,MENU_ICON_LINEUP,MSG_ICON_LINEUP,MENUFLAG_USE_SEQ|MENUFLAG_MAKE_SEQ(',')},
		{NM_ITEM,MENU_ICON_RESET,MSG_ICON_RESET,MENUFLAG_USE_SEQ|MENUFLAG_MAKE_SEQ('T')},
		{NM_ITEM,0,(ULONG)NM_BARLABEL,0},
		{NM_ITEM,MENU_ICON_RENAME,MSG_ICON_RENAME,MENUFLAG_USE_SEQ|MENUFLAG_MAKE_SEQ('R')},
		{NM_ITEM,MENU_ICON_DELETE,MSG_DELETE,0},
		{NM_ITEM,MENU_ICON_FORMAT,MSG_ICON_FORMAT,0},
		{NM_ITEM,MENU_ICON_DISKINFO,MSG_ICON_DISKINFO,0},

		// Buttons
		{NM_TITLE,0,MSG_BUTTONS_MENU,0},
		{NM_ITEM,MENU_NEW_BUTTONS,MSG_NEW_BUTTONS_MENU,0},
			{NM_SUB,MENU_NEW_BUTTONS_GFX,MSG_NEW_BUTTONS_GFX_MENU,0},
			{NM_SUB,MENU_NEW_BUTTONS_TEXT,MSG_NEW_BUTTONS_TEXT_MENU,0},
			{NM_SUB,0,(ULONG)NM_BARLABEL,0},
			{NM_SUB,MENU_NEW_STARTMENU,MSG_NEW_STARTMENU_MENU,0},
		{NM_ITEM,0,(ULONG)NM_BARLABEL,0},
		{NM_ITEM,MENU_OPEN_BUTTONS,MSG_OPEN_MENU,0},
		{NM_ITEM,MENU_OPEN_STARTMENU,MSG_OPEN_STARTMENU_MENU,0},
		{NM_ITEM,0,(ULONG)NM_BARLABEL,0},
		{NM_ITEM,MENU_SAVE_BUTTONS,MSG_SAVE_MENU,0},
		{NM_ITEM,MENU_SAVEAS_BUTTONS,MSG_SAVEAS_MENU,0},
		{NM_ITEM,0,(ULONG)NM_BARLABEL,0},
		{NM_ITEM,MENU_CLOSE_BUTTONS,MSG_CLOSE_BUTTONS_MENU,0},
		{NM_ITEM,0,(ULONG)NM_BARLABEL,0},
		{NM_ITEM,MENU_EDIT_BUTTONS,MSG_EDIT_MENU,MENUFLAG_USE_SEQ|MENUFLAG_MAKE_SEQ('3')},

		// Settings
		{NM_TITLE,0,MSG_SETTINGS_MENU,0},
		{NM_ITEM,MENU_CLOCK,MSG_CLOCK_MENU,CHECKIT|MENUTOGGLE},
		{NM_ITEM,MENU_CREATE_ICONS,MSG_CREATE_ICONS_MENU,CHECKIT|MENUTOGGLE},
		{NM_ITEM,MENU_DEFPUBSCR,MSG_DEFPUBSCR_MENU,CHECKIT|MENUTOGGLE},
		{NM_ITEM,MENU_FILTER,MSG_FILTER_MENU,CHECKIT|MENUTOGGLE|MENUFLAG_USE_SEQ|MENUFLAG_MAKE_SEQ('/')},
		{NM_ITEM,0,(ULONG)NM_BARLABEL,0},
		{NM_ITEM,MENU_EDIT_ENVIRONMENT,MSG_ENVIRONMENT_EDIT,MENUFLAG_USE_SEQ|MENUFLAG_MAKE_SEQ('4')},
		{NM_ITEM,MENU_FILETYPES,MSG_FILETYPES_MENU,MENUFLAG_USE_SEQ|MENUFLAG_MAKE_SEQ('5')},
		{NM_ITEM,MENU_MENU,MSG_MENU_MENU,MENUFLAG_USE_SEQ|MENUFLAG_MAKE_SEQ('6')},
		{NM_ITEM,MENU_HOTKEYS,MSG_MENU_HOTKEYS,MENUFLAG_USE_SEQ|MENUFLAG_MAKE_SEQ('7')},
		{NM_ITEM,MENU_SCRIPTS,MSG_MENU_SCRIPTS,MENUFLAG_USE_SEQ|MENUFLAG_MAKE_SEQ('8')},
		{NM_ITEM,MENU_ICONPOS,MSG_MENU_ICONPOS,MENUFLAG_USE_SEQ|MENUFLAG_MAKE_SEQ('9')},
		{NM_ITEM,MENU_THEMES,MSG_THEMES_MENU,0},
			{NM_SUB,MENU_THEMES_LOAD,MSG_THEMES_LOAD,0},
			{NM_SUB,MENU_THEMES_SAVE,MSG_THEMES_SAVE,0},
			{NM_SUB,0,(ULONG)NM_BARLABEL,0},
			{NM_SUB,MENU_THEMES_BUILD,MSG_THEMES_BUILD,0},
		{NM_ITEM,0,(ULONG)NM_BARLABEL,0},
		{NM_ITEM,MENU_OPEN_ENVIRONMENT,MSG_ENVIRONMENT_LOAD_NEW,0},
		{NM_ITEM,MENU_SAVE_ENVIRONMENT,MSG_ENVIRONMENT_SAVE_NEW,0},
		{NM_ITEM,MENU_SAVE_LAYOUT,MSG_ENVIRONMENT_SAVE_LAYOUT_NEW,0},
		{NM_NEXT}};


// Help for menu items
MenuHelp
	menu_help_data[]={

		{0,							"Project"},
		{MENU_BACKDROP,				"Backdrop"},
		{MENU_EXECUTE,				"Execute Command"},
		{MENU_ABOUT,				"About"},
		{MENU_HELP,					"Help"},
		{MENU_KEYFINDER,			"KeyFinder"},
		{MENU_HIDE,					"Hide"},
		{MENU_QUIT,					"Quit"},

		{0,							"Lister"},
		{MENU_NEW_LISTER,			"New"},
		{MENU_OPEN_PARENT,			"Open Parent"},
		{MENU_LISTER_CLOSE,			"Close"},
		{MENU_CLOSE_ALL,			"Close All"},
		{MENU_LISTER_SOURCE,		"Make Source"},
		{MENU_LISTER_DEST,			"Make Dest"},
		{MENU_LISTER_OFF,			"Off"},
		{MENU_LISTER_LOCK_SOURCE,	"Lock Source"},
		{MENU_LISTER_LOCK_DEST,		"Lock Dest"},
		{MENU_LISTER_UNLOCK,		"Unlock"},
		{MENU_LISTER_UNLOCK_ALL,	"Unlock All"},
		{MENU_EDIT_LISTER,			"Edit"},
		{MENU_LISTER_BUTTONS,		"Edit Toolbar"},
		{MENU_LISTER_MENU,			"Edit Menu"},
		{MENU_TILE_HORIZ,			"Tile"},
		{MENU_TILE_VERT,			"Tile"},
		{MENU_CASCADE,				"Tile"},
		{MENU_LISTER_SNAPSHOT,		"Snapshot"},
		{MENU_LISTER_UNSNAPSHOT,	"UnSnapshot"},
		{MENU_LISTER_VIEW_NAME,		"View As"},
		{MENU_LISTER_VIEW_ICON,		"View As"},
		{MENU_LISTER_ICON_ACTION,	"View As"},
		{MENU_LISTER_SHOW_ALL,		"View As"},
		{MENU_LISTER_ICONIFY,		"Iconify"},
		{MENU_LISTER_LOCK_POS,		"Lock Position"},

		{0,							"Icons"},
		{MENU_ICON_MAKEDIR,			"New Drawer"},
		{MENU_GROUP_NEW,			"New Group"},
		{MENU_COMMAND_NEW,			"New Command"},
		{MENU_ICON_OPEN,			"Open"},
		{MENU_ICON_INFO,			"Information"},
		{MENU_ICON_SNAPSHOT_ICON,	"Snapshot"},
		{MENU_ICON_SNAPSHOT_WINDOW,	"Snapshot"},
		{MENU_ICON_SNAPSHOT_ALL,	"Snapshot"},
		{MENU_ICON_UNSNAPSHOT,		"UnSnapshot"},
		{MENU_ICON_LEAVE_OUT,		"Leave Out"},
		{MENU_ICON_PUT_AWAY,		"Put Away"},
		{MENU_ICON_SELECT_ALL,		"Select All"},
		{MENU_ICON_CLEANUP,			"CleanUp"},
		{MENU_ICON_RESET,			"Reset"},
		{MENU_ICON_RENAME,			"Rename"},
		{MENU_ICON_DELETE,			"Delete"},
		{MENU_ICON_FORMAT,			"Format"},
		{MENU_ICON_DISKINFO,		"Disk Information"},
		{MENU_ICON_COPY,			"Copy"},
		{MENU_ICON_COPY_RAM,		"Copy"},
		{MENU_ICON_COPY_DF0,		"Copy"},
		{MENU_ICON_COPY_OTHER,		"Copy"},
		{MENU_LISTER_ARRANGE_NAME,	"Arrange Icons"},
		{MENU_LISTER_ARRANGE_TYPE,	"Arrange Icons"},
		{MENU_LISTER_ARRANGE_SIZE,	"Arrange Icons"},
		{MENU_LISTER_ARRANGE_DATE,	"Arrange Icons"},

		{0,							"Buttons"},
		{MENU_NEW_BUTTONS_GFX,		"New Gfx Buttons"},
		{MENU_NEW_BUTTONS_TEXT,		"New Text Buttons"},
		{MENU_NEW_STARTMENU,		"New Start Menu"},
		{MENU_OPEN_BUTTONS,			"Open"},
		{MENU_OPEN_STARTMENU,		"Open Start Menu"},
		{MENU_SAVE_BUTTONS,			"Save"},
		{MENU_SAVEAS_BUTTONS,		"Save As"},
		{MENU_CLOSE_BUTTONS,		"Close"},
		{MENU_EDIT_BUTTONS,			"Edit"},
		{MENU_ICONIFY_BUTTONS,		"Iconify"},

		{0,							"Settings"},
		{MENU_CLOCK,				"Clock"},
		{MENU_CREATE_ICONS,			"Create Icons"},
		{MENU_DEFPUBSCR,			"Default PubScreen"},
		{MENU_FILTER,				"Filter"},
		{MENU_EDIT_ENVIRONMENT,		"Environment"},
		{MENU_FILETYPES,			"FileTypes"},
		{MENU_MENU,					"User Menu"},
		{MENU_HOTKEYS,				"Hotkeys"},
		{MENU_SCRIPTS,				"Scripts"},
		{MENU_ICONPOS,				"Icon Positioning"},
		{MENU_THEMES_LOAD,			"Load Theme"},
		{MENU_THEMES_SAVE,			"Save Theme"},
		{MENU_THEMES_BUILD,			"Build Theme"},
		{MENU_OPEN_ENVIRONMENT,		"Load Environment"},
		{MENU_SAVE_ENVIRONMENT,		"Save Environment"},
		{MENU_SAVE_LAYOUT,			"Save Layout"},

		{0,							"Icon Popup"},
		{MENU_ICON_CLOSE,			"Close"},
		{MENU_CUSTOM,				"Custom"},
		{MENU_FILE_OPEN_WITH,		"Open With"},
		{MENU_OPEN_NEW_WINDOW,		"Open In New Lister"},

		{0,							"Desktop"},
		{MENU_DESKTOP_COPY,			"Copy"},
		{MENU_DESKTOP_MOVE,			"Move"},
		{MENU_DESKTOP_LEFTOUT,		"Left-Out"},
		{MENU_DESKTOP_CANCEL,		"Cancel"},

		{0,0}};
