/*

Directory Opus 5
Original APL release version 5.82
Copyright 1993-2012 Jonathan Potter & GP Software

This program is free software; you can redistribute it and/or
modify it under the terms of the AROS Public License version 1.1.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
AROS Public License for more details.

The release of Directory Opus 5 under the GPL in NO WAY affects
the existing commercial status of Directory Opus for Windows.

For more information on Directory Opus for Windows please see:

                 http://www.gpsoft.com.au

*/

/*
 *
 * dopus5.library header file
 *
 * Support library for Directory Opus version 5
 *
 * (c) Copyright 1994,5 Jonathan Potter
 *
 */

#ifndef _DOPUSBASE
#define _DOPUSBASE

#include "dopus_config.h"


typedef struct _DragInfo
{
	struct RastPort	*rastport;	// Stores RastPort this bob belongs to
	struct ViewPort	*viewport;	// Stores ViewPort

	WORD		width;		// Bob width
	WORD		height;		// Bob height

	struct VSprite	sprite;		// VSprite structure
	struct Bob	bob;		// BOB structure

	unsigned long	flags;		// Flags

	struct RastPort	drag_rp;	// RastPort we can draw into
	struct BitMap	drag_bm;	// BitMap we can draw into

	struct Window	*window;	// Window pointer
} DragInfo;

typedef struct
{
	struct VSprite	head;		// GEL list head sprite
	struct VSprite	tail;		// GEL list tail sprite
	struct GelsInfo	info;		// GEL info
} DragInfoExtra;

#define DRAGF_VALID		(1<<0)	// Bob is valid
#define DRAGF_OPAQUE		(1<<1)	// Bob should be opaque
#define DRAGF_DONE_GELS		(1<<2)	// Installed GelsInfo
#define DRAGF_NO_LOCK		(1<<3)	// Don't lock layers
#define DRAGF_TRANSPARENT	(1<<4)	// Bob should be transparent (use with opaque)


DragInfo *GetDragInfo(struct Window *,struct RastPort *,long,long,long);
void FreeDragInfo(DragInfo *);
void GetDragImage(DragInfo *,ULONG,ULONG);
void GetDragMask(DragInfo *);
void AddDragImage(DragInfo *);
void RemDragImage(DragInfo *);
void ShowDragImage(DragInfo *,ULONG,ULONG);
void HideDragImage(DragInfo *);
void StampDragImage(DragInfo *,ULONG,ULONG);
BOOL CheckDragDeadlock(DragInfo *);
BOOL BuildTransDragMask(USHORT *,USHORT *,short,short,short);


// Layout routines
#define POS_CENTER		-1
#define POS_RIGHT_JUSTIFY	-2
#define POS_MOUSE_CENTER	-3
#define POS_MOUSE_REL		-4
#define POS_PROPORTION		1024
#define POS_SQUARE		1124
#define POS_REL_RIGHT		(1<<14)

#define FPOS_TEXT_OFFSET	16384

#define SIZE_MAXIMUM		-1
#define SIZE_MAX_LESS		-101

// Defines a window
typedef struct _ConfigWindow {
	struct IBox char_dim;
	struct IBox fine_dim;
} ConfigWindow;

// Opens a window
typedef struct _NewConfigWindow {
	void			*parent;		// Parent to open on
	ConfigWindow		*dims;			// Window dimensions
	char			*title;			// Window title
	struct DOpusLocale	*locale;		// Locale to use
	struct MsgPort		*port;			// Message port to use
	ULONG			flags;			// Flags
	struct TextFont		*font;			// Alternative font to use
} NewConfigWindow;

// Set by the user
#define WINDOW_SCREEN_PARENT	(1<<0)		// Parent is a screen
#define WINDOW_NO_CLOSE		(1<<1)		// No close gadget
#define WINDOW_NO_BORDER	(1<<2)		// No border
#define WINDOW_LAYOUT_ADJUST	(1<<3)		// Adjust window size to fit objects
#define WINDOW_SIMPLE		(1<<4)		// Simple refresh
#define WINDOW_AUTO_REFRESH	(1<<5)		// Refresh window automatically
#define WINDOW_AUTO_KEYS	(1<<6)		// Handle keys automatically
#define WINDOW_OBJECT_PARENT	(1<<7)		// Parent is an existing object
#define WINDOW_REQ_FILL		(1<<8)		// Backfill as a requester
#define WINDOW_NO_ACTIVATE	(1<<9)		// Don't activate
#define WINDOW_VISITOR		(1<<10)		// Open as visitor window
#define WINDOW_SIZE_RIGHT	(1<<11)		// Size gadget, in right border
#define WINDOW_SIZE_BOTTOM	(1<<12)		// Size gadget, in bottom border
#define WINDOW_ICONIFY		(1<<13)		// Iconify gadget

// Set by the system
#define OPEN_USED_DEFAULT	(1<<16)		// To open had to use default font
#define OPEN_USED_TOPAZ		(1<<17)		// To open had to use topaz
#define OPEN_SHRUNK_VERT	(1<<18)		// Window is not full vertical size requested
#define OPEN_SHRUNK_HORIZ	(1<<19)		// Window is not full horizontal size requested
#define OPEN_SHRUNK		(OPEN_SHRUNK_VERT|OPEN_SHRUNK_HORIZ)


#define GAD_ID_ICONIFY		0xffa0

// Defines an object
typedef struct _ObjectDef {
	BYTE type;
	UBYTE object_kind;
	struct IBox char_dims;
	struct IBox fine_dims;
	ULONG gadget_text;
	ULONG flags;
	USHORT gadgetid;
	struct TagItem *taglist;
} ObjectDef;

#define GADFLAG_GLASS			(1<<16)		// Magnifying-glass gadget
#define TEXTFLAG_TEXT_STRING		(1<<17)		// Text is a string, not a Locale ID
#define TEXTFLAG_NO_USCORE		(1<<18)		// No underscore in text
#define BUTTONFLAG_OKAY_BUTTON		(1<<18)		// Button is an "ok" button
#define BUTTONFLAG_CANCEL_BUTTON	(1<<19)		// Button is a "cancel" button
#define BUTTONFLAG_TOGGLE_SELECT	(1<<20)		// Button is toggle-select
#define LISTVIEWFLAG_CURSOR_KEYS	(1<<21)		// Lister responds to cursor
#define BUTTONFLAG_THIN_BORDERS		(1<<22)		// Button has thin borders
#define FILEBUTFLAG_SAVE		(1<<21)		// Save mode

#define TEXTFLAG_ADJUST_TEXT		(1<<23)		// Adjust for text
#define POSFLAG_ADJUST_POS_X		(1<<24)		// Position adjustor
#define POSFLAG_ADJUST_POS_Y		(1<<25)		// Position adjustor
#define POSFLAG_ALIGN_POS_X		(1<<26)		// Align
#define POSFLAG_ALIGN_POS_Y		(1<<27)		// Align

#define TEXTFLAG_RIGHT_JUSTIFY		(1<<1)		// Right-justify text
#define TEXTFLAG_CENTER			(1<<2)		// Center text

#define AREAFLAG_RAISED			(1<<8)		// Raised rectangle
#define AREAFLAG_RECESSED		(1<<9)		// Recessed rectangle
#define AREAFLAG_THIN			(1<<10)		// Thin borders
#define AREAFLAG_ICON			(1<<11)		// Icon drop box
#define AREAFLAG_ERASE			(1<<12)		// Erase interior
#define AREAFLAG_LINE			(1<<13)		// Line (separator)
#define AREAFLAG_GRAPH			(1<<14)		// Graph display
#define AREAFLAG_OPTIM			(1<<15)		// Optimised refreshing
#define AREAFLAG_TITLE			(1<<16)		// Box with a title
#define AREAFLAG_NOFILL			(1<<18)		// No fill

#define OBJECTFLAG_DRAWN		(1<<31)		// Object has been drawn

#define OD_END		0		// End of a list
#define OD_GADGET	1		// A gadget
#define OD_TEXT		2		// Some text
#define OD_AREA		3		// A rectangular area
#define OD_IMAGE	4		// An image
#define OD_SKIP		-1		// Skip this entry

typedef struct _GL_Object
{
	struct _GL_Object	*next;		// Next object
	short			type;		// Type of object
	char			key;		// Key equivalent

	unsigned char		flags2;		// Additional flags

	unsigned short		id;		// Object ID
	unsigned short		control_id;	// Object that this controls
	struct IBox		dims;		// Object dimensions
	ULONG			flags;		// Object flags
	char			*text;		// Text
	USHORT			object_kind;	// Object kind

	union
	{
		struct _gl_gadget
		{
			struct Gadget *context;	// Context data for the gadget
			struct Gadget *gadget;	// The gadget itself
			int components;		// Number of component gadgets
			LONG data;		// Some data for the gadget
			short choice_max;	// Number of choices
			short choice_min;	// Minimum choice
			struct Image *image;	// Gadget image
		} gl_gadget;

		struct _gl_text
		{
			struct IBox text_pos;	// Text position
			WORD base_pos;		// Baseline position
			short uscore_pos;	// Underscore position
		} gl_text;

		struct _gl_area
		{
			struct IBox text_pos;	// Text position within area
			struct IBox area_pos;	// Area position
			int frametype;		// Frame type
		} gl_area;

		struct _gl_image
		{
			struct IBox image_pos;	// Image position
			struct Image *image;	// Image
		} gl_image;
	} gl_info;

	APTR memory;				// Any other memory

	char *original_text;			// Original text string
	char fg,bg;				// Current pen colours

	ULONG	data_ptr;			// Pointer to other data

	struct TagItem	*tags;			// Copy of tags

	struct IBox char_dims;			// Original dimensions
	struct IBox fine_dims;
} GL_Object;

typedef struct _ObjectList {
	GL_Object		*firstobject;	// First object
	struct TextAttr		attr;		// Font used
	struct Window		*window;	// Window used
	struct _ObjectList	*next_list;	// Next list
} ObjectList;

#define OBJECTF_NO_SELECT_NEXT	(1<<0)		// Don't select next field
#define OBJECTF_PATH_FILTER	(1<<1)		// Filter path characters
#define OBJECTF_SECURE		(1<<2)		// Hide string
#define OBJECTF_INTEGER		(1<<3)		// Integer gadget
#define OBJECTF_READ_ONLY	(1<<4)		// Read-only
#define OBJECTF_HOTKEY		(1<<5)		// Hotkey string

typedef struct _MenuData {
	UBYTE	type;				// Menu type
	ULONG	id;				// Menu ID
	ULONG	name;				// Menu name
	ULONG	flags;				// Menu flags
} MenuData;

#define MENUFLAG_TEXT_STRING	(1<<16)		// Menu name is a real string
#define MENUFLAG_COMM_SEQ	(1<<17)		// Give menu a command sequence
#define MENUFLAG_AUTO_MUTEX	(1<<18)		// Automatic mutual exclusion
#define MENUFLAG_USE_SEQ	(1<<19)		// Use command sequence supplied

#define MENUFLAG_MAKE_SEQ(c)	((ULONG)(c)<<24)
#define MENUFLAG_GET_SEQ(fl)	((char)((fl)>>24))

#define NM_NEXT			10
#define NM_BAR_LABEL	(ULONG)NM_BARLABEL

#define IS_GADTOOLS(obj)		(BOOL)(obj->gl_info.gl_gadget.context)

typedef struct
{
	ULONG			magic;		// Magic ID
	struct Window		*window;	// Pointer back to window
	ULONG			window_id;	// User window ID
	struct MsgPort		*app_port;	// "Window's" application port
} WindowID;

#define WINDOW_MAGIC		0x83224948
#define WINDOW_UNKNOWN		(ULONG)-1
#define WINDOW_UNDEFINED	0

// Window types
#define WINDOW_BACKDROP			0x4000001
#define WINDOW_LISTER			0x4000002
#define WINDOW_BUTTONS			0x4000004
#define WINDOW_GROUP			0x4000008
#define WINDOW_LISTER_ICONS		0x4000010
#define WINDOW_FUNCTION			0x4000020	// not really a window
#define WINDOW_START			0x4000040

#define WINDOW_POPUP_MENU		0x0001200
#define WINDOW_TEXT_VIEWER		0x0001300

typedef struct _WindowData
{
	WindowID		id;		// Window ID information

	ObjectList		*list;		// Window object list
	struct FileRequester	*request;	// Window's file requester
	APTR			visinfo;	// Visual info
	struct DrawInfo		*drawinfo;	// Draw info
	struct DOpusLocale	*locale;	// Locale info
	struct MsgPort		*window_port;	// Window message port (if supplied)
	struct NewMenu		*new_menu;	// NewMenu structure allocated
	struct Menu		*menu_strip;	// Menu strip allocated
	struct Requester	*busy_req;	// Window busy requester
	ULONG			data;		// Window-specific data
	ULONG			flags;		// Flags
	APTR			memory;		// User memory chain, freed when window closes

	APTR			hook_magic;	// Magic for backfill hooks
	struct FontRequester	*font_request;	// Window's font requester

	ULONG			userdata;
	struct TagItem		*user_tags;

	struct List		boopsi_list;	// BOOPSI list
} WindowData;

#define FILE_GLASS_KIND	1000
#define DIR_GLASS_KIND	1001

#define GM_RESIZE	(20)

struct gpResize
{
	ULONG			MethodID;
	struct GadgetInfo	*gpr_GInfo;
	struct RastPort		*gpr_RPort;
	struct IBox		gpr_Size;
	long			gpr_Redraw;
	struct Window		*gpr_Window;
	struct Requester	*gpr_Requester;
};

// Custom tags
#define GTCustom_LocaleLabels	TAG_USER + 0	// Points to list of Locale IDs
#define GTCustom_Image		TAG_USER + 1	// Image for gadget
#define GTCustom_CallBack	TAG_USER + 2	// Tag ID and data filled in by callback
#define GTCustom_LayoutRel	TAG_USER + 3	// Layout relative to this object ID
#define GTCustom_Control	TAG_USER + 4	// Controls another gadget
#define GTCustom_TextAttr	TAG_USER + 6	// TextAttr to use
#define GTCustom_MinMax		TAG_USER + 24	// Minimum and maximum bounds
#define GTCustom_BorderButton	TAG_USER + 26	// Border button
#define GTCustom_ThinBorders	TAG_USER + 27	// Gadget has thin borders
#define GTCustom_TextInside	TAG_USER + 28	// Gadget has text inside it
#define GTCustom_LocaleKey	TAG_USER + 29	// Key from locale string
#define GTCustom_Flags		TAG_USER + 30	// Flags
#define GTCustom_NoSelectNext	TAG_USER + 31	// Don't select next field
#define GTCustom_PathFilter	TAG_USER + 32	// Filter path characters
#define GTCustom_History	TAG_USER + 33	// History
#define GTCustom_CopyTags	TAG_USER + 34	// Copy tags
#define GTCustom_FontPens	TAG_USER + 35	// Place to store pens and style
#define GTCustom_FontPenCount	TAG_USER + 36	// Number of pens for font requester
#define GTCustom_FontPenTable	TAG_USER + 37	// Table of pens for font requester
#define GTCustom_Bold		TAG_USER + 38	// Bold pen
#define GTCustom_Secure		TAG_USER + 39	// Secure string field
#define GTCustom_Integer	TAG_USER + 40	// Integer gadget
#define GTCustom_TextPlacement	TAG_USER + 41	// Position of text
#define GTCustom_NoGhost	TAG_USER + 42	// Disable without ghosting
#define GTCustom_LayoutFlags	TAG_USER + 43	// Layout flags
#define GTCustom_Style		TAG_USER + 44	// Pen styles
#define GTCustom_FrameFlags	TAG_USER + 45	// Frame flags
#define GTCustom_ChangeSigTask	TAG_USER + 46	// Task to signal on change
#define GTCustom_ChangeSigBit	TAG_USER + 47	// Signal bit to use
#define GTCustom_LayoutPos	TAG_USER + 49	// Use with the POSFLAGs
#define GTCustom_Borderless	TAG_USER + 50	// Borderless
#define GTCustom_Justify	TAG_USER + 51	// Justification

#define LAYOUTF_SAME_HEIGHT	(1<<0)
#define LAYOUTF_SAME_WIDTH	(1<<1)
#define LAYOUTF_TOP_ALIGN	(1<<2)
#define LAYOUTF_BOTTOM_ALIGN	(1<<3)
#define LAYOUTF_LEFT_ALIGN	(1<<4)
#define LAYOUTF_RIGHT_ALIGN	(1<<5)

#define JUSTIFY_LEFT		0
#define JUSTIFY_RIGHT		1
#define JUSTIFY_CENTER		2

#define DIA_Type		TAG_USER + 5	// Image type
#define DIA_FrontPen		TAG_USER + 7	// Image front pen

#define IM_ARROW_UP	0
#define IM_ARROW_DOWN	1
#define IM_CHECK	2
#define IM_DRAWER	3
#define IM_BORDER_BOX	4
#define IM_BBOX		5
#define IM_ICONIFY	6
#define IM_CROSS	7
#define IM_LOCK		8

#define MY_LISTVIEW_KIND	127		// Custom listview gadget
#define FILE_BUTTON_KIND	126		// File button gadget
#define DIR_BUTTON_KIND		125		// Directory button gadget
#define FONT_BUTTON_KIND	124		// Font button gadget
#define FIELD_KIND		123		// Text field (no editing)
#define FRAME_KIND		122		// Frame
#define HOTKEY_KIND		121		// Hotkey field

// Listview tags
#define DLV_ScrollUp		TAG_USER + 7		// Scroll list up
#define DLV_ScrollDown		TAG_USER + 8		// Scroll list down
#define DLV_SelectPrevious	TAG_USER + 11		// Select previous item
#define DLV_SelectNext		TAG_USER + 12		// Select next item
#define DLV_Labels		GTLV_Labels		// Labels
#define DLV_Top			GTLV_Top		// Top item
#define DLV_MakeVisible		GTLV_MakeVisible	// Make visible
#define DLV_Selected		GTLV_Selected		// Selected
#define DLV_ScrollWidth		GTLV_ScrollWidth	// Scroller width
#define DLV_ShowSelected	GTLV_ShowSelected	// Show selected
#define DLV_Check		TAG_USER + 10		// Check selection
#define DLV_Highlight		TAG_USER + 14		// Highlight selection
#define DLV_MultiSelect		TAG_USER + 9		// Multi-selection
#define DLV_ReadOnly		GTLV_ReadOnly		// Read only
#define DLV_Lines		TAG_USER + 13		// Visible lines (get only)
#define DLV_ShowChecks		TAG_USER + 15		// Show checkmarks
#define DLV_Flags		TAG_USER + 16		// Layout flags
#define DLV_NoScroller		TAG_USER + 17		// No scroller necessary
#define DLV_TopJustify		TAG_USER + 18		// Top-justify items
#define DLV_RightJustify	TAG_USER + 19		// Right-justify items
#define DLV_DragNotify		TAG_USER + 20		// Notify of drags
#define DLV_GetLine		TAG_USER + 25		// Get line from coordinate
#define DLV_DrawLine		TAG_USER + 26		// Draw a line from the listview
#define DLV_Object		TAG_USER + 27		// Pointer to object
#define DLV_DoubleClick		TAG_USER + 28		// Indicates double-click
#define DLV_ShowFilenames	TAG_USER + 48		// Show filenames only

typedef struct
{
	struct RastPort		*rp;
	struct DrawInfo		*drawinfo;
	struct Node		*node;
	unsigned short		line;
	struct IBox		box;
} ListViewDraw;

// Listview node data
#define lve_Flags		ln_Type			// Listview entry flags
#define lve_Pen			ln_Pri			// Listview entry pen
#define LVEF_SELECTED		(1<<0)			// Entry is selected
#define LVEF_USE_PEN		(1<<1)			// Use pen to render entry
#define LVEF_TEMP		(1<<2)			// Temporary flag for something

// File button tags
#define DFB_DefPath		TAG_USER + 19		// Default path

// Palette tags
#define DPG_Pen			TAG_USER + 21		// Ordinal selected pen
#define DPG_SelectPrevious	TAG_USER + 22		// Select previous pen
#define DPG_SelectNext		TAG_USER + 23		// Select next pen

// Some useful macros
#define GADGET(obj) (obj->gl_info.gl_gadget.gadget)
#define AREA(obj) obj->gl_info.gl_area
#define DATA(win) ((WindowData *)win->UserData)
#define WINFLAG(win) (DATA(win)->flags)
#define WINMEMORY(win) (DATA(win)->memory)
#define WINREQUESTER(win) (DATA(win)->request)
#define OBJLIST(win) (DATA(win)->list)
#define DRAWINFO(win) (DATA(win)->drawinfo)
#define VISINFO(win) (DATA(win)->visinfo)
#define GADSPECIAL(list,id) (GADGET(L_GetObject(list,id))->SpecialInfo)
#define GADSTRING(list,id) ((struct StringInfo *)GADSPECIAL(list,id))->Buffer
#define GADNUMBER(list,id) ((struct StringInfo *)GADSPECIAL(list,id))->LongInt
#define GADSEL(list,id) (GADGET(L_GetObject(list,id))->Flags&GFLG_SELECTED)
#define GADGET_SPECIAL(list,id) (GADGET(GetObject(list,id))->SpecialInfo)
#define GADGET_STRING(list,id) ((struct StringInfo *)GADGET_SPECIAL(list,id))->Buffer
#define GADGET_NUMBER(list,id) ((struct StringInfo *)GADGET_SPECIAL(list,id))->LongInt
#define GADGET_SEL(list,id) (GADGET(GetObject(list,id))->Flags&GFLG_SELECTED)
#define CFGDATA(win) (((WindowData *)win->UserData)->data)

#define MENUID(menu) ((ULONG)GTMENUITEM_USERDATA(menu))


// Window dimensions
typedef struct
{
	struct IBox	wd_Normal;
	struct IBox	wd_Zoomed;
	unsigned short	wd_Flags;
} WindowDimensions;

#define WDF_VALID	(1<<0)
#define WDF_ZOOMED	(1<<1)

void InitWindowDims(struct Window *,WindowDimensions *);
void StoreWindowDims(struct Window *,WindowDimensions *);
BOOL CheckWindowDims(struct Window *,WindowDimensions *);


// Locale marker
struct DOpusLocale
{
	APTR		li_LocaleBase;
	APTR		li_Catalog;
	char		*li_BuiltIn;
	struct Locale	*li_Locale;
};


// List management stuff
typedef struct _Att_List
{
	struct List		list;		// List structure
	struct SignalSemaphore	lock;		// Semaphore for locking
	ULONG			flags;		// Flags
	APTR			memory;		// Memory pool
	struct _Att_Node	*current;	// Current node (application use)
} Att_List;

#define LISTF_LOCK	(1<<0)
#define LISTF_POOL	(1<<1)

typedef struct _Att_Node
{
	struct Node		node;		// Node structure
	Att_List		*list;		// Pointer to list (inefficient!)
	ULONG			data;		// User data
} Att_Node;

#define ADDNODE_SORT		1		// Sort names
#define ADDNODE_EXCLUSIVE	2		// Exclusive entry
#define ADDNODE_NUMSORT		4		// Numerical name sort
#define ADDNODE_PRI		8		// Priority insertion

#define REMLIST_FREEDATA	1		// FreeVec data when freeing list
#define REMLIST_SAVELIST	2		// Don't free list itself

Att_List *Att_NewList(ULONG);
Att_Node *Att_NewNode(Att_List *list,char *name,ULONG data,ULONG flags);
void Att_RemNode(Att_Node *node);
void Att_PosNode(Att_List *,Att_Node *,Att_Node *);
void Att_RemList(Att_List *list,long);
Att_Node *Att_FindNode(Att_List *list,long number);
Att_NodeNumber(Att_List *list,char *name);
Att_Node *Att_FindNodeData(Att_List *list,ULONG data);
Att_NodeDataNumber(Att_List *list,ULONG data);
char *Att_NodeName(Att_List *list,long number);
Att_NodeCount(Att_List *list);
void Att_ChangeNodeName(Att_Node *node,char *name);
Att_FindNodeNumber(Att_List *list,Att_Node *node);
void AddSorted(struct List *list,struct Node *node);
struct Node *FindNameI(struct List *,char *name);
void LockAttList(Att_List *list,short exclusive);
void UnlockAttList(Att_List *list);
void SwapListNodes(struct List *,struct Node *,struct Node *);
BOOL IsListLockEmpty(struct ListLock *);

// Timer handle
typedef struct TimerHandle
{
	struct MsgPort		*port;
	struct timerequest	req;
	struct MsgPort		*my_port;
	short			active;
} TimerHandle;

TimerHandle *AllocTimer(ULONG,struct MsgPort *);
void FreeTimer(TimerHandle *);
void StartTimer(TimerHandle *,ULONG,ULONG);
BOOL CheckTimer(TimerHandle *);
void StopTimer(TimerHandle *);
BOOL TimerActive(TimerHandle *);
struct Library *GetTimerBase(void);


// Notification message
typedef struct
{
	struct Message		dn_Msg;
	ULONG			dn_Type;
	ULONG			dn_UserData;
	ULONG			dn_Data;
	ULONG			dn_Flags;
	struct FileInfoBlock	*dn_Fib;
	char			dn_Name[1];
} DOpusNotify;

#define NT_DOPUS_NOTIFY		199
#define DN_WRITE_ICON		(1<<0)		// Icon written
#define DN_APP_ICON_LIST	(1<<1)		// AppIcon added/removed
#define DN_APP_MENU_LIST	(1<<2)		// AppMenu added/removed
#define DN_CLOSE_WORKBENCH	(1<<3)		// Workbench closed
#define DN_OPEN_WORKBENCH	(1<<4)		// Workbench opened
#define DN_RESET_WORKBENCH	(1<<5)		// Workbench reset
#define DN_DISKCHANGE		(1<<6)		// Disk inserted/removed
#define DN_OPUS_QUIT		(1<<7)		// Main program quit
#define DN_OPUS_HIDE		(1<<8)		// Main program hide
#define DN_OPUS_SHOW		(1<<9)		// Main program show
#define DN_OPUS_START		(1<<10)		// Main program start
#define DN_DOS_ACTION		(1<<11)		// DOS action
#define DN_REXX_UP		(1<<12)		// REXX started

#define DNF_ICON_REMOVED	(1<<0)		// Icon removed
#define DNF_ICON_CHANGED	(1<<1)		// Image changed

#define DNF_DOS_CREATEDIR	(1<<0)		// CreateDir
#define DNF_DOS_DELETEFILE	(1<<1)		// DeleteFile
#define DNF_DOS_SETFILEDATE	(1<<2)		// SetFileDate
#define DNF_DOS_SETCOMMENT	(1<<3)		// SetComment
#define DNF_DOS_SETPROTECTION	(1<<4)		// SetProtection
#define DNF_DOS_RENAME		(1<<5)		// Rename
#define DNF_DOS_CREATE		(1<<6)		// Open file (create)
#define DNF_DOS_CLOSE		(1<<7)		// Close file
#define DNF_DOS_RELABEL		(1<<8)		// Relabel disk

APTR AddNotifyRequest(ULONG,ULONG,struct MsgPort *);
void RemoveNotifyRequest(APTR);
void SendNotifyMsg(ULONG,ULONG,ULONG,short,char *,struct FileInfoBlock *);
void SetNotifyRequest(APTR,ULONG,ULONG);


// Inter-Process Communication
typedef struct {
	struct Message	msg;			// Exec message
	ULONG		command;		// Message command
	ULONG		flags;			// Message flags
	APTR		data;			// Message data
	APTR		data_free;		// Data to be FreeVec()ed automatically
	struct _IPC	*sender;		// Sender IPC
} IPCMessage;

#define PF_ASYNC	(1<<7)

#define REPLY_NO_PORT		(struct MsgPort *)-1
#define REPLY_NO_PORT_IPC	(struct MsgPort *)-2

typedef struct _IPC {
	struct MinNode		node;
	struct Process		*proc;		// Process pointer
	IPCMessage		startup_msg;	// Startup message
	struct MsgPort		*command_port;	// Port to send commands to
	struct ListLock		*list;		// List we're a member of
	APTR			userdata;
	APTR			memory;		// Memory
	struct MsgPort		*reply_port;	// Port for replies
	ULONG			flags;		// Flags
} IPCData;

#define IPCF_INVALID		(1<<0)
#define IPCF_LISTED		(1<<1)
#define IPCF_STARTED		(1<<2)

#define IPCDATA(ipc)		((APTR)ipc->userdata)
#define SET_IPCDATA(ipc,data)	ipc->userdata=(APTR)data

#define IPCF_GETPATH		(1<<31)
#define IPCF_DEBUG		(1<<30)
#define IPCM_STACK(s)		(s&0xffffff)

enum {
	IPC_COMMAND_BASE=0x8000000,
	IPC_STARTUP,
	IPC_ABORT,
	IPC_QUIT,
	IPC_ACTIVATE,
	IPC_HELLO,
	IPC_GOODBYE,
	IPC_HIDE,
	IPC_SHOW,
	IPC_RESET,
	IPC_HELP,
	IPC_NEW,
	IPC_GOT_GOODBYE,
	IPC_IDENTIFY,
	IPC_PRIORITY,
	IPC_REMOVE,
};

#define IPCSIG_HIDE		SIGBREAKF_CTRL_D
#define IPCSIG_SHOW		SIGBREAKF_CTRL_E
#define IPCSIG_QUIT		SIGBREAKF_CTRL_F


// Requesters
#define REF_CALLBACK(name)	void __asm (*name)(register __d0 ULONG,register __a0 APTR,register __a1 APTR)

long AsyncRequest(IPCData *,long,struct Window *,REF_CALLBACK(),APTR,struct TagItem *);
long __stdargs AsyncRequestTags(IPCData *,long,struct Window *,REF_CALLBACK(),APTR,Tag,...);
struct IntuiMessage *CheckRefreshMsg(struct Window *,ULONG);

enum
{
	REQTYPE_FILE,
	REQTYPE_SIMPLE,
};


#define AR_Requester	TAG_USER + 1		// Pointer to requester

#define AR_Window	TAG_USER + 2		// Window
#define AR_Screen	TAG_USER + 3		// Screen
#define AR_Message	TAG_USER + 4		// Text message
#define AR_Button	TAG_USER + 5		// Button label
#define AR_ButtonCode	TAG_USER + 6		// Code for this button
#define AR_Title	TAG_USER + 7		// Title string
#define AR_Buffer	TAG_USER + 8		// String buffer
#define AR_BufLen	TAG_USER + 9		// Buffer length
#define AR_History	TAG_USER + 10		// History list
#define AR_CheckMark	TAG_USER + 11		// Check mark text
#define AR_CheckPtr	TAG_USER + 12		// Check mark data storage
#define AR_Flags	TAG_USER + 13		// Flags



// Pop-up menu stuff
typedef struct {
	struct MinNode	node;
	char		*item_name;		// Menu item name
	USHORT		id;			// Menu ID
	USHORT		flags;			// Menu item flags
	APTR		data;			// Menu item data
} PopUpItem;

#define POPUPF_LOCALE		(1<<0)	// Item name is a locale ID
#define POPUPF_CHECKIT		(1<<1)	// Item can be checked
#define POPUPF_CHECKED		(1<<2)	// Item is checked
#define POPUPF_SUB		(1<<3)	// Item has sub-items
#define POPUPF_DISABLED		(1<<4)	// Item is disabled
#define POPUPF_STRING		(1<<5)

#define POPUP_BARLABEL		(char *)-1

typedef struct {
	struct MinList		item_list;	// List of menu items
	struct DOpusLocale	*locale;	// Locale data
	ULONG			flags;		// Flags
	ULONG			userdata;	// User data
	REF_CALLBACK		(callback);	// Refresh callback
} PopUpMenu;

#define POPUPMF_HELP		(1<<0)		// Supports help
#define POPUPMF_REFRESH		(1<<1)		// Use refresh callback
#define POPUPMF_ABOVE		(1<<2)		// Open above parent window
#define POPUP_HELPFLAG		(1<<15)

USHORT DoPopUpMenu(struct Window *,PopUpMenu *,PopUpItem **,USHORT);
PopUpItem *GetPopUpItem(PopUpMenu *,USHORT);


struct ListLock {
	struct List		list;
	struct SignalSemaphore	lock;
};

long GetSemaphore(struct SignalSemaphore *,long,char *);
void FreeSemaphore(struct SignalSemaphore *);
void ShowSemaphore(struct SignalSemaphore *);
void InitListLock(struct ListLock *,char *);

#define SEMF_SHARED		0
#define SEMF_EXCLUSIVE		(1<<0)
#define SEMF_ATTEMPT		(1<<1)

// Image routine tags
#define IM_Width		TAG_USER + 0		// Width of image
#define IM_Height		TAG_USER + 1		// Height of image
#define IM_State		TAG_USER + 2		// 1 = selected, 0 = normal (default)
#define IM_Rectangle		TAG_USER + 3		// Rectangle to center within
#define IM_Mask			TAG_USER + 4		// 1 = mask image
#define IM_Depth		TAG_USER + 5		// Depth of image
#define IM_ClipBoundary		TAG_USER + 6		// Clip boundary size
#define IM_Erase		TAG_USER + 7		// Erase background
#define IM_NoDrawInvalid	TAG_USER + 8		// Don't draw if image is invalid
#define IM_NoIconRemap		TAG_USER + 9		// Don't remap icons

/* SimpleRequest structure */

struct DOpusSimpleRequest {
	char		*title;			// Title
	char		*message;		// Text to display
	char		**gadgets;		// Gadget names
	int		*return_values;		// Gadget return values
	char		*string_buffer;		// Buffer for string gadget
	int		string_len;		// Maximum string length
	int		flags;			// Flags, see below
	struct TextFont	*font;			// Font to use
	IPCData		*ipc;			// IPC port to listen to
	Att_List	*history;		// History list
	char		*check_text;		// Text for checkmark
	short		*check_ptr;		// Result of checkmark
};

#define SRF_LONGINT		(1<<0)	// Integer gadget
#define SRF_CENTJUST		(1<<1)	// Center justify
#define SRF_RIGHTJUST		(1<<2)	// Right justify
#define SRF_SCREEN_PARENT	(1<<5)	// Parent is a screen
#define SRF_IPC			(1<<6)	// Listen to IPC port
#define SRF_SIGNAL		(1<<7)	// Wait for a signal
#define SRF_HISTORY		(1<<8)	// History supplied
#define SRF_PATH_FILTER		(1<<9)	// Filter path characters
#define SRF_BUFFER		(1<<10)	// Buffer supplied (not really used)
#define SRF_CHECKMARK		(1<<11)	// Checkmark supplied
#define SRF_SECURE		(1<<12)	// Secure field
#define SRF_MOUSE_POS		(1<<13)	// Position over mouse pointer

// SelectionList

#define SLF_DIR_FIELD		(1<<0)	// Directory field


// Disk IO stuff
typedef struct
{
	struct MsgPort			*dh_port;	// Message port
	struct IOExtTD			*dh_io;		// IO request
	struct FileSysStartupMsg	*dh_startup;	// Startup message
	struct DosEnvec			*dh_geo;	// Disk geometry
	char				dh_name[32];	// Disk name
	char				dh_device[32];	// Device name
	struct InfoData			dh_info;	// Disk information
	unsigned long			dh_result;
	unsigned long			dh_root;	// Root block
	unsigned long			dh_blocksize;	// Block size
	struct DateStamp		dh_stamp;	// DateStamp
} DiskHandle;

#define ID_AFS_PRO		0x41465301
#define ID_AFS_USER		0x41465302
#define ID_AFS_MULTI		0x6D754146
#define ID_PFS_FLOPPY		0x50465300
#define ID_PFS_HARD		0x50465301

DiskHandle *OpenDisk(char *,struct MsgPort *);
void CloseDisk(DiskHandle *);


// String edit hook

struct Hook *GetEditHook(ULONG,ULONG,struct TagItem *tags);
struct Hook *__stdargs GetEditHookTags(ULONG,ULONG,Tag,...);
void FreeEditHook(struct Hook *);
char *GetSecureString(struct Gadget *);

#define EDITF_NO_SELECT_NEXT	(1<<0)		// Don't select next field
#define EDITF_PATH_FILTER	(1<<1)		// Filter path characters
#define EDITF_PASSWORD		(1<<2)		// Hidden password field



// Copy protection (sic)
typedef struct
{
	long	serial_number;			// Actual serial number (Xor)
	long	random_key;			// Random key (xxxx)
	char	serial_check_1[6];		// Check #1 (AAAAA)
	char	serial_check_2[5];		// Check #2 (yyyy)
	char	serial_check_3;			// Check #3 (c)
} serial_data;


// Screen Info

#define SCRI_LORES	(1<<0)

ULONG ScreenInfo(struct Screen *);


// Images
typedef struct
{
	struct Screen	*ir_Screen;
	unsigned short	*ir_PenArray;
	short		ir_PenCount;
	unsigned long	ir_Flags;
} ImageRemap;

#define IRF_REMAP_COL0		(1<<0)
#define IRF_PRECISION_EXACT	(1<<1)
#define IRF_PRECISION_ICON	(1<<2)
#define IRF_PRECISION_GUI	(1<<3)

typedef struct
{
	USHORT	*oi_ImageData;
	ULONG	*oi_Palette;
	short	oi_Width;
	short	oi_Height;
	short	oi_Depth;
} OpenImageInfo;

APTR OpenImage(char *name,OpenImageInfo *);
void CloseImage(APTR image);
APTR CopyImage(APTR image);
void FlushImages(void);
short RenderImage(struct RastPort *rp,APTR image,unsigned short left,unsigned short top,struct TagItem *tags);
void GetImageAttrs(APTR image,struct TagItem *tags);
ULONG *GetImagePalette(APTR image);
void FreeImageRemap(ImageRemap *);
BOOL RemapImage(APTR,struct Screen *,ImageRemap *);
void FreeRemapImage(APTR,ImageRemap *);


/*** IFF ***/

#define IFF_READ	MODE_OLDFILE
#define IFF_WRITE	MODE_NEWFILE
#define IFF_CLIP	0x8000
#define IFF_CLIP_READ	(IFF_CLIP|IFF_READ)
#define IFF_CLIP_WRITE	(IFF_CLIP|IFF_WRITE)
#define IFF_SAFE	0x4000
#define IFF_ASYNC	0x2000

APTR IFFOpen(char *,unsigned short,ULONG);
void IFFClose(APTR);
long IFFPushChunk(APTR,ULONG);
long IFFWriteChunkBytes(APTR,APTR,long);
long IFFPopChunk(APTR);
long IFFWriteChunk(APTR,APTR,ULONG,ULONG);
ULONG IFFNextChunk(APTR,ULONG);
long IFFChunkSize(APTR);
long IFFReadChunkBytes(APTR,APTR,long);
APTR IFFFileHandle(APTR);
long IFFChunkRemain(APTR);
ULONG IFFChunkID(APTR);
ULONG IFFGetFORM(APTR);
void IFFFailure(APTR);

/* Function prototypes */

void ActivateStrGad(struct Gadget *,struct Window *);
Atoh(char *,int);
Itoa(long,char *,char);
ItoaU(unsigned long,char *,char);
Ito26(unsigned long,char *);
BytesToString(unsigned long,char *,short,char);
DivideToString(char *,unsigned long,unsigned long,short,char);

ULONG CompareListFormat(ListFormat *,ListFormat *);

void BtoCStr(BSTR,char *,int);

DoSimpleRequest(struct Window *,struct DOpusSimpleRequest *);
SimpleRequest(struct Window *,char *,char *,char *,char *,APTR,long,ULONG);
SimpleRequestTags(struct Window *,char *,char *,char *,...);
SimpleRequestScreenTags(struct Screen *,char *,char *,char *,...);
short SelectionList(Att_List *,struct Window *,struct Screen *,char *,short,ULONG,char *,char *,char *);

void Seed(int);
Random(int);
BuildKeyString(unsigned short,unsigned short,unsigned short,unsigned short,char *);
USHORT QualValid(unsigned short);
ConvertRawKey(unsigned short,unsigned short,char *);
void SetBusyPointer(struct Window *);
StrCombine(char *,char *,char *,int);
StrConcat(char *,char *,int);
BPTR GetDosPathList(BPTR);
void FreeDosPathList(BPTR);
void CopyLocalEnv(struct Library *);

// Layout functions
struct Window *OpenConfigWindow(NewConfigWindow *);
void CloseConfigWindow(struct Window *);
struct IntuiMessage *GetWindowMsg(struct MsgPort *);
void ReplyWindowMsg(struct IntuiMessage *);
ObjectList *AddObjectList(struct Window *,ObjectDef *);
void FreeObject(ObjectList *,GL_Object *);
void FreeObjectList(ObjectList *);
GL_Object *GetObject(ObjectList *,int);
void StoreGadgetValue(ObjectList *,struct IntuiMessage *);
void UpdateGadgetValue(ObjectList *,struct IntuiMessage *,USHORT);
void UpdateGadgetList(ObjectList *);
void SetGadgetValue(ObjectList *,USHORT,ULONG);
long GetGadgetValue(ObjectList *,USHORT);
void SetGadgetChoices(ObjectList *list,ULONG id,APTR choices);
CheckObjectArea(GL_Object *,int,int);
void DisplayObject(struct Window *,GL_Object *,int fg,int bg,char *txt);
void StripIntuiMessages(struct Window *);
void CloseWindowSafely(struct Window *);
void AddWindowMenus(struct Window *,MenuData *);
void FreeWindowMenus(struct Window *);
void SetWindowBusy(struct Window *);
void ClearWindowBusy(struct Window *);
STRPTR GetString(struct DOpusLocale *,LONG);
struct Gadget *FindKeyEquivalent(ObjectList *,struct IntuiMessage *,int);
void ShowProgressBar(struct Window *,GL_Object *,ULONG,ULONG);
void SetObjectKind(ObjectList *,ULONG,USHORT);
void DisableObject(ObjectList *,ULONG,BOOL);
BoundsCheckGadget(ObjectList *,ULONG,int,int);
void RefreshObjectList(struct Window *,ObjectList *);
struct Menu *BuildMenuStrip(MenuData *,struct DOpusLocale *);
struct MenuItem *FindMenuItem(struct Menu *,USHORT);

void SetWindowID(struct Window *,WindowID *,ULONG,struct MsgPort *);
ULONG GetWindowID(struct Window *);
struct MsgPort *GetWindowAppPort(struct Window *);
BOOL GetObjectRect(ObjectList *,ULONG,struct Rectangle *);
void LayoutResize(struct Window *);
void SetConfigWindowLimits(struct Window *,ConfigWindow *,ConfigWindow *);

void StartRefreshConfigWindow(struct Window *,long);
void EndRefreshConfigWindow(struct Window *);

// Memory allocation
void *NewMemHandle(ULONG puddle_size,ULONG thresh_size,ULONG type);
void FreeMemHandle(void *handle);
void ClearMemHandle(void *handle);
void *AllocMemH(void *handle,ULONG size);
void FreeMemH(void *memory);

// configuration

Cfg_Lister *NewLister(char *path);
Cfg_ButtonBank *NewButtonBank(BOOL,short);
Cfg_Button *NewButton(APTR memory);
Cfg_Button *NewButtonWithFunc(APTR memory,char *label,short type);
Cfg_Function *NewFunction(APTR memory,UWORD type);
Cfg_ButtonFunction *NewButtonFunction(APTR memory,UWORD type);
Cfg_Instruction *NewInstruction(APTR memory,short type,char *string);
Cfg_Filetype *NewFiletype(APTR memory);

short ReadSettings(CFG_SETS *,char *);
Cfg_Lister *ReadListerDef(APTR,ULONG);
Cfg_ButtonBank *OpenButtonBank(char *name);
Cfg_FiletypeList *ReadFiletypes(char *name,APTR memory);
Cfg_Button *ReadButton(APTR iff,APTR memory);
Cfg_Function *ReadFunction(APTR iff,APTR memory,struct List *func_list,Cfg_Function *function);

#define READCFG_FAIL	0
#define READCFG_OK	1
#define READCFG_WRONG	2

void DefaultSettings(CFG_SETS *);
void DefaultEnvironment(CFG_ENVR *);
Cfg_ButtonBank *DefaultButtonBank(void);
SaveFiletypeList(Cfg_FiletypeList *list,char *name);
SaveSettings(CFG_SETS *,char *name);
SaveListerDef(APTR,Cfg_Lister *lister);
SaveButtonBank(Cfg_ButtonBank *bank,char *name);
SaveButton(APTR,Cfg_Button *);
SaveFunction(APTR,Cfg_Function *);

void CloseButtonBank(Cfg_ButtonBank *bank);
void FreeListerDef(Cfg_Lister *lister);
void FreeButtonList(struct List *list);
void FreeButtonImages(struct List *list);
void FreeButton(Cfg_Button *button);
void FreeFunction(Cfg_Function *function);
void FreeButtonFunction(Cfg_ButtonFunction *function);
void FreeInstruction(Cfg_Instruction *ins);
void FreeInstructionList(Cfg_Function *func);
void FreeFiletypeList(Cfg_FiletypeList *list);
void FreeFiletype(Cfg_Filetype *type);

Cfg_ButtonBank *CopyButtonBank(Cfg_ButtonBank *orig);
Cfg_Button *CopyButton(Cfg_Button *orig,APTR,short);
Cfg_Filetype *CopyFiletype(Cfg_Filetype *,APTR);
Cfg_Function *CopyFunction(Cfg_Function *orig,APTR,Cfg_Function *new);
Cfg_ButtonFunction *CopyButtonFunction(Cfg_ButtonFunction *,APTR,Cfg_ButtonFunction *);

Cfg_Function *FindFunctionType(struct List *list,UWORD type);


// IPC
IPC_Launch(struct ListLock *,IPCData **,char *,ULONG,ULONG,ULONG,struct Library *);
IPC_Launch_Local(struct ListLock *,IPCData **,char *,ULONG,ULONG,ULONG,struct Library *);
IPC_Startup(IPCData *,APTR,struct MsgPort *);
ULONG IPC_Command(IPCData *,ULONG,ULONG,APTR,APTR,struct MsgPort *);
ULONG IPC_SafeCommand(IPCData *,ULONG,ULONG,APTR,APTR,struct MsgPort *,struct ListLock *);
void IPC_Reply(IPCMessage *);
void IPC_Free(IPCData *);
void IPC_Flush(IPCData *);
IPCData *IPC_FindProc(struct ListLock *,char *,BOOL,ULONG);
IPCData *IPC_ProcStartup(ULONG *,ULONG (*__asm)(register __a0 IPCData *,register __a1 APTR));
void IPC_Quit(IPCData *,ULONG,BOOL);
void IPC_Hello(IPCData *,IPCData *);
void IPC_Goodbye(IPCData *,IPCData *,ULONG);
ULONG IPC_GetGoodbye(IPCMessage *);
ULONG IPC_ListQuit(struct ListLock *list,IPCData *owner,ULONG quit_flags,BOOL wait);
void IPC_ListCommand(struct ListLock *list,ULONG command,ULONG flags,ULONG data,BOOL wait);
void IPC_QuitName(struct ListLock *,char *,ULONG);



// gui
void DrawBox(struct RastPort *,struct Rectangle *,struct DrawInfo *,BOOL);
void DrawFieldBox(struct RastPort *,struct Rectangle *,struct DrawInfo *);
BOOL WriteIcon(char *,struct DiskObject *);

// status
struct Window *OpenStatusWindow(char *,char *,struct Screen *,LONG,ULONG);
void SetStatusText(struct Window *,char *);
void UpdateStatusGraph(struct Window *,char *,ULONG,ULONG);

// clipboard
struct ClipHandle *OpenClipBoard(ULONG);
void CloseClipBoard(struct ClipHandle *);
BOOL WriteClipString(struct ClipHandle *,char *,long);
long ReadClipString(struct ClipHandle *,char *,long);

// palette
void LoadPalette32(struct ViewPort *,unsigned long *);
void GetPalette32(struct ViewPort *,unsigned long *,unsigned short,short);

// buffered_io
APTR OpenBuf(char *name,long mode,long buffer_size);
void CloseBuf(APTR file);
long ReadBuf(APTR file,char *data,long size);
long WriteBuf(APTR file,char *data,long size);
void FlushBuf(APTR file);
long SeekBuf(APTR file,long offset,long mode);
long ExamineBuf(APTR file,struct FileInfoBlock *fib);
BPTR FHFromBuf(APTR file);


// boopsi
struct Gadget *AddScrollBars(struct Window *,struct List *,struct DrawInfo *,short);
struct Gadget *FindBOOPSIGadget(struct List *,USHORT);
void BOOPSIFree(struct List *);
struct Gadget *CreateTitleGadget(struct Screen *,struct List *,BOOL,short,short,unsigned short);
struct Gadget *FindGadgetType(struct Gadget *,UWORD);
void FixTitleGadgets(struct Window *);

#define SCROLL_NOIDCMP	(1<<0)
#define SCROLL_VERT	(1<<1)
#define SCROLL_HORIZ	(1<<2)



ULONG DivideU(unsigned long,unsigned long,unsigned long *,struct Library *);
BOOL SerialValid(serial_data *);
BOOL SerialCheck(char *,ULONG *);
ULONG ChecksumFile(char *,ULONG);

void ReplyFreeMsg(APTR);
BOOL GetWBArgPath(struct WBArg *,char *,long);

void WriteFileIcon(char *,char *);

struct PubScreenNode *FindPubScreen(struct Screen *,BOOL);


BOOL WB_Launch(char *,struct Screen *,short);
BOOL CLI_Launch(char *,struct Screen *,BPTR,BPTR,BPTR,short);


// anim
void AnimDecodeRIFFXor(unsigned char *,char *,unsigned short,unsigned short);
void AnimDecodeRIFFSet(unsigned char *,char *,unsigned short,unsigned short);

// devices
struct DosList *DeviceFromLock(BPTR,char *);
struct DosList *DeviceFromHandler(struct MsgPort *,char *);
BOOL DevNameFromLock(BPTR,char *,long);


#define ERROR_NOT_CONFIG -1

#define RECTWIDTH(rect)		(1+(rect)->MaxX-(rect)->MinX)
#define RECTHEIGHT(rect)	(1+(rect)->MaxY-(rect)->MinY)


enum
{
	GAD_xxx=1,

	GAD_VERT_SCROLLER,
	GAD_VERT_ARROW_UP,
	GAD_VERT_ARROW_DOWN,

	GAD_HORIZ_SCROLLER,
	GAD_HORIZ_ARROW_LEFT,
	GAD_HORIZ_ARROW_RIGHT,
};


// Workbench patch stuff
enum
{
	APP_ICON,
	APP_WINDOW,
	APP_MENU
};

typedef struct
{
	struct MinNode		node;
	ULONG			type;		// Type of entry

	ULONG			id;		// ID
	ULONG			userdata;	// User data

	APTR			object;		// Type-specific object
	char			*text;		// If text is needed
	struct MsgPort		*port;		// Message port

	APTR			os_object;	// Object from OS routine

	unsigned short		flags;		// Some flags

	struct MinList		menu;		// Menu items

	unsigned short		data;
	long			menu_id_base;	// Base ID for menu
}  AppEntry;

#define DAE_Local		TAG_USER + 0		// Local entry
#define DAE_SnapShot		TAG_USER + 1		// Supports snapshot
#define DAE_Menu		TAG_USER + 2		// Menu item
#define DAE_Close		TAG_USER + 3		// Close item
#define DAE_Background		TAG_USER + 4		// Background colour
#define DAE_ToggleMenu		TAG_USER + 5		// Toggle item
#define DAE_ToggleMenuSel	TAG_USER + 6		// Toggle item (selected)
#define DAE_Info		TAG_USER + 7		// Supports Information
#define DAE_Locked		TAG_USER + 8		// Position locked
#define DAE_MenuBase		TAG_USER + 9		// Menu ID base

#define ln_MenuFlags		ln_Type

#define MNF_TOGGLE		(1<<0)
#define MNF_SEL			(1<<1)

#define APPENTF_LOCAL		(1<<0)
#define APPENTF_SNAPSHOT	(1<<1)
#define APPENTF_ICON_COPY	(1<<2)
#define APPENTF_CLOSE		(1<<3)
#define APPENTF_NO_OPEN		(1<<4)
#define APPENTF_BACKGROUND	(1<<5)
#define APPENTF_INFO		(1<<6)
#define APPENTF_LOCKED		(1<<7)
#define APPENTF_BUSY		(1<<8)

void WB_Install_Patch(void);
BOOL WB_Remove_Patch(void);
struct AppWindow *WB_AddAppWindow(ULONG,ULONG,struct Window *,struct MsgPort *,struct TagItem *);
BOOL WB_RemoveAppWindow(struct AppWindow *);
struct AppWindow *WB_FindAppWindow(struct Window *);
struct MsgPort *WB_AppWindowData(struct AppWindow *,ULONG *,ULONG *);
BOOL WB_AppWindowLocal(struct AppWindow *);
ULONG WB_AppIconFlags(struct AppIcon *);
APTR LockAppList(void);
APTR NextAppEntry(APTR,ULONG);
void UnlockAppList(void);

#define MTYPE_APPSNAPSHOT	0x3812
#define MTYPE_APPICONMENU	0x3813

struct AppSnapshotMsg
{
	struct AppMessage	ap_msg;		// Message
	long			position_x;	// Icon x-position
	long			position_y;	// Icon y-position
	struct IBox		window_pos;	// Window position
	unsigned long		flags;		// Flags
	long			id;		// ID
};

#define APPSNAPF_UNSNAPSHOT	(1<<0)		// Set "no position"
#define APPSNAPF_WINDOW_POS	(1<<1)		// Window position supplied
#define APPSNAPF_MENU		(1<<2)		// Menu operation
#define APPSNAPF_CLOSE		(1<<3)		// Close command
#define APPSNAPF_HELP		(1<<4)		// Help on a command
#define APPSNAPF_INFO		(1<<5)		// Information command

#define ICONF_POSITION_OK	(1<<31)		// Opus position stored in icon
#define ICONF_GROUP_OBJECT	(1<<30)		// Icon is from a group object
#define ICONF_ICON_VIEW		(1<<29)		// View as icons
#define ICONF_TRANSPARENT	(1<<28)		// No icon background
#define ICONF_NO_LABEL		(1<<27)		// No label

ULONG GetIconFlags(struct DiskObject *);
void SetIconFlags(struct DiskObject *,ULONG);
void GetIconPosition(struct DiskObject *,short *,short *);
void SetIconPosition(struct DiskObject *,short,short);

struct DiskObject *CopyDiskObject(struct DiskObject *,ULONG);
void FreeDiskObjectCopy(struct DiskObject *);

#define DOCF_COPYALL		(1<<0)		// Copy tooltypes, etc
#define DOCF_NOIMAGE		(1<<1)		// Don't copy image data

struct DiskObject *GetCachedDefDiskObject(long);
void FreeCachedDiskObject(struct DiskObject *);
struct DiskObject *GetCachedDiskObject(char *);
struct DiskObject *GetCachedDiskObjectNew(char *);
unsigned long IconCheckSum(struct DiskObject *,short);

void ChangeAppIcon(APTR,struct Image *,struct Image *,char *,ULONG);
long SetAppIconMenuState(APTR,long,long);

#define CAIF_RENDER	(1<<0)
#define CAIF_SELECT	(1<<1)
#define CAIF_TITLE	(1<<2)
#define CAIF_LOCKED	(1<<3)
#define CAIF_SET	(1<<4)
#define CAIF_BUSY	(1<<5)
#define CAIF_UNBUSY	(1<<6)

#define MTYPE_DOPUS		(UWORD)-1

typedef struct _DOpusAppMessage
{
	struct AppMessage	da_Msg;
	Point			*da_DropPos;
	Point			da_DragOffset;
	ULONG			da_Flags;
	ULONG			da_Pad[2];
} DOpusAppMessage;

#define DAPPF_ICON_DROP		(1<<16)		// Dropped with icon

DOpusAppMessage *AllocAppMessage(APTR,struct MsgPort *,short);
void FreeAppMessage(DOpusAppMessage *);
void ReplyAppMessage(DOpusAppMessage *);
BOOL CheckAppMessage(DOpusAppMessage *);
DOpusAppMessage *CopyAppMessage(DOpusAppMessage *,APTR);
BOOL SetWBArg(DOpusAppMessage *,short,BPTR,char *,APTR);

// Progress window
APTR OpenProgressWindow(struct TagItem *);
void CloseProgressWindow(APTR);
void HideProgressWindow(APTR);
void ShowProgressWindow(APTR,struct Screen *,struct Window *);
void SetProgressWindow(APTR,struct TagItem *);
void GetProgressWindow(APTR,struct TagItem *);
BOOL CheckProgressAbort(APTR);

APTR __stdargs OpenProgressWindowTags(Tag,...);
void __stdargs SetProgressWindowTags(APTR,Tag,...);
void __stdargs GetProgressWindowTags(APTR,Tag,...);

#define PW_Screen	TAG_USER + 0		// Screen to open on
#define PW_Window	TAG_USER + 1		// Owner window
#define PW_Title	TAG_USER + 2		// Window title
#define PW_SigTask	TAG_USER + 3		// Task to signal
#define PW_SigBit	TAG_USER + 4		// Signal bit
#define PW_Flags	TAG_USER + 5		// Flags
#define PW_FileName	TAG_USER + 6		// File name
#define PW_FileSize	TAG_USER + 7		// File size
#define PW_FileDone	TAG_USER + 8		// File done
#define PW_FileCount	TAG_USER + 9		// Number of files
#define PW_FileNum	TAG_USER + 10		// Current number
#define PW_Info		TAG_USER + 11		// Information line

#define PWF_FILENAME		(1<<0)		// Filename display
#define PWF_FILESIZE		(1<<1)		// Filesize display
#define PWF_INFO		(1<<2)		// Information line
#define PWF_GRAPH		(1<<3)		// Bar graph display
#define PWF_NOABORT		(1<<4)		// No abort gadget
#define PWF_INVISIBLE		(1<<5)		// Open invisibly
#define PWF_ABORT		(1<<6)		// Want abort gadget
#define PWF_SWAP		(1<<7)		// Swap bar and size displays


// Search
long SearchFile(APTR,UBYTE *,ULONG,UBYTE *,ULONG);

// Search Flags
#define SEARCH_NOCASE		(1<<0)	// Not case sensitive
#define SEARCH_WILDCARD		(1<<1)	// Wildcards
#define SEARCH_ONLYWORDS	(1<<2)	// Only match whole words


// Date routines
char *ParseDateStrings(char *,char *,char *,long *);
BOOL DateFromStrings(char *,char *,struct DateStamp *);

#define RANGE_BETWEEN		1
#define RANGE_AFTER		2
#define RANGE_WEIRD		-1


// Filetype matching
APTR GetMatchHandle(char *);
void FreeMatchHandle(APTR);
BOOL MatchFiletype(APTR,APTR);
void ClearFiletypeCache(void);


// version
BOOL GetFileVersion(char *,short *,short *,struct DateStamp *,APTR);


// Set flags in library
ULONG SetLibraryFlags(ULONG,ULONG);

#define LIBDF_SYSIHACK		(1<<0)
#define LIBDF_NO_CACHING	(1<<1)
#define LIBDF_NOSTIPPLE		(1<<2)
#define LIBDF_DOS_PATCH		(1<<3)
#define LIBDF_3DLOOK		(1<<4)
#define LIBDF_FT_CACHE		(1<<5)

// Bitmap
struct BitMap *NewBitMap(ULONG,ULONG,ULONG,ULONG,struct BitMap *);
void DisposeBitMap(struct BitMap *);


// Args
typedef struct
{
	struct RDArgs	*FA_RDArgs;	// RDArgs structure
	struct RDArgs	*FA_RDArgsRes;	// Return from ReadArgs()
	char		*FA_ArgString;	// Copy of argument string (with newline)
	LONG		*FA_ArgArray;	// Argument array pointer
	LONG		*FA_Arguments;	// Argument array you should use
	short		FA_Count;	// Number of arguments
	short		FA_DoneArgs;	// DOpus uses this flag for its own purposes
} FuncArgs;

FuncArgs *ParseArgs(char *,char *);
void DisposeArgs(FuncArgs *);

void SetEnv(char *,char *,BOOL);


// Original DOS functions
BPTR OriginalCreateDir(char *);
long OriginalDeleteFile(char *);
BOOL OriginalSetFileDate(char *,struct DateStamp *);
BOOL OriginalSetComment(char *,char *);
BOOL OriginalSetProtection(char *,ULONG);
BOOL OriginalRename(char *,char *);
BOOL OriginalRelabel(char *,char *);
BPTR OriginalOpen(char *,LONG);
BOOL OriginalClose(BPTR);
LONG OriginalWrite(BPTR,void *,LONG);

#ifndef DOPUS_PRAG
#include "dopuspragmas.h"
#endif

#endif
