#include <ntp.h>
#include <libraries/dosextens.h>
#include <intuition/intuition.h>
#include <exec/memory.h>

#include <stdio.h>

#define COPY    1
#define MOVE    2
#define DEL     3
#define RENAME  4
#define SEND    5
#define SEARCH  6
#define BUILDAG 7
#define OTHER   8
#define FINDF   9
#define CREATET 10 /* create tree structure, fn ak dostane ako druhy parameter
                      nulu, tak vtedy si dany dir zapameta. Inak to neni dir */
#define CREATT  11

#define ADD     1
#define REM     2

#define SET     1

#ifdef TEST
NTBase NTB,*NTPBase;
NTPPrefs NTPp;
#endif

extern struct FileLock *CurrentDir(),*Lock();
extern struct Gadget NWGadget8,NWGadget18,NWGadget17;
extern struct FileHandle *Open();
static int (*fptr)(char *,char *);
char sv;

Prototype void DosError(int e)
{
   switch(e)
   {
      case 103: ErrorLine("DOS-Error: NO FREE STORE");break;
      case 105: ErrorLine("DOS-Error: TASK TABLE FULL");break;
      case 120: ErrorLine("DOS-Error: LINE TOO LONG");break;
      case 121: ErrorLine("DOS-Error: FILE NOT OBJECT");break;
      case 122: ErrorLine("DOS-Error: INVALID RESIDENT LIBRARY");break;
      case 201: ErrorLine("DOS-Error: NO DEFAULT DIR");break;
      case 202: ErrorLine("DOS-Error: OBJECT IN USE");break;
      case 203: ErrorLine("DOS-Error: OBJECT EXISTS");break;
      case 204: ErrorLine("DOS-Error: DIR NOT FOUND");break;
      case 205: ErrorLine("DOS-Error: OBJECT NOT FOUND");break;
      case 206: ErrorLine("DOS-Error: BAD STREAM NAME");break;
      case 207: ErrorLine("DOS-Error: OBJECT TOO LARGE");break;
      case 209: ErrorLine("DOS-Error: ACTION NOT KNOWN");break;
      case 210: ErrorLine("DOS-Error: INVALID COMPONENT NAME");break;
      case 211: ErrorLine("DOS-Error: INVALID LOCK");break;
      case 212: ErrorLine("DOS-Error: OBJECT WRONG TYPE");break;
      case 213: ErrorLine("DOS-Error: DISK NOT VALIDATED");break;
      case 214: ErrorLine("DOS-Error: DISK WRITE PROTECTED");break;
      case 215: ErrorLine("DOS-Error: RENAME ACROSS DEVICES");break;
      case 216: ErrorLine("DOS-Error: DIRECTORY NOT EMPTY");break;
      case 217: ErrorLine("DOS-Error: TOO MANY LEVELS");break;
      case 218: ErrorLine("DOS-Error: DEVICE NOT MOUNTED");break;
      case 219: ErrorLine("DOS-Error: SEEK ERROR");break;
      case 220: ErrorLine("DOS-Error: COMMENT TOO BIG");break;
      case 221: ErrorLine("DOS-Error: DISK FULL");break;
      case 222: ErrorLine("DOS-Error: DELETE PROTECTED");break;
      case 223: ErrorLine("DOS-Error: WRITE PROTECTED");break;
      case 224: ErrorLine("DOS-Error: READ PROTECTED");break;
      case 225: ErrorLine("DOS-Error: NOT A DOS DISK");break;
      case 226: ErrorLine("DOS-Error: NO DISK");break;
      case 232: ErrorLine("DOS-Error: NO MORE ENTRIES");break;
      case 233: ErrorLine("DOS-Error: IS SOFT LINK");break;
      case 234: ErrorLine("DOS-Error: OBJECT LINKED");break;
      case 235: ErrorLine("DOS-Error: BAD HUNK");break;
      case 236: ErrorLine("DOS-Error: NOT IMPLEMENTED");break;
      case 240: ErrorLine("DOS-Error: RECORD NOT LOCKED");break;
      case 241: ErrorLine("DOS-Error: LOCK COLLISION");break;
      case 242: ErrorLine("DOS-Error: LOCK TIMEOUT");break;
      case 243: ErrorLine("DOS-Error: UNLOCK ERROR");break;
      case 303: ErrorLine("DOS-Error: BUFFER OVERFLOW");break;
      case 304: ErrorLine("DOS-Error: BREAK");break;
      case 305: ErrorLine("DOS-Error: NOT EXECUTABLE");break;
      default : ErrorLine("DOS-Error: UNKNOWN ERROR (BY NTP)");break;
   }
}

Prototype void FreeNode(int i)
{
   if(pw[Act].l[i]->Comment) FreeMem(pw[Act].l[i]->Comment,80);
   FreeMem(pw[Act].l[i],sizeof(Dir));
   pw[Act].l[i]=0;
}

Prototype FSearch1(char *sou)
{
   FILE *f;
   if(f=fopen(sou,"r"))
   {
      char c,i=0;
      while((c=fgetc(f))!=EOF)
      {
         if(c!=lse[i]) i=sep[i];
         if(c==lse[i])
            if(lse[i+1]==0)
            {
               fclose(f);
               strcpy(buf,lse);
               men=1;
               if(!ED1(spath,1))
               {
                  strcpy(lse,spath);
                  sep[0]=1;
                  return(0);
               }
               return(1);
            }
            else i++;
      }
      fclose(f);
    }
    return(1);
}

Prototype void FSearch()
{
   *lse=0;
#ifdef GERMAN
   if(StringReq(lse,"Kette zum suchen"))
#else
   if(StringReq(lse,"String to search"))
#endif
   {
      ParseLse();
      ResDir(OTHER,FSearch1);
      if(sep[0]==1)
      {
         int x;
         for(x=strlen(lse);x>=0;x--)
            if(lse[x]=='/'||lse[x]==':')
               break;
         if(x>-1)
         {
            x++;
            if(strncmp(lse,wp[Act].Path,x))
            {
               CopyMem(lse,wp[Act].Path,x);
               wp[Act].Path[x]=0;
               GetSort(Act);
            }
            pw[Act].First=-10000;
            FirstOcc(lse+x);
            pw[Act].l[pw[Act].CurAct+pw[Act].First]->Set=0;
            SetCount();
#ifdef GERMAN
         } else ErrorLine("Error");
#else
         } else ErrorLine("Error in FSEarch");
#endif
      }
   }
}

Prototype AddNode(Dir **d,int i,char *name,char *size,char *prot)
{
   if(d[i]=(Dir *)AllocMem(sizeof(Dir),0))
   {
      strcpy(d[i]->Name,name);
      CopyMem(size,d[i]->Size,8);
      CopyMem(prot,d[i]->Protect,8);
      d[i]->Set=0;
      d[i]->Comment=0;
      return(1);
   }
   return(0);
}

Prototype int SSearch(char *name,char w)
{
   register i;
   for(i=pw[w].cnt-1;i>=0;i--)
      if(stricmp(pw[w].l[i]->Name,name)==0) break;
   return(i);
}

Prototype int BSearch(char *name,char w)
{
   int p,l,m,r;
   l=0;p=pw[w].cnt;
   m=p+l>>1;
   while(p>=l)
   {
      m=p+l>>1;
      if((r=NTPBase->SCmp[wp[w].Case](pw[w].l[m]->Name,name))==-1) l=m+1;
         else if(r==1) p=m-1;
            else return(m);
   }
   return(-1);
}

Prototype int FindNode(char *Name,char which)
{
   short a;
   if(wp[which].Sort==SNAME) a=BSearch(Name,which);
   else a=SSearch(Name,which);
   return(a);
}

Prototype FirstOcc1(char *Name)
{
   int i;
   if((i=FindNode(Name,Act))!=-1)
   {
      if(i==pw[Act].First+pw[Act].CurAct)
      {
         PCurs();
         return;
      }
      
      ReCalcFC(i);
      
/*      if(i<NTPBase->Lines)
      {
         pw[Act].First=0;
         pw[Act].CurAct=i;
      }
      else
      {
         pw[Act].First=i-NTPBase->Lines+1;
         pw[Act].CurAct=NTPBase->Lines-1;
      }*/
   } else
   {
      pw[Act].First=pw[Act].CurAct=0;
   }
  
}

Prototype FirstOcc(char *Name)
{
   FirstOcc1(Name);
   ClearWindow();
   RefreshDir(Act);
   if(pw[Act].cnt) PCurs();
   else HCurs();
}

Prototype AltFirstOcc(char *Name)
{
   int row=pw[Act].CurAct, first=pw[Act].First;
   FirstOcc1(Name);
   if(pw[Act].First!=first)
      ClearWindow();
   else if(row==pw[Act].CurAct) PCurs();
   RefreshDir(Act);
   if(pw[Act].cnt) PCurs();
   else HCurs();
}



/*
void RemNode(char *Name)
{
   int i;
   FillSpaces(Name);
   i=FindNode(Name,Act); // podmienka, je zbytocna-> remove it
   if(i!=-1)
   {
      if(pw[Act].l[i]->Comment) FreeMem(pw[Act].l[i]->Comment,80);
      FreeMem(pw[Act].l[i],sizeof(Dir));
      pw[Act].l[i]=0;
   }
   else ErrorLine("Can't find node");
}

void RenameNode(char *old,char *new)
{
   int i=FindNode(old,Act); // ----------------||--------------
   if(i!=-1) strcpy(pw[Act].l[i]->Name,new);
   else ErrorLine("Can't find node");
}
*/
Prototype void CopyPath()
{
   strcpy(spath,wp[Act].Path);
   strcpy(dpath,wp[1-Act].Path);
}

Prototype void CopyL()
{
   cnt=pw[Act].cnt;
   CopyMem(pw[Act].l,l,cnt<<2);
}

Prototype int TryAdd()
{
   struct FileLock *lock1,*lock;
   char dp[256];
   if(wp[1-Act].Type!=DIR) return(0);
   strcpy(dp,dpath);
   if(work==COPY)
      if(NWGadget18.GadgetText->FrontPen==WARN)
#ifdef GERMAN
         if(!(StringReqLen(dp,"Kopieren zu:",255))) return(0); else;
#else
         if(!(StringReqLen(dp,"Copy files to:",255))) return(0); else;
#endif
      else;
   else
   if(work==ENCRYPT)
      if(NWGadget18.GadgetText->FrontPen==WARN)
#ifdef GERMAN
         if(!(StringReqLen(dp,"Kodieren zu:",255))) return(0); else;
#else
         if(!(StringReqLen(dp,"Encrypt files to:",255))) return(0); else;
#endif
      else;
   else
      if(NWGadget8.GadgetText->FrontPen==WARN)
#ifdef GERMAN
         if(!(StringReqLen(dp,"Schieben zu:",255))) return(0);
#else
         if(!(StringReqLen(dp,"Move files to:",255))) return(0);
#endif
   if(lock=Lock(dp,ACCESS_READ))
   {
      if(strcmp(dp,dpath))
      {

         lock1=CurrentDir(lock);
         FullPath(dp);
         if(strcmp(dp,dpath))
         {
            strcpy(dpath,dp);
            ar&=~ADD;
         } else ar|=ADD;
         CurrentDir(lock1);
      } else ar|=ADD;
      UnLock(lock);
#ifdef GERMAN
   } else {ErrorLine("ffnen Verzeichnis nicht mglich!");return(0);}
#else
   } else {ErrorLine("Can't get into that directory!!");return(0);}
#endif
   return(1);
}

Prototype void NumToS(int Size,char *SSize)
{
   char j=7;
   do
   {
      SSize[j--]=(Size % 10) + '0';
   }
   while(Size /= 10);
   for(;j>=0;) SSize[j--]=' ';
}

Prototype char *PathToName(path)
char *path;
{
   char *last=path;
   for(;*path;path++) if(*path==':' || *path=='/') last=path+1;
   return(last);
}
/*
Prototype SendFile(char *sou)
{
   int size;
   struct FileHandle *i,*o;
   struct FileLock *lock;
   if(!(lock=Lock(sou,ACCESS_READ))) return(0);
   Examine(lock,lfib);
   size=lfib->fib_Size;
   UnLock(lock);
   if(i=Open(sou,MODE_OLDFILE))
   {
      if(o=Open("SER:",MODE_NEWFILE))
      {
         int n;
         Write(o,&size,4);
         while(n=Read(i,buf,BLEN))
         {
            Write(o,buf,n);
            size-=n;
         }
         Close(o);
      } else
      {
         ErrorLine("Can't open SER:");
         Close(i);
         return(0);
      }
      Close(i);
   } else return(0);
   if(size) return(0);
   return(1);
}

Prototype GetFile()
{
   char Name[60];
   *Name=0;
   if(StringReq(Name,"Path+name:"))
   {
      struct FileHandle *i,*o;
      if(i=Open("SER:",MODE_OLDFILE))
      {
//         ErrorLine("Waiting 20 seconds for input");
//         if(WaitForChar(i,10000))
//         {
            if(o=Open(Name,MODE_NEWFILE))
            {
               int size,n;
               Read(i,&size,4);
               while(size>0)
               {
                  n=size<BLEN?size:BLEN;
                  Read(i,buf,n);
                  size-=n;
                  if(n!=Write(o,buf,n)) size=0;
               }
               Close(o);
            }
            else ErrorLine("Can not open");
//         } else ErrorLine("No input");
         Close(i);
         RFree(Act);
      } else ErrorLine("Can't open SER:");
   }
}
*/

extern struct NewWindow NW3;

Prototype Copy1(char *sou,char *dest)
{
   int size;
   struct Window *w,*OpenCopyW();
   int n,sum=0;
   short rt=1;
   char ow=0,prot;
   struct FileLock *lock=NULL, *lo;
   struct FileHandle *i,*o;
   if(lo=Lock(dest,ACCESS_READ))
   {
      if(NTPPREFS.Flags&OVWMSG)
      {
         struct FileInfoBlock *fib;
         fib=(void *)AllocMem(sizeof(struct FileInfoBlock), MEMF_PUBLIC);
         if(fib)
         {
            Examine(lo, fib);
            if(lock=Lock(sou,ACCESS_READ))
            {
               ow=1;
               Examine(lock, lfib);
               size=lfib->fib_Size;
               
               switch(OverReq(l[cl]->Name, size, &lfib->fib_Date, fib->fib_Size, &fib->fib_Date))
               {
                  case 0: ow=2; break;
                  case 2: NTPPREFS.Flags^=OVWMSG; break;
                  default: break;
               }
               UnLock(lock);
            } else ow=2;
            FreeMem(fib, sizeof(struct FileInfoBlock));
         } else ow=2;
      } else ow=1;
      UnLock(lo);
      if(ow==2) return(2);
   }
   w=OpenCopyW(sou);
   if(lock) goto __c0; 
   if(lock=Lock(sou,ACCESS_READ))
   {
      Examine(lock,lfib);
      UnLock(lock);
      size=lfib->fib_Size;
__c0: prot=lfib->fib_Protection;
      if(prot&FIBF_READ)
      {
#ifdef GERMAN
         sprintf(buf,"Datei %s ist Lesegeschtzt",sou);
#else
         sprintf(buf,"File %s is read-protected",sou);
#endif
         ErrorLine(buf);
         CloseCopyW(w);
         return(2);
      }
   }
   if(i=Open(sou,MODE_OLDFILE))
   {
      if(o=Open(dest,MODE_NEWFILE))
      {
         int er=0,xxx;
         if(sv)
         {
            char *bf;
            int as;
            if(size<=BLEN) goto __c1;
            Forbid();
            as=AvailMem(MEMF_PUBLIC|MEMF_LARGEST)-100;
            if(as>size) as=size;
            bf=(void *)AllocMem(as,MEMF_PUBLIC);
            Permit();
            if(bf)
            {
               do
               {
                  n=Read(i,bf,as);
                  xxx=Write(o,bf,n);
                  sum+=xxx;
                  if(xxx<n) er=1;
                  if(RefCW(w,size,sum)) rt=0;
               }
               while(xxx==BLEN);
               FreeMem(bf,as);
            } else goto __c1;
         }
         else
__c1:       do
            {
               n=Read(i,buf,BLEN);
               xxx=Write(o,buf,n);
               sum+=xxx;
               if(xxx<n) er=1;
               if(RefCW(w,size,sum)) rt=0;
            }
            while(xxx==BLEN);
         Close(o);
         Close(i);
         if(er)
         {
            DeleteFile(dest);
            CloseCopyW(w);
            return(0);
         }
         SetProtection(dest,prot);
         if(ar&ADD)
         {
            int fpos;
            Act=1-Act;
            if(ow)
            {
               fpos=FindNode(sou,Act);
               if(fpos==-1);
               else
               {
                  FreeNode(fpos);
                  MakeNode(pw[Act].l,fpos,sou,sum,prot,0,0,&lfib->fib_Date);
               }
            }
            else
               if(MakeNode(pw[Act].l,pw[Act].cnt,sou,sum,prot,0,1,&lfib->fib_Date))
                  pw[Act].cnt++;
            Act=1-Act;
         }
      }
      else
      {
#ifdef GERMAN
         ErrorLine("Zieldatei kann nicht ffnen");
#else
         ErrorLine("Can't Open output file");
#endif
         Close(i);
         CloseCopyW(w);
         return(0);
      }
   } else ErrorLine("Can't Open input file");  // to by sa nemalo stat
   CloseCopyW(w);
   return(rt);
}

Prototype Copy2(char *sou,char *dest)
{
   int size;
   struct Window *w,*OpenCopyW();
   int n,sum=0;
   short rt=1,di;
   char ow=0,prot;
   struct FileLock *lock=NULL, *lo;
   if(lo=Lock(dest,ACCESS_READ))
   {
      if(NTPPREFS.Flags&OVWMSG)
      {
         struct FileInfoBlock *fib;
         fib=(void *)AllocMem(sizeof(struct FileInfoBlock), MEMF_PUBLIC);
         if(fib)
         {
            Examine(lo, fib);
            if(lock=Lock(sou,ACCESS_READ))
            {
               ow=1;
               Examine(lock, lfib);
               size=lfib->fib_Size;
               
               switch(OverReq(l[cl]->Name, size, &lfib->fib_Date, fib->fib_Size, &fib->fib_Date))
               {
                  case 0: ow=2; break;
                  case 2: NTPPREFS.Flags^=OVWMSG; break;
                  default: break;
               }
               UnLock(lock);
            } else ow=2;
            FreeMem(fib, sizeof(struct FileInfoBlock));
         } else ow=2;
      } else ow=1;
      UnLock(lo);
      if(ow==2) return(2);
   }
   w=OpenCopyW(sou);
   if(lock) goto __c21; 
   if(lock=Lock(sou,ACCESS_READ))
   {
      Examine(lock,lfib);
      UnLock(lock);
__c21:prot=lfib->fib_Protection;
      sum=size=lfib->fib_Size;
      di=(lfib->fib_DirEntryType >= 0 ? 1 : 0);
      if(prot&FIBF_READ)
      {
#ifdef GERMAN
         sprintf(buf,"Datei %s ist lesegeschtzt",sou);
#else
         sprintf(buf,"File %s is read-protected",sou);
#endif
         ErrorLine(buf);
         CloseCopyW(w);
         return(2);
      }
   }
   if(ow) DeleteFile(dest);
   Rename(spath,dpath);
   if(RefCW(w,1,1)) rt=0;

   if(ar&ADD)
   {
      int fpos;
      Act=1-Act;
      if(ow)
      {
         fpos=FindNode(sou,Act);
         if(fpos==-1);
         else
         {
            FreeNode(fpos);
            MakeNode(pw[Act].l,fpos,sou,sum,prot,di,0,&lfib->fib_Date);
         }
      }
      else
         if(MakeNode(pw[Act].l,pw[Act].cnt,sou,sum,prot,di,1,&lfib->fib_Date))
            pw[Act].cnt++;
      Act=1-Act;
   }
   CloseCopyW(w);
   return(1);
}


Prototype Enc(int len,int *kp)
{
   int i;
   for(i=0;i<len;i++)
   {
      if(sep[0]=='+') buf[i]+=sep[*kp];
      else buf[i]-=sep[*kp];
      (*kp)++;
      if(!sep[*kp]) *kp=1;
   }
}

Prototype Encrypt1(char *sou,char *dest)
{
   int size;
   struct Window *w,*OpenCopyW();
   int n,sum=0,x=1;
   short rt=1;
   char ow=0,prot;
   struct FileLock *lock=NULL, *lo;
   struct FileHandle *i,*o;
   if(lo=Lock(dest,ACCESS_READ))
   {
      if(NTPPREFS.Flags&OVWMSG)
      {
         struct FileInfoBlock *fib;
         fib=(void *)AllocMem(sizeof(struct FileInfoBlock), MEMF_PUBLIC);
         if(fib)
         {
            Examine(lo, fib);
            if(lock=Lock(sou,ACCESS_READ))
            {
               ow=1;
               Examine(lock, lfib);
               size=lfib->fib_Size;
               
               switch(OverReq(l[cl]->Name, size, &lfib->fib_Date, fib->fib_Size, &fib->fib_Date))
               {
                  case 0: ow=2; break;
                  case 2: NTPPREFS.Flags^=OVWMSG; break;
                  default: break;
               }
               UnLock(lock);
            } else ow=2;
            FreeMem(fib, sizeof(struct FileInfoBlock));
         } else ow=2;
      } else ow=1;
      UnLock(lo);
      if(ow==2) return(2);
   }
   w=OpenCopyW(sou);
   if(lock) goto __e1; 
   if(lock=Lock(sou,ACCESS_READ))
   {
      Examine(lock,lfib);
      UnLock(lock);
      size=lfib->fib_Size;
__e1: prot=lfib->fib_Protection;
      if(prot&FIBF_READ)
      {
#ifdef GERMAN
         sprintf(buf,"Datei %s ist lesegeschtzt",sou);
#else
         sprintf(buf,"File %s is read-protected",sou);
#endif
         ErrorLine(buf);
         CloseCopyW(w);
         return(2);
      }
   }
   if(i=Open(sou,MODE_OLDFILE))
   {
      if(o=Open(dest,MODE_NEWFILE))
      {
         do
         {
            n=Read(i,buf,BLEN);
            Enc(n,&x);
            n=Write(o,buf,n);
            sum+=n;
            if(RefCW(w,size,sum)) rt=0;
         }
         while(n==BLEN);
         Close(o);
         Close(i);
         SetProtection(dest,prot);
         if(ar&ADD)
         {
            int fpos;
            Act=1-Act;
            if(ow)
            {
               fpos=FindNode(sou,Act);
               if(fpos==-1);
               else
               {
                  FreeNode(fpos);
                  MakeNode(pw[Act].l,fpos,sou,sum,prot,0,0,&lfib->fib_Date);
               }
            }
            else
               if(MakeNode(pw[Act].l,pw[Act].cnt,sou,sum,prot,0,1,&lfib->fib_Date))
                  pw[Act].cnt++;
            Act=1-Act;
         }
      }
      else
      {
#ifdef GERMAN
         ErrorLine("Zieldatei kann nicht ffnen");
#else
         ErrorLine("Can't Open output file");
#endif
         Close(i);
         CloseCopyW(w);
         return(0);
      }
   } else ErrorLine("Can't Open input file");  // to by sa nemalo stat
   CloseCopyW(w);
   return(rt);
}


Prototype DelProt(char *name)
{
   struct FileLock *lock;
   if(lock=Lock(name,ACCESS_READ))
   {
      Examine(lock,lfib);
      UnLock(lock);
      if(lfib->fib_Protection & FIBF_DELETE)
      {
#ifdef GERMAN
         sprintf(buf,"Datei %s ist lschengeschtzt",spath);
#else
         sprintf(buf,"File %s is delete-protected",spath);
#endif
         ErrorLine(buf);
         return(1);
      }
   }
   return(0);
}

Prototype Del1(char *sou)
{
   struct IntuiMessage *msg;
   if(msg=(struct IntuiMessage *)GetMsg(NTPBase->w->UserPort))
   {
      if(msg->Class==RAWKEY && msg->Code==0x45)
      {
         ReplyMsg(msg);
         return(0);
      }
      ReplyMsg(msg);
   }
   if(DelProt(sou)) return(2);
   if(DeleteFile(sou))
   {
      int d;
      d=fre[Act];
      RFree(Act);
      if(ar&REM)
      {
         d-=fre[Act];
         l[cl]->Set=4;
         STest=0;
         pw[Act].Sel--;
         pw[Act].SetSize+=d;
         RefreshSet(Act);
         return(2);
      } else
      {
         RefreshSet(Act);
         return(1);
      }
   }
   if(IoErr() == ERROR_DIRECTORY_NOT_EMPTY)
   {
#ifdef GERMAN
      sprintf(buf,"Verzeichnis %s kann nicht gelscht werden.",sou);
#else
      sprintf(buf,"Directory %s can not be deleted (it isn't empty)!",sou);
#endif
      return(2);
   }
   else DosError(IoErr());
   return(0);
}

Prototype Rename1(char *sou)
{
   strcpy(buf,sou);
#ifdef GERMAN
   if(!StringReqLen(sou,"Neue Name:",31))
#else
   if(!StringReqLen(sou,"New name:",31))
#endif
   {
      strcpy(sou,buf);
      return(0);
   }
   else
      if(!Rename(buf,sou))
      {
         strcpy(sou,buf);
         DosError(IoErr());
         return(0);
      }
   return(1);
}

Prototype Move1(char *sou,char *dest)
{
   char c;
   if(sv)
   {
      if(c=Copy2(sou,dest))
      {
         if(ar&REM)
         {
            l[cl]->Set=4;
            return(2);
         }
         return(c);

      }
      return(0);
   }
   if(DelProt(sou)) return(2);
   c=Copy1(sou,dest);
   if(c==1)
   {
      if(DeleteFile(sou))
         if(ar&REM)
         {
            l[cl]->Set=4;
            return(2);
         } else;
      else return(0);
   }
   return(c);
}

Prototype UBYTE MaskToI()
{
   UBYTE c=0;
   if(!strchr(patt,'D')) c|=1;
   if(!strchr(patt,'E')) c|=2;
   if(!strchr(patt,'W')) c|=4;
   if(!strchr(patt,'R')) c|=8;
   if(strchr(patt,'A')) c|=16;
   if(strchr(patt,'P')) c|=32;
   if(strchr(patt,'S')) c|=64;
   if(strchr(patt,'H')) c|=128;
   return(c);
}

Prototype Protect1(char *sou)
{
   UWORD p;
   if(*patt==0)
#ifdef GERMAN
      if(!StringReq(patt,"Geschtzt Maske")) return(2);
#else
      if(!StringReq(patt,"Protection mask:")) return(2);
#endif
      else
      {
         ToUpper(patt);
         p=MaskToI();
         patt[1]=patt[0];
         patt[0]=0;
      }
   else p=patt[2];
   if(patt[1]=='+' || patt[1]=='-')
   {
      UBYTE pr=0;
      int j;
      for(j=7; j>=4; j--) if(l[cl]->Protect[7-j]!='-') pr|=1<<j;
      for(j=3; j>=0; j--) if(l[cl]->Protect[7-j]=='-') pr|=1<<j;
      for(j=0; j<4; j++) { pr^=1<<j; p^=1<<j; }
      if(patt[1]=='+') p|=pr;
      else p=pr&~p;
      for(j=0; j<4; j++) p^=1<<j;
   }
   if(!SetProtection(sou,p))
   {
      DosError(IoErr());
      return(0);
   }
   if((ar!=4) && (NTPBase->Prot==0))
   {
      int i,j;
      i=FindNode(sou,Act);
      if(i!=-1)
      {
         for(j=7;j>=4;j--)
            if(p & (1 << j)) pw[Act].l[i]->Protect[7-j]=pro[j];
         else pw[Act].l[i]->Protect[7-j]='-';
         for(j=3;j>=0;j--)
            if(p & (1 << j)) pw[Act].l[i]->Protect[7-j]='-';
         else pw[Act].l[i]->Protect[7-j]=pro[j];
#ifdef GERMAN
      } else ErrorLine("Fehler");
#else
      } else ErrorLine("Error");
#endif
   }
   return(1);
}

Prototype ED1(char *sou,sea)
{
   if(NWGadget17.GadgetText->FrontPen==WARN)
      if(!Req(sure)) return(0);
   if(ED(sou,sea))
   {
      if(ar!=4)
      {
         int i;
         i=FindNode(sou,Act);
         if(i!=-1)
         {
            struct FileLock *lock;
            if(lock=Lock(sou,ACCESS_READ))
            {
               Examine(lock,lfib);
               FreeNode(i);
               MakeNode(pw[Act].l,i,lfib->fib_FileName,lfib->fib_Size,
                 lfib->fib_Protection,(lfib->fib_DirEntryType >= 0 ? 1 : 0),0,
                 &lfib->fib_Date);
               UnLock(lock);
            }else DosError(IoErr());
         }
      }
      return(1);
   }
   return(0);
}

Prototype CountSumm1()
{
   int *a=(int *)lse;
   if(isdigit(l[cl]->Size[SLEN-1]))
   {
      a[1]++;
      a[2]+=atoi(l[cl]->Size);
   }
   else a[0]++;
   return(1);
}

Prototype void CountSumm()
{
   int *a=(int *)lse;
   a[0]=0;  /*  directories count */
   a[1]=0;  /*  files count       */
   a[2]=0;  /*  files length      */
   ResDir(PROCESS,CountSumm1);
#ifdef GERMAN
   sprintf(buf,"%d Dateien der %d Byte im %d Verzeichnisses",a[1],a[2],a[0]);
#else
   sprintf(buf,"%d files of %d bytes in %d directories",a[1],a[2],a[0]);
#endif
   ErrorLine(buf);
}

Prototype Copy()
{
   struct FileHandle *f;
   int i,add;
/*   char pom[32];
   if(ac==0)*/
   {
      if(ResDir(COPY,Copy1))
      {
         RFree(1-Act);
         if(ar&ADD)
         {
            Act=1-Act;
            if(wp[Act].Sort != UNSORTED) quicksort(pw[Act].s,pw[Act].cnt-1);
            PrintDir();
            Act=1-Act;
         }// else RefreshSet(1-Act);
      }
   }
 /*  else
   {
      ar=0;
      ac--;
      if(f=Open(ag[ac],MODE_NEWFILE)) {add=0;Close(f);}
      else
      {
         strcpy(pom,ag[ac]);
         add=strlen(pom);
         if(pom[add-1]!=':' && pom[add-1]!='/') {pom[add++]='/';pom[add]=0;}
      }
      for(i=ac-1; i>0; i--)
         if(add)
         {
            strcat(pom,ag[i]);
            Copy1(ag[i],pom);
            pom[add]=0;
         } else Copy1(ag[i],ag[ac]);
      ac++;
   }*/
}


Prototype Encrypt()
{
   struct FileHandle *f;
   int i,add;
   char pom[60];
   *pom=0;
#ifdef GERMAN
   if(StringReq(pom,"Kode:"))
#else
   if(StringReq(pom,"Key:"))
#endif
   {
      if(*pom!='+' && *pom!='-')
      {
         *sep='+';
         strcpy(sep+1,pom);
      }
      else strcpy(sep,pom);
      if(ResDir(ENCRYPT,Encrypt1))
      {
         RFree(1-Act);
         if(ar&ADD)
         {
            Act=1-Act;
            if(wp[Act].Sort != UNSORTED) quicksort(pw[Act].s,pw[Act].cnt-1);
            PrintDir();
            Act=1-Act;
         } else RefreshSet(1-Act);
      }
   }
 /*  else
   {
      ar=0;
      ac--;
      if(f=Open(ag[ac],MODE_NEWFILE)) {add=0;Close(f);}
      else
      {
         strcpy(pom,ag[ac]);
         add=strlen(pom);
         if(pom[add-1]!=':' && pom[add-1]!='/') {pom[add++]='/';pom[add]=0;}
      }
      for(i=ac-1; i>0; i--)
         if(add)
         {
            strcat(pom,ag[i]);
            Copy1(ag[i],pom);
            pom[add]=0;
         } else Copy1(ag[i],ag[ac]);
      ac++;
   }*/
}



Prototype FMove()
{
   struct FileHandle *f;
   int i,add;
   char pom[32];
   if(ac==0)
   {
      if(ResDir(MOVE,Move1))
      {
         RFree(0);
         RFree(1);
         if(ar&ADD)
         {
            Act=1-Act;
            if(wp[Act].Sort != UNSORTED) quicksort(pw[Act].s,pw[Act].cnt-1);
            PrintDir();
            Act=1-Act;
         } else RefreshSet(1-Act);
         if(ar&REM)

         {
            RepairDir();
            PrintDir();
            PCurs();
         } else RefreshSet(Act);
      }
   }
  /* else
   {
      ar=0;
      ac--;
      if(f=Open(ag[ac],MODE_NEWFILE)) {add=0;Close(f);}
      else
      {
         strcpy(pom,ag[ac]);
         add=strlen(pom);
         if(pom[add-1]!=':' && pom[add-1]!='/') {pom[add++]='/';pom[add]=0;}
      }
      for(i=ac-1; i>0; i--)
         if(add)
         {
            strcat(pom,ag[i]);
            Move1(ag[i],pom);
            pom[add]=0;
         } else Move1(ag[i],ag[ac]);
      ac++;
   }*/
}

Prototype void FDel()
{
   int n;
   if(ac==0)
   {
      {
         int i, ind=pw[Act].First+pw[Act].CurAct;
         for(n=i=0; i<ind; i++) if(pw[Act].l[i]->Set==0) n++;
      }
      ResDir(DEL,Del1);
      RFree(Act);
      if(ar&REM)
      {
         RepairDir();
         if(n>=pw[Act].cnt) n--;
         PrintNumber(n);
         PCurs();
      } else RefreshSet(Act);
   }
   else;
}

Prototype void FRename()
{
   if(ac==0)
   {
      ResDir(RENAME,Rename1);
      if(wp[Act].Sort!=UNSORTED) quicksort(pw[Act].s,pw[Act].cnt-1);
      PCurs();
      RefreshDir(Act);
      PCurs();
   }
   else;
}

Prototype void Protect()
{
   int i,n=0;
   for(i=pw[Act].cnt-1;i>=0;i--)
      if(pw[Act].l[i]->Set)
      {
         n++;
         if(!isdigit(pw[Act].l[i]->Size[7]))
            n++;
         if(n>1) break;
      }
   *patt=0;
   if(n>1)
#ifdef GERMAN
      if(!StringReq(patt,"Zusammene Maske")) *patt=0;
#else
      if(!StringReq(patt,"Common mask:")) *patt=0;
#endif
      else
      {
         ToUpper(patt);
         patt[2]=MaskToI();
         patt[1]=patt[0];
         patt[0]=1;
      }
   ResDir(PROCESS,Protect1);
}

Prototype ResGetDir(char d)
{
   char ars=ar,rr;
   Dir **ls;
   short i;
   int scnt=cnt;
   if(ls=(Dir **)AllocMem(cnt<<2,0))
   {
      CopyMem(l,ls,cnt<<2);
      ar=4;
      cnt=0;
      GetDir(spath,l,&cnt,0);
      if(cnt>1 && wp[Act].Sort!=UNSORTED) ResQuickSort(0,cnt-1);
      for(i=0;i<cnt;i++) l[i]->Set=1;
      rr=res(d+1);
      ar=ars;
      FreeDir(l,&cnt);
      cnt=scnt;
      CopyMem(ls,l,cnt<<2);
      FreeMem(ls,cnt<<2);
   }
   return(rr);
}

Prototype SameVolume(i,j)
struct FileLock *i,*j;
{
   i=(struct FileLock *)BADDR(i);
   j=(struct FileLock *)BADDR(j);
   return(i->fl_Volume==j->fl_Volume);
}

Prototype res(char d)
{
   int i,x,y,fr;
   struct FileLock *lock,*ol;
   lock=Lock(spath,ACCESS_READ);
   ol=CurrentDir(lock);
   x=strlen(spath);
   y=strlen(dpath);
   if(spath[x-1]!=':' && spath[x-1]!='/') {spath[x++]='/';spath[x]=0;}
   if(dpath[y-1]!=':' && dpath[y-1]!='/') {dpath[y++]='/';dpath[y]=0;}
   for(i=0;i<cnt;i++)
      if(l[i]->Set==SET)
      {
         cl=i;
         if(x+strlen(l[i]->Name)>254 ||
            y+strlen(l[i]->Name)>254) break;
         strcat(dpath,l[i]->Name);
         strcat(spath,l[i]->Name);
         if(work!=BUILDAG && work!=CREATET) ErrorLine(spath);
         if(isdigit(l[i]->Size[7]))   // 7 nie je konst !!! (pozor na to)
         {
            if(!(fr=fptr(l[i]->Name,dpath)))
            {
               CurrentDir(ol);
               UnLock(lock);
               if(STest==0) SetCount();
               return(0);
            }
            if(fr==1) l[i]->Set=0;
         }
         else
         {
            fr=3;
            switch(work)
            {
               case COPY   :
               case ENCRYPT:{
                              struct FileLock *nd,*CreateDir();
                              char ii=0;
                              if(!(nd=Lock(dpath,ACCESS_READ)))
                                 if(!(nd=CreateDir(dpath)))
                                 {
                                    DosError(IoErr());
                                    fr=0;
                                    break;
                                 } else
                                 {
                                    fr=1;
                                    ii=1;
                                 }
                              else fr=1;
                              Examine(nd,lfib);
                              if(lfib->fib_DirEntryType>0)
                                 if(ar&ADD && ii)
                                    if(MakeNode(pw[1-Act].l,pw[1-Act].cnt,
                                    l[i]->Name,0,lfib->fib_Protection,1,1,&lfib->fib_Date))
                                       pw[1-Act].cnt++;
                                    else;
                                 else;
                              else
                              {
                                 UnLock(nd);
                                 fr=0;
                                 break;
                              }
                              UnLock(nd);
                              if(!ResGetDir(d))
                              {
                                 CurrentDir(ol);
                                 UnLock(lock);
                                 return(0);
                              }
                            }
                             break;
               case MOVE   :if(sv)
                            {
                              fr=fptr(l[i]->Name,dpath);
                              break;
                            } else
                            {
                              struct FileLock *nd,*CreateDir();
                              char ii=0;
                              if(!(nd=Lock(dpath)))
                                 if(!(nd=CreateDir(dpath)))
                                 {
#ifdef GERMAN
                                    ErrorLine("Verzeichnis nicht mglich ffnen.");
#else
                                    ErrorLine("Can't create dir");
#endif
                                    fr=0;
                                    break;
                                 } else fr=ii=1;
                              else fr=1;
                              Examine(nd,lfib);
                              if(lfib->fib_DirEntryType>0)
                                 if(ar&ADD && ii)
                                    if(MakeNode(pw[1-Act].l,pw[1-Act].cnt,
                                    l[i]->Name,0,lfib->fib_Protection,1,1,&lfib->fib_Date))
                                       pw[1-Act].cnt++;
                                    else;
                                 else;
                              else
                              {
                                 UnLock(nd);
                                 fr=0;
                                 break;
                              }
                              UnLock(nd);
                            }

               case DEL    : if(!ResGetDir(d))
                             {
                                CurrentDir(ol);
                                UnLock(lock);
                                return(0);
                             }
                             cl=i;
                             fr=Del1(l[i]->Name);
                             break;
               case RENAME :  fr=Rename1(l[i]->Name);
                              break;
               case CREATET: fr=fptr(l[i]->Name,(char *)d);
                             if(!ResGetDir(d))
                             {
                                CurrentDir(ol);
                                UnLock(lock);
                                return(0);
                             }
                             break;
               case FINDF  : fr=fptr(l[i]->Name,spath);ResGetDir(d);break;
               
               case NOREC_PR: fr=fptr(l[i]->Name, dpath); break;
               
               case PROCESS: fr=fptr(l[i]->Name,dpath);
               case OTHER  :
               case SEARCH :
               case BUILDAG: if(!ResGetDir(d))
                             {
                                CurrentDir(ol);
                                UnLock(lock);
                                return(0);
                             }
                             if(fr==3) fr=1;
                             break;
            }
            if(fr==1) l[i]->Set=0;
         }
         spath[x]=0;dpath[y]=0;
      }
   CurrentDir(ol);
   UnLock(lock);  // lock mozem zrusit --> UnLock(CurrentDir(ol));
   if(!STest) SetCount();
   return(1);
}

Prototype void ReReadCheck()
{
   if(ReRead&1<<Act)
   {
      Process(Act);
      RCurs(Act);
      ReRead&=~(1<<Act);
   }
   if(ReRead&1<<(1-Act))
   {
      Process(1-Act);
      ReRead=0;
   }
}

Prototype ResDir(char w,fp)
void (*fp)(char *,char *);
{
   int scnt,i;
   fptr=fp;work=w;
   cnt=0;ar=0;
   CopyPath();
/*   if(work==BUILDAG)
   {
      GetDir(spath,l,&cnt,0);
      for(i=0;i<cnt;i++) if(Match(l[i]->Name,patt)) l[i]->Set=SET;
      ar=4;
   } else*/
   if(work==CREATET)
   {
      GetDir(spath,l,&cnt,&i);
      for(i=0;i<cnt;i++) l[i]->Set=SET;
      ar=4;
   } else CopyL();
   if(work<3) if(!TryAdd()) return(0);
   if(work==DEL || work==MOVE) ar|=REM;
   else ar&=~REM;
   if(work==MOVE || work==COPY)
   {
      struct FileLock *i,*j;
      i=Lock(spath,ACCESS_READ);
      j=Lock(dpath,ACCESS_READ);
      sv=SameVolume(i,j);
      UnLock(i); UnLock(j);
   }
   scnt=cnt;
   res(1);
   if(work==MOVE || work==COPY || work==ENCRYPT)
      RefOverWrite();
   if(ar==4) FreeDir(l,&scnt);
   if(w==OTHER || w==PROCESS || w=NOREC_PR)
      ReReadCheck();
   return(1);
}

/*
void Build1(arg,dumm)
char *arg,*dumm;
{
   char a;
   if(ag[ac]=(char *)AllocMem(a=strlen(arg)+1,0))
   {
      CopyMem(arg,ag[ac],a);
      ac++;
   }
   else ErrorLine(memory);
}

ProcLine(char *s)
{
   char *e=s,a;
   ac=0; // daj to do napmain.c
   do
   {
      char h=0;
      while(*e && *e != '_')   // nahrad medzerou
      {
         if(*e=='*') h=1;
         e++;
      }
      a=*e;
      *e=0;
      printf("..%s , %d , %d\n",s,a,e-s);
      if(h==0)
         if(ag[ac]=(char *)AllocMem(e-s+1,0))
         {
            strcpy(ag[ac],s); //CopyMem(s,ag[ac],e-s+1);
            ac++;
         }
         else
         {
            a=0;
            ErrorLine(memory);
         }
      else
      {
         char *b=e;
         while(*b!='*') b--;
         while(b>s && *b != '/' && *b != ':') b--;
         if(b>s)
         {
            *b=0;
            CopyMem(s,spath,b-s+1);
            b++;
         } else spath[0]=0;
         CopyMem(b,patt,e-b+1);
         ResDir(BUILDAG,Build1);
      }
      s=++e;
   } while(a);

   {
      int i;
      for(i=0;i<ac;i++) printf(",,%s\n",ag[ac]);
   }

   {
      int i;
      for(i=0;i<ac;i++) FreeMem(ag[ac],strlen(ag[ac]));
   }
   ac=0;
}

*/
