// #define TEST

#ifndef TEST
#include <ntp.h>
#include <libraries/dos.h>
#endif

#include <intuition/intuitionbase.h>

#ifdef TEST
UBYTE *key=0xbfec01;
UBYTE *cia=0xbfe001;
#endif

#define BPL 16
#define py 14
#define pyt(n) (20+((n)<<3))
#define px  4

extern struct Window *OpenWindow();
extern struct IntuitionBase *IntuitionBase;

static struct Window *w;
static struct RastPort *rp;
static char lpw;
static char *first,*end,*start;
static char hex[16]="0123456789ABCDEF";


static void DumpLine(adr,len)
long len;
unsigned char *adr;
{
   char pom[9],*sadr=adr,t[100],*p=t;
   register a;
   sprintf(p,"%06x: ",adr-start);
   p+=8;
   for(a=0;a<len;a++,adr++)
   {
      *p++=*(hex+(*adr>>4));
      *p++=*(hex+(*adr&0xf));
      *p++=' ';
   }
   Text(rp,t,p-t);
   rp->cp_x=492;
   p=t;
   adr=sadr;
   for(a=0;a<len;a++,adr++)
      if((*adr & 0x7f) < 32) *p++='.';
      else *p++=*adr;
   Text(rp,t,p-t);
}

static void PrintLine(int i)
{
   char *ptr=first+i*BPL;
   int len=end-ptr;
   if(len>0)
   {
      Move(rp,px,pyt(i));
      DumpLine(ptr,len<BPL?len:BPL);
   }
}

static void PrintDump()
{
   int i;
   SetAPen(rp,DARK);
   RectFill(rp,px,w->Height-19,w->Width-8,w->Height-11);
   SetAPen(rp,LIGHT);
   SetBPen(rp,DARK);
   for(i=0;i<lpw;i++)
      PrintLine(i);
}

static void Down()
{
   if(first+BPL*lpw < end)
   {
      first+=BPL;
      ScrollRaster(rp,0,8,px,py,w->Width-8,w->Height-11);
      PrintLine(lpw-1);
   }
}

static void Up()
{
   if(first>start)
   {
      first-=BPL;
      ScrollRaster(rp,0,-8,px,py,w->Width-(px<<1),w->Height-11);
      PrintLine(0);
   }
}

static End()
{
   int ofs;
   first=end-lpw*BPL;
   ofs=((int)first%BPL-(int)start%BPL);
   if(ofs<0) ofs+=BPL;
   first+=BPL-ofs;
   if(first>start) PrintDump();
   else first=start;
}

Prototype Dump(char *title,char *adr,int len)
{
   void WRectangle(),WTitle();
   struct NewWindow NW =
   {
      0,0,0,0,-1,-1,
      RAWKEY|MOUSEBUTTONS,
      ACTIVATE|BORDERLESS|RMBTRAP,
      0,0,0,
#ifdef TEST
      0,
#else
      NTPBase->Screen,
#endif

      0,20,20,0,0,

#ifdef TEST
      WBENCHSCREEN
#else
      CUSTOMSCREEN
#endif
   };
   struct IntuiMessage *msg,*GetMsg();
   char go=1;
   NW.Width=IntuitionBase->ActiveScreen->Width;
   NW.Height=IntuitionBase->ActiveScreen->Height;
   if(!(w=OpenWindow(&NW))) return(0);
   SetRast(rp=w->RPort,DARK);
   SetAPen(rp,KMZ);
   SetBPen(rp,KMZ);
   SetFont(rp,pbx);
   RectFill(rp,0,0,NW.Width-1,10);
   SetAPen(rp,YELLOW);
   Move(rp,5,8);
   Text(rp,title,strlen(title));
   SetBPen(rp,GRAY);
   SetAPen(rp,WHITE);
   lpw=(w->Height-32>>3)+1;
   start=first=adr;
   end=adr+len;
   PrintDump();
   while(go==1)
   {
      Wait(1<<w->UserPort->mp_SigBit);
      while(msg=GetMsg(w->UserPort))
      {
         switch(msg->Class)
         {
            case RAWKEY :
               switch(msg->Code)
               {
                  case 0x45:
                     go=2;
                     break;
                  case 0x59:
                     go=0;
                     break;
                  case 0x4d:
                  case 0x1e:
                     if(msg->Qualifier&(IEQUALIFIER_LSHIFT|IEQUALIFIER_RSHIFT)) goto _pgdn;
                     if(*key==0x65 || *key==0xc3) Down();
                     break;
                  case 0x4c:
                  case 0x3e:
                     if(msg->Qualifier&(IEQUALIFIER_LSHIFT|IEQUALIFIER_RSHIFT)) goto _pgup;
                     if(*key==0x67 || *key==0x83) Up();
                     break;
                  case 0x1f:
_pgdn:               if(first+BPL*lpw*2<end)
                     {
                        first+=BPL*lpw;
                        PrintDump();
                     }
                     else End();
                     break;
                  case 0x35:
                  case 0x1d:
                     End();
                     break;
                  case 0x3f:
_pgup:               if(first!=start)
                     {
                        first-=BPL*lpw;
                        if(first < start)
                        {
                           first=start;
                        }
                        PrintDump();
                     }
                     break;
                  case 0x3d:
                  case 0x14:
                     if(first!=start)
                     {
                        first=start;
                        PrintDump();
                     }
                     break;
               }
               break;
            case MOUSEBUTTONS:
               if(msg->Code == 104)
               {
                  if(msg->MouseY < 15)
                  {
                     go=0;
                     break;
                  }
                  else
                  if(msg->MouseY < 50)
                     while((!(*cia & 0x40)) && w->MouseY < 50) Up();
                  else
                  if(msg->MouseY > 200)
                     while((!(*cia & 0x40)) && w->MouseY > 200) Down();
               }
               break;
         }
         ReplyMsg(msg);
      }
   }
   CloseWindow(w);
   if(go) return(0);
   return(1);
}

#ifndef TEST

extern struct FileInfoBlock *lfib;
extern char spath[50],buf[BLEN];

Prototype Dump1(char *sou)
{
   char *ptr,ret;
   int len,n;
   struct FileHandle *f,*Open();
   struct FileLock *lock,*Lock();
   if(!(lock=Lock(sou,ACCESS_READ)))
   {
      DosError(IoErr());
      return(2);
   }
   Examine(lock,lfib);
   len=lfib->fib_Size;
   UnLock(lock);
   if(ptr=(char *)AllocMem(len,0))
   {
      if(f=Open(sou,MODE_OLDFILE))
      {
         n=Read(f,ptr,len);
         if(n)
         {
#ifdef GERMAN
            sprintf(buf,"Hex-dump der Datei %s       Klicken hier zum Ausgang",sou);
#else
            sprintf(buf,"Hex-dump of file %s       Click here to Exit",sou);
#endif
            ret=Dump(buf,ptr,len);
         }
         else
         {
            DosError(IoErr());
            ret=2;
         }
         Close(f);
      }
      else
      {
         DosError(IoErr());
         ret=2;
      }
      FreeMem(ptr,len);
   }
   else
   {
      ErrorLine(memory);
      ret=2;
   }
   return(ret);
}
#endif

#ifdef TEST

#define White 2
#define Black 3
#define Pen 1
#define Back 0

void WRectangle(struct Window *w)
{
   SetAPen(w->RPort,White);
   Move(w->RPort,0,w->Height-1);
   Draw(w->RPort,0,0);
   Draw(w->RPort,w->Width-1,0);
   Move(w->RPort,1,w->Height-2);
   Draw(w->RPort,1,1);
   Draw(w->RPort,w->Width-2,1);
   SetAPen(w->RPort,Black);
   Move(w->RPort,1,w->Height-1);
   Draw(w->RPort,w->Width-1,w->Height-1);
   Draw(w->RPort,w->Width-1,1);
   Move(w->RPort,2,w->Height-2);
   Draw(w->RPort,w->Width-2,w->Height-2);
   Draw(w->RPort,w->Width-2,2);
}

void WTitle(struct Window *w,char *str)
{
   SetAPen(w->RPort,White);
   Move(w->RPort,2,12);
   Draw(w->RPort,2,2);
   Draw(w->RPort,w->Width-3,2);
   SetAPen(w->RPort,Black);
   Move(w->RPort,3,12);
   Draw(w->RPort,w->Width-3,12);
   Draw(w->RPort,w->Width-3,2);
   SetAPen(w->RPort,Pen);
   Move(w->RPort,5,10);
   Text(w->RPort,str,strlen(str));
}


main()
{
   Dump("anca",(char *)100,2000);
}
#endif
