#ifndef NTP_H
#define NTP_H
/*
**  $filename : NTP.H  $
**  $Release 2         $
**
**  main NTP include
**
**  (C) Copyright 1992 Patrick Sucansky
**      All Rights Reserved
**
*/

/* useful for struct PWindow */
//#define DEMO20 1000

#include "language.h"

#define Local static
#define Prototype
#define SLOVAKIA

#define LIGHT  3
#define DARK   1
#define YELLOW 5
#define KMZ    6
#define WHITE  4
#define BLACK  0
#define GRAY   7
#define DGRAY  2

#define NOW    DARK
#define WARN   WHITE

#define White WHITE
#define Black LIGHT
#define Pen   YELLOW
#define Back  DARK


#define xx 4
#define MOUSE 0
#define KEY   1

#define HISL 10
#define NUMD 26
#define NLEN 23
#define SLEN 8
#define BLEN 4096
#define MAXDIR 1000
#define lstart 4
#define rstart 324
#define width 311
#define mal 79
#define MAXAG 50
#define CWBORDER 5

/* StringReq history */
#define SR_PATTERN 1  /* Pattern (+, -, find, filter) */
#define SR_STRING  2  /* Edit/find, Dmup/find, find   */
#define SR_EXPR    3  /* Ed/Goto_line Dump/Goto Calc BlockNr TabLen NChan */
#define SR_OTHER   0  /* All other */
#define SR_TYPES   4  /* totat # of types */
/*  Where */
#define LEFT         0

#define RIGHT        1

#define ENCRYPT  0
#define COPY     1
#define MOVE     2
#define DEL      3
#define RENAME   4
#define SEND     5
#define SEARCH   6
#define BUILDAG  7
#define OTHER    8
#define FINDF    9
#define CREATET  10 /* create tree structure, fn ak dostane ako druhy parameter
                      nulu, tak vtedy si dany dir zapameta. Inak to neni dir */
#define CREATT   11
#define PROTECT  12
#define PROCESS  13
#define NOREC_PR 14
#define FORMAT   15
#define DISKCOPY 16

/* Win Prefs -> Type */
#define NO           0  /* There is nothing in window */
#define DIR          1  /* Dir type files are in window */
#define TREE         2  /* Tree type directorys are in window*/
#define QVIEW        3  /* Quick Info about file */
#define INFO         4  /* Info : availmem,disk .. */
#define DEVS         6  /* Devs are in window*/
#define ASSIGN       5  /* Assigns are in window*/
#define LIST         7  /* Any exec list is viewed */

/* WinPrefs->Sort - only number of sort (for saving prefs) */
#define SNAME        0  /* Sort Name */
#define SSIZE        1  /* Sort Size */
#define SEPAR        2  /* Separeted directories and files */
#define UNSORTED     3

#define UCASE        1  /* All Files,Dirs are in Upper Case (good for *
                         * sort)                                      */
#define NCASE        0

/*   Prefs -> Run   */

#define ARGSAFTER    0  /* send arguments after selected file(s) */
#define ARGSBEFORE   1  /* execute arguments and selected files like args*/
#define ARGSSEPAR    2  /* send selected files separated */
#define NEWPROC      4  /* execute file like a new proces */
#define OUTPUTW      8  /* create outbut window */
#define INPUTW      16  /* create input window  */
#define RESIDENT    32  /* make file resident */
#define CLOSEBYRUN  64  /* close NTP screen while file is runing */

/*   Prefs -> Flags  */

#define MBLANK       1
#define COLOR        2
#define INGADGETS    4  /* gadgets invisable */
#define INTERLACE    8  /* using interlace screen */
#define REQON       64  /* system requeser on */
#define OVWMSG     128  /* warning by moving files */
#define STRICTNC   256  /* strict NC */
#define WBLIKE     512  /* like workbench */
#define NOTIFYWB  1024  /* notify workbench */

/*    Prefs -> Auto   */


#define VCHECK       1  /* Virus check if disk inserted */
#define AUTODIR      2  /* auto get dir if disk inserted */
#define AUTOFREE     4  /* auto free dir if disk removed */
#define AUTOVIEWBB   8  /* view boot block when disk inserted */
#define AUTOMNU     16  /* view menu if disk inserted (needn't get dir */


/* WinPrefs -> List */
#define RESLIST      1  /* dos-resident */
#define RESMODLIST   2  /* exec resident */
#define TASK         3  /* task (READY|WAITING) list */
#define INTLIST      4  /* Exec Interruppt list */
#define PORTLIST     5  /* Exec message ports */
#define MEMLIST      6
#define RESOURCELIST 7
#define SEMAPHORELIST 8
#define DEVICELIST    9

/*  NTP->Prot */

#define PROTECT 0
#define DATE 1
#define TIME 2

typedef struct Dir
{
   char Name[32];
   char Size[SLEN];
   char Protect[8];
   char Set;
   char *Comment;
} Dir;

typedef struct WinPrefs
{
   char Type;
   char Sort;
   char Case;
   char Enable[32];
   char Disable[32];
   char Path[256];
   char List;
   char pad;
} WinPrefs;

typedef struct NTPPrefs
{
   unsigned short Color[4];
   char Run;         /*  described above */
   short Flags;       /*  described above */
   char Auto;        /*  described above */
   char FontName[32];  /* zero if default */
   char RenamePatB;  /* if rename has a pattern this is its start letter */
   char ExtEd[32];   /* Name of extern editor,zero if builtin */
   char ExtPlay[32];  /* Name of extern MOD - player */
   char ExtIFF[34];   /* Name of extern IFF viewer */
   char NChan;
   char TabLen;
} NTPPrefs;

typedef struct CGadget
{
   char GadgetID;
   char Name[12];
} CGadget;

typedef struct CMenu
{
   char MenuItem;
   char Run;
   char Name[8];
   char File[32];
   char Args[22];
} CMenu;

typedef struct PWindow
{
   Dir *l[MAXDIR];
   int  cnt;
   int  First;
   int CurAct;
   char s;
   int SetSize;
   short Sel;
} PWindow;


typedef char (*SPtr)(char *,char *);
typedef char (*CPtr)(Dir *, Dir *);

typedef struct NTPBase
{
   long Future;
   struct Screen *Screen;
   struct Window *w;
   NTPPrefs *Prefs;
   CGadget *CGad[3];
   CMenu   **CMnu;
   int Lines;
   char SPat[16],UPat[16];
   SPtr SCmp[2];
   CPtr Cmp[4];
   int ac;
   char **ag;
   char ss[40]; /* searched string or file name */
   char Prot;
} NTBase;

#ifndef NOGLOBALS

#ifdef DEMO20
extern char *DemoText;
#endif
#ifdef GERMAN
extern char sure[17],memory[23],tdname[17];
#else
extern char sure[14],memory[19],tdname[17];
#endif
extern double x;
extern char CalcEn;
extern long pom;
extern short p[300],pc,npc;
extern char pro[8];
extern struct MEDPlayerBase *MEDPlayerBase;
extern struct OctaPlayerBase *OctaPlayerBase;
extern struct Library *WorkbenchBase, *IconBase;
extern int fre[2];
extern int ty,cx;
extern char STest;
extern char line[mal];
extern struct RastPort *rp;
extern char *rmb;
extern char nc;
extern char drives[NUMD+1][7];
extern char HelpPossible;
extern struct FileHandle *io;
extern char lp[60],lp1[60];
extern unsigned char *key;
extern struct Library *ConsoleDevice;
extern char spaces[216];
extern char msn,nlo,ins;
extern char buf[BLEN];
extern char *cia,Act;
extern struct NTPBase NTPBASE,*NTPBase;
extern struct NTPPrefs NTPPREFS;
extern WinPrefs wp[2];
extern PWindow pw[2];
extern int ac;
// extern char *ag[MAXAG];
extern struct FileInfoBlock *lfib;
extern unsigned char *sw;
extern char spath[256],dpath[256],patt[32];
extern char ar;
extern Dir *l[MAXDIR];
extern int cnt;
extern char men;
extern char lse[256],sep[256];
extern char *his[10],ah,ht;
extern omp[80];
extern char inl[30][6];
#ifdef SLOVAKIA
extern int pbx,DiskfontBase;
#endif

typedef unsigned char *STRPTR;

typedef STRPTR *APTR;

extern APTR swinptr;
extern char LIn,SE;
extern BotBor;
extern char wait;
extern cl;
extern struct LayerBase *LayersBase;
extern char ReRead;
extern char work;
extern unsigned long SystemVer;
extern char cla;
extern char breakstr[];
extern unsigned long mode_id;
   #define NOFONTS 1
   #define NOHELP 2
   #define FIRST 4
#endif

#endif
