#include <ntp.h>
#include <intuition/intuition.h>

#include <exec/memory.h>
#include <exec/io.h>
#include <hardware/custom.h>
#include <hardware/dmabits.h>
#include <libraries/dosextens.h>
#include <devices/audio.h>

extern struct NewWindow NW3;
extern struct Gadget Gadget32;

static UWORD tony[]={  856,808,762,720,678,640,604,570,
                538,508,480,453,428,404,381,360,
                339,320,302,285,269,254,240,226,
                214,202,190,180,170,160,151,143,
                135,127,120,113,000 };

extern struct MsgPort *CreatePort();

Prototype PlaySample1(char *sou)
{
   struct IOAudio sound[4];
   UBYTE chan,*data1,status=0,klav[21],ch;
   UWORD ton[256];
   struct IntuiMessage *msg,*GetMsg();
   struct Window *w,*OpenWindow();
   int b,ach=0,len;
   char go=1,ret=1;
   struct FileHandle *file,*Open();
   struct FileLock *lock,*Lock();
   ch=NTPBase->Prefs->NChan;
   for(b=0;b<256;b++)
           ton[b]=0;
   strcpy(klav,"ysxdcvgbhnjm,l.-");
   for(b=0;klav[b] != 0;b++)
           ton[klav[b]]=tony[b];
   strcpy(klav,"q2w3er5t6z7ui9o0p");
   for(b=0;klav[b] != 0;b++)
          ton[klav[b]]=tony[b+12];
   if(!(lock=Lock(sou,ACCESS_READ)))
   {
      DosError(IoErr());
      return(2);
   }
   Examine(lock,lfib);
   len=lfib->fib_Size;
   UnLock(lock);
   if(!(file=Open(sou,MODE_OLDFILE)))
   {
      DosError(IoErr());
      return(2);
   }
        if(!(data1=(UBYTE *)AllocMem(len,MEMF_CHIP)))
   {
      ErrorLine(memory);
      Close(file);
      return(2);
   }
   if(Read(file,data1,len)!=len)
   {
      DosError(IoErr());
      Close(file);
      ret=2;
      goto err;
   }
   Close(file);
   for(b=0;b<ch;b++)
      sound[b].ioa_Request.io_Message.mn_ReplyPort = NULL;
   for(b=0;b<ch;b++)
   {
      if(!(sound[b].ioa_Request.io_Message.mn_ReplyPort=CreatePort("Music port",0)))
        {
         ErrorLine("No free port");
         ret=0;
         goto err;
      }
      chan=1<<b;
      sound[b].ioa_Request.io_Message.mn_Node.ln_Pri = 10;
      sound[b].ioa_Data = &chan;
      sound[b].ioa_Length = 1;
      if((OpenDevice(AUDIONAME,0,&sound[b],0))!=NULL)
        {
         ret=0;
         goto err;
      }
      status++;
      sound[b].ioa_Request.io_Command = CMD_WRITE;
      sound[b].ioa_Request.io_Flags = ADIOF_PERVOL|IOF_QUICK;
      sound[b].ioa_Cycles = 1;
      sound[b].ioa_Length = len;
      sound[b].ioa_Period = 64;
      sound[b].ioa_Volume = 64;
      sound[b].ioa_Data = data1;
   }
   NW3.Height=32;
   NW3.FirstGadget=&Gadget32;
   NW3.Screen=NTPBase->Screen;
   NW3.IDCMPFlags|=VANILLAKEY;
   CenterWindow(&NW3);
   if(w=OpenWindow(&NW3))
   {
      SetRast(w->RPort,GRAY);
      RefreshGList(w->FirstGadget,w,0,-1);
      WRectangle(w);
      WTitle(w,sou);
      while(go)
      {
              Wait(1<<w->UserPort->mp_SigBit);
              while(msg=GetMsg(w->UserPort))
              {
            switch(msg->Class)
                 {
                         case GADGETUP    :
                           ret=((struct Gadget *)msg->IAddress)->GadgetID;
                           go=0;
                           break;
                         case VANILLAKEY  :
                                               if(ton[msg->Code] != 0)
                                               {
                                                       AbortIO(sound+ach);
                                                    (sound+ach)->ioa_Period = ton[msg->Code];
                                                       BeginIO(sound+ach);
                                                       ach = (ach+1)%ch;
                                               } else if(msg->Code==13)
                           {
                              ret=1;
                              go=0;
                           }
                           else if(msg->Code==27) ret=go=0;

                                                    break;
                 }
            ReplyMsg(msg);
         }
      }
      CloseWindow(w);
   } else
   {
      ErrorLine(memory);
      ret=2;
   }
err:
   NW3.IDCMPFlags=GADGETUP;
   FreeMem(data1,len);
   for(b=0;b<ch;b++)
   {
           if (sound[b].ioa_Request.io_Message.mn_ReplyPort)
                   DeletePort(sound[b].ioa_Request.io_Message.mn_ReplyPort);
           if (status) {CloseDevice(sound+b);status--;}
   }

   return(ret);
}
