#include <NTP.h>
#include <time.h>
#include <exec/types.h>
#include <exec/memory.h>
#include <exec/devices.h>
#include <exec/io.h>
#include <exec/libraries.h>
#include <devices/trackdisk.h>
#include <libraries/dosextens.h>
#include <libraries/filehandler.h>
#include <intuition/intuition.h>

// #define DEMO20

extern struct DosLibrary *DOSBase;
extern struct NewWindow NW3;

#ifdef DEMO20
long xxx;
#endif



typedef struct FileInfoBlock FIB;
extern struct Library *SysBase;
extern struct FileLock *Lock();
extern int *AllocMem();
static ULONG *bitmap;


static unsigned long boot[13] = {
 0x444f5300, 0xc0200f19, 0x00000370, 0x43fa0018, 0x4eaeffa0, 0x4a80670a,
 0x20402068, 0x00167000, 0x4e7570ff, 0x60fa646f, 0x732e6c69, 0x62726172,
 0x79000000  };

static long bam[56] = {
 0xc000c037, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffff3fff, 0xffffffff,
 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
 0xffffffff, 0x3fffffff };

Prototype void tried(int l,int r)
{
   int d,i,j;
   d=(p[l]+p[r])/2;
   i=l;j=r;
   while(i<j)
   {
     while(p[i] < d) i++;
     while(p[j] > d) j--;
     if(i<=j)

          {
      pom=p[i];p[i]=p[j];p[j]=pom;
      i++;j--;
          }
   }
   if( l<j ) tried(l,j);
   if( i<r ) tried(i,r);
}

Prototype void CloseDev(struct IOExtTD *request)
{
   DeletePort(request->iotd_Req.io_Message.mn_ReplyPort);
   CloseDevice(request);
   DeleteExtIO(request,sizeof(struct IOExtTD));
}

Prototype struct IOExtTD *OpenDev(char *name,int num,int flags)
{
   int i;
   struct MsgPort *CreatePort(),*port;
   struct IOExtTD *request,*CreateExtIO();
   port = CreatePort(0,0);
   if (port == 0) {return(0);}
   if(!(request = CreateExtIO(port,sizeof(struct IOExtTD))))
   {
      DeletePort(port);
      return(0);
   }
   if(OpenDevice(name,num,request,flags))

   {
      strcpy(buf,name);
#ifdef GERMAN
      strcat(buf," erforderlich");
#else
      strcat(buf," required");
#endif
      ErrorLine(buf);
      DeletePort(port);
      DeleteExtIO(request,sizeof(struct IOExtTD));
      return(0);
   }
  return(request);
}

Prototype void MotorOn(struct IOExtTD *request)
{
  request->iotd_Req.io_Length = 1;
  request->iotd_Req.io_Command = TD_MOTOR;
  DoIO(request);
  request->iotd_Req.io_Command=TD_PROTSTATUS;
  DoIO(request);
}

Prototype void MotorOff(struct IOExtTD *request)
{
  request->iotd_Req.io_Length = 0;
  request->iotd_Req.io_Command = TD_MOTOR;
  DoIO(request);
}

Prototype void Counter(struct IOExtTD *request)
{
  request->iotd_Req.io_Command = TD_CHANGENUM;
  DoIO(request);
  request->iotd_Count = request->iotd_Req.io_Actual;
}

Prototype void DRead(struct IOExtTD *request,UBYTE *str,int pos,int len)
{
  request->iotd_Req.io_Length = len;
  request->iotd_Req.io_Data =(APTR) str;
  request->iotd_Req.io_Offset = pos*512;

  request->iotd_Req.io_Command = CMD_READ;
  DoIO(request);
}


Prototype void RRead(struct IOExtTD *request,UBYTE *str,int pos,int len)
{
  request->iotd_Req.io_Length = len;
  request->iotd_Req.io_Data =(APTR) str;
  request->iotd_Req.io_Offset = pos;

  request->iotd_Req.io_Command = CMD_READ;
  DoIO(request);
}


Prototype void DFormat(struct IOExtTD *request,UBYTE *str,int pos,int len)
{
  request->iotd_Req.io_Length = len;
  request->iotd_Req.io_Data =(APTR) str;
  request->iotd_Req.io_Offset = pos;

  request->iotd_Req.io_Command = TD_FORMAT;
  DoIO(request);
}

Prototype void DWrite(struct IOExtTD *request,UBYTE *str,int pos,int len)
{
  request->iotd_Req.io_Length = len;
  request->iotd_Req.io_Data =(APTR) str;
  request->iotd_Req.io_Offset = pos*512;

  request->iotd_Req.io_Command = CMD_WRITE;
  DoIO(request);
  request->iotd_Req.io_Command = CMD_UPDATE;
  DoIO(request);
}

Prototype void FreeDir(Dir **l,int *cnt)
{
   int i;
#ifdef DEB
   printf("Free dir : %d nodes\n",*cnt);
#endif
   for(i=0;i<*cnt;i++)
   {
      if(l[i]->Comment) FreeMem(l[i]->Comment,80);
      FreeMem(l[i],sizeof(Dir));
      l[i]=0;
   }
   *cnt=0;
}

Prototype MakeNode(Dir **l,int cnt,char *Name,int Size,char Prot,char di,int *si,long *v)
{
   char j;
   time_t t;
   struct tm *tm;


#ifdef DEMO20
   if(!kontrola(0,Size)) return(0);
#endif

   if(si && di==0)
      if(Match(Name,wp[Act].Enable))
         if(Match(Name,wp[Act].Disable)==1) return(0); else;
      else return(0);
   if(!(l[cnt]=(Dir *)AllocMem(sizeof(Dir),MEMF_CLEAR)))
   {
      puts("MakeNode;AllocMem()");
      return(0);
   }
   CopyMem(Name,l[cnt]->Name,32);
   if(di==1) CopyMem("<SUBDIR>",l[cnt]->Size,SLEN);
   else
   {
      j=SLEN-1;
      do
      {
         l[cnt]->Size[j--]=(Size % 10) + '0';
      }
      while(Size /= 10);
      for(;j>=0;) l[cnt]->Size[j--]=' ';
   }
   switch(NTPBase->Prot)
   {
      case 1:
         {
            char temp[9];
            t = v[0] * (1440 * 60) + v[1] * 60 + v[2] / 50;
            tm=localtime(&t);
            strftime(temp,8,"%d.%m.%y",tm);
            CopyMem(temp,l[cnt]->Protect,8);
            break;
         }
      case 2:
         {
            char temp[9];
            t = v[0] * (1440 * 60) + v[1] * 60 + v[2] / 50;
            tm=localtime(&t);
            strftime(temp,8,"%H:%M:%S",tm);
            CopyMem(temp,l[cnt]->Protect,8);
            break;
         }
      default:  // + case 0:
            for(j=7;j>=4;j--)
               if(Prot & (1 << j)) l[cnt]->Protect[7-j]=pro[j];
               else l[cnt]->Protect[7-j]='-';
            for(j=3;j>=0;j--)
               if(Prot & (1 << j)) l[cnt]->Protect[7-j]='-';
               else l[cnt]->Protect[7-j]=pro[j];
   }
   return(1);
}

Prototype GetDir(char *Name,Dir **l,int *count,int *Size)
{
   struct FileLock *lock,*l1,*ParentDir();
   char *c;
   short d=0,i,j;
   long *b,cnt=0,size,sd;
#ifdef DEB
#ifdef GERMAN
   puts("Lese Verzeichnes");
#else
   puts("Getting Dir");
#endif
#endif

#ifdef DEMO20
   xxx=2000;
   xxx=xxx*5+10000;
   xxx-=6000;
   xxx-=4000;
   xxx/=5;
   xxx*=5;
#endif

   if(!(lock=Lock(Name,ACCESS_READ)))
   {
      DosError(IoErr());
      return(0);
   }
   FreeDir(l,count);
   *count=0;
   if(Size) pw[Act].s=0;
   if(Examine(lock,lfib))
      if(lfib->fib_DirEntryType>0)
      {
         if(Size)
         {
            if(NTPPREFS.Flags&STRICTNC)
               pw[Act].s=cnt=AddNode(l,0,"."," <ROOT> ","        ");
            else
               pw[Act].s=cnt=AddNode(l,0,"."," DEVICES","LIST    ");
            if(l1=ParentDir(lock))
            {
               UnLock(l1);
               cnt+=AddNode(l,cnt,"..","<UP-DIR>","        ");
               pw[Act].s=cnt;
            }
#ifdef DEMO20
            ErrorLine(DemoText);
#endif
         }
         if(lfib->fib_DiskKey < 1760)
         {
            struct IOExtTD *req;
            int num;
            int co;
            sd=d=lfib->fib_DiskKey;
            Info(lock,lfib);
            num=((struct InfoData *)lfib)->id_UnitNumber;
            co=((struct InfoData *)lfib)->id_NumBlocks;
            if(Size)
            {
               *Size=(co-((struct InfoData *)lfib)->id_NumBlocksUsed)
                        *((struct InfoData *)lfib)->id_BytesPerBlock;
               if(wp[1-Act].Type==INFO) NTPInfo(lfib,1-Act);
            }
            if(FindResident("ramdrive.device"))
            {
               char aaa=0;
               if(SysBase->lib_Version>=36)
                  if(FindTask("RAD")) aaa=1; else;
               else aaa=1;
               if(aaa)
               {
                  l1=Lock("rad:",ACCESS_READ);
                  if(((struct FileLock *)BADDR(l1))->fl_Volume==
                     ((struct FileLock *)BADDR(lock))->fl_Volume)
                     req=OpenDev("ramdrive.device",num,0);
                  else req=OpenDev(tdname,num,0);
                  if(l1) UnLock(l1);
               }
               else
                  if(!strcmp("File System",
                     ((struct Task *)((struct DeviceList *)BADDR(((struct FileLock *)
                     BADDR(lock))->fl_Volume))->dl_Task->mp_SigTask)->\
                     tc_Node.ln_Name))
                     req=OpenDev(tdname,num,0);
                  else goto lab1;
            }
            else  if(!strcmp("File System",
                     ((struct Task *)((struct DeviceList *)BADDR(((struct FileLock *)
                     BADDR(lock))->fl_Volume))->dl_Task->mp_SigTask)->
                     tc_Node.ln_Name))
                     req=OpenDev(tdname,num,0);
                  else goto lab1;
 /*           if(co == 1758) req=OpenDev("trackdisk.device",num,0);
               else req=OpenDev("ramdrive.device",num,0);*/
            if(req==0)
            {
               UnLock(lock);
               return(0);
            }
            if(!(b=AllocMem(1024,MEMF_CHIP)))
            {
               ErrorLine(memory);
               UnLock(lock);
               CloseDev(req);
               return(0);
            }
            Counter(req);
            MotorOn(req);
         //   printf("met1\n");
            do
            {
               DRead(req,b,d,512);
               if(b[127]==2||b[127]==1)
               {
                  for(i=6;i<78;i++)
                     if(b[i]) p[pc++]=(short)b[i];
                  d=b[124];
               } else d=0;
            } while(d);
            do {
               tried(0,pc-1);
               npc=0;
               for(i=0;i<pc;i++)

               {
                     DRead(req,b+128,p[i],512);
                     if( b[124+128] )
                     {
                        size=b[124+128];
                        if(size > p[i])
                        {
                           j=pc;
                           pc++;
                           while(size < p[j-1])
                           {
                              p[j]=p[j-1];
                              j--;
                           }
                           p[j]=size;
                        }
                            else p[npc++]=size;
                     }
                     c=((char *)(b+128+108));
                     c[c[0]+1]=0;
                     if(sd==b[253])
                        if(MakeNode(l,cnt,c+1,b[209],b[208],(b[255] == 2 ? 1 : 0),Size,b+105+128))
                           cnt++;
               }
               pc=npc;
            }
            while(npc);
            MotorOff(req);
            CloseDev(req);
            FreeMem(b,1024);
         }
         else
         {
            if(Size)
            {
               int co;
               Info(lock,lfib);
               co=((struct InfoData *)lfib)->id_NumBlocks;
               *Size=(co-((struct InfoData *)lfib)->id_NumBlocksUsed)
                     *((struct InfoData *)lfib)->id_BytesPerBlock;
               if(wp[1-Act].Type==INFO) NTPInfo(lfib,1-Act);
            }
lab1:
            Examine(lock,lfib);
            while(ExNext(lock,lfib))
            {
               if(MakeNode(l,cnt,lfib->fib_FileName,lfib->fib_Size,
                  lfib->fib_Protection,(lfib->fib_DirEntryType >= 0 ? 1 : 0),Size,(long *)&lfib->fib_Date))
                  cnt++;
            }
         }
      }
   UnLock(lock);
   if(Size) FlushIDCMP();
   *count=cnt;
#ifdef DEB
   printf("GetDir ready : %d nodes\n",cnt);
#endif
   return(1);
}


Prototype struct DeviceNode *NextDevice(struct DeviceNode *d)
{
   struct DosInfo *i;
   if(!d)
   {
      i=(struct DosInfo *)BADDR(((struct RootNode *)DOSBase->dl_Root)->rn_Info);
      d=(struct DeviceNode *)BADDR(i->di_DevInfo);
   }
   for(d=(void *)BADDR(d->dn_Next);d;d=(struct DeviceNode *)BADDR(d->dn_Next))
       if(d->dn_Type==DLT_DEVICE && d->dn_Startup>10) return(d);
   return(NextDevice(0));
}


Prototype void inhibit(int t,char *name)
{
   struct MsgPort *handler,*dosport;
   struct StandardPacket *packet;

   if(packet=AllocMem(sizeof(struct StandardPacket),MEMF_CLEAR|MEMF_PUBLIC))
   {
      if(handler = (struct MsgPort *)DeviceProc(name))
      if(dosport=(void *)CreatePort(0,0))
      {

         packet->sp_Msg.mn_Node.ln_Name = (char *)&(packet->sp_Pkt);
         packet->sp_Pkt.dp_Link = &(packet->sp_Msg);
         packet->sp_Pkt.dp_Port = dosport;
         packet->sp_Pkt.dp_Type = ACTION_INHIBIT;
         packet->sp_Pkt.dp_Arg1 = t;
         PutMsg(handler, packet);
         WaitPort(dosport);
         GetMsg(dosport);
         DeletePort(dosport);
      }
      FreeMem(packet,sizeof(struct StandardPacket));
   }
}


Prototype void DumpTrack(BPTR num,int pos)
{
   char *name;
   struct IOExtTD *req;
   struct DeviceNode *d;
   struct FileSysStartupMsg *msg;
   struct DosEnvec *env;
   d=(void *)num;
   msg=(void *)BADDR(d->dn_Startup);
   env=(void *)BADDR(msg->fssm_Environ);
   if(req=OpenDev(\
     &((char *)BADDR(msg->fssm_Device))[1],msg->fssm_Unit,msg->fssm_Flags))
   {
      char *ptr;
      int size=env->de_SizeBlock*4;
      Counter(req);
      MotorOn(req);
      if(ptr=AllocMem(size,env->de_BufMemType))
      {
         name=(char *)BtoCStr(d->dn_Name);
         RRead(req,ptr,pos*size,size);
#ifdef GERMAN
         sprintf(buf,"Block %d des %s            Klick hier zum Ausgang",pos,name);
#else
         sprintf(buf,"Block %d of %s            Click here to exit",pos,name);
#endif
         Dump(buf,ptr,size);
         FreeMem(ptr,size);
      } else ErrorLine(memory);
      MotorOff(req);
      CloseDev(req);
   }
}

Prototype WPCheck(struct IOExtTD *req)
{
   req->iotd_Req.io_Command=TD_PROTSTATUS;
   DoIO(req);
   while(req->iotd_Req.io_Actual)
#ifdef GERMAN
      if(Req("Disk schreibgeschtzt!"))
#else
      if(Req("Unprotect disk!"))
#endif
      {
         req->iotd_Req.io_Command=TD_PROTSTATUS;
         DoIO(req);
      } else return(0);
   return(1);
}

Prototype void Initialize1(struct IOExtTD *req)
{
   char *ptr;
   int len=11*512;
   if(ptr=AllocMem(len,MEMF_CHIP|MEMF_CLEAR))
   {
#ifdef GERMAN
      ErrorLine("Schreiben Boot");
#else
      ErrorLine("Writing boot");
#endif
      CopyMem(boot,ptr,13<<2);
      DFormat(req,ptr,0,len);

      FreeMem(ptr,len);
   } else ErrorLine(memory);
#ifdef GERMAN
   ErrorLine("Bereit");
#else
   ErrorLine("Ready");
#endif
}


Prototype void Initialize2(struct IOExtTD *req,ULONG type)
{
   char *ptr;
   int len=11*512,i;
   ULONG a0,a1,cs=0,ps;
   a0=boot[0]; a1=boot[1];
   boot[0]=type;
   boot[1]=0;
   for(i=0; i<13; i++)
   {
      ps=cs;
      if((cs+=(boot[i]))<ps) ++cs;
   }
   boot[1]=~cs;

   if(ptr=AllocMem(len,MEMF_CHIP|MEMF_CLEAR))
   {
#ifdef GERMAN
      ErrorLine("Schreiben Boot");
#else
      ErrorLine("Writing boot");
#endif
      CopyMem(boot,ptr,13<<2);
      DFormat(req,ptr,0,len);

      FreeMem(ptr,len);
      boot[0]=a0; boot[1]=a1;
   } else ErrorLine(memory);
#ifdef GERMAN
   ErrorLine("Bereit");
#else
   ErrorLine("Ready");
#endif
}

Prototype void set_bitmap(int block)
{
   int  lindex;

   if ((block - 2) > -1)
   {
      lindex = 1 + (block - 2) / 32;
      bitmap[lindex] = bitmap[lindex] | (1 << ((block-2) % 32));
   }
}



Prototype ULONG check_sum(long *pbitmap)
{/*
   long *pbitmap0=pbitmap+1;
   int i;

 //  *pbitmap=0;
   for(i=1; i < 128; ++i)
      *pbitmap -= *pbitmap0++;*/
      
   
   int j;
   ULONG cksum;

   cksum=0;
   for(j=0; j < 128; ++j)
      cksum += bitmap[j];
   
   return(-cksum);
}


Prototype void QFormat1(struct IOExtTD *req,char *name)
{
   long *ptr,len=512*11;
   if(ptr=AllocMem(len,MEMF_CHIP|MEMF_CLEAR))
   {
      struct DateStamp d;
      DateStamp(&d);
#ifdef GERMAN
      ErrorLine("Schreiben ROOT");
#else
      ErrorLine("Making ROOT");
#endif
      ptr[0]=2;
      ptr[3]=72;
      ptr[78]=-1;
      ptr[79]=881;
      ptr[105]=ptr[121]=d.ds_Days;
      ptr[106]=ptr[122]=d.ds_Minute;
      ptr[107]=ptr[123]=d.ds_Tick;
      ptr[127]=1;
      CopyMem(name,ptr+108,*name+1);
      {
         register sucet=0;
         register short i;
         for(i=0;i<128;i++) sucet-=ptr[i];
         ptr[5]=sucet;
      }
      if(bitmap)
      {
         bitmap[0]=0;
         bitmap[0]=check_sum(bitmap);
         CopyMem(bitmap,ptr+128,512);
      }
      else CopyMem(bam,ptr+128,56<<2);
      DFormat(req,ptr,80*len,len);
      FreeMem(ptr,len);
      Initialize1(req);
   } else ErrorLine(memory);
}

Prototype Format(int num)
{
   struct Window *w, *OpenCopyW();
   struct IOExtTD *req;
   char name1[5], *tmp=buf+20;
   short bad=0;
   
   dpath[1]=0; dpath[0]=' ';
   work=FORMAT;
   sprintf(name1,"DF%d:",num);
   inhibit(DOSTRUE,name1);
   if(StringReqLen(dpath+1,"Name:",31, SR_OTHER))
   {
      if(dpath[1]==0)
         strcpy(dpath+1,"Empty");
      if(req=OpenDev(tdname,num,0))
      {
         char *ptr;
         int len=512,hc=100,ok=1;
         D(struct DosEnvec *de);
         struct DeviceNode *l=0;
         
         while(strcmp(BtoCStr((l=NextDevice(l))->dn_Name),name1))
            if(!(hc--)) break;

         if(!hc) return(0);
         D(de=(struct DosEnvec *)BADDR(((struct FileSysStartupMsg *)\
             BADDR(l->dn_Startup))->fssm_Environ));
         D(printf("de_TableSize = %d\n", de->de_TableSize));
         D(printf("de_SizeBlock = %d\n", de->de_SizeBlock));
         D(printf("de_SecOrg = %d\n", de->de_SecOrg));
         D(printf("de_Surfaces = %d\n", de->de_Surfaces));
         D(printf("de_SectorPerBlock = %d\n", de->de_SectorPerBlock));
         D(printf("de_BlocksPerTrack = %d\n", de->de_BlocksPerTrack));
         D(printf("de_PreAlloc = %d\n", de->de_PreAlloc));
         D(printf("de_Interleave = %d\n", de->de_Interleave));
         D(printf("de_LowCyl = %d\n", de->de_LowCyl));
         D(printf("de_HighCyl = %d\n", de->de_HighCyl));
         D(printf("de_NumBuffers = %d\n", de->de_NumBuffers));
         D(printf("de_MaxTransfer = %d\n", de->de_MaxTransfer));
         D(printf("de_Mask = $%x\n", de->de_Mask));
         D(printf("de_BootPri = %d\n", de->de_BootPri));
         D(printf("de_DosType = %x\n", de->de_DosType));
         D(printf("de_Baud = %d\n", de->de_Baud));
         D(printf("de_Control = %d\n", de->de_Control));
         D(printf("de_BootBlocks = %d\n", de->de_BootBlocks));
         
         if(bitmap=AllocMem(512,MEMF_CLEAR))
         {
            if(ptr=AllocMem(2*len,MEMF_CHIP|MEMF_CLEAR))
            {
               int i,j,s=0;
               Counter(req);
               if(WPCheck(req))
               {
                  w=OpenCopyW(name1);
                  MotorOn(req);
                  hc=1760;
                  for(i=0;i<hc;i++)
                  {
                     DFormat(req,ptr,i*len,len);
                     req->iotd_Req.io_Length = len;
                     req->iotd_Req.io_Data = (APTR)(ptr+len);
                     req->iotd_Req.io_Command = CMD_READ;
                     req->iotd_Req.io_Offset = i * len;
                     DoIO(req);
                     if ((req->iotd_Req.io_Error) || (req->iotd_Req.io_Actual != len) /*|| memcmp(ptr,ptr+len,len)*/)
                     {
                        if(!bad) strcpy(tmp, E("Bad blocks: "));
                        bad++;
                        sprintf(buf, "%d ", i);
                        strcat(tmp, buf);
                        ErrorLine(tmp);
#ifdef DEBUG
                        if(req->iotd_Req.io_Error) printf("%d - err\n",i);
                        else if(req->iotd_Req.io_Actual!=len)
                           printf("%d - actual\n",i);
                        else printf("%d memcmp\n",i);
#endif
                     } else if(i!=880 && i!=881) set_bitmap(i);
                     if((i&7)==0)
                        if(RefCW(w, hc, i))  
                        {
                           ok=0;
                           goto failed; 
                        }
                  }
failed:           CloseCopyW(w);
                  FreeMem(ptr,2*len);
                  dpath[0]=strlen(dpath+1);
                  if(ok) QFormat1(req,dpath);
                  MotorOff(req);
               } else FreeMem(ptr,512);
            } else ErrorLine(memory);
         FreeMem(bitmap,512); bitmap=0;
         } else ErrorLine(memory);
         CloseDev(req);
      }
   }
   inhibit(DOSFALSE,name1);
   sprintf(buf, E("Done. %d block(s) bad."), bad);
   ErrorLine(buf);
}

Prototype DiskCopy(int d1,int d2)
{
   struct Window *w;
   char *ptr,drv[5], tmp[5];
   int len=22*512;
   
   work=DISKCOPY;
   sprintf(drv,"DF%d:",d2);
   inhibit(DOSTRUE,drv);
   if(ptr=AllocMem(len,MEMF_CHIP))
   {
      struct IOExtTD *rw;
      if(rw=OpenDev(tdname,d2,0))
      {
         sprintf(tmp, "DF%d:", d1);
         sprintf(dpath, " DF%d:",d2);
         w=(void *)OpenCopyW(tmp);
         NW3.Flags|=ACTIVATE;
         Counter(rw);
         MotorOn(rw);
         if(d1!=d2)
         {
            struct IOExtTD *rr;
            if(WPCheck(rw))
               if(rr=OpenDev(tdname,d1,0))
               {
                  int i;
                  Counter(rr);
                  MotorOn(rr);
                  for(i=0;i<80;i++)
                  {
                        sprintf(buf,"Track %d",i);
                        ErrorLine(buf);
                        DRead(rr,ptr,22*i,len);
                        DFormat(rw,ptr,512*22*i,len);
                        if(RefCW(w, 79, i))
                        {
                           i=80; break;
                        }
                  }
                  MotorOff(rr);
                  CloseDev(rr);
               }
            MotorOff(rw);
         } else
         {
            long list[80],i,f,mm,na;
            char a=1;
            for(i=0;i<80;i++)
               if(!(list[i]=AllocMem(len,0))) break;
            mm=na=i;
            f=0;
            if(na==0) f=80;
            while(f<80)
            {
               for(i=0;i<mm;i++)
               {
#ifdef GERMAN
                  sprintf(buf,"Lesen %d",i+f);
#else
                  sprintf(buf,"Reading %d",i+f);
#endif
                  ErrorLine(buf);
                  DRead(rw,ptr,(i+f)*22,len);
                  CopyMem(ptr,list[i],len);
                  if(RefCW(w, 79, i+f))
                  {
                     i=f=80;
                     break;
                  }
               }
               MotorOff(rw);
               if(f==80) break;
#ifdef GERMAN
               if(Req("Einlegen Zieldisk"))
#else
               if(Req("Insert target"))
#endif
               {
                  Counter(rw);
                  if(WPCheck(rw))
                  {
                     if(w) SetAPen(w->RPort, YELLOW);
                     MotorOn(rw);
                     for(i=0;i<mm;i++)
                     {
#ifdef GERMAN
                        sprintf(buf,"Schreiben %d",i+f);
#else
                        sprintf(buf,"Writing %d",i+f);
#endif
                        ErrorLine(buf);
                        CopyMem(list[i],ptr,len);
                        DFormat(rw,ptr,(i+f)*22*512,len);
                        if(RefCW(w, 79, i+f))
                        {
                           i=f=80; break;
                        }
                     }
                     MotorOff(rw);
                     if(w) SetAPen(w->RPort, LIGHT);
                     f+=mm;
                     if(f+mm>80) mm=80-f;
                     if(f<80)
#ifdef GERMAN
                        if(!Req("Einlegen Quelldisk")) f=80;
#else
                        if(!Req("Insert source")) f=80;
#endif
                        else
                        {
                           Counter(rw);
                           MotorOn(rw);
                        }
                  } else f=80;
               } else f=80;
            }
            for(i=0;i<na;i++) FreeMem(list[i],len);
            if(!na) MotorOff(rw);
         }
         CloseDev(rw);
         CloseCopyW(w);
      }
      FreeMem(ptr,len);
   } else ErrorLine(memory);
   inhibit(DOSFALSE,drv);
#ifdef GERMAN
   ErrorLine("Bereit.");
#else
   ErrorLine("Ready.");
#endif
}

Prototype void FastFormat(int num)
{
   struct IOExtTD *req;
   char name[31],drv[5];
   sprintf(drv,"DF%d:",num);
   inhibit(DOSTRUE,drv);
   name[1]=0;
   bitmap=0;
   if(StringReqLen(name+1,"Name:",31, SR_OTHER))
   {   if(name[1]==0)
         strcpy(name+1,"Empty");
       if(req=OpenDev(tdname,num,0))
       {
          Counter(req);
          if(WPCheck(req))
          {
             MotorOn(req);
             name[0]=strlen(name+1);
             QFormat1(req,name);
             MotorOff(req);
             CloseDev(req);
          }
       }
   }
   inhibit(DOSFALSE,drv);
}

Prototype void Install(int num)
{
   struct IOExtTD *req;
   struct FileLock *l;
   struct InfoData id;
   char str[6];
   sprintf(str,"DF%d:",num);
   l=Lock(str,ACCESS_READ);
   Info(l,&id);
   if(req=OpenDev(tdname,num,0))
   {
      Counter(req);
      if(WPCheck(req))
      {
         MotorOn(req);
         Initialize2(req,id.id_DiskType);
         MotorOff(req);
         CloseDev(req);
      }
   }
   UnLock(l);
}

#ifdef TEST
main(ac,ag)
char ac,*ag[];
{
   Dir *l[100];
   unsigned int cnt=0,size;
   if(ac > 1) if(GetDir(ag[1],l,&cnt,&size))
      printf("Free = %d\n",size);
   FreeDir(l,&cnt);
}
#endif

#ifdef DEMO20

Prototype kontrola(int k,int Size)
{
   if(Size>xxx)
   {
      if(k>=5) return(0);
      return(kontrola(k+1,Size-xxx));
   }
   return(1);
}

#endif
