/*
  Name: Locale.c
  Author: Peter Hutchison
  Project: Printer
*/

#define CATCOMP_ARRAY
#include "global.h"


struct Catalog  *catalog;
struct List country_list, language_list, pref_language_list;


/*********************************************************************************************/

void InitLocale(STRPTR catname, ULONG version)
{
    #ifdef __SASC
    LocaleBase = (struct Library *)OpenLibrary("locale.library", 39);
    #else
    LocaleBase = (struct LocaleBase *)OpenLibrary("locale.library", 39);
    #endif

    if (LocaleBase)
    {
    catalog = OpenCatalog(NULL, catname, OC_Version, version,
                         TAG_DONE);
    }
}

/*********************************************************************************************/

void CleanupLocale(void)
{
    if (catalog) CloseCatalog(catalog);
    if (LocaleBase) CloseLibrary((struct Library *)LocaleBase);
}

/*********************************************************************************************/

char* MSG(ULONG id)
{
    char msg[30];

    if (catalog != NULL)
    {
        strcpy(msg,  GetCatalogStr(catalog, id, CatCompArray[id].cca_Str));
        if (strlen(msg)>0)
           return msg;
        else
           return (char *)CatCompArray[id].cca_Str;
    }
    else
    {
        return (char *)CatCompArray[id].cca_Str;
    }
}

