/*
Name:    Global.h
Project: Printer Prefs
Author:  Peter Hutchison

*/

#ifndef GLOBAL_H
#define GLOBAL_H

#define VERSTRING "$VER: Printer 1.1 (29.02.2008)"

/******************************* Includes *****************************************************/

/* Created by Catcomp?! */
#include "strings.h"

/* Include obsolete macros */
#ifndef MUI_OBSOLETE
#define MUI_OBSOLETE
#endif

#ifndef LIBRARIES_MUI_H
#include <libraries/mui.h>
#endif

#ifndef DOS_DOS_H
#include <dos/dos.h>
#endif

#ifndef EXEC_TYPES_H
#include <exec/types.h>
#endif

#ifndef EXEC_MEMORY_H
#include <exec/memory.h>
#endif

#ifndef INTUITION_INTUITION_H
#include <intuition/intuition.h>
#endif

#ifndef INTUITION_SCREENS_H
#include <intuition/screens.h>
#endif

#ifndef LIBRARIES_GADTOOLS_H
#include <libraries/gadtools.h>
#endif

#ifndef LIBRARIES_ASL_H
#include <libraries/asl.h>
#endif

#ifndef LIBRARIES_IFFPARSE_H
#include <libraries/iffparse.h>
#endif

#ifndef UTILITY_UTILITY_H
#include <utility/utility.h>
#endif

#ifndef UTILITY_TAGITEM_H
#include <utility/tagitem.h>
#endif

#ifndef LIBRARIES_LOCALE_H
#include <libraries/locale.h>
#endif

#ifndef CYBERGRAPHX_CYBERGRAPHICS_H
#include <cybergraphx/cybergraphics.h>
#endif

#ifndef DATATYPES_DATATYPES_H
#include <datatypes/datatypes.h>
#endif

#ifndef DATATYPES_DATATYPESCLASS_H
#include <datatypes/datatypesclass.h>
#endif

#ifndef PREFS_SERIAL_H
#include <prefs/serial.h>
#endif

#ifndef PREFS_PREFHDR_H
#include <prefs/prefhdr.h>
#endif

/******************************** Protos ***************************************************/

#ifndef PROTO_EXEC_H
#include <proto/exec.h>
#endif

#ifndef PROTO_DOS_H
#include <proto/dos.h>
#endif

#ifndef PROTO_INTUITION_H
#include <proto/intuition.h>
#endif

#ifndef PROTO_GRAPHICS_H
#include <proto/graphics.h>
#endif

#ifndef PROTO_UTILITY_H
#include <proto/utility.h>
#endif

#ifndef PROTO_LOCALE_H
#include <proto/locale.h>
#endif

#ifndef PROTO_ALIB_H
#include <clib/alib_protos.h>
#endif

#ifndef PROTO_GADTOOLS_H
#include <proto/gadtools.h>
#endif

#ifndef PROTO_ASL_H
#include <proto/asl.h>
#endif

#ifndef PROTO_IFFPARSE_H
#include <proto/iffparse.h>
#endif

#ifndef PROTO_CYBERGRAPHICS_H
#include <proto/cybergraphics.h>
#endif

#ifndef PROTO_MUIMASTER_H
#include <proto/muimaster.h>
#endif

/* ANSI C */
#include <stdlib.h>
#include <string.h>
#include <stdio.h>


/*********************************************************************************************/


#undef CATCOMP_STRINGS
#undef CATCOMP_NUMBERS

#define CATCOMP_NUMBERS

/*********************************************************************************************/

#define CONFIGNAME_ENV	    	"ENV:Sys/printerps.prefs"
#define CONFIGNAME_ENVARC   	"ENVARC:Sys/printerps.prefs"

#define PAGECMD_PREFS_CHANGED 1
#define PAGECMD_PREFS_CHANGING 2

#define getstring(obj, str)  get(obj, MUIA_String_Contents, str)
#define getcycle(obj, n)     get(obj, MUIA_Cycle_Active, n)
#define getcheckmark(obj, n) get(obj, MUIA_Selected, n)
#define getslider(obj, n)    get(obj, MUIA_Numeric_Value, n)

/*********************************************************************************************/

/* misc.c */

struct Node *FindListNode(struct List *list, WORD which);
void SortInNode(struct List *list, struct Node *node);
void GUI_to_Prefs(void);
void Prefs_to_GUI(void);

STRPTR GetFile(char *title, char *dir, BOOL savemode);
void InitMenus(void);

/* locale.c */

void InitLocale(STRPTR catname, ULONG version);
void CleanupLocale(void);
char *MSG(ULONG id);
VOID LocalizeLabels(const char** labels);

/* prefs.c */

void InitPrefs(STRPTR filename, BOOL use, BOOL save);
void Cleanup(char *msg);
void CleanupPrefs(void);
BOOL LoadPrefs(STRPTR filename);
BOOL SavePrefs(STRPTR filename);
BOOL DefaultPrefs(void);
void RestorePrefs(void);
void Last_Saved(void);


/*********************************************************************************************/
/*********************************************************************************************/

#endif /* GLOBAL_H */
