/* Printer Preferences
   Author: Peter Hutchison
   Date: 06/12/07
   System: AROS
   
   Copyright 2007 Peter Hutchison
   GNU Public License
*/

#define CATCOMP_NUMBERS

#include "global.h"
#include "printer.h"
#include <prefs/printerps.h>
 
/* Menu items */

enum { MEN_TITLE=1, MEN_OPEN, MEN_SAVEAS, MEN_QUIT, MEN_EDIT, MEN_DEFAULTS, MEN_LAST, MEN_RESTORE, MEN_SETTINGS, 
    MEN_ICONS, ID_TEST, ID_REVERT, ID_SAVE, ID_USE, ID_CANCEL, ID_CUSTOM, ID_PRTNAME };

/* Switched from a NewMenu structure to a MUI based menu instead */

struct Library *MUIMasterBase;

/* Pointers for values we want to read or set.
   CY = Cycle, ST=String, LB = Label, NM = number 
   LV = Listview CM=CheckMark  SL=Slider BT=Button
   MN = Menu
*/

APTR app, CY_DriverMode, SL_Copies, CY_PaperFormat, ST_PaperWidth, ST_PaperHeight, ST_HorizDPI, ST_VertDPI,
 CY_Font, CY_Pitch, CY_Orient, CY_TextTab, NM_Left, NM_Right, NM_Top, NM_Bottom, NM_Point, NM_Leading, NM_LinesInch,
 NM_LinesPage, NM_LeftEdge, NM_TopEdge, NM_Width, NM_Height, CY_Image, CY_Shade, CY_Dither, CY_Aspect, CY_Scaling,
 CY_Centering, BT_Test, BT_Revert, BT_Save, BT_Use, BT_Cancel, MN_Open, MN_SaveAs, MN_Quit, MN_Defaults, 
 MN_Last, MN_Restore, MN_Icons;
 
/* Values for Labels, Tabs and Cycle gagdets. */


static STRPTR Tabs[5], DriverMode[3], PaperFormat[5], TextFont[9], TextPitch[4], TextOrient[3], TextTab[6], 
 Dithering[5], PrintImage[3], Shade[4], Aspect[3], Scaling[8],  Centering[5];


int main(int argc,char *argv[])
{
	APTR window, strip;
        BOOL running = TRUE, Icons = FALSE;
        ULONG signal, id;
        STRPTR filename;
        LONG paperfmt;
        UBYTE buf[10];
        int linespage;
        
        double fmtWidths[] = {8.5, 8.5, 8.26, 8.5 },
               fmtHeights[] = {11.0, 14.0, 11.69, 11.0 };
             
        /* Initialise Localisation */
        InitLocale("printerps.catalog", 1);

        /* Localize the labels.
           LocalizeLabels() didn't work so used the long method */
           
        Tabs[0] = MSG(MSG_TAB_TEXT);
        Tabs[1] = MSG(MSG_TAB_DIMENSIONS); 
        Tabs[2] = MSG(MSG_TAB_GRAPHICS);  
        Tabs[3] = MSG(MSG_TAB_SCALING);
        Tabs[4] = NULL;
        DriverMode[0] = MSG(MSG_MODE_POSTSCRIPT);
        DriverMode[1] = MSG(MSG_MODE_PASSTHRU);
        DriverMode[2] = NULL;
        PaperFormat[0] = MSG(MSG_FMT_LETTER);
        PaperFormat[1] = MSG(MSG_FMT_LEGAL);
        PaperFormat[2] = MSG(MSG_FMT_DINA4);
        PaperFormat[3] = MSG(MSG_FMT_CUSTOM);
        PaperFormat[4] = NULL;
        TextFont[0] = MSG(MSG_FONT_COURIER);
        TextFont[1] = MSG(MSG_FONT_TIMES_ROMAN);
        TextFont[2] = MSG(MSG_FONT_HELVETICA);
        TextFont[3] = MSG(MSG_FONT_HELV_NARROW);
        TextFont[4] = MSG(MSG_FONT_AVANT_GARDE);
        TextFont[5] = MSG(MSG_FONT_BOOKMAN);
        TextFont[6] = MSG(MSG_FONT_PALATINO);
        TextFont[7] = MSG(MSG_FONT_ZAPF_CHANCERY);
        TextFont[8] = NULL;
        TextPitch[0] = MSG(MSG_PITCH_NORMAL);
        TextPitch[1] = MSG(MSG_PITCH_COMPRESSED);
        TextPitch[2] = MSG(MSG_PITCH_EXPANDED);
        TextPitch[3] = NULL;
        TextOrient[0] = MSG(MSG_ORIENT_PORTRAIT);
        TextOrient[1] = MSG(MSG_ORIENT_LANDSCAPE);
        TextOrient[2] = NULL;
        TextTab[0] = MSG(MSG_TAB_4CHARS);
        TextTab[1] = MSG(MSG_TAB_8CHARS);
        TextTab[2] = MSG(MSG_TAB_QTR_INCH);
        TextTab[3] = MSG(MSG_TAB_HALF_INCH);
        TextTab[4] = MSG(MSG_TAB_ONE_INCH);
        TextTab[5] = NULL;
        PrintImage[0] = MSG(MSG_IMAGE_POSITIVE);
        PrintImage[1] = MSG(MSG_IMAGE_NEGATIVE);
        PrintImage[2] = NULL;
        Shade[0] = MSG(MSG_SHADE_BW);
        Shade[1] = MSG(MSG_SHADE_GREYSCALE);
        Shade[2] = MSG(MSG_SHADE_COLOR); 
        Shade[3] = NULL;
        Dithering[0] = MSG(MSG_DITHER_DEFAULT);
        Dithering[1] = MSG(MSG_DITHER_DOTTY);
        Dithering[2] = MSG(MSG_DITHER_VERT);
        Dithering[3] = MSG(MSG_DITHER_HORIZ);
        Dithering[4] = NULL;
        Aspect[0] = MSG(MSG_ASPECT_NORMAL);
        Aspect[1] = MSG(MSG_ASPECT_SIDEWAYS);
        Aspect[2] = NULL;
        Scaling[0] = MSG(MSG_SCALE_NONE);
        Scaling[1] = MSG(MSG_SCALE_ASP_WIDTH);
        Scaling[2] = MSG(MSG_SCALE_ASP_HEIGHT);
        Scaling[3] = MSG(MSG_SCALE_ASP_BOTH);
        Scaling[4] = MSG(MSG_SCALE_FITS_WIDE);
        Scaling[5] = MSG(MSG_SCALE_FITS_TALL);
        Scaling[6] = MSG(MSG_SCALE_FITS_BOTH);
        Scaling[7] = NULL;
        Centering[0] = MSG(MSG_CENTER_NONE);
        Centering[1] = MSG(MSG_CENTER_HORIZ);
        Centering[2] = MSG(MSG_CENTER_VERT);
        Centering[3] = MSG(MSG_CENTER_BOTH);
        Centering[4] = NULL;
                               
        /* Initialise MUI GUI */
	init();

        /* Printer contains 3 tabs: Printer Type, Page Size & Margins & Settings
           Printer type: Selects printer driver, port and unit
           Paper Size:   Size of printer page and margins
           Settings:     Graphics and colour settings
           Menus:        PrinterPS, Edit, Settings
        */
	app = ApplicationObject,
		MUIA_Application_Title      , "PrinterPS",
		MUIA_Application_Version    , "$VER: PrinterPS 41.0 (27.02.09)",
		MUIA_Application_Copyright  , "2009 Peter Hutchison",
		MUIA_Application_Author     , "Peter Hutchison",
		MUIA_Application_Description, "PrinterPS Preferences",
		MUIA_Application_Base       , "PRINTERPS",

		MUIA_Application_Window, window = WindowObject,
			MUIA_Window_Title, MSG(MSG_PROGRAM_TITLE),
			MUIA_Window_ID   , MAKE_ID('P','R','I','N'),
                        MUIA_Window_CloseGadget, FALSE,
                        MUIA_Window_Menustrip, (strip = MenustripObject,
                         MUIA_Family_Child, (MenuObject,
                           MUIA_Menu_Title, MSG(MSG_PROGRAM_TITLE),
                             MUIA_Family_Child, (MN_Open = MenuitemObject,
                               MUIA_Menuitem_Title, MSG(MSG_MENU_OPEN),
                               MUIA_Menuitem_Shortcut, "O",
                             End),
                             MUIA_Family_Child, (MN_SaveAs = MenuitemObject,
                               MUIA_Menuitem_Title, MSG(MSG_MENU_SAVEAS),
                               MUIA_Menuitem_Shortcut, "A",
                             End),
                             MUIA_Family_Child, (MenuitemObject,
                                MUIA_Menuitem_Title, NM_BARLABEL,
                             End),
                             MUIA_Family_Child, (MN_Quit = MenuitemObject,
                               MUIA_Menuitem_Title, MSG(MSG_MENU_QUIT),
                               MUIA_Menuitem_Shortcut, "Q",
                             End),
                           End),
                           MUIA_Family_Child, (MenuObject,
                             MUIA_Menu_Title, MSG(MSG_MENU_EDIT),
                             MUIA_Family_Child, (MN_Defaults = MenuitemObject,
                               MUIA_Menuitem_Title, MSG(MSG_MENU_RESET),
                               MUIA_Menuitem_Shortcut, "D",
                             End),
                             MUIA_Family_Child, (MN_Last = MenuitemObject,
                               MUIA_Menuitem_Title, MSG(MSG_MENU_LAST),
                               MUIA_Menuitem_Shortcut, "L",
                             End),
                             MUIA_Family_Child, (MN_Restore = MenuitemObject,
                               MUIA_Menuitem_Title, MSG(MSG_MENU_RESTORE),
                               MUIA_Menuitem_Shortcut, "R",
                             End),
                          End),
                          MUIA_Family_Child, (MenuObject,
                            MUIA_Menu_Title, MSG(MSG_MENU_SETTINGS),
                              MUIA_Family_Child, (MN_Icons = MenuitemObject,
                                MUIA_Menuitem_Title, MSG(MSG_MENU_ICONS),
                                MUIA_Menuitem_Shortcut, "I",
                                MUIA_Menuitem_Checkit, TRUE,
                              End),
                          End),
                     End),

                        
			WindowContents, VGroup,
                           Child, HGroup,
				Child, HGroup,
                                  Child, ColGroup(2),
                                       Child, CLabel2(MSG(MSG_DRIVER_MODE)), Child, CY_DriverMode = Cycle(DriverMode),
                                       Child, CLabel2(MSG(MSG_COPIES)), Child, SL_Copies = Slider(1, 99, 1),
                                       Child, CLabel2(MSG(MSG_PAPER_FORMAT)), Child, CY_PaperFormat = Cycle(PaperFormat),
                                       Child, CLabel2(MSG(MSG_PAPER_WIDTH)), Child, ST_PaperWidth = String("8.5", 6),
                                       Child, CLabel2(MSG(MSG_PAPER_HEIGHT)), Child, ST_PaperHeight = String("11.0", 6),
                                       Child, CLabel2(MSG(MSG_HORIZ_DPI)), Child, ST_HorizDPI = String("300", 6),
                                       Child, CLabel2(MSG(MSG_VERT_DPI)), Child, ST_VertDPI = String("300", 6),
                                   End,
                                End,

				Child, RegisterGroup(Tabs),
					MUIA_Register_Frame, TRUE,
                                        /* Text group */
					Child, HGroup,                                           
                                              Child, ColGroup(2),
                                                 Child, Label1(MSG(MSG_TEXT_FONT)), Child, CY_Font = Cycle(TextFont),
                                                 Child, Label1(MSG(MSG_TEXT_PITCH)), Child, CY_Pitch = Cycle(TextPitch),
                                                 Child, Label1(MSG(MSG_TEXT_ORIENT)), Child, CY_Orient = Cycle(TextOrient),
                                                 Child, Label1(MSG(MSG_TEXT_TAB)), Child, CY_TextTab = Cycle(TextTab),                                                  					        
                                              End,
                                        End,
                                        
                                        /* Dimensions Group */
					Child, HGroup,
                                               Child, ColGroup(2),
                                               Child, Label1(MSG(MSG_LEFT_MARGIN)), Child, NM_Left = String("1", 4),
                                               Child, Label1(MSG(MSG_RIGHT_MARGIN)), Child, NM_Right = String("1", 4),
                                               Child, Label1(MSG(MSG_TOP_MARGIN)), Child, NM_Top = String("1", 4),
                                               Child, Label1(MSG(MSG_BOTTOM_MARGIN)), Child, NM_Bottom = String("1", 4),
                                               Child, Label1(MSG(MSG_POINT_SIZE)), Child, NM_Point = String("10", 4),
                                               Child, Label1(MSG(MSG_LEADING)), Child, NM_Leading = String("2", 3),
                                               Child, Label1(MSG(MSG_LINES_INCH)), Child, NM_LinesInch = String("6", 4),
                                               Child, Label1(MSG(MSG_LINES_PAGE)), Child, NM_LinesPage = String("58", 4),
                                               End,     
                                        End,                                                                                                                                                                           
                                        

					Child, HGroup,
                                                /* Graphics Group */
						Child, ColGroup(2), 
                                                   Child, Label1(MSG(MSG_LEFT_EDGE)), Child, NM_LeftEdge = String("1.00", 5),
 				                   Child, Label1(MSG(MSG_TOP_EDGE)), Child, NM_TopEdge = String( "1.00", 5),
                                                   Child, Label1(MSG(MSG_WIDTH)), Child, NM_Width = String("6.50", 5),
                                                   Child, Label1(MSG(MSG_HEIGHT)), Child, NM_Height = String("9.00", 5),
                                                   Child, Label1(MSG(MSG_IMAGE)), Child, CY_Image = Cycle(PrintImage),
                                                   Child, Label1(MSG(MSG_SHADE)), Child, CY_Shade = Cycle(Shade),
						   Child, Label1(MSG(MSG_DITHERING)), Child, CY_Dither = Cycle(Dithering),
	                                        End,
					End,
                                             
                                         /* Scaling Group */   
                                        Child, HGroup,
                                             Child, ColGroup(2),         
                                                    Child, Label1(MSG(MSG_ASPECT)), Child, CY_Aspect = Cycle(Aspect),
					            Child, Label1(MSG(MSG_SCALING)), Child, CY_Scaling = Cycle(Scaling),
                                                    Child, Label1(MSG(MSG_CENTERING)), Child, CY_Centering = Cycle(Centering),        
                                               End,
                                       End, 
                                End, 
                            End,   
                            /* Buttons */       
                            Child, HGroup, 
                                       Child, BT_Test = SimpleButton(MSG(MSG_TEST_BUTTON)),
                                       Child, BT_Revert = SimpleButton(MSG(MSG_REVERT_BUTTON)),
                                       Child, HSpace(15),
                                       Child, BT_Save = SimpleButton(MSG(MSG_SAVE_BUTTON)),
                                       Child, BT_Use = SimpleButton(MSG(MSG_USE_BUTTON)),
                                       Child, BT_Cancel = SimpleButton(MSG(MSG_CANCEL_BUTTON)),
                            End,
                                          
			   
	                End,
		End,
        End;

	if (!app) {
 		fail(app,MSG(MSG_APPLICATION_FAILED));
       }


        /* Close program if Window closed */      
	DoMethod(window,MUIM_Notify,MUIA_Window_CloseRequest,TRUE,
		app,2,MUIM_Application_ReturnID,MUIV_Application_ReturnID_Quit);
                               
        /* Initialise some values */
        getcycle(CY_PaperFormat, &paperfmt);
        if (paperfmt != PF_CUSTOM) {
            set(ST_PaperWidth, MUIA_Disabled, TRUE);
            set(ST_PaperHeight, MUIA_Disabled, TRUE);
        }       
        
        /* Check if paper format setting changed */
        DoMethod(CY_PaperFormat, MUIM_Notify, MUIA_Cycle_Active, MUIV_EveryTime, app, 2, MUIM_Application_ReturnID, ID_CUSTOM);

        /* Load Current Printer prefs */
        InitPrefs(CONFIGNAME_ENV, FALSE, FALSE);
        Prefs_to_GUI();
/*
** Note that MUIM_Application_NewInput expects sigs to contain the result
** from Wait() (or 0). This makes the input loop significantly faster.
*/
        /* Save, Use, Cancel buttons */
        DoMethod(BT_Test,   MUIM_Notify, MUIA_Pressed, FALSE, app, 2, MUIM_Application_ReturnID, ID_TEST);
        DoMethod(BT_Revert, MUIM_Notify, MUIA_Pressed, FALSE, app, 2, MUIM_Application_ReturnID, ID_REVERT);
        DoMethod(BT_Save,   MUIM_Notify, MUIA_Pressed, FALSE, app, 2, MUIM_Application_ReturnID, ID_SAVE);
        DoMethod(BT_Use,    MUIM_Notify, MUIA_Pressed, FALSE, app, 2, MUIM_Application_ReturnID, ID_USE);
        DoMethod(BT_Cancel, MUIM_Notify, MUIA_Pressed, FALSE, app, 2, MUIM_Application_ReturnID, ID_CANCEL);

        /* Menu items, return ID if menu select
           This works better than NewMenus */
        DoMethod(MN_Open, MUIM_Notify, MUIA_Menuitem_Trigger, MUIV_EveryTime, MUIV_Notify_Application, 2, 
          MUIM_Application_ReturnID, MEN_OPEN);
        DoMethod(MN_SaveAs, MUIM_Notify, MUIA_Menuitem_Trigger, MUIV_EveryTime, MUIV_Notify_Application, 2, 
          MUIM_Application_ReturnID, MEN_SAVEAS);
        DoMethod(MN_Quit, MUIM_Notify, MUIA_Menuitem_Trigger, MUIV_EveryTime, MUIV_Notify_Application, 2, 
          MUIM_Application_ReturnID, MEN_QUIT);
        DoMethod(MN_Defaults, MUIM_Notify, MUIA_Menuitem_Trigger, MUIV_EveryTime, MUIV_Notify_Application, 2, 
          MUIM_Application_ReturnID, MEN_DEFAULTS);
        DoMethod(MN_Last, MUIM_Notify, MUIA_Menuitem_Trigger, MUIV_EveryTime, MUIV_Notify_Application, 2, 
          MUIM_Application_ReturnID, MEN_LAST);
        DoMethod(MN_Restore, MUIM_Notify, MUIA_Menuitem_Trigger, MUIV_EveryTime, MUIV_Notify_Application, 2, 
          MUIM_Application_ReturnID, MEN_RESTORE);
        DoMethod(MN_Icons, MUIM_Notify, MUIA_Menuitem_Trigger, MUIV_EveryTime, MUIV_Notify_Application, 2, 
          MUIM_Application_ReturnID, MEN_ICONS);
 
          
 	set(window,MUIA_Window_Open,TRUE);

                     
	while (running)
	{
                /* Check buttons */
		id = DoMethod(app,MUIM_Application_Input,&signal);
                if (id > 0) { 
                              
		  switch (id)
		  {
                        case ID_CANCEL:
                        case MEN_QUIT:
			case MUIV_Application_ReturnID_Quit:
				running = FALSE;
				break;
                                
		
                        case ID_REVERT:
                                RestorePrefs();
                                Prefs_to_GUI();
				break;
                        case ID_TEST:
                               GUI_to_Prefs();
                               SavePrefs(CONFIGNAME_ENV);     
                               break;
                               
                        case ID_SAVE:
                               GUI_to_Prefs();
                               SavePrefs(CONFIGNAME_ENVARC);
                               running = FALSE;
                               break;
                               
                        case ID_USE:
                               GUI_to_Prefs();
                               SavePrefs(CONFIGNAME_ENV); 
                               running = FALSE;
                               break;
                        
                        case ID_CUSTOM:
                                getcycle(CY_PaperFormat, &paperfmt);
                               if (paperfmt != PF_CUSTOM) {
                                    set(ST_PaperWidth, MUIA_Disabled, TRUE);
                                    set(ST_PaperHeight, MUIA_Disabled, TRUE);                                    
                                } else {
                                    set(ST_PaperWidth, MUIA_Disabled, FALSE);
                                    set(ST_PaperHeight, MUIA_Disabled, FALSE);
                                }
                                sprintf(buf, "%f", fmtWidths[paperfmt]);
                                setstring(ST_PaperWidth, buf);
                                sprintf(buf, "%f", fmtHeights[paperfmt]);
                                setstring(ST_PaperHeight, buf);
                                /* Set Lines per page */
                                switch (paperfmt) {
                                   case PF_USLETTER:
                                   case PF_CUSTOM:
                                      linespage = 54;
                                      break;
                                   case PF_USLEGAL:
                                      linespage = 72;
                                      break;
                                   case PF_A4:
                                      linespage = 58;
                                      break;
                                }
                                sprintf(buf, "%d", linespage);
                                setstring(NM_LinesPage, buf);
                                break;     
                        case MEN_OPEN:
                                if ((filename = GetFile((const STRPTR)MSG(MSG_ASL_OPEN_TITLE), "SYS:Prefs/Presets", FALSE))) {
 	        	          LoadPrefs(filename);
                                  Prefs_to_GUI();
                                }
                                break;
                        
                        case MEN_SAVEAS:
                                if ((filename = GetFile((const STRPTR)MSG(MSG_ASL_SAVE_TITLE), "SYS:Prefs/Presets", TRUE))) {
                                    GUI_to_Prefs();
                                    SavePrefs(filename);
                                }
                                break;
                                
                        case MEN_DEFAULTS:
                                DefaultPrefs();
                                Prefs_to_GUI();                        
                                break;
                                
                        case MEN_LAST:
                                LoadPrefs(CONFIGNAME_ENVARC);
                                Prefs_to_GUI();
                                break;
                                
                        case MEN_RESTORE:   
                                RestorePrefs();
                                Prefs_to_GUI();                                                                       
                                break;
                        
                        case MEN_ICONS:
                                Icons = !Icons;
                                break;
                                
		  } /* Switch */
                } /* if */
                 
                if (running && signal) Wait(signal);
            
	} /* End switch */
	set(window,MUIA_Window_Open,FALSE);


/*
** Shut down...
*/

	fail(app,NULL);
        CleanupLocale();
}
    
