/*
Name:  Misc.c
Project: Printer prefs
Author:  Peter Hutchison
*/

/*********************************************************************************************/

#include "global.h"

#include <math.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <prefs/printergfx.h>
#include <prefs/printertxt.h>
#include <prefs/printerps.h>

extern APTR CY_DriverMode, SL_Copies, CY_PaperFormat, ST_PaperWidth, ST_PaperHeight, ST_HorizDPI, ST_VertDPI,
 CY_Font, CY_Pitch, CY_Orient, CY_TextTab, NM_Left, NM_Right, NM_Top, NM_Bottom, NM_Point, NM_Leading, NM_LinesInch,
 NM_LinesPage, NM_LeftEdge, NM_TopEdge, NM_Width, NM_Height, CY_Image, CY_Shade, CY_Dither, CY_Aspect, CY_Scaling,
 CY_Centering, BT_Test, BT_Revert, BT_Save, BT_Use, BT_Cancel;
 
extern struct PrinterPSPrefs        printerpsprefs;

extern BOOL customdev;

/*********************************************************************************************/


STRPTR GetFile(char *title, char *dir, BOOL savemode)
{
    static UBYTE filebuffer[300];
    struct FileRequester *req;
    STRPTR retval = NULL;
   
    if (AslBase = OpenLibrary("asl.library", 39))
    {
	if (req = AllocAslRequestTags(ASL_FileRequest, ASLFR_TitleText    , title,
						   ASLFR_DoPatterns   , TRUE       ,
						   ASLFR_InitialDrawer, dir  ,
						   ASLFR_DoSaveMode   , savemode   ,
						   TAG_DONE))
	{
	    if (AslRequest(req, NULL))
	    {
		strncpy(filebuffer, req->fr_Drawer, 299);
		AddPart(filebuffer, req->fr_File, 299);
		
		retval = filebuffer;
		
	    } /* if (AslRequest(req, NULL) */
	    
 	    FreeAslRequest(req);
	    
	} /* if (req) */
	
	CloseLibrary(AslBase);
	
    } /* if (AslBase) */
    
    return retval;
}

void GUI_to_Prefs(void) 
{
    char *buf;
    LONG value = 0;
    
    getcycle(CY_DriverMode, &value);
    printerpsprefs.ps_DriverMode = value;
    
    getcycle(CY_PaperFormat, &value);
    printerpsprefs.ps_PaperFormat = value;
    
    getslider(SL_Copies, &value);
    printerpsprefs.ps_Copies = value;
    
    /* Convert inches to 1/72000 in */    
    getstring(ST_PaperWidth, &buf);
    if (strlen(buf)>0) {
      printerpsprefs.ps_PaperWidth =atof(buf) * 72000;
    }
    getstring(ST_PaperHeight, &buf);
    if (strlen(buf)>0) {
      printerpsprefs.ps_PaperHeight = atof(buf) * 72000;
    }
    getstring(ST_HorizDPI, &buf);
    if (strlen(buf)>0) {
      printerpsprefs.ps_HorizontalDPI = atoi(buf);
    }
    getstring(ST_VertDPI, &buf);
    if (strlen(buf)>0) {
      printerpsprefs.ps_VerticalDPI = atoi(buf);
    }
    
    /* Text Options */
    getcycle(CY_Font, &value);
    printerpsprefs.ps_Font = value;
    
    getcycle(CY_Pitch, &value);
    printerpsprefs.ps_Pitch = value;

    getcycle(CY_Orient, &value);
    printerpsprefs.ps_Orientation = value;

    getcycle(CY_TextTab, &value);
    printerpsprefs.ps_Tab = value;

    /* Dimension Options */
  
    getstring(NM_Left, &buf);
    if (strlen(buf)>0) {
      printerpsprefs.ps_LeftMargin = atof(buf) * 72000.0;
    }
    getstring(NM_Right, &buf);
    if (strlen(buf)>0) {
      printerpsprefs.ps_RightMargin = atof(buf) * 72000.0;
    }
    getstring(NM_Top, &buf);
    if (strlen(buf)>0) {
      printerpsprefs.ps_TopMargin = atof(buf) * 72000.0;
    }
    getstring(NM_Bottom, &buf);
    if (strlen(buf)>0) {
      printerpsprefs.ps_BottomMargin = atof(buf) * 72000.0;
    }
    getstring(NM_Point, &buf);
    if (strlen(buf)>0) {
      printerpsprefs.ps_FontPointSize = atoi(buf) * 1000;
    }
    getstring(NM_Leading, &buf);
    if (strlen(buf)>0) {
      printerpsprefs.ps_Leading = atoi(buf) * 1000;
    }
    /* Note: LPI and LPP is calculated! */
    
    /* Graphics Options */
    
    getstring(NM_LeftEdge, &buf);
    if (strlen(buf)>0) {
      printerpsprefs.ps_LeftEdge = atof(buf) * 72000.0;
    }
    getstring(NM_TopEdge, &buf);
    if (strlen(buf)>0) {
      printerpsprefs.ps_TopEdge = atof(buf) * 72000.0;
    }    
    getstring(NM_Width, &buf);
    if (strlen(buf)>0) {
      printerpsprefs.ps_Width = atof(buf) * 72000.0;
    }    
    getstring(NM_Height, &buf);
    if (strlen(buf)>0) {
      printerpsprefs.ps_Height = atof(buf) * 72000.0;
    }     
    getcycle(CY_Image, &value);
    printerpsprefs.ps_Image = value;
    
    getcycle(CY_Shade, &value);
    printerpsprefs.ps_Shading = value;
 
    getcycle(CY_Dither, &value);
    printerpsprefs.ps_Dithering = value;
   
    /* Scaling */
    
    getcycle(CY_Aspect, &value);
    printerpsprefs.ps_Aspect = value;
    
    getcycle(CY_Scaling, &value);
    printerpsprefs.ps_ScalingType = value;
     
    getcycle(CY_Centering, &value);
    printerpsprefs.ps_Centering = value;  
}

void Prefs_to_GUI(void)
{
    char buf[50];
    UWORD point;
    double height;
    LONG paperfmt, linespage;

    setcycle(CY_DriverMode, printerpsprefs.ps_DriverMode);
    paperfmt = printerpsprefs.ps_PaperFormat;
    setcycle(CY_PaperFormat, paperfmt);
    setslider(SL_Copies, printerpsprefs.ps_Copies);
    sprintf(buf, "%3.2f", printerpsprefs.ps_PaperWidth / 72000.0);
    setstring(ST_PaperWidth, buf);
    height =  printerpsprefs.ps_PaperHeight / 72000.0;
    sprintf(buf, "%3.2f", height);
    setstring(ST_PaperHeight, buf);
    sprintf(buf, "%d", printerpsprefs.ps_HorizontalDPI);
    setstring(ST_HorizDPI, buf);
    sprintf(buf, "%d", printerpsprefs.ps_VerticalDPI);
    setstring(ST_VertDPI, buf);
 
    /* Text Options */
    setcycle(CY_Font, printerpsprefs.ps_Font);
    setcycle(CY_Pitch, printerpsprefs.ps_Pitch);
    setcycle(CY_Orient, printerpsprefs.ps_Orientation);
    setcycle(CY_TextTab, printerpsprefs.ps_Tab);
    
    /* Dimension options */
    sprintf(buf, "%3.2f", printerpsprefs.ps_LeftMargin / 72000.0);
    setstring(NM_Left, buf);
    sprintf(buf, "%3.2f", printerpsprefs.ps_RightMargin / 72000.0);
    setstring(NM_Right, buf);    
    sprintf(buf, "%3.2f", printerpsprefs.ps_TopMargin / 72000.0);
    setstring(NM_Top, buf);
    sprintf(buf, "%3.2f", printerpsprefs.ps_BottomMargin / 72000.0);
    setstring(NM_Bottom, buf);
    point = printerpsprefs.ps_FontPointSize / 1000;
    sprintf(buf, "%d", point);
    setstring(NM_Point, buf);    
    sprintf(buf, "%d", printerpsprefs.ps_Leading / 1000);
    setstring(NM_Leading, buf);
    /* Calculate LPI and LPP approx. */
    switch (paperfmt) {
           case PF_USLETTER: 
           case PF_CUSTOM:
              linespage = 54;
              break;
           case PF_USLEGAL:
              linespage = 72;
              break;
           case PF_A4:
              linespage = 58;
              break;
            }
     sprintf(buf, "%d", linespage);
     setstring(NM_LinesPage, buf);
     setstring(NM_LinesInch, "6");
    
    /* Graphics */
    sprintf(buf, "%3.2f", printerpsprefs.ps_LeftEdge / 72000.0);
    setstring(NM_LeftEdge, buf);
    sprintf(buf, "%3.2f", printerpsprefs.ps_TopMargin / 72000.0);
    setstring(NM_TopEdge, buf);
    sprintf(buf, "%3.2f", printerpsprefs.ps_Width / 72000.0);
    setstring(NM_Width, buf);
    sprintf(buf, "%3.2f", printerpsprefs.ps_Height / 72000.0);
    setstring(NM_Height, buf);
    setcycle(CY_Image, printerpsprefs.ps_Image);
    setcycle(CY_Shade, printerpsprefs.ps_Shading);
    setcycle(CY_Dither, printerpsprefs.ps_Dithering);
    
    /* Scaling options */
    setcycle(CY_Aspect, printerpsprefs.ps_Aspect);
    setcycle(CY_Scaling, printerpsprefs.ps_ScalingType);
    setcycle(CY_Centering, printerpsprefs.ps_Centering);
    
}
