/* Printer Preferences
   Author: Peter Hutchison
   Date: 06/12/07
   System: AROS
   
   Copyright 2007 Peter Hutchison
   GNU Public License
*/

#define CATCOMP_NUMBERS

#include "global.h"
#include "printer.h"

/* Menu items */

enum { MEN_OPEN=1, MEN_SAVEAS, MEN_QUIT, MEN_DEFAULTS, MEN_LAST, MEN_RESTORE, MEN_ICONS, ID_TEST,
 ID_REVERT, ID_SAVE, ID_USE, ID_CANCEL, ID_CUSTOM, ID_PRTNAME };

struct Library *MUIMasterBase;

/* Pointers for values we want to read or set.
   CY = Cycle, ST=String, LB = Label, NM = number 
   LV = Listview CM=CheckMark  SL=Slider BT=Button
*/

APTR LV_Directory, ST_PrtName, CY_PrtPort, CM_Custom, ST_PortDevice,
  NM_PortUnit, CY_PaperType, CY_PaperFmt, CY_PrtPitch, CY_PrtSpace, NM_Length, NM_Left, NM_Right,
  SL_Density,LB_Res, LB_PaperSize, LB_TopBorder, LB_LeftBorder, LB_PrtArea, CY_PrtQuality, CY_Dither,
  CY_Scaling, CY_Image, CY_Aspect, CY_Shade, SL_Threshold, NM_LeftEdge, CM_Center, CM_Smooth,
  CM_Red, CM_Green, CM_Blue, CY_Limits, NM_Width, NM_Height, BT_Save, BT_Use, BT_Cancel,
  BT_Test, BT_Revert, MN_Open, MN_SaveAs, MN_Quit, MN_Defaults, 
  MN_Last, MN_Restore, MN_Icons;

    
BOOL customdev = TRUE;

/* Values for Labels, Tabs and Cycle gagdets. */

static STRPTR Tabs[4], Ports[3], PaperType[3], PaperFormat[15], PrintPitch[4], Spacing[3],
   Quality[3], Dithering[4], Scaling[3], PrintImage[3], Aspect[3], Shade[5], LimitsType[6];

int main(int argc,char *argv[])
{
    APTR app,window, strip;
        BOOL running = TRUE, Icons = FALSE;
        ULONG signal, id;
        STRPTR filename;
        struct FileInfoBlock *finfo = NULL;
        
        /* Initialise Localisation */
        InitLocale("printer.catalog", 1);

        /* Localize the labels.
           LocalizeLabels() didn't work so used the long method */
           
        Tabs[0] = MSG(MSG_TAB_PRT_TYPE);
        Tabs[1] = MSG(MSG_TAB_SIZE_MARGINS); 
        Tabs[2] = MSG(MSG_TAB_SETTINGS);  
        Tabs[3] = NULL;
        Ports[0] = MSG(MSG_PARALLEL_PORT);
        Ports[1] = MSG(MSG_SERIAL_PORT);
        Ports[2] = NULL;
        PaperType[0] = MSG(MSG_TYPE_CONT);
        PaperType[1] = MSG(MSG_TYPE_SINGLE);
        PaperType[2] = NULL;
        PaperFormat[0] = MSG(MSG_FMT_LETTER);
        PaperFormat[1] = MSG(MSG_FMT_LEGAL);
        PaperFormat[2] = MSG(MSG_FMT_NARROW);
        PaperFormat[3] = MSG(MSG_FMT_WIDE);
        PaperFormat[4] = MSG(MSG_FMT_CUSTOM);
        PaperFormat[5] = MSG(MSG_FMT_DINA0);
        PaperFormat[6] = MSG(MSG_FMT_DINA1);
        PaperFormat[7] = MSG(MSG_FMT_DINA2);
        PaperFormat[8] = MSG(MSG_FMT_DINA3);
        PaperFormat[9] = MSG(MSG_FMT_DINA4);
        PaperFormat[10] = MSG(MSG_FMT_DINA5);
        PaperFormat[11] = MSG(MSG_FMT_DINA6);
        PaperFormat[12] = MSG(MSG_FMT_DINA7);
        PaperFormat[13] = MSG(MSG_FMT_DINA8);
        PaperFormat[14] = NULL;
        PrintPitch[0] = MSG(MSG_PITCH8);
        PrintPitch[1] = MSG(MSG_PITCH12);
        PrintPitch[2] = MSG(MSG_PITCH15);
        PrintPitch[3] = NULL;
        Spacing[0] = MSG(MSG_6LPI);
        Spacing[1] = MSG(MSG_8LPI);
        Spacing[2] = NULL;
        Quality[0] = MSG(MSG_QUALITY_DRAFT);
        Quality[1] = MSG(MSG_QUALITY_LETTER);
        Quality[2] = NULL;
        Dithering[0] = MSG(MSG_DITHER_ORDERED);
        Dithering[1] = MSG(MSG_DITHER_HALFTONE);
        Dithering[2] = MSG(MSG_DITHER_FLOYD);
        Dithering[3] = NULL;
        Scaling[0] = MSG(MSG_SCALE_FRACTION);
        Scaling[1] = MSG(MSG_SCALE_INTEGER);
        Scaling[2] = NULL;
        PrintImage[0] = MSG(MSG_IMAGE_POSITIVE);
        PrintImage[1] = MSG(MSG_IMAGE_NEGATIVE);
        PrintImage[2] = NULL;
        Aspect[0] = MSG(MSG_ASPECT_HORIZ);
        Aspect[1] = MSG(MSG_ASPECT_VERT);
        Aspect[2] = NULL;
        Shade[0] = MSG(MSG_SHADE_BW);
        Shade[1] = MSG(MSG_SHADE_GREY1);
        Shade[2] = MSG(MSG_SHADE_COLOR); 
        Shade[3] = MSG(MSG_SHADE_GREY2);
        Shade[4] = NULL;
        LimitsType[0] = MSG(MSG_LIMITS_IGNORE);
        LimitsType[1] = MSG(MSG_LIMITS_BOUND);
        LimitsType[2] = MSG(MSG_LIMITS_ABS);
        LimitsType[3] = MSG(MSG_LIMITS_PIXELS);
        LimitsType[4] = MSG(MSG_LIMITS_MULTI);
        LimitsType[5] = NULL;
                                                        
        /* Initialise MUI GUI */
    init();

        /* Printer contains 3 tabs: Printer Type, Page Size & Margins & Settings
           Printer type: Selects printer driver, port and unit
           Paper Size:   Size of printer page and margins
           Settings:     Graphics and colour settings
        
        */
    app = ApplicationObject,
        MUIA_Application_Title      , "Printer",
        MUIA_Application_Version    , "$VER: Printer 41.0 (27.02.09)",
        MUIA_Application_Copyright  , "2009 Peter Hutchison",
        MUIA_Application_Author     , "Peter Hutchison",
        MUIA_Application_Description, "Printer Preferences",
        MUIA_Application_Base       , "PRINTER",

        SubWindow, window = WindowObject,
            MUIA_Window_Title, MSG(MSG_PROGRAM_TITLE),
            MUIA_Window_ID   , MAKE_ID('P','R','I','N'),
                        MUIA_Window_CloseGadget, FALSE,
                        MUIA_Window_Menustrip,   (strip = MenustripObject,
                         MUIA_Family_Child, (MenuObject,
                           MUIA_Menu_Title, (IPTR)MSG(MSG_PROGRAM_TITLE),
                             MUIA_Family_Child, (MN_Open = MenuitemObject,
                               MUIA_Menuitem_Title, (IPTR)MSG(MSG_MENU_OPEN),
                               MUIA_Menuitem_Shortcut, "O",
                             End),
                             MUIA_Family_Child, (MN_SaveAs = MenuitemObject,
                               MUIA_Menuitem_Title, (IPTR)MSG(MSG_MENU_SAVEAS),
                               MUIA_Menuitem_Shortcut, "A",
                             End),
                             MUIA_Family_Child, (MenuitemObject,
                                MUIA_Menuitem_Title, NM_BARLABEL,
                             End),
                             MUIA_Family_Child, (MN_Quit = MenuitemObject,
                               MUIA_Menuitem_Title, (IPTR)MSG(MSG_MENU_QUIT),
                               MUIA_Menuitem_Shortcut, "Q",
                             End),
                           End),
                           MUIA_Family_Child, (MenuObject,
                             MUIA_Menu_Title, MSG(MSG_MENU_EDIT),
                             MUIA_Family_Child, (MN_Defaults = MenuitemObject,
                               MUIA_Menuitem_Title, MSG(MSG_MENU_RESET),
                               MUIA_Menuitem_Shortcut, "D",
                             End),
                             MUIA_Family_Child, (MN_Last = MenuitemObject,
                               MUIA_Menuitem_Title, MSG(MSG_MENU_LAST),
                               MUIA_Menuitem_Shortcut, "L",
                             End),
                             MUIA_Family_Child, (MN_Restore = MenuitemObject,
                               MUIA_Menuitem_Title, MSG(MSG_MENU_RESTORE),
                               MUIA_Menuitem_Shortcut, "R",
                             End),
                          End),
                          MUIA_Family_Child, (MenuObject,
                            MUIA_Menu_Title, MSG(MSG_MENU_SETTINGS),
                              MUIA_Family_Child, (MN_Icons = MenuitemObject,
                                MUIA_Menuitem_Title, MSG(MSG_MENU_ICONS),
                                MUIA_Menuitem_Shortcut, "I",
                                MUIA_Menuitem_Checkit, TRUE,
                              End),
                          End),
                     End),
                       
            WindowContents, VGroup,

                Child, VSpace(1),

                Child, RegisterGroup(Tabs),
                    MUIA_Register_Frame, TRUE,

                    Child, HGroup,
                                               Child, VGroup,
                                                Child, CLabel2(MSG(MSG_PRINTER_TYPE)), 
                            Child, LV_Directory = ListviewObject,
                           MUIA_Listview_Input, TRUE,
                               MUIA_Listview_List, DirlistObject, InputListFrame, 
                                                   MUIA_Dirlist_FilesOnly, TRUE,
                                                   MUIA_Dirlist_RejectIcons, TRUE,
                                                   MUIA_List_Format, "COL=0",
                                                   MUIA_Dirlist_Directory, "devs:printers/", 
                                                   MUIA_List_Title, FALSE, End,
                           End,
                                                End,
                                                
                                                Child, HGroup, 
                                                 Child, ColGroup(2), 
                                                  Child, VSpace(6), Child, VSpace(6),
                                                    Child, Label1(MSG(MSG_PRINTER_NAME)), 
                                                      Child, ST_PrtName = String("Generic", 20),
                                                    Child, Label1(MSG(MSG_PRINTER_PORT)), 
                                                      Child, CY_PrtPort = Cycle(Ports),
                                                    Child, CM_Custom = CheckMark(FALSE), 
                                                      Child, LLabel(MSG(MSG_CUSTOM_DEVICE)),
                                                    Child, LLabel(MSG(MSG_PORT_DEVICE)), 
                                                      Child, ST_PortDevice = String("", 20),    
                                                    Child, LLabel(MSG(MSG_PORT_UNIT)), 
                                                      Child, NM_PortUnit = String("0", 4),    
                                                  End, 
                                                 End,
                                        End,
                                        
                    Child, HGroup, 
                                               Child, ColGroup(2),
                                               Child, HSpace(15), Child, HSpace(25),
                                               Child, Label1(MSG(MSG_PAPER_TYPE)), Child, CY_PaperType = Cycle(PaperType),
                                               Child, Label1(MSG(MSG_PAPER_FORMAT)), Child, CY_PaperFmt = Cycle(PaperFormat),
                                               Child, Label1(MSG(MSG_PRINT_PITCH)), Child, CY_PrtPitch = Cycle(PrintPitch),
                                               Child, Label1(MSG(MSG_PRINT_SPACING)), Child, CY_PrtSpace = Cycle(Spacing),
                                               Child, Label1(MSG(MSG_PAPER_LENGTH)), Child, NM_Length = String("66", 3),
                                               Child, Label1(MSG(MSG_LEFT_MARGIN)), Child, NM_Left = String("2", 3),
                                               Child, Label1(MSG(MSG_RIGHT_MARGIN)), Child, NM_Right = String("2", 3),
                                               Child, Label1(MSG(MSG_DENSITY)), Child, SL_Density = Slider(1,7,4),
                                              End, 
                                              
                                              Child, ColGroup(2),
                                               Child, HSpace(15), Child, HSpace(20),
                                              End,                                                                                                                                                                         
                                        End,

                    Child, HGroup,
                        Child, VGroup,
                          Child, ColGroup(2), 
                            Child, Label1(MSG(MSG_PRINT_QUALITY)), Child, CY_PrtQuality = Cycle(Quality),
                            Child, Label1(MSG(MSG_DITHERING)), Child, CY_Dither = Cycle(Dithering),
                            Child, Label1(MSG(MSG_SCALING)), Child, CY_Scaling = Cycle(Scaling),
                            Child, Label1(MSG(MSG_IMAGE)), Child, CY_Image = Cycle(PrintImage),
                                                        Child, Label1(MSG(MSG_ASPECT)), Child, CY_Aspect = Cycle(Aspect),
                                                        Child, Label1(MSG(MSG_SHADE)), Child, CY_Shade = Cycle(Shade),
                                                        Child, Label1(MSG(MSG_THRESHOLD)), Child, SL_Threshold = Slider(1,15,7),
                                                        Child, Label1(MSG(MSG_LEFT_EDGE)), Child, NM_LeftEdge = String("10", 3),
                                                        Child, CM_Center = CheckMark(FALSE), Child, LLabel(MSG(MSG_CENTER_PICTURE)),
                                                        Child, CM_Smooth = CheckMark(FALSE), Child, LLabel(MSG(MSG_SMOOTHING)),
                                End,
                        End,
                                                
                                                Child, VGroup, 
                                                        Child, CLabel(MSG(MSG_COLOR_CORRECTION)),
                                                        Child, ColGroup(6),
                                                            Child, CM_Red = CheckMark(FALSE), Child, Label1(MSG(MSG_RED_COLOUR)),
                                                            Child, CM_Green = CheckMark(FALSE), Child, Label1(MSG(MSG_GREEN_COLOUR)),
                                                            Child, CM_Blue = CheckMark(FALSE), Child, Label1(MSG(MSG_BLUE_COLOUR)),
                                                            End,
                                                        Child, CLabel(MSG(MSG_LIMITS)),
                                                        Child, ColGroup(2),
                                                            Child, Label1(MSG(MSG_LIMIT_TYPE)), Child, CY_Limits = Cycle(LimitsType),
                                                            Child, Label1(MSG(MSG_LIMIT_WIDTH)), Child, NM_Width = String("0", 5),
                                                            Child, Label1(MSG(MSG_LIMIT_HEIGHT)), Child, NM_Height = String("0", 5),
                                                            End,
                                                            
                                               End,
                                        End, 
                                       End, 
                                              
                                       Child, HGroup, 
                                          Child, BT_Test = SimpleButton(MSG(MSG_TEST_BUTTON)),
                                          Child, BT_Revert = SimpleButton(MSG(MSG_REVERT_BUTTON)),
                                          Child, HSpace(15),
                                          Child, BT_Save = SimpleButton(MSG(MSG_SAVE_BUTTON)),
                                          Child, BT_Use = SimpleButton(MSG(MSG_USE_BUTTON)),
                                          Child, BT_Cancel = SimpleButton(MSG(MSG_CANCEL_BUTTON)),
                                          End,
                                          
                End,
            End,
        End;

    if (!app) {
        fail(app,MSG(MSG_APPLICATION_FAILED));
       }

    DoMethod(window,MUIM_Notify,MUIA_Window_CloseRequest,TRUE,
        app,2,MUIM_Application_ReturnID,MUIV_Application_ReturnID_Quit);
                               
        /* Initialise some values */
        if (customdev == FALSE) {
          set(ST_PortDevice, MUIA_Disabled, customdev);
          set(NM_PortUnit, MUIA_Disabled, customdev);
        }
        set(LV_Directory, MUIA_List_Active, 0);
        setcycle(CY_PrtPort, 1); /* Serial */
        setstring(NM_Length, "70");

        /* Load Current Printer prefs */
        InitPrefs(CONFIGNAME_ENV, FALSE, FALSE);
        Prefs_to_GUI();
        

/*
** Note that MUIM_Application_NewInput expects sigs to contain the result
** from Wait() (or 0). This makes the input loop significantly faster.
*/
        /* Toggle Custom device settings */
        DoMethod(CM_Custom, MUIM_Notify, MUIA_Selected, MUIV_EveryTime, app, 2, MUIM_Application_ReturnID, ID_CUSTOM);

        /* Save, Use, Cancel buttons */
        DoMethod(BT_Test,   MUIM_Notify, MUIA_Pressed, FALSE, app, 2, MUIM_Application_ReturnID, ID_TEST);
        DoMethod(BT_Revert, MUIM_Notify, MUIA_Pressed, FALSE, app, 2, MUIM_Application_ReturnID, ID_REVERT);
        DoMethod(BT_Save,   MUIM_Notify, MUIA_Pressed, FALSE, app, 2, MUIM_Application_ReturnID, ID_SAVE);
        DoMethod(BT_Use,    MUIM_Notify, MUIA_Pressed, FALSE, app, 2, MUIM_Application_ReturnID, ID_USE);
        DoMethod(BT_Cancel, MUIM_Notify, MUIA_Pressed, FALSE, app, 2, MUIM_Application_ReturnID, ID_CANCEL);

        /* Menu items, return ID if menu select
           This works better than NewMenus */
        DoMethod(MN_Open, MUIM_Notify, MUIA_Menuitem_Trigger, MUIV_EveryTime, MUIV_Notify_Application, 2, 
          MUIM_Application_ReturnID, MEN_OPEN);
        DoMethod(MN_SaveAs, MUIM_Notify, MUIA_Menuitem_Trigger, MUIV_EveryTime, MUIV_Notify_Application, 2, 
          MUIM_Application_ReturnID, MEN_SAVEAS);
        DoMethod(MN_Quit, MUIM_Notify, MUIA_Menuitem_Trigger, MUIV_EveryTime, MUIV_Notify_Application, 2, 
          MUIM_Application_ReturnID, MEN_QUIT);
        DoMethod(MN_Defaults, MUIM_Notify, MUIA_Menuitem_Trigger, MUIV_EveryTime, MUIV_Notify_Application, 2, 
          MUIM_Application_ReturnID, MEN_DEFAULTS);
        DoMethod(MN_Last, MUIM_Notify, MUIA_Menuitem_Trigger, MUIV_EveryTime, MUIV_Notify_Application, 2, 
          MUIM_Application_ReturnID, MEN_LAST);
        DoMethod(MN_Restore, MUIM_Notify, MUIA_Menuitem_Trigger, MUIV_EveryTime, MUIV_Notify_Application, 2, 
          MUIM_Application_ReturnID, MEN_RESTORE);
        DoMethod(MN_Icons, MUIM_Notify, MUIA_Menuitem_Trigger, MUIV_EveryTime, MUIV_Notify_Application, 2, 
          MUIM_Application_ReturnID, MEN_ICONS);
 

        /* Set Printer name depending on selected name */
        DoMethod(LV_Directory, MUIM_Notify, MUIA_Listview_DoubleClick, TRUE, app, 2,
          MUIM_Application_ReturnID, ID_PRTNAME);     
        
    set(window,MUIA_Window_Open,TRUE);
                      
    while (running)
    {
        id = DoMethod(app,MUIM_Application_Input,&signal);
                if (id > 0) { 
                              
          switch (id)
          {
                        case ID_CANCEL:
            case MEN_QUIT:
            case MUIV_Application_ReturnID_Quit:
                running = FALSE;
                break;
                                
                        case MEN_OPEN:
                                if ((filename = GetFile((const STRPTR)MSG(MSG_ASL_OPEN_TITLE), "SYS:Prefs/Presets", FALSE))) {
                      LoadPrefs(filename);
                                  Prefs_to_GUI();
                                }
                            break;

            case MEN_SAVEAS:
                            if ((filename = GetFile((const STRPTR)MSG(MSG_ASL_SAVE_TITLE), "SYS:Prefs/Presets", TRUE))) {
                                    GUI_to_Prefs();
                                    SavePrefs(filename);
                                }
                    break;

            case MEN_DEFAULTS:
                                DefaultPrefs();
                                Prefs_to_GUI();
                    break;

            case MEN_LAST:
                                LoadPrefs(CONFIGNAME_ENVARC);
                                Prefs_to_GUI();
                break;
            
                        case ID_REVERT:
            case MEN_RESTORE:
                                RestorePrefs();
                                Prefs_to_GUI();
                break;

            case MEN_ICONS:
                Icons = !Icons;
                                break;
                            
                        case ID_TEST:
                               GUI_to_Prefs();
                               SavePrefs(CONFIGNAME_ENV);     
                               break;
                               
                        case ID_SAVE:
                               GUI_to_Prefs();
                               SavePrefs(CONFIGNAME_ENVARC);
                               running = FALSE;
                               break;
                               
                        case ID_USE:
                               GUI_to_Prefs();
                               SavePrefs(CONFIGNAME_ENV); 
                               running = FALSE;
                               break;
                        
                        case ID_CUSTOM:
                               customdev = !customdev;
                               set(ST_PortDevice, MUIA_Disabled, customdev);
                               set(NM_PortUnit, MUIA_Disabled, customdev);
                               if (customdev == TRUE)
                                 setstring(ST_PortDevice, "");
                               break;
                               
                       
                        case ID_PRTNAME:
                               DoMethod(LV_Directory, MUIM_List_GetEntry, MUIV_List_GetEntry_Active, &finfo);
                               if (strlen(finfo->fib_FileName) != 0)
                                 setstring(ST_PrtName, finfo->fib_FileName); 
                               break;
                        
          }
                }
        if (running && signal) Wait(signal);
    }


    set(window,MUIA_Window_Open,FALSE);


/*
** Shut down...
*/

    fail(app,NULL);
        CleanupLocale();
}
    
    
