/*
Name:  Misc.c
Project: Printer prefs
Author:  Peter Hutchison
*/

/*********************************************************************************************/

#include "global.h"

#include <string.h>
#include <stdio.h>
#include <prefs/printergfx.h>
#include <prefs/printertxt.h>

extern APTR LV_Directory, ST_PrtName, CY_PrtPort, CM_Custom, ST_PortDevice;
extern APTR NM_PortUnit, CY_PaperType, CY_PaperFmt, CY_PrtPitch, CY_PrtSpace, NM_Length, NM_Left, NM_Right;
extern APTR SL_Density,LB_Res, LB_PaperSize, LB_TopBorder, LB_LeftBorder, LB_PrtArea, CY_PrtQuality, CY_Dither;
extern APTR CY_Scaling, CY_Image, CY_Aspect, CY_Shade, SL_Threshold, NM_LeftEdge, CM_Center, CM_Smooth;
extern APTR CM_Red, CM_Green, CM_Blue, CY_Limits, NM_Width, NM_Height, BT_Save, BT_Use, BT_Cancel;
extern APTR BT_Test, BT_Revert;
 
extern struct PrinterTxtPrefs        printertxtprefs;
extern struct PrinterUnitPrefs       printerunitprefs;
extern struct PrinterGfxPrefs        printergfxprefs;

extern BOOL customdev;

/*********************************************************************************************/


STRPTR GetFile(char *title, char *dir, BOOL savemode)
{
    static UBYTE filebuffer[300];
    struct FileRequester *req;
    STRPTR retval = NULL;
   
    if (AslBase = OpenLibrary("asl.library", 39))
    {
	if (req = AllocAslRequestTags(ASL_FileRequest, ASLFR_TitleText    , title,
						   ASLFR_DoPatterns   , TRUE       ,
						   ASLFR_InitialDrawer, dir  ,
						   ASLFR_DoSaveMode   , savemode   ,
						   TAG_DONE))
	{
	    if (AslRequest(req, NULL))
	    {
		strncpy(filebuffer, req->fr_Drawer, 299);
		AddPart(filebuffer, req->fr_File, 299);
		
		retval = filebuffer;
		
	    } /* if (AslRequest(req, NULL) */
	    
	    FreeAslRequest(req);
	    
	} /* if (req) */
	
	CloseLibrary(AslBase);
	
    } /* if (AslBase) */
    
    return retval;
}

void GUI_to_Prefs(void) 
{
    char *buf;
    LONG customdevice = FALSE, colorvalue = FALSE, flagvalue=FALSE;
    UWORD flags = 0;
    UBYTE color = 0;
    LONG value = 0;
    
    getstring(ST_PrtName,  &buf);
    if (strlen(buf)>0) {
      strncpy(printertxtprefs.pt_Driver, buf, 30);
    }
    getcycle(CY_PrtPort,   &value);
    printertxtprefs.pt_Port = (UBYTE)value;  
   
    getcycle(CY_PaperType, &value);
    printertxtprefs.pt_PaperType = (UWORD)value; 
    
    getcycle(CY_PaperFmt,  &value);
    printertxtprefs.pt_PaperSize = (UWORD)value;
    
    getstring(NM_Length,   &buf);
    if (strlen(buf)>0) {
      printertxtprefs.pt_PaperLength = atoi(buf);
    }
    getcycle(CY_PrtPitch,  &value);
    printertxtprefs.pt_Pitch = (UWORD)value;
    
    getcycle(CY_PrtSpace,  &value);
    printertxtprefs.pt_Spacing = (UWORD)value;
    
    getstring(NM_Left,     &buf);
    if (strlen(buf)>0)
      printertxtprefs.pt_LeftMargin = atoi(buf);
    
    getstring(NM_Right,    &buf);
    if (strlen(buf)>0)
      printertxtprefs.pt_RightMargin = atoi(buf);
    
    getcycle(CY_PrtQuality, &value);
    printertxtprefs.pt_Quality = (UWORD)value;
    
    getcheckmark(CM_Custom, &customdevice);
    if ((BOOL)customdevice) {
      printerunitprefs.pu_UnitNum = 0;
      printerunitprefs.pu_OpenDeviceFlags = 0;
      getstring(ST_PortDevice, &buf);
      if (strlen(buf)>0) {
        strncpy(printerunitprefs.pu_DeviceName, buf, 32);
      }
      getstring(NM_PortUnit,   &buf);
      if (strlen(buf)>0)
        printerunitprefs.pu_UnitNum = atoi(buf);
    } else {
      printerunitprefs.pu_UnitNum = 0;
      printerunitprefs.pu_OpenDeviceFlags = 0;
      strncpy(printerunitprefs.pu_DeviceName, "", 32);
      printerunitprefs.pu_UnitNum = 0;
    }
    
    getcycle(CY_Aspect, &value);
    printergfxprefs.pg_Aspect = (UWORD)value;
    
    getcycle(CY_Shade,  &value);
    printergfxprefs.pg_Shade = (UWORD)value;
    
    getcycle(CY_Image,  &value);
    printergfxprefs.pg_Image = (UWORD)value;
   
    getslider(SL_Threshold, &value);
    printergfxprefs.pg_Threshold = (WORD)value;
   
    /* CM_Red + CM_Green + CM_Blue */
    getcheckmark(CM_Red, &colorvalue);
    if ((BOOL)colorvalue) {
      color += PCCF_RED;
    }
    getcheckmark(CM_Green, &colorvalue);
   if ((BOOL)colorvalue) {
      color += PCCF_GREEN;
    }
    getcheckmark(CM_Blue, &colorvalue);
    if ((BOOL)colorvalue) {
      color += PCCF_BLUE;
    }
    printergfxprefs.pg_ColorCorrect = color;
   
    getcycle(CY_Limits, &value);
    printergfxprefs.pg_Dimensions = (UBYTE)value;
    
    getcycle(CY_Dither, &value);
    printergfxprefs.pg_Dithering = (UBYTE)value;
    
    /* Set Graphics Flags */
    get(CM_Center, MUIA_Selected, &flagvalue);
    if ((BOOL)flagvalue) 
      flags += PGFF_CENTER_IMAGE;
    get(CM_Smooth, MUIA_Selected, &flagvalue);
    if ((BOOL)flagvalue)   
      flags += PGFF_ANTI_ALIAS;
    get(CY_Scaling, MUIA_Cycle_Active, &flagvalue);
    if ((BOOL)flagvalue)
      flags += PGFF_INTEGER_SCALING;
    printergfxprefs.pg_GraphicFlags = flags;
       
    getslider(SL_Density, &value);
    printergfxprefs.pg_PrintDensity = (UBYTE)value;
    
    getstring(NM_Width,   &buf);
    if (strlen(buf)>0)
      printergfxprefs.pg_PrintMaxWidth = atoi(buf);
    
    getstring(NM_Height,  &buf);
    if (strlen(buf)>0)
      printergfxprefs.pg_PrintMaxHeight = atoi(buf);
    
    getstring(NM_LeftEdge, &buf);
    if (strlen(buf)>0)
      printergfxprefs.pg_PrintXOffset = atoi(buf);
    
    printergfxprefs.pg_PrintYOffset = 0;    
}

void Prefs_to_GUI(void)
{
    char buf[50];
    UWORD flags;
    UBYTE color;
    
/*    set(LV_Directory, MUIA_Selected, printertxtprefs.pt_Driver); */
    setstring(ST_PrtName, printertxtprefs.pt_Driver);
    setcycle(CY_PrtPort,  printertxtprefs.pt_Port);
    setcycle(CY_PaperType, printertxtprefs.pt_PaperType);
    setcycle(CY_PaperFmt, printertxtprefs.pt_PaperSize);
    sprintf(buf,"%d", printertxtprefs.pt_PaperLength);
    setstring(NM_Length, buf);
    setcycle(CY_PrtPitch, printertxtprefs.pt_Pitch);
    setcycle(CY_PrtSpace, printertxtprefs.pt_Spacing);
    sprintf(buf, "%d", printertxtprefs.pt_LeftMargin);
    setstring(NM_Left, buf);
    sprintf(buf, "%d", printertxtprefs.pt_RightMargin);
    setstring(NM_Right,  buf);
    setcycle(CY_PrtQuality, printertxtprefs.pt_Quality);
    
    if (strlen(printerunitprefs.pu_DeviceName) > 1) {
      /* Enable the input boxes */
      set(ST_PortDevice, MUIA_Disabled, FALSE);
      set(NM_PortUnit, MUIA_Disabled, FALSE);
      customdev = FALSE; /* Custom boxes are not disabled */
      /* Set values in boxes */ 
      setcheckmark(CM_Custom, TRUE);
      setstring(ST_PortDevice, printerunitprefs.pu_DeviceName);
      sprintf(buf, "%d", printerunitprefs.pu_UnitNum);
      setstring(NM_PortUnit, buf);
    } else {
      set(ST_PortDevice, MUIA_Disabled, TRUE);
      set(NM_PortUnit, MUIA_Disabled, TRUE);
      customdev = TRUE; /* Custom boxes are not disabled */
    }
    setcycle(CY_Aspect, printergfxprefs.pg_Aspect);
    setcycle(CY_Shade,  printergfxprefs.pg_Shade);
    setcycle(CY_Image,  printergfxprefs.pg_Image);
   
    setslider(SL_Threshold, printergfxprefs.pg_Threshold);
   
    /* CM_Red + CM_Green + CM_Blue */
    color = printergfxprefs.pg_ColorCorrect;
    if ((color & PCCF_RED) == PCCF_RED) 
      setcheckmark (CM_Red, TRUE);    
    if ((color & PCCF_GREEN) == PCCF_GREEN) 
      setcheckmark(CM_Green, TRUE);
    if ((color & PCCF_BLUE) == PCCF_BLUE) 
      setcheckmark(CM_Blue, TRUE);

    setcycle(CY_Limits, printergfxprefs.pg_Dimensions);
    setcycle(CY_Dither, printergfxprefs.pg_Dithering);
    
    /* Set Graphics Flags */
    flags = printergfxprefs.pg_GraphicFlags;
    if ((flags & PGFF_CENTER_IMAGE) == PGFF_CENTER_IMAGE)
         setcheckmark(CM_Center, TRUE);
    else
         setcheckmark(CM_Center, FALSE);
    if ((flags & PGFF_ANTI_ALIAS) == PGFF_ANTI_ALIAS) 
       setcheckmark(CM_Smooth, TRUE);
    else
       setcheckmark(CM_Smooth, FALSE);   
    if ((flags & PGFF_INTEGER_SCALING) == PGFF_INTEGER_SCALING)   
       setcycle(CY_Scaling, 1); /* Integer scaling */
    else 
       setcycle(CY_Scaling, 0); /* Fraction scaling */
       
    setslider(SL_Density, printergfxprefs.pg_PrintDensity);
    sprintf(buf, "%d", printergfxprefs.pg_PrintMaxWidth);
    setstring(NM_Width, buf);
    sprintf(buf, "%d", printergfxprefs.pg_PrintMaxHeight);
    setstring(NM_Height, buf);
    sprintf(buf, "%d", printergfxprefs.pg_PrintXOffset);
    setstring(NM_LeftEdge, buf);   
}
