/*
  Name: Locale.c
  Author: Peter Hutchison
  Project: Printer
*/

#define CATCOMP_ARRAY
#include "global.h"
#include "strings.h"

struct Catalog  *catalog;
struct List country_list, language_list, pref_language_list;

#ifdef __AROS__
#define LOCALE_VER 50
#else
#define LOCALE_VER 39
#endif

/*********************************************************************************************/

void InitLocale(STRPTR catname, ULONG version)
{
    #ifdef __SASC
    LocaleBase = (struct Library *)OpenLibrary("locale.library", LOCALE_VER);
    #else
    LocaleBase = (struct LocaleBase *)OpenLibrary("locale.library", LOCALE_VER);
    #endif

    if (LocaleBase)
    {
       catalog = OpenCatalog(NULL, catname, OC_Version, version,
                         TAG_DONE);
    } else {
       catalog = NULL;
    }
}

/*********************************************************************************************/

void CleanupLocale(void)
{
    if (catalog) CloseCatalog(catalog);
    if (LocaleBase) CloseLibrary((struct Library *)LocaleBase);
}

/*********************************************************************************************/

char* MSG(ULONG id)
{
    char msg[30];
    if (LocaleBase != NULL && catalog != NULL)
    {
        strcpy(msg, GetCatalogStr(catalog, id, CatCompArray[id].cca_Str));
        if (strlen(msg)>0)
          return (char *)msg;
        else {   
         return CatCompArray[id].cca_Str;
    }
    else
    {
        return (char *)CatCompArray[id].cca_Str;
    }
}

