/* test ttengine */

#define __NOLIBBASE__

#include <proto/dos.h>
#include <proto/exec.h>
#include <proto/intuition.h>
#include <proto/graphics.h>
#include <proto/ttengine.h>
#include <proto/asl.h>
#include <proto/muimaster.h>
#include <proto/utility.h>

#include <libraries/ttengine.h>
#include <libraries/mui.h>

#define DRAW_LOW_HALF   32
#define DRAW_HIGH_HALF  160
#define DRAW_NORMAL     0
#define DRAW_INVERSED   1

#define FONT_SIZE       32
#define TABLE_COLS      16
#define TABLE_ROWS      6
#define TABLE_WIDTH     FONT_SIZE * TABLE_COLS + TABLE_COLS + 1

#ifdef __AROS__
#define reg(x) x
#define __saveds
#define xget XGET
#define xset set
#else
#define reg(x) __asm(#x)
#endif

extern struct Library *SysBase, *DOSBase;

struct Library *TTEngineBase, *IntuitionBase, *GfxBase, *AslBase,
  *MUIMasterBase, *UtilityBase;

struct MUI_CustomClass *charfield_mcc;

UBYTE WinName[256];

const STRPTR ISO_Labels[] = {"ISO-8859-1", "ISO-8859-2", "ISO-8859-3",
  "ISO-8859-4", "ISO-8859-5", "ISO-8859-6", "ISO-8859-7", "ISO-8859-8",
  "ISO-8859-9", "ISO-8859-10", "ISO-8859-11", "ISO-8859-13", "ISO-8859-14",
  "ISO-8859-15", "ISO-8859-16", NULL};

const LONG IANA_Numbers[] = {
  TT_Encoding_ISO8859_1,
  TT_Encoding_ISO8859_2,
  TT_Encoding_ISO8859_3,
  TT_Encoding_ISO8859_4,
  TT_Encoding_ISO8859_5,
  TT_Encoding_ISO8859_6,
  TT_Encoding_ISO8859_7,
  TT_Encoding_ISO8859_8,
  TT_Encoding_ISO8859_9,
  TT_Encoding_ISO8859_10,
  TT_Encoding_ISO8859_11,
  TT_Encoding_ISO8859_13,
  TT_Encoding_ISO8859_14,
  TT_Encoding_ISO8859_15,
  TT_Encoding_ISO8859_16};


struct AppData
  {
    Object *app;
    Object *win;
    Object *hfb;
    Object *lnb;
    Object *chf;
    Object *cyc;
    Object *mgr;
    Object *group2;
    APTR ttfont;
    STRPTR fontname;
  };

struct charfield_data
  {
    APTR ttfont;
    UBYTE startch;
    WORD cellh;
    WORD mtop;
    LONG encoding;
  };

#define CHFA_Font       0x6EDA0001
#define CHFA_StartChar  0x6EDA0002
#define CHFA_Encoding   0x6EDA0003

static STRPTR get_font_name(STRPTR);
static VOID free_font_name(STRPTR);

/*--------------------------------------------------------------------------*/

#ifdef __AROS__
AROS_UFH3S(LONG, load_font_hook,
AROS_UFHA(struct Hook *, h, A0),
AROS_UFHA(Object *, app, A2),
AROS_UFHA(STRPTR *, path, A1))
{
    AROS_USERFUNC_INIT
#else
__saveds LONG load_font_hook(struct Hook *h reg(a0), Object *app reg(a2), STRPTR *path reg(a1))
{
#endif
    struct AppData *ad;
    LONG current_codepage, current_half = DRAW_LOW_HALF;
    APTR new_font;

    if (!(*path)) return 10;
    ad = (struct AppData*)xget(app, MUIA_UserData);
    if (new_font = TT_OpenFont(
      TT_FontFile, (ULONG)*path,
      TT_FontSize, 24,
    TAG_END))
      {
        if (ad->ttfont) TT_CloseFont(ad->ttfont);
        ad->ttfont = new_font;
        current_codepage = xget(ad->cyc, MUIA_Cycle_Active);
        if (xget(ad->hfb, MUIA_Selected)) current_half = DRAW_HIGH_HALF;
        DoMethod(ad->mgr, MUIM_Group_InitChange);
        DoMethod(ad->mgr, OM_REMMEMBER, ad->chf);
        DoMethod(ad->mgr, OM_REMMEMBER, ad->group2);
        MUI_DisposeObject(ad->chf);
        if (ad->chf = NewObject(charfield_mcc->mcc_Class, NULL,
          CHFA_Font, (ULONG)ad->ttfont,
          MUIA_Frame, MUIV_Frame_ReadList,
          MUIA_Background, MUII_BACKGROUND,
        TAG_END))
          {
            SetAttrs(ad->chf,
              CHFA_StartChar, current_half,
              CHFA_Encoding, current_codepage,
            TAG_END);
            DoMethod(ad->mgr, OM_ADDMEMBER, ad->chf);
          }
        DoMethod(ad->mgr, OM_ADDMEMBER, ad->group2);
        DoMethod(ad->mgr, MUIM_Group_ExitChange);
      }
    return 0;
#ifdef __AROS__
    AROS_USERFUNC_EXIT
#endif
  }

struct Hook h_load_font = {NULL, NULL, (HOOKFUNC)load_font_hook, NULL, NULL};

const struct MUI_Command RexxCommds[] = {
  {"LoadFont", "FONTNAME/A", 1, &h_load_font},
  {NULL, NULL, 0, NULL}};

/*--------------------------------------------------------------------------*/

#ifdef __AROS__
AROS_UFH3S(LONG, change_encoding_hook,
AROS_UFHA(struct Hook *, h, A0),
AROS_UFHA(Object *, app, A2),
AROS_UFHA(LONG *, encoding, A1))
{
    AROS_USERFUNC_INIT
#else
__saveds LONG change_encoding_hook(struct Hook *h reg(a0), Object *app reg(a2),
 LONG *encoding reg(a1))
  {
#endif
    struct AppData *ad;

    ad = (struct AppData*)xget(app, MUIA_UserData);
    xset(ad->chf, CHFA_Encoding, *encoding);
    return 0;
#ifdef __AROS__
    AROS_USERFUNC_EXIT
#endif
  }

struct Hook h_change_encoding = {NULL, NULL, (HOOKFUNC)change_encoding_hook, NULL, NULL};

/*--------------------------------------------------------------------------*/

#ifdef __AROS__
AROS_UFH3S(LONG, change_half_hook,
AROS_UFHA(struct Hook *, h, A0),
AROS_UFHA(Object *, app, A2),
AROS_UFHA(LONG *, half, A1))
{
    AROS_USERFUNC_INIT
#else
__saveds LONG change_half_hook(struct Hook *h reg(a0), Object *app reg(a2),
 LONG *half reg(a1))
  {
#endif
    struct AppData *ad;

    ad = (struct AppData*)xget(app, MUIA_UserData);
    xset(ad->chf, CHFA_StartChar, *half);
    return 0;
#ifdef __AROS__
    AROS_USERFUNC_EXIT
#endif
  }

struct Hook h_change_half = {NULL, NULL, (HOOKFUNC)change_half_hook, NULL, NULL};

/*--------------------------------------------------------------------------*/

#ifdef __AROS__
AROS_UFH3S(LONG, load_button_hook,
AROS_UFHA(struct Hook *, h, A0),
AROS_UFHA(Object *, app, A2),
AROS_UFHA(Msg, msg, A1))
{
    AROS_USERFUNC_INIT
#else
__saveds LONG load_button_hook(struct Hook *h reg(a0), Object *app reg(a2),
 Msg msg reg(a1))
  {
#endif
    struct AppData *ad;
    STRPTR newname;

    ad = (struct AppData*)xget(app, MUIA_UserData);
    if (newname = get_font_name(ad->fontname))
      {
        free_font_name(ad->fontname);
        ad->fontname = newname;
        DoMethod(app, MUIM_CallHook, &h_load_font, ad->fontname);
      }
    return 0;
#ifdef __AROS__
    AROS_USERFUNC_EXIT
#endif
  }

struct Hook h_load_button = {NULL, NULL, (HOOKFUNC)load_button_hook, NULL, NULL};

/*--------------------------------------------------------------------------*/

VOID draw_char(Object *obj, WORD x, WORD y, LONG half, LONG inversion, WORD
  cellh, WORD ascend)
  {
    UBYTE chnum;
    WORD width;
    struct TextExtent te;
    struct RastPort *rp = _rp(obj);

    chnum = half + y * TABLE_COLS + x;
    TT_TextExtent(rp, &chnum, 1, &te);
    width = te.te_Extent.MaxX - te.te_Extent.MinX + 1;
    Move(rp, _mleft(obj) + x * (FONT_SIZE + 1) + ((FONT_SIZE - width) >> 1) -
      te.te_Extent.MinX + 1, _mtop(obj) + y * (cellh + 1) + ascend + 2);
    TT_Text(rp, &chnum, 1);
  }

/*--------------------------------------------------------------------------*/

VOID draw_charset(Object *obj, LONG half, WORD cellh, WORD asc)
  {
    WORD p, p2;
    struct RastPort *rp = _rp(obj);
    WORD table_x = _mleft(obj);
    WORD table_y = _mtop(obj);

    SetAPen(rp, 1);
    for (p = 1; p < TABLE_COLS; p++)
      {
        p2 = table_x + p * (FONT_SIZE + 1);
        Move(rp, p2, table_y + 1);
        Draw(rp, p2, table_y + cellh * TABLE_ROWS + TABLE_ROWS - 1);
      }

    for (p = 1; p < TABLE_ROWS; p++)
      {
        p2 = table_y + p * (cellh + 1) + 1;
        Move(rp, table_x + 1, p2);
        Draw(rp, table_x + TABLE_WIDTH - 2, p2);
      }

    SetDrMd(rp, JAM1);
    for (p = 0; p < TABLE_COLS; p++)
      {
        for (p2 = 0; p2 < TABLE_ROWS; p2++)
          draw_char(obj, p, p2, half, DRAW_NORMAL, cellh, asc);
      }
  }

/*--------------------------------------------------------------------------*/

#ifdef __AROS__
BOOPSI_DISPATCHER(LONG,charfield_mcc_disp,cl,obj,msg)
#else
__saveds LONG charfield_mcc_disp(Class *cl reg(a0), Object *obj reg(a2), Msg msg reg(a1))
#endif
  {
    switch (msg->MethodID)
      {
        case MUIM_Show:
          {
            struct charfield_data *d = INST_DATA(cl, obj);

            DoSuperMethodA(cl, obj, msg);
            TT_SetFont(_rp(obj), d->ttfont);
            TT_SetAttrs(_rp(obj),
              TT_Window, (ULONG)_window(obj),
              TT_Encoding, d->encoding,
            TAG_END);
            return TRUE;
          }

        case MUIM_Hide:
          {
            TT_DoneRastPort(_rp(obj));
            return DoSuperMethodA(cl, obj, msg);
          }

        case MUIM_Draw:
          {
            struct charfield_data *d = INST_DATA(cl, obj);

            DoSuperMethodA(cl, obj, msg);
            TT_SetAttrs(_rp(obj),
              TT_Encoding, d->encoding,
            TAG_END);
            draw_charset(obj, d->startch, d->cellh, d->mtop);
            return 0;
          }

        case MUIM_AskMinMax:
          {
            struct MUIP_AskMinMax *msg2 = (struct MUIP_AskMinMax*)msg;
            struct charfield_data *d = INST_DATA(cl, obj);
            LONG mt, mb;
            struct Screen *s = _screen(obj);

            DoSuperMethodA(cl, obj, msg);

            TT_SetFont(&s->RastPort, d->ttfont);
            TT_GetAttrs(&s->RastPort,
              TT_FontMaxTop, (ULONG)&mt,
              TT_FontMaxBottom, (ULONG)&mb,
            TAG_END);
            TT_DoneRastPort(&s->RastPort);

            d->cellh = mt + mb + 2;
            d->mtop = mt;

            msg2->MinMaxInfo->MinWidth += TABLE_WIDTH;
            msg2->MinMaxInfo->DefWidth += TABLE_WIDTH;
            msg2->MinMaxInfo->MaxWidth += TABLE_WIDTH;

            msg2->MinMaxInfo->MinHeight += (d->cellh + 1) * TABLE_ROWS + 1;
            msg2->MinMaxInfo->DefHeight += (d->cellh + 1) * TABLE_ROWS + 1;
            msg2->MinMaxInfo->MaxHeight += (d->cellh + 1) * TABLE_ROWS + 1;

            return 0;
          }

        case MUIM_Setup:
          {
            struct charfield_data *d = INST_DATA(cl, obj);
            struct Screen *s = _screen(obj);
            STRPTR fn;

            if (!(DoSuperMethodA(cl, obj, msg))) return FALSE;
            TT_SetFont(&s->RastPort, d->ttfont);
            TT_GetAttrs(&s->RastPort,
              TT_FontName, (ULONG)&fn,
            TAG_END);
            strcpy(WinName, "ViewISO 1.1 - ");
            strncpy(&WinName[14], fn, 240);
            SetAttrs(_win(obj),
              MUIA_Window_Title, (ULONG)WinName,
            TAG_END);
            TT_DoneRastPort(&s->RastPort);
            return TRUE;
          }

        case OM_NEW:
          {
            struct opSet *msg2 = (struct opSet*)msg;
            struct charfield_data *d;

            if (obj = (Object*)DoSuperMethodA(cl, obj, msg))
              {
                d = INST_DATA(cl, obj);
                d->ttfont = (APTR)GetTagData(CHFA_Font, NULL, msg2->ops_AttrList);
                d->startch = (UBYTE)GetTagData(CHFA_StartChar, 32,
                  msg2->ops_AttrList);
                d->encoding = TT_Encoding_ISO8859_1;
                return (LONG)obj;
              }
            else return NULL;
          }

        case OM_SET:
          {
            struct TagItem *tag, *ptr;
            struct opSet *msg2 = (struct opSet*)msg;
            struct charfield_data *d = INST_DATA(cl, obj);

            DoSuperMethodA(cl, obj, msg);

            ptr = msg2->ops_AttrList;

            while (tag = NextTagItem(&ptr))
              {
                switch (tag->ti_Tag)
                  {
                    case CHFA_StartChar:
                      {
                        d->startch = tag->ti_Data;
                        MUI_Redraw(obj, MADF_DRAWOBJECT);
                      }
                    break;

                    case CHFA_Encoding:
                      {
                        LONG e;
                        e = IANA_Numbers[tag->ti_Data];
                        if (e != d->encoding)
                          {
                            d->encoding = e;
                            MUI_Redraw(obj, MADF_DRAWOBJECT);
                          }
                      }
                    break;
                  }
              }
            return 0;
          }

        default: return DoSuperMethodA(cl, obj, msg);
      }
#ifdef __AROS__
    BOOPSI_DISPATCHER_END
#endif
  }

/*--------------------------------------------------------------------------*/

STRPTR get_fontname_from_commandline(VOID)
  {
    LONG params;
    STRPTR name = NULL;
    struct RDArgs *args;

    if (args = ReadArgs("FONTNAME/A", &params, NULL))
      {
        if (name = AllocVec(strlen((STRPTR)params) + 1, MEMF_ANY))
          strcpy(name, (STRPTR)params);
        FreeArgs(args);
      }
    return name;
  }

/*--------------------------------------------------------------------------*/

static STRPTR get_font_name(STRPTR current_name)
  {
    struct FileRequester *freq;
    STRPTR name = NULL;
    UBYTE path[256];

    if (current_name)
      {
        strncpy(path, current_name, 255);
        *PathPart(path) = 0x00;
      }
    else strcpy(path, "FONTS:");

    if (freq = AllocAslRequestTags(ASL_FileRequest, TAG_END))
      {
        if (AslRequestTags(freq,
          ASLFR_TitleText, (ULONG)"Select TrueType font",
          ASLFR_InitialDrawer, (ULONG)path,
          ASLFR_DoPatterns, TRUE,
          ASLFR_InitialPattern, (ULONG)"#?.ttf",
          ASLFR_RejectIcons, TRUE,
          TAG_END))
          {
            ULONG namelen = strlen(freq->fr_File) + strlen(freq->fr_Drawer)
              + 4;

            if (name = AllocVec(namelen + 1, MEMF_ANY | MEMF_CLEAR))
              {
                strncpy(name, freq->fr_Drawer, namelen);
                AddPart(name, freq->fr_File, namelen);
              }
          }
        FreeAslRequest(freq);
      }
    return name;
  }

/*--------------------------------------------------------------------------*/

static VOID free_font_name(STRPTR name)
  {
    if (name) FreeVec(name);
  }

/*--------------------------------------------------------------------------*/

BOOL open_libs(VOID)
  {
    if (!(GfxBase = OpenLibrary("graphics.library", 39))) return FALSE;
    if (!(IntuitionBase = OpenLibrary("intuition.library", 39)))
      return FALSE;
    if (!(AslBase = OpenLibrary("asl.library", 38))) return FALSE;
    if (!(TTEngineBase = OpenLibrary("ttengine.library", 5))) return FALSE;
    if (!(MUIMasterBase = OpenLibrary("muimaster.library", 19))) return FALSE;
    if (!(UtilityBase = OpenLibrary("utility.library", 39))) return FALSE;
    return TRUE;
  }

/*--------------------------------------------------------------------------*/

VOID close_libs(VOID)
  {
    if (UtilityBase) CloseLibrary(UtilityBase);
    if (MUIMasterBase) CloseLibrary(MUIMasterBase);
    if (TTEngineBase) CloseLibrary(TTEngineBase);
    if (AslBase) CloseLibrary(AslBase);
    if (IntuitionBase) CloseLibrary(IntuitionBase);
    if (GfxBase) CloseLibrary(GfxBase);
    return;
  }

/*--------------------------------------------------------------------------*/

Object *build_gui(struct AppData *app)
  {
    Object *a;

    a = MUI_NewObject(MUIC_Application,
      MUIA_Application_Author, (ULONG)"Grzegorz \"Krashan\" Kraszewski",
      MUIA_Application_Base, (ULONG)"VIEWISO",
      MUIA_Application_Description, (ULONG)"ISO-8859 charsets viewer",
      MUIA_Application_Title, (ULONG)"ViewISO",
      MUIA_Application_Version, (ULONG)"$VER: ViewISO 1.1 (30.12.2002)",
      MUIA_Application_Commands, (ULONG)&RexxCommds,
      MUIA_UserData, (ULONG)app,
      MUIA_Application_Window, app->win = MUI_NewObject(MUIC_Window,
        MUIA_Window_Title, (ULONG)"ViewISO 1.1",
        MUIA_Window_ID, 0x5649534F,
        MUIA_Window_RootObject, app->mgr = MUI_NewObject(MUIC_Group,
          MUIA_Group_Child, app->chf = NewObject(charfield_mcc->mcc_Class, NULL,
            CHFA_Font, (ULONG)app->ttfont,
            MUIA_Frame, MUIV_Frame_ReadList,
            MUIA_Background, MUII_BACKGROUND,
          TAG_END),
          MUIA_Group_Child, app->group2 = MUI_NewObject(MUIC_Group,
            MUIA_Group_Horiz, TRUE,
            MUIA_Group_Child, app->cyc = MUI_NewObject(MUIC_Cycle,
              MUIA_Cycle_Entries, (ULONG)ISO_Labels,
              MUIA_CycleChain, TRUE,
            TAG_END),
            MUIA_Group_Child, app->hfb = MUI_NewObject(MUIC_Text,
              MUIA_Text_Contents, (ULONG)"\33cUpper half",
              MUIA_Frame, MUIV_Frame_Button,
              MUIA_Font, MUIV_Font_Button,
              MUIA_Background, MUII_ButtonBack,
              MUIA_CycleChain, TRUE,
              MUIA_Text_HiChar, 'u',
              MUIA_ControlChar, 'u',
              MUIA_InputMode, MUIV_InputMode_Toggle,
            TAG_END),
            MUIA_Group_Child, app->lnb = MUI_NewObject(MUIC_Text,
              MUIA_Text_Contents, (ULONG)"\33cLoad",
              MUIA_Frame, MUIV_Frame_Button,
              MUIA_Font, MUIV_Font_Button,
              MUIA_Background, MUII_ButtonBack,
              MUIA_CycleChain, TRUE,
              MUIA_Text_HiChar, 'l',
              MUIA_ControlChar, 'l',
              MUIA_InputMode, MUIV_InputMode_RelVerify,
            TAG_END),
          TAG_END),
        TAG_END),
      TAG_END),
    TAG_END);

    app->app = a;

    return a;
  }

/*--------------------------------------------------------------------------*/

VOID notifications(struct AppData *app)
  {
    DoMethod(app->win, MUIM_Notify, MUIA_Window_CloseRequest, MUIV_EveryTime,
      app->app, 2, MUIM_Application_ReturnID, MUIV_Application_ReturnID_Quit);
    DoMethod(app->hfb, MUIM_Notify, MUIA_Selected, TRUE, app->app, 3,
      MUIM_CallHook, &h_change_half, DRAW_HIGH_HALF);
    DoMethod(app->hfb, MUIM_Notify, MUIA_Selected, FALSE, app->app, 3,
      MUIM_CallHook, &h_change_half, DRAW_LOW_HALF);
    DoMethod(app->cyc, MUIM_Notify, MUIA_Cycle_Active, MUIV_EveryTime, app->app,
      3, MUIM_CallHook, &h_change_encoding, MUIV_TriggerValue);
    DoMethod(app->lnb, MUIM_Notify, MUIA_Pressed, FALSE, app->app,
      2, MUIM_CallHook, &h_load_button);
  }

/*--------------------------------------------------------------------------*/

VOID main_loop(struct AppData *app)
  {
    ULONG signals;

    SetAttrs(app->win, MUIA_Window_Open, TRUE, TAG_END);

    while (DoMethod(app->app, MUIM_Application_NewInput, &signals) !=
      MUIV_Application_ReturnID_Quit)
      {
        if (signals)
          {
            signals = Wait(signals | SIGBREAKF_CTRL_C);
            if (signals & SIGBREAKF_CTRL_C) break;
          }
      }

    SetAttrs (app->win, MUIA_Window_Open, FALSE, TAG_END);
    return;
  }

/*--------------------------------------------------------------------------*/

#ifdef __AROS__
int main(void)
#else
int Main (void)
#endif
  {
    struct AppData app;
    STRPTR fontname;

    if (open_libs())
      {
        app.fontname = get_fontname_from_commandline();
        if (!app.fontname) app.fontname = get_font_name(app.fontname);
        if (app.fontname)
          {
            if (app.ttfont = TT_OpenFont(
              TT_FontFile, (ULONG)app.fontname,
              TT_FontSize, 24,
            TAG_END))
              {
                if (charfield_mcc = MUI_CreateCustomClass(NULL, MUIC_Area,
                  NULL, sizeof(struct charfield_data), charfield_mcc_disp))
                  {
                    Object *appobj;

                    if (appobj = build_gui(&app))
                      {
                        notifications(&app);
                        main_loop(&app);
                        MUI_DisposeObject(appobj);
                      }
                    MUI_DeleteCustomClass(charfield_mcc);
                  }
                TT_CloseFont(app.ttfont);
              }
            free_font_name(app.fontname);
          }
      }
    close_libs();
    return 0;
  }
