
DEVICES_PRINTER_I   EQU $BAD       ; exclude a buggy header file

                    incdir         "include:"
                    include        "exec/execbase.i"
                    include        "exec/initializers.i"
                    include        "exec/lists.i"
                    include        "exec/memory.i"
                    include        "exec/resident.i"
                    include        "dos/var.i"
                    include        "dos/dosextens.i"
                    include        "datatypes/datatypesclass.i"
                    include        "graphics/gfx.i"
                    include        "graphics/gfxbase.i"
                    include        "graphics/rpattr.i"
                    include        "graphics/view.i"
                    include        "intuition/classusr.i"
                    include        "intuition/screens.i"
                    include        "workbench/icon.i"
                    include        "workbench/workbench.i"
                    include        "lvo/LVOs.i"
                    include        "lvo/cybergraphics_lib.i"
                    include        "cybergraphics/cybergraphics.i"

_LVOPrivateOpenLibrary  EQU -$32A  ; _LVOexecPrivate17
                                   ; gfxbase   D0 =  1
                                   ; layerbase D0 =  2
                                   ; intuibase D0 =  3
                                   ; dosbase   D0 =  4
                                   ; iconbase  D0 =  5
                                   ; expanbase D0 =  6
                                   ; utilbase  D0 =  7
                                   ; keymap    D0 =  8
                                   ; gadtools  D0 =  9
                                   ; wbbase    D0 = 10

ICONGETA_NoNewIcons     EQU (ICONA_Dummy+76)   ; $8000904C = ICONA_Reserved3

; MACHINE 68000

RLEjit            EQU 1          ; delaying second image RLE decompression

; smurf             EQU 0          ; special lite version with line drawing
     ifnd smurf
WB47fix           EQU 1          ; temporary fix for WB v47 update crashes

IDtype            EQU 1          ; support the IdentifyBuffer as hook tag

DTtype            EQU 1          ; use the DataType system to identify files
     endif   

 ifgt (__CPU-68000)

MC68020           EQU 1
     ifd smurf
LineD             EQU 1          ; line by line direct drawing on gfx-card
     else
Scalers           EQU 1          ; upscaling, downscaling and grayscales 
     endif
 endif

Alert               MACRO                              ; USAGE: Alert source
                    MOVE.L         \1,-(SP)            ; Just replace source
                    MOVEM.L        D0-D1/D7/A0-A1/A6,-(SP)
                    MOVE.L         $18(SP),D7          ; with what you want
                    BCLR           #31,D7              ; to be displayed as
                    MOVEA.L        (4).w,A6            ; a recoverable Alert
                    JSR            _LVOAlert(A6)       ; D0, (A0), #$BADC0DE
                    MOVEM.L        (SP)+,D0-D1/D7/A0-A1/A6
                    ADDQ.W         #4,SP               ; won't restore flags
                    ENDM

Count               MACRO
                    BRA.S          .skipcounter\@
                    DC.L           $ADD1C0CA           ; search it in memory
.countpasses\@      DC.L           0
.skipcounter\@      ADDQ.L         #1,.countpasses\@
                    ENDM

MoveOddLong         MACRO                              ; 68k MOVE.L (Ax)+,Dy
                    MOVE.B         (\1)+,-(SP)
                    MOVE.W         (SP)+,\2
                    MOVE.B         (\1)+,\2
                    SWAP           \2
                    MOVE.B         (\1)+,-(SP)
                    MOVE.W         (SP)+,\2
                    MOVE.B         (\1)+,\2
                    ENDM

;---------------------------------------------------------------------------

CodeStart                          ; Structure infos are appended at the end
                    RTS            ; =======================================

ROMTag              DC.W           RTC_MATCHWORD
                    DC.L           ROMTag
                    DC.L           EndCode
                    DC.B           RTF_AUTOINIT
 ifd MC68020
                    DC.B           46            ; rt_Ver
 else
                    DC.B           47            ; for OS 3.2 and 68000 CPU
 endif
                    DC.B           NT_LIBRARY
                    DC.B           -120          ; rt_Pri
                    DC.L           LibName
                    DC.L           LibId
                    DC.L           LibInit

LibInit
 ifd MC68020
                    DC.L           10000         ; MoreLibSpace or zlib buffer
 else
                    DC.L           2944
 endif
                    DC.L           FuncTable
                    DC.L           DataTable
                    DC.L           Init

FuncTable           DC.W           -1
                    DC.W           Open              - FuncTable
                    DC.W           Close             - FuncTable
                    DC.W           Expunge           - FuncTable
                    DC.W           Null              - FuncTable
                    DC.W           GetWBObject       - FuncTable ; iconPrivate1
                    DC.W           PutWBObject       - FuncTable ; iconPrivate2
                    DC.W           GetIcon           - FuncTable ; iconPrivate3
                    DC.W           PutIcon           - FuncTable ; iconPrivate4
                    DC.W           FreeFreeList      - FuncTable
                    DC.W           FreeWBObject      - FuncTable ; iconPrivate5
                    DC.W           AllocWBObject     - FuncTable ; iconPrivate6
                    DC.W           AddFreeList       - FuncTable
                    DC.W           GetDiskObject     - FuncTable
                    DC.W           PutDiskObject     - FuncTable
                    DC.W           FreeDiskObject    - FuncTable
                    DC.W           FindToolType      - FuncTable
                    DC.W           MatchToolValue    - FuncTable
                    DC.W           BumpRevision      - FuncTable
                    DC.W           FreeAlloc         - FuncTable ; iconPrivate7
                    DC.W           GetDefDiskObject  - FuncTable
                    DC.W           PutDefDiskObject  - FuncTable
                    DC.W           GetDiskObjectNew  - FuncTable
                    DC.W           DeleteDiskObject  - FuncTable ; last v37-v40
                    DC.W           FreeRemove        - FuncTable ; iconPrivate8
                    DC.W           DupDiskObjectA    - FuncTable
                    DC.W           IconControlA      - FuncTable
                    DC.W           DrawIconStateA    - FuncTable
                    DC.W           GetIconRectangleA - FuncTable
                    DC.W           NewDiskObject     - FuncTable
                    DC.W           GetIconTagList    - FuncTable
                    DC.W           PutIconTagList    - FuncTable
                    DC.W           LayoutIconA       - FuncTable
                    DC.W           ChangeToSelectedIconColor - FuncTable
                    DC.W           BumpRevisionLength        - FuncTable
                    DC.W           -1

DataTable           INITBYTE       LIB_FLAGS,LIBF_SUMUSED|LIBF_CHANGED
 ifd MC68020
                    INITWORD       LIB_REVISION,4           ; Mikes MNL-Fix needs 4
 else
                    INITWORD       LIB_REVISION,-1          ; for OS 3.2 and 68000
 endif
                    DC.W           $0

                    ;--------------------------------------------------------------

Init                MOVEM.L        A5-A6,-(SP)
                    MOVEA.L        D0,A5                    ; iconbase
                    CMPI.W         #39,LIB_VERSION(A6)      ; running on OS 3.0+ ?
                    BCS.S          .failure
                    BTST.B         #AFB_68020,AttnFlags+1(A6)
 ifd MC68020
                    BNE.S          .usethislibrary
                    LEA            LibName(PC),A1
                    JSR            _LVOFindResident(A6)
                    TST.L          D0                       ; resident icon.library?
                    BNE.S          .failure
                    LEA            LibDir68000(PC),A1
                    JSR            (_LVOOldOpenLibrary,A6)
 else
                    BEQ.S          .usethislibrary
                    MOVE.L         A0,-(SP)                 ; save segmentlist
                    LEA            LibName(PC),A1
                    JSR            _LVOFindResident(A6)
                    MOVEA.L        (SP)+,A0
                    TST.L          D0                       ; resident icon.library?
                    BNE.S          .usethislibrary          ; avoid recursive Open()
                    MOVE.L         A0,-(SP)                 ; save segmentlist
                    LEA            LibDir68020(PC),A1
                    JSR            (_LVOOldOpenLibrary,A6)
                    MOVEA.L        (SP)+,A0
                    TST.L          D0                       ; 68020/icon.library ?
                    BEQ.S          .usethislibrary
 endif
                    MOVEA.L        D0,A1
                    JSR            (_LVOCloseLibrary,A6)
.failure            BRA.W          freemem                  ; release wrong version

.usethislibrary     MOVEM.L        A0/A6,$22(A5)            ; segmentlist, execbase
                    MOVEQ          #4,D0                    ;              v36+
                    JSR            _LVOPrivateOpenLibrary(A6)
                    MOVE.L         D0,$2A(A5)               ; dosbase      v36+
                    MOVEQ          #7,D0
                    JSR            _LVOPrivateOpenLibrary(A6)
                    MOVE.L         D0,$2E(A5)               ; utilbase     v37+
                    MOVEQ          #1,D0
                    JSR            _LVOPrivateOpenLibrary(A6)
                    MOVE.L         D0,$32(A5)               ; gfxbase      v39+
                    MOVEQ          #3,D0
                    JSR            _LVOPrivateOpenLibrary(A6)
                    MOVE.L         D0,$36(A5)               ; intuibase    v36+
 ifd MC68020
                    LEA            string_MoreLibSpace(PC),A1
                    JSR            _LVOFindResident(A6)
                    TST.L          D0
                    SNE            $EE(A5)                  ; flag for MoreLibSpace
                    LEA            string_ArosLib(PC),A1
                    JSR            _LVOFindResident(A6)
 endif
                    MOVE.B         #%10101010,$EF(A5)       ; mask for 50 % ghosting
                    LEA            $A2+4(A5),A1             ; empty list for
                    MOVE.L         A1,-(A1)                 ; v44 DiskObjects
                    LEA            $A2+8(A5),A0
                    MOVE.L         A1,(A0)+
                    ADDQ.L         #1,(A0)+                 ; current dir undefined
                    ADDQ.W         #2,(A0)+                 ; rectangle delta width
                    ADDQ.W         #2,(A0)+                 ; rectangle delta height
                    ADDQ.W         #1,(A0)+                 ; GlobalEmbossRect MinX
                    ADDQ.W         #1,(A0)+                 ; GlobalEmbossRect MinY
                    ADDQ.W         #2,(A0)+                 ; SHINEPEN
                    ADDQ.W         #1,(A0)+                 ; SHADOWPEN
                    CLR.W          (A0)+                    ; BACKGROUNDPEN
 ifd MC68020
                    TST.L          D0                       ; result of FindResident
                    SNE            $ED(A5)                  ; flag for aros.library
 endif
.memoryattributes   ADDQ.L         #3,(A0)+                 ; MEMF_PUBLIC|MEMF_CHIP
                    ADDQ.W         #1,(A0)+                 ; GlobalFrameless TRUE
                    ADDQ.W         #1,(A0)+                 ; GlobalNewIconsSupport
                    ADDQ.W         #1,(A0)+                 ; GlobalColorIconSupport
                    MOVE.W         #25,(A0)+                ; GlobalMaxNameLength=25
                    MOVE.L         #$AAAAAA00,(A0)+         ; default
                    MOVE.L         #$0000FFFF,(A0)+         ; system
                    MOVE.L         #$FF6688BB,(A0)          ; colors
                    MOVEQ          #16,D0
                    MOVEQ          #MEMF_PUBLIC|MEMF_CHIP,D1
                    JSR            _LVOAllocVec(A6)
                    LEA            Dot_ImageData(PC),A0
                    LEA            $154+4(A5),A1            ; struct Dot_Image + 4
                    ADDQ.W         #8,(A1)+                 ; width
                    ADDQ.W         #8,(A1)+                 ; height
                    ADDQ.W         #1,(A1)+                 ; depth
                    MOVE.L         D0,(A1)                  ; image data
                    BNE.S          .dotimagetochipmem
                    MOVE.L         A0,(A1)                  ; no free chipmem !!
                    BRA.S          .setPlanePickOnOff       ; maybe we should quit

.dotimagetochipmem  MOVEA.L        D0,A1
                    MOVEQ          #16,D0                   ; copy Dot image data
                    BSR.W          CopyMemAligned
.setPlanePickOnOff  ADDQ.B         #1,$154+$E(A5)
                    LEA            $56A(A5),A0              ; top of distance table
                    LEA            $968(A5),A1              ; distance table bottom
                    MOVEQ          #0,D0
                    NOT.B          D0                       ; D0 = 255
.writedistancetable MOVE.L         D0,D1
                    MULU.W         D1,D1
                    MOVEA.L        D1,A6
                    MULU.W         D1,D1
                    CLR.W          D1
                    SWAP           D1
                    ADD.L          A6,D1
                    ADDQ.L         #7,D1
                    LSR.L          #3,D1                    ; x=(n^4/65536+n^2+7)/8
                    MOVE.W         D1,(A0)+                 ; store x
                    MOVE.W         D1,-(A1)                 ; store x
                    DBRA           D0,.writedistancetable
                    LEA            $3E(A5),A1               ; RastPort
                    MOVEA.L        $32(A5),A6               ; gfxbase
                    JSR            _LVOInitRastPort(A6)     ; for MakePlanarMask
                    MOVEQ          #0,D0                    ; APen
                    LEA            $3E(A5),A1               ; RastPort
                    JSR            _LVOSetAPen(A6)
                    MOVE.L         A5,D0                    ; iconbase
                    MOVEM.L        (SP)+,A5-A6
                    RTS

Open                ADDQ.W         #1,LIB_OPENCNT(A6)       ; no call by Workbench
                    BCLR.B         #LIBB_DELEXP,LIB_FLAGS(A6)
 ifd MC68020                                                ; needs Forbid() state !
                    MOVE.L         A5,-(SP)
                    MOVEA.L        A6,A5                    ; iconbase
                    MOVEA.L        $26(A5),A6               ; execbase
                    CMP.W          #4,LIB_OPENCNT(A5)
                    BHI.S          .checkforCyberGFX
                    LEA            string_FBlit(PC),A1
                    JSR            _LVOFindPort(A6)         ; is FBlit running ?
                    TST.L          D0
                    BEQ.S          .checkforCyberGFX
                    BCLR.B         #1,$C0+3(A5)             ; no ChipMem for FBlit
.checkforCyberGFX   TST.L          $120(A5)                 ; cgxbase ?
                    BNE.S          .checkforDOpus5
                    MOVEQ          #41,D0                   ; v41+
                    LEA            string_CyberGfxLib(PC),A1
                    TST.B          $ED(A5)                  ; aros.library found ?
                    BEQ.S          .openCGXlibrary
                    ADDQ.W         #4,A1                    ; skip the "NIL:"
.openCGXlibrary     JSR            _LVOOpenLibrary(A6)
                    MOVE.L         D0,$120(A5)              ; cgxbase
                    BEQ.S          .checkforDOpus5
                    BCLR.B         #1,$C0+3(A5)             ; no ChipMem for CGX
.checkforDOpus5     LEA            string_DirOpus(PC),A1
                    JSR            _LVOFindPort(A6)
                    TST.L          D0
                    BEQ.S          .setDOpus5process
                    MOVEA.L        D0,A0                    ; DOpus5 message port
                    MOVE.L         MP_SIGTASK(A0),D0
                    SCC            $978(A5)                 ; flag for other GUI
.setDOpus5process   MOVE.L         D0,$96C(A5)              ; DOpus5 process
                    BEQ.S          .checkforOpenGUI
                    MOVE.L         $DC(A5),D0               ; patchbase ?
                    BNE.S          .checkforOpenGUI
                    TST.L          $120(A5)                 ; cgxbase ?
                    BEQ.S          .checkforOpenGUI
                    BSR.W          installGfxPatch          ; needs A6 = execbase
.checkforOpenGUI    TST.B          $978(A5)                 ; any GUI running ?
                    BNE.S          .allcheckingdone
                    LEA            string_SCALOS(PC),A1
                    JSR            _LVOFindPort(A6)
                    TST.L          D0
                    SNE            $978(A5)                 ; flag for other GUI
                    BNE.S          .allcheckingdone
                    TST.L          $974(A5)                 ; test Workbench task
                    BEQ.S          .allcheckingdone
                    ADDQ.B         #1,$978(A5)              ; no other GUI used
.allcheckingdone
                    MOVEA.L        A5,A6
                    MOVEA.L        (SP)+,A5
 else ; MC68000
                    TST.B          $978(A6)                 ; any GUI running ?
                    BNE.S          .returniconbase
                    TST.L          $974(A6)                 ; test Workbench task
                    BEQ.S          .returniconbase
                    ADDQ.B         #1,$978(A6)              ; no other GUI used
 endif
.returniconbase     MOVE.L         A6,D0
                    RTS

Close               SUBQ.W         #1,LIB_OPENCNT(A6)
                    BNE.S          Null
                    BTST.B         #LIBB_DELEXP,LIB_FLAGS(A6)
                    BEQ.S          Null

Expunge             TST.W          LIB_OPENCNT(A6)
                    BEQ.S          kickout
                    BSET.B         #LIBB_DELEXP,LIB_FLAGS(A6)
Null                MOVEQ          #0,D0
                    RTS

closelibrary        MOVEA.L        (A5,D0.W),A1             ; D0 as word only
                    JMP            _LVOCloseLibrary(A6)

kickout             MOVEM.L        A5-A6,-(SP)
                    MOVEA.L        A6,A5                    ; iconbase
                    MOVEA.L        $26(A5),A6               ; execbase
setmefree           MOVEQ          #$2A,D0                  ; dosbase
                    BSR.S          closelibrary
                    MOVEQ          #$2E,D0                  ; utilbase
                    BSR.S          closelibrary
                    MOVEQ          #$32,D0                  ; gfxbase
                    BSR.S          closelibrary
                    MOVEQ          #$36,D0                  ; intuibase
                    BSR.S          closelibrary
 ifd DTtype
                    MOVE.W         #$11C,D0                 ; dtbase
                    BSR.S          closelibrary
 endif
 ifd MC68020
                    MOVE.W         #$120,D0                 ; cgxbase
                    BSR.S          closelibrary
 endif
                    LEA            Dot_ImageData(PC),A0
                    MOVEA.L        $154+$A(A5),A1           ; Dot image data
                    CMPA.L         A0,A1
                    BEQ.S          .removezlibbuffer
                    JSR            _LVOFreeVec(A6)
.removezlibbuffer   MOVEA.L        $970(A5),A1              ; the zlib buffer
                    JSR            _LVOFreeVec(A6)
                    MOVEA.L        A5,A1
                    MOVEA.L        (A1)+,A0
                    MOVEA.L        (A1),A1
                    MOVE.L         A0,(A1)
                    MOVE.L         A1,4(A0)
freemem             MOVEA.L        A5,A1                    ; iconbase
                    MOVEQ          #0,D0
                    MOVE.W         LIB_NEGSIZE(A5),D0
                    SUBA.W         D0,A1
                    ADD.W          LIB_POSSIZE(A5),D0
                    MOVEA.L        $22(A5),A5               ; 0 or segmentlist
                    JSR            (_LVOFreeMem,A6)
                    MOVE.L         A5,D0                    ; return segmentlist
                    MOVEM.L        (SP)+,A5-A6
                    RTS

 ifd MC68020
LibDir68000         DC.B           "68000/"
LibName             DC.B           "icon.library",0         ; Copyright 2007-2025
                    DC.B           "$VER:"
LibId               DC.B           "icon.library 46.4"      ;  by Peter Keunecke
 else
LibDir68020         DC.B           "68020/"
LibName             DC.B           "icon.library",0
                    DC.B           "$VER:"
LibId               DC.B           "icon.library 47.-1"     ; OS 3.2 and 68000
 endif
                    DC.B           ".592 "
 ifd MC68020
     ifd smurf
                    DC.B           "(smurf)",0
     else
                    DC.B           "(68020)",0
     endif
 else
                    DC.B           "(68000)",0
 endif

;--------------------------------------------------------------------

                    CNOP           0,4

installGfxPatch     MOVEQ          #(PatchEnd-GfxPatch),D0  ; needs A6 = execbase
                    MOVEQ          #MEMF_PUBLIC,D1
                    JSR            _LVOAllocMem(A6)
                    MOVE.L         D0,$DC(A5)               ; store patch memblock
                    BEQ.S          .outofmemory
                    ADDQ.W         #1,LIB_OPENCNT(A5)       ; never close iconlib
                    JSR            _LVOForbid(A6)
                    LEA            GfxPatch(PC),A0
                    MOVEA.L        D0,A1
                    MOVEQ          #(PatchEnd-GfxPatch),D0
                    BSR.W          CopyMemAligned
                    MOVEA.L        $DC(A5),A0               ; start of patch memory
                    MOVE.L         A5,(LoadIconBase+2-GfxPatch)(A0)
                    MOVEA.L        $32(A5),A1               ; gfxbase
                    ADDA.W         #_LVOBltBitMapRastPort,A1
                    MOVE.L         A1,(BltBitMapRP+2-GfxPatch)(A0)
                    ADDA.W         #(_LVOBltMaskBitMapRastPort-_LVOBltBitMapRastPort),A1
                    MOVE.L         A1,(BltMaskBitMapRP+2-GfxPatch)(A0)
                    JSR            _LVOCacheClearU(A6)
                    MOVE.L         $DC(A5),D0               ; start of patch memory
                    MOVEA.W        #_LVOBltBitMapRastPort,A0
                    MOVEA.L        $32(A5),A1               ; gfxbase
                    JSR            _LVOSetFunction(A6)
                    MOVEA.L        $DC(A5),A0               ; start of patch memory
                    MOVE.L         D0,(BltBitMapRP+2-GfxPatch)(A0)
                    MOVEQ          #(BltMaskBitMapRP-GfxPatch),D0
                    ADD.L          A0,D0
                    MOVEA.W        #_LVOBltMaskBitMapRastPort,A0
                    MOVEA.L        $32(A5),A1               ; gfxbase
                    JSR            _LVOSetFunction(A6)
                    MOVEA.L        $DC(A5),A0               ; start of patch memory
                    MOVE.L         D0,(BltMaskBitMapRP+2-GfxPatch)(A0)
                    JSR            _LVOCacheClearU(A6)
                    JMP            _LVOPermit(A6)

.outofmemory        RTS

;--------------------------------------------------------------------
;
; error = BltBitMapRastPort
;         (srcbm, srcx, srcy, destrp, destX, destY, sizeX, sizeY, minterm)
;  D0      A0     D0    D1    A1      D2     D3     D4     D5     D6
;
; BOOL BltBitMapRastPort
;      (struct BitMap *, W, W, struct RastPort *, W, W, W, W, UBYTE);
;
; BltMaskBitMapRastPort
;     (srcbm, srcx, srcy, destrp, destX, destY, sizeX, sizeY, minterm, bltmask)
;      A0     D0    D1    A1      D2     D3     D4     D5     D6       A2
;
; void BltMaskBitMapRastPort
;      (struct BitMap *, W, W, struct RastPort *, W, W, W, W, UBYTE, APTR);


                    CNOP           0,4
 ifd MC68020

GfxPatch                                                    ; A6 = gfxbase !!

BltBitMapRP         PEA            $BAD2FEED                ; for frames, WB30/31
                    BRA.S          Check8BitsAndToken

BltMaskBitMapRP     PEA            $BAD2FEED                ; for frameless icons
Check8BitsAndToken  MOVE.L         A5,-(SP)
LoadIconBase        LEA            $BAD2FEED,A5
                    TST.L          $120(A5)                 ; cgxbase ?
                    BNE.S          checkdirectdrawing
                    CMP.B          #8,5(A0)                 ; bitmap depth = 8 ?
                    BNE.S          return2orifunction
checkdecode42token  MOVE.L         A0,-(SP)
                    MOVEA.L        8(A0),A0                 ; * bitplane 0
                    CMPA.W         #4096,A0                 ; avoid zero page hits
                    BLT.S          return2oldfunction
                    CMPI.L         #$DEC0DE42,(A0)+
                    BNE.S          return2oldfunction
                    MOVEM.L        D0-D1/D7/A1/A3,-(SP)
                    DC.W           $4EB9                    ; JSR don't optimize
                    DC.L           DecodingForImage2        ; must be relocated !
                    MOVEM.L        (SP)+,D0-D1/D7/A1/A3
return2oldfunction  MOVEA.L        (SP)+,A0
return2orifunction  MOVEA.L        (SP)+,A5
                    RTS

checkdirectdrawing  MOVEM.L        D0-D1/A0-A1,-(SP)
                    DC.W           $4EF9                    ; JMP don't optimize
                    DC.L           DirectDrawingPatch       ; must be relocated !

                    CNOP           0,4
PatchEnd

;-------------------------------------------------------------------------------

checkthemagictoken  CLR.B          $97A(A5)                 ; no TrueColor screen
abortdirectdrawing  MOVEM.L        (SP)+,D0-D1/A0-A1/A5
                    RTS

DirectDrawingPatch  MOVEA.L        rp_BitMap(A1),A0         ; bitmap of rastport
                    MOVEQ          #BMA_DEPTH,D1
                    JSR            _LVOGetBitMapAttr(A6)
                    SUBQ.B         #8,D0                    ; Hi- or TrueColor ?
                    BLE.S          checkthemagictoken
.sourcebitmapdepth  MOVEA.L        8(SP),A0                 ; get source bitmap
                    CMP.B          #8,5(A0)                 ; bitmap depth = 8 ?
                    BNE.S          abortdirectdrawing
.checkbitplanedata  MOVEM.W        (A0),D0-D1               ; BytesPerRow, rows
                    MULU.W         D0,D1                    ; planar image size
                    ADDQ.W         #8,A0
                    MOVEA.L        (A0)+,A1                 ; bitplane 0 pointer
                    CMPA.W         #4096,A1                 ; avoid zero page hits
                    BLT.S          abortdirectdrawing
                    MOVEQ.L        #8-2,D0                  ; check pointers 1-7
.testplanepointers  ADDA.L         D1,A1                    ; add the plane size
                    CMPA.L         (A0)+,A1                 ; pointer correct ?
                    DBNE           D0,.testplanepointers
                    BNE.S          abortdirectdrawing
                    ADDA.L         D1,A1                    ; points below image
.testformagictoken  CMPI.L         #$ADD2FEED,(A1)+         ; magic token found?
                    BNE.S          abortdirectdrawing
                    MOVEA.L        (A1),A1                  ; restore our PalMap
                    MOVE.L         (A1),D0                  ; width, height
                    MOVEM.W        D4-D5,-(SP)              ; sizeX, sizeY
                    CMP.L          (SP)+,D0
                    BNE.S          abortdirectdrawing
     ifd RLEjit
                    TST.B          $11F(A1)                 ; RLE compressed data ?
                    BPL.S          .uncompressedimage
                    CLR.B          $11F(A1)                 ; color reduction dump
                    MOVEM.L        A1-A2/A6,-(SP)
                    MOVEA.L        A1,A6                    ; PalMap
                    MOVE.W         (A1)+,D0                 ; PalMap width
                    MULU.W         (A1)+,D0                 ; width * height
                    MOVEA.L        D0,A0                    ; full size of image
                    MOVEA.L        (A1),A1                  ; * chunky image data
                    MOVEA.L        A1,A2                    ; target = full image
                    MOVEQ          #0,D0
                    MOVE.W         (A1)+,D0                 ; offset of RLE data
                    ADDA.L         D0,A2                    ; source = *RLE z-data
                    MOVE.W         (A1)+,D0                 ; RLE compressed size
                    MOVEQ          #0,D1
                    MOVE.B         (A1),D1                  ; depth
                    SUBQ.W         #4,A1                    ; target = full image
                    BSR.W          decompressdata           ; A6 = PalMap
                    MOVEM.L        (SP)+,A1-A2/A6
                    BNE.W          abortdirectdrawing       ; should never happen
.uncompressedimage
     endif
                    MOVE.L         $14(SP),D0               ; old blit function
                    MOVEA.L        $DC(A5),A0               ; GfxPatch memblock
                    CMP.L          (BltBitMapRP+2-GfxPatch)(A0),D0
                    BNE.S          .calldirectdrawing       ; image has no frame
                    MOVEM.L        D2-D3/A1,-(SP)
                    TST.B          $97E(A5)                 ; is it WB 3.0/3.1 ?
                    BEQ.S          .usegraybackground
                    PEA            .backgrounddonenow(PC)   ; RTS after blitting
                    MOVE.L         D0,-(SP)                 ; old blit function
                    MOVEM.L        $C+8(SP),D0-D1/A0-A1     ; original contents
                    RTS                                     ; restore background

.usegraybackground  MOVEQ          #0,D0                    ; use pen 0
                    MOVEA.L        $C+$C(SP),A1             ; rastport
                    JSR            _LVOSetAPen(A6)          ; A1 = rastport
                    MOVE.L         D2,D0                    ; left edge
                    MOVE.L         D3,D1                    ; top edge
                    ADD.W          D4,D2                    ; left edge + width
                    SUBQ.W         #1,D2                    ; - 1 = right edge
                    ADD.W          D5,D3                    ; top edge + height
                    SUBQ.W         #1,D3                    ; - 1 = bottom edge
                    MOVEA.L        $C+$C(SP),A1             ; rastport
                    JSR            _LVORectFill(A6)         ; gray background
.backgrounddonenow  MOVEM.L        (SP)+,D2-D3/A1
.calldirectdrawing  MOVE.L         A5,D1                    ; save iconbase
                    MOVEM.L        $C(SP),A0/A5             ; get rastport and A5
                    LEA            $18(SP),SP               ; drop off the RTS
                    MOVEM.L        D2-D7/A2-A6,-(SP)
                    MOVEA.L        A0,A3                    ; restore rastport
                    MOVEA.L        D1,A5                    ; restore iconbase
                    MOVE.L         D3,D4                    ; Y position
                    MOVE.L         D2,D3                    ; X position
                    MOVEQ          #1,D2                    ; disable the ghosting
                    MOVE.B         D2,$97A(A5)              ; set RTG flag bit 0

;--------------------------------------------------------------------------------- 

DirectDrawing

    ifd LineD
                    MOVE.W         (A1)+,D5                 ; width for x counter
                    MOVEQ          #1,D6                    ; process one row only
                    SWAP           D6
                    MOVE.W         (A1)+,D6                 ; height for y counter
                    MOVEA.L        (A1),A2                  ; chunky pixel data
                    MOVEA.L        $120(A5),A6              ; cgxbase
                    LEA            $104(A1),A1              ; goto offset $108
                    MOVEA.L        (A1)+,A5                 ; RGB triplets
                    MOVE.W         (A1),-(SP)
                    NOT.B          (SP)                     ; invert transparency
                    MOVEA.W        (SP)+,A4                 ; transparent color
                    MOVE.W         D5,D2
                    ADD.W          D5,D2
                    ADD.W          D5,D2
                    ADDQ.W         #3,D2                    ; round to longwords
                    AND.B          #$FC,D2                  ; SrcMod bytes per row
                    SUBQ.L         #1,D3                    ; SrcX - 1
                    SUBQ.L         #1,D5
                    MOVEM.W        D3/D5,-(SP)              ; save SrcX and width
                    SUBA.W         D2,SP                    ; buffer for one line
                    SUBQ.W         #1,D6                    ; y counter
                    MOVEQ          #RECTFMT_RGB,D7          ; DestFormat
.nextimageline      MOVE.L         A4,D0                    ; transparent color ?
                    BPL.S          .findfirstpixel
                    ADDQ.L         #1,D3                    ; SrcX
                    ADDQ.L         #1,D5                    ; width
                    MOVEA.L        A2,A1
                    ADDA.W         D5,A1                    ; 1. pixel of next row
                    BRA.S          .readpixelarray

.findfirstpixel     ADDQ.L         #1,D3                    ; skip SrcX position
                    CMP.B          (A2)+,D0                 ; transparent color ?
                    DBNE           D5,.findfirstpixel
                    BEQ.S          .transparentrow
                    MOVEA.L        A2,A1
                    ADDA.W         D5,A1                    ; 1. pixel of next row
                    SUBQ.W         #1,A2                    ; first visible pixel
                    MOVEA.L        A1,A0
.findlastpixel      CMP.B          -(A0),D0                 ; transparent color ?
                    DBNE           D5,.findlastpixel
                    ADDQ.L         #1,D5                    ; width
.readpixelarray     MOVEA.L        SP,A0                    ; start of row buffer
                    MOVEQ          #0,D0                    ; DestX
                    MOVE.L         A1,-(SP)                 ; save pixel pointer
                    MOVEQ          #0,D1                    ; DestY
                    MOVEA.L        A3,A1                    ; rastport
                    MOVE.L         D2,-(SP)                 ; fixing CyberGFX bug
                    SWAP           D6
                    JSR            _LVOReadPixelArray(A6)
                    MOVE.L         D5,D0
                    MOVE.L         (SP)+,D2
                    SUBQ.L         #1,D0                    ; x counter
                    MOVEA.L        SP,A0
                    ADDQ.W         #4,A0                    ; start of row buffer
.copynextpixel      MOVE.B         (A2)+,D7                 ; read a pixel
                    CMP.L          A4,D7
                    BEQ.S          .itstransparent
                    LEA            (A5,D7.L*2),A1
                    ADDA.L         D7,A1                    ; pointer to RGB bytes
                    TST.L          D2
                    BPL.S          .noiconghosting
.pixelisghosted     MOVE.B         (A1)+,D7                 ; use 50% transparency
                    ADD.B          (A0),D7                  ; for ghosted deficons
                    ROXR.B         #1,D7
                    MOVE.B         D7,(A0)+
                    MOVE.B         (A1)+,D7
                    ADD.B          (A0),D7
                    ROXR.B         #1,D7
                    MOVE.B         D7,(A0)+
                    MOVE.B         (A1),D7
                    ADD.B          (A0),D7
                    ROXR.B         #1,D7
                    MOVE.B         D7,(A0)+
                    DBRA           D0,.copynextpixel
                    BRA.S          .writepixelarray

.itstransparent     ADDQ.W         #3,A0
                    DBRA           D0,.copynextpixel
                    BRA.S          .writepixelarray

.noiconghosting     MOVE.B         (A1)+,(A0)+              ; copy R into buffer
                    MOVE.W         (A1),(A0)+               ; copy GB into buffer
                    DBRA           D0,.copynextpixel
.writepixelarray    MOVEA.L        (SP)+,A2                 ; 1. pixel of next row
                    MOVEQ          #0,D0                    ; SrcX
                    MOVEQ          #0,D1                    ; SrcY
                    MOVEQ          #RECTFMT_RGB,D7          ; SrcFormat
                    MOVEA.L        SP,A0                    ; start of row buffer
                    MOVEA.L        A3,A1                    ; rastport
                    JSR            _LVOWritePixelArray(A6)
                    SWAP           D6
.transparentrow     ADDQ.L         #1,D4                    ; move to next line
                    MOVEM.W        (SP,D2.W),D3/D5          ; restore SrcX, width
                    DBRA           D6,.nextimageline
                    ADDA.W         D2,SP
                    MOVEM.L        (SP)+,D1-D7/A2-A6        ; drop SrcX and width
                    MOVEQ          #1,D0                    ; return TRUE
                    RTS

   else             ;--------------------------------------------------------------

                    MOVEM.W        (A1),D5-D6               ; width, height
                    MOVE.L         D5,D0
                    MULU.W         D6,D0                    ; number of pixels
                    MOVEA.L        4(A1),A2                 ; chunky pixel data
                    LEA            $108(A1),A4              ; * RGB color table
                    MOVE.L         D0,D7
                    ADD.L          D0,D0
                    ADD.L          D7,D0                    ; 3 * number of pixels
                    MOVEQ          #MEMF_PUBLIC,D1
                    MOVEA.L        $26(A5),A6               ; execbase
                    JSR            _LVOAllocVec(A6)
                    MOVE.L         D0,-(SP)
                    BEQ.W          nofreebuffermem
                    MOVE.W         D5,D2                    ; store original width
                    MOVEA.L        $120(A5),A6              ; cgxbase
                    MOVEA.L        (A4)+,A5                 ; RGB color table
                    MOVE.W         (A4),-(SP)
                    NOT.B          (SP)                     ; invert transparency
                    MOVEA.W        (SP)+,A4                 ; transparent color
                    MOVE.L         A4,D0
                    BMI.W          .readpixelarray
                    MOVEA.L        A2,A1                    ; save image pointer
                    ADD.L          A1,D7                    ; end of image + 1
                    MOVEQ          #-1,D1
.skiptransparent    ADD.W          D5,D1                    ; copy image width
.findfirstopaque    CMP.B          (A2)+,D0                 ; transparent color ?
                    DBNE           D1,.findfirstopaque
                    BNE.S          .belowendofimage
                    ADDA.L         D5,A1                    ; image pointer + width
                    ADDQ.L         #1,D4                    ; first image line + 1
                    SUBQ.L         #1,D6                    ; height - 1 line
                    BNE.S          .skiptransparent
                    BRA.W          freeimagebuffer          ; all lines transparent

                    CNOP           0,4

.belowendofimage    MOVEA.L        D7,A2                    ; end of image + 1
                    MOVEQ          #-1,D1
.droptransparent    ADD.W          D5,D1                    ; copy image width
                    SUBQ.L         #1,D6                    ; height - 1 line
.findfinalopaque    CMP.B          -(A2),D0                 ; transparent color ?
                    DBNE           D1,.findfinalopaque
                    BEQ.S          .droptransparent
                    MOVE.L         D5,D7                    ; copy image width
                    SUBA.W         D1,A2                    ; goto start of line
                    MOVEA.L        A2,A4
                    ADDA.L         D5,A4                    ; new end of image + 1
                    BRA.S          .setleftcounter

.lefttransparent    SUBA.L         D7,A2
.setleftcounter     CMPA.L         A1,A2                    ; above top of array ?
                    BCS.S          .setnewleftedge
                    MOVE.L         D7,D1                    ; max transparent left
                    SUBQ.L         #1,D1
.findleftopaque     CMP.B          (A2)+,D0                 ; transparent color ?
                    DBNE           D1,.findleftopaque
                    SUBA.L         D5,A2                    ; move up one line
                    BEQ.S          .lefttransparent
                    SUBQ.W         #1,A2
                    SUB.L          D1,D7                    ; opaque pixel found
                    SUBQ.L         #1,D7                    ; reduce left border
                    BGT.S          .lefttransparent
.setnewleftedge     ADDA.L         D7,A1                    ; new image left edge
                    MOVEA.L        A1,A2                    ; new image pointer
                    ADD.L          D7,D3
                    SUB.L          D7,D5                    ; new image line width
                    MOVE.L         D5,D7                    ; copy image width
                    ADDQ.L         #1,D6                    ; height + 1 line
                    BRA.S          .setrightcounter

.righttransparent   ADDQ.W         #1,A4
.transparentpixel   CMPA.L         A1,A4                    ; above top of array ?
                    BLS.S          .newarraypointer
                    ADDA.L         D7,A4
.setrightcounter    MOVE.L         D7,D1                    ; transparent at right
                    SUBQ.L         #1,D1
.findrightopaque    CMP.B          -(A4),D0                 ; transparent color ?
                    DBNE           D1,.findrightopaque
                    SUBA.W         D2,A4                    ; move up one line
                    BEQ.S          .transparentpixel
                    SUB.L          D1,D7                    ; opaque pixel found
                    SUBQ.L         #1,D7                    ; reduce right border
                    BGT.S          .righttransparent
.newarraypointer    MOVEA.L        D0,A4                    ; transparent color
                    SUB.L          D7,D5                    ; new image line width
.readpixelarray     MOVEQ          #0,D0                    ; DestX
                    MOVEQ          #0,D1                    ; DestY
                    MOVEA.L        (SP),A0                  ; pixel array buffer
                    SUB.W          D5,D2                    ; original - new width
                    MOVE.L         D2,-(SP)                 ; = transparent width
                    MOVE.L         D5,D2                    ; new reduced width
                    ADD.L          D2,D2
                    ADD.L          D5,D2                    ; SrcMod bytes per row
                    MOVEQ          #RECTFMT_RGB,D7          ; DestFormat = RGB = 0
                    MOVEA.L        A3,A1                    ; rastport
                    JSR            _LVOReadPixelArray(A6)
                    MOVEQ          #-1,D0
                    MOVE.L         (SP)+,D2                 ; transparent width
                    MOVEA.L        (SP),A0                  ; pixel array buffer
                    MOVE.L         D6,D1                    ; new number of lines
                    SUBQ.L         #1,D1                    ; line counter - 1
                    BRA.S          .copyfirstline

                    CNOP           0,4

.copynextline       ADDA.W         D2,A2                    ; + transparent width
.copyfirstline      ADD.W          D5,D0                    ; reduced width - 1
.copynextpixel      MOVE.B         (A2)+,D7                 ; read an image pixel
                    CMP.L          A4,D7
                    BEQ.S          .itstransparent
                    LEA            (A5,D7.L*2),A1
                    ADDA.L         D7,A1                    ; pointer to RGB bytes
                    TST.L          D2
                    BPL.S          .noiconghosting
                    MOVE.B         (A1)+,D7                 ; use 50% transparency
                    ADD.B          (A0),D7                  ; for ghosted deficons
                    ROXR.B         #1,D7
                    MOVE.B         D7,(A0)+
                    MOVE.B         (A1)+,D7
                    ADD.B          (A0),D7
                    ROXR.B         #1,D7
                    MOVE.B         D7,(A0)+
                    MOVE.B         (A1),D7
                    ADD.B          (A0),D7
                    ROXR.B         #1,D7
                    MOVE.B         D7,(A0)+
                    DBRA           D0,.copynextpixel
                    DBRA           D1,.copynextline
                    BRA.S          .writepixelarray

                    CNOP           0,4

.itstransparent     ADDQ.W         #3,A0                    ; keep background RGB
                    DBRA           D0,.copynextpixel
                    DBRA           D1,.copynextline
                    BRA.S          .writepixelarray

.noiconghosting     MOVE.B         (A1)+,(A0)+              ; copy R into buffer
                    MOVE.W         (A1),(A0)+               ; copy GB into buffer
                    DBRA           D0,.copynextpixel
                    DBRA           D1,.copynextline
.writepixelarray    MOVE.L         D5,D2                    ; new reduced width
                    ADD.L          D2,D2
                    ADD.L          D5,D2                    ; SrcMod bytes per row
                    MOVEA.L        (SP),A0                  ; pixel array buffer
                    MOVEQ          #RECTFMT_RGB,D7          ; SrcFormat = RGB = 0
                    MOVEA.L        A3,A1                    ; rastport
                    MOVEQ          #0,D0                    ; SrcX
                    MOVEQ          #0,D1                    ; SrcY
                    JSR            _LVOWritePixelArray(A6)
freeimagebuffer     MOVEA.L        (SP),A1
                    MOVEA.L        (4).w,A6                 ; execbase
                    JSR            _LVOFreeVec(A6)
                    MOVEQ          #1,D0                    ; return TRUE
nofreebuffermem     MOVEM.L        (SP)+,D1-D7/A2-A6        ; drop buffer pointer
                    RTS

     endif ; LineD
 else ; MC68000 CPU -------------------------------------------------------------

GfxPatch            ; for Workbench 3.0 or 3.1 and 68000 CPU, A6 = gfxbase !!

BltBitMapRP         PEA            $BAD2FEED                ; for frames, WB30/31
                    BRA.S          Check8BitsAndToken

BltMaskBitMapRP     PEA            $BAD2FEED                ; for frameless icons
Check8BitsAndToken  CMP.B          #8,5(A0)                 ; bitmap depth = 8 ?
                    BNE.S          return2orifunction
                    MOVEM.L        A0/A5,-(SP)
                    MOVEA.L        8(A0),A0                 ; * bitplane 0
                    CMPA.W         #4096,A0                 ; avoid zero page hits
                    BLT.S          return2oldfunction
                    CMPI.L         #$DEC0DE42,(A0)+         ; magic token found?
                    BNE.S          return2oldfunction
                    MOVEM.L        D0-D1/D7/A1/A3,-(SP)
LoadIconBase        LEA            $BAD2FEED,A5
                    DC.W           $4EB9                    ; JSR don't optimize
                    DC.L           DecodingForImage2        ; must be relocated !
                    MOVEM.L        (SP)+,D0-D1/D7/A1/A3
return2oldfunction  MOVEM.L        (SP)+,A0/A5
return2orifunction  RTS

                    CNOP           0,4
PatchEnd

 endif ;;;-------------------------------------------------------------------------

DecodingForImage2   CLR.B          $97A(A5)                 ; no TrueColor screen
                    MOVEA.L        (A0)+,A3                 ; DiskObject
 ifd MC68020
                    CMPI.W         #$E310,(A3)              ; DiskMagic found ?
 else
                    CMPI.B         #$E3,(A3)
 endif
                    BNE.S          .returntoblitfunc        ; data trashed by CGX4
                    MOVE.L         $1A(A3),D0               ; SelectRender
                    MOVEQ          #-1,D7                   ; color precision
                    MOVEA.L        $7A(A3),A1               ; PalMap2
                    MOVEA.L        $36(A5),A0               ; intuibase
                    MOVEA.L        ib_ActiveScreen(A0),A0   ; is the ActiveScreen
                    CMPA.L         $86(A3),A0               ; = old icons screen ?
                    BEQ.S          .imagecolormapping
                    MOVE.L         A0,$86(A3)               ; a new WB 3.1 screen!
                    CLR.W          $11C(A1)                 ; no colors mapped yet
.imagecolormapping  BSR.W          imagecolormapping        ; map selected image
                    MOVEA.L        $1A(A3),A0               ; SelectRender
                    TST.L          $A(A0)                   ; * image data ?
                    BNE.S          .image2datadone
                    LEA            $154+4(A5),A1            ; Dot image width
                    MOVE.L         (A1)+,4(A0)              ; width, height
                    MOVE.L         (A1)+,8(A0)              ; depth, * image data
                    MOVE.L         (A1),$C(A0)              ; PlanePick PlaneOnOff
.image2datadone     MOVEM.W        4(A0),D4-D5              ; scratches D4=w, D5=h
                    MOVEA.L        $18(SP),A1               ; update source bitmap
                    BRA.W          preparebitmap            ; overwriting source !

.returntoblitfunc   RTS

;--------------------------------------------------------------------------------

                    CNOP           0,4

; BumpRevision takes a name and turns it into a "copy_of_name".
; result = BumpRevision(newbuf, oldname)
;   D0                    A0      A1
; STRPTR   BumpRevision(STRPTR, STRPTR);

; BumpRevisionLength takes a name and turns it into a "copy_of_name".
; result = BumpRevision(newbuf, oldname, maxLength)
;   D0                    A0      A1        D0
; STRPTR   BumpRevision(STRPTR, STRPTR,  ULONG);

BumpRevision        MOVEQ          #25,D1                   ; 25 chars maximal
                    BRA.S          NewBumpRevision

BumpRevisionLength  MOVEQ          #15,D1
                    CMP.L          D1,D0                    ; is maxLength < 15 ?
                    BCC.S          .validmaxLength
                    MOVEQ          #0,D0                    ; too small maxLength
                    RTS

.validmaxLength     MOVEQ          #102,D1                  ; default = 102 chars
                    TST.B          $EA(A6)                  ; was GlobalMNL set ?
                    BEQ.S          .MNLormaxLength          
                    MOVE.W         $CA(A6),D1               ; GlobalMaxNameLength
.MNLormaxLength     MOVE.W         D1,$CA(A6)
                    CMP.L          D1,D0
                    BCC.S          NewBumpRevision
                    MOVE.L         D0,D1                    ; maxLength as limit                                             
NewBumpRevision     MOVEM.L        D1/D7/A2-A3/A6,-(SP)     ; D1 = maximal length
                    MOVE.L         A0,D0
                    BEQ.W          .quit
                    MOVE.L         A1,D0
                    BEQ.W          .quit
                    MOVEA.L        A0,A3                    ; newbuf
                    MOVEQ          #$30,D0
                    MOVEA.L        D0,A2                    ; char "0"
                    MOVEQ          #0,D7                    ; revision = 0
                    MOVEA.L        A1,A0                    ; oldname
 ifd MC68020
                    MOVE.L         (A0)+,D1                 ; "copy" ?
 else
                    MoveOddLong    A0,D1
 endif
                    OR.L           lowercasefilter(PC),D1
                    CMPI.L         #"copy",D1
                    BNE.S          .firstcopy
                    MOVE.B         (A0)+,D1
                    CMPI.B         #" ",D1                  ; " " ?
                    BEQ.S          .checkrevision
                    CMPI.B         #"_",D1                  ; "_" ?
                    BEQ.S          .checkrevision
.firstcopy          LEA            string_copy_of_(PC),A0
                    BRA.S          .norevision

.adddigit           MOVE.L         D7,D1
                    LSL.L          #2,D7
                    ADD.L          D1,D7
                    ADD.L          D7,D7                    ; 10 * revision
                    ADD.L          D0,D7                    ; + digit
.checkrevision      MOVE.B         (A0)+,D0                 ; get char
                    SUB.L          A2,D0                    ; sub "0"
                    BCS.S          .nodigit
                    MOVEQ          #9,D1
                    CMP.L          D1,D0                    ; cmp 9
                    BLS.S          .adddigit
.nodigit            MOVEQ          #" ",D0                  ; " "
                    MOVEQ          #"_",D1                  ; "_"
                    TST.L          D7                       ; any digits ?
                    BNE.S          .digitsdone
                    SUBQ.W         #2,A0
.skipspaces         ADDQ.W         #1,A0
.digitsdone         CMP.B          (A0),D1                  ; "_" ?
                    BEQ.S          .skipspaces
                    CMP.B          (A0),D0                  ; " " ?
                    BEQ.S          .skipspaces
 ifd MC68020
                    CMPI.W         #"of",(A0)+              ; "of" ?
 else
                    CMPI.B         #"o",(A0)+               ; "o" ?
                    BNE.S          .getformat
                    CMPI.B         #"f",(A0)+               ; "f" ?
 endif
                    BNE.S          .getformat
                    CMP.B          (A0)+,D1                 ; "_" ?
                    BEQ.S          .nameoffset
                    SUBQ.W         #1,A0
                    CMP.B          (A0)+,D0                 ; " " ?
                    BNE.S          .getformat
.nameoffset         MOVEA.L        A0,A1
.getformat          LEA            string_copy_xld_of_(PC),A0
                    ADDQ.L         #1,D7                    ; the new revision
.norevision         MOVEM.L        D7/A1,-(SP)              ; revision, name offset
                    MOVEA.L        SP,A1                    ; * DataStream = * rev
                    LEA            .procedure(PC),A2        ; PutChProc
                    MOVEA.L        $26(A6),A6               ; execbase
                    JSR            _LVORawDoFmt(A6)         ; A3 = PutChData
                    MOVEM.L        (SP)+,D7/A1              ; revision, name offset
                    MOVEA.L        A3,A0                    ; newbuf
.countprefix        TST.B          (A0)+
                    BNE.S          .countprefix
                    SUBQ.W         #1,A0                    ; end of prefix
                    MOVE.L         A0,D1
                    SUB.L          A3,D1                    ; prefix size
                    MOVE.L         (SP),D0                  ; maximal length 15-102
                    MOVEA.L        A3,A2                    ;
                    ADDA.L         D0,A2                    ; last position
                    SUB.L          D1,D0                    ; count = max - prefix
                    BHI.S          .first
                    BRA.S          .last

.procedure          MOVE.B         D0,(A3)+                 ; used by RawDoFmt
                    RTS

.cat                MOVE.B         (A1)+,(A0)+              ; prefix + base name
                    BEQ.S          .rest
.first              DBRA           D0,.cat
                    BRA.S          .last

.clear              CLR.B          (A0)+
.rest               DBRA           D0,.clear
.last               CLR.B          (A2)                     ; cut off at limit
                    MOVE.L         A3,D0                    ; newbuf pointer
.quit               MOVEM.L        (SP)+,D1/D7/A2-A3/A6
                    RTS

;------------------------------------------------------------------

                    CNOP           0,4

; IconControlA -- Set and get icon and icon.library options (V44)
; processed = IconControlA(icon,tags);
;  D0                       A0   A1
; ULONG IconControlA(struct DiskObject *,struct TagItem *);

IconControlA        MOVE.L         A0,D0                    ; icon ?
                    BEQ.S          .doiconcontrol
                    MOVE.L         A1,D0                    ; taglist ?
                    BEQ.S          .doiconcontrol
                    MOVE.L         4(A1),D0                 ; getting tag data ?
                    BEQ.S          .doiconcontrol
                    MOVEQ          #$5E,D1                  ; offset V44 magic
                    ADD.L          A0,D1
                    SUB.L          $5E(A0),D1               ; magic selfpointer ?
                    OR.L           8(A1),D1                 ; 2. tag = TAG_DONE ?
                    BNE.S          .doiconcontrol
                    MOVE.L         (A1),D1                  ; tag item
                    SUBI.L         #$8000900E,D1            ; GetImageMask1 ?
                    BNE.S          .tryimagemask2
.copyimagemask      MOVEA.L        D0,A1                    ; address for result
                    MOVE.L         $7E(A0,D1),(A1)          ; too many WB calls !
                    BEQ.S          .imagemaskdone
                    MOVEA.L        (A1),A0
                    MOVE.L         (A0),(A1)                ; send mask pointer
.imagemaskdone      MOVEQ          #1,D0                    ; 1 tag processed
                    RTS 

.tryimagemask2      SUBQ.L         #1,D1                    ; GetImageMask2 ?
                    BNE.S          .doiconcontrol
                    MOVEQ          #3,D1
                    AND.B          $10+1(A0),D1             ; flags bit 0 and 1
                    SUBQ.B         #1,D1
                    BEQ.S          .copyimagemask           ; use image mask 1
                    MOVEQ          #($82-$7E),D1            ; for selected image
                    BRA.S          .copyimagemask           ; and faster dragging

.doiconcontrol      CLR.L          -(SP)                    ; WBupdate, ImageFormat
                    CLR.L          -(SP)                    ; GlobalEmbossRectangle
                    CLR.L          -(SP)                    ; AllocAttributes
                    MOVE.L         $128(A6),-(SP)           ; default=GlobalScreen
                    MOVE.L         A0,D1                    ; icon stored in (SP)
                    MOVEM.L        D1/D6-D7/A1-A6,-(SP)
                    BEQ.S          .DiskObjectV44
                    LEA            $5E(A0),A0               ; magic v44 selfpointer
                    CMPA.L         (A0),A0
                    BEQ.S          .DiskObjectV44
                    MOVEQ          #0,D1                    ; no v44 extensions
.DiskObjectV44      MOVEA.L        D1,A3                    ; 0 or DiskObject v44
                    MOVEA.L        A1,A2                    ; taglist
                    SUBA.L         A4,A4                    ; ErrorCode reply addr
                    MOVEQ          #0,D6                    ; (error) returncode
                    MOVEQ          #0,D7                    ; processed tags = 0
                    MOVEA.L        A6,A5                    ; iconbase
                    BRA.S          IC_ReadTagList

IC_Skip             SUBQ.L         #1,D0
                    BNE.S          IC_TagItem
                    MOVE.L         (A2),D0
                    LSL.L          #3,D0
                    ADDA.L         D0,A2
IC_Ignore           ADDQ.W         #4,A2
IC_Next             MOVE.L         (A2)+,D0
                    BMI.S          IC_TagItem
                    BEQ.S          IC_TagDone
                    SUBQ.L         #2,D0
                    BCS.S          IC_Ignore
                    BNE.S          IC_Skip
                    MOVEA.L        (A2),A2
IC_ReadTagList      MOVE.L         A2,D0
                    BNE.S          IC_Next
IC_TagDone          BRA.W          IC_TagsDone

IC_Add_NextTag      ADDQ.L         #1,D7                    ; processed tags + 1
IC_NextTag          ADDQ.W         #8,A2                    ; next TagItem
                    BRA.S          IC_Next

IC_TagItem          MOVEA.L        (A2),A6                  ; TagData
                    MOVE.L         -(A2),D0                 ; TagItem
                    SUBI.L         #$80009000,D0            ; - (ICONA_Dummy)
                    BLE.S          IC_NextTag
                    MOVEQ          #44,D1
                    CMP.L          D1,D0
                    BHI.S          .ICONA_Dummy_49
                    LEA            .jmpbase(PC),A0
 ifd MC68020
                    ADDA.W         (A0,D0.L*2),A0
 else
                    ADD.W          D0,D0
                    ADDA.W         (A0,D0.W),A0
 endif
.jmpbase            JMP            (A0)

                    DC.W ErrorCodeWanted          -.jmpbase ; (ICONA_Dummy +1)
                    DC.W SetGlobalScreen          -.jmpbase ; (ICONA_Dummy +2)
                    DC.W GetGlobalScreen          -.jmpbase ; (ICONA_Dummy +3)
                    DC.W SetGlobalPrecision       -.jmpbase ; (ICONA_Dummy +4)
                    DC.W GetGlobalPrecision       -.jmpbase ; (ICONA_Dummy +5)
                    DC.W SetGlobalEmbossRect      -.jmpbase ; (ICONA_Dummy +6)
                    DC.W GetGlobalEmbossRect      -.jmpbase ; (ICONA_Dummy +7)
                    DC.W SetGlobalFrameless       -.jmpbase ; (ICONA_Dummy +8)
                    DC.W GetGlobalFrameless       -.jmpbase ; (ICONA_Dummy +9)
                    DC.W SetGlobalNewIconsSupport -.jmpbase ; (ICONA_Dummy+10)
                    DC.W GetGlobalNewIconsSupport -.jmpbase ; (ICONA_Dummy+11)
                    DC.W SetGlobalIdentifyHook    -.jmpbase ; (ICONA_Dummy+12)
                    DC.W GetGlobalIdentifyHook    -.jmpbase ; (ICONA_Dummy+13)
                    DC.W GetImageMask1            -.jmpbase ; (ICONA_Dummy+14)
                    DC.W GetImageMask2            -.jmpbase ; (ICONA_Dummy+15)
                    DC.W SetTransparentColor1     -.jmpbase ; (ICONA_Dummy+16)
                    DC.W GetTransparentColor1     -.jmpbase ; (ICONA_Dummy+17)
                    DC.W SetTransparentColor2     -.jmpbase ; (ICONA_Dummy+18)
                    DC.W GetTransparentColor2     -.jmpbase ; (ICONA_Dummy+19)
                    DC.W SetPalette1              -.jmpbase ; (ICONA_Dummy+20)
                    DC.W GetPalette1              -.jmpbase ; (ICONA_Dummy+21)
                    DC.W SetPalette2              -.jmpbase ; (ICONA_Dummy+22)
                    DC.W GetPalette2              -.jmpbase ; (ICONA_Dummy+23)
                    DC.W SetPaletteSize1          -.jmpbase ; (ICONA_Dummy+24)
                    DC.W GetPaletteSize1          -.jmpbase ; (ICONA_Dummy+25)
                    DC.W SetPaletteSize2          -.jmpbase ; (ICONA_Dummy+26)
                    DC.W GetPaletteSize2          -.jmpbase ; (ICONA_Dummy+27)
                    DC.W SetImageData1            -.jmpbase ; (ICONA_Dummy+28)
                    DC.W GetImageData1            -.jmpbase ; (ICONA_Dummy+29)
                    DC.W SetImageData2            -.jmpbase ; (ICONA_Dummy+30)
                    DC.W GetImageData2            -.jmpbase ; (ICONA_Dummy+31)
                    DC.W SetFrameless             -.jmpbase ; (ICONA_Dummy+32)
                    DC.W GetFrameless             -.jmpbase ; (ICONA_Dummy+33)
                    DC.W SetNewIconsSupport       -.jmpbase ; (ICONA_Dummy+34)
                    DC.W GetNewIconsSupport       -.jmpbase ; (ICONA_Dummy+35)
                    DC.W SetAspectRatio           -.jmpbase ; (ICONA_Dummy+36)
                    DC.W GetAspectRatio           -.jmpbase ; (ICONA_Dummy+37)
                    DC.W SetWidth                 -.jmpbase ; (ICONA_Dummy+38)
                    DC.W GetWidth                 -.jmpbase ; (ICONA_Dummy+39)
                    DC.W SetHeight                -.jmpbase ; (ICONA_Dummy+40)
                    DC.W GetHeight                -.jmpbase ; (ICONA_Dummy+41)
                    DC.W IsPaletteMapped          -.jmpbase ; (ICONA_Dummy+42)
                    DC.W GetScreen                -.jmpbase ; (ICONA_Dummy+43)
                    DC.W HasRealImage2            -.jmpbase ; (ICONA_Dummy+44)

.ICONA_Dummy_49     MOVEQ          #49,D1
                    SUB.L          D1,D0
                    BEQ.W          IsDefaultIcon            ; (ICONA_Dummy+49)
                    MOVEQ          #18,D1
                    SUB.L          D1,D0
                    BEQ.W          SetGlobalMaxNameLength   ; (ICONA_Dummy+67)
                    SUBQ.L         #1,D0
                    BEQ.W          GetGlobalMaxNameLength   ; (ICONA_Dummy+68)
                    SUBQ.L         #5,D0
                    BEQ.W          SetAllocAttributes       ; (ICONA_Dummy+73)
                    SUBQ.L         #1,D0
                    BEQ.W          GetAllocAttributes       ; (ICONA_Dummy+74)
                    SUBQ.L         #3,D0
                    BCS.W          IC_NextTag
                    BEQ.W          SetGlobalColorIconSupport; (ICONA_Dummy+77)
                    SUBQ.L         #2,D0
                    BCS.W          GetGlobalColorIconSupport; (ICONA_Dummy+78)
                    BEQ.W          IsNewIcon                ; (ICONA_Dummy+79)
                    SUBQ.L         #2,D0
                    BCS.W          IsNativeIcon             ; (ICONA_Dummy+80)
                    BEQ.S          EnableAWebIISE           ; (ICONA_Dummy+81)
                    SUB.L          D1,D0
                    BEQ.W          GrayscaleOnOff           ; (ICONA_Dummy+99)
                    SUBQ.L         #1,D0
                    BEQ.W          OutlineOrShadow          ; (ICONA_Dummy+100)
                    SUBQ.L         #1,D0
                    BEQ.S          IconGhostingOff          ; (ICONA_Dummy+101)
                    SUBQ.L         #1,D0
                    BEQ.S          DOnoColorMapping         ; (ICONA_Dummy+102)
                    SUBQ.L         #8,D0
                    BCS.W          IC_NextTag
                    BEQ.S          InvertGhostingMask       ; (ICONA_Dummy+110)
                    SUBQ.L         #2,D0
                    BCS.S          IconScalingOnOff         ; (ICONA_Dummy+111)
                    BEQ.S          KillPlanarImages         ; (ICONA_Dummy+112)
                    SUBI.L         #$3FF6F90,D0
                    BEQ.W          SetGlobalPrecision       ; ($84000000)
                    CMPI.L         #(ICONA_Dummy+$FFF),(A2)
                    BNE.W          IC_NextTag               ; (Dummy+85/88 fail)
                    MOVE.W         $CA(A5),D1               ; GlobalMaxNameLength
                    MOVEM.L        (A6),A0-A1               ; newbuf, oldname
                    MOVEA.L        A5,A6                    ; iconbase
                    BSR.W          NewBumpRevision
                    BRA.W          IC_Add_NextTag

EnableAWebIISE      MOVE.L         A6,D0
                    BEQ.S          IC_ArgMissing
                    MOVE.L         #$8000A03A,(A6)          ; used by AWeb-II SE
                    BRA.W          IC_Add_NextTag

ErrorCodeWanted     MOVEA.L        A6,A4
                    BRA.W          IC_NextTag

IconGhostingOff     SEQ            $97B(A5)
                    BRA.W          IC_Add_NextTag

DOnoColorMapping    SEQ            $EB(A5)
                    BRA.W          IC_Add_NextTag

InvertGhostingMask  NOT.B          $EF(A5)
                    BRA.W          IC_Add_NextTag

KillPlanarImages    MOVE.L         A6,D0                    ; Keep=0 Kill=-1 Depth=3
                    MOVE.B         D0,$F3(A5)               ; default = 0 = good
                    BNE.S          .done
                    ADDQ.B         #1,$F3(A5)               ; KeepPlanarImages=1
.done               BRA.W          IC_Add_NextTag

IconScalingOnOff
 ifd Scalers
                    MOVE.L         A6,D0
                    CMP.B          $F0(A5),D0
                    BNE.S          .setupiconscaling
                    MOVEQ          #0,D0
.setupiconscaling   MOVE.B         D0,$F0(A5)               ; scaleup=1, down=-1
                    BRA.W          IC_Add_NextTag
 else
                    BRA.W          IC_NextTag
 endif

SetAllocAttributes  MOVE.L         A6,D0
                    BTST.B         #1,$C0+2(A5)             ; MEMF_24BITDMA set ?
                    BEQ.S          .setallocattribs
                    ORI.W          #$200,D0                 ; keep MEMF_24BITDMA
.setallocattribs    MOVE.L         D0,$C0(A5)               ; ($80009049)
                    MOVE.L         A2,$28(SP)               ; used by IPrefs and
                    BRA.W          IC_Add_NextTag           ; for allocate_WxHxD

GetAllocAttributes  MOVE.L         A6,D0                    ; ($8000904A)
                    BEQ.S          IC_ArgMissing
                    MOVE.L         $C0(A5),(A6)
                    BRA.W          IC_Add_NextTag

IC_ArgMissing       MOVEQ          #$74,D6                  ; argument missing
IC_PostBadTagItem   MOVE.L         #ICONA_ErrorTagItem,D0
                    MOVEQ          #0,D1                    ; default = 0
                    MOVEA.L        $C(SP),A0                ; taglist
                    MOVEA.L        $2E(A5),A6               ; utilbase
                    JSR            _LVOGetTagData(A6)
                    TST.L          D0
                    BEQ.S          .nodemand
                    MOVEA.L        D0,A0                    ; apps bugre-port
                    MOVE.L         A2,(A0)                  ; apps "bad" tag
.nodemand           BRA.W          IC_FinalSteps

OutlineOrShadow     MOVE.L         A6,D0
                    MOVE.B         D0,$979(A5)
                    BRA.W          IC_Add_NextTag

GrayscaleOnOff
 ifd Scalers
                    NOT.B          $97D(A5)
                    BRA.W          IC_Add_NextTag
 else
                    BRA.W          IC_NextTag
 endif

SetGlobalScreen     MOVE.L         A6,$24(SP)
                    BRA.W          IC_Add_NextTag

GetGlobalScreen     MOVE.L         A6,D0
                    BEQ.S          IC_ArgMissing
                    MOVE.L         $128(A5),(A6)            ; GlobalScreen
                    BRA.W          IC_Add_NextTag

SetGlobalPrecision  MOVE.L         A6,$124(A5)              ; GlobalPrecision
                    BRA.W          IC_Add_NextTag

GetGlobalPrecision  MOVE.L         A6,D0
                    BEQ.S          IC_ArgMissing
                    MOVE.L         $124(A5),(A6)            ; GlobalPrecision
                    BRA.W          IC_Add_NextTag

SetGlobalEmbossRect MOVE.L         A6,D0
                    BEQ.S          IC_ArgMissing
                    MOVEA.W        #$FF00,A0                ; $FFFFFF00
                    MOVEM.W        (A6)+,D0-D1              ; MinX, MinY
                    CMP.L          A0,D0
                    BLS.S          IC_BadNumber
                    CMP.L          A0,D0
                    BLS.S          IC_BadNumber
                    NEG.L          D0                       ; |MinX|
                    NEG.L          D1                       ; |MinY|
                    MOVEA.L        D1,A1
                    MOVE.W         (A6)+,D1                 ;  MaxX
                    NEG.L          D1
                    CMP.L          A0,D1
                    BLS.S          IC_BadNumber
                    MOVE.W         (A6),D1                  ;  MaxY
                    NEG.W          D1
                    CMP.L          A0,D1
                    BLS.S          IC_BadNumber
                    NEG.L          D1
                    LEA            $B2(A5),A0               ; * delta width height
                    MOVE.W         -(A6),(A0)               ;  MaxX
                    ADD.W          D0,(A0)+                 ; |MinX| + MaxX
                    MOVE.W         A1,(A0)                  ; |MinY|
                    ADD.W          D1,(A0)+                 ; |MinY| + MaxY
                    MOVE.W         D0,(A0)+                 ; GlobalEmbRect |MinX|
                    MOVE.W         A1,(A0)                  ; GlobalEmbRect |MinY|
                    SUBQ.L         #4,A6
                    MOVE.L         A6,$2C(SP)               ; GERect for WBupdate
                    BRA.W          IC_Add_NextTag

IC_BadNumber        MOVEQ          #$73,D6                  ; error 115
                    BRA.W          IC_PostBadTagItem

GetGlobalEmbossRect MOVE.L         A6,D0
                    BEQ.W          IC_ArgMissing
                    LEA            $B6(A5),A0
                    MOVEM.W        (A0),D0-D1               ; |MinX| |MinY|
                    NEG.L          D0
                    MOVE.W         D0,(A6)+                 ; -MinX
                    NEG.L          D1
                    MOVE.W         D1,(A6)+                 ; -MinY
                    ADD.W          -(A0),D1                 ; delta height - MinY
                    ADD.W          -(A0),D0                 ; delta width - MinX
                    MOVEM.W        D0-D1,(A6)               ;  MaxX MaxY
                    BRA.W          IC_Add_NextTag

SetGlobalMaxNameLength
                    MOVEQ          #25,D0
                    CMPA.L         D0,A6                    ; MNL < 25 ?
                    BCS.S          .fixMNL
                    MOVEQ          #102,D0
                    CMPA.L         D0,A6                    ; MNL > 102 ?
                    BLS.S          .setMNL
.fixMNL             MOVE.L         D0,A6                    ; keep in range
.setMNL             MOVE.W         A6,$CA(A5)
                    SCC            $EA(A5)                  ; MNL was set
                    BRA.W          IC_Add_NextTag

GetGlobalMaxNameLength
                    MOVE.L         A6,D0
                    BEQ.W          IC_ArgMissing
                    CLR.W          (A6)+
                    MOVE.W         $CA(A5),(A6)
                    BRA.W          IC_Add_NextTag

GetGlobalColorIconSupport
                    MOVE.W         $C8(A5),D0
                    BRA.S          getglobal

GetGlobalNewIconsSupport
                    MOVE.W         $C6(A5),D0
                    BRA.S          getglobal

GetGlobalFrameless  MOVE.W         $C4(A5),D0
getglobal           MOVE.L         A6,D1
                    BEQ.W          IC_ArgMissing
                    EXT.L          D0
                    MOVE.L         D0,(A6)
                    BRA.W          IC_Add_NextTag

SetGlobalFrameless  MOVE.L         A6,D0
                    BGT.S          .settheframeoption
                    OR.B           D0,$E8(A5)               ; planar frames flag
                    BEQ.S          .settheframeoption
                    MOVEQ          #-1,D0                   ; force planar only
.settheframeoption  CMP.W          $C4(A5),D0
                    SNE            $30(SP)                  ; flag for WB update
                    MOVE.W         D0,$C4(A5)
                    BRA.W          IC_Add_NextTag

SetGlobalNewIconsSupport
                    MOVE.W         A6,$C6(A5)
                    BRA.W          IC_Add_NextTag

SetGlobalColorIconSupport
                    MOVE.W         A6,$C8(A5)
                    BRA.W          IC_Add_NextTag

SetGlobalIdentifyHook
                    BSET.B         #2,$F1(A5)               ; hook protection
                    BEQ.S          .storethehook
                    BSR.W          bitlockdelay

.storethehook       MOVE.L         A6,$D8(A5)               ; GlobalIdentifyHook
 ifd IDtype
                    MOVEA.L        $26(A5),A0               ; execbase
                    MOVEA.L        ThisTask(A0),A0
                    MOVEA.L        $A(A0),A0                ; * task name
                    CMPI.L         #"DefI",(A0)+
                    BNE.S          releasethehook
                    CMPI.L         #"cons",(A0)+
                    BNE.S          releasethehook
                    TST.B          (A0)
                    BNE.S          releasethehook
                    MOVE.L         A6,$114(A5)              ; DefIcons hook
 endif
releasethehook      SUBQ.B         #4,$F1(A5)               ; clear protection
                    BRA.W          IC_Add_NextTag

GetGlobalIdentifyHook
                    MOVE.L         A6,D0
                    BEQ.W          IC_ArgMissing
                    BSET.B         #2,$F1(A5)               ; hook protection
                    BEQ.S          .getthehook
                    BSR.W          bitlockdelay

.getthehook         MOVE.L         $D8(A5),(A6)
                    BRA.S          releasethehook

GetImageMask1       MOVE.L         A3,D1                    ; DiskObject v44 ?
                    BEQ.S          .noV44icon
.mask1              MOVEQ          #$7E,D0                  ; most often used
.mask2              MOVE.L         A6,D1                    ; result pointer ?
                    BEQ.S          .argmissing
                    MOVE.L         (A3,D0.w),D1
                    BEQ.S          .noresult
                    MOVEA.L        D1,A1
                    MOVE.L         (A1),(A6)
.done               BRA.W          IC_Add_NextTag

.noV44icon          MOVE.L         A6,D1                    ; result pointer ?
                    BEQ.S          .argmissing
.noresult           CLR.L          (A6)
                    TST.L          (SP)                     ; old DiskObject ?
                    BNE.S          .done
.argmissing         BRA.W          IC_ArgMissing

GetImageMask2       MOVE.L         A3,D1                    ; DiskObject v44 ?
                    BEQ.S          GetImageMask1\.noV44icon
                    MOVEA.L        D1,A0
                    MOVEQ          #3,D0                    ; filter Bit 0,1
                    AND.B          $10+1(A0),D0             ; from DO flags
                    SUBQ.B         #1,D0
                    BEQ.S          GetImageMask1\.mask1
                    MOVEQ          #$41,D0
                    ADD.L          D0,D0
                    BRA.S          GetImageMask1\.mask2

SetNewIconsSupport  MOVE.L         A3,D0                    ; DiskObject v44 ?
                    BEQ.S          IC_ActionNotKnown
                    MOVE.W         A6,D0
                    BEQ.S          .bitclear
                    BSET.B         #1,$8A(A3)
                    BRA.S          .done

.bitclear           BCLR.B         #1,$8A(A3)
.done               BRA.W          IC_Add_NextTag

IC_ActionNotKnown   MOVEQ          #$2E,D6
                    NOT.B          D6                       ; error 209
                    BRA.W          IC_PostBadTagItem

SetFrameless        MOVE.L         A3,D0                    ; DiskObject v44 ?
                    BEQ.S          IC_ActionNotKnown
                    MOVE.W         A6,D0
                    BEQ.S          .bitclear
                    BSET.B         #0,$8A(A3)
.done               BRA.W          IC_Add_NextTag

.bitclear           BCLR.B         #0,$8A(A3)
                    BRA.S          .done

IsPaletteMapped     MOVE.L         A3,D0                    ; DiskObject v44 ?
                    BEQ.S          IC_ActionNotKnown
                    TST.L          $76(A3)                  ; PalMap1 ?
                    BRA.S          sendreply1

IsNativeIcon        TST.L          (SP)                     ; DiskObject ?
                    BEQ.W          IC_ArgMissing
                    MOVE.L         A3,D0                    ; DiskObject v44 ?
                    BRA.S          sendreply1

HasRealImage2       MOVE.L         A3,D0                    ; DiskObject v44 ?
                    BEQ.S          IC_ActionNotKnown
                    BTST.B         #4,$8A(A3)               ; NoImage2 flag ?
                    SEQ            D0
                    BRA.S          sendreply2

IsDefaultIcon       MOVE.L         A3,D0                    ; DiskObject v44 ?
                    BEQ.S          IC_ActionNotKnown
                    BTST.B         #2,$8A(A3)
                    BRA.S          sendreply1

GetNewIconsSupport  MOVE.L         A3,D0                    ; DiskObject v44 ?
                    BEQ.S          IC_ActionNotKnown
                    BTST.B         #1,$8A(A3)
                    BRA.S          sendreply1

GetFrameless        MOVE.L         A3,D0                    ; DiskObject v44 ?
                    BEQ.S          IC_ActionNotKnown
                    BTST.B         #0,$8A(A3)
sendreply1          SNE            D0
sendreply2          NEG.B          D0
 ifd MC68020
                    EXTB.L         D0
 else
                    EXT.W          D0
                    EXT.L          D0
 endif
                    MOVE.L         A6,D1
                    BEQ.W          IC_ArgMissing
                    MOVE.L         D0,(A6)
                    BRA.W          IC_Add_NextTag

SetPalette1         MOVE.L         A3,D0                    ; DiskObject v44 ?
                    BEQ.S          IC_ActionNotKnown
                    LEA            $76(A3),A0               ; * PalMap1
                    BSR.W          A0_gets_PalMap
                    BRA.S          SetPalette

SetPalette2         MOVE.L         A3,D0                    ; DiskObject v44 ?
                    BEQ.W          IC_ActionNotKnown
                    LEA            $7A(A3),A0               ; * PalMap2
                    BSR.W          A0_gets_PalMap
                    BCLR.B         #4,$8A(A3)               ; no NoImage2 flag
SetPalette          MOVE.L         A6,D0
                    BEQ.W          IC_ArgMissing
                    MOVE.L         A6,$108(A0)              ; * cmap RGB bytes
                    BRA.W          IC_Add_NextTag

GetPalette1         LEA            $76(A3),A0               ; * PalMap1
                    BRA.S          GetPalette

GetPalette2         LEA            $7A(A3),A0               ; * PalMap2
GetPalette          MOVE.L         A3,D0                    ; DiskObject v44 ?
                    BEQ.W          IC_ActionNotKnown
                    MOVE.L         (A0),D0                  ; PalMap ?
                    BEQ.S          IC_ObjectWrongType
                    MOVEA.L        D0,A0                    ; PalMap
                    MOVE.L         A6,D0
                    BEQ.W          IC_ArgMissing
                    MOVE.L         $108(A0),(A6)            ; * cmap RGB bytes
                    BRA.W          IC_Add_NextTag

IC_ObjectWrongType  MOVEQ          #$6A,D6                  ; error 212
                    ADD.L          D6,D6
                    BRA.W          IC_PostBadTagItem

GetPaletteSize1     LEA            $76(A3),A0               ; * PalMap1
                    BRA.S          GetPaletteSize

GetPaletteSize2     LEA            $7A(A3),A0               ; * PalMap2
GetPaletteSize      MOVE.L         A3,D0                    ; DiskObject v44 ?
                    BEQ.W          IC_ActionNotKnown
                    MOVE.L         (A0),D0                  ; PalMap ?
                    BEQ.S          IC_ObjectWrongType
                    MOVEA.L        D0,A0                    ; PalMap
                    MOVE.L         A6,D0
                    BEQ.W          IC_ArgMissing
                    CLR.W          (A6)+
                    MOVE.W         $10E(A0),(A6)            ; number of colors
                    BRA.W          IC_Add_NextTag

SetPaletteSize1     MOVE.L         A3,D0                    ; DiskObject v44 ?
                    BEQ.W          IC_ActionNotKnown
                    LEA            $76(A3),A0               ; * PalMap1
                    BSR.W          A0_gets_PalMap
                    BRA.S          SetPaletteSize

SetPaletteSize2     MOVE.L         A3,D0                    ; DiskObject v44 ?
                    BEQ.W          IC_ActionNotKnown
                    LEA            $7A(A3),A0               ; * PalMap2
                    BSR.W          A0_gets_PalMap
                    BCLR.B         #4,$8A(A3)               ; no NoImage2 flag
SetPaletteSize      MOVE.L         A6,D0
                    BLE.W          IC_BadNumber
                    CMPA.W         #256,A6
                    BHI.W          IC_BadNumber
                    MOVE.W         D0,$10E(A0)              ; number of colors
                    SUBQ.L         #1,D0
                    CMP.B          $10D(A0),D0              ; transparent color
                    BCC.S          palettesizedone
transparencyoff     CLR.B          $10C(A0)                 ; no transparency
palettesizedone     BRA.W          IC_Add_NextTag

SetTransparentColor1
                    MOVE.L         A3,D0                    ; DiskObject v44 ?
                    BEQ.W          IC_ActionNotKnown
                    LEA            $76(A3),A0               ; * PalMap1
                    BSR.W          A0_gets_PalMap
                    BRA.S          SetTransparentColor

SetTransparentColor2
                    MOVE.L         A3,D0                    ; DiskObject v44 ?
                    BEQ.W          IC_ActionNotKnown
                    LEA            $7A(A3),A0               ; * PalMap2
                    BSR.W          A0_gets_PalMap
                    BCLR.B         #4,$8A(A3)               ; no NoImage2 flag
SetTransparentColor MOVE.L         A6,D0
                    BMI.S          transparencyoff
                    CMP.W          $10E(A0),D0              ; number of colors
                    BGE.W          IC_BadNumber
                    SLT            $10C(A0)                 ; use transparency
                    MOVE.B         D0,$10D(A0)              ; transparent color
                    BRA.W          IC_Add_NextTag

GetTransparentColor1
                    LEA            $76(A3),A0               ; * PalMap1
                    BRA.S          GetTransparentColor

GetTransparentColor2
                    LEA            $7A(A3),A0               ; * PalMap2
GetTransparentColor MOVE.L         A3,D0                    ; DiskObject v44 ?
                    BEQ.W          IC_ActionNotKnown
                    MOVEQ          #-1,D0                   ; opaque = failure
                    MOVE.L         (A0),D1                  ; PalMap ?
                    BEQ.S          .opaque
                    MOVEA.L        D1,A0                    ; PalMap
                    TST.B          $10C(A0)                 ; transparency ?
                    BEQ.S          .opaque
                    MOVEQ          #0,D0
                    MOVE.B         $10D(A0),D0              ; transparent color
.opaque             MOVE.L         A6,D1                    ; target address
                    BEQ.W          IC_ArgMissing
                    MOVE.L         D0,(A6)                  ; set result
                    BRA.W          IC_Add_NextTag

SetImageData1       MOVE.L         A3,D0                    ; DiskObject v44 ?
                    BEQ.W          IC_ActionNotKnown
                    LEA            $76(A3),A0               ; * PalMap1
                    MOVE.L         A6,D0
                    BEQ.S          dropimagedata
.palettemappeddata  BSR.W          A0_gets_PalMap
                    MOVE.L         A6,4(A0)                 ; * image data bytes
                    BRA.W          IC_Add_NextTag

dropimagedata       MOVE.L         (A0),D0                  ; PalMap ?
                    BEQ.S          .done
                    MOVEA.L        D0,A0                    ; PalMap
                    CLR.L          4(A0)                    ; * image data bytes
.done               BRA.W          IC_Add_NextTag


SetImageData2       MOVE.L         A3,D0                    ; DiskObject v44 ?
                    BEQ.W          IC_ActionNotKnown
                    LEA            $7A(A3),A0               ; * PalMap2
                    MOVE.L         A6,D0
                    BEQ.S          dropimagedata
.palettemappeddata  BSR.W          A0_gets_PalMap
                    MOVE.L         A6,4(A0)                 ; * image data bytes
                    BCLR.B         #4,$8A(A3)               ; clear NoImage2 flag
                    BRA.W          IC_Add_NextTag

GetImageData1       MOVE.L         A3,D0                    ; DiskObject v44 ?
                    BEQ.W          IC_ActionNotKnown
                    MOVE.L         $76(A3),D0               ; PalMap1 ?
                    BEQ.W          IC_ObjectWrongType
                    MOVEA.L        D0,A0                    ; PalMap1
                    BRA.S          GetImageData

GetImageData2       MOVE.L         A3,D0                    ; DiskObject v44 ?
                    BEQ.W          IC_ActionNotKnown
                    MOVE.L         $7A(A3),D0               ; PalMap2 ?
                    BEQ.W          IC_ObjectWrongType
                    MOVEA.L        D0,A1
                    CMPI.W         #1,$11C(A1)              ; mapping done ?
                    BHI.S          .skipcolormapping
.PalMapwascreated
 ifd RLEjit
                    TST.B          $11F(A1)                 ; RLE compressed ?
                    BMI.S          .RLEdecompression
 endif
                    TST.L          $86(A3)                  ; icons screen ?
                    BEQ.S          .skipcolormapping        ; fix for IconEdit
.RLEdecompression   MOVE.L         $1A(A3),D0               ; SelectRender
                    BEQ.S          .skipcolormapping
                    MOVE.L         D7,-(SP)
                    MOVEQ          #-1,D7                   ; color precision
                    MOVEA.L        $86(A3),A0               ; icons screen
                    BSR.W          imagecolormapping        ; map second image
                    MOVE.L         (SP)+,D7                 ; processed tags
.skipcolormapping   MOVEA.L        $7A(A3),A0               ; PalMap2
                    LEA            $82(A3),A1               ; *mask2 Select
                    BSR.W          makePalMapMask
                    MOVEA.L        $7A(A3),A0               ; PalMap2
GetImageData        MOVE.L         A6,D0
                    BEQ.W          IC_ArgMissing
                    MOVE.L         4(A0),(A6)
                    BRA.W          IC_Add_NextTag

IsNewIcon           MOVE.L         A6,D0
                    BEQ.W          IC_ArgMissing
                    TST.L          (SP)                     ; DiskObject ?
                    BEQ.W          IC_ArgMissing
                    MOVE.L         A3,D0                    ; DiskObject v44
                    BEQ.S          .returnbool
                    MOVE.L         $6A(A3),D0               ; * NewIcon ?
                    BEQ.S          .returnbool
                    MOVEQ          #1,D0                    ; return TRUE
.returnbool         MOVE.L         D0,(A6)
                    BRA.W          IC_Add_NextTag

SetAspectRatio      MOVE.L         A3,D0                    ; DiskObject v44
                    BEQ.W          IC_ActionNotKnown
                    MOVE.B         ti_Data+3(A2),$8C(A3)    ; it's soo easy!
                    BRA.W          IC_Add_NextTag

GetAspectRatio      MOVE.L         A3,D0                    ; DiskObject v44
                    BEQ.W          IC_ActionNotKnown
                    MOVE.L         A6,D0
                    BEQ.W          IC_ArgMissing
                    MOVE.B         $8C(A3),(A6)
                    BRA.W          IC_Add_NextTag

GetWidth            MOVEQ          #0,D1                    ; offset width
                    BRA.S          getsize

GetHeight           MOVEQ          #2,D1                    ; offset height
getsize             MOVE.L         A3,D0                    ; DiskObject v44
                    BEQ.W          IC_ActionNotKnown
                    MOVEA.L        $76(A3),A0
                    MOVE.L         A0,D0
                    BEQ.W          IC_ObjectWrongType
                    MOVEQ          #0,D0
                    MOVE.W         (A0,D1.L),D0
                    MOVE.L         A6,D1
                    BEQ.W          IC_ArgMissing
                    MOVE.L         D0,(A6)
                    BRA.W          IC_Add_NextTag

SetWidth            MOVEQ          #0,D1                    ; offset width
                    MOVEA.L        $26(A5),A0               ; execbase
                    MOVEA.L        ThisTask(A0),A0
                    MOVEA.L        $A(A0),A0                ; * task name
                    CMPI.L         #"Star",(A0)+
                    BNE.S          setsize
                    CMPI.L         #"tmen",(A0)+
                    BNE.S          setsize
                    CMPI.W         #$7500,(A0)              ; "Startmenu",0 ?
                    BNE.S          setsize
                    BRA.W          IC_NextTag               ; trashed width = 10
                                        
SetHeight           MOVEQ          #2,D1                    ; offset height
setsize             MOVE.L         A3,D0                    ; DiskObject v44
                    BEQ.W          IC_ActionNotKnown
                    LEA            $76(A3),A0               ; * PalMap1
                    BSR.W          A0_gets_PalMap           ; preserves D1 now ;)
                    MOVE.L         A6,D0
                    BLE.W          IC_BadNumber
                    CMPA.W         #256,A6
                    BHI.W          IC_BadNumber
                    MOVE.W         A6,(A0,D1.L)
                    MOVE.L         $7A(A3),D0               ; PalMap2 ?
                    BEQ.S          .done
                    MOVEA.L        D0,A0                    ; PalMap2
                    MOVE.W         A6,(A0,D1.L)
.done               BRA.W          IC_Add_NextTag

GetScreen           MOVE.L         A3,D0                    ; DiskObject v44
                    BEQ.W          IC_ActionNotKnown
                    MOVE.L         A6,D0
                    BEQ.W          IC_ArgMissing
                    MOVE.L         $86(A3),(A6)
                    BRA.W          IC_Add_NextTag

IC_BadScreenRequest MOVEA.L        $28(SP),A2               ; 0 or SetAllocAttribs
                    SUBQ.L         #1,D7                    ; related tag failed
                    BRA.W          IC_ActionNotKnown

IC_TagsDone         MOVEA.L        $128(A5),A2              ; GlobalScreen iconlib
                    MOVEA.L        $24(SP),A3               ; from SetGlobalScreen
                    CMPA.L         A3,A2
                    BEQ.W          IC_FinalSteps            ; no screen changes
                    MOVE.L         A2,D0
                    BEQ.S          .setglobalscreen
                    MOVE.L         A3,D0
                    BNE.S          IC_BadScreenRequest      ; 2 different screens!
.setglobalscreen    MOVE.L         A3,$128(A5)               ; set new GlobalScreen
 ifd MC68020
                    BEQ.S          .set_RTG_flag
                    MOVEA.L        sc_RastPort+rp_BitMap(A3),A0
                    MOVEA.L        $32(A5),A6               ; gfxbase
                    MOVEQ          #BMA_DEPTH,D1
                    JSR            _LVOGetBitMapAttr(A6)
                    SUBQ.L         #8,D0
.set_RTG_flag       SHI            $97A(A5)                 ; WB RTG mode = -1
 endif
                    MOVEA.L        $A2(A5),A3               ; list of v44 icons
                    MOVE.L         A2,D0
                    BNE.S          .releaseallpens          ; SetGlobalScreen = 0
 ifd MC68020
                    MOVEA.L        $26(A5),A6               ; execbase
                    MOVEA.L        ThisTask(A6),A6
                    SUBA.L         $974(A5),A6              ; Workbench task ?
 endif
 ifd RLEjit
                    BRA.W          .docolormapping          ; no old GlobalScreen
 else
                    BRA.S          .docolormapping          ; no old GlobalScreen
 endif

.freeiconcolors     CMPA.L         ($86-$62)(A3),A2         ; check icons screen
                    BNE.S          .nexticon
                    MOVEA.L        ($76-$62)(A3),A0         ; PalMap1
                    MOVEA.L        A2,A1                    ; old GlobalScreen
                    BSR.W          releasepens
                    MOVEA.L        ($7A-$62)(A3),A0         ; PalMap2
                    MOVEA.L        A2,A1                    ; old GlobalScreen
                    BSR.W          releasepens
                    CLR.L          ($86-$62)(A3)            ; remove icons screen
.nexticon           MOVEA.L        (A3),A3
.releaseallpens     TST.L          (A3)
                    BNE.S          .freeiconcolors
                    MOVEA.L        A2,A0                    ; old GlobalScreen
                    MOVEA.L        $12C(A5),A1              ; ScreenDrawInfo
                    MOVEA.L        $36(A5),A6               ; intuibase
                    JSR            _LVOFreeScreenDrawInfo(A6)
                    CLR.L          $12C(A5)                 ; remove old drawinfo
 ifd RLEjit
                    BRA.W          IC_FinalSteps
 else
                    BRA.S          IC_FinalSteps
 endif

.mapDiskObject      LEA            -$62(A3),A3              ; DiskObject base
                    BTST.B         #3,$8A(A3)               ; GlobalScreen flag ?
                    BEQ.S          .nextDiskObject
                    MOVEA.L        $76(A3),A0               ; PalMap1
                    BSR.W          checkpalmap
                    BEQ.S          .nextDiskObject
 ifd MC68020
.nocolorreduction   MOVEA.L        A6,A0                    ; delayed WB mapping
 endif
                    MOVEA.L        A3,A1                    ; DiskObject
                    MOVEM.L        $124(A5),D0-D1           ; GlobPrec GlobScreen
                    BSR.W          iconcolormapping
                    TST.L          D0                       ; only DOpus5 fails
                    BEQ.S          .colormappingdone
                    MOVEA.L        A3,A0                    ; DiskObject
                    BSR.W          map2systemcolors
.colormappingdone
 ifd RLEjit
                    TST.B          $97A(A5)                 ; TrueColor screen ?
                    BNE.S          .nextDiskObject
                    MOVE.L         $1A(A3),D0               ; SelectRender ?
                    BEQ.S          .nextDiskObject
                    MOVEA.L        D0,A0
                    TST.L          $A(A0)                   ; image2 after RLEjit
                    BEQ.S          .nextDiskObject
                    MOVEA.L        $7A(A3),A0               ; PalMap2
                    LEA            $82(A3),A1               ; *mask2
                    BSR.W          makePalMapMask
 endif
.nextDiskObject     MOVEA.L        $62(A3),A3               ; next icon list node
.docolormapping     TST.L          (A3)
                    BNE.S          .mapDiskObject
                    MOVEA.L        $128(A5),A0              ; new GlobalScreen
                    MOVEA.L        $36(A5),A6               ; intuibase
                    JSR            _LVOGetScreenDrawInfo(A6)
                    MOVE.L         D0,$12C(A5)              ; store new DrawInfo
                    BEQ.S          IC_FinalSteps
                    MOVEA.L        D0,A1                    ; new screens DrawInfo
                    MOVEA.L        dri_Pens(A1),A0
                    MOVE.W         (SHINEPEN*2)(A0),$BA(A5)
                    MOVE.W         (SHADOWPEN*2)(A0),$BC(A5)
                    MOVE.W         (BACKGROUNDPEN*2)(A0),$BE(A5)
IC_FinalSteps       MOVE.L         A4,D0
                    BEQ.S          .noerrorcodewanted
                    MOVE.L         D6,(A4)                  ; return errorcode
.noerrorcodewanted  TST.L          $2C(SP)                  ; GlobalEmbossRect
                    BNE.S          .tryWBupdate
                    TST.B          $30(SP)                  ; update workbench ?
                    BEQ.S          .noWBupdate
.tryWBupdate        MOVEQ          #$A,D0                   ; workbench
                    MOVEA.L        $26(A5),A6               ; execbase
                    JSR            _LVOPrivateOpenLibrary(A6)
                    TST.L          D0
                    BEQ.S          .noWBupdate
                    MOVEA.L        D0,A6                    ; wbbase
                    CMPI.W         #44,LIB_VERSION(A6)
                    BCS.S          .oldWBversion
                    MOVEQ          #1,D0                    ; TAG_IGNORE
                    MOVEA.L        D0,A0
                    MOVE.L         $2C(SP),D1               ; GlobalEmbossRect
                    BEQ.S          .nonewframesize
                    MOVE.L         #$8000A039,D0            ; framesize changed
.nonewframesize     TST.B          $30(SP)                  ; update workbench ?
                    MOVEA.W        $C4(A5),A1               ; GlobalFrameLess
                    BEQ.S          .sameframestate
                    LEA            $8000A040,A0             ; frameless changed
.sameframestate     CLR.L          -(SP)                    ; TAG_DONE
                    MOVEM.L        D0-D1/A0-A1,-(SP)
                    SUBA.L         A0,A0
                    MOVEA.L        SP,A1                    ; taglist pointer
                    JSR            _LVOWorkbenchControlA(A6)
                    LEA            $14(SP),SP
.oldWBversion       MOVEA.L        A6,A1                    ; wbbase
                    MOVEA.L        $26(A5),A6               ; execbase
                    JSR            _LVOCloseLibrary(A6)
.noWBupdate         MOVE.L         D7,D0                    ; number of tags done
                    MOVEM.L        (SP)+,D1/D6-D7/A1-A6
                    LEA            $10(SP),SP
                    RTS

;-------------------------------------------------------------------------

A0_gets_PalMap      TST.L          (A0)                     ; * PalMap ?
                    BNE.S          .return
                    MOVEM.L        D1/A0/A2/A6,-(SP)        ; D1 > SetWidth/Height
                    LEA            $4E(A3),A0               ; freelist
                    MOVEA.W        #$120,A1                 ; sizeof struct PalMap
                    LEA            MEMF_PUBLIC|MEMF_CLEAR,A2
                    BSR.W          FreeAlloc                ; needs no iconbase
                    MOVEM.L        (SP)+,D1/A0/A2
                    MOVE.L         D0,(A0)                  ; * new struct PalMap
                    BEQ.S          .outofmemory
                    MOVEA.L        D0,A1                    ; * new struct PalMap
                    MOVE.L         $76(A3),D0               ; if this is PalMap2
                    BEQ.S          .done                    ; is there a PalMap1 ?
                    MOVEA.L        D0,A6
                    MOVE.L         (A6),(A1)                ; copy width & height
.done               MOVEA.L        (SP)+,A6
.return             MOVEA.L        (A0),A0                  ; PalMap
                    RTS

.outofmemory        ADDQ.W         #8,SP                    ; no RTS, flush stack!
                    MOVEQ          #$67,D6                  ; error 103
                    BRA.W          IC_PostBadTagItem

;------------------------------------------------------------------

                    CNOP           0,4

; DrawIconStateA -- Draw an icon as if it were an image (V44)
; DrawIconStateA(rp,icon,label,leftEdge,topEdge,state,tags)
;                A0 A1   A2    D0       D1      D2    A3
; VOID DrawIconStateA(struct RastPort *rp,struct DiskObject *icon,
;                     STRPTR label,LONG leftEdge,LONG topEdge,
                            ULONG state,struct TagItem *tags);

DrawIconStateA      MOVE.L         A0,-(SP)                 ; rastport ?
                    BEQ.S          .quit
                    MOVE.L         A1,(SP)                  ; icon ?
                    BEQ.S          .quit
                    TST.W          $C(A1)                   ; icon width > 0 ?
                    BLE.S          .quit
                    TST.W          $E(A1)                   ; icon height > 0 ?
.quit               ADDQ.W         #4,SP
                    BGT.S          drawiconstate
DIS_quit            RTS

drawiconstate
 ifd MC68020
                    CMPI.W         #$E310,(A1)              ; DiskMagic found ?
 else
                    CMPI.B         #$E3,(A1)
 endif
                    BNE.S          DIS_quit
                    MOVE.L         $979-3(A6),-(SP)         ; Shadow, Outlinetext
                    CLR.L          -(SP)                    ; IsLink, Background
                    ADDQ.W         #1,(SP)                  ; EraseBackground = 1
                    CLR.L          -(SP)                    ; Borderless, Frameless
                    CLR.L          -(SP)                    ; DrawInfo dri_Pens
                    LEA            -$38(SP),SP              ; $38-$6F
                    MOVEM.L        D1-D7/A0-A6,-(SP)
                    MOVE.W         D0,(SP)                  ; (SP)=left/top edge
                    MOVEA.L        A1,A4                    ; DiskObject (V44 ?)
                    MOVEA.L        A6,A5                    ; iconbase
                    LEA            $5E(A1),A1
                    CMPA.L         (A1),A1                  ; magic selfpointer ?
                    BEQ.S          DIS_ReadTagList
                    SUBA.L         A4,A4                    ; old DiskObject
                    BRA.S          DIS_ReadTagList

DIS_Skip            SUBQ.L         #1,D0
                    BNE.S          DIS_TagItem
                    MOVE.L         (A3),D0
                    LSL.L          #3,D0
                    ADDA.L         D0,A3
DIS_Ignore          ADDQ.L         #4,A3
DIS_NextTag         MOVE.L         (A3)+,D0
                    BMI.S          DIS_TagItem
                    BEQ.S          DIS_TagsDone
                    SUBQ.L         #2,D0
                    BCS.S          DIS_Ignore
                    BNE.S          DIS_Skip
                    MOVEA.L        (A3),A3
DIS_ReadTagList     MOVE.L         A3,D0
                    BNE.S          DIS_NextTag
                    BRA.S          DIS_TagsDone

DIS_TagItem         MOVEA.L        A3,A0
                    MOVE.L         -(A0),D0                 ; TagItem
                    MOVEA.L        (A3)+,A1                 ; TagData
                    SUBI.L         #$8000905E,D0            ; - (ICONA_Dummy+94)
                    BNE.S          .noLabelOutline
                    SUB.L          A1,D0
                    MOVE.L         D0,A1
.LabelShadow        MOVE.L         A1,$7C(SP)               ; Outline=-1 Shadow=1
                    BRA.S          DIS_NextTag
                    
.noLabelOutline     ADDQ.L         #1,D0
                    BEQ.S          .LabelShadow
                    ADDQ.L         #4,D0                    ; (ICONA_Dummy+89)
                    BNE.S          NoLink
                    MOVE.W         A1,$7A(SP)               ; IsLink, always used
                    BRA.S          DIS_NextTag

NoLink              ADDQ.L         #6,D0
                    BEQ.S          Borderless
                    ADDQ.L         #6,D0
                    ADDQ.L         #6,D0
                    BEQ.S          EraseBackground
                    ADDQ.L         #1,D0
                    BEQ.S          Frameless
                    ADDQ.L         #4,D0
                    BNE.S          DIS_NextTag
                    MOVE.L         A1,D0                    ; DrawInfo
                    BEQ.S          DIS_NextTag
                    MOVE.L         dri_Pens(A1),$70(SP)
                    BRA.S          DIS_NextTag

Borderless          MOVE.W         A1,$74(SP)
                    BEQ.S          DIS_NextTag
Frameless           MOVE.W         A1,$76(SP)
                    BRA.S          DIS_NextTag

EraseBackground     MOVE.W         A1,$78(SP)
                    BRA.S          DIS_NextTag

DIS_TagsDone        LEA            $40(SP),A2               ; apen, bpen, drawmode
                    MOVEA.L        $1C(SP),A3               ; rastport
                    MOVEA.L        A3,A0                    ; rastport
                    MOVEA.L        $32(A5),A6               ; gfxbase
                    JSR            _LVOGetAPen(A6)
                    MOVE.W         D0,(A2)+                 ; store apen
                    MOVEA.L        A3,A0                    ; rastport
                    JSR            _LVOGetBPen(A6)
                    MOVE.W         D0,(A2)+                 ; store bpen
                    MOVEA.L        A3,A0                    ; rastport
                    JSR            _LVOGetDrMd(A6)
                    MOVE.W         D0,(A2)                  ; store drawmode
                    MOVEM.W        (SP),D3-D4               ; left edge, top edge
                    MOVEA.L        $20(SP),A2               ; DiskObject
                    MOVEM.W        $C(A2),D5-D6             ; icon width, height
                    LEA            $B2(A5),A0               ; * delta width height
                    ADD.W          (A0)+,D5                 ; width + delta width
                    ADD.L          D3,D5                    ; + left edge
                    SUBQ.L         #1,D5                    ; - 1
                    ADD.W          (A0),D6                  ; height + delta height
                    ADD.L          D4,D6                    ; + top edge
                    MOVE.W         D6,$3C(SP)               ; save bottom
                    SUBQ.L         #1,D6                    ; - 1
                    ADDQ.W         #6,A0
                    MOVEM.W        (A0),D0-D1/D7            ; get global pens
                    EXG            D1,D7
                    MOVEA.L        $70(SP),A0               ; DrawInfo dri_pens
                    MOVE.L         A0,D2
                    BEQ.S          .savepens
                    MOVEM.W        6(A0),D0/D7              ; dri SHINE, SHADOWPEN
                    MOVE.W         $E(A0),D1                ; dri BACKGROUNDPEN
.savepens           MOVEM.W        D1/D7,$38(SP)
                    CMP.W          D0,D7
                    BNE.S          .differentpens
                    MOVE.L         D1,D0                    ; SHINE <= BACKGROUND
.differentpens      MOVE.B         $C4+1(A5),D1             ; GlobalFrameless
                    BGT.W          .noframe
                    TST.W          $76(SP)                  ; frameless ?
                    BNE.W          .noframe
                    MOVE.L         A4,D2                    ; DiskObject v44 ?
                    BEQ.S          .skipflag
                    TST.L          $76(A4)                  ; PalMap1 ?
                    BEQ.S          .skipflag
                    TST.B          D1                       ; planar frames only ?
                    BMI.W          .noframe
                    BTST.B         #0,$8A(A4)               ; V44 frameless flag ?
                    BNE.W          .noframe
.skipflag           MOVE.L         4(SP),D1                 ; state
                    SUBQ.L         #1,D1                    ; SELECTED
                    BEQ.S          .selectedstate
                    SUBQ.L         #5,D1                    ; INACTIVESELECTED
                    BEQ.S          .selectedstate
                    SUBQ.L         #2,D1                    ; SELECTEDDISABLED
                    BNE.S          .unselectedstate
.selectedstate      EXG            D7,D0                    ; apen SHINE sel=SHADOW
.unselectedstate    MOVE.W         $42(SP),D1               ; bpen
                    MOVEQ          #1,D2                    ; mode
                    MOVEA.L        A3,A1                    ; rastport
                    JSR            _LVOSetABPenDrMd(A6)
                    MOVE.L         D3,D0                    ; x word left edge
                    MOVE.L         D6,D1                    ; low edge
                    SUBQ.W         #1,D1                    ; y word low edge - 1
                    MOVEA.L        A3,A1                    ; rastport
                    JSR            _LVOMove(A6)
                    MOVE.L         D3,D0                    ; x word left edge
                    MOVE.L         D4,D1                    ; y word top edge
                    MOVEA.L        A3,A1                    ; rastport
                    LEA            _LVODraw(A6),A2
                    JSR            (A2)                     ; draw a line to x,y
                    MOVE.L         D5,D0
                    SUBQ.W         #1,D0                    ; x word right edge - 1
                    MOVE.L         D4,D1                    ; y word top edge
                    MOVEA.L        A3,A1                    ; rastport
                    JSR            (A2)
                    MOVE.L         D7,D0                    ; apen SHADOW sel=SHINE
                    MOVEA.L        A3,A1                    ; rastport
                    JSR            _LVOSetAPen(A6)
                    MOVE.L         D5,D0                    ; x word right edge
                    MOVE.L         D4,D1
                    ADDQ.W         #1,D1                    ; y word top edge + 1
                    MOVEA.L        A3,A1                    ; rastport
                    JSR            _LVOMove(A6)
                    MOVE.L         D5,D0                    ; x word right edge
                    MOVE.L         D6,D1                    ; y word low edge
                    MOVEA.L        A3,A1                    ; rastport
                    JSR            (A2)
                    MOVE.L         D3,D0                    ; left edge
                    ADDQ.W         #1,D0                    ; x word left edge + 1
                    MOVE.L         D6,D1                    ; y word low edge
                    MOVEA.L        A3,A1                    ; rastport
                    JSR            (A2)
                    MOVE.W         $38(SP),D0               ; apen = BACKGROUNDPEN
                    MOVEA.L        A3,A1                    ; rastport
                    JSR            _LVOSetAPen(A6)
                    ADDQ.W         #1,D3                    ; left edge + 1
                    ADDQ.W         #1,D4                    ; top edge + 1
                    SUBQ.W         #1,D5                    ; right edge - 1
                    SUBQ.W         #1,D6                    ; low edge - 1
                    MOVE.L         D3,D0                    ; xmin word
                    MOVE.L         D4,D1                    ; ymin word
                    MOVE.L         D5,D2                    ; xmax word
                    EXG            D6,D3                    ; ymax word
                    MOVEA.L        A3,A1                    ; rastport
                    JSR            _LVORectFill(A6)
                    SUBQ.W         #1,D6                    ; left edge
                    SUBQ.W         #1,D4                    ; top edge
                    MOVE.W         $B6(A5),D5               ; MinX
                    ADD.W          D6,D5                    ; left edge + MinX
                    MOVE.W         $B8(A5),D6               ; MinY
                    ADD.W          D4,D6                    ; top edge + MinY
                    BRA.S          .processimage

.noframe            TST.W          $78(SP)                  ; erase background ?
                    BEQ.S          .keepbackground
                    TST.W          $74(SP)                  ; borderless ?
                    BEQ.S          .erasebackground
                    MOVEM.W        $C(A2),D5-D6             ; icon width, height
                    ADD.W          D3,D5                    ; left edge + width
                    SUBQ.W         #1,D5                    ; - 1 = right edge
                    ADD.W          D4,D6                    ; top edge + height
.erasebackground    SUBQ.W         #1,D6                    ; - 1 = low edge
                    MOVE.L         D3,D0                    ; xmin word
                    MOVE.L         D4,D1                    ; ymin word
                    MOVE.L         D5,D2                    ; xmax word
                    MOVE.L         D6,D3                    ; ymax word
                    MOVEA.L        A3,A1                    ; rastport
                    JSR            _LVOEraseRect(A6)
.keepbackground     MOVEM.W        (SP),D5-D6               ; left edge, top edge
                    TST.W          $74(SP)                  ; borderless ?
                    BNE.S          .isborderless
                    ADD.W          $B6(A5),D5               ; left edge + MinX
                    ADD.W          $B8(A5),D6               ; top edge + MinY
.isborderless       MOVE.W         $E(A2),D0                ; height
                    ADD.W          D6,D0                    ; top + height + MinY
                    MOVE.W         D0,$3C(SP)               ; store bottom
.processimage       MOVEA.L        $20(SP),A0               ; icon
                    MOVEQ          #0,D7                    ; SelectRender unknown
                    MOVE.L         4(SP),D0                 ; state
                    SUBQ.L         #1,D0                    ; SELECTED
                    BEQ.S          .selectedimage
                    SUBQ.L         #5,D0                    ; INACTIVESELECTED
                    BEQ.S          .selectedimage
                    SUBQ.L         #2,D0                    ; SELECTEDDISABLED
                    BNE.S          .unselectedimage
.selectedimage      MOVE.L         $1A(A0),D0               ; SelectRender
                    BEQ.S          .noSelectRender
                    MOVEA.L        D0,A2
                    MOVE.L         A4,D1                    ; V44 DiskObject ?
 ifd MC68020
                    BEQ.W          .checkimage
 else
                    BEQ.S          .checkimage
 endif
                    BTST           #7,$8A(A0)               ; PalMaps disabled ?
                    BNE.S          .trymask2
                    TST.L          $76(A4)                  ; PalMap1 ?
                    BEQ.S          .trymask2
                    MOVE.L         $7A(A4),D2               ; PalMap2 ?
                    BEQ.S          .trymask2
                    MOVEA.L        D2,A1
                    TST.W          $11C(A1)                 ; colormapping done ?
                    BNE.S          .trymask2
                    MOVE.L         A3,-(SP)                 ; rastport
                    MOVEA.L        A4,A3                    ; DiskObject
                    MOVEA.L        $86(A3),A0               ; icons screen
                    BSR.W          imagecolormapping        ; D7 = precision = 0
                    BEQ.S          .createmask2now
                    MOVEA.L        (SP)+,A3                 ; restore rastport
                    MOVEA.L        D2,A0                    ; PalMap2 was delayed
                    CLR.W          $11C(A0)                 ; colormapping failed
 ifd MC68020
                    TST.B          $97A(A5)                 ; TrueColor flag set ?
                    BMI.S          .trymask2
 endif
                    MOVEA.L        $16(A4),A2               ; GadgetRender again
                    MOVEQ          #2,D0
                    MOVE.L         D0,4(SP)                 ; state = DISABLED
                    BRA.S          .trymask1
.createmask2now                                             ; (SP)= A3 = rastport
.makePalMapMask     MOVEA.L        D2,A0                    ; PalMap2
                    LEA            $82(A3),A1               ; **mask2
                    BSR.W          makePalMapMask
                    MOVEA.L        (SP)+,A3                 ; restore rastport
.trymask2           MOVEA.L        $82(A4),A4               ; *mask2
 ifd MC68020
                    BRA.S          .checkstate
 else
                    BRA.S          .checkmask
 endif

.noSelectRender     MOVEQ          #-1,D7                   ; has no SelectRender
.unselectedimage    MOVEA.L        $16(A0),A2               ; GadgetRender
                    MOVE.L         A4,D0                    ; V44 DiskObject ?
 ifd MC68020
                    BEQ.W          .checkimage
.trymask1           MOVEA.L        $7E(A4),A4               ; *mask1
.checkstate         MOVE.L         4(SP),D0                 ; state
                    SUBQ.L         #2,D0                    ; DISABLED
                    BEQ.W          .checkmask
                    SUBQ.L         #5,D0                    ; INTERACTIVEDISABLED
                    BEQ.W          .checkmask
                    SUBQ.L         #1,D0                    ; SELECTEDDISABLED
                    BEQ.W          .checkmask
                    MOVEA.L        $20(SP),A0               ; icon
                    BTST           #7,$8A(A0)               ; PalMaps disabled ?
                    BNE.W          .checkmask
                    MOVEA.L        $7A(A0),A1               ; PalMap2
                    CMPA.L         $1A(A0),A2
                    BEQ.S          .checkPalMap
                    MOVEA.L        $76(A0),A1               ; PalMap1
.checkPalMap        MOVE.L         A1,D0
                    BEQ.W          .checkmask
                    MOVEQ          #0,D2                    ; no default ghosting
                    BTST           #2,$8A(A0)               ; is this a deficon ?
                    BEQ.S          .checkthedepth
                    TST.B          $10C(A1)                 ; is transparency on ?
                    BEQ.S          .checkthedepth
                    TST.B          $97B(A5)                 ; is ghosting wanted ?
                    BNE.S          .checkthedepth
                    MOVE.L         do_ToolTypes(A0),D0      ; ToolArray ?
                    BEQ.S          .enableghosting
                    MOVE.L         #"nogh",D1
.nexttooltype       MOVEA.L        D0,A0
                    MOVE.L         (A0)+,D0                 ; ToolType ?
                    BEQ.S          .enableghosting
                    EXG            D0,A0
                    MOVE.L         (A0),D2                  ; get 4 characters
                    OR.L           lowercasefilter(PC),D2
                    SUB.L          D1,D2
                    BEQ.S          .checkthedepth           ; found "NoGhost"
                    BRA.S          .nexttooltype

.enableghosting     MOVEQ          #-1,D2
.checkthedepth      TST.L          $120(A5)                 ; cgxbase ?
                    BEQ.S          .checkghosting
                    MOVE.L         A1,-(SP)
                    MOVEA.L        4(A3),A0                 ; rastport bitmap
                    MOVEQ          #BMA_DEPTH,D1
                    JSR            _LVOGetBitMapAttr(A6)
                    MOVEA.L        (SP)+,A1                 ; PalMap
                    SUBQ.L         #8,D0
                    SGT            $97A(A5)                 ; WB RTG flag = -1
                    BLE.S          .checkghosting
                    PEA            .notdisabled(PC)
                    MOVEM.L        D2-D7/A2-A6,-(SP)
                    MOVEM.W        $30(SP),D3-D4            ; X, Y position
                    TST.W          $30+$74(SP)              ; borderless ?
                    BNE.W          DirectDrawing
                    TST.W          $30+$76(SP)              ; frameless ?
                    BNE.S          .drawnoframe
                    TST.B          $C4+1(A5)                ; GlobalFrameless ?
                    BGT.S          .drawnoframe
                    ADD.W          $B6(A5),D3               ; LeftEdge + MinX
                    ADD.W          $B8(A5),D4               ; TopEdge + MinY
                    BRA.W          DirectDrawing            ; RTS .notdisabled

.drawnoframe        ADDQ.L         #1,D3                    ; but add a border
                    ADDQ.L         #1,D4
                    BRA.W          DirectDrawing            ; RTS .notdisabled

.checkghosting      TST.L          D2                       ; is ghosting set ?
                    BEQ.S          .checkmask
                    MOVEA.L        A1,A0                    ; PalMap
                    MOVE.L         A3,-(SP)
                    MOVEA.L        4+$20(SP),A3             ; icon
                    LEA            $7E(A3),A4               ; **mask1 Gadget
                    CMPA.L         $16(A3),A2
                    BEQ.S          .fakemask
                    ADDQ.W         #4,A4
.fakemask           MOVEA.L        A4,A1
                    BSR.W          makePalMapMask
                    MOVEA.L        (SP)+,A3
                    MOVEA.L        (A4),A4                  ; *mask
 else ; MC68000
                    BEQ.S          .checkimage
.trymask1           MOVEA.L        $7E(A4),A4               ; *mask1
 endif

.checkmask          MOVE.L         A4,D0
                    BEQ.S          .nomask
                    MOVEA.L        (A4),A4                  ; get mask plane
.nomask             
 ifd MC68020
                    TST.B          $97A(A5)                 ; TrueColor flag set ?
                    BEQ.S          .checkimage
                    MOVE.L         A3,-(SP)
                    MOVEA.L        4+$20(SP),A3             ; icon
                    BTST           #7,$8A(A3)               ; PalMaps disabled ?
                    BNE.S          .image1done
                    MOVE.L         $76(A3),D1               ; PalMap1 ?
                    BEQ.S          .image1done
                    MOVEA.L        D1,A1
                    TST.W          $11C(A1)
                    BNE.S          .image1done
                    MOVEA.L        $86(A3),A0               ; icons screen
                    MOVE.L         $16(A3),D0               ; GadgetRender
                    BSR.W          imagecolormapping        ; D7 = precision = -1
.image1done         MOVEA.L        (SP)+,A3
 endif
.checkimage         MOVEA.L        A2,A0                    ; Gadget or SelectRender
                    BSR.W          checkimage
                    BEQ.W          .done                    ; badimage
                    MOVEA.L        A2,A0                    ; image
                    LEA            $48(SP),A1               ; 40 bytes bitmap
                    BSR.W          preparebitmap
                    MOVEA.L        4(A3),A0                 ; rastport bitmap
                    MOVE.B         5(A0),D0                 ; bitmap depth
                    MOVEQ          #8,D1
                    CMP.B          D1,D0
                    BLS.S          .depthfits
                    MOVEQ          #8,D0                    ; limit to 8 planes
.depthfits          MOVEA.L        A4,A5
                    LEA            $48(SP),A4               ; bitmap buffer
                    CMP.B          8+1(A2),D0               ; screen - image depth
                    BLE.S          .noextraplanes
                    TST.B          D7                       ; SelectRender ?
                    BEQ.S          .hasSelectRender
                    MOVEQ          #0,D0                    ; transparent
                    MOVEA.L        A3,A1                    ; rastport
                    JSR            _LVOSetAPen(A6)
                    MOVEM.W        4(A2),D2-D3              ; image width, height
                    SUBQ.W         #1,D2
                    SUBQ.W         #1,D3
                    MOVE.L         D5,D0                    ; minx word
                    MOVE.L         D6,D1                    ; miny word
                    ADD.W          D5,D2                    ; maxx word
                    ADD.W          D6,D3                    ; maxy word
                    MOVE.W         (A4),D4                  ; bytes/row word
                    MOVEA.L        A5,A0                    ; mask
                    MOVEA.L        A3,A1                    ; rastport
                    JSR            _LVOBltPattern(A6)
                    BRA.S          .noextraplanes

.hasSelectRender    MOVE.B         D0,$48+5(SP)             ; save depth in buffer
.noextraplanes      MOVEM.L        D5-D6/A2,-(SP)
                    MOVEQ          #0,D0                    ; source x
                    MOVEQ          #0,D1                    ; source y
                    MOVE.L         D5,D2                    ; dest x
                    MOVE.L         D6,D3                    ; dest y
                    MOVEM.W        4(A2),D4-D5              ; image width, height
                    MOVEA.L        A4,A0                    ; source bitmap
                    MOVEA.L        A3,A1                    ; dest rastport
                    MOVE.L         A5,D6                    ; mask ?
                    BEQ.S          .masknotavailable
.notAros            MOVEQ          #$20,D6                  ; minterm, why not $3A?
                    TST.B          D7                       ; SelectRender ?
                    BNE.S          .noselectedmask
                    MOVEQ          #$70,D6                  ; $CA wont work native!
                    ADD.L          D6,D6                    ; minterm = $E0 masked
.noselectedmask     MOVEA.L        A5,A2                    ; blit mask
                    JSR            _LVOBltMaskBitMapRastPort(A6)
                    BRA.S          .blitimagedone

.masknotavailable   MOVEQ          #$33,D6                  ; minterm = $33 invert
                    TST.B          D7                       ; SelectRender ?
                    BNE.S          .nosecondimage
                    MOVEQ          #$66,D6
                    ADD.L          D6,D6                    ; minterm = $CC copy
.nosecondimage      JSR            _LVOBltBitMapRastPort(A6)
.blitimagedone      MOVEM.L        (SP)+,D5-D6/A2
                    MOVE.L         4(SP),D0                 ; state
                    SUBQ.L         #2,D0                    ; DISABLED
                    BEQ.S          .disabled
                    SUBQ.L         #5,D0                    ; INTERACTIVEDISABLED
                    BEQ.S          .disabled
                    SUBQ.L         #1,D0                    ; SELECTEDDISABLED
                    BNE.S          .notdisabled
.disabled           MOVE.W         $3A(SP),D0               ; apen = SHADOWPEN
                    MOVEQ          #0,D1                    ; bpen = transparent
                    MOVEQ          #0,D2                    ; mode = JAM 1 color
                    MOVEA.L        A3,A1                    ; rastport
                    JSR            _LVOSetABPenDrMd(A6)
                    MOVE.B         $1D(A3),$3E(SP)          ; save AreaPtSz
                    MOVE.L         8(A3),$38(SP)            ; save AreaPtrn
                    LEA            AreaFillPattern(PC),A0
                    MOVE.L         A0,8(A3)                 ; AreaPtrn = Pattern
                    MOVE.B         #1,$1D(A3)               ; AreaPtSz = 2^1 words
 ifd MC68020
                    MOVE.L         D5,D0                    ; minx word
                    MOVE.L         D6,D1                    ; miny word
                    MOVE.L         D5,D2
                    SUBQ.L         #1,D2
                    MOVE.L         D6,D3
                    SUBQ.L         #1,D3
 else
                    MOVE.W         D5,D0
                    MOVE.W         D6,D1
                    MOVE.W         D5,D2
                    SUBQ.W         #1,D2
                    MOVE.W         D6,D3
                    SUBQ.W         #1,D3
 endif
                    MOVEA.L        A3,A1                    ; RastPort
                    MOVE.L         A5,D4
                    BEQ.S          .withoutmask
                    ADD.W          4(A2),D2                 ; maxx=minx-1+image w
                    ADD.W          6(A2),D3                 ; maxy=miny-1+image h
                    MOVE.W         (A4),D4                  ; bytes/row word
                    MOVEA.L        A5,A0                    ; mask
                    JSR            _LVOBltPattern(A6)
                    BRA.S          .greyoutdone
.withoutmask        MOVEA.L        $20(SP),A0               ; icon
                    ADD.W          $C(A0),D2                ; maxx=minx-1+icon w
                    ADD.W          $E(A0),D3                ; maxy=miny-1+icon h
                    JSR            _LVORectFill(A6)
.greyoutdone        MOVE.L         $38(SP),8(A3)            ; restore AreaPtrn
                    MOVE.B         $3E(SP),$1D(A3)          ; restore AreaPtSz
.notdisabled        MOVEM.L        $20(SP),A1-A2            ; icon, label
                    MOVE.W         $C(A1),D4                ; icon width
                    MOVE.L         A2,D0
                    BEQ.W          .nolabel
                    MOVEA.L        A2,A0
.countcharacters    TST.B          (A0)+
                    BNE.S          .countcharacters
                    SUBA.L         A2,A0
                    SUBQ.W         #1,A0
                    MOVE.L         A0,D6                    ; string length
                    BEQ.W          .nolabel
                    EXG            D0,A0                    ; string <-> length
                    MOVEA.L        A3,A1                    ; rastport
                    JSR            _LVOTextLength(A6)
                    MOVE.L         D0,D7                    ; pixel lenght
                    SUB.W          D7,D4                    ; icon-text width
                    BPL.S          .shorttext
                    ADDQ.W         #1,D4                    ; diff + 1
.shorttext          ASR.W          #1,D4                    ; diff / 2
                    ADD.W          D5,D4                    ; left edge + diff/2
                    MOVE.W         $3C(SP),D5               ; bottom
                    ADDQ.W         #1,D5                    ; bottom + 1
                    MOVE.W         $42(SP),D0               ; apen <= bpen
                    MOVEA.L        A3,A1                    ; rastport
                    JSR            _LVOSetAPen(A6)
                    MOVE.L         D4,D0                    ; left edge + diff/2
                    SUBQ.W         #1,D0                    ; minx word
                    MOVE.L         D5,D1                    ; bottom
                    SUBQ.W         #1,D1                    ; miny word
                    MOVE.L         D4,D2
                    ADD.W          D7,D2                    ; maxx word
                    MOVE.W         $3A(A3),D3               ; TxHeight
                    ADD.W          D5,D3                    ; maxy word
                    MOVEA.L        A3,A1                    ; rastport
                    MOVEQ          #1,D7
                    CMP.W          $44(SP),D7               ; DrawMode = JAM2
                    BNE.S          .notJAM2
                    JSR            _LVORectFill(A6)
                    BRA.S          .writelabel

.notJAM2            JSR            _LVOEraseRect(A6)
.writelabel         MOVE.W         $7A(SP),D7               ; is it a link ?
                    BEQ.S          .nolink
                    MOVEQ          #1,D0                    ; style UNDERLINE
                    MOVEQ          #1,D1                    ; enable bit 1
                    MOVEA.L        A3,A1                    ; rastport
                    JSR            _LVOSetSoftStyle(A6)
.nolink
                    MOVEM.W        $40(SP),D0-D2            ; apen, bpen, mode
                    EXG            D0,D1
                    MOVEA.L        A3,A1                    ; rastport
                    JSR            _LVOSetABPenDrMd(A6)
                    ADD.W          $3E(A3),D5               ; TxBaseline
                    LEA            _LVOMove(A6),A4
                    LEA            _LVOText(A6),A5
                    MOVE.B         $7F(SP),D1               ; outline or shadow
                    BEQ.S          .backgrounddone
                    MOVE.L         D4,D0                    ; x = middle
                    ADDQ.L         #1,D4                    ; x = right
                    TST.B          D1
                    BGT.S          .writeshadowtext
                    CMPI.W         #$4EF9,(A4)              ; is it a JMP ?
                    BNE.S          .checkthetextcall
                    MOVEA.L        2(A4),A4
.checkthetextcall   CMPI.W         #$4EF9,(A5)              ; is it a JMP ?
                    BNE.S          .writeoutlinetext
                    MOVEA.L        2(A5),A5
.writeoutlinetext   ADDQ.L         #2,D5                    ; 1down + bottom
                    BSR.S          .writelabeltext1
                    SUBQ.L         #2,D4                    ; left bottom
                    BSR.S          .writelabeltext0
                    SUBQ.L         #1,D5                    ; left
                    BSR.S          .writelabeltext0
                    SUBQ.L         #1,D5                    ; top left
                    BSR.S          .writelabeltext0
                    ADDQ.L         #1,D4                    ; top
                    BSR.S          .writelabeltext0
                    ADDQ.L         #1,D4                    ; top right
                    BSR.S          .writelabeltext0
                    ADDQ.L         #1,D5                    ; right
                    BSR.S          .writelabeltext0
.writeshadowtext    ADDQ.L         #1,D5                    ; right bottom
                    BSR.S          .writelabeltext0
                    SUBQ.L         #1,D4                    ; center
                    SUBQ.L         #1,D5                    ; center
.backgrounddone     MOVEM.W        $40(SP),D0-D1            ; apen, bpen
                    MOVEA.L        A3,A1                    ; rastport
                    JSR            _LVOSetABPenDrMd(A6)
                    BSR.S          .writelabeltext0
                    TST.W          D7                       ; was it a link ?
                    BEQ.S          .done
                    MOVEQ          #0,D0                    ; style NORMAL
                    MOVEQ          #1,D1                    ; enable bit 1
                    MOVEA.L        A3,A1                    ; rastport
                    JSR            _LVOSetSoftStyle(A6)
                    BRA.S          .done

.writelabeltext0    MOVE.L         D4,D0                    ; x offset
.writelabeltext1    MOVE.L         D5,D1                    ; y offset
                    MOVEA.L        A3,A1                    ; rastport
                    JSR            (A4)                     ; Move()
                    MOVE.L         D6,D0                    ; lenght
                    MOVEA.L        A2,A0                    ; string
                    MOVEA.L        A3,A1                    ; rastport
                    JMP            (A5)                     ; Text()

.nolabel            MOVEM.W        $40(SP),D0-D2            ; apen, bpen, mode
                    MOVEA.L        A3,A1                    ; rastport
                    JSR            _LVOSetABPenDrMd(A6)
.done               MOVEM.L        (SP)+,D1-D7/A0-A6
                    LEA            $48(SP),SP
                    RTS

;------------------------------------------------------------------

                    CNOP           0,4

; GetIconRectangleA -- Query the size of the area an icon renders into (V44)
; success = GetIconRectangleA(rp,icon,label,rectangle,tags)
; D0                          A0 A1   A2    A3        A4
; BOOL GetIconRectangleA(struct RastPort *rp,struct DiskObject *icon,
;                        STRPTR label,struct Rectangle *rectangle,
;                        struct TagItem *tags)
;
; used by Workbench to sort and align icons on a screen or in a window

GetIconRectangleA   MOVE.L         A1,D0                    ; icon ?
                    BEQ.S          .fail
                    MOVE.L         A3,D0                    ; rectangle ?
.fail               BEQ.W          .quit
                    MOVE.L         A2,D0                    ; label ?
                    ADD.L          A4,D0                    ; + tags ?
                    BHI.S          .geticonrectangle
                    MOVEA.L        A3,A0                    ; rectangle
                    CLR.L          (A0)+                    ; ra_MinX, ra_MinY
                    MOVE.L         $C(A1),(A0)              ; icon width, height
                    TST.B          $C4+1(A6)                ; GlobalFrameless ?
                    BPL.S          .defaulticonframe
                    LEA            $5E(A1),A1               ; PlanarFramesOnly !
                    CMPA.L         (A1),A1                  ; magic selfpointer ?
                    BNE.S          .defaulticonframe
                    TST.L          $76-$5E(A1)              ; PalMap1 ?
                    BEQ.S          .defaulticonframe
                    ADDQ.W         #1,(A0)+                 ; width  + 2 - 1
                    ADDQ.W         #1,(A0)                  ; height + 2 - 1
                    MOVEQ          #1,D0                    ; result = OK
                    RTS                    

.defaulticonframe   MOVE.L         $B2(A6),D0               ; delta width, height
                    SUBQ.W         #1,D0
                    ADD.L          D0,(A0)
                    SUBQ.W         #1,(A0)
                    MOVEQ          #1,D0                    ; result = OK
                    RTS                    

.geticonrectangle   MOVEM.L        D2-D7/A4/A6,-(SP)
                    MOVEM.W        $C(A1),D5-D6             ; icon width, height
                    MOVE.B         $979(A6),D7              ; Shadow, Outlinetext
                    MOVEQ          #0,D2                    ; border on by default
                    TST.B          $C4+1(A6)                ; GlobalFrameless ?
                    BPL.S          .ReadTagList
                    LEA            $5E(A1),A1
                    CMPA.L         (A1),A1                  ; magic selfpointer ?
                    BNE.S          .ReadTagList
                    TST.L          $76-$5E(A1)              ; PalMap1 ?
                    SNE            D2                       ; frameless ColorIcons
                    BRA.S          .ReadTagList

.TagItem            MOVEA.L        A4,A1
                    MOVE.L         -(A1),D0                 ; TagItem
                    MOVE.L         (A4)+,D1                 ; TagData
                    SUBI.L         #$8000905E,D0            ; - (ICONA_Dummy+94)
                    BNE.S          .noLabelOutline
                    NEG.B          D1                       ; LabelOutline = -1
.LabelShadow        MOVE.B         D1,D7                    ; LabelShadow  =  1
                    BRA.S          .NextTag
                    
.noLabelOutline     ADDQ.L         #1,D0                    ; (ICONA_Dummy+93)
                    BEQ.S          .LabelShadow
                    MOVEQ          #10,D3
                    ADD.L          D3,D0                    ; (ICONA_Dummy+83)
                    BNE.S          .NextTag
                    TST.L          D1
                    BEQ.S          .NextTag
                    MOVEQ          #1,D2                    ; borderless = TRUE
                    BRA.S          .NextTag

.Skip               SUBQ.L         #1,D0
                    BNE.S          .TagItem
                    MOVE.L         (A4),D0
                    LSL.L          #3,D0
                    ADDA.L         D0,A4
.Ignore             ADDQ.W         #4,A4
.NextTag            MOVE.L         (A4)+,D0
                    BMI.S          .TagItem
                    BEQ.S          .TagsDone
                    SUBQ.L         #2,D0
                    BCS.S          .Ignore
                    BNE.S          .Skip
                    MOVEA.L        (A4),A4
.ReadTagList        MOVE.L         A4,D0
                    BNE.S          .NextTag
.TagsDone           MOVEA.L        A0,A4                    ; save rastport
                    MOVE.L         D5,D3                    ; copy width
                    TST.L          D2
                    BEQ.S          .addiconframe
                    SUBQ.L         #1,D2                    ; borderless=TRUE ?
                    BEQ.S          .borderless
                    MOVEQ          #1,D2                    ; MinX=1 = framesize
                    ADD.W          $B2(A6),D5               ; width + delta width
                    ADDQ.L         #2,D6                    ; height + 2
                    BRA.S          .borderless              ; frameless ColorIcon

.addiconframe       LEA            $B2(A6),A0               ; * delta width height
                    ADD.W          (A0)+,D5                 ; width + delta width
                    ADD.W          (A0)+,D6                 ; height + delta height
                    MOVE.W         (A0),D2                  ; GlobalEmbossRect MinX
.borderless         MOVE.L         A4,D4                    ; rastport supplied ?
                    BEQ.S          .setresult
                    MOVEA.L        A4,A1                    ; rastport
                    MOVEQ          #0,D4                    ; ra_MinX = 0
                    MOVE.L         A2,D0                    ; label ?
                    BEQ.S          .setresult
                    MOVEA.L        A2,A0                    ; label text string
.countchars         TST.B          (A0)+
                    BNE.S          .countchars
                    SUBQ.W         #1,A0
                    SUBA.L         A2,A0
                    EXG            D0,A0                    ; string <-> length
                    ADD.W          $3A(A4),D6               ; height + TxHeight
                    ADDQ.L         #2,D6                    ; height + 2
                    TST.B          D7                       ; outline or shadow ?
                    BEQ.S          .gettextlength
                    BPL.S          .shadowicontext
                    ADDQ.L         #1,D6                    ; outline
.shadowicontext     ADDQ.L         #1,D6
.gettextlength      MOVEA.L        $32(A6),A6               ; gfxbase
                    JSR            _LVOTextLength(A6)
                    SUB.W          D0,D3                    ; width - text width
                    BPL.S          .shorttext
                    ADDQ.W         #1,D3
.shorttext          ASR.W          #1,D3
                    ADD.W          D3,D2
                    BGT.S          .ra_MinXok
                    MOVE.W         D2,D4
                    SUBQ.W         #1,D4                    ; ra_MinX < 0
.ra_MinXok          ADD.W          D2,D0
                    CMP.W          D0,D5
                    BGT.S          .setresult
                    MOVE.W         D0,D5
                    BRA.S          .ra_MaxXok

.setresult          SUBQ.W         #1,D5
.ra_MaxXok          SUBQ.W         #1,D6
                    MOVEA.L        A3,A0                    ; rectangle
                    MOVE.W         D4,(A0)+                 ; ra_MinX  ra_MinY = 0
                    MOVE.L         D5,(A0)+                 ; ra_MaxX = width  - 1
                    MOVE.W         D6,(A0)                  ; ra_MaxY = height - 1
                    MOVEM.L        (SP)+,D2-D7/A4/A6
                    MOVEQ          #1,D0                    ; result = OK
.quit               RTS

;------------------------------------------------------------------

                    CNOP           0,4

; LayoutIconA -- Adapt a palette-mapped icon for display (V44)
; success = LayoutIconA(icon,screen,tags);
; D0                    A0   A1     A2
; BOOL LayoutIconA(struct DiskObject *icon,struct Screen *screen,
;                  struct TagItem *tags);

LayoutIconA         MOVEM.L        D6-D7/A1-A3/A5-A6,-(SP)
                    MOVEA.L        A6,A5                    ; iconbase
                    MOVE.L         A0,D0                    ; icon ?
 ifd MC68020
                    BEQ.W          .noicon
                    CMPI.W         #$E310,(A0)              ; DiskMagic found ?
                    BNE.W          .wrongtype
 else
                    BEQ.S          .noicon
                    CMPI.B         #$E3,(A0)
                    BNE.S          .wrongtype
 endif
                    MOVEQ          #0,D7                    ; result2 = 0
                    MOVEA.L        A0,A3                    ; icon
                    LEA            $5E(A3),A0               ; magic selfpointer
                    CMPA.L         (A0),A0                  ; V44 DiskObject ?
                    BNE.W          .setresult2
                    MOVEA.L        $76(A3),A0               ; PalMap1
                    BSR.W          checkpalmap              ; preserves A0, A1
                    BEQ.W          .setresult2
 ifd MC68020
                    MOVEA.L        $26(A5),A6               ; execbase
                    MOVEA.L        ThisTask(A6),A0          ; the running task
                    MOVEA.L        $A(A0),A6                ; the task name
                    CMPA.L         $96C(A5),A0              ; DOpus5 task ?
                    BEQ.S          .setdopus5flag
                    CMPI.L         #"dopu",(A6)             ; DOpus5 child task?
.setdopus5flag      SEQ            D6
                    BNE.S          .layouticon              ; not a DOpus5 task
                    MOVEA.L        $36(A5),A0               ; intuibase
                    MOVE.L         $38(A0),D0               ; ActiveScreen
                    BEQ.S          .layouticon
                    CMP.L          $86(A3),D0               ; = icons screen ?
                    BNE.S          .layouticon
                    MOVEA.L        D0,A0                    ; fix DOpus5 mapping
                    MOVEA.L        $58(A0),A0               ; scr.rastport.bitmap
                    MOVE.B         5(A0),D0                 ; ActiveScreen depth
                    MOVEA.L        $16(A3),A0               ; GadgetRender
                    CMP.B          8+1(A0),D0               ; same depth again ?
                    BNE.S          .checkdopustask
                    MOVEQ          #0,D6                    ; same screen depth
.checkdopustask     ADDQ.W         #4,A6
                    CMPI.L         #"s_fu",(A6)             ; dopus_function ?
                    BEQ.S          .checkRTGscreen
                    CMPI.L         #"s_li",(A6)             ; dopus_lister ?
                    BNE.S          .layouticon
.checkRTGscreen     TST.B          $EB(A5)                  ; DOnoColorMapping ?
                    BEQ.S          .checkthescreen
                    TST.B          $97A(A5)                 ; RTG flag > 0 ?
                    BGT.W          .setresult2              ; no need to remap !
.checkthescreen     TST.L          A1                       ; screen supplied ?
                    BNE.W          .setresult2              ; no need to remap !
 endif
.layouticon         MOVEA.L        $6E(A3),A0               ; *V44image1
                    CMPA.L         $16(A3),A0               ; = *GadgetRender ?
                    BNE.S          .newGadget
                    CLR.L          $16(A3)                  ; remove old image
.newGadget          MOVEA.L        $72(A3),A0               ; *V44image2
                    CMPA.L         $1A(A3),A0               ; = *SelectRender ?
                    BNE.S          .newSelect
                    CLR.L          $1A(A3)                  ; remove old image
.newSelect          MOVEA.L        $76(A3),A0               ; PalMap1
 ifd MC68020
                    TST.B          D6                       ; DOpus5 running ?
                    BNE.S          .clearcounter1
 endif
                    MOVEA.L        $86(A3),A1               ; icons screen
                    BSR.W          releasepens
.tryPalMap2         BSR.W          darkerPalMapCopy         ; A6 scratched!
                    BEQ.S          .noPalMap2
                    MOVEA.L        $7A(A3),A0               ; PalMap2
 ifd MC68020
                    TST.B          D6                       ; DOpus5 running ?
                    BNE.S          .clearcounter2
 endif
                    MOVEA.L        $86(A3),A1               ; icons screen
                    BSR.W          releasepens
                    BRA.S          .PalMaps_done

.clearcounter1      CLR.W          $11C(A0)                 ; mapped colors = 0
                    BRA.S          .tryPalMap2
          
.noicon             MOVEQ          #$74,D7                  ; argument missing
                    BRA.S          .error

.wrongtype          MOVEQ          #$6A,D7
                    ADD.L          D7,D7
                    BRA.S          .error

.noPalMap2          MOVEQ          #$67,D7                  ; no free memory
.error              BRA.S          .setresult2

.clearcounter2      CLR.W          $11C(A0)                 ; mapped colors = 0
.PalMaps_done       CLR.L          $86(A3)                  ; remove icon screen
                    MOVE.L         8(SP),D6                 ; supplied screen ?
                    BEQ.S          .use4coloricons
                    MOVE.L         $124(A5),D0              ; def=GlobalPrecision
                    MOVE.L         A2,D1                    ; taglist supplied ?
                    BEQ.S          .noprecisiontag
                    MOVE.L         #OBP_Precision,D1
                    EXG            D0,D1
                    MOVEA.L        A2,A0                    ; taglist
                    MOVEA.L        $2E(A5),A6               ; utilbase
                    JSR            _LVOGetTagData(A6)
                    MOVEA.L        A2,A0                    ; no delayed mapping
.noprecisiontag     MOVE.L         D6,D1                    ; supplied screen
                    MOVEA.L        A3,A1                    ; DiskObject
                    BSR.W          iconcolormapping
                    MOVE.L         D0,D7                    ; result2
                    BEQ.S          .mappingdone
.use4coloricons     BSR.S          alloc4colorimages
                    MOVE.L         D0,D7                    ; result2
                    BNE.S          .setresult2
                    MOVEA.L        A3,A0                    ; DiskObject
                    BSR.W          map2systemcolors
.mappingdone        MOVEA.L        $76(A3),A0               ; PalMap1
                    LEA            $7E(A3),A1               ; *mask1 Gadget
                    BSR.W          makePalMapMask           ; A5 = iconbase
                    MOVE.L         D0,D7                    ; result2
                    BNE.S          .setresult2
                    MOVEA.L        $7A(A3),A0               ; PalMap2
                    LEA            $82(A3),A1               ; *mask2 Select
                    BSR.W          makePalMapMask           ; A5 = iconbase
                    MOVE.L         D0,D7                    ; result2
                    BNE.S          .setresult2
                    BCLR.B         #3,$8A(A3)               ; GlobalScreen flag=0
                    MOVEA.L        $76(A3),A0               ; PalMap1
                    MOVE.L         (A0),D0                  ; width, height
                    LEA            $C(A3),A6                ; DiskObject w, h
                    MOVE.L         D0,(A6)+                 ; copy width, height
                    MOVEQ          #-4,D0
                    AND.W          D0,(A6)+                 ; mask flags 0,1
                    BSET.B         #1,$11(A3)               ; DiskObject flags
.setresult2         MOVE.L         D7,D1                    ; result2
                    MOVEA.L        $2A(A5),A6               ; dosbase
                    JSR            _LVOSetIoErr(A6)         ; always set/clear RC2
                    TST.L          D7
                    BEQ.S          .done
                    MOVEQ          #0,D0                    ; error = false
                    BRA.S          .quit

.done               MOVEQ          #1,D0                    ; return true
.quit               MOVEM.L        (SP)+,D6-D7/A1-A3/A5-A6
                    RTS

;-------------------------------------------------------------------------

alloc4colorimages   MOVEM.L        D4/A2/A4,-(SP)
                    MOVE.L         $76(A3),D4               ; PalMap1
                    BEQ.S          .done1
                    LEA            $16(A3),A4               ; GadgetRender
                    BSR.S          .allocImage
.done1              MOVE.L         $7A(A3),D4               ; PalMap2
                    BEQ.S          .done2
                    LEA            $1A(A3),A4               ; SelectRender
                    BSR.S          .allocImage
.done2              MOVEQ          #0,D0
.exit               MOVEM.L        (SP)+,D4/A2/A4
                    RTS

.allocImage         TST.L          (A4)                     ; struct Image ?
                    BNE.S          .done
                    LEA            $4E(A3),A0               ; freelist
                    MOVEA.W        #20,A1                   ; 20 bytes
                    LEA            MEMF_PUBLIC|MEMF_CLEAR,A2
                    BSR.W          FreeAlloc                ; needs no iconbase
                    BEQ.S          .nomem
                    MOVEA.L        D0,A2                    ; new struct Image
                    LEA            4(A2),A0
                    MOVEA.L        D4,A1                    ; struct PalMap
                    MOVE.L         (A1),(A0)+               ; copy width, height
                    MOVEQ          #2,D0                    ; depth = 2
                    MOVE.W         D0,(A0)+                 ; depth = 2, 4 colors
                    MOVE.L         A0,D1                    ; * target image data
                    MOVE.B         #3,$E(A2)                ; PlanePick plane 0,1
                    LEA            $4E(A3),A0               ; freelist
                    BSR.W          allocate_WxHxD           ; (A1) = width, height
                    BNE.S          .error
                    MOVE.L         A2,(A4)                  ; * struct Image
.done               RTS

.nomem              MOVEQ          #$67,D0
.error              ADDQ.W         #4,SP                    ; no rts
                    BRA.S          .exit

;------------------------------------------------------------------

                    CNOP           0,4

; ChangeToSelectedIconColor -- Modify an RGB colour value for use in
;                              a selected icon image (V44)
; ChangeToSelectedIconColor(cr)
;                           A0
; VOID ChangeToSelectedIconColor(struct ColorRegister *cr);

ChangeToSelectedIconColor

                    CMPA.W         #1024,A0                 ; zero page hit ?
                    BLT.S          darkerB
                    MOVEQ          #40,D0
darkerPalMapColors  SUB.B          D0,(A0)+
                    BCC.S          darkerR
                    CLR.B          -1(A0)
darkerR             SUB.B          D0,(A0)+
                    BCC.S          darkerG
                    CLR.B          -1(A0)
darkerG             SUB.B          D0,(A0)+
                    BCC.S          darkerB
                    CLR.B          -1(A0)
darkerB             RTS

;-------------------------------------------------------------------------

darkerPalMapCopy    MOVEA.L        $7A(A3),A0               ; A3=icon A5=iconbase
                    BSR.S          checkpalmap              ; PalMap2
                    BNE.S          .done
                    MOVE.L         $76(A3),D1               ; PalMap1
                    LEA            $4E(A3),A0               ; freelist
                    BSR.W          copyPalMap
                    MOVE.L         D0,$7A(A3)               ; PalMap2
                    BEQ.S          .done                    ; no free memory
                    BSET.B         #4,$8A(A3)               ; set NoImage2 flag
                    MOVEA.L        D0,A0                    ; new PalMap2
                    MOVE.W         $10E(A0),D1              ; number of colors
                    SUBQ.W         #1,D1
                    MOVEA.L        $108(A0),A0              ; colormap RGB bytes
                    LEA            ChangeToSelectedIconColor(PC),A1
                    CMPA.L         _LVOChangeToSelectedIconColor+2(A5),A1
                    BNE.S          .newselectedcolors
                    MOVEQ          #50,D0
.setselectedcolors  BSR.S          darkerPalMapColors
                    DBRA           D1,.setselectedcolors
.done               RTS

.newselectedcolors  MOVE.L         D2,-(SP)                 ; function is patched
                    MOVE.W         D1,D2
                    MOVEA.L        A5,A6                    ; iconbase
                    MOVEA.L        A0,A5
.jumptablefunction  MOVEA.L        A5,A0
                    JSR            _LVOChangeToSelectedIconColor(A6)
                    ADDQ.W         #3,A5
                    DBRA           D2,.jumptablefunction
                    MOVE.L         (SP)+,D2
                    MOVEA.L        A6,A5
                    MOVEQ          #1,D0                    ; return no error
                    RTS                                     ; A6 was scratched !

;-------------------------------------------------------------------------

checkpalmap         MOVE.L         A0,-(SP)                 ; PalMap
                    BEQ.S          .done
                    TST.L          $108(A0)                 ; * colormap
                    BEQ.S          .done
                    TST.W          (A0)+                    ; width
                    BEQ.S          .done
                    TST.W          (A0)+                    ; height
                    BEQ.S          .done
                    TST.L          (A0)                     ; * image data
                    BEQ.S          .done
                    MOVE.W         $10E-4(A0),D0            ; number of colors
                    BEQ.S          .done                    ; 0 colors
                    SUB.W          #257,D0
                    BCS.S          .done                    ; 1 - 256 colors
                    MOVEQ          #0,D0
.done               MOVEA.L        (SP)+,A0
                    RTS

;-------------------------------------------------------------------------

releasepens         MOVE.L         A0,D0                    ; PalMap ?
                    BEQ.S          .exit
                    MOVE.L         A1,D0                    ; icons screen ?
                    BEQ.S          .exit
                    MOVEM.L        D6-D7/A2-A3/A6,-(SP)
                    MOVE.W         $11C(A0),D7              ; colormapping result ?
                    BLE.S          .done
                    CLR.W          $11C(A0)
                    TST.B          $97E(A5)                 ; is this WB 3.0/3.1 ?
                    BNE.S          .done
                    MOVEA.L        $26(A5),A6               ; execbase
                    MOVEA.L        ThisTask(A6),A2
                    CMPA.L         $974(A5),A2              ; Workbench task ?
                    BEQ.S          .checkcmapsize         
                    MOVEA.L        $36(A5),A6               ; intuibase
                    CMPA.L         $38(A6),A1               ; screen=ActiveScreen?
                    BNE.S          .done                    ; avoid DOpus5 crashes
.checkcmapsize      CMPI.W         #256,D7
                    BHI.S          .done                    ; should never happen !
                    LEA            8(A0,D7.w),A2            ; last+1 cmap register
                    MOVEA.L        sc_ViewPort+vp_ColorMap(A1),A3
                    MOVEA.L        $32(A5),A6               ; gfxbase
                    MOVEQ          #-1,D6
                    TST.B          $10C(A0)                 ; transparency ?
                    BEQ.S          .countdown
                    MOVEQ          #0,D6
                    MOVE.B         $10D(A0),D6              ; transparent color
                    BRA.S          .countdown

.nextregister       MOVEQ          #0,D0
                    MOVE.B         -(A2),D0                 ; cmap.register->pen
                    CMP.W          D6,D7                    ; transparent color ?
                    BEQ.S          .countdown
                    MOVEA.L        A3,A0                    ; viewport.colormap
                    JSR            _LVOReleasePen(A6)
.countdown          DBRA           D7,.nextregister
.done               MOVEM.L        (SP)+,D6-D7/A2-A3/A6
.exit               RTS

;-------------------------------------------------------------------------

maptofirst4pens     LEA            -$30(SP),SP              ; 12 longword buffer
                    MOVEM.L        D3-D7/A2-A3/A6,-(SP)     ; A5=iconbase
                    MOVEA.L        A1,A3                    ; PalMap
                    SUBA.L         A0,A0                    ; no name
                    MOVEA.L        $36(A5),A6               ; intuibase
                    JSR            _LVOLockPubScreen(A6)
                    TST.L          D0                       ; locked screen ?
                    BEQ.S          .nopubscreen
                    MOVEA.L        D0,A2
                    MOVEA.L        $30(A2),A0               ; screen colormap
                    LEA            $20(SP),A1               ; fill table buffer
                    MOVEA.L        $32(A5),A6               ; gfxbase
                    MOVEQ          #0,D0                    ; first color = 0
                    MOVEQ          #4,D1                    ; 4 long RGB colors
                    JSR            _LVOGetRGB32(A6)
                    SUBA.L         A0,A0                    ; no name, use addr
                    MOVEA.L        A2,A1                    ; locked screen addr
                    MOVEA.L        $36(A5),A6               ; intuibase
                    JSR            _LVOUnlockPubScreen(A6)
                    LEA            $20(SP),A0               ; longword buffer
                    LEA            $CC(A5),A1               ; systemcolors
                    MOVEQ          #12-1,D0
.fromlongtobyte     MOVE.B         (A0),(A1)+               ; converting 4 RGB
                    ADDQ.W         #4,A0                    ; from long to byte
                    DBRA           D0,.fromlongtobyte
.nopubscreen        MOVEA.L        $108(A3),A1              ; icon cm RBG bytes
                    LEA            $CC(A5),A2               ; systemcolors
                    MOVEQ          #0,D0
                    MOVEQ          #0,D1
                    MOVEQ          #0,D7                    ; i-color counter
.nexticoncolor      MOVEA.L        A2,A0                    ; systemcolors
                    MOVEQ          #-1,D4                   ; worst distance
                    MOVEQ          #3,D5                    ; 4*RGB counter - 1
                    MOVEQ          #0,D6                    ; best pen = 0
.nextpen            MOVEQ          #0,D3
                    PEA            .get_next(PC)
.get_diff           MOVE.B         (A0)+,D0
                    MOVE.B         (A1)+,D1
                    SUB.L          D0,D1
                    BPL.S          .add_diff
                    NEG.L          D1
.add_diff           ADD.L          D1,D3
                    RTS

.get_next           BSR.S          .get_diff
                    BSR.S          .get_diff
                    CMP.L          D4,D3                    ; compare distances
                    BCC.S          .trynext                 ; is worse or the same
                    MOVE.L         D3,D4                    ; save better distance
                    MOVEQ          #3,D6
                    SUB.L          D5,D6                    ; save better pen
.trynext            SUBQ.W         #3,A1                    ; same i-color again
                    DBRA           D5,.nextpen
                    MOVE.B         D6,8(A3,D7.L)            ; store best pen
                    ADDQ.W         #3,A1                    ; next icon color
                    ADDQ.L         #1,D7                    ; i-color counter + 1
                    CMP.W          $10E(A3),D7              ; to number i-colors
                    BCS.S          .nexticoncolor
                    TST.B          $10C(A3)                 ; transparency ?
                    BEQ.S          .done
                    MOVE.B         $10D(A3),D0              ; transparent color
                    CLR.B          8(A3,D0.W)               ; map color to pen0
.done               MOVEM.L        (SP)+,D3-D7/A2-A3/A6
                    LEA            $30(SP),SP
                    RTS            ;------------------------  goto V44imagetoplanar

imagecolormapping   MOVEM.L        D0/A1,-(SP)              ; planar image, PalMap
                    PEA            V44imagetoplanar(PC)
                    BCLR.B         #3,$8A(A3)               ; GlobalScreen flag=0
 ifd RLEjit
                    TST.B          $11F(A1)                 ; RLE compressed data ?
                    BPL.S          .chunkydatadone
                    CLR.B          $11F(A1)                 ; color reduction dump
                    MOVEM.L        D0/A0-A2/A6,-(SP)
                    MOVEA.L        A1,A6                    ; PalMap
                    MOVE.W         (A1)+,D0                 ; PalMap width
                    MULU.W         (A1)+,D0                 ; width * height
                    MOVEA.L        D0,A0                    ; full size of image
                    MOVEA.L        (A1),A1                  ; * chunky image data
                    MOVEA.L        A1,A2                    ; target = full image
                    MOVEQ          #0,D0
                    MOVE.W         (A1)+,D0                 ; offset of RLE data
                    ADDA.L         D0,A2                    ; source = *RLE z-data
                    MOVE.W         (A1)+,D0                 ; RLE compressed size
                    MOVEQ          #0,D1
                    MOVE.B         (A1),D1                  ; depth
                    SUBQ.W         #4,A1                    ; target = full image
                    BSR.W          decompressdata           ; A6 = PalMap
                    MOVEM.L        (SP)+,D0/A0-A2/A6
                    BNE.W          maptofirst4pens          ; should never happen
 endif
.chunkydatadone
 ifd MC68020
                    MOVE.L         $36(A5),D1               ; intuibase
                    CMPA.L         $38(D1.L),A0             ; is screen active ?
                    BEQ.S          .seticonsscreen
                    TST.L          A0
                    BEQ.S          .maptofirst4pens
                    TST.B          $97E(A5)                 ; is this WB 3.0/3.1 ?
                    BNE.S          .useactivescreen
                    CMPI.B         #WBDISK,do_Type(A3)      ; no P96 fix for disks
                    BEQ.S          .seticonsscreen          ; mounted from 2. screen
                    MOVE.L         $26(A5),D1               ; execbase
                    MOVE.L         ThisTask(D1.L),D1        ; running task
                    CMP.L          $96C(A5),D1              ; DOpus5 main task ?
                    BEQ.S          .useactivescreen         ; P96 v3 palette bug
                    MOVE.L         $A(D1.L),D1              ; task name
                    CMPI.L         #"dopu",(D1.L)           ; dopus child task ?
                    BNE.S          .seticonsscreen
.useactivescreen    MOVEA.L        $36(A5),A0               ; intuibase
                    MOVEA.L        $38(A0),A0               ; force ActiveScreen
                    CLR.L          $968(A5)                 ; reload colormap cache
 else
                    TST.B          $97E(A5)                 ; is this WB 3.0/3.1 ?
                    BEQ.S          .seticonsscreen
                    MOVEA.L        $36(A5),A0               ; intuibase
                    MOVEA.L        $38(A0),A0               ; force ActiveScreen
 endif
.seticonsscreen     MOVE.L         $86(A3),D1               ; get existing screen
.maptofirst4pens    MOVE.L         A0,$86(A3)               ; set requested screen
                    BEQ.W          maptofirst4pens
                    TST.L          D1
                    BEQ.S          noscreenconflict
                    CMP.L          A0,D1                    ; same screen again ?
                    BEQ.S          noscreenconflict
                    MOVE.L         D1,$86(A3)               ; restore icons screen
itsdone             RTS                                     ; goto V44imagetoplanar

noscreenconflict    CMPA.L         $128(A5),A0              ; screen=GlobalScreen ?
                    BNE.S          IconBeFast
                    BSET.B         #3,$8A(A3)               ; GlobalScreen flag
IconBeFast          TST.W          $11C(A1)                 ; the previous result
                    BNE.S          itsdone                  ; goto V44imagetoplanar
                    MOVE.L         D7,D1                    ; get -1, 0, 16 or 32
                    BPL.S          quality                  ; from WB preferences
                    MOVEQ          #-16,D1                  ; and convert it to:
quality             ADDQ.L         #8,D1                    ; 0, 32, 64 or 96 for
                    ADDQ.L         #8,D1                    ; the color tolerance
                    ADD.L          D1,D1
                    MOVEM.L        A2-A6,-(SP)
                    MOVEA.L        $32(A5),A6               ; gfxbase
                    MOVEM.L        D0-D7/A6,-(SP)
                    MOVEA.L        A1,A2                    ; PalMap structure
                    MOVEA.L        $86(A3),A3               ; icons screen
                    TST.L          $120(A5)                 ; cgxbase ?
                    BEQ.S          setmode
                    TST.B          $97A(A5)                 ; Hi/TrueColor flag ?
setmode             SGT            5(SP)                    ; turbo mapping mode
                    MOVEA.L        $30(A3),A3               ; viewport colormap
                    MOVEA.L        cm_PalExtra(A3),A0
                    MOVEA.L        $26(A5),A6               ; execbase
                    MOVEA.L        A0,A5
                    JSR            _LVOObtainSemaphore(A6)
                    MOVEA.L        A2,A6                    ; PalMap structure
                    MOVE.W         pe_SharableColors(A5),D0
                    MOVE.L         4(SP),D1
                    MOVEQ          #96,D2
                    CMP.L          D1,D2                    ; color tolerance
                    SLS            4(SP)                    ; flag turbo mapping
                    BHI.S          flagset
                    SUBQ.W         #1,D0
                    BCLR           #5,D0
                    MOVEQ          #28,D1
flagset             ADD.W          D1,D0
                    LSL.W          #2,D0                    ; adjusted tolerance
                    MOVE.W         D0,(SP)
                    MOVE.W         pe_NShared(A5),D2
                    CMPI.W         #256,D2                  ; 256 shared maximal
                    BLS.S          getbase                  ; fits into cm-cache
                    MOVE.W         #256,D2                  ; avoid an overflow!
getbase             MOVEA.L        $30(SP),A0               ; icon.library base
 ifd Scalers
                    TST.B          $97D(A0)                 ; flag for grayscale
                    BEQ.S          grayset
                    MOVEQ          #32,D1
                    CMP.L          $124(A0),D1              ; GlobalPrecision=32?
                    BNE.S          mapflag
                    SEQ            4(SP)                    ; flag turbo mapping
mapflag             ROR.W          4(SP)
 endif
grayset             LEA            $768(A0),A1              ; colordistance table
                    MOVE.L         A1,-(SP)                 ; store TabBase for B
                    MOVE.L         A1,-(SP)                 ; store TabBase for G
                    MOVE.L         A1,-(SP)                 ; store TabBase for R
                    MOVEA.L        $968(A0),A1              ; previous colormap
                    MOVE.L         A3,$968(A0)              ; colormap for cache
                    LEA            $568(A0),A2              ; to bottom of cache
                    MOVE.W         (A2),D3                  ; previous NShared
                    MOVE.W         D2,D1
                    LSL.W          #2,D1
                    SUBA.W         D1,A2                    ; 4 * NShared above
                    MOVE.L         A2,-(SP)                 ; store cache-pointer
                    MOVEQ          #-1,D1                   ; best distance = -1
                    MOVE.L         D1,-(SP)                 ; maximum as default
                    MOVE.W         D2,-(SP)                 ; store shared colors
                    MOVE.W         D2,-(SP)                 ; set as loop counter
                    BEQ.S          noNSharedforcache
                    CMPA.L         A1,A3                    ; did ColorMap change?
                    BNE.S          .cachenewcolormap
                    CMP.W          D2,D3                    ; did NShared change?
 ifd MC68020
                    BEQ.S          cacheok
 else
                    BEQ.W          cacheok
 endif
.cachenewcolormap   LEA            $ED(A0),A4               ; flag for aros.library
                    MOVEA.L        cm_ColorTable(A3),A0
                    MOVEA.L        A0,A1                    ; high = low RGB bits
                    TST.B          cm_Type(A3)
                    BEQ.S          setmask
                    MOVE.L         cm_LowColorBits(A3),D0
                    BEQ.S          setmask
                    MOVEA.L        D0,A0
setmask             MOVEQ          #$0F,D5                  ; $0F mask
                    MOVEQ          #$78,D6
                    ADD.L          D6,D6                    ; $F0 mask
                    MOVEQ          #0,D7
                    MOVE.B         pe_FirstShared+1(A5),D7
                    MOVEA.L        pe_AllocList(A5),A3
cmcache             ;------------------------------------------------------------
 ifd MC68020
                    MOVE.W         (A0,D7.L*2),D2           ; _rgb lower bits
                    MOVE.W         (A1,D7.L*2),D3           ; _RGB higher bits
 else
                    MOVE.W         D7,D0
                    ADD.W          D0,D0
                    MOVE.W         (A0,D0.W),D2             ; _rgb lower bits
                    MOVE.W         (A1,D0.W),D3             ; _RGB higher bits
 endif
                    MOVE.L         D2,D1
                    LSR.L          #4,D1                    ; _ = 4 bits
                    MOVE.L         D1,D4
                    AND.L          D5,D4                    ; __g_ -> D4 = _g
                    LSR.L          #4,D1
                    AND.L          D5,D1                    ; _r__ -> D1 = _r
                    MOVE.L         D3,D0
                    LSR.L          #4,D0
                    AND.L          D6,D0                    ; _R__ -> D0 = R_
                    OR.B           D1,D0                    ;         D0 = Rr
                    MOVE.L         D3,D1
                    AND.L          D6,D1                    ; __G_ -> D1 = G_
                    OR.B           D4,D1                    ;         D1 = Gg
                    AND.L          D5,D2                    ; ___b -> D2 = _b
                    LSL.L          #4,D3
                    AND.L          D6,D3                    ; ___B -> D3 = B_
                    OR.B           D3,D2                    ;         D2 = Bb
                    MOVE.B         D7,(A2)+                 ; cache color register
                    MOVE.B         D2,(A2)+                 ; cache B
                    MOVE.B         D1,(A2)+                 ; cache G
                    MOVE.B         D0,(A2)+                 ; cache R
                    MOVE.L         D7,D0
                    TST.B          (A4)                     ; aros.library found ?
                    BEQ.S          sizeset
                    ADD.L          D0,D0                    ; AllocList uses words
                    ADDQ.L         #1,D0                    ; address the 2. byte
sizeset             MOVE.B         (A3,D0.L),D7             ; next color register
                    SUBQ.W         #1,(SP)                  ; countdown Nshared
                    BNE.S          cmcache                  ; 256 loops maximal
                    ;-------------------------------------------------------------
noNSharedforcache   MOVEA.L        $48(SP),A0               ; iconbase
                    LEA            $980(A0),A0
                    MOVEQ          #127,D0
initmap             CLR.L          (A0)+                    ; 512 bytes turbo map
                    DBRA           D0,initmap
cacheok             MOVE.W         $10E(A6),D5              ; number of i-colors
                    CMPI.W         #256,D5                  ; too many i-colors ?
                    BLS.S          nolimit                  ;
                    MOVE.W         #256,D5                  ; set to 256 i-colors
nolimit             MOVEA.L        $108(A6),A4              ; icon cmap RGB bytes
                    MOVE.W         D5,$11C(A6)              ; write colors mapped
                    ADDA.W         D5,A4
                    ADDA.W         D5,A4
                    ADDA.W         D5,A4
 ifd smurf
                    SUBQ.L         #1,(SP)                  ; skip pen0 ColorFades
 endif
                    MOVEQ          #0,D1
                    MOVEQ          #0,D2
                    MOVEQ          #0,D3
                    MOVEQ          #-1,D4                   ; transparency is off
                    TST.B          $10C(A6)                 ; transparency used ?
                    BEQ.W          looping
                    MOVEQ          #0,D4                    ; enable transparency
                    MOVE.B         $10D(A6),D4              ; transparent i-color
                    BRA.W          looping                  ; count colors-1 to 0
                    ;------------------------------------------------------------

                    CNOP           0,4

maploop             MOVE.B         -(A4),D3                 ; icon blue byte
                    MOVE.B         -(A4),D2                 ; icon green byte
                    MOVE.B         -(A4),D1                 ; icon red byte
                    MOVEQ          #0,D7                    ; default register = 0
                    CMP.W          D4,D5                    ; transparent i-color?
                    BEQ.W          map2pen
 ifnd Scalers
                    NOP
 endif
                    MOVEM.L        (SP),D0/D6/A0-A3
                    MOVEM.L        D1-D3/A6,-(SP)
                    LEA            $97F-$768(A1),A6
                    SUBQ.W         #1,D0                    ; rgbloop - 1 for DBRA
                    BMI.W          rgbdone
                    TST.W          $2C(SP)                  ; any turbo flags set?
 ifd Scalers
                    BEQ.W          tabbase
                    BMI.S          fastmap
                    ADD.L          D2,D1                    ; convert to grayscale
                    ADD.L          D3,D1
                    LSR.L          #2,D1
                    MOVE.L         D1,D2
                    LSR.L          #2,D2
                    ADDX.L         D2,D1
                    MOVE.L         D1,D2
                    LSR.L          #4,D2                    ; this is matt's magic
                    ADDX.L         D2,D1                    ; efficient math-matic
                    MOVE.L         D1,D2
                    MOVE.L         D1,D3
                    BRA.S          usegray

                    CNOP           0,4
 else
                    BEQ.S          tabbase
 endif
fastmap             MOVEQ          #-32,D7                  ; filter for 3 bits
                    AND.B          D7,D1                    ; highest 3 bits red
                    ADD.L          D1,D1
                    AND.B          D7,D2                    ; highest 3 bits green
                    LSR.B          #2,D2
                    LSR.B          #5,D3                    ; highest 3 bits blue
                    OR.B           D2,D1
                    OR.B           D3,D1
                    ADDQ.L         #1,D1                    ; turbo colors 1 to 512
                    MOVEQ          #9,D7
                    BTST           D7,D1                    ; avoid white with pink
                    BNE.S          bewhite
                    ADDA.L         D1,A6                    ; turbo colormap offset
                    MOVE.B         (A6),D7                  ; register of turbo map
                    BNE.W          countup
bewhite             MOVEM.L        (SP),D1-D3
                    BNE.S          default
                    MOVEQ          #-8,D7                   ; filter for 5 bits
                    AND.B          D7,D1                    ; highest 5 bits red
                    AND.B          #$FC,D2                  ; highest 6 bits green
                    AND.B          D7,D3                    ; highest 5 bits blue
                    BCLR           #2,D2
                    BEQ.S          GdoneB1
                    ADDQ.B         #2,D2
GdoneB1             MOVEQ          #3,D7
                    BCLR           D7,D1
                    BEQ.S          RdoneB2
                    ADDQ.B         #3,D1
RdoneB2             BCLR           D7,D2
                    BEQ.S          GdoneB2
                    ADDQ.B         #4,D2
GdoneB2             BCLR           D7,D3
                    BEQ.S          BdoneB2
                    ADDQ.B         #3,D3
BdoneB2             MOVEQ          #4,D7                    ; closer to the middle
                    BCLR           D7,D1
                    BEQ.S          RdoneB3
                    ADDQ.B         #6,D1
RdoneB3             BCLR           D7,D2
                    BEQ.S          GdoneB3
                    ADDQ.B         #8,D2
GdoneB3             BCLR           D7,D3
                    BEQ.S          BdoneB3
                    ADDQ.B         #6,D3
BdoneB3             ADDQ.B         #6,D1
                    ADDQ.B         #4,D2                    ; adjusting the level
                    ADDQ.B         #6,D3
usegray             MOVEM.L        D1-D3,(SP)
default             MOVEQ          #0,D7                    ; default register = 0
tabbase
 ifd MC68020
                    SUBA.L         D1,A1
                    SUBA.L         D1,A1                    ; A1 = TabBase-R words
                    SUBA.L         D2,A2
                    SUBA.L         D2,A2                    ; A2 = TabBase-G words
                    SUBA.L         D3,A3
                    SUBA.L         D3,A3                    ; A3 = TabBase-B words
 else
                    SUBA.W         D1,A1
                    SUBA.W         D1,A1
                    SUBA.W         D2,A2
                    SUBA.W         D2,A2
                    SUBA.W         D3,A3
                    SUBA.W         D3,A3
 endif
                    ;==============================================================
rgbloop             MOVE.L         (A0)+,D1                 ; cached register,B,G,R
 ifd MC68020
                    MOVE.B         D1,D2
                    MOVE.W         (A1,D2.L*2),D3           ;   distance red part
                    LSR.W          #8,D1
                    ADD.W          (A2,D1.W*2),D3           ; + distance green part
                    SWAP           D1
                    MOVE.B         D1,D2
                    ADD.W          (A3,D2.L*2),D3           ; + distance blue part
 else
                    MOVEQ          #0,D2
                    MOVE.B         D1,D2
                    ADD.W          D2,D2
                    MOVE.W         (A1,D2.W),D3             ;   distance red part
                    LSR.W          #8,D1
                    ADD.W          D1,D1
                    ADD.W          (A2,D1.W),D3             ; + distance green part
                    SWAP           D1
                    MOVEQ          #0,D2
                    MOVE.B         D1,D2
                    ADD.W          D2,D2
                    ADD.W          (A3,D2.W),D3             ; + distance blue part
 endif
                    CMP.L          D3,D6                    ; compare the distances
                    BLS.S          trynext                  ; is worse or the same
                    MOVE.W         D1,D7                    ; best register as yet
                    MOVE.L         D3,D6                    ; closest distance now
                    BEQ.S          bestpen                  ; fits 100% perfectly
trynext             DBRA           D0,rgbloop               ; countdown shared pens
                    ;==============================================================
rgbdone             MOVE.W         pe_NFree(A5),D0
                    BLE.S          bestpen
                    MOVE.W         $28(SP),D2               ; the tolerance level
                    DIVU.W         D0,D2
                    MULU.W         D2,D2                    ; (8*(sharable+x)/free)^2
                    LSL.L          #2,D6                    ; adjust the color distance
                    CMP.L          D6,D2                    ; tolerance - best distance
                    BCS.S          newfree                  ; allocate a new free pen
bestpen             LSR.W          #8,D7                    ; shift right register byte
                    MOVE.B         D7,(A6)
countup             MOVEA.L        pe_RefCnt(A5),A0
 ifd MC68020
                    ADDQ.W         #1,(A0,D7.W*2)
 else
                    MOVE.W         D7,D0
                    ADD.W          D0,D0
                    ADDQ.W         #1,(A0,D0.W)
 endif
                    MOVEM.L        (SP)+,D1-D3/A6
map2pen             MOVE.B         D7,8(A6,D5.W)            ; map icon color to pen
looping             DBRA           D5,maploop               ; 256 maploops maximal
                    ;---------------------------------------------------------------
                    LEA            $18(SP),SP               ; release of stackspace
                    MOVEA.L        A5,A0                    ; Semaphore=cm_PalExtra
                    MOVEA.L        (4).w,A6
                    JSR            _LVOReleaseSemaphore(A6)
                    MOVEA.W        pe_NShared(A5),A0
                    MOVEM.L        (SP)+,D0-D7/A1-A6
                    MOVE.W         A0,$568(A5)              ; store cached NShared
                    RTS                                     ; jumps to V44imagetoplanar

newfree             LEA            pe_FirstFree+1(A5),A2
                    LEA            pe_NFree(A5),A3
                    MOVEQ          #0,D0
                    MOVE.B         (A2),D0                  ; backup pe_FirstFree
                    MOVE.B         D0,(A6)                  ; store in turbo color map
                    MOVEA.L        pe_AllocList(A5),A6
                    MOVEA.L        $58(SP),A1               ; icon.library base pointer
                    MOVE.B         $ED(A1),D1               ; was aros.library found ?
                    BEQ.S          allocok
                    ADDQ.W         #1,A6                    ; access to the second byte
                    ADDA.L         D0,A6                    ; pe_AllocList + FirstFree
allocok             ADDA.L         D0,A6                    ; pe_AllocList + FirstFree
                    MOVE.B         (A6),(A2)                ; successor -> pe_FirstFree
                    SUBQ.W         #1,(A3)                  ; pe_NFree -= 1
                    BNE.S          doalloc
                    TST.B          D1                       ; was aros.library found ?
                    BEQ.S          doalloc
                    MOVE.W         #-1,pe_FirstFree(A5)     ; set a marker for AROS
doalloc             ADDQ.L         #3,A3
                    MOVE.B         (A3),(A6)                ; FirstShared -> AllocList
                    MOVE.B         D0,(A3)+                 ; old FirstFree -> FShared
                    ADDQ.W         #1,(A3)                  ; pe_NShared += 1
                    MOVEM.L        (SP),D1-D3               ; restore requested RGB
                    MOVEA.L        $18(SP),A0               ; pointer to top of cache
                    SUBQ.W         #4,A0                    ; move up to 4 bytes above
                    LEA            $168(A1),A1
                    CMPA.L         A1,A0                    ; compare with top of cache
                    BCS.S          limited                  ; avoid any cache overflows
                    ADDQ.L         #1,$10(SP)               ; correct rgb counter += 1
                    MOVE.L         A0,$18(SP)               ; store as new top of cache
                    MOVE.B         D0,(A0)+                 ; new pen to cache
                    MOVE.B         D3,(A0)+                 ; new B into cache
                    MOVE.B         D2,(A0)+                 ; new G into cache
                    MOVE.B         D1,(A0)                  ; new R into cache
limited             MOVE.B         D1,D7
                    LSL.L          #8,D1
                    MOVE.B         D7,D1
                    SWAP           D1                       ; R --> RR00 (longword)
                    MOVE.B         D2,D7
                    LSL.L          #8,D2
                    MOVE.B         D7,D2
                    SWAP           D2                       ; G --> GG00 (longword)
                    MOVE.B         D3,D7
                    LSL.L          #8,D3
                    MOVE.B         D7,D3
                    SWAP           D3                       ; B --> BB00 (longword)
                    MOVE.W         D0,D7                    ; bestpen = newpen
                    MOVEA.L        pe_ViewPort(A5),A0
                    MOVEA.L        $48(SP),A6               ; A6 = gfxbase
                    JSR            _LVOSetRGB32(A6)
                    BRA.W          countup

V44imagetoplanar    MOVEM.L        D5-D7/A3/A6,-(SP)        ; image, Palmap on SP
                    MOVEQ          #2,D7                    ; default = 2 planes
                    MOVE.L         $86(A3),D0               ; icons screen
                    BEQ.S          .depthinrange
                    MOVEA.L        D0,A0                    ; on WB 3.1 maybe dead
                    MOVEA.L        $58(A0),A0               ; scr.rastport.bitmap
                    MOVE.B         5(A0),D0                 ; screen depth
                    CMP.B          D7,D0
                    BLS.S          .depth2ormore
                    MOVE.B         D0,D7
.depth2ormore       SUBQ.B         #8,D0
                    BLS.S          .depthinrange
                    MOVEQ          #8,D7                    ; maximal planes = 8
.depthinrange       MOVEA.L        $14(SP),A0               ; old planar image
                    CMPI.W         #8,4(A0)                 ; dot or width = 8 ?
                    BEQ.S          .keepdefaultimage
                    CMPI.W         #20,6(A0)                ; image height > 20 ?
                    BLS.S          .keepdefaultimage
                    MOVEA.L        $A(A0),A1                ; old image memblock
                    LEA            $4E(A3),A0               ; freelist
                    BSR.W          DOFreeRemove             ; not for internal img    
.keepdefaultimage   MOVEA.L        $18(SP),A1               ; struct PalMap
                    MOVE.L         D7,D0                    ; number of bitplanes
                    MOVEQ          #$A,D1
                    ADD.L          $14(SP),D1               ; * target image data
                    LEA            $4E(A3),A0               ; freelist
                    BSR.W          allocate_WxHxD
                    BNE.S          .nofreemem
                    MOVEM.L        $14(SP),A1/A3            ; planar image, PalMap
                    ADDQ.W         #4,A1                    ; image width etc
                    MOVE.L         (A3)+,(A1)               ; PalMap width, height
                    MOVEM.W        (A1)+,D0-D1              ; width, height
                    MOVE.W         D7,(A1)+                 ; screen depth 2 - 8
                    MOVEA.L        (A1)+,A0                 ; planar image data
                    MOVEQ          #0,D6
                    BSET.L         D7,D6
                    SUBQ.L         #1,D6
                    MOVE.B         D6,(A1)+                 ; new planepick
                    CLR.B          (A1)                     ; clear planeonoff
                    BSR.S          chunkytoplanar           ; A3 = * chunky bytes
                    MOVEQ          #0,D0                    ; return ok
.nofreemem          MOVEM.L        (SP)+,D5-D7/A3/A6
                    ADDQ.W         #8,SP                    ; drop image & PalMap
                    RTS                                     ; A0 points below planes

;-------------------------------------------------------------------------

map2systemcolors    MOVEM.L        D5-D7/A0/A3-A4/A6,-(SP)  ; A0 = v44 diskobject
                    MOVEA.L        $76(A0),A3               ; PalMap1
                    MOVEA.L        $16(A0),A4               ; GadgetRender
                    BSR.S          .tryoldimage
                    MOVEA.L        $C(SP),A0                ; v44 diskobject
                    MOVEA.L        $7A(A0),A3               ; PalMap2
                    MOVEA.L        $1A(A0),A4               ; SelectRender
                    BSR.S          .tryoldimage
.skipmapping        MOVEM.L        (SP)+,D5-D7/A0/A3-A4/A6
                    RTS

.badoldimage        ADDQ.W         #4,SP                    ; drop return address
                    BRA.S          .skipmapping

.tryoldimage        MOVEA.L        A4,A0
                    BSR.W          checkimage
                    BEQ.S          .badoldimage
                    MOVEA.L        A3,A1                    ; PalMap
                    BSR.W          maptofirst4pens
                    ADDQ.W         #4,A3                    ; PalMap *chunky image
                    ADDQ.W         #4,A4
                    MOVEM.W        (A4)+,D0-D1/D7           ; width, height, depth
                    MOVEA.L        (A4),A0                  ; plane 0
chunkytoplanar      MOVEM.L        D2-D4/A2/A4-A5,-(SP)
                    LEA            .jmpbase(PC),A6
                    MOVE.L         D7,D6                    ; depth = 1-8 planes
 ifd MC68020
                    ADDA.W         (A6,D7.L*2),A6
 else
                    ADD.B          D7,D7
                    ADDA.W         (A6,D7.W),A6
 endif
                    MOVEA.L        D0,A2                    ; width = pixel count
                    ADDQ.L         #8,D0
                    ADDQ.L         #7,D0
                    LSR.L          #4,D0
                    ADD.L          D0,D0                    ; plane bytes/row
                    MOVE.L         D0,D2
                    MULU.W         D1,D2
                    MOVEA.L        D2,A5                    ; plane byte size
                    LSL.L          #3,D0                    : planar row bit size
                    SUB.L          A2,D0                    ; row bits - pixels
                    LSR.L          #3,D0                    ; planar pad count
                    SUBQ.L         #1,D1                    ; row counter - 1
                    SUBQ.B         #2,D6
                    BCS.S          .setPalMapImage
.addonebitplane     ADDA.L         A5,A0                    ; add 1 - 7 bitplanes
                    DBRA           D6,.addonebitplane
.setPalMapImage     MOVEA.L        (A3)+,A1                 ; PalMap image bytes
.nextrow            MOVEM.L        D0-D1,-(SP)              ; A3 = colormap regs
                    MOVE.L         A2,-(SP)                 ; chunky byte counter
.nextchunk          MOVEA.L        A0,A4                    ; bitplane 0 - 7
                    MOVE.B         (A1)+,D7                 ; a chunky image byte
 ifd MC68020
                    MOVE.B         (A3,D7.L),D0             ; cmap register -> pen
                    MOVE.B         (A1)+,D7
                    MOVE.B         (A3,D7.L),D1
                    MOVE.B         (A1)+,D7
                    MOVE.B         (A3,D7.L),D2
                    MOVE.B         (A1)+,D7
                    MOVE.B         (A3,D7.L),D3
                    MOVE.B         (A1)+,D7
                    MOVE.B         (A3,D7.L),D4
                    MOVE.B         (A1)+,D7
                    MOVE.B         (A3,D7.L),D5
                    MOVE.B         (A1)+,D7
                    MOVE.B         (A3,D7.L),D6
                    MOVE.B         (A1)+,D7
                    MOVE.B         (A3,D7.L),D7
 else
                    MOVE.B         (A3,D7.W),D0
                    MOVE.B         (A1)+,D7
                    MOVE.B         (A3,D7.W),D1
                    MOVE.B         (A1)+,D7
                    MOVE.B         (A3,D7.W),D2
                    MOVE.B         (A1)+,D7
                    MOVE.B         (A3,D7.W),D3
                    MOVE.B         (A1)+,D7
                    MOVE.B         (A3,D7.W),D4
                    MOVE.B         (A1)+,D7
                    MOVE.B         (A3,D7.W),D5
                    MOVE.B         (A1)+,D7
                    MOVE.B         (A3,D7.W),D6
                    MOVE.B         (A1)+,D7
                    MOVE.B         (A3,D7.W),D7
 endif
.jmpbase            JMP            (A6)

                    DC.W           .1plane  - .jmpbase
                    DC.W           .2planes - .jmpbase
                    DC.W           .3planes - .jmpbase
                    DC.W           .4planes - .jmpbase
                    DC.W           .5planes - .jmpbase
                    DC.W           .6planes - .jmpbase
                    DC.W           .7planes - .jmpbase
                    DC.W           .8planes - .jmpbase
 ifnd MC68020
      macro ROR.WorL
      ROR.W \1,\2
      endm

      macro ROL.WorL
      ROL.W \1,\2
      endm

.2planes            ROR.W          #1,D0
                    ROR.B          #2,D1
                    ROR.B          #2,D2
                    ROR.B          #2,D3
                    ROR.B          #2,D4
                    ROR.B          #2,D5
                    ROR.B          #2,D6
                    ROR.B          #2,D7
                    BRA.W          .toplane01

.3planes            ROR.W          #2,D0
                    ROR.B          #3,D1
                    ROR.B          #3,D2
                    ROR.B          #3,D3
                    ROR.B          #3,D4
                    ROR.B          #3,D5
                    ROR.B          #3,D6
                    ROR.B          #3,D7
                    BRA.W          .toplane02
 else
      macro ROR.WorL
      ROR.L \1,\2
      endm

      macro ROL.WorL
      ROL.L \1,\2
      endm

.2planes            ROR.L          #1,D0
                    LSL.B          #7,D1
                    ADDX.B         D0,D0
                    LSL.B          #7,D2
                    ADDX.B         D0,D0
                    LSL.B          #7,D3
                    ADDX.B         D0,D0
                    LSL.B          #7,D4
                    ADDX.B         D0,D0
                    LSL.B          #7,D5
                    ADDX.B         D0,D0
                    LSL.B          #7,D6
                    ADDX.B         D0,D0
                    LSL.B          #7,D7
                    BRA.W          .toplane1

.3planes            ROR.L          #2,D0
                    LSL.B          #6,D1
                    ADDX.B         D0,D0
                    LSL.B          #6,D2
                    ADDX.B         D0,D0
                    LSL.B          #6,D3
                    ADDX.B         D0,D0
                    LSL.B          #6,D4
                    ADDX.B         D0,D0
                    LSL.B          #6,D5
                    ADDX.B         D0,D0
                    LSL.B          #6,D6
                    ADDX.B         D0,D0
                    LSL.B          #6,D7
                    BRA.W          .toplane2
 endif
.4planes            ROR.WorL       #3,D0
                    LSL.B          #5,D1
                    ADDX.B         D0,D0
                    LSL.B          #5,D2
                    ADDX.B         D0,D0
                    LSL.B          #5,D3
                    ADDX.B         D0,D0
                    LSL.B          #5,D4
                    ADDX.B         D0,D0
                    LSL.B          #5,D5
                    ADDX.B         D0,D0
                    LSL.B          #5,D6
                    ADDX.B         D0,D0
                    LSL.B          #5,D7
                    BRA.W          .toplane3

.5planes            ROR.WorL       #4,D0
                    LSL.B          #4,D1
                    ADDX.B         D0,D0
                    LSL.B          #4,D2
                    ADDX.B         D0,D0
                    LSL.B          #4,D3
                    ADDX.B         D0,D0
                    LSL.B          #4,D4
                    ADDX.B         D0,D0
                    LSL.B          #4,D5
                    ADDX.B         D0,D0
                    LSL.B          #4,D6
                    ADDX.B         D0,D0
                    LSL.B          #4,D7
                    BRA.W          .toplane4

.6planes            ROR.WorL       #5,D0
                    LSL.B          #3,D1
                    ADDX.B         D0,D0
                    LSL.B          #3,D2
                    ADDX.B         D0,D0
                    LSL.B          #3,D3
                    ADDX.B         D0,D0
                    LSL.B          #3,D4
                    ADDX.B         D0,D0
                    LSL.B          #3,D5
                    ADDX.B         D0,D0
                    LSL.B          #3,D6
                    ADDX.B         D0,D0
                    LSL.B          #3,D7
                    BRA.S          .toplane5

.7planes            ROR.WorL       #6,D0
                    ADD.B          D1,D1
                    ADD.B          D2,D2
                    ADD.B          D3,D3
                    ADD.B          D4,D4
                    ADD.B          D5,D5
                    ADD.B          D6,D6
                    ADD.B          D7,D7
                    BRA.S          .toplane6

                    CNOP           0,4

.8planes            ROR.WorL       #7,D0
                    ADD.B          D1,D1
                    ADDX.B         D0,D0
                    ADD.B          D2,D2
                    ADDX.B         D0,D0
                    ADD.B          D3,D3
                    ADDX.B         D0,D0
                    ADD.B          D4,D4
                    ADDX.B         D0,D0
                    ADD.B          D5,D5
                    ADDX.B         D0,D0
                    ADD.B          D6,D6
                    ADDX.B         D0,D0
                    ADD.B          D7,D7
                    ADDX.B         D0,D0
                    MOVE.B         D0,(A4)                  ; write a byte to plane 7
                    SUBA.L         A5,A4                    ; jump to plane 6
                    ROL.WorL       #1,D0
.toplane6           ADD.B          D1,D1
                    ADDX.B         D0,D0
                    ADD.B          D2,D2
                    ADDX.B         D0,D0
                    ADD.B          D3,D3
                    ADDX.B         D0,D0
                    ADD.B          D4,D4
                    ADDX.B         D0,D0
                    ADD.B          D5,D5
                    ADDX.B         D0,D0
                    ADD.B          D6,D6
                    ADDX.B         D0,D0
                    ADD.B          D7,D7
                    ADDX.B         D0,D0
                    MOVE.B         D0,(A4)                  ; write a byte to plane 6
                    SUBA.L         A5,A4                    ; jump to plane 5
                    ROL.WorL       #1,D0
                    ADD.B          D1,D1
                    ADDX.B         D0,D0
                    ADD.B          D2,D2
                    ADDX.B         D0,D0
                    ADD.B          D3,D3
                    ADDX.B         D0,D0
                    ADD.B          D4,D4
                    ADDX.B         D0,D0
                    ADD.B          D5,D5
                    ADDX.B         D0,D0
                    ADD.B          D6,D6
                    ADDX.B         D0,D0
                    ADD.B          D7,D7
.toplane5           ADDX.B         D0,D0
                    MOVE.B         D0,(A4)                  ; write a byte to plane 5
                    SUBA.L         A5,A4                    ; jump to plane 4
                    ROL.WorL       #1,D0
                    ADD.B          D1,D1
                    ADDX.B         D0,D0
                    ADD.B          D2,D2
                    ADDX.B         D0,D0
                    ADD.B          D3,D3
                    ADDX.B         D0,D0
                    ADD.B          D4,D4
                    ADDX.B         D0,D0
                    ADD.B          D5,D5
                    ADDX.B         D0,D0
                    ADD.B          D6,D6
                    ADDX.B         D0,D0
                    ADD.B          D7,D7
.toplane4           ADDX.B         D0,D0
                    MOVE.B         D0,(A4)                  ; write a byte to plane 4
                    SUBA.L         A5,A4                    ; jump to plane 3
                    ROL.WorL       #1,D0
                    ADD.B          D1,D1
                    ADDX.B         D0,D0
                    ADD.B          D2,D2
                    ADDX.B         D0,D0
                    ADD.B          D3,D3
                    ADDX.B         D0,D0
                    ADD.B          D4,D4
                    ADDX.B         D0,D0
                    ADD.B          D5,D5
                    ADDX.B         D0,D0
                    ADD.B          D6,D6
                    ADDX.B         D0,D0
                    ADD.B          D7,D7
.toplane3           ADDX.B         D0,D0
                    MOVE.B         D0,(A4)                  ; write a byte to plane 3
                    SUBA.L         A5,A4                    ; jump to plane 2
                    ROL.WorL       #1,D0
.toplane02          ADD.B          D1,D1
                    ADDX.B         D0,D0
                    ADD.B          D2,D2
                    ADDX.B         D0,D0
                    ADD.B          D3,D3
                    ADDX.B         D0,D0
                    ADD.B          D4,D4
                    ADDX.B         D0,D0
                    ADD.B          D5,D5
                    ADDX.B         D0,D0
                    ADD.B          D6,D6
                    ADDX.B         D0,D0
                    ADD.B          D7,D7
.toplane2           ADDX.B         D0,D0
                    MOVE.B         D0,(A4)                  ; write a byte to plane 2
                    SUBA.L         A5,A4                    ; jump to plane 1
                    ROL.WorL       #1,D0
.toplane01          ADD.B          D1,D1
                    ADDX.B         D0,D0
                    ADD.B          D2,D2
                    ADDX.B         D0,D0
                    ADD.B          D3,D3
                    ADDX.B         D0,D0
                    ADD.B          D4,D4
                    ADDX.B         D0,D0
                    ADD.B          D5,D5
                    ADDX.B         D0,D0
                    ADD.B          D6,D6
                    ADDX.B         D0,D0
                    ADD.B          D7,D7
.toplane1           ADDX.B         D0,D0
                    MOVE.B         D0,(A4)                  ; write a byte to plane 1
                    SUBA.L         A5,A4                    ; jump to plane 0
                    ROL.WorL       #1,D0
.1plane             NEG.B          D1
                    ADDX.B         D0,D0
                    NEG.B          D2
                    ADDX.B         D0,D0
                    NEG.B          D3
                    ADDX.B         D0,D0
                    NEG.B          D4
                    ADDX.B         D0,D0
                    NEG.B          D5
                    ADDX.B         D0,D0
                    NEG.B          D6
                    ADDX.B         D0,D0
                    NEG.B          D7
                    ADDX.B         D0,D0
                    MOVE.B         D0,(A4)                  ; write a byte to plane 0
                    ADDQ.W         #1,A0                    ; 1 planar byte done
.eightbytesdone     SUBQ.L         #8,(SP)                  ; 8 image bytes done
                    BGT.W          .nextchunk
                    ADDA.L         (SP)+,A1                 ; go to start of row
                    MOVEM.L        (SP)+,D0-D1
                    ADDA.L         D0,A0                    ; add planar pad byte
                    DBRA           D1,.nextrow
 ifd MC68020
                    CLR.L          (A0)                     ; no magic token yet
 endif
                    MOVEM.L        (SP)+,D2-D4/A2/A4-A5
                    RTS

;-------------------------------------------------------------------------

freerastermem       MOVE.L         (A1),D0                  ; backup *mementry
                    BEQ.S          .done
                    MOVEM.L        A2/A6,-(SP)
                    CLR.L          (A1)                     ; clear *mementry
                    MOVEA.L        D0,A2
                    MOVEA.L        $26(A5),A6               ; execbase
                    MOVE.L         (A2),D0
                    BEQ.S          .norastermem
                    MOVEA.L        D0,A1                    ; rastermem
                    MOVEM.W        4(A2),D0-D1              ; width, height
                    ADDQ.L         #8,D0
                    ADDQ.L         #7,D0
                    LSR.L          #4,D0
                    ADD.L          D0,D0                    ; word aligned bytes
                    MULU.W         D1,D0                    ; total plane size
                    BEQ.S          .norastermem
                    JSR            _LVOFreeMem(A6)
.norastermem        MOVEA.L        A2,A1                    ; *mementry
                    MOVEQ          #8,D0                    ; 8 bytes
                    JSR            _LVOFreeMem(A6)
                    MOVEM.L        (SP)+,A2/A6
.done               RTS

;-------------------------------------------------------------------------

updatePalMapMask                                            ; for tricky dragn
                    ; RLEjit creates an undesired mask, but we need something ;)

makePalMapMask      MOVEM.L        D2-D6/A2/A4/A6,-(SP)     ; A3=icon A5=iconbase
                    MOVEA.L        A0,A2                    ; PalMap
                    MOVEA.L        A1,A4                    ; *mask
                    BSR.S          freerastermem
                    MOVE.L         A2,D0
                    BEQ.W          .error
.norastermementry   TST.B          $10C(A2)                 ; transparency ?
                    BEQ.W          .done
                    MOVEQ          #8,D0                    ; allocate 8 bytes
                    MOVEQ          #MEMF_PUBLIC,D1
                    MOVEA.L        $26(A5),A6               ; execbase
                    JSR            _LVOAllocMem(A6)
                    MOVE.L         D0,D5                    ; rastermem pointer
                    BEQ.W          .failure
                    MOVEM.W        (A2),D2-D3               ; PalMap width, height
                    MOVEQ          #15,D6
                    MOVE.L         D2,D4                    ; image width
                    ADD.L          D6,D2
                    LSR.L          #4,D2                    ; words per line
                    ADD.L          D2,D2                    ; bytes per line
                    MOVE.L         D2,D0
                    MULU.W         D3,D0                    ; total plane size
                    MOVE.L         $C0(A5),D1               ; attributes (IPrefs)
                    JSR            _LVOAllocMem(A6)
                    MOVEA.L        D5,A0                    ; rastermem pointer
                    MOVE.L         D0,(A0)+                 ; rastermem plane
                    BEQ.W          .freepointer
                    MOVE.L         D5,(A4)                  ; return planeptr
.updatetheoldmask   MOVE.B         $10D(A2),D5              ; transparent color
                    MOVE.L         (A2)+,(A0)               ; plane width, height
                    MOVEA.L        D0,A1                    ; mask bitplane
                    MOVEQ          #16,D1
                    SUBQ.L         #1,D2                    ; image bytes/line - 1
                    SUBQ.L         #1,D3                    ; line counter - 1
                    AND.L          D6,D4
                    SUB.L          D4,D1
                    AND.L          D6,D1
                    MOVEQ          #0,D4
                    BSET           D1,D4
                    NEG.L          D4                       ; word alignment mask
                    MOVEA.L        (A2),A0                  ; PalMap image bytes
                    MOVEA.L        D2,A2
                    TST.B          $97B(A5)                 ; is ghosting off ?
                    BMI.S          .ghostingisoff
                    BTST           #2,$8A(A3)               ; is it a deficon ?
                    BEQ.S          .ghostingisoff
                    MOVE.B         $EF(A5),D2               ; mask for ghosting
                    MOVE.L         do_ToolTypes(A3),D0      ; ToolArray pointer ?
                    BEQ.S          .nextimageline
                    MOVEA.L        #"nogh",A6
.nexttooltype       MOVEA.L        D0,A4                    ; should be aligned
                    MOVE.L         (A4)+,D0                 ; ToolType pointer ?
                    BEQ.S          .nextimageline
                    EXG            D0,A4                    ; should be aligned
                    MOVE.L         (A4),D6                  ; get 4 characters
                    OR.L           lowercasefilter(PC),D6
                    SUB.L          A6,D6
                    BNE.S          .nexttooltype
 ifd MC68020
     macro ADD.WorL
     ADD.L \1,\2
     endm

     macro LSR.WorL
     LSR.L \1,\2
     endm
 else
     macro ADD.WorL
     ADD.W \1,\2
     endm

     macro LSR.WorL
     LSR.W \1,\2
     endm
 endif
.ghostingisoff      MOVEQ          #-1,D2                   ; turn all pixels on 
.nextimageline      MOVE.L         A2,D0                    ; init byte counter
.nextimagebyte      CMP.B          (A0)+,D5                 ; transparent color ?
                    SNE            D6
                    ADD.WorL       D6,D6
                    CMP.B          (A0)+,D5
                    SNE            D6
                    ADD.WorL       D6,D6
                    CMP.B          (A0)+,D5
                    SNE            D6
                    ADD.WorL       D6,D6
                    CMP.B          (A0)+,D5
                    SNE            D6
                    ADD.WorL       D6,D6
                    CMP.B          (A0)+,D5
                    SNE            D6
                    ADD.WorL       D6,D6
                    CMP.B          (A0)+,D5
                    SNE            D6
                    ADD.WorL       D6,D6
                    CMP.B          (A0)+,D5
                    SNE            D6
                    ADD.WorL       D6,D6
                    CMP.B          (A0)+,D5
                    SNE            D6
                    LSR.WorL       #7,D6
                    AND.B          D2,D6                    ; 50 % transparency
                    MOVE.B         D6,(A1)+                 ; save a bitmap byte
                    DBRA           D0,.nextimagebyte
                    SUBA.L         D1,A0                    ; to the left border
                    ROR.B          #1,D2                    ; shift mask 1 pixel
                    AND.W          D4,-2(A1)                ; clear the pad bits
                    DBRA           D3,.nextimageline
.done               MOVEQ          #0,D0                    ; all OK
.error              MOVEM.L        (SP)+,D2-D6/A2/A4/A6
                    RTS

.freepointer        MOVEQ          #8,D0                    ; 8 bytes
                    MOVEA.L        D5,A1                    ; rastermem planeptr
                    JSR            _LVOFreeMem(A6)
.failure            MOVEQ          #$67,D0                  ; no free memory
                    BRA.S          .error

;-------------------------------------------------------------------------

preparebitmap       ADDQ.W         #4,A0                    ; image width etc
                    MOVEM.W        (A0)+,D0-D1              ; width, height
                    ADDQ.L         #8,D0
                    ADDQ.L         #7,D0
                    LSR.L          #4,D0
                    ADD.L          D0,D0                    ; plane bytes/row
                    MOVE.W         D0,(A1)+                 ; bytes/row
                    MOVE.W         D1,(A1)+                 ; row count
                    MULU.W         D0,D1                    ; total plane size
                    MOVE.W         (A0)+,D0                 ; depth
                    MOVEA.L        (A0),A0                  ; planar image data
                    CMPI.W         #8,D0
                    BLS.S          .depthok
                    MOVEQ          #8,D0                    ; limit to 8 planes
.depthok            MOVE.W         D0,(A1)+                 ; flags, depth
                    CLR.W          (A1)                     ; clear pad word !!
                    ADDA.W         #30,A1
                    CLR.L          (A1)                     ; plane 7
                    CLR.L          -(A1)                    ; plane 6
                    CLR.L          -(A1)                    ; plane 5
                    CLR.L          -(A1)                    ; plane 4
                    CLR.L          -(A1)                    ; plane 3
                    CLR.L          -(A1)                    ; plane 2
                    CLR.L          -(A1)                    ; plane 1
                    CLR.L          -(A1)                    ; plane 0
                    BRA.S          .countdowndepth

.nextpointer        MOVE.L         A0,(A1)+                 ; image data offsets
                    ADDA.L         D1,A0                    ; add planesize
.countdowndepth     DBRA           D0,.nextpointer
                    RTS

;-------------------------------------------------------------------------

 ifd MC68020
copydotimage        MOVE.L         A0,$86(A3)               ; set icons screen
                    BSET.B         #3,$8A(A3)               ; GlobalScreen flag
                    LEA            $154+4(A5),A0            ; dot image width
                    MOVEA.L        D0,A1                    ; GadgetRender
                    ADDQ.W         #4,A1                    ; offset width
                    MOVE.L         (A0)+,(A1)+
                    MOVE.L         (A0)+,(A1)+
                    MOVE.L         (A0),(A1)
                    BRA.S          iconcolormapping\.checkPalMap2
 endif
iconcolormapping    MOVEM.L        D1/D7/A0/A2-A3/A6,-(SP)  ; D1=targetscreen
                    MOVE.L         D0,D7                    ; GlobalPrecision
                    MOVEA.L        A1,A3                    ; DiskObject
.checkGadgetRender  MOVEQ          #-4,D0
                    AND.B          D0,$11(A3)               ; clear flags 0, 1
                    MOVE.L         $16(A3),D0               ; GadgetRender ?
                    BNE.S          .hasGadgetRender
                    LEA            $4E(A3),A0               ; freelist
                    MOVEA.W        #20,A1                   ; 20 bytes
                    LEA            MEMF_PUBLIC|MEMF_CLEAR,A2
                    BSR.W          FreeAlloc                ; needs no iconbase
                    MOVE.L         D0,$16(A3)               ; memblock for Gadget
 ifd MC68020
                    BEQ.W          .usedeficons
 else
                    BEQ.S          .usedeficons
 endif
.hasGadgetRender    MOVEA.L        (SP),A0                  ; target screen
                    MOVEA.L        $76(A3),A1               ; PalMap1
                    MOVE.L         (A1),$C(A3)              ; copy width, height
 ifd MC68020
.checktheRTGflag    TST.B          $97A(A5)                 ; RTG flag set ?
                    BGT.W          .directdrawingone        ; set by gfx patch
                    BEQ.S          .docolormapping
                    TST.L          8(SP)                    ; delayed mapping ?
                    BEQ.S          copydotimage
 endif
.docolormapping     BSR.W          imagecolormapping        ; D7 = precision
 ifd MC68020
                    BNE.W          .usedeficons
                    MOVE.L         #$ADD2FEED,(A0)+         ; DirectD magic token
                    MOVE.L         $76(A3),(A0)             ; save PalMap1
 else
                    BNE.S          .usedeficons
 endif
.checkPalMap2       MOVEA.L        $7A(A3),A0               ; PalMap2
                    BSR.W          checkpalmap
                    BEQ.S          .badpalmap2
                    MOVE.L         $1A(A3),D0               ; SelectRender ?
                    BNE.S          .hasSelectRender
                    LEA            $4E(A3),A0               ; freelist
                    MOVEA.W        #20,A1                   ; 20 bytes
                    LEA            MEMF_PUBLIC|MEMF_CLEAR,A2
                    BSR.W          FreeAlloc                ; needs no iconbase
                    MOVE.L         D0,$1A(A3)               ; memblock for Select
                    BEQ.S          .usedeficons
.hasSelectRender    MOVEA.L        $7A(A3),A1               ; PalMap2
                    TST.W          $11C(A1)                 ; colormapping done ?
                    BNE.S          .getplanarimage
 ifd MC68020
                    TST.L          8(SP)                    ; delayed WB mapping ?
                    BEQ.W          .delayedmapping
                    TST.L          $96C(A5)                 ; DirOpus running ?
                    BEQ.S          .getplanarimage
                    TST.B          $EB(A5)                  ; DOnoColorMapping ?
                    BEQ.S          .getplanarimage
                    TST.B          $97A(A5)                 ; RTG flag > 0 ?
                    BLE.S          .getplanarimage
                    MOVEA.L        $26(A5),A0               ; execbase
                    MOVEA.L        ThisTask(A0),A0
                    MOVEA.L        LN_NAME(A0),A0           ; * task name
                    CMPI.L         #"s_fu",4(A0)
                    BEQ.W          .usedirectdrawing
 else
                    TST.L          8(SP)                    ; delayed mapping ?
                    BEQ.S          .delayedmapping
 endif
.getplanarimage     MOVEA.L        (SP),A0                  ; target screen
                    BSR.W          imagecolormapping        ; D7 = precision
                    BNE.S          .usedeficons
 ifd MC68020
                    MOVE.L         #$ADD2FEED,(A0)+         ; DirectD magic token
                    MOVE.L         $7A(A3),(A0)             ; save PalMap2
 endif
.hasimage2          BSET.B         #1,$11(A3)               ; has image2
                    BRA.S          .done

.badpalmap2         CLR.L          $7A(A3)                  ; remove PalMap2
                    BRA.S          .done
.usedeficons
 ifd MC68020
                    TST.B          $97A(A5)                 ; TrueColor screen ?
                    BEQ.S          .ChipMemDotGadget
                    TST.L          $96C(A5)                 ; DirOpus running ?
                    BNE.S          .ChipMemDotSelect
                    BTST.B         #1,$C0+3(A5)             ; is ChipMem used ?
                    BNE.S          .ChipMemDotGadget
                    BSR.W          usedeficons
                    BRA.S          .dropPalMaps

.ChipMemDotSelect   CLR.L          $1A(A3)                  ; remove SelectRender
                    CLR.L          $72(A3)
                    LEA            $154(A5),A0              ; struct dot image
                    MOVE.L         A0,$6E(A3)
 endif
.ChipMemDotGadget   LEA            $154(A5),A0              ; struct dot image
                    MOVE.L         A0,$16(A3)
                    MOVEQ          #8,D0
                    LEA            $C(A3),A0
                    MOVE.W         D0,(A0)+                 ; set width = 8
                    MOVE.W         D0,(A0)+                 ; set height = 8
                    MOVE.W         #4,(A0)                  ; flags = invert Dot
                    TST.L          $96C(A5)                 ; DirOpus running ?
                    BNE.S          .done
.dropPalMaps        MOVEA.L        $76(A3),A0               ; PalMap1
                    MOVE.L         $C(A3),(A0)              ; fake width, height
                    CLR.B          $10C(A0)                 ; no transparency
                    CLR.W          $11C(A0)                 ; mapped colors = 0
                    MOVE.L         $7A(A3),D0
                    BEQ.S          .exit
                    MOVEA.L        D0,A0                    ; PalMap2
                    MOVE.L         $C(A3),(A0)              ; fake width, height
                    CLR.B          $10C(A0)                 ; no transparency
                    CLR.W          $11C(A0)                 ; mapped colors = 0
.done               MOVEQ          #0,D0
.exit               MOVEM.L        (SP)+,D1/D7/A0/A2-A3/A6
                    RTS

.delayedmapping     TST.B          $97E(A5)                 ; is it WB 3.0/3.1 ?
                    BEQ.S          .trydotimage
 ifd MC68020
                    TST.L          $120(A5)                 ; cgxbase ?
                    BNE.W          .getplanarimage          ; v40 native P96 mask problem
 endif
                    MOVEA.L        D0,A0                    ; SelectRender
                    ADDQ.W         #4,A0                    ; offset width
                    MOVE.L         #$00010001,(A0)+         ; width=1, height=1
                    MOVE.W         #8,(A0)+                 ; depth=8
                    MOVE.L         A0,D7
                    LEA            $4E(A3),A0               ; freelist
                    MOVEA.W        #16,A1                   ; 16 bytes FastMem
                    LEA            MEMF_PUBLIC.w,A2
                    BSR.W          FreeAlloc                ; needs no iconbase
                    MOVEA.L        D7,A0
                    MOVE.L         D0,(A0)+                 ; SelectRender *data
                    BEQ.S          .image2failed
                    MOVEA.L        D0,A1
                    MOVE.L         #$DEC0DE42,(A1)+         ; set a magic token
                    MOVE.L         A3,(A1)                  ; store DiskObject
                    MOVE.W         #$FF00,(A0)              ; set PlanePick/OnOff
                    BRA.S          .dontcreatemask2

.image2failed       MOVE.L         $1A(A3),D0               ; restore SelectRender
.trydotimage        LEA            $154+4(A5),A0            ; dot image width
                    MOVEA.L        D0,A1                    ; SelectRender
                    ADDQ.W         #4,A1                    ; offset width
                    MOVE.L         (A0)+,(A1)+
                    MOVE.L         (A0)+,(A1)+
                    MOVE.L         (A0),(A1)
.dontcreatemask2    BSET.B         #5,$8A(A3)               ; skip mask2
                    BRA.W          .hasimage2

 ifd MC68020
.directdrawingone   TST.L          8(SP)
                    BPL.W          .docolormapping          ; is not DOpus5
.usedirectdrawing   MOVEA.L        D0,A6                    ; Gadget/SelectRender
                    ADDQ.W         #4,A6                    ; offset width
                    MOVE.L         (A1),(A6)+               ; PalMap width height
                    MOVE.W         #8,(A6)+                 ; image depth = 8
                    MOVEM.W        (A1),D0/D7               ; image width, height
                    ADDQ.L         #8,D0
                    ADDQ.L         #7,D0
                    AND.B          #$F0,D0                  ; round to word size
                    MULU.W         D0,D7                    ; total image bytes
                    MOVEA.L        D7,A1                    ; memory for 8 planes
                    ADDQ.W         #8,A1                    ; for magic DD token
                    LEA            $4E(A3),A0               ; freelist
                    MOVEA.W        $C2(A5),A2               ; use GlobalAttributes
                    BSR.W          FreeAlloc                ; needs no iconbase
                    MOVE.L         D0,(A6)+                 ; image data memblock
                    BEQ.W          .ChipMemDotSelect
                    MOVE.W         #$FF00,(A6)              ; set PlanePick/OnOff
                    MOVEA.L        D0,A0                    ; top of image data
                    LSR.L          #4,D7                    ; size in 4*longwords
                    SUBQ.L         #1,D7                    ; words of 1 plane - 1
                    MOVE.L         D7,D0
.clearallimagedata  CLR.L          (A0)+
                    CLR.L          (A0)+
                    CLR.L          (A0)+
                    CLR.L          (A0)+                    ; for 8 planes only
                    DBRA           D0,.clearallimagedata
                    MOVE.L         #$ADD2FEED,(A0)+         ; direct drawing token
                    LEA            -$E(A6),A6
                    CMPA.L         $16(A3),A6               ; is it GadgetRender ?
                    BNE.S          .directdrawingtwo
                    MOVE.L         $76(A3),(A0)             ; append PalMap1
                    LEA            $7E(A3),A2
                    MOVEA.L        (A0),A0                  ; PalMap1
                    MOVEA.L        A2,A1                    ; *mask1
                    BSR.W          makePalMapMask
                    MOVEA.L        $A(A6),A1                ; image1 data pointer
                    MOVE.L         (A2),D0                  ; was mask1 created ?
                    BEQ.S          .makeinvertedplane
                    MOVEA.L        D0,A0
                    MOVEA.L        (A0),A0                  ; mask1 plane pointer
.copymask1toimage   MOVE.W         (A0)+,(A1)+
                    DBRA           D7,.copymask1toimage
.GadgetRenderdone   MOVEQ          #-1,D7                   ; reset icon quality
                    MOVE.L         (SP),$86(A3)             ; set icons screen
                    BRA.W          .checkPalMap2

.makeinvertedplane  MOVEQ          #-1,D0
.writeimage1plane0  MOVE.W         D0,(A1)+
                    DBRA           D7,.writeimage1plane0
                    BRA.S          .GadgetRenderdone

.directdrawingtwo   MOVE.L         $7A(A3),(A0)             ; append PalMap2
                    MOVE.W         $8A(A3),-(SP)            ; save icon flags
                    BSET.B         #2,$8A(A3)               ; make a ghosted mask
                    LEA            $82(A3),A2
                    MOVEA.L        (A0),A0                  ; PalMap2
                    MOVEA.L        A2,A1                    ; *mask2
                    BSR.W          makePalMapMask
                    BSET.B         #5,(SP)                  ; no mask2 wanted
                    MOVE.W         (SP)+,$8A(A3)            ; restore icon flags
                    MOVEA.L        $A(A6),A1                ; image2 data pointer
                    MOVE.L         (A2),D0                  ; was mask2 created ?
                    BEQ.S          .makestripedplane
                    MOVEA.L        D0,A0
                    MOVEA.L        (A0),A0                  ; mask2 plane pointer
.copymask2toimage   MOVE.W         (A0)+,(A1)+
                    DBRA           D7,.copymask2toimage
.SelectRenderdone   BRA.W          .hasimage2

.makestripedplane   MOVE.W         #%1010101010101010,D0
.writeimageplane0   MOVE.W         D0,(A1)+
                    DBRA           D7,.writeimageplane0
                    BRA.S          .SelectRenderdone
 endif

;-------------------------------------------------------------------------

allocnamecat_info   MOVEM.L        A2/A6,-(SP)
                    MOVEA.L        A1,A2                    ; filename
.getlast            TST.B          (A1)+
                    BNE.S          .getlast
                    SUBA.L         A2,A1
                    MOVE.L         A1,D0
                    ADDQ.L         #5,D0
                    MOVEA.L        $26(A5),A6               ; execbase
                    MOVEQ          #MEMF_PUBLIC,D1
                    JSR            _LVOAllocVec(A6)
                    TST.L          D0
                    BEQ.S          .nomem
                    MOVEA.L        D0,A0
.copyfilename       MOVE.B         (A2)+,(A0)+
                    BNE.S          .copyfilename
 ifd MC68020
                    CMPI.W         #$2F00,-(A0)             ; dir name with slash ?
                    BEQ.S          .addextension
                    ADDQ.W         #1,A0
.addextension       MOVE.B         #".",(A0)+
                    MOVE.L         #"info",(A0)+
 else
                    SUBQ.W         #2,A0
                    CMPI.B         #"/",(A0)
                    BEQ.S          .addextension
                    ADDQ.W         #1,A0
.addextension       MOVE.B         #".",(A0)+
                    MOVE.B         #"i",(A0)+
                    MOVE.B         #"n",(A0)+
                    MOVE.B         #"f",(A0)+
                    MOVE.B         #"o",(A0)+
 endif
                    CLR.B          (A0)
.nomem              MOVEM.L        (SP)+,A2/A6
                    RTS

;-------------------------------------------------------------------------

readtoolstring      MOVEM.L        D2/A0/A2,-(SP)           ; A2=freelist
                    CLR.L          (A0)                     ; clear string pointer
                    MOVEA.L        A2,A0                    ; freelist
                    MOVEA.W        #MEMF_PUBLIC,A2          ; attributes
                    MOVEQ          #4,D0                    ; 4 bytes string size
                    SUB.L          D0,$48+$10(SP)           ; remaining - required
                    BCS.S          .stringtoolong
                    MOVEA.L        $44+$10(SP),A1           ; current position
                    ADD.L          D0,$44+$10(SP)           ; final copy position
 ifd MC68020
                    MOVE.L         (A1),D2
 else
                    MoveOddLong    A1,D2
 endif
                    MOVEA.L        D2,A1                    ; length of toolstring
                    CMPA.W         #1000,A1                 ; should be 128 ONLY !
                    BHI.S          .stringtoolong           ; more than 1000 chars
                    BSR.W          FreeAlloc                ; needs no iconbase
                    MOVEA.L        4(SP),A0                 ; * string pointer
                    MOVE.L         D0,(A0)                  ; new string pointer
                    BNE.S          .readstring
.nomem              MOVEQ          #103,D5                  ; out of memory
                    BRA.S          .error

.string_ERROR       MOVEA.L        8(SP),A0                 ; freelist
.stringtoolong      MOVEA.W        #8,A1
                    BSR.W          FreeAlloc                ; needs no iconbase
                    MOVEA.L        4(SP),A0                 ; * string pointer
                    MOVE.L         D0,(A0)                  ; new string pointer
                    BEQ.S          .nomem
                    MOVEA.L        D0,A0                    ; new string
                    MOVE.L         #$28455252,(A0)+
                    MOVE.L         #$4F522900,(A0)          ; (ERROR)
                    MOVEQ          #120,D0                  ; invalid or too long
                    BRA.S          .error

.readstring         SUB.L          D2,$48+$10(SP)           ; remaining - required
                    BCS.S          .string_ERROR
                    MOVEA.L        $44+$10(SP),A0           ; current position
                    ADD.L          D2,$44+$10(SP)           ; final copy position
                    MOVEA.L        D0,A1                    ; target buffer
                    MOVE.L         D2,D0                    ; length of toolstring
                    BSR.W          CopyMemBlock             ; A1 is re-used
                    CMPI.B         #40+1,D2
                    BNE.S          .done
                    LEA            string_DontEdit(PC),A0
                    SUB.L          D2,A1
                    CMP.L          (A0)+,(A1)+
                    BNE.S          .done
                    CMP.L          (A0)+,(A1)+
                    BNE.S          .done                    ; don't change flag
                    SEQ            $40+$10(SP)              ; flag for NewIcons
.done               MOVEQ          #0,D0                    ; no error
.error              MOVEM.L        (SP)+,D2/A0/A2
                    RTS

;-------------------------------------------------------------------------

readplanarimage     MOVEA.L        $44+4(SP),A1             ; current position
                    MOVEM.W        4(A1),D0-D1              ; width, height
                    ADDQ.L         #7,D0
                    ADDQ.L         #8,D0                    ; width + 15
                    LSR.L          #4,D0                    ; round to wordsize
                    ADD.L          D0,D0                    ; bytes/line
                    MULU.W         D1,D0                    ; bytes/plane
                    MULU.W         8(A1),D0                 ; total bytes to read
                    MOVEQ          #20,D1                   ; sizeof struct image
                    ADD.L          D1,D0
                    SUB.L          D0,$48+4(SP)             ; remaining - required
                    BCS.S          .endoficonerror
                    ADD.L          D0,$44+4(SP)             ; new data position
                    SUB.L          D1,D0                    ; size of real image
                    MOVE.L         A1,D1                    ; old data position
                    LEA            do_Gadget+gg_SelectRender(A3),A1
                    CMPA.L         A0,A1                    ; = *image ?
                    SEQ            $41+4(SP)                ; has real image 2
                    BEQ.S          .image2wasfound
                    MOVE.L         D0,$24C+4(SP)            ; size of real image
                    BTST.B         #1,$C3(A5)               ; is ChipMem used ?
                    BNE.S          .usethedotimage
                    MOVE.L         (A1),-(SP)               ; get real image 2
                    MOVEM.L        D0-D1/A1,-(SP)
                    BSR.S          usedeficons
                    MOVE.L         (SP)+,$24C+4+$C(SP)      ; save image 1 size
                    MOVE.L         (SP)+,$250+4+8(SP)       ; save real image 1
                    MOVEA.L        (SP)+,A0                 ; * SelectRender
                    TST.L          (SP)+                    ; test real image 2
                    BEQ.S          .image2notfound
                    TST.L          (A0)                     ; deficon image 2 ?
                    BEQ.S          readplanarimage
                    RTS

.image2notfound     LEA            longwordfor0000(PC),A0   ; skip real image 2
                    BRA.S          .deficonwasused

.image2wasfound     MOVE.W         D0,$42+4(SP)             ; save image 2 size
                    LEA            $154(A5),A1              ; struct dot image
                    CMPA.L         do_Gadget+gg_GadgetRender(A3),A1
                    BNE.S          .deficonwasused
                    CLR.L          (A0)                     ; clear SelectRender
.deficonwasused     MOVEQ          #1,D0                    ; return success
                    RTS

.endoficonerror     CLR.L          do_DefaultTool(A3)
                    CLR.L          do_ToolTypes(A3)
                    CLR.L          do_ToolWindow(A3)
                    MOVEQ          #0,D1                    ; drop real image 1
                    LEA            do_Gadget+gg_SelectRender(A3),A1
                    CLR.L          (A1)                     ; clear SelectRender
                    CMPA.L         A0,A1                    ; = *image ?
                    BEQ.S          .droprealimage1          ; close the file now
.usethedotimage     LEA            $154(A5),A1              ; struct dot image
                    MOVE.L         A1,(A0)+                 ; GadgetRender = Dot
                    MOVE.W         #4,do_Gadget+gg_Flags(A3); flags = invert Dot
.droprealimage1     MOVE.L         D1,$250+4(SP)            ; save real image 1
                    RTS

;-------------------------------------------------------------------------

usedeficons         MOVEQ          #6,D0
                    MOVE.B         do_Type(A3),D1
                    SUBQ.B         #1,D1
                    CMP.B          D0,D1
                    BHI.S          .getdeficon              ; force WBPROJECT
                    ADD.B          D1,D1
                    MOVE.B         D1,D0
.getdeficon         LEA            DiskObjectTypes(PC),A0
 ifd MC68020
                    ADDA.W         (A0,D0.L),A0
 else
                    ADDA.W         (A0,D0.W),A0
 endif
                    MOVE.B         do_Type(A0),do_Type(A3)
                    MOVEQ          #14,D0                   ; copy 14 bytes
                    LEA            do_Gadget+gg_Flags(A0),A0
                    LEA            do_Gadget+gg_Flags(A3),A1
                    BRA.W          CopyMemAligned

;-------------------------------------------------------------------------

decompressdata      MOVEM.L        D2-D7/A2,-(SP)           ; D0 size of source A2
                    MOVE.L         A0,D7                    ; D7 size of target A1
                    SUBQ.B         #8,D1                    ; depth = 8 ?
                    BEQ.W          .use8bitsfordepth
                    ADDQ.B         #8,D1                    ; depth again
                    MOVEQ          #0,D4                    ; empty bitbuffer
                    MOVEQ          #0,D6                    ; bits in bitbuffer
.targetnotfull      MOVEQ          #8,D3
                    SUB.B          D6,D3                    ; 8 - bits
                    SUBQ.B         #8,D6                    ; bits - 8
                    BGE.S          .readcontrolbyte         ; enough buffer bits
                    SUBQ.L         #1,D0
                    BLT.S          .return                  ; not enough data
                    MOVEQ          #0,D2
                    MOVE.B         (A2)+,D2                 ; get source byte
                    ADDQ.B         #8,D6                    ; bits + 8
                    LSL.L          D3,D2                    ; data << (8-bits)
                    OR.W           D2,D4                    ; add new below old
.readcontrolbyte    MOVE.L         D4,D5                    ; get control Hi-byte
                    LSL.W          #8,D4                    ; drag Hi-byte out
                    ASR.W          #8,D5                    ; counter >= 0 ?
                    BPL.S          .datasequence
                    NEG.W          D5                       ; invert counter
                    SUB.L          D5,D7
                    BLE.S          .nofreespace             ; not enough space
                    SUB.B          D1,D6                    ; bits - depth
                    BGE.S          .enoughdatabits
                    SUBQ.L         #1,D0
                    BLT.S          .return                  ; not enough data
                    MOVEQ          #0,D2
                    MOVE.B         (A2)+,D2                 ; get source byte
                    ADDQ.L         #8,D6                    ; bits + 8
                    LSL.L          D3,D2                    ; data << (8-bits)
                    OR.W           D2,D4                    ; add new below old
.enoughdatabits     ROL.W          D1,D4                    ; rotate data<<depth
.byterun            MOVE.B         D4,(A1)+                 ; repeat same byte
                    DBRA           D5,.byterun
                    CLR.B          D4                       ; data << depth
.nofreespace        SUBQ.L         #1,D7                    ; error is negative
                    BGT.S          .targetnotfull
                    BRA.S          .return

.datasequence       SUB.L          D5,D7
                    BLE.S          .outofspace              ; not enough space
.copynextbyte       SUB.B          D1,D6                    ; bits - depth
                    BGE.S          .enoughcopybits
                    SUBQ.L         #1,D0
                    BLT.S          .return                  ; not enough data
                    MOVEQ          #0,D2
                    MOVE.B         (A2)+,D2                 ; get source byte
                    ADDQ.B         #8,D6                    ; bits + 8
                    LSL.L          D3,D2                    ; data << (8-bits)
                    OR.W           D2,D4                    ; add new below old
                    SUBQ.B         #8,D3                    ; eight less to shift
.enoughcopybits     ADD.B          D1,D3                    ; depth more to shift
                    ROL.W          D1,D4                    ; rotate data<<depth
                    MOVE.B         D4,(A1)+                 ; copy another byte
                    CLR.B          D4                       ; data << depth
                    DBRA           D5,.copynextbyte
.outofspace         SUBQ.L         #1,D7                    ; error is negative
                    BGT.S          .targetnotfull
.return             MOVEM.L        (SP)+,D2-D7/A2
                    RTS

.decompresscolormap MOVEM.L        D2-D7/A2,-(SP)           ; for decompressdata
                    MOVE.L         D2,D7                    ; fullsize of colormap
                    BRA.S          .use8bitsfordepth

.bytesequence       SUB.L          D2,D0
                    BLT.S          .return                  ; not enough data
                    SUB.L          D2,D7
                    BLE.S          .checkspace
.copytotarget       MOVE.B         (A2)+,(A1)+              ; copy another byte
                    DBRA           D2,.copytotarget
.checkspace         SUBQ.L         #1,D7                    ; error is negative       
                    BLE.S          .return
.use8bitsfordepth   SUBQ.L         #2,D0                    ; we need 2 bytes
                    BLT.S          .return                  ; not enough data
                    MOVEQ          #0,D2
                    MOVE.B         (A2)+,D2                 ; get control byte
                    BPL.S          .bytesequence
                    NEG.B          D2
                    SUB.L          D2,D7
                    BLE.S          .checkspace              ; not enough space
                    MOVE.B         (A2)+,D3                 ; get the data byte
.repeatbyte         MOVE.B         D3,(A1)+                 ; repeat same byte
                    DBRA           D2,.repeatbyte
                    BRA.S          .checkspace

;------------------------------------------------------------------
;                                                             
;   NAME                                                      
;       GetIcon - read in a DiskObject structure from disk. ; it's iconprivate3 
;                                                             
;   SYNOPSIS                                                  
;       status = GetIcon( name, icon, free )                  
;         D0               A0    A1    A2                     
;                                                             
;       long = char *, struct DiskObject *, struct FreeList *;
;                                                             
;   FUNCTION                                                  
;       This routine reads in a DiskObject structure, and its 
;       associated information.  All memory will be automatica
;       allocated, and stored in the specified FreeList. 

                    CNOP           0,4

GetIcon             MOVE.L         A0,D0                    ; icon name ?
                    BEQ.S          .argmissing
                    MOVE.L         A1,D0                    ; empty DiskObject ?
                    BEQ.S          .argmissing
                    MOVE.L         A2,D0                    ; freelist ?
                    BNE.S          .argsok
.argmissing         MOVEQ          #116,D1                  ; argument missing
                    MOVE.L         A6,-(SP)
                    MOVEA.L        $2A(A6),A6               ; dosbase
                    JSR            _LVOSetIoErr(A6)
                    MOVEA.L        (SP)+,A6
.returnfailure      MOVEQ          #0,D0
                    RTS

.argsok             MOVE.L         A1,-(SP)
                    MOVEA.L        $36(A6),A1               ; intuibase
                    MOVE.L         $38(A1),$128(A6)         ; Global=ActiveScreen
                    MOVEQ          #-1,D0
                    MOVE.B         D0,$97E(A6)              ; flag for WB 3.0/3.1
                    MOVE.L         D0,A1                    ; disable the taglist
                    BSR.W          GetIconTagList
                    MOVEA.L        (SP)+,A1
                    BEQ.S          .returnfailure
                    MOVEA.L        D0,A0                    ; V44 DiskObject
                    MOVEM.L        A2-A3/A5,-(SP)
                    MOVEA.L        A0,A3                    ; source DiskObject
                    MOVEA.L        A1,A2                    ; target DiskObject
                    MOVEA.L        A6,A5                    ; iconbase
                    MOVEQ          #$4E,D0                  ; size of DiskObject
                    BSR.W          CopyMemAligned
                    MOVE.L         A3,$26(A2)               ; SpecialInfo = V44 DO
                    BSET.B         #1,$F1(A5)               ; V44 icon protection
                    BEQ.S          .removeiconnode          ; no FreeDiskObject()
                    BSR.W          bitlockdelay             ; call by WB 3.0/3.1

.removeiconnode     MOVEM.L        $62(A3),A1-A2            ; remove v44icon node
                    MOVE.L         A1,(A2)
                    MOVE.L         A2,4(A1)
                    SUBQ.B         #2,$F1(A5)               ; clear V44 protection
                    LEA            $7E(A3),A1               ; mask1 never used
                    BSR.W          freerastermem
                    LEA            $82(A3),A1               ; mask2 never used
                    BSR.W          freerastermem
                    TST.L          $DC(A5)                  ; GfxPatch installed ?
                    BNE.S          .addicontofreelist
                    MOVEA.L        $26(A5),A6               ; execbase
                    BSR.W          installGfxPatch          ; needs A6 = execbase
.addicontofreelist  LEA            $4E(A3),A0               ; V44 freelist
                    MOVEA.L        A3,A1                    ; V44 DiskObject
                    LEA            142.w,A2                 ; size of V44 icon
                    MOVEA.L        A5,A6                    ; iconbase
                    BSR.W          fastAFL                  ; AddFreeList
                    MOVEA.L        (SP),A2                  ; icon freelist
                    LEA            $4E(A3),A3               ; V44 freelist
                    MOVE.W         (A2)+,(A3)+              ; copy fl_NumFree
                    MOVEA.L        (A3),A0                  ; V44 first ml_Node
                    ADDQ.W         #8,A3                    ; * V44 lh_TailPred
                    MOVEA.L        (A3),A1                  ; V44 last ml_Node
                    MOVE.L         8(A2),(A3)               ; copy lh_TailPred
                    MOVEA.L        (A2),A3                  ; icon first ml_Node
                    MOVE.L         A1,4(A3)                 ; V44 last ml_Node
                    MOVE.L         A3,(A1)                  ; icon first ml_Node
                    MOVE.L         A0,(A2)                  ; V44 first ml_Node
                    MOVE.L         A2,4(A0)                 ; icon lh_Head
                    MOVEM.L        (SP)+,A2-A3/A5
                    MOVEQ          #1,D0                    ; return success
                    RTS

;------------------------------------------------------------------

                    CNOP           0,4

; GetDefDiskObject - read default wb disk object from disk. (V36)
; diskobj = GetDefDiskObject(def_type)
;   D0                          D0
; struct DiskObject *GetDefDiskObject(LONG);

GetDefDiskObject    PEA            (-1).w                   ; enableGetIconTags
                    PEA            (TAG_MORE).w             ; in GetIconTagList()
                    MOVE.L         D0,-(SP)                 ; type
                    PEA            ICONGETA_GetDefaultType
                    MOVE.L         A6,-(SP)
                    MOVEA.L        $26(A6),A6               ; execbase
                    MOVEQ          #$A,D0                   ; workbench tag
                    JSR            _LVOPrivateOpenLibrary(A6)
                    TST.L          D0
                    BEQ.S          .noworkbenchbase
                    MOVEA.L        D0,A1                    ; wbbase
                    CMPI.W         #40,LIB_VERSION(A1)
                    BHI.S          .higherworkbench
                    MOVEA.L        (SP),A0                  ; iconbase
                    MOVEA.L        $36(A0),A1               ; intuibase
                    MOVE.L         $38(A1),$128(A0)         ; Global=ActiveScreen
                    SCC.B          $97E(A0)                 ; flag for WB 3.0/3.1
                    MOVEA.L        D0,A1                    ; wbbase
.higherworkbench    JSR            _LVOCloseLibrary(A6)
.noworkbenchbase    MOVEA.L        (SP)+,A6                 ; iconbase
                    SUBA.L         A0,A0                    ; no icon name
                    BRA.S          gettaglistandmore        ; 4 longwords on stack

;------------------------------------------------------------------

                    CNOP           0,4

; GetDiskObject[New] - read in a Workbench disk object from disk.
; diskobj = GetDiskObject[New](name)
;   D0                          A0
; struct DiskObject *GetDiskObject[New](STRPTR);

GetDiskObject       MOVE.L         A0,D0
                    BEQ.S          buildDOstructure
                    TST.L          $974(A6)                 ; is Workbench running ?
                    BNE.S          checkactivescreen
                    LEA            GetDO_Planar_Tags(PC),A1 ; avoid early WB opening
invalid_WindowPtr   MOVEA.L        D0,A0                    ; restore icon name
rungeticontaglist   BSR.W          GetIconTagList
                    BRA.S          testfordiskobject

checkactivescreen   SUBA.L         A1,A1                    ; no taglist by default
checkscreenNoFail   MOVEA.L        $36(A6),A0               ; intuibase
                    MOVE.L         $38(A0),D1               ; ActiveScreen (i.e. DOpus4)
                    MOVEA.L        $26(A6),A0               ; execbase
                    MOVEA.L        ThisTask(A0),A0
                    MOVEA.L        pr_WindowPtr(A0),A0
 ifd MC68020
                    TST.L          A0
 else
                    CMPA.W         #0,A0
 endif
                    BLE.S          invalid_WindowPtr
                    CMP.L          wd_WScreen(A0),D1
                    MOVEA.L        D0,A0                    ; restore icon name
                    BNE.S          rungeticontaglist
                    MOVE.L         A1,-(SP)                 ; NULL or DontFail_Tags
                    PEA            (TAG_MORE).w
                    MOVE.L         D1,-(SP)                 ; WScreen=ActiveScreen
                    PEA            ICONGETA_Screen
gettaglistandmore   MOVEA.L        SP,A1                    ; taglist with TAG_MORE
                    BSR.W          GetIconTagList
                    LEA            $10(SP),SP               ; drop the local tags
testfordiskobject   TST.L          D0
                    BEQ.S          .gotnodiskobject
                    MOVEA.L        D0,A0
                    MOVE.L         D0,$26(A0)               ; SpecialInfo = V44 DO
.gotnodiskobject    RTS

                    CNOP           0,4

GetDiskObjectNew    LEA            DontFail_Tags(PC),A1     ; use def_icon on failure
                    MOVE.L         A0,D0
                    BNE.S          checkscreenNoFail
buildDOstructure    MOVEM.L        A4-A6,-(SP)
                    MOVEA.L        A6,A5                    ; iconbase
                    MOVEQ          #71,D0
                    ADD.L          D0,D0                    ; 142 bytes for v44 DO
                    MOVEA.L        $26(A5),A6               ; execbase
                    MOVE.L         #MEMF_PUBLIC|MEMF_CLEAR,D1
                    JSR            _LVOAllocMem(A6)
                    MOVE.L         D0,-(SP)                 ; save struct DiskObject
                    BEQ.S          .nomem
                    MOVEA.L        D0,A4
                    MOVE.L         DiskObject_tool(PC),(A4) ; do_Magic = $E3100001
                    LEA            $50+4(A4),A0             ; empty free/memlist
                    MOVE.L         A0,-(A0)
                    MOVE.L         A0,$8(A0)
                    LEA            $5E(A4),A0               ; magic v44 selfpointer
                    MOVE.L         A0,(A0)
                    ADDQ.B         #2,$8A(A4)               ; use NewIcon tooltypes
                    BSET.B         #1,$F1(A5)               ; V44 icon protection
                    BEQ.S          .appendiconnode
                    BSR.W          bitlockdelay

.appendiconnode     LEA            $62(A4),A1               ; A1 = new struct node
                    LEA            $A2+8(A5),A4             ; A4 = list *lh_TailPred
                    MOVE.L         (A4),D1                  ; D1 = old lh_TailPred
                    MOVE.L         A1,(A4)                  ; new lh_TailPred = A1
                    SUBQ.W         #4,A4                    ; *lh_Tail -> Null
                    EXG            D1,A4
                    MOVEM.L        D1/A4,(A1)               ; succ=0, pred=old
                    MOVE.L         A1,(A4)                  ; old succ = A1
                    SUBQ.B         #2,$F1(A5)               ; clear V44 protection
.nomem              MOVEM.L        (SP)+,D0/A4-A6
                    RTS

;------------------------------------------------------------------

                    CNOP           0,4

; PutIcon - write out an Icon to disk.                      ; it's iconPrivate4
; status = PutIcon(name, icon)
;  D0               A0    A1
; BOOL PutIcon(STRPTR, struct DiskObject *);

PutIcon             MOVE.L         $26(A1),D0               ; SpecialInfo set ?
                    BEQ.S          PutNormalIcon            ; should not happen
                    MOVEM.L        D0/A0/A2,-(SP)
                    MOVEA.L        A1,A0                    ; old DiskObject
                    MOVEA.L        D0,A1                    ; V44 DiskObject
                    MOVEQ          #0,D1                    ; default write all
                    LEA            Snapshot_Tags(PC),A2
                    MOVEM.L        do_CurrentX(A0),D0-D1
                    CMP.L          do_CurrentX(A1),D0
                    BNE.S          .updateposition
                    CMP.L          do_CurrentY(A1),D1
                    BEQ.S          .copyDiskObject
.updateposition     MOVEM.L        D0-D1,do_CurrentX(A1)
                    MOVE.L         do_DrawerData(A0),do_DrawerData(A1)
                    TST.L          do_DefaultTool(A0)
                    BNE.S          .puticontaglist
                    MOVE.L         do_DefaultTool(A1),do_DefaultTool(A0)
                    BRA.S          .puticontaglist          ; fix for DefIconsNI

.copyDiskObject     MOVEQ          #$4E,D0                  ; size of old icon
                    BSR.W          CopyMemBlock  
                    ADDQ.W         #8,A2                    ; no tags = TAGDONE
.puticontaglist     MOVEA.L        (SP)+,A1                 ; V44 DiskObject
                    MOVEA.L        (SP)+,A0                 ; file name
                    BRA.S          callPutIconTagList

;------------------------------------------------------------------

                    CNOP           0,4

; PutDiskObject - write out a DiskObject to disk.
; status = PutDiskObject(name, diskobj)
;  D0                     A0    A1
; BOOL PutDiskObject(STRPTR, struct DiskObject *);

PutDiskObject       MOVE.L         $26(A1),D0               ; SpecialInfo set ?
                    BEQ.S          PutNormalIcon            ; created on WB 3.5+
                    MOVEM.L        D0/A0,-(SP)
                    CMP.L          A1,D0                    ; same DiskObject ?
                    BEQ.S          .diskobjectok
                    MOVEA.L        A1,A0                    ; old DiskObject
                    MOVEA.L        D0,A1                    ; V44 DiskObject
                    MOVEQ          #$4E,D0                  ; size of old icon
                    BSR.W          CopyMemAligned
.diskobjectok       MOVEA.L        (SP)+,A1                 ; V44 DiskObject
                    MOVEA.L        (SP)+,A0                 ; file name
PutNormalIcon       MOVE.L         A2,-(SP)
                    LEA            PutDO_Tags(PC),A2
callPutIconTagList  CLR.L          $26(A1)                  ; no V44 SpecialInfo
                    JSR            _LVOPutIconTagList(A6)
                    MOVEA.L        (SP)+,A2
                    EXT.L          D0
                    RTS

;------------------------------------------------------------------

                    CNOP           0,4

; PutDefDiskObject - write disk object as the default for its type. (V36)
; status = PutDefDiskObject(diskobj)
;   D0                        A0
; BOOL PutDefDiskObject(struct DiskObject *);

PutDefDiskObject    MOVE.L         A2,-(SP)
                    MOVEA.L        A0,A1                    ; struct DO
                    MOVEQ          #0,D0
                    MOVE.B         $30(A1),D0
                    CLR.L          -(SP)                    ; TAG_DONE
                    MOVE.L         D0,-(SP)                 ; DO type
                    PEA            ICONPUTA_PutDefaultType
                    SUBA.L         A0,A0                    ; no name
                    MOVEA.L        SP,A2                    ; * tagitem
                    JSR            _LVOPutIconTagList(A6)
                    MOVEM.L        (SP)+,D1/A0-A2
                    EXT.L          D0
                    RTS

;------------------------------------------------------------------

                    CNOP           0,4

; DeleteDiskObject - Delete a Workbench disk object from disk. (V37)
; result = DeleteDiskObject(name)
;   D0                      A0
; BOOL DeleteDiskObject(STRPTR);

DeleteDiskObject    MOVEM.L        D2-D3/D7/A2-A3/A5-A6,-(SP)
                    MOVEA.L        A6,A5                    ; iconbase
                    MOVE.L         A0,D0                    ; file name ?
                    BEQ.S          .nofilename
                    MOVEA.L        A0,A3                    ; * file name
                    MOVEA.L        A3,A1
                    BSR.W          allocnamecat_info
                    MOVE.L         D0,D1                    ; name.info memblock
                    BNE.S          .checkfilelocks
                    MOVEQ          #$67,D1                  ; no free memory
                    BRA.S          .nofreememory

.nofilename         MOVEQ          #$74,D1                  ; argument missing
.nofreememory       BRA.S          .error

.checkfilelocks     MOVEA.L        D0,A2                    ; save * name.info
                    MOVEA.L        $2A(A5),A6               ; dosbase
                    MOVEQ          #ACCESS_READ,D2
                    JSR            _LVOLock(A6)
                    MOVE.L         D0,D3                    ; lock on name.info
                    BEQ.S          .getfilepart
                    MOVE.L         A3,D1                    ; * file name
                    JSR            _LVOLock(A6)
                    MOVE.L         D3,D1                    ; lock on name.info
                    MOVE.L         D0,D2                    ; lock on file name
                    JSR            _LVOSameLock(A6)
                    MOVE.L         D0,D7
                    MOVE.L         D2,D1                    ; unlock file name
                    JSR            _LVOUnLock(A6)
                    MOVE.L         D3,D1                    ; unlock name.info
                    JSR            _LVOUnLock(A6)
                    TST.L          D7                       ; name = name.info ?
                    BEQ.S          .removeobject            ; don't kill mother
.getfilepart        MOVE.L         A3,D1                    ; file name
                    JSR            _LVOFilePart(A6)
                    MOVEA.L        D0,A0                    ; file part
.countchars         TST.B          (A0)+
                    BNE.S          .countchars
                    SUBQ.W         #1,A0
                    SUBA.L         D0,A0                    ; file name lenght
                    CMPA.W         $CA(A5),A0               ; GlobalMaxNameLength
                    BHI.S          .noerror
                    MOVE.L         A2,D1                    ; name.info
                    JSR            _LVODeleteFile(A6)
                    TST.L          D0                       ; deleted=1 failed=0
                    BNE.S          .noerror
                    JSR            _LVOIoErr(A6)
                    MOVE.L         D0,D7                    ; error code
                    MOVEQ          #$32,D1
                    NOT.B          D1
                    CMP.L          D1,D0                    ; object not found ?
                    BEQ.S          .noerror
                    TST.L          D7                       ; other error ?
                    BNE.S          .notdeleted
.noerror            MOVEQ          #0,D7                    ; no error code
.removeobject       MOVEA.L        A5,A0                    ; iconbase
                    MOVEA.L        A3,A1                    ; file name
                    MOVEQ          #UPDATEWB_ObjectRemoved,D0
                    BSR.S          UpdateWorkbench
.notdeleted         MOVEA.L        A2,A1                    ; name.info memblock
                    MOVEA.L        $26(A5),A6               ; execbase
                    JSR            _LVOFreeVec(A6)
                    MOVEQ          #1,D0                    ; no error yet
                    MOVE.L         D7,D1                    ; error code
                    BEQ.S          .done
.error              MOVEA.L        $2A(A5),A6               ; dosbase
                    JSR            _LVOSetIoErr(A6)
                    MOVEQ          #0,D0                    ; error = FALSE
.done               MOVEM.L        (SP)+,D2-D3/D7/A2-A3/A5-A6
                    RTS

;------------------------------------------------------------------

UpdateWorkbench     MOVEM.L        D2-D4/A3-A6,-(SP)
                    MOVE.L         D0,D4                    ; action add or remove
                    MOVEA.L        A1,A4                    ; file name
                    BSR.W          allocnamecat_info
                    MOVE.L         D0,D1                    ; name.info memblock
                    BEQ.S          .allocnamefailed
                    MOVEA.L        D0,A3
                    MOVEA.L        $2A(A5),A6               ; dosbase
                    JSR            _LVOPathPart(A6)
                    MOVEA.L        D0,A0                    ; end of path + 1
                    CLR.B          (A0)                     ; terminate path part
                    MOVE.L         A3,D1                    ; root:path only now
                    MOVEQ          #ACCESS_READ,D2
                    JSR            _LVOLock(A6)
                    MOVE.L         D0,D2                    ; path lock
                    MOVEQ          #$A,D0                   ; open workbench
                    MOVEA.L        $26(A5),A6               ; execbase
                    JSR            _LVOPrivateOpenLibrary(A6)
                    MOVE.L         D0,D3                    ; workbenchbase ?
                    BEQ.S          .noworkbenchbase
                    MOVE.L         A4,D1                    ; file name
                    MOVEA.L        $2A(A5),A6               ; dosbase
                    JSR            _LVOFilePart(A6)
                    MOVEA.L        D0,A0                    ; name file part
                    MOVE.L         D4,D0                    ; action add or remove
                    MOVEA.L        D2,A1                    ; parent lock
                    MOVEA.L        D3,A6                    ; wbbase
                    JSR            _LVOUpdateWorkbench(A6)
                    MOVEA.L        D3,A1                    ; wbbase
                    MOVEA.L        $26(A5),A6               ; execbase
                    JSR            _LVOCloseLibrary(A6)
.noworkbenchbase    MOVE.L         D2,D1                    ; parent lock
                    MOVEA.L        $2A(A5),A6               ; dosbase
                    JSR            _LVOUnLock(A6)
                    MOVEA.L        A3,A1                    ; name.info memblock
                    MOVEA.L        $26(A5),A6               ; execbase
                    JSR            _LVOFreeVec(A6)
.allocnamefailed    MOVEM.L        (SP)+,D2-D4/A3-A6
                    RTS

;------------------------------------------------------------------

                    CNOP           0,4

; GetIconTagList -- Retrieve an icon (V44)
; icon = GetIconTagList(name,tags);
; D0                    A0   A1
; struct DiskObject * GetIconTagList(STRPTR name,struct TagItem *tags);

V44DO               set            $260                     ; for readDiskObject()

GetIconTagList      MOVEQ          #1,D0                    ; $290 parameter stack
                    MOVE.L         D0,-(SP)                 ; $28C screen flag, Fail
                    MOVE.L         D0,-(SP)                 ; $288 deficon,   Masks
                    MOVE.L         D0,-(SP)                 ; $284 NoNewIcon, ReMap
                    CLR.L          -(SP)                    ; $280 this task
                    CLR.L          -(SP)                    ; $27C pr_WindowPtr
                    CLR.L          -(SP)                    ; $278 *error code
                    CLR.L          -(SP)                    ; $274 modified taglist
                    CLR.L          -(SP)                    ; $270 DefaultIconState
                    CLR.L          -(SP)                    ; $26C file lock
                    CLR.L          -(SP)                    ; $268 filehandle
                    CLR.L          -(SP)                    ; $264 supplied screen
                    CLR.L          -(SP)                    ; $260 * DiskObject
                    MOVE.W         $C8(A6),-(SP)            ; $25E PalMaps wanted
                                                            ; $15C-$25B name string
                                                            ; $138-$15B GlobIdHook
                                                            ; $134 fib_Protection
                                                            ; $30=$2D-$133 FileInfo
                    LEA            -$232(SP),SP             ; $2C-$25D
 ifd IDtype
                    CLR.B          (SP)                     ; $2C IDBuffer flags
 endif
                    MOVEM.L        D2-D6/A0-A3/A5-A6,-(SP)
                    SUBA.L         A3,A3                    ; clear (def_)name
                    MOVEA.L        A6,A5                    ; iconbase
                    MOVEQ          #$32,D3
                    NOT.B          D3                       ; 205 object not found
                    MOVEQ          #0,D4                    ; parentdir
                    MOVEQ          #0,D5                    ; return code
                    MOVEQ          #-1,D6                   ; default type = -1
                    BRA.S          GITL_ReadTagList
 ifd IDtype
IdentifyBuffer      MOVE.L         A0,D1                    ; IdentifyBuffer ?
                    BEQ.S          GITL_NextTag
                    CLR.B          (A0)                     ; initialize buffer
                    BSET.B         #7,$2C(SP)               ; flag to get IDtype
                    BRA.S          GITL_NextTag

IdentifyIcon        MOVEQ          #46,D1
                    SUB.L          D1,D0
                    BEQ.S          IdentifyBuffer           ; (ICONA_Dummy+122)
                    SUBQ.L         #1,D0
                    BNE.S          GITL_NextTag
                    MOVE.L         A0,D1                    ; (ICONA_Dummy+123)
                    BEQ.S          GITL_NextTag
                    ADDQ.B         #1,$2C(SP)               ; flag IdentifyOnly
                    BRA.S          GITL_NextTag
 endif
RemapIcon           MOVE.W         A0,$286(SP)              ; BOOL no RLEjit if 0
                    BRA.S          GITL_NextTag

Screen              MOVE.L         A0,$264(SP)              ; struct screen
                    ADDQ.W         #1,$28C(SP)              ; screen supplied
                    BRA.S          GITL_NextTag

GITL_Skip           SUBQ.L         #1,D0
                    BNE.S          GITL_TagItem
                    MOVE.L         (A1),D0
                    LSL.L          #3,D0
                    ADDA.L         D0,A1
GITL_Ignore         ADDQ.W         #4,A1
GITL_NextTag        MOVE.L         (A1)+,D0
                    BMI.S          GITL_TagItem
                    BEQ.S          GITL_TagDone
                    SUBQ.L         #2,D0
                    BCS.S          GITL_Ignore
                    BNE.S          GITL_Skip
                    MOVEA.L        (A1),A1                  ; this is TagMore
GITL_ReadTagList    MOVE.L         A1,D0
                    BMI.S          enableGetIconTags        ; special case -1
GITL_TagDone        BEQ.S          GITL_TagsDone
                    BRA.S          GITL_NextTag

GITL_TagItem        MOVEA.L        A1,A0
                    MOVE.L         -(A0),D0                 ; TagItem
                    MOVEA.L        (A1)+,A0                 ; TagData
                    SUBI.L         #ICONA_Dummy+1,D0        ; Item-(ICONA_Dummy+1)
                    BEQ.S          GITL_ErrorCode
                    MOVEQ          #$2C,D1
                    SUB.L          D1,D0
                    BCS.S          GITL_NextTag
                    BEQ.S          GetDefaultType           ; (ICONA_Dummy+45)
                    SUBQ.L         #2,D0
                    BCS.S          GetDefaultName
                    BEQ.S          FailIfUnavailable        ; (ICONA_Dummy+47)
                    SUBQ.L         #2,D0
                    BCS.S          GetPaletteMappedIcon
                    BEQ.S          GITL_IsDefaultIcon       ; (ICONA_Dummy+49)
                    SUBQ.L         #2,D0
                    BCS.S          RemapIcon
                    BEQ.S          GenerateImageMasks       ; (ICONA_Dummy+51)
                    MOVEQ          #18,D1                   ; Label not supported
                    SUB.L          D1,D0
                    BEQ.S          Screen                   ; (ICONA_Dummy+69)
                    SUBQ.L         #7,D0
 ifd IDtype
                    BNE.S          IdentifyIcon
 else
                    BNE.S          GITL_NextTag
 endif
NoNewIcons          MOVE.W         A0,$284(SP)              ; (ICONA_Dummy+76)
                    BRA.S          GITL_NextTag

GITL_ErrorCode      MOVE.L         A0,$278(SP)              ; * error code
                    BRA.S          GITL_NextTag

GetDefaultType      MOVE.L         A0,D6                    ; DiskObject type
                    BRA.S          GITL_NextTag

GetDefaultName      MOVEA.L        A0,A3                    ; (def_)name
                    BRA.S          GITL_NextTag

FailIfUnavailable   MOVE.W         A0,$28E(SP)              ; BOOL
                    BRA.S          GITL_NextTag

GetPaletteMappedIcon MOVE.W        A0,$25E(SP)              ; BOOL
 ifd RLEjit
                    BNE.S          GITL_NextTag
                    CLR.W          $286(SP)                 ; no Remap, no RLEjit
 endif
                    BRA.S          GITL_NextTag

GITL_IsDefaultIcon  MOVE.L         A0,$270(SP)              ; DefaultIconStatus
                    BEQ.S          GITL_NextTag
                    CLR.L          (A0)                     ; DefaultIcon = FALSE
                    BRA.S          GITL_NextTag

GenerateImageMasks  MOVE.W         A0,$28A(SP)              ; BOOL
                    BRA.S          GITL_NextTag

; WBDISK=1, WBDRAWER=2, WBTOOL=3, WBPROJECT=4, WBGARBAGE=5, WBDEVICE=6, WBKICK=7

enableGetIconTags   CLR.B          $28A+1(SP)               ; want no image masks
                    CLR.B          $28C+1(SP)               ; dont fail now
GITL_TagsDone       MOVEA.L        $26(A5),A6               ; execbase
                    MOVEA.L        ThisTask(A6),A0
                    MOVE.L         pr_WindowPtr(A0),$27C(SP)
                    MOVE.L         A0,$280(SP)              ; this task
                    TST.L          $974(A5)                 ; Workbench task set ?
                    BNE.S          .workbenchtaskfound
                    MOVEA.L        $A(A0),A1
                    CMP.L          #"Work",(A1)+
                    BNE.S          .checkworkbenchdone
                    CMP.L          #"benc",(A1)+
                    BNE.S          .checkworkbenchdone
                    CMP.W          #$6800,(A1)
                    BNE.S          .checkworkbenchdone
                    MOVE.L         A0,$974(A5)              ; store Workbench task
     ifd WB47fix
                    MOVEQ          #$A,D0                   ; workbench tag
                    JSR            _LVOPrivateOpenLibrary(A6)
                    TST.L          D0
                    BEQ.S          .checkworkbenchdone
                    MOVEA.L        D0,A1                    ; wbbase
                    CMPI.W         #47,LIB_VERSION(A1)
                    BCS.S          .closeworkbenchlib
                    BSET.B         #5,$F1(A5)               ; fix UpdateWB v47+
.closeworkbenchlib  JSR            _LVOCloseLibrary(A6)
     endif
.checkworkbenchdone
.workbenchtaskfound MOVE.L         D6,D0                    ; default type ?
                    BPL.S          getdeficonbytype
                    MOVE.L         A3,D0                    ; (def_)name ?
                    BNE.S          getdeficonbyname
                    BRA.W          geticonfromfile

GITL_wrongtype      MOVEQ          #$6A,D5
                    ADD.L          D5,D5                    ; error 212
                    BRA.W          GITL_exit

getdeficonbytype    BEQ.S          GITL_wrongtype           ; type = 0
                    SUBQ.L         #WBKICK,D0
                    BHI.S          GITL_wrongtype           ; type > 7
                    ADDQ.L         #(WBKICK-WBDISK),D0
                    BNE.S          getdeficonbyname
getdef_disk_info    MOVEA.L        $2A(A5),A6               ; dosbase
                    MOVEQ          #0,D1                    ; new tmp dir = sys:
                    JSR            _LVOCurrentDir(A6)
                    MOVE.L         D0,-(SP)                 ; save old dir lock
                    MOVE.L         D0,D1
                    JSR            _LVOCurrentDir(A6)
                    LEA            string_Ram.(PC),A0       ; "Ram:",0
                    MOVE.L         A0,D1
                    MOVEQ          #ACCESS_READ,D2
                    JSR            _LVOLock(A6)
                    MOVE.L         (SP)+,D1                 ; current dir lock
                    MOVE.L         D0,D2                    ; lock on Ram:
                    JSR            _LVOSameLock(A6)
                    MOVE.L         D2,D1                    ; unlock Ram:
                    MOVE.L         D0,D2
                    JSR            _LVOUnLock(A6)
                    TST.L          D2                       ; current dir = Ram: ?
                    BNE.S          getdeficonbyname
.foundtheRamDisk    LEA            string_RAM(PC),A3        ; "RAM",0
getdeficonbyname    MOVEQ          #-1,D0
                    MOVEA.L        $280(SP),A0              ; this task
                    MOVE.L         D0,pr_WindowPtr(A0)      ; no error requester
                    LEA            $15C(SP),A0              ; name string buffer
                    LEA            ENV_sys_def_(PC),A1
.copypath           MOVE.B         (A1)+,(A0)+              ; copy "ENV:sys/def_"
                    BNE.S          .copypath
                    SUBQ.W         #1,A0
                    MOVEA.L        A3,A1
                    MOVE.L         A3,D0                    ; (def_)name ?
                    BNE.S          .catname
.namebytype         LEA            DiskObjectNames(PC),A1
 ifd MC68020
                    ADDA.W         -2(A1,D6.L*2),A1         ; get name by type
 else
                    MOVE.W         D6,D0
                    ADD.W          D0,D0
                    ADDA.W         -2(A1,D0.W),A1
 endif
.catname            MOVEQ          #106,D0                  ; max 12 + 107 + $0
.copyname           MOVE.B         (A1)+,(A0)+
                    BEQ.S          .catdone
                    DBRA           D0,.copyname
                    CLR.B          (A0)
.catdone            LEA            $15C(SP),A1              ; * name string
                    BSR.W          readDiskObject
                    MOVE.L         D0,D5                    ; error code
                    MOVEA.L        $260(SP),A0              ; the new DiskObject
                    TST.L          D6                       ; default type ?
                    BMI.S          .nodefaulttype
                    MOVE.L         A0,D0
                    BNE.S          .forceicontype
                    MOVE.L         A3,D0                    ; (def_)name
                    BEQ.S          .tryinternalicons
                    SUBA.L         A3,A3                    ; no (def_)name found
                    LEA            $15C+12(SP),A0           ; string buffer + 12
                    BRA.S          .namebytype

.tryinternalicons   TST.L          D6                       ; default type ?
                    BMI.S          .objectnotfound
                    LEA            DiskObjectTypes(PC),A0
 ifd MC68020
                    ADDA.W         -2(A0,D6.L*2),A0
 else
                    MOVE.W         D6,D0
                    ADD.W          D0,D0
                    ADDA.W         -2(A0,D0.W),A0
 endif
                    LEA            $260(SP),A1              ; * struct DiskObject
                    MOVEQ          #$3F,D0                  ; set flags, copy all
                    BSR.W          copyStructDO
                    MOVE.L         D0,D5                    ; result
                    BNE.W          GITL_exit
                    MOVEA.L        $260(SP),A0              ; DiskObject
 ifd DTtype
                    MOVE.B         D6,do_PAD_BYTE(A0)       ; a default type icon
 endif
.nodefaulttype      MOVE.L         A0,D0
 ifd MC68020
                    BNE.W          .useiconimages
 else
                    BNE.S          .useiconimages
 endif
.objectnotfound     MOVE.L         D3,D5                    ; 205 object not found
                    BRA.W          GITL_exit

.forceicontype
 ifd MC68020
                    MOVE.B         do_Type(A0),D0           ; save old icon type
 endif
                    MOVE.B         D6,do_Type(A0)
 ifd DTtype
                    MOVE.B         D6,do_PAD_BYTE(A0)       ; a default type icon
 endif
                    SUBQ.B         #WBDISK,D6
 ifd MC68020
                    BNE.S          .testdrawerdata
                    SUBQ.B         #WBDISK,D0               ; was old type disk ?
                    BEQ.S          .testdrawerdata          ; keep old disk images
                    TST.L          $76(A0)                  ; does PalMap1 exist ?
                    BEQ.S          .testdrawerdata
                    LEA            do_Gadget+gg_Flags(A0),A1
                    LEA            do_Gadget+gg_Flags+DiskObject_disk(PC),A0
                    MOVEQ          #14,D0
                    BSR.W          CopyMemAligned
                    MOVEA.L        $260(SP),A0              ; DiskObject
                    BTST.B         #1,$C3(A5)               ; is ChipMem used ?
                    BEQ.S          .copy2extension
                    LEA            $154(A5),A1              ; struct dot image
                    MOVE.L         A1,do_Gadget+gg_GadgetRender(A0)
                    MOVE.W         #4,do_Gadget+gg_Flags(A0); flags = invert Dot
.copy2extension     MOVE.L         $16(A0),$6E(A0)          ; copy GadgetRender
                    MOVE.L         $1A(A0),$72(A0)          ; copy SelectRender
                    MOVEQ          #3,D0                    ; filter bit 0,1
                    AND.B          $10+1(A0),D0             ; get Gadget flags
                    MOVE.B         D0,$8B(A0)               ; set OS 3.5 flags
 endif
.testdrawerdata     TST.L          do_DrawerData(A0)
                    BNE.S          .useiconimages
                    SUBQ.B         #1,D6
                    BLS.S          .allocdrawerdata         ; WBDISK or WBDRAWER
                    SUBQ.B         #3,D6                    ; WBTRASHCAN ?
                    BNE.S          .useiconimages
.allocdrawerdata    MOVEM.L        A0/A2,-(SP)
                    ADDA.W         #$4E,A0                  ; freelist
                    MOVEA.W        #$3E,A1                  ; size of DrawerData
                    MOVEA.W        #MEMF_PUBLIC,A2
                    BSR.W          FreeAlloc                ; needs no iconbase
                    MOVEM.L        (SP)+,A0/A2
                    LEA            DefDrawerData(PC),A1
                    MOVE.L         D0,do_DrawerData(A0)     ; new struct drawer
                    BEQ.S          .assigndefdata           ; no free memory
                    MOVEA.L        A1,A0
                    MOVEA.L        D0,A1
                    MOVEQ          #$3E,D0                  ; size of DrawerData
                    BSR.W          CopyMemAligned  
                    MOVEA.L        $260(SP),A0              ; DiskObject
                    BRA.S          .useiconimages

.assigndefdata      MOVE.L         A1,do_DrawerData(A0)     ; use internal data
.useiconimages      MOVE.L         A3,D0                    ; valid (def_)name ?
                    BEQ.S          .clearposition
 ifd MC68020
                    MOVE.L         (A3),D0
 else
                    MOVEA.L        A3,A1                    ; *(def_)name
                    MoveOddLong    A1,D0
 endif
                    OR.L           lowercase3bytes(PC),D0
                    CMPI.L         #$72616D00,D0            ; is it "ram",0 ?
                    BEQ.S          .ramdiskfound
 ifd DTtype
                    ORI.B          #$20,D0
                    CMPI.L         #"proj",D0
                    BNE.S          .clearposition
     ifd MC68020
                    MOVE.L         4(A3),D0
     else
                    MoveOddLong    A1,D0
     endif
                    OR.L           lowercase3bytes(PC),D0
                    CMPI.L         #$65637400,D0            ; def_project.info ?
                    BNE.S          .clearposition
                    MOVE.B         #WBPROJECT,do_PAD_BYTE(A0)
 endif
.clearposition      MOVEQ          #1,D0
                    ROR.L          #1,D0                    ; NO_ICON_POSITION
                    MOVE.L         D0,do_CurrentX(A0)
                    MOVE.L         D0,do_CurrentY(A0)
                    MOVE.L         $280(SP),D0              ; this task
                    CMP.L          $974(A5),D0              ; Workbench task ?
                    BNE.S          .ramdiskfound            ; not ghosted for JAM
                    BSET.B         #2,$8A(A0)               ; make a ghosted icon
.ramdiskfound       ADDQ.B         #1,$288(SP)              ; set deficon flag
                    MOVE.L         $270(SP),D0              ; DefaultIconState ?
                    BEQ.S          .defaultdone
                    MOVEA.L        D0,A0
                    ADDQ.L         #1,(A0)                  ; DefaultIcon = TRUE
.defaultdone        BRA.W          geticonfromfile\.processimages

                    ;---------------------------------------

geticonfromfile     MOVEA.L        $14(SP),A3               ; file name
                    MOVE.L         A3,D0
 ifd MC68020
                    BNE.S          .checkDOpus5
                    MOVEQ          #$74,D5                  ; argument missing
                    BRA.W          GITL_exit

.checkDOpus5        MOVE.L         $280(SP),D0              ; this task
                    CMP.L          $96C(A5),D0              ; DOpus5 main task ?
                    BNE.S          .readfile
                    MOVEA.L        A3,A0                    ; file name
                    MOVE.L         lowercasefilter(PC),D0
                    MOVE.L         (A0)+,D1
                    OR.L           D0,D1
                    SUBI.L         #"env:",D1
                    OR.L           (A0)+,D1         
                    OR.L           D0,D1
                    SUBI.L         #"sys/",D1
                    OR.L           (A0)+,D1         
                    OR.L           D0,D1
                    SUBI.L         #$6465667F,D1            ; def_
                    OR.L           (A0),D1         
                    OR.L           D0,D1
                    SUBI.L         #"disk",D1               ; env:sys/def_disk ?
                    BNE.S          .readfile
                    MOVEQ          #WBDISK,D6
                    SUBA.L         A3,A3                    ; no (def_)name
                    CLR.B          $EC(A5)                  ; no disk.info flag
                    BRA.W          getdef_disk_info
 else
                    BNE.S          .readfile
                    MOVEQ          #$74,D5                  ; argument missing
                    BRA.W          GITL_exit
 endif
.readfile           TST.B          $ED(A5)                  ; is this Aros ?
                    BEQ.S          .readicon
                    MOVEA.L        A3,A0                    ; file name
                    LEA            $15C(SP),A1              ; file name buffer
                    MOVEQ          #125,D0
                    ADD.L          D0,D0                    ; max 251 chars + $0
.copyArosname       MOVE.B         (A0)+,(A1)+
                    DBEQ           D0,.copyArosname
                    BEQ.S          .copynamedone
                    CLR.B          (A1)+                    ; terminate string
.copynamedone       SUBQ.W         #2,A1
                    CMPI.B         #":",(A1)+               ; root name only ?
                    BNE.S          .readicon
 ifd MC68020
                    MOVE.L         #"disk",(A1)+            ; fix bad Aros bugs
 else
                    MOVE.B         #"d",(A1)+
                    MOVE.B         #"i",(A1)+
                    MOVE.B         #"s",(A1)+
                    MOVE.B         #"k",(A1)+
 endif
                    CLR.B          (A1)
                    LEA            $15C(SP),A3              ; file name buffer
.readicon
                    MOVEA.L        $2A(A5),A6               ; dosbase
 ifd IDtype
                    MOVE.B         $2C(SP),D0               ; IdentifyBuffer ?
                    BPL.S          .readiconnow
                    ADD.B          D0,D0                    ; IdentifyOnly ?
     ifd MC68020
                    BNE.W          .dontfailnow
     else
                    BNE.S          .dontfailnow
     endif
 endif
.readiconnow        MOVEA.L        A3,A1                    ; file name
                    BSR.W          readDiskObject
                    MOVE.L         D0,D5                    ; error code
 ifd MC68020
                    MOVEA.L        $280(SP),A0              ; this task
                    CMPA.L         $96C(A5),A0              ; DOpus5 main task ?
                    BEQ.S          .checkforerrors
                    MOVEA.L        $A(A0),A0                ; the task name
                    CMPI.L         #"s_li",4(A0)            ; "dopus_lister" ?
                    BEQ.S          .testfordiskinfo
                    BRA.W          .testoferrorcode

.checkforerrors     TST.L          D5                       ; any error code ?
                    BNE.S          .testfordiskinfo
                    TST.B          $EC(A5)                  ; disk.info flag ?
                    BEQ.W          .processimages
                    CLR.B          $EC(A5)
                    MOVEA.L        $260(SP),A0              ; DiskObject
                    MOVE.B         #WBDISK,do_Type(A0)      ; force WBDISK DOpus5
                    TST.L          do_DrawerData(A0)
                    BNE.W          .processimages
                    MOVEM.L        A0/A2,-(SP)
                    ADDA.W         #$4E,A0                  ; freelist
                    MOVEA.W        #$3E,A1                  ; size of DrawerData
                    MOVEA.W        #MEMF_PUBLIC,A2
                    BSR.W          FreeAlloc                ; needs no iconbase
                    MOVEM.L        (SP)+,A0/A2
                    PEA            .processimages(PC)
                    LEA            DefDrawerData(PC),A1
                    MOVE.L         D0,do_DrawerData(A0)     ; new struct drawer
                    BEQ.S          .assigndefdrawer         ; no free memory
                    MOVEA.L        A1,A0
                    MOVEA.L        D0,A1
                    MOVEQ          #$3E,D0                  ; size of DrawerData
                    BRA.W          CopyMemAligned           ; RTS .processimages  

.assigndefdrawer    MOVE.L         A1,do_DrawerData(A0)     ; use internal data
                    RTS

.testfordiskinfo    CMP.L          D3,D5                    ; object not found ?
                    BNE.S          .setdiskinfoflag
                    MOVEM.L        (A3),D0-D1               ; 8 chars of filename
                    OR.L           lowercase3bytes(PC),D0
                    CMP.L          longwordforram.(PC),D0   ; "ram:" ?
                    BEQ.S          .dontfailnow
                    CMP.L          longwordforram_(PC),D0   ; "ram " ?
                    BNE.S          .testfordiskonly
                    OR.L           lowercasefilter(PC),D1
                    CMP.L          longwordfordisk(PC),D1   ; "ram disk" ?
                    BEQ.S          .dontfailnow
.testfordiskonly    CMPI.L         #"s_li",(A0)             ; "dopus_lister" ?
                    BEQ.S          .testoferrorcode         ; no disappearing icon
                    ORI.B          #$20,D0
                    CMP.L          longwordfordisk(PC),D0   ; "disk" ?
.setdiskinfoflag    SEQ            $EC(A5)                  ; disk flag for DOpus5                    
.testoferrorcode    TST.L          D5                       ; any error code ?
 endif
                    BNE.S          .checkwrongtype
 ifd IDtype
                    TST.B          $2C(SP)                  ; IdentifyBuffer ?
                    BMI.S          .dontfailnow
                    BRA.W          .processimages
 else
                    BEQ.W          .processimages
 endif
.checkwrongtype     MOVEQ          #$6A,D0
                    ADD.L          D0,D0
                    CMP.L          D0,D5                    ; object wrong type ?
                    BNE.S          .othericonerror
                    MOVE.L         A3,D1                    ; filename
                    JSR            _LVOFilePart(A6)
                    MOVEA.L        D0,A0
.countchars         TST.B          (A0)+
                    BNE.S          .countchars
                    SUBQ.W         #1,A0
                    SUBA.L         D0,A0                    ; file part length
                    CMPA.W         $CA(A5),A0               ; GlobalMaxNameLength
                    BLS.S          .is_it_a_disk
                    MOVE.L         D3,D5
                    BRA.S          .objectnotfound

.is_it_a_disk       MOVEA.L        D0,A0                    ; Disk(.info) ?
 ifd MC68020
                    MOVE.L         (A0),D0
 else
                    MoveOddLong    A0,D0
 endif
                    OR.L           lowercasefilter(PC),D0
                    CMP.L          longwordfordisk(PC),D0
                    BEQ.S          .dontfailnow
                    TST.W          $28E(SP)                 ; FailIfUnavailable ?
                    BEQ.S          .dontfailnow             ; SYS: may show def_disk
.othericonerror     CMP.L          D3,D5                    ; object not found ?
                    BNE.W          GITL_exit
.objectnotfound
 ifd IDtype
                    TST.B          $2C(SP)                  ; IdentifyBuffer ?
                    BMI.S          .dontfailnow
 endif
                    TST.W          $28E(SP)                 ; FailIfUnavailable ?
                    BNE.W          GITL_exit
.dontfailnow        MOVE.L         A3,D1                    ; file name
                    MOVEQ          #-2,D2                   ; SHARED_LOCK READ
                    JSR            _LVOLock(A6)
                    MOVE.L         D0,D6                    ; BCPL file lock
                    MOVE.L         D0,$26C(SP)              ; store lock
 ifd MC68020
                    BNE.S          .filelocked
 else
                    BNE.W          .filelocked
 endif
 ifd IDtype
                    MOVE.B         $2C(SP),D0               ; IdentifyBuffer ?
                    BPL.S          .nofilelock
.identifyerror      MOVE.L         D3,D5                    ; object not found
                    TST.L          $260(SP)                 ; DiskObject ?
                    BEQ.W          GITL_exit                ; no type, no icon
                    ADD.B          D0,D0                    ; identify only ?
                    BNE.W          GITL_exit                ; no type, drop icon
                    MOVEQ          #0,D5                    ; clear error code
                    BRA.W          .processimages           ; no type, use icon 
 endif
.nofilelock         JSR            _LVOIoErr(A6)
                    MOVE.L         D0,D5                    ; error code
                    CMP.L          D3,D5                    ; object not found ?
                    BNE.W          GITL_exit
                    MOVE.L         A3,D1                    ; file name
                    JSR            _LVOFilePart(A6)
                    MOVEA.L        D0,A0                    ; Disk(.info) ?
 ifd MC68020
                    MOVE.L         (A0),D0
 else
                    MoveOddLong    A0,D0
 endif
                    OR.L           lowercasefilter(PC),D0
                    CMP.L          longwordfordisk(PC),D0
                    BNE.W          GITL_exit
                    LEA            $15C(SP),A2              ; file name buffer
                    MOVEA.L        A2,A1
                    MOVEA.L        A3,A0                    ; file name
                    MOVEQ          #127,D0
                    ADD.L          D0,D0                    ; max 255 chars + $0
.copyname           MOVE.B         (A0)+,(A1)+
                    DBEQ           D0,.copyname
                    BEQ.S          .copydone
                    CLR.B          (A1)
.copydone           MOVE.L         A2,D1                    ; file name buffer
                    JSR            _LVOPathPart(A6)
                    MOVEA.L        D0,A0                    ; end of path + 1
                    CLR.B          (A0)                     ; cut off Disk(.info)
                    MOVE.L         A2,D1                    ; path only  (DF0:)
                    JSR            _LVOLock(A6)
                    MOVE.L         D0,D6                    ; BCPL file lock
                    MOVE.L         D0,$26C(SP)              ; store lock
                    BNE.S          .filelocked
                    JSR            _LVOIoErr(A6)
                    MOVE.L         D0,D5                    ; error code
                    BRA.W          GITL_exit

.filelocked         LEA            $30(SP),A0
                    MOVE.L         A0,D0
                    ANDI.B         #$FC,D0                  ; align stack address
                    MOVEA.L        D0,A2                    ; size=$104, $2D-$133
                    MOVE.L         D6,D1                    ; file lock
                    MOVE.L         A2,D2                    ; FileInfoBlock
                    JSR            _LVOExamine(A6)
                    TST.L          D0
                    BNE.S          .storefileinfo
 ifd IDtype
                    MOVE.B         $2C(SP),D0               ; IdentifyBuffer ?
                    BMI.W          .identifyerror
 endif
                    JSR            _LVOIoErr(A6)
                    MOVE.L         D0,D5                    ; io error
                    BRA.W          GITL_exit

.storefileinfo      MOVE.L         fib_DirEntryType(A2),D3
                    MOVE.L         fib_Protection(A2),$134(SP)
                    MOVEA.L        $18(SP),A0               ; taglist
                    MOVEA.L        $2E(A5),A6               ; utilbase
 ifd IDtype
                    TST.L          $260(SP)                 ; DiskObject ?
                    BEQ.S          .clonetagitems
                    MOVE.L         A0,-(SP)                 ; original taglist
                    PEA            TAG_MORE.w
                    PEA            1.w                      ; real icon exists
                    PEA            ICONGETA_IdentifyOnly
                    MOVEA.L        SP,A0                    ; extended taglist
                    JSR            _LVOCloneTagItems(A6)
                    ADDA.W         #$10,SP
                    BRA.S          .taglistcloned
 endif
.clonetagitems      JSR            _LVOCloneTagItems(A6)
.taglistcloned      MOVEA.L        D0,A0
                    MOVE.L         D0,$274(SP)              ; cloned taglist
 ifd IDtype
                    BNE.S          .nodontfailtag
.checkIDbuffer      MOVE.B         $2C(SP),D0               ; IdentifyBuffer ?
                    BMI.W          .identifyerror
                    BRA.W          .noDiskObject
 else
                    BEQ.W          .noDiskObject
 endif
.nodontfailtag      LEA            DontFail_Tags(PC),A1     ; filter array
                    MOVEQ          #TAGFILTER_NOT,D0        ; exclude all hits
                    JSR            _LVOFilterTagItems(A6)
                    MOVEA.L        $2A(A5),A6               ; dosbase
                    TST.L          D3                       ; fib_DirEntryType
                    BPL.S          .callidentifyhook        ; >0 drawer, <0 file
                    MOVE.L         A3,D1                    ; file name
                    MOVE.L         #MODE_OLDFILE,D2         ; open existing R/W
                    JSR            _LVOOpen(A6)
                    MOVE.L         D0,$268(SP)              ; BCPL filehandle
 ifd IDtype
                    BEQ.S          .checkIDbuffer
 else
                    BEQ.W          .noDiskObject
 endif
.callidentifyhook   MOVE.L         D6,D1                    ; BCPL file lock
                    JSR            _LVOParentDir(A6)
                    MOVE.L         D0,D4
                    BSET.B         #2,$F1(A5)               ; hook protection
                    BEQ.S          .checkthehook
                    BSR.W          bitlockdelay

.checkthehook       MOVE.L         $D8(A5),D0               ; GlobalIdentifyHook
                    BEQ.S          .releasehook             ; DefIcons or Eastern
 ifd IDtype
                    TST.B          $2C(SP)                  ; IdentifyBuffer ?
                    BPL.S          .callthehook
                    MOVE.L         $114(A5),D2              ; DefIcons hook ?
                    BEQ.S          .callthehook
                    MOVE.L         D2,D0                    ; don't use Eastern
 endif
.callthehook        LEA            $138(SP),A1              ; parameter packet
                    MOVEA.L        A1,A0
                    MOVE.L         $26(A5),(A0)+            ; execbase
                    MOVE.L         $2A(A5),(A0)+            ; dosbase
                    MOVEA.L        $2E(A5),A6               ; utilbase
                    MOVE.L         A6,(A0)+
                    MOVE.L         A5,(A0)+                 ; iconbase
                    MOVE.L         D6,(A0)+                 ; BCPL file lock
                    MOVE.L         D4,(A0)+                 ; parentdir lock
                    MOVE.L         A2,(A0)+                 ; FileInfoBlock
                    MOVE.L         $268(SP),(A0)+           ; BCPL filehandle
                    MOVE.L         $274(SP),(A0)            ; filtered taglist
                    MOVEA.L        D0,A0                    ; GlobalIdentifyHook
                    SUBA.L         A2,A2                    ; hook object = NULL
                    JSR            _LVOCallHookPkt(A6)      ; autodocs IconControlA
.releasehook        SUBQ.B         #4,$F1(A5)               ; clear hook protection
                    MOVEA.L        A5,A6                    ; iconbase
 ifd IDtype
                    MOVE.B         $2C(SP),D2               ; flags for IDtype
                    BPL.S          .savediskobject          ; has no IdentifyBuffer
                    MOVEQ          #0,D5                    ; return no error = 0
                    TST.L          $260(SP)                 ; stored DiskObject ?
                    BEQ.S          .noiconsavedyet
                    MOVEA.L        D0,A0                    ; deficon from hook
                    JSR            _LVOFreeDiskObject(A6)
                    ADD.B          D2,D2                    ; identify only ?
                    BEQ.W          .processimages
                    MOVEA.L        $260(SP),A0              ; real icon from file
                    CLR.L          $260(SP)                 ; remove stored icon
                    BRA.S          .freediskobject

.noiconsavedyet     ADD.B          D2,D2                    ; identify only ?
                    BEQ.S          .savediskobject
                    MOVEA.L        D0,A0                    ; deficon from hook
.freediskobject     JSR            _LVOFreeDiskObject(A6)   ; identify type only
                    BRA.W          GITL_exit
 endif
;                   Types for fib_DirEntryType.  NOTE that both USERDIR and ROOT are
;                   directories, and that directory/file checks should use <0 and >=0.
;                   This is not necessarily exhaustive!  Some handlers may use other
;                   values as needed, though <0 and >=0 should remain as supported as
;                   possible.
;                   ST_ROOT        EQU  1
;                   ST_USERDIR     EQU  2
;                   ST_SOFTLINK    EQU  3   ; looks like dir, but may point to a file!
;                   ST_LINKDIR     EQU  4   ; hard link to dir
;                   ST_FILE        EQU  -3  ; must be negative for FIB!
;                   ST_LINKFILE    EQU  -4  ; hard link to file
;                   ST_PIPEFILE    EQU  -5  ; for pipes that support ExamineFH

.savediskobject     MOVE.L         D0,$260(SP)              ; DiskObject from hook
                    MOVEA.L        D0,A0
                    MOVE.L         D0,D5                    ; icon was identified
 ifd DTtype
                    BEQ.S          .testdatatypes
                    CMPI.B         #WBPROJECT,do_PAD_BYTE(A0)
                    BNE.W          .analyzeicontype
.testdatatypes      MOVE.L         D3,D0                    ; fib_DirEntryType
                    BMI.S          .filedetected
                    SUBQ.L         #3,D0                    ; SoftLink ?
                    BNE.W          .datatypesdone
.filedetected       MOVE.L         $11C(A5),D0              ; dtbase ?
                    BNE.S          .datatypesopen
                    MOVEQ          #39,D0                   ; v39+
                    LEA            string_DatatypesLib(PC),A1
                    MOVEA.L        $26(A5),A6               ; execbase
                    JSR            _LVOOpenLibrary(A6)
                    MOVE.L         D0,$11C(A5)              ; save dtbase
                    BEQ.W          .datatypesdone
.datatypesopen      MOVEA.L        D0,A6                    ; dtbase
                    MOVEQ          #DTST_FILE,D0
                    MOVEA.L        D6,A0                    ; file lock
                    SUBA.L         A1,A1                    ; no taglist
                    JSR            _LVOObtainDataTypeA(A6)
                    TST.L          D0
                    BEQ.W          .datatypesdone
                    MOVEA.L        D0,A2                    ; save datatype
                    MOVE.L         dtn_Header(A2),D0
                    BEQ.W          .releasedttype
                    MOVEA.L        A5,A6                    ; iconbase            
                    MOVEA.L        D0,A0                    ; datatype header
                    MOVE.L         dth_GroupID(A0),D2       ; four characters
                    CMPI.L         #GID_SYSTEM,D2
                    BNE.S          .notexecutable
                    CMPI.L         #$65786500,dth_ID(A0)    ; ID = "exe",0 ?
                    BNE.S          .notexecutable
                    MOVEQ          #WBTOOL,D0
                    JSR            _LVOGetDefDiskObject(A6)
                    MOVE.L         D0,$260(SP)              ; def_tool.info
                    BRA.S          .releasedttype

.notexecutable      PEA            TAG_DONE.w
                    MOVE.L         (A0),-(SP)               ; dth_Name
                    PEA            ICONGETA_GetDefaultName
                    SUBA.L         A0,A0                    ; no icon name
                    MOVEA.L        SP,A1                    ; taglist
                    JSR            _LVOGetIconTagList(A6)
                    MOVE.L         D0,$C+$260(SP)
                    BNE.S          .tagsfromstack
                    LEA            (9*4)+datatypegroup(PC),A0
                    MOVEQ          #9-1,D0                  ; check 9 groups
.filetypegroup      CMP.L          -(A0),D2                 ; which GroupID ?
                    DBEQ           D0,.filetypegroup
                    BNE.S          .tagsfromstack
                    LEA            datatype2name(PC),A0
     ifd MC68020
                    ADDA.W         (A0,D0.L*2),A0
     else
                    ADD.B          D0,D0
                    ADDA.W         (A0,D0.W),A0
     endif
                    MOVE.L         A0,4(SP)                 ; datatype group 
                    SUBA.L         A0,A0                    ; no icon name
                    MOVEA.L        SP,A1                    ; taglist
                    JSR            _LVOGetIconTagList(A6)
                    MOVE.L         D0,$C+$260(SP)           ; group deficon
                    OR.L           D5,D0                    ; project deficon ?
                    BNE.S          .tagsfromstack
                    CMPI.L         #GID_SYSTEM,D2           ; GroupID="syst"?
                    BEQ.S          .tagsfromstack
                    MOVEQ          #WBPROJECT,D0            ; get project icon
                    JSR            _LVOGetDefDiskObject(A6)
                    MOVE.L         D0,$C+$260(SP)
.tagsfromstack      ADDA.W         #$C,SP
.releasedttype      MOVEA.L        A2,A0                    ; datatype
                    MOVEA.L        $11C(A5),A6              ; dtbase
                    JSR            _LVOReleaseDataType(A6)
                    MOVEA.L        $260(SP),A0
                    TST.L          D5                       ; project deficon ?
                    BNE.S          .deficonexists
                    MOVE.L         A0,D5                    ; DiskObject ?
                    BNE.S          .checksystemid
                    BRA.S          .noDiskObject

.deficonexists      MOVE.L         A0,D0                    ; datatype found ?
                    BEQ.S          .olddiskobject
                    MOVEA.L        D5,A0                    ; old project icon
                    MOVEA.L        A5,A6                    ; iconbase
                    JSR            _LVOFreeDiskObject(A6)
                    MOVEA.L        $260(SP),A0              ; datatypes icon
.checksystemid      CMPI.L         #GID_SYSTEM,D2           ; GroupID="syst"?
                    BEQ.S          .analyzeicontype
                    MOVE.B         #WBPROJECT,do_Type(A0)   ; force to project
                    BRA.W          .defaulticon             ; it's a data file

.datatypesdone      TST.L          D5                       ; project deficon ?
                    BEQ.S          .noDiskObject
                    BRA.S          .trytheproject

.olddiskobject      MOVE.L         D5,$260(SP)              ; restore deficon
.trytheproject      MOVEA.L        D5,A0
 else
                    BEQ.S          .noDiskObject
 endif
.analyzeicontype    LEA            $5E(A0),A1
                    CMPA.L         (A1),A1                  ; V44 selfpointer ?
                    BNE.S          .dataconflict
                    MOVE.B         do_Type(A0),D1
                    CMPI.B         #WBDISK,D1
                    BEQ.S          .DiskDrawerTrash
                    CMPI.B         #WBDRAWER,D1
                    BEQ.S          .DiskDrawerTrash
                    CMPI.B         #WBGARBAGE,D1
                    BNE.S          .ToolProjectDevKick
.DiskDrawerTrash    TST.L          D3                       ; fib_DirEntryType
                    BMI.S          .dataconflict
                    TST.L          D4                       ; parentdir ?
                    BEQ.S          .rootdir
                    SUBQ.B         #WBDISK,D1
                    BEQ.S          .dataconflict
                    BRA.W          .useDiskObject

.rootdir            SUBQ.B         #WBDISK,D1
                    BEQ.W          .useDiskObject
                    BRA.S          .dataconflict

.ToolProjectDevKick MOVE.L         D3,D1                    ; fib_DirEntryType
                    BMI.W          .useDiskObject
                    SUBQ.L         #3,D1                    ; SoftLink ?
                    BEQ.S          .useDiskObject
.dataconflict       MOVEA.L        D0,A0                    ; DiskObject
                    JSR            _LVOFreeDiskObject(A6)
                    CLR.L          $260(SP)                 ; remove DiskObject
.noDiskObject       MOVE.L         D3,D0                    ; fib_DirEntryType
                    BMI.S          .executabletest
                    SUBQ.L         #3,D0                    ; SoftLink ?
                    BEQ.S          .executabletest
                    MOVE.L         D6,D1                    ; BCPL file lock
                    MOVEQ          #WBDISK,D6
                    TST.L          D4                       ; parentdir ?
                    BNE.S          .drawer_or_project
                    MOVEA.L        $2A(A5),A6               ; dosbase
                    JSR            _LVOParentDir(A6)
                    MOVE.L         D0,D4                    ; parentdir lock
                    BNE.S          .drawer_or_project
                    BRA.S          .typeset

.executabletest     MOVEQ          #WBTOOL,D6
                    MOVE.L         $134(SP),D1              ; fib_Protection
                    BTST.L         #FIBB_SCRIPT,D1          ; script if bit set
                    BNE.S          .drawer_or_project
                    BTST.L         #FIBB_EXECUTE,D1         ; execute allowed if 0
                    BEQ.S          .typeset
.drawer_or_project  ADDQ.L         #1,D6
.typeset            MOVE.W         $25E(SP),D0              ; PalMaps wanted ?
                    EXT.L          D0
                    CLR.L          -(SP)                    ; TAGS_DONE
                    MOVE.L         D6,-(SP)                 ; type
                    PEA            ICONGETA_GetDefaultType
                    MOVE.L         D0,-(SP)
                    PEA            ICONGETA_GetPaletteMappedIcon
                    SUBA.L         A0,A0                    ; no name
                    MOVEA.L        SP,A1                    ; taglist
                    MOVEA.L        A5,A6                    ; iconbase
                    JSR            _LVOGetIconTagList(A6)
                    LEA            $14(SP),SP
                    MOVE.L         D0,$260(SP)              ; DiskObject
                    BNE.S          .defaulticon
                    MOVEA.L        $2A(A5),A6               ; dosbase
                    JSR            _LVOIoErr(A6)
                    MOVE.L         D0,D5                    ; error code
                    BRA.W          GITL_exit

.defaulticon        ADDQ.B         #1,$288(SP)              ; is a deficon
.useDiskObject      MOVE.L         $270(SP),D0              ; DefaultIconStatus ?
                    BEQ.S          .defaultdone
                    MOVEA.L        D0,A0
                    ADDQ.L         #1,(A0)                  ; DefaultIcon = TRUE
.defaultdone        MOVEA.L        $260(SP),A3              ; DiskObject
                    CMPI.B         #WBDISK,do_Type(A3)
                    BNE.W          .initdeficon
                    LEA            $15C(SP),A2              ; * filename buffer
                    MOVEM.L        (A2),D0-D1
                    OR.L           lowercase3bytes(PC),D0
                    CMP.L          longwordforram.(PC),D0   ; "ram:" ?
                    BEQ.S          .itsRam_Disk
                    CMP.L          longwordforram_(PC),D0   ; "ram " ?
                    BNE.S          .getcurrentdir
                    OR.L           lowercasefilter(PC),D1
                    CMP.L          longwordfordisk(PC),D1   ; "ram disk" ?
                    BEQ.S          .itsRam_Disk
.getcurrentdir      MOVEA.L        $2A(A5),A6               ; dosbase, relative
                    MOVEQ          #0,D1                    ; new tmp dir = sys:
                    JSR            _LVOCurrentDir(A6)
                    MOVE.L         D0,-(SP)                 ; save old dir lock
                    MOVE.L         D0,D1
                    JSR            _LVOCurrentDir(A6)
                    LEA            string_Ram.(PC),A0       ; "Ram:",0
                    MOVE.L         A0,D1
                    MOVEQ          #ACCESS_READ,D2
                    JSR            _LVOLock(A6)
                    MOVE.L         (SP)+,D1                 ; current dir lock
                    MOVE.L         D0,D2                    ; lock on Ram:
                    JSR            _LVOSameLock(A6)
                    MOVE.L         D2,D1                    ; unlock Ram:
                    MOVE.L         D0,D2
                    JSR            _LVOUnLock(A6)
                    TST.L          D2                       ; current dir = Ram: ?
                    BNE.S          .initdeficon
.itsRam_Disk        TST.L          D5                       ; icon identified ?
                    BNE.S          .checkdeficon
                    PEA            $52414D00                ; "RAM",0
                    MOVEA.L        SP,A0
                    CLR.L          -(SP)                    ; TAGS_DONE
                    MOVE.L         A0,-(SP)                 ; * "RAM" 
                    PEA            ICONGETA_GetDefaultName
                    MOVEA.L        SP,A1                    ; taglist
                    MOVEA.L        A5,A6                    ; iconbase
                    JSR            _LVOGetIconTagList(A6)
                    LEA            $10(SP),SP
                    TST.L          D0
                    BEQ.S          .checkdeficon
                    MOVE.L         D0,$260(SP)              ; DiskObject
                    BRA.S          .checkdeficon

.initdeficon        BSET.B         #2,$8A(A3)               ; set flag DefIcon
                    MOVEQ          #1,D0
                    ROR.L          #1,D0                    ; NO_ICON_POSITION
                    MOVE.L         D0,do_CurrentX(A3)
                    MOVE.L         D0,do_CurrentY(A3)
                    MOVE.L         do_DrawerData(A3),D0
                    BEQ.S          .checkdeficon
                    LEA            DefDrawerData(PC),A0     ; internal structure
                    CMP.L          A0,D0
                    BEQ.S          .checkdeficon            ; don't write to code 
                    MOVEA.L        D0,A0
                    CLR.L          dd_Flags(A0)
                    CLR.W          dd_ViewModes(A0)
.checkdeficon       MOVEQ          #0,D5                    ; no error yet
                    TST.B          $288(SP)                 ; is it a deficon ?
                    BNE.W          GITL_exit
.processimages      MOVEA.L        $260(SP),A3              ; DiskObject
                    TST.W          $25E(SP)                 ; are PalMaps wanted ?
                    BEQ.W          .PalMaps_off
                    BCLR.B         #7,$8A(A3)               ; enable V44 PalMaps
                    TST.L          $76(A3)                  ; PalMap1 ?
                    BNE.S          .hasPalMap1
                    TST.W          $284(SP)                 ; NoNewIcons ?
                    BNE.W          .PalMaps_done
                    TST.W          $C6(A5)                  ; GlobNewIconsSupport
                    BEQ.W          .PalMaps_done
                    MOVEQ          #1,D1                    ; mode = snip images
                    BSR.W          newicontooltypes         ; A3 = DiskObject
                    BEQ.W          .PalMaps_done
                    MOVEA.L        D0,A0                    ; NewIconImage strings
                    BSR.W          newiconimages            ; A3 = DiskObject
                    BNE.W          .PalMaps_done
                    LEA            $16(A3),A0               ; **GadgetRender
                    MOVE.L         (A0)+,$6E(A3)            ; copy *GadgetRender
                    MOVE.L         (A0),$72(A3)             ; copy *SelectRender
                    MOVE.B         $10+1(A3),D0             ; do_Flags
                    MOVEQ          #3,D1
                    AND.B          D1,D0                    ; do_Flags & 3
                    MOVE.B         D0,$8B(A3)               ; V44 flags
.hasPalMap1         MOVEA.L        $76(A3),A0
                    BSR.W          checkpalmap              ; PalMap1 ok ?
                    BNE.S          .usePalMap1
                    CLR.L          $76(A3)                  ; clear buggy PalMap1
                    BRA.W          .PalMaps_done

.usePalMap1         BSR.W          darkerPalMapCopy         ; A6 scratched!
                    TST.W          $286(SP)                 ; RemapIcon ?
                    BEQ.W          .mappingdone
                    LEA            $1A(A3),A0               ; *SelectRender
                    MOVEA.L        $72(A3),A1               ; V44 Select image
                    CMPA.L         (A0),A1
                    BNE.S          .differentSelect
                    CLR.L          (A0)                     ; clear SelectRender
.differentSelect    MOVEA.L        $6E(A3),A1               ; V44 Gadget image
                    CMPA.L         -(A0),A1
                    BNE.S          .differentGadget
                    CLR.L          (A0)                     ; clear GadgetRender
.differentGadget    TST.W          $28C(SP)                 ; screen supplied ?
                    BNE.S          .suppliedscreen
                    MOVE.L         $128(A5),D2              ; use GlobalScreen
                    BNE.S          .screensupplied
                    MOVEA.L        $36(A5),A0               ; intuibase
                    MOVE.L         $38(A0),D2               ; Global=ActiveScreen
.screensupplied     MOVE.L         $86(A3),D3               ; old icon screen
                    BEQ.S          .colormapping
                    CMP.L          D3,D2                    ; new screen wanted ?
                    BEQ.S          .colormapping
                    MOVEA.L        $76(A3),A0               ; PalMap1
                    MOVEA.L        D3,A1                    ; icon screen
                    BSR.W          releasepens
                    MOVEA.L        $7A(A3),A0               ; PalMap2
                    MOVEA.L        D3,A1                    ; icon screen
                    BSR.W          releasepens
.colormapping       MOVEA.L        $26(A5),A6               ; execbase
                    MOVEA.L        ThisTask(A6),A0
                    CMPA.L         $974(A5),A0              ; Workbench task ?
                    BNE.S          .dopus_function
                    SUBA.L         A0,A0                    ; delay color mapping
 ifd MC68020
                    BRA.S          .docolormapping

.dopus_function     MOVEA.L        $A(A0),A0
                    CMP.L          #"func",6(A0)
                    BNE.S          .docolormapping
                    MOVEA.W        #-1,A0                   ; it's dopus_function
 else
.dopus_function
 endif
.docolormapping     MOVEA.L        A3,A1                    ; DiskObject
                    MOVE.L         D2,D1                    ; own or GlobalScreen
                    MOVE.L         $124(A5),D0              ; GlobalPrecision
                    BSR.W          iconcolormapping
                    MOVE.L         D0,D5                    ; error code
                    BEQ.S          .colordone
 ifd MC68020
                    BRA.W          GITL_exit
 else
                    BRA.S          GITL_exit
 endif

.suppliedscreen     MOVE.L         $264(SP),D2              ; screen or NULL ?
                    BNE.S          .screensupplied
.noscreenconfig     BSR.W          alloc4colorimages
                    MOVE.L         D0,D5                    ; error code
 ifd MC68020
                    BNE.W          GITL_exit
 else
                    BNE.S          GITL_exit
 endif
                    MOVEA.L        A3,A0                    ; DiskObject
                    BSR.W          map2systemcolors
.colordone          MOVEA.L        $76(A3),A0               ; PalMap1
                    MOVE.L         (A0),D0                  ; width, height
                    LEA            $C(A3),A6                ; DiskObject w, h
                    MOVE.L         D0,(A6)+                 ; copy width, height
                    MOVEQ          #-4,D0
                    AND.W          D0,(A6)+                 ; clear flags 0,1
                    TST.L          $7A(A3)                  ; PalMap2 ?
                    BEQ.S          .mappingdone
                    BSET.B         #1,$11(A3)               ; flag hasImage2
                    BRA.S          .mappingdone

.PalMaps_off        BSET           #7,$8A(A3)               ; disable V44 PalMaps
.PalMaps_done       MOVEA.L        $16(A3),A0               ; GadgetRender
                    MOVE.L         4(A0),$C(A3)             ; copy width, height
.mappingdone        TST.W          $28A(SP)                 ; generate image masks?
                    BEQ.S          GITL_exit                ; (no masks for WB 3.1)
 ifd MC68020
                    TST.B          $97A(A5)                 ; RTG flag > 0 ?
                    BLE.S          .trymask1
                    MOVE.L         $280(SP),D0              ; this task
                    CMP.L          $974(A5),D0              ; = Workbench task ?
                    BEQ.S          .trymask1
                    TST.L          $7E(A3)                  ; does mask1 exist ?
                    BNE.S          .trymask2
 endif
.trymask1           LEA            $7E(A3),A1               ; * mask1
                    TST.W          $25E(SP)                 ; PalMaps wanted ?
                    BEQ.W          makePlanarMask
                    MOVE.L         $76(A3),D0               ; PalMap1
 ifd MC68020
                    BEQ.W          makePlanarMask
 else
                    BEQ.S          makePlanarMask
 endif
                    MOVEA.L        D0,A0                    ; PalMap1
                    BSR.W          makePalMapMask           ; A0=PalMap,A5=iconbase
 ifd MC68020
.trymask2           BCLR           #5,$8A(A3)               ; no mask2 wanted ?
                    BNE.S          GITL_exit
 endif
                    MOVE.L         $7A(A3),D0               ; PalMap2 ?
                    BEQ.S          GITL_exit
                    MOVEA.L        D0,A0                    ; PalMap2
                    LEA            $82(A3),A1               ; mask2
                    BSR.W          makePalMapMask           ; A0=PalMap,A5=iconbase
GITL_exit           MOVEA.L        $2A(A5),A6               ; dosbase
                    MOVE.L         $268(SP),D1              ; filehandle
                    BEQ.S          .skipclose
                    JSR            _LVOClose(A6)
.skipclose          MOVE.L         $26C(SP),D1              ; path or file lock
                    JSR            _LVOUnLock(A6)
                    MOVE.L         D4,D1                    ; parentdir
                    JSR            _LVOUnLock(A6)
                    MOVE.L         $274(SP),D0              ; filtered taglist
                    BEQ.S          .restoreWindowPtr
                    MOVEA.L        D0,A0
                    MOVEA.L        $2E(A5),A6               ; utilbase
                    JSR            _LVOFreeTagItems(A6)
.restoreWindowPtr   MOVEA.L        $280(SP),A0              ; this task
                    MOVE.L         $27C(SP),pr_WindowPtr(A0)
                    MOVE.L         $278(SP),D0              ; * error code
                    BEQ.S          .noerrorwanted
                    MOVEA.L        D0,A0
                    MOVE.L         D5,(A0)                  ; tagitem error code
.noerrorwanted      MOVEA.L        $260(SP),A2              ; DiskObject
                    MOVE.L         D5,D1                    ; error code
                    BEQ.S          .noerror
                    MOVEA.L        $2A(A5),A6               ; dosbase
                    JSR            _LVOSetIoErr(A6)
                    MOVEA.L        A2,A0                    ; DiskObject
                    MOVEA.L        A5,A6                    ; iconbase
                    JSR            _LVOFreeDiskObject(A6)
                    SUBA.L         A2,A2                    ; clear DiskOject
.noerror            MOVE.L         A2,D0                    ; return DiskObject
                    MOVEM.L        (SP)+,D2-D6/A0-A3/A5-A6
                    LEA            $264(SP),SP
                    RTS

                 ;;;;--------------------------------------------------------------
                    ; tmpras=$88-$8F inverse image bitmap=$90-$B7 *planes[] cleared
                    ; *rastermem=$34  source image bitmap=$38-$5F tmpmaskbm=$60-$87         

makePlanarMask      BTST.B         #0,$11(A3)               ; BackFill with 0 ?
                    BEQ.S          GITL_exit
                    MOVEQ          #8-1,D0
.initplanearray     CLR.L          -(SP)
                    DBRA           D0,.initplanearray       ; $98-$B7 array cleared 
                    LEA            -$64(SP),SP              ; $34-$97
                    MOVEA.L        $16(A3),A0               ; GadgetRender
                    MOVEM.L        4(A0),D0-D1              ; width, height, depth
                    MOVEM.L        D0-D7/A0-A4,-(SP)        ; A0=image, A1=*mask
                    BSR.W          freerastermem
                    MOVEQ          #8,D0                    ; 8 bytes
                    MOVE.L         #MEMF_PUBLIC|MEMF_CLEAR,D1
                    MOVEA.L        $26(A5),A6               ; execbase
                    JSR            _LVOAllocMem(A6)
                    MOVE.L         D0,$34(SP)               ; rastermem entry
                    BEQ.W          .nomemory
                    MOVEA.L        D0,A3
                    BSET.B         #7,$F1(A5)               ; rastport protection
                    BEQ.S          .allocmaskplane
                    BSR.W          bitlockdelay

.allocmaskplane     MOVEM.W        (SP),D0-D1               ; width, height
                    ADDQ.L         #8,D0
                    ADDQ.L         #7,D0
                    LSR.L          #4,D0
                    ADD.L          D0,D0                    ; word aligned bytes
                    MULU.W         D1,D0                    ; total plane size
                    MOVEQ          #1,D5
                    SWAP           D5                       ; bit 16 = MEMF_CLEAR
                    OR.L           $C0(A5),D5               ; attributes (IPrefs)
                    MOVE.L         D5,D1                    ; alloc attributes
                    JSR            _LVOAllocMem(A6)
                    MOVE.L         D0,(A3)+                 ; rastermem mask plane
                    BEQ.S          .nofreemem
                    MOVE.L         (SP),(A3)                ; mask width, height
                    LEA            $60(SP),A4               ; temp mask bitmap
                    MOVEM.W        (SP),D1-D2/D7            ; width, height, depth
                    MOVE.L         D7,D0                    ; depth
                    MOVEA.L        A4,A0                    ; temp mask bitmap
                    MOVEA.L        $32(A5),A6               ; gfxbase
                    JSR            _LVOInitBitMap(A6)
                    MOVEA.L        -(A3),A0                 ; mask plane
                    MOVEA.L        A4,A1                    ; temp mask bitmap
                    ADDQ.W         #8,A1                    ; temp bitmap ->plane0
                    BRA.S          .countdowndepth

.nofreemem          LEA            $34(SP),A1               ; *rastermem entry
                    BSR.W          freerastermem
                    BRA.W          .freeplanes

.linkmaskplane      MOVE.L         A0,(A1)+                 ; 1 mask plane for all
.countdowndepth     DBRA           D7,.linkmaskplane
                    LEA            $90(SP),A3               ; inverse image bitmap
                    MOVEM.W        (SP),D1-D2/D7            ; width, height, depth
                    MOVE.L         D7,D0                    ; depth
                    MOVE.L         D1,D6                    ; width
                    ADDQ.L         #2,D1                    ; + 1 left + 1 right edge
                    ADDQ.L         #2,D2                    ; + 1 row above + 1 below
                    MOVEA.L        A3,A0                    ; image bitmap
                    JSR            _LVOInitBitMap(A6)
                    MOVE.L         A3,rp_BitMap+$3E(A5)     ; bitmap into rastport
                    MOVEM.W        (A3),D3-D4               ; bytes/row, rows
                    MULU.W         D3,D4                    ; bytes/row * rows
                    MOVE.L         D4,D0                    ; plane size
                    MULU.W         D7,D0                    ; image size
                    ADD.L          D4,D0                    ; + 1 plane for tmpras
                    MOVE.L         D5,D1                    ; attributes (IPrefs)
                    MOVEA.L        $26(A5),A6               ; execbase
                    JSR            _LVOAllocVec(A6)
                    TST.L          D0
                    BEQ.S          .nofreemem
                    SUBQ.L         #3,D2                    ; (height+2) - 3
                    MOVE.L         D3,D5                    ; bytes/row
                    LSR.L          #1,D3                    ; words/row
                    SUBQ.L         #1,D3                    ; words/row - 1
                    ADDQ.L         #1,D6                    ; width + 1
                    ROR.L          #3,D6                    ; width+1/8, modulo 8 up
                    MOVEA.W        D6,A2                    ; byte offset right edge
                    CLR.W          D6
                    ROL.L          #3,D6                    ; get width+1 modulo 8
                    NOT.L          D6                       ; from -1 to -8
                    ADDQ.L         #8,D6                    ; from bit 7 to bit 0
                    MOVEA.L        A3,A0                    ; inverted image bitmap
                    ADDQ.W         #8,A0                    ; image bitmap *plane0
                    SUBQ.L         #1,D7                    ; counter = depth - 1
.nextplane          MOVE.L         D0,(A0)+                 ; plane pointer or NULL
                    MOVEA.L        D0,A1                    ; start of the top row
                    MOVE.L         D3,D1                    ; words/row - 1
.firstline          NOT.W          (A1)+                    ; set all top bits to 1
                    DBRA           D1,.firstline
                    MOVE.L         D2,D1                    ; height - 1
.movelower          BSET.B         #7,(A1)                  ; set left border to 1
                    BSET.B         D6,(A1,A2)               ; set right border to 1
                    ADDA.L         D5,A1                    ; move to next row
                    DBRA           D1,.movelower
                    MOVE.L         D3,D1                    ; words/row - 1
.bottomrow          NOT.W          (A1)+                    ; all bottom bits to 1
                    DBRA           D1,.bottomrow
                    ADD.L          D4,D0                    ; to next plane offset
                    DBRA           D7,.nextplane            ; mask all planes D7=-1
                    MOVEA.L        D0,A1                    ; tmpras raster memory
                    MOVE.L         D4,D0                    ; size in bytes
                    LEA            $88(SP),A0               ; * tmpras structure
                    MOVE.L         A0,rp_TmpRas+$3E(A5)     ; link it into rastport
                    MOVEA.L        $32(A5),A6               ; gfxbase
                    JSR            _LVOInitTmpRas(A6)
                    MOVEA.L        $20(SP),A0               ; source image
                    LEA            $38(SP),A1               ; source image bitmap
                    BSR.W          preparebitmap
                    MOVEQ          #0,D0                    ; src x = 0
                    MOVEQ          #0,D1                    ; src y = 0
                    MOVEQ          #1,D2                    ; dst x = 1
                    MOVEQ          #1,D3                    ; dst y = 1
                    MOVEM.W        (SP),D4-D5               ; image width, height
                    MOVEQ          #$33,D6                  ; minterm = $33, D7=-1
                    LEA            $38(SP),A0               ; source image bitmap
                    MOVEA.L        A3,A1                    ; inverse image bitmap
                    SUBA.L         A2,A2                    ; TmpA not used
                    JSR            _LVOBltBitMap(A6)        ; invert all image data
                    MOVEQ          #0,D0                    ; x = 0
                    MOVEQ          #0,D1                    ; y = 0
                    MOVEQ          #1,D2                    ; flood mode = JAM2
                    LEA            $3E(A5),A1               ; rastport
                    JSR            _LVOFlood(A6)
                    MOVEQ          #1,D0                    ; src x = 1
                    MOVEQ          #1,D1                    ; src y = 1
                    MOVEQ          #0,D2                    ; dst x = 0
                    MOVEQ          #0,D3                    ; dst y = 0
                    MOVEQ          #$77,D6
                    ADD.L          D6,D6                    ; minterm = $EE = OR
                    MOVEA.L        A3,A0                    ; inverse image bitmap
                    MOVEA.L        A4,A1                    ; dst = mask bitmap
                    JSR            _LVOBltBitMap(A6)
                    MOVEQ          #0,D0                    ; src x = 0
                    MOVEQ          #0,D1                    ; src y = 0
                    LEA            $38(SP),A0               ; source image bitmap
                    MOVEA.L        A4,A1                    ; dst = mask bitmap
                    JSR            _LVOBltBitMap(A6)
                    MOVEA.L        $24(SP),A0               ; *mask
                    MOVE.L         $34(SP),(A0)             ; store rastermem entry
                    JSR            _LVOWaitBlit(A6)
                    MOVEA.L        $26(A5),A6               ; execbase
.freeplanes         MOVEA.L        8+$90(SP),A1             ; inverse image *plane0
                    JSR            _LVOFreeVec(A6)
                    BCLR.B         #7,$F1(A5)               ; release rastport
.nomemory           MOVEM.L        (SP)+,D0-D7/A0-A4
                    LEA            $84(SP),SP
                    BRA.W          GITL_exit

;---------------------------------------------------------------------------------

DOstack             set            $258

readDiskObject      CLR.L          -(SP)                    ; $250 * real image 1
                    CLR.L          -(SP)                    ; $24C size of image 1
                    LEA            -$21C(SP),SP             ; $30-$24B
                    CLR.L          -(SP)                    ; $2C * icon buffer
                    CLR.L          -(SP)                    ; $28 * decode buffer
                    MOVEM.L        D2-D7/A2-A4/A6,-(SP)     ; A1=filename,A5=ibase
                    MOVEA.L        A1,A2                    ; filename
                    LEA            $4C(SP),A4               ; 512 bytes stack
                    CLR.L          $40(SP)                  ; NewIcon image2 size2
                    MOVEA.L        A4,A0                    ; name.info buffer
.copyfilename       MOVE.B         (A1)+,(A0)+
                    BNE.S          .copyfilename
 ifd MC68020
                    CMPI.W         #$2F00,-(A0)             ; dir name with slash ?
                    BEQ.S          .addextension
                    ADDQ.W         #1,A0
.addextension       MOVE.B         #".",(A0)+
                    MOVE.L         #"info",(A0)+
 else
                    SUBQ.W         #2,A0
                    CMPI.B         #"/",(A0)
                    BEQ.S          .addextension
                    ADDQ.W         #1,A0
.addextension       MOVE.B         #".",(A0)+
                    MOVE.B         #"i",(A0)+
                    MOVE.B         #"n",(A0)+
                    MOVE.B         #"f",(A0)+
                    MOVE.B         #"o",(A0)+
 endif
                    CLR.B          (A0)
                    MOVE.L         A4,D1                    ; name.info buffer
                    MOVE.L         #MODE_OLDFILE,D2
                    MOVEA.L        $2A(A5),A6               ; dosbase
                    JSR            _LVOOpen(A6)
                    MOVE.L         D0,D7                    ; filehandle ?
                    BNE.S          .allocateV44icon
                    JSR            _LVOIoErr(A6)
                    MOVE.L         D0,D5
                    BRA.W          .noiconfilehandle

.allocateV44icon    MOVEQ          #71,D0
                    ADD.L          D0,D0                    ; 142 bytes for v44 DO
                    MOVEA.L        $26(A5),A6               ; execbase
                    MOVE.L         #MEMF_PUBLIC|MEMF_CLEAR,D1
                    JSR            _LVOAllocMem(A6)
                    MOVE.L         D0,DOstack+V44DO(SP)     ; * struct DiskObject
                    BEQ.W          .noiconstructure
                    MOVEA.L        D0,A3                    ; V44 icon structure
                    MOVE.L         DiskObject_tool(PC),(A3) ; do_Magic = $E3100001
                    MOVEQ          #0,D5                    ; return code = ok
                    LEA            $50+4(A3),A0             ; empty free/memlist
                    MOVE.L         A0,-(A0)
                    MOVE.L         A0,$8(A0)
                    LEA            $5E(A3),A0               ; magic v44 selfpointer
                    MOVE.L         A0,(A0)
                    ADDQ.B         #2,$8A(A3)               ; use NewIcon tooltypes
 ifd Scalers
                    MOVE.B         $F0(A5),$8D(A3)          ; image scaling flag
 endif
                    BSET.B         #1,$F1(A5)               ; V44 icon protection
                    BEQ.S          .appendiconnode
                    BSR.W          bitlockdelay

.appendiconnode     LEA            $A2+8(A5),A0             ; A0 = list *lh_TailPred
                    MOVE.L         (A0),D0                  ; D0 = old lh_TailPred
                    LEA            $62(A3),A1               ; A1 = new struct node
                    MOVE.L         A1,(A0)                  ; new lh_TailPred = A1
                    SUBQ.W         #4,A0                    ; *lh_Tail -> Null
                    EXG            D0,A0
                    MOVEM.L        D0/A0,(A1)               ; succ=0, pred=old
                    MOVE.L         A1,(A0)                  ; old succ = A1
                    SUBQ.B         #2,$F1(A5)               ; clear V44 protection
                    MOVE.L         D7,D1                    ; filehandle
                    MOVEQ          #0,D2                    ; offset position
                    MOVEQ          #OFFSET_END,D3
                    MOVEA.L        $2A(A5),A6               ; dosbase
                    JSR            _LVOSeek(A6)
                    MOVE.L         D7,D1                    ; filehandle
                    MOVEQ          #OFFSET_BEGINNING,D3
                    JSR            _LVOSeek(A6)
                    MOVE.L         D0,D4                    ; icon size = END
                    MOVEQ          #MEMF_PUBLIC,D1
                    MOVEA.L        $26(A5),A6               ; execbase
                    JSR            _LVOAllocVec(A6)
                    MOVE.L         D0,$2C(SP)               ; store icon buffer
                    BEQ.W          .nofreestore
                    MOVE.L         D7,D1                    ; filehandle
                    MOVE.L         D0,D2                    ; icon buffer
                    MOVE.L         D4,D3                    ; bytes to read
                    MOVEA.L        $2A(A5),A6               ; dosbase
                    JSR            _LVORead(A6)
                    CMP.L          D0,D4                    ; all bytes read ?
                    BNE.W          .endofbuffer
                    MOVEQ          #0,D6                    ; no disk.info yet
                    MOVE.L         A4,D1                    ; name.info buffer
                    JSR            _LVOPathPart(A6)
                    MOVEA.L        D0,A0
                    MOVE.L         lowercasefilter(PC),D0
                    CMPI.B         #"/",(A0)
                    BEQ.S          .checkfiletype
 ifd MC68020
                    MOVE.L         (A0)+,D1
 else
                    MoveOddLong    A0,D1
 endif
                    OR.L           D0,D1                    ; force to lower case
                    CMPI.B         #".",(A0)+
                    BNE.S          .checkfiletype
                    CMP.L          longwordfordisk(PC),D1
                    BNE.S          .checkfiletype
 ifd MC68020
                    OR.L           (A0)+,D0                 ; force lower case
 else
                    MoveOddLong    A0,D1
                    OR.L           D1,D0
 endif
                    TST.B          (A0)
                    BNE.S          .checkfiletype
                    CMPI.L         #"info",D0
                    BNE.S          .checkfiletype
                    MOVE.L         A4,D1                    ; name.info buffer
                    MOVEQ          #ACCESS_READ,D2
                    JSR            _LVOLock(A6)
                    MOVE.L         D0,D1                    ; lock of disk.info
                    BEQ.S          .checkfiletype
                    MOVE.L         D1,-(SP)
                    MOVE.L         A4,D2                    ; name.info buffer
                    MOVEQ          #64,D3
                    LSL.L          #3,D3                    ; 512 bytes maximum
                    JSR            _LVONameFromLock(A6)
                    MOVE.L         D0,D2
                    MOVE.L         (SP)+,D1                 ; lock of disk.info
                    JSR            _LVOUnLock(A6)
                    TST.L          D2                       ; name from lock ?
                    BEQ.S          .checkfiletype
                    MOVE.L         A4,D1                    ; name.info buffer
                    JSR            _LVOPathPart(A6)
                    MOVEA.L        D0,A0
                    CMPI.B         #":",-(A0)               ; disk.info on root ?
                    BNE.S          .checkfiletype
                    SEQ            D6                       ; flag for disk.info
.usingdiskicon      LEA            DiskObject_disk(PC),A0
.checkfiletype      MOVEA.L        $2C(SP),A1
                    CMPI.L         #$E3100001,(A1)          ; is it a DiskObject?
                    BEQ.W          .diskmagicfound
                    CMPI.L         #$89504E47,(A1)          ; is it a PNG icon ?
                    BNE.W          .wrongtype
                    MOVEQ          #$D,D0                   ; size of IHDR chunk
                    SUB.L          8(A1),D0                 ; DiskObject trash ?
                    BNE.W          .wrongtype               ; written by AsimCDFS
                    TST.B          D6                       ; disk.info flag set?
                    BNE.S          .copyDiskObject
                    MOVE.L         A2,D1                    ; filename or dirname
                    MOVEQ          #ACCESS_READ,D2
                    JSR            _LVOLock(A6)
                    MOVE.L         D0,D3                    ; file lock
                    BEQ.S          .PNG_file
                    MOVE.L         D0,D1                    ; file lock
                    MOVE.L         A4,D2                    ; 512 B stack buffer
                    ADDQ.L         #3,D2
                    ANDI.B         #$FC,D2                  ; align stack address
                    MOVEA.L        D2,A2                    ; for FileInfoBlock
                    JSR            _LVOExamine(A6)
                    MOVE.L         fib_DirEntryType(A2),D2
                    MOVE.L         D3,D1
                    JSR            _LVOUnLock(A6)
                    LEA            DiskObject_drawer(PC),A0
                    TST.L          D2                       ; type > 0 for drawers
                    BPL.S          .copyDiskObject
.PNG_file           LEA            DiskObject_tool(PC),A0
.copyDiskObject     MOVEA.L        A3,A1
                    MOVEQ          #$4E,D0                  ; sizeof DiskObject
                    BSR.W          CopyMemAligned           ; A1 is re-used
                    MOVEA.L        A1,A0                    ; freelist
                    MOVEA.W        #$3E,A1                  ; sizeof DrawerData
                    MOVEA.W        #MEMF_PUBLIC,A2
                    BSR.W          FreeAlloc                ; needs no iconbase
                    MOVEA.L        D0,A4                    ; buffer as allocated
                    MOVE.L         A4,do_DrawerData(A3)     ; new struct drawer
                    BEQ.W          .nofreestore
                    LEA            DefDrawerData(PC),A0
                    MOVEA.L        A4,A1
                    MOVEQ          #$3E,D0                  ; sizeof DrawerData
                    BSR.W          CopyMemAligned
                    MOVE.L         #"IEND",D5               ; search for "IEND"
                    MOVEA.L        #"icOn",A1               ; search for "icOn"
                    MOVEA.L        $2C(SP),A2               ; icon file buffer
                    ADD.L          A2,D4                    ; buffer start + size
                    MOVE.L         D4,$3C(SP)               ; store end of buffer
                    SUBQ.L         #4,D4                    ; no 4 byte chunks !
                    MOVEQ          #4,D0                    ; skip ~PNG signature
.scanPNGimage1      ADDA.L         D0,A2                    ; add chunk data size
                    ADDQ.W         #4,A2                    ; start of next chunk
 ifd MC68020
                    MOVEM.L        (A2)+,D0-D1              ; chunk size and type
 else
                    MoveOddLong    A2,D0
                    MoveOddLong    A2,D1
 endif
                    CMPA.L         D4,A2                    ; >4 bytes in buffer?
                    BCC.W          .PNG_EOF_found
                    CMP.L          D5,D1                    ; end of PNG image1 ?
                    BEQ.W          .PNG_IEND_found
                    CMP.L          A1,D1                    ; chunk type = icOn ?
                    BNE.S          .scanPNGimage1
                    MOVE.L         A2,D6
                    ANDI.B         #$FC,D6                  ; longword alignment
                    MOVE.L         D6,$34(SP)               ; * toolarray buffer
                    ADD.L          A2,D0                    ; * icOn data + size
                    MOVEA.L        D0,A6
.read_icOn          CMPA.L         A6,A2                    ; end of icOn data ?
                    BCC.W          .PNG_icOn_done
 ifd MC68020
                    MOVEM.L        (A2)+,D0-D1              ; read tag and value
 else
                    MoveOddLong    A2,D0
                    MoveOddLong    A2,D1
 endif
                    SUBI.L         #$80001001,D0            ; icOn tag found ?
                    BCS.S          .read_icOn
                    SUBQ.L         #8,D0
                    BHI.S          .tenorhigher
                    BEQ.S          .stacksize               ; 9
                    ADDQ.L         #2,D0
                    BEQ.S          .read_icOn               ; 7 default dd_Flags
                    BPL.S          .toolwindow              ; 8
                    ADDQ.L         #4,D0
                    BPL.S          .drawerwindow            ; 3-6 D0=0-3
                    ADDQ.L         #2,D0
 ifd MC68020
                    MOVE.L         D1,do_CurrentX(A3,D0.L*4); 1-2 D0=0-1
 else
                    ADD.B          D0,D0
                    ADD.B          D0,D0
                    MOVE.L         D1,do_CurrentX(A3,D0.W)
 endif
                    BRA.S          .read_icOn

.tenorhigher        SUBQ.L         #2,D0
     ifd MC68020
                    BEQ.S          .tooltypes
                    BCS.S          .defaulttool
     else
                    BEQ.W          .tooltypes
                    BCS.W          .defaulttool
     endif
                    SUBQ.L         #2,D0
                    BEQ.S          .drawerCurrentX          ; 13
                    BCS.S          .read_icOn               ; 12 default viewmode
                    SUBQ.L         #2,D0
                    BCS.S          .drawerCurrentY          ; 14
                    BNE.S          .testframelessflag       ; >15
                    CMPI.B         #WBPROJECT,D1            ; 15 D1 = icon type
                    BEQ.S          .set_do_Type
                    CMPI.B         #WBDRAWER,do_Type(A3)
                    BNE.S          .checkforwbdisk
                    CMPI.B         #WBGARBAGE,D1            ; trashcan + drawer?
                    BNE.S          .read_icOn               ; found & set drawer
.checkforwbdisk     CMPI.B         #WBDISK,do_Type(A3)
                    BEQ.S          .usedopustoolbar
.set_do_Type        MOVE.B         D1,do_Type(A3)
                    SUBQ.B         #WBDISK,D1
                    BNE.S          .read_icOn
.usedopustoolbar    MOVE.B         #$10,dd_Flags(A4)
     ifd MC68020
                    BRA.S          .read_icOn
     else
                    BRA.W          .read_icOn
     endif
 ifd MC68020
.testframelessflag  SUBQ.L         #1,D0
                    BNE.S          .read_icOn
                    TST.L          D1
                    BEQ.S          .read_icOn
                    BSET.B         #0,$8A(A3)               ; 16 frameless
                    BRA.S          .read_icOn

.stacksize          MOVE.L         D1,do_StackSize(A3)
                    BRA.S          .read_icOn

.drawerwindow       MOVE.W         D1,(A4,D0.L*2)
                    BRA.W          .read_icOn
.toolwindow
                    BSR.S          .readPNGtoolstring
                    MOVE.L         D4,do_ToolWindow(A3)
 else
.testframelessflag  SUBQ.L         #1,D0
                    BNE.W          .read_icOn
                    TST.L          D1
                    BEQ.W          .read_icOn
                    BSET.B         #0,$8A(A3)
                    BRA.W          .read_icOn

.stacksize          MOVE.L         D1,do_StackSize(A3)
                    BRA.W          .read_icOn

.drawerwindow       ADD.B          D0,D0
                    MOVE.W         D1,(A4,D0.W)
                    BRA.W          .read_icOn

.toolwindow
                    BSR.S          .readPNGtoolstring
                    MOVE.L         D4,do_ToolWindow(A3)
 endif
                    BRA.W          .read_icOn

.drawerCurrentX     MOVE.L         D1,dd_CurrentX(A4)
                    BRA.W          .read_icOn

.drawerCurrentY     MOVE.L         D1,dd_CurrentY(A4)
                    BRA.W          .read_icOn
.tooltypes          BSR.S          .readPNGtoolstring
                    MOVEA.L        D6,A0                    ; toolarraypointer
                    MOVE.L         D4,(A0)                  ; save *toolstring
                    ADDQ.L         #4,D6
                    BRA.W          .read_icOn

.defaulttool        BSR.S          .readPNGtoolstring
                    TST.L          D4
                    BEQ.S          .nodefaulttool
                    MOVEA.L        D4,A0
                    TST.B          (A0)
                    BEQ.S          .nodefaulttool
                    CMPI.L         #"JUNK",(A0)
                    BEQ.S          .nodefaulttool
                    MOVE.L         D4,do_DefaultTool(A3)
.nodefaulttool      BRA.W          .read_icOn

.readPNGtoolstring  SUBQ.W         #4,A2                    ; 4 bytes backwards
                    MOVEA.L        A2,A0                    ; start of toolstring
.countcharacters    TST.B          (A2)+
                    BNE.S          .countcharacters
                    MOVE.L         A2,D2                    ; save buffer pointer
                    MOVE.L         A2,D3
                    SUB.L          A0,D3
                    LEA            $4E(A3),A0               ; freelist
                    MOVEA.L        D3,A1                    ; toolstring length
                    MOVEA.W        #MEMF_PUBLIC,A2
                    BSR.W          FreeAlloc                ; needs no iconbase
                    MOVEA.L        D2,A2                    ; buffer pointer back
                    MOVE.L         D0,D4                    ; target memblock ?
                    BEQ.S          .stringcopydone
                    MOVEA.L        A2,A0                    ; source icon buffer
                    SUBA.L         D3,A0                    ; start of toolstring
                    MOVEA.L        D4,A1                    ; toolstring memblock
                    MOVE.L         D3,D0                    ; toolstring length
                    BRA.W          CopyMemBlock

.stringcopydone     RTS

.PNG_icOn_done      MOVEA.L        $3C(SP),A1               ; end of icon buffer
                    SUBQ.W         #4,A1                    ; no 4 byte chunks !
                    MOVEA.L        A6,A2                    ; icOn data end > CRC
                    MOVEQ          #0,D0
.find_IEND_chunk    ADDA.L         D0,A2                    ; add chunk data size
                    ADDQ.W         #4,A2                    ; start of next chunk
 ifd MC68020
                    MOVEM.L        (A2)+,D0-D1              ; chunk size and type
 else
                    MoveOddLong    A2,D0
                    MoveOddLong    A2,D1
 endif
                    CMPA.L         A1,A2                    ; >4 bytes in buffer?
                    BCC.S          .PNG_EOF_found
                    CMP.L          D5,D1                    ; end of PNG image1 ?
                    BNE.S          .find_IEND_chunk
.PNG_IEND_found     ADDQ.W         #4,A2                    ; skip IEND CRC32 sum
                    MOVE.L         A2,$44(SP)
 ifd MC68020
                    CMPI.L         #$89504E47,(A2)          ; is it PNG image2 ?
 else
                    MoveOddLong    A2,D0
                    CMPI.L         #$89504E47,D0
 endif
                    BEQ.S          .maketooltypearray
.PNG_EOF_found      CLR.L          $44(SP)                  ; no second PNG image
.maketooltypearray  LEA            $4E(A3),A0               ; freelist
                    MOVEA.L        $34(SP),A4               ; tooltypearray buffer
                    SUB.L          A4,D6                    ; number of used longs
                    BLS.S          .arraycopydone
                    MOVEA.L        D6,A1                    ; required array size
                    ADDQ.W         #4,A1                    ; for the Null entry
                    MOVEA.W        #MEMF_PUBLIC,A2
                    BSR.W          FreeAlloc                ; needs no iconbase
                    MOVE.L         D0,do_ToolTypes(A3)
                    BEQ.S          .arraycopydone
                    MOVEA.L        A4,A0
                    MOVEA.L        D0,A1
                    MOVE.L         D6,D0                    ; required array size
                    BSR.W          CopyMemAligned           ; A1 is re-used
                    CLR.L          (A1)                     ; terminate the array
.arraycopydone      BTST.B         #1,$C3(A5)               ; is ChipMem used ?
                    BNE.S          .usethedotimage
                    BSR.W          usedeficons              ; the internal icons
                    BRA.S          .oldimagesdone

.usethedotimage     LEA            $154(A5),A0              ; struct dot image
                    LEA            do_Gadget+gg_GadgetRender(A3),A1
                    MOVE.L         A0,(A1)+
                    CLR.L          (A1)                     ; clear SelectRender
                    MOVE.W         #4,do_Gadget+gg_Flags(A3); flags = invert Dot
.oldimagesdone      MOVEA.L        $2C(SP),A2               ; start of icon buffer
                    TST.L          $76(A3)                  ; is PalMap1 done ?
                    BEQ.S          .check_PNG_IHDR
.try_PNG_image2     MOVE.L         $44(SP),D0               ; PNG image2 found ?
                    BEQ.W          .addglowingimage
                    MOVEA.L        D0,A2                    ; start of PNG image2
 ifd MC68020
                    MOVEA.L        $280+DOstack(SP),A0      ; this task
                    MOVEA.L        $A(A0),A0                ; name of this task
                    MOVE.L         (A0)+,D0
                    OR.L           lowercasefilter(PC),D0
                    CMPI.L         #"imag",D0
                    BNE.S          .check_PNG_IHDR
                    MOVE.L         (A0),D0
                    OR.L           lowercasefilter(PC),D0
                    CMPI.L         #"e2ic",D0               ; is this Image2Icon?
                    BEQ.W          .addglowingimage         ; replacing 2. image
 endif
.check_PNG_IHDR     MOVEA.L        $3C(SP),A4               ; end of icon buffer
                    ADDA.W         #$C,A2
 ifd MC68020
                    CMPI.L         #"IHDR",(A2)+            ; IHDR chunk found ?
                    BNE.W          .PNGreturn
                    MOVEM.L        (A2)+,D0-D2
 else
                    MoveOddLong    A2,D0
                    CMPI.L         #"IHDR",D0
                    BNE.W          .PNGreturn
                    MoveOddLong    A2,D0
                    MoveOddLong    A2,D1
                    MoveOddLong    A2,D2
 endif
                    TST.L          $76(A3)                  ; is PalMap1 done ?
                    BEQ.S          .checkimagedata
                    CMP.W          $48(SP),D0               ; same width again ?
                    BNE.W          .addglowingimage
                    CMP.W          $4A(SP),D1               ; same height again ?
                    BNE.W          .addglowingimage
.checkimagedata     MOVEM.W        D0-D1,$30(SP)            ; image width, height
                    MOVEM.W        D0-D1,$48(SP)            ; unscaled image size
                    MOVE.L         D0,D6
                    MULU.W         D1,D6                    ; full size of image
                    MOVE.L         D6,D3
                    LSL.L          #2,D6                    ; 4 * size for ARGB
                    ADD.L          D6,D3
                    ADD.L          D1,D6                    ; +height for filters
                    SUBQ.L         #1,D0                    ; width  (1 to 256)
                    CLR.B          D0
                    SUBQ.L         #1,D1                    ; height (1 to 256)
                    CLR.B          D1
                    OR.B           (A2)+,D2                 ; interlace OR filter
                    SWAP           D2                       ; and compression = 0
                    SUBI.W         #$0802,D2                ; depth = 8 color = 2
                    MOVE.L         D2,D4                    ; must be 0 or 4 now
                    ANDI.W         #$FFFB,D2                ; color type = 2 or 6
                    OR.L           D0,D2
                    OR.L           D1,D2
 ifd MC68020
                    BNE.S          .PNGreturn
 else
                    BNE.W          .PNGreturn
 endif
                    MOVE.L         D6,D0                    ; ARGB bytes + filter
 ifd Scalers
                    MOVE.B         $8D(A3),D1               ; image scaling on ?
                    BLE.S          .skipscalingsize
                    ADD.L          D3,D0                    ; 900 % for upscaling
.skipscalingsize
 endif
                    MOVEA.L        $26(A5),A6               ; execbase
                    TST.L          $28(SP)                  ; test decode buffer
                    BNE.S          .read_IDAT_chunk
                    MOVEQ          #MEMF_PUBLIC,D1
                    JSR            _LVOAllocVec(A6)
                    MOVE.L         D0,$28(SP)               ; temp decode buffer
                    BEQ.W          .nofreestore
.read_IDAT_chunk    MOVEA.L        #"IDAT",A6
.find_IDAT_chunk    ADDA.L         D2,A2                    ; add chunk data size
                    ADDQ.W         #4,A2                    ; start of next chunk
 ifd MC68020
                    MOVEM.L        (A2)+,D2-D3              ; chunk size and type
 else
                    MoveOddLong    A2,D2
                    MoveOddLong    A2,D3
 endif
                    CMPA.L         A4,A2                    ; end of icon buffer?
                    BCC.S          .PNGreturn
                    CMP.L          D5,D3                    ; "IEND" found ?
                    BEQ.S          .PNGreturn
                    CMP.L          A6,D3                    ; "IDAT" found ?
                    BNE.S          .find_IDAT_chunk
                    MOVEA.L        A2,A0                    ; start of IDAT image
                    ADDA.L         D2,A0                    ; end of 1. IDAT data
                    MOVEA.L        A0,A1                    ; add more data at CRC
.next_IDAT_chunk    ADDQ.W         #4,A0                    ; start of next chunk
 ifd MC68020
                    MOVEM.L        (A0)+,D0-D1              ; chunk size and type
 else
                    MoveOddLong    A0,D0
                    MoveOddLong    A0,D1
 endif
                    CMP.L          A6,D1                    ; "IDAT" found ?
                    BNE.S          .last_IDAT_done
                    CMPA.L         A4,A0                    ; end of icon buffer?
                    BCC.S          .last_IDAT_done
                    ADD.L          D0,D2                    ; new IDAT data size
                    BSR.W          CopyMemBlock             ; append data above
                    BRA.S          .next_IDAT_chunk

.PNGreturn          MOVEQ          #0,D5                    ; return no error code
                    BRA.W          .readingdone

.last_IDAT_done     MOVEA.L        A2,A0                    ; start of IDAT image
                    MOVE.L         D2,D0                    ; size of IDAT image
                    MOVE.L         D6,D1                    ; full size of image
                    MOVEA.L        $28(SP),A2
                    MOVEA.L        A2,A1                    ; start of buffer
                    BSR.W          zlib_inflate
                    BNE.S          .PNGreturn
                    MOVEM.W        $30(SP),D2/D6            ; image width, height
                    LSL.L          #2,D2                    ; * 4 bytes per pixel
                    MOVE.L         D4,D5                    ; is either 0 or 4
                    BNE.S          .bytesperpixelset
                    SUB.W          $30(SP),D2               ; RGB only, no alpha
                    MOVEQ          #3,D5                    ; 3 bytes per pixel
.bytesperpixelset   SUBQ.L         #1,D6                    ; reduce 1 for DBRA
                    MOVE.L         D6,D1                    ; count of first row
.filternextrow      MOVEA.L        A2,A0                    ; filter byte of row
                    MOVE.L         D2,D0                    ; data bytes per row
                    SUBQ.L         #1,D0                    ; reduce 1 for DBRA
                    MOVE.B         (A2)+,D3                 ; filter type
                    BLE.S          .filter0
                    SUBQ.B         #2,D3
                    BEQ.S          .filter2
                    MOVEA.L        A2,A1                    ; first pixel in row
                    BCS.S          .filter1
                    SUBQ.B         #2,D3
                    BCS.S          .filter3
                    BEQ.S          .filter4
.filter0            ADDA.L         D2,A2                    ; skip this row
                    BRA.S          .countdownrows

.filter1            ADDA.L         D5,A2                    ; skip n bytes/pixel
                    SUB.L          D5,D0
                    BCS.S          .countdownrows
.filter1nextbyte    MOVE.B         (A1)+,D3
                    ADD.B          D3,(A2)+                 ; 100 % of the left
                    DBRA           D0,.filter1nextbyte
                    BRA.S          .countdownrows

.filter2            CMP.L          D1,D6                    ; is it the 1. row ?
                    BEQ.S          .filter0
                    SUBA.L         D2,A0                    ; the position above
.filter2nextbyte    MOVE.B         (A0)+,D3
                    ADD.B          D3,(A2)+                 ; 100 % of the upper
                    DBRA           D0,.filter2nextbyte
                    BRA.S          .countdownrows

.filter3            CMP.L          D1,D6                    ; is it the 1. row ?
                    BNE.S          .filter3belowtop
                    ADDA.L         D5,A2                    ; skip n bytes/pixel
                    SUB.L          D5,D0
                    BCS.S          .countdownrows
.filter3firstrow    MOVE.B         (A1)+,D3
                    LSR.B          #1,D3                    ; 50 % of the left
                    ADD.B          D3,(A2)+
                    DBRA           D0,.filter3firstrow
                    BRA.S          .countdownrows

.filter3belowtop    SUBA.L         D2,A0
                    MOVE.L         D5,D4                    ; bytes per pixel
                    SUBQ.L         #1,D4
.filter3countbpp    MOVE.B         (A0)+,D3
                    LSR.B          #1,D3                    ; 50 % of the upper
                    ADD.B          D3,(A2)+
                    DBRA           D4,.filter3countbpp
                    SUB.L          D5,D0
                    BCS.S          .countdownrows
.filter3nextbyte    MOVE.B         (A0)+,D3
                    ADD.B          (A1)+,D3
                    ROXR.B         #1,D3                    ; the average of both
                    ADD.B          D3,(A2)+
                    DBRA           D0,.filter3nextbyte
.countdownrows      DBRA           D1,.filternextrow
                    BRA.S          .setalphachannel

.filter4            CMP.L          D1,D6                    ; is it the 1. row ?
                    BEQ.S          .filter1
                    SUBA.L         D2,A0
                    MOVEA.L        A0,A4
                    MOVE.L         D5,D4
                    SUBQ.L         #1,D4
.filter4countbpp    MOVE.B         (A0)+,D3
                    ADD.B          D3,(A2)+                 ; 100 % of the upper
                    DBRA           D4,.filter4countbpp
                    SUB.L          D5,D0
                    BCS.S          .countdown4rows
.filter4nextbyte    MOVEQ          #0,D3
                    MOVEQ          #0,D4
                    MOVE.B         (A1)+,D3                 ; get A = left
                    MOVE.B         (A4)+,D4                 ; get C = upper left
                    SUB.W          D4,D3                    ; A - C
                    MOVEA.W        D3,A6
                    BPL.S          .absolutevaluePB
                    NEG.W          D3
.absolutevaluePB    SWAP           D3
                    MOVE.B         (A0)+,D3                 ; get B = upper
                    SUB.W          D4,D3                    ; B - C
                    MOVE.W         D3,D4
                    BPL.S          .absolutevaluePA
                    NEG.W          D4
.absolutevaluePA    ADD.W          A6,D3                    ; A - C + B - C
                    BPL.S          .absolutevaluePC
                    NEG.W          D3
.absolutevaluePC    MOVEA.L        A1,A6
                    CMP.W          D4,D3                    ; D4 = PA,   D3 = PC
                    BCC.S          .PAlowerorsamePC
                    SWAP           D3                       ;            D3 = PB
                    BRA.S          .PAisntthelowest

.PAlowerorsamePC    SWAP           D3
                    CMP.W          D4,D3                    ; D4 = PA,   D3 = PB
                    BCC.S          .sendlowestvalue
.PAisntthelowest    MOVE.L         D3,D4
                    SWAP           D3
                    MOVEA.L        A0,A6
                    CMP.W          D4,D3                    ; D4 = PB,   D3 = PC
                    BCC.S          .sendlowestvalue
                    MOVEA.L        A4,A6
.sendlowestvalue    MOVE.B         -(A6),D3
                    ADD.B          D3,(A2)+
                    DBRA           D0,.filter4nextbyte
.countdown4rows     DBRA           D1,.filternextrow
.setalphachannel    MOVEM.W        $30(SP),D0/D4            ; width, height
                    MULU.W         D0,D4                    ; number of pixels
                    SUBQ.L         #1,D0
                    MOVEA.L        $28(SP),A0               ; start of buffer
                    SUBQ.L         #3,D5
                    BEQ.S          .noalphachannel
                    MOVEA.L        A0,A1                    ; A1 is long aligned
.donextbufferrow    MOVE.L         D0,D2                    ; width - 1
.writealphafirst    MOVE.B         4(A0),(A0)               ; move alpha to left
 ifd MC68020
                    MOVE.L         (A0)+,(A1)+              ; drop filter bytes
 else
                    MoveOddLong    A0,D1
                    MOVE.L         D1,(A1)+
 endif
                    DBRA           D2,.writealphafirst
                    ADDQ.W         #1,A0
                    DBRA           D6,.donextbufferrow
.filteringisdone    MOVE.L         $28(SP),$34(SP)          ; start of image
                    MOVE.L         A1,$38(SP)               ; end of image
                    MOVEA.L        A3,A4                    ; for PNG detection
                    BRA.W          .storeblocknumber

.noalphachannel
 ifd MC68020
                    LEA            (A0,D4.L*4),A0           ; end of image
 else
                    MOVE.L         D4,D1
                    LSL.L          #2,D1
                    ADDA.L         D1,A0
 endif     
                    MOVEA.L        A0,A1
                    MOVEQ          #-1,D1
.previousRGBrow     MOVE.L         D0,D2
 ifd MC68020
.addalphachannel    MOVE.L         -(A2),-(A0)              ; move xRGB to end
                    ADDQ.W         #1,A2
                    MOVE.B         D1,(A0)                  ; set alpha to 255
 else
.addalphachannel    MOVE.B         -(A2),-(A0)
                    MOVE.B         -(A2),-(A0)
                    MOVE.B         -(A2),-(A0)
                    MOVE.B         D1,-(A0)
 endif
                    DBRA           D2,.addalphachannel
                    SUBQ.W         #1,A2                    ; skip filter bytes
                    DBRA           D6,.previousRGBrow
                    BRA.S          .filteringisdone

                    ;---------------------------------------- OS 3.5 / 4.0 icons

.diskmagicfound     MOVE.L         D4,D3                    ; icon file size
                    MOVEA.L        $2C(SP),A0               ; icon file buffer
                    MOVEA.L        A3,A1                    ; new V44 DiskObject
                    MOVEQ          #$4E,D0                  ; sizeof DiskObject
                    SUB.L          D0,D3                    ; remaining bytes
                    BSR.W          CopyMemAligned
                    MOVE.L         A0,$44(SP)               ; current position
                    MOVE.L         D3,$48(SP)               ; remaining bytes
                    TST.B          D6                       ; flag for disk.info
                    BEQ.S          .checkappicon
                    MOVE.B         #WBDISK,do_Type(A3)
.checkappicon       MOVE.B         do_Type(A3),D0
                    BLE.W          .wrongtype
                    SUBQ.B         #WBAPPICON,D0
                    BHI.W          .wrongtype
                    BNE.S          .noappicon
                    MOVE.B         #WBPROJECT,do_Type(A3)
.noappicon          MOVEA.L        A5,A6                    ; iconbase
                    TST.L          do_DrawerData(A3)
                    BNE.S          .allocdrawer
                    MOVE.B         do_Type(A3),D0
                    SUBQ.B         #1,D0                    ; 1 = WBDISK
                    BEQ.S          .allocdrawer
                    SUBQ.B         #1,D0                    ; 2 = WBDRAWER
                    BEQ.S          .allocdrawer
                    SUBQ.B         #3,D0                    ; 5 = WBTRASHCAN
                    BNE.S          .drawerdone
.allocdrawer        LEA            $4E(A3),A0               ; freelist
                    MOVEA.W        #$3E,A1                  ; sizeof DrawerData
                    MOVEA.W        #MEMF_PUBLIC,A2
                    BSR.W          FreeAlloc                ; needs no iconbase
                    MOVEA.L        D0,A1                    ; buffer as allocated
                    TST.L          do_DrawerData(A3)
                    BEQ.S          .getdefdrawer
                    MOVE.L         D0,do_DrawerData(A3)     ; new struct drawer
                    BEQ.W          .nofreestore
                    MOVEQ          #$38,D0                  ; size-flags-viewmodes
                    SUB.L          D0,$48(SP)               ; remaining - required
                    BCS.W          .endofbuffer
                    MOVEA.L        $44(SP),A0               ; current position
                    ADD.L          D0,$44(SP)               ; final copy position
                    BSR.W          CopyMemBlock             ; A1 is re-used
                    CLR.L          (A1)+                    ; clear dd_Flags
                    CLR.W          (A1)                     ; clear dd_ViewModes
                    MOVEA.L        do_DrawerData(A3),A1     ; struct drawer
 ifd MC68020
                    TST.W          4(A1)                    ; drawer width = 0 ?
                    BEQ.S          .getdefdrawer
                    TST.W          6(A1)                    ; drawer height = 0 ?
 else
                    LEA            4(A1),A0
                    MOVE.B         (A0)+,D0
                    TST.B          (A0)+
                    BNE.S          .checkheight
                    TST.B          D0
                    BEQ.S          .getdefdrawer
.checkheight        TST.B          (A0)+
                    BNE.S          .drawerdone
                    TST.B          (A0)
 endif
                    BNE.S          .drawerdone
.getdefdrawer       LEA            DefDrawerData(PC),A0
                    MOVE.L         A1,do_DrawerData(A3)     ; new struct drawer
                    BEQ.W          .nofreestore
                    MOVEQ          #$3E,D0                  ; sizeof DrawerData
                    BSR.W          CopyMemAligned
.drawerdone         LEA            $16(A3),A0               ; GadgetRender
                    LEA            $4E(A3),A2               ; freelist
                    BSR.W          readplanarimage
                    BEQ.W          .readingdone             ; bad DiskObject data
                    TST.L          (A0)                     ; SelectRender ?
                    BEQ.S          .oneimageonly
                    BSR.W          readplanarimage
                    BEQ.W          .readingdone             ; bad DiskObject data
.oneimageonly       TST.L          do_DefaultTool(A3)
                    BEQ.S          .testtooltypes
                    LEA            do_DefaultTool(A3),A0    ; string pointer
                    BSR.W          readtoolstring
                    BNE.S          .baddefaulttool          ; D5 with error code
.testtooltypes      TST.L          do_ToolTypes(A3)
                    BEQ.W          .tooltypesdone
                    MOVEQ          #4,D0                    ; 4 bytes for tt-size
                    SUB.L          D0,$48(SP)               ; remaining - required
                    BCS.S          .endofbuffer
                    MOVEA.L        $44(SP),A0               ; current position
                    ADD.L          D0,$44(SP)               ; final copy position
 ifd MC68020
                    MOVE.L         (A0),D0                  ; size of tt-array
 else
                    MoveOddLong    A0,D0
 endif
                    MOVE.L         D0,D4
                    LSR.L          #2,D4                    ; size in longwords
                    SUBQ.L         #1,D4
                    BLE.S          .badtooltypes            ; less than 2 longs ?
                    MOVEA.L        A2,A0                    ; freelist
                    MOVEA.L        D0,A1                    ; sizeof tooltypes
                    CMPA.W         #4000,A1                 ; > 1000 longs ?
                    BCC.S          .badtooltypes
                    MOVEA.W        #MEMF_PUBLIC,A2
                    BSR.W          FreeAlloc                ; needs no iconbase
                    MOVE.L         D0,do_ToolTypes(A3)
                    BEQ.W          .nofreestore
                    ASL.L          #2,D4                    ; longs to bytes
                    MOVEQ          #0,D6
                    LEA            $4E(A3),A2               ; freelist
                    BRA.S          .readtooltypes

.endofbuffer        MOVEQ          #$74,D5
                    ADD.L          D5,D5                    ; no more entries
                    BRA.W          .readingdone

.badtoolstring      MOVEA.L        do_ToolTypes(A3),A0
                    CLR.L          (A0,D6.W)                ; clear last pointer
                    BRA.S          .badtoolwindow

.baddefaulttool     CLR.L          do_DefaultTool(A3)
.badtooltypes       LEA            longwordfor0000(PC),A0   ; empty toolarray
                    MOVE.L         A0,do_ToolTypes(A3)
.badtoolwindow      CLR.L          do_ToolWindow(A3)
                    MOVEQ          #$4E,D0                  ; size of DiskObject
                    ADD.L          $2C(SP),D0               ; + icon file buffer
                    MOVEM.L        D0/D3,$44(SP)            ; position and bytes
                    BRA.S          .find_FORM_chunk

.nexttooltype       ADDA.L         D6,A0                    ; toolstring pointer
                    ADDQ.L         #4,D6
                    BSR.W          readtoolstring
                    BNE.S          .badtoolstring           ; D5 with error code
.readtooltypes      MOVEA.L        do_ToolTypes(A3),A0
                    CMP.L          D4,D6                    ; tooltypes done ?
                    BLT.S          .nexttooltype
                    CLR.L          (A0,D4.W)                ; clear last pointer
.tooltypesdone      TST.L          do_ToolWindow(A3)
                    BEQ.S          .toolwindowdone
                    BSR.W          readtoolstring
                    BNE.S          .badtoolwindow           ; D5 with error code
.toolwindowdone     MOVEA.L        $2C(SP),A0               ; icon file buffer
                    TST.L          do_DrawerData(A0)        ; bugfix for AfA_OS
                    BEQ.S          .find_FORM_chunk
                    MOVEQ          #1,D0
                    CMP.B          $2C+3(A3),D0             ; UserData = 1 ?
                    BNE.S          .find_FORM_chunk
                    SUBQ.L         #6,$48(SP)               ; remaining - 6 bytes
                    BCS.W          .useplanarimages
                    MOVEA.L        $44(SP),A0               ; current position
                    ADDQ.L         #6,$44(SP)               ; final copy position
                    MOVEA.L        do_DrawerData(A3),A1
                    ADDA.W         #dd_Flags,A1
 ifd MC68020
                    MOVE.L         (A0)+,(A1)+              ; copy dd_Flags
                    MOVE.W         (A0),(A1)                ; copy dd_ViewModes
 else
                    MOVE.B         (A0)+,(A1)+
                    MOVE.B         (A0)+,(A1)+
                    MOVE.B         (A0)+,(A1)+
                    MOVE.B         (A0)+,(A1)+
                    MOVE.B         (A0)+,(A1)+
                    MOVE.B         (A0),(A1)
 endif
.find_FORM_chunk    MOVEQ          #-26,D0                  ; need 26 FORM bytes
                    ADD.L          $48(SP),D0               ; remaining in buffer
                    BLE.W          .useplanarimages
                    MOVEA.L        $44(SP),A4               ; current position
                    SUBQ.L         #1,D0
                    MOVE.L         D0,D1
                    SWAP           D1                       ; high word counter
                    MOVEQ          #"F",D2
.find_FORM          CMP.B          (A4)+,D2
.nextposition       DBEQ           D0,.find_FORM
                    DBEQ           D1,.find_FORM
                    BNE.W          .useplanarimages
 ifd MC68020
                    CMPI.L         #"FORM",-1(A4)
 else
                    CMPI.B         #"O",(A4)
                    BNE.S          .nextposition
                    CMPI.B         #"R",1(A4)
                    BNE.S          .nextposition
                    CMPI.B         #"M",2(A4)
 endif
                    BNE.S          .nextposition
                    ADDQ.W         #3,A4
 ifd MC68020
                    MOVEM.L        (A4)+,D1-D4              ; D1 = FORM size
 else
                    MoveOddLong    A4,D1
                    MoveOddLong    A4,D2
                    MoveOddLong    A4,D3
                    MoveOddLong    A4,D4
 endif
                    SUBI.L         #"ICON",D2               ; ICON ?
                    BNE.W          .useplanarimages
                    SUBI.L         #"FACE",D3               ; FACE header ?
                    BNE.W          .wrongtype
                    SUBQ.L         #6,D4                    ; header size = 6 ?
                    BNE.W          .wrongtype
                    MOVEQ          #0,D0
                    MOVE.B         (A4)+,D0                 ; width - 1
                    ADDQ.W         #1,D0
                    MOVE.L         D0,D4
                    SWAP           D0
                    MOVE.B         (A4)+,D0                 ; height - 1
                    ADDQ.W         #1,D0
                    MULU.W         D0,D4                    ; full size of image
                    BTST.B         #0,(A4)                  ; frameless flag ?
                    BEQ.S          .noframelessflag
                    BSET.B         #0,$8A(A3)               ; force frameless icon
.noframelessflag    ADDQ.W         #4,A4                    ; skip to IMAG or ARGB
 ifd MC68020
                    CMPI.L         #"ARGB",(A4)             ; v44 image ?
 else
                    MoveOddLong    A4,D2
                    SUBQ.W         #4,A4
                    CMPI.L         #"ARGB",D2
 endif
                    BNE.S          .imagesizeok
                    TST.W          D4                       ; bugfix for bad ARGBs
                    BNE.S          .imagesizeok             ; no fake size of 64kB
                    BTST.B         #1,-4(A4)                ; ARGB flag bit 1 set?
                    BNE.S          .imagesizeok
                    MOVE.W         $C(A3),D4                ; use gadget width
                    MOVE.L         $C(A3),D0                ; gadget width, height
                    MULU.W         D0,D4                    ; full size of image
.imagesizeok        MOVE.L         $48(SP),D2               ; remaining bytes
                    MOVE.L         D0,$48(SP)               ; store width, height
                    ADD.L          $44(SP),D2               ; bytes + old position
                    SUB.L          A4,D2                    ; bytes - new position
                    MOVEQ          #18,D0
                    SUB.L          D0,D1                    ; 18 bytes read now
                    BLS.W          .useplanarimages
                    SUB.L          D1,D2                    ; remaining - required
                    BCS.W          .useplanarimages
                    MOVE.L         D1,D3                    ; remaining FORM size
.sharetempbuffer    MOVE.L         D4,D0                    ; number of pixels
                    LSL.L          #2,D0                    ; full ARGB image size
 ifd Scalers
                    TST.B          $8D(A3)                  ; image scaling on ?
                    BLE.S          .nosizeupscaling
                    ADD.L          D0,D0
                    ADD.L          D4,D0                    ; 900 % of image size
 endif
.nosizeupscaling    MOVEQ          #MEMF_PUBLIC,D1
                    MOVEA.L        $26(A5),A6               ; execbase
                    JSR            _LVOAllocVec(A6)
.storetempbuffer    MOVE.L         D0,$28(SP)               ; temp decode buffer
.notempbuffermem    BEQ.W          .nofreestore
                    MOVE.L         D0,$34(SP)               ; decoded image start
.readagain
.decodetheimages    MOVE.L         $48(SP),$30(SP)          ; original image w h
 ifd MC68020
                    MOVE.L         (A4)+,D0
 else
                    MoveOddLong    A4,D0
 endif
                    CMPI.L         #"ARGB",D0               ; OS4 image ?
                    BEQ.W          .decode_ARGB
                    CMPI.L         #"IMAG",D0               ; v44 image ?
                    BNE.W          .readingdone
                    MOVE.B         7(A4),D0                 ; compressed image
                    SUBQ.B         #1,D0                    ; BOOL ?
                    BHI.W          .wrongIMAGtype
                    MOVE.B         8(A4),D0                 ; compressed colormap
                    SUBQ.B         #1,D0                    ; BOOL ?
                    BHI.W          .wrongIMAGtype
                    MOVEQ          #0,D0
 ifd MC68020
                    MOVE.W         $A(A4),D0                ; compressed size - 1
 else
                    MOVE.B         $A(A4),-(SP)
                    MOVE.W         (SP)+,D0
                    MOVE.B         $B(A4),D0
 endif
                    MOVEQ          #1+10,D1
                    ADD.L          D1,D0
                    BTST.B         #1,6(A4)
                    BEQ.S          .sharecolormap1
 ifd MC68020
                    MOVE.W         $C(A4),D1                ; compressed cmap - 1
 else
                    MOVE.B         $C(A4),-(SP)
                    MOVE.W         (SP)+,D1
                    MOVE.B         $D(A4),D1
 endif
                    ADDQ.L         #1,D1
                    ADD.L          D1,D0
.sharecolormap1
 ifd MC68020
                    CMP.L          (A4),D0                  ; more than data size?
 else
                    MoveOddLong    A4,D6
                    SUBQ.W         #4,A4
                    CMP.L          D6,D0
 endif
                    BHI.W          .wrongIMAGtype
                    MOVEQ          #0,D6
                    BTST.B         #1,6(A4)
                    BNE.S          .usecolormap2
                    TST.L          $76(A3)
                    BNE.S          .createthePalMap
                    MOVEQ          #$74,D5                  ; should call .readingdone
                    BRA.W          .readmorefiledata        ; fix AfA + bad Aros icons

.allocmemforPalMap  ADDQ.L         #3,D5                    ; rounded up to
                    ANDI.B         #$FC,D5                  ; longword size
                    LEA            $4E(A3),A0               ; freelist
                    ADDA.L         D5,A1                    ; image bytes
                    ADDA.W         #$120,A1                 ; size of PalMap
                    LEA            MEMF_PUBLIC|MEMF_CLEAR,A2
                    BSR.W          FreeAlloc                ; needs no iconbase
                    BEQ.W          .returnnomem
                    MOVEA.L        D0,A6                    ; new PalMap structure
                    MOVE.L         $30+4(SP),(A6)           ; PalMap width, height
                    LEA            $120(A6),A0
                    MOVE.L         A0,4(A6)                 ; * chunky image bytes
                    MOVEA.L        A0,A1
                    ADDA.L         D5,A1                    ; + long size of image
                    MOVE.L         A1,$108(A6)              ; * colormap RGB bytes
                    RTS                                     ; A0=pixels, A1=colors

.usecolormap2       MOVE.B         5(A4),D6
                    ADDQ.L         #1,D6                    ; number of i-colors
.createthePalMap    MOVE.L         D4,D5                    ; full size of image
 ifd RLEjit
                    ADDQ.L         #8,D5                    ; to align RLE data
 endif
                    MOVE.L         D6,D2
                    ADD.L          D2,D2
                    ADD.L          D6,D2                    ; 3 * i-colors
                    MOVEA.L        D2,A1
                    BSR.S          .allocmemforPalMap
                    BTST.B         #0,6(A4)                 ; transparency used ?
                    BEQ.S          .notransparency
                    SNE            $10C(A6)                 ; set transparency on
                    MOVE.B         4(A4),$10D(A6)           ; transparent color
.notransparency     MOVE.W         D6,$10E(A6)              ; number of i-colors
                    MOVEQ          #0,D5                    ; no error code yet
                    MOVEQ          #0,D6
 ifd MC68020
                    MOVE.W         $A(A4),D6
 else
                    MOVE.B         $A(A4),-(SP)
                    MOVE.W         (SP)+,D6
                    MOVE.B         $B(A4),D6
 endif
                    ADDQ.L         #1,D6                    ; sizeof comp image
                    MOVEA.L        4(A6),A1                 ; target
                    LEA            $E(A4),A2                ; temp buffer offset
                    TST.B          7(A4)                    ; compressed image ?
 ifd RLEjit
                    BEQ.S          .copychunkyimage
                    MOVEQ          #0,D1
                    MOVE.B         9(A4),D1                 ; compression bit depth         
                    TST.L          $76(A3)                  ; PalMap1 done ?
                    BEQ.S          .decompressimage
                    TST.W          DOstack+$286(SP)         ; color mapping wanted?
                    BEQ.S          .decompressimage         ; for IconEdit, AsyncWB ...
                    MOVE.L         D4,D0                    ; full size of image 2
                    SUB.L          D6,D0                    ; - RLE compressed size
                    BMI.S          .decompressimage         ; should never happen !
                    ADDQ.L         #8,D0                    ; offset for RLE data
                    ANDI.B         #$FC,D0                  ; align up to longwords
     ifd MC68020
                    LSL.L          #8,D1                    ; shift depth up 1 byte
                    MOVEA.L        D1,A0
     else
                    LSL.W          #8,D1
                    MOVEA.W        D1,A0                    ; 5 bytes data are safe
     endif
                    MOVEM.W        D0/D6/A0,(A1)            ; offset, z-size, depth
                    ADDA.L         D0,A1                    ; compressed data start
                    NOT.B          $11F(A6)                 ; set flag for RLE data
                    MOVE.L         D6,D0                    ; compressed image size
                    BRA.S          .compressedtoend         ; just copying RLE data
 else
                    BNE.S          .decompressimage
 endif
.copychunkyimage    CMP.L          D4,D6                    ; full size of image ?
                    BNE.S          .freenewPalMap
                    MOVE.L         D4,D0                    ; full size of image
.compressedtoend    MOVEA.L        A2,A0                    ; temp buffer pointer
                    ADDA.L         D0,A2                    ; new buffer position
                    BSR.W          CopyMemBlock             ; large copy !
                    BRA.S          .getcolormapRGBs

.decompressimage    MOVE.L         D6,D0                    ; size of comp image
 ifnd RLEjit
                    MOVEQ          #0,D1
                    MOVE.B         9(A4),D1                 ; image depth
 endif
                    MOVEA.L        D4,A0                    ; full size of image
                    BSR.W          decompressdata           ; A6 = PalMap
                    BNE.S          .freenewPalMap
                    ADDA.L         D6,A2                    ; new buffer offset
.getcolormapRGBs    BTST.B         #1,6(A4)                 ; duplicate cmap1 ?
                    BEQ.S          .copycolormapRGBs
                    MOVEQ          #0,D6
 ifd MC68020
                    MOVE.W         $C(A4),D6
 else
                    MOVE.B         $C(A4),-(SP)
                    MOVE.W         (SP)+,D6
                    MOVE.B         $D(A4),D6
 endif
                    ADDQ.L         #1,D6                    ; size of cmap RGBs
                    MOVEA.L        $108(A6),A1              ; target
                    MOVE.L         A1,$44(SP)               ; save the RGB pointer
                    TST.B          8(A4)                    ; compressed colormap ?
                    BNE.S          .decompresscolormap
                    CMP.L          D2,D6                    ; 3 * i-colors
                    BNE.S          .freenewPalMap
                    MOVE.L         D2,D0                    ; fullsize of colormap
                    MOVEA.L        A2,A0                    ; temp buffer
                    BSR.W          CopyMemBlock
                    BRA.S          .returnOS35PalMap

.decompresscolormap MOVE.L         D6,D0                    ; compressed cmap size
                    BSR.W          decompressdata\.decompresscolormap
                    BEQ.S          .returnOS35PalMap
.freenewPalMap      LEA            $4E(A3),A0               ; freelist
                    MOVEA.L        A6,A1                    ; new PalMap memblock
                    BSR.W          DOFreeRemove             ; needs no iconbase    
.wrongIMAGtype      MOVEQ          #$6A,D5
                    ADD.L          D5,D5                    ; should call .readingdone
 ifd Scalers
                    BRA.W          .readmorefiledata        ; fix AfA + bad Aros icons
 else
                    BRA.S          .readmorefiledata
 endif

.wrongtype          MOVEQ          #$6A,D5
                    ADD.L          D5,D5
                    BRA.W          .readingdone

.copycolormapRGBs   MOVEA.L        $76(A3),A0               ; PalMap1
                    MOVE.L         $44(SP),$108(A6)         ; use colormap 1 again
                    MOVE.W         $10E(A0),$10E(A6)        ; copy number of colors
.returnOS35PalMap
 ifd Scalers
                    TST.B          $8D(A3)                  ; is image scaling on ?
                    BEQ.S          .creatednewPalMap
                    MOVEA.L        4(A6),A0                 ; PalMap image bytes
                    MOVEA.L        $108(A6),A1              ; PalMap RGB colors
                    MOVEQ          #0,D2
                    MOVE.B         $10D(A6),D2              ; transparent color
                    TST.B          $10C(A6)                 ; transparency flag
                    SEQ            D1
                    BEQ.S          .setthealphavalue
                    MOVEQ          #-107,D0                 ; byte = 149
                    LEA            (A1,D2.W),A2
                    MOVE.B         D0,(A2)+                 ; set the transparent
                    MOVE.B         D0,(A2)+                 ; color always to gray
                    MOVE.B         D0,(A2)
.setthealphavalue   BSET.B         #6,D1                    ; alpha is 64 or 255
                    MOVEA.L        $34(SP),A2               ; start of ARGB array
                    MOVEQ          #0,D5
                    MOVE.L         D4,D0                    ; number of pixels
                    SUBQ.L         #1,D0
.buildanARGBarray   MOVE.B         (A0)+,D5                 ; current pixel color
                    CMP.B          D2,D5                    ; transparent color ?
                    SNE            (A2)
                    OR.B           D1,(A2)+                 ; build alpha value
                    MOVE.L         D5,D6
                    ADD.L          D5,D6
                    ADD.L          D5,D6
                    MOVE.B         (A1,D6.W),(A2)+          ; copy red component 
     ifd MC68020
                    MOVE.W         1(A1,D6.W),(A2)+         ; copy green and blue
     else
                    MOVE.B         1(A1,D6.W),(A2)+         ; copy green component
                    MOVE.B         2(A1,D6.W),(A2)+         ; copy blue component
     endif
                    DBRA           D0,.buildanARGBarray
                    MOVE.L         A2,$38(SP)               ; end of ARGB array
                    TST.L          $76(A3)                  ; PalMap1 done already?
                    BEQ.W          .ARGBimagescaling        ; preserve old PalMap1
                    LEA            $4E(A3),A0               ; freelist
                    MOVEA.L        A6,A1                    ; old PalMap2 memblock
                    BSR.W          DOFreeRemove             ; needs no iconbase    
                    BRA.W          .ARGBimagescaling
 endif
.creatednewPalMap                                           ; A6 = PalMap
                    TST.L          $76(A3)                  ; PalMap1 done before?
                    BNE.W          .isPalMap2
                    MOVE.L         A6,$76(A3)               ; PalMap1 = new PalMap
                    CMPA.L         A3,A4                    ; was it a PNG image ?
                    BEQ.W          .try_PNG_image2
                    MOVEQ          #0,D5                    ; no error code yet
.readmorefiledata                                           ; fix AfA + bad Aros icons
                                                            ; skip over trashed data
 ifd MC68020
                    MOVE.L         (A4)+,D0                 ; size of IMAG data
 else
                    MoveOddLong    A4,D0
 endif
                    ADDQ.L         #1,D0
                    ANDI.B         #$FE,D0                  ; make size even
                    ADDA.L         D0,A4                    ; skip to next IMAG
                    SUBQ.L         #8,D3
                    SUB.L          D0,D3                    ; remaining FORM bytes
                    BGT.W          .readagain
                    TST.L          D5                       ; was there an error ?
                    BNE.W          .readingdone
                    BTST.B         #6,$8A(A3)               ; get truecolor flag
                    BEQ.W          .returnnow
.addglowingimage    MOVEM.W        $30(SP),D0-D1            ; image1 width, height
                    MOVE.L         D0,D4
                    MULU.W         D1,D4                    ; number of pixels
.addimage2effect    MOVEA.L        $34(SP),A0               ; start of 1. image
 ifd HBbuf2         ;--------------------------------
                    MOVE.L         D4,D0                    ; number of pixels
                    SUBQ.L         #1,D0
                    MOVEQ          #3,D6                    ; transparency mask
.halfbrightness     CMP.B          (A0)+,D6
                    BCC.S          .transparentpixel
                    MOVE.B         (A0),D1
                    LSR.B          #1,D1          
                    MOVE.B         D1,(A0)+
                    MOVE.B         (A0),D1
                    LSR.B          #1,D1          
                    MOVE.B         D1,(A0)+
                    MOVE.B         (A0),D1
                    LSR.B          #1,D1          
                    MOVE.B         D1,(A0)+
.trynextdarkpixel   DBRA           D0,.halfbrightness
                    TST.L          $6A(A3)                  ; was TCbuf1 used ?
                    BEQ.S          .simplehalfbright
                    LEA            $4E(A3),A0               ; freelist
                    MOVEA.L        D2,A1                    ; number of ARGB bytes
                    ADDQ.W         #4,A1                    ; space for freelist
                    MOVEA.W        #MEMF_PUBLIC,A2          ; attributes
                    BSR.W          FreeAlloc                ; needs no iconbase
                    MOVE.L         D0,$7E(A3)               ; store it temporarily 
                    BEQ.S          .simplehalfbright
                    LEA            $4E(A3),A0               ; freelist
                    MOVEA.L        D0,A1                    ; buffer image copy
                    MOVE.L         A0,(A1)+                 ; upload *freelist
                    MOVEA.L        $34(SP),A0               ; TCbuf1 image data
                    MOVE.L         D2,D0                    ; number of ARGB bytes
                    BSR.W          CopyMemBlock
.simplehalfbright   MOVE.L         D4,D5                    ; number of pixels
                    BRA.W          .createARGBborder

.transparentpixel   ADDQ.W         #3,A0
                    BRA.S          .trynextdarkpixel
 else               ;--------------------------------
                    MOVEA.L        A0,A1
                    MOVE.L         D0,D2                    ; width
                    MOVE.L         #$00FFFFE2,D6            ; white with yellow
                    SUBQ.L         #3,D1
                    BCS.S          .imageistoosmall
                    SUBQ.L         #3,D2
.imageistoosmall    BCS.W          .readingdone
.glowingatthetop    OR.L           D6,(A1)+                 ; yellow glowing 1.
                    CLR.B          -1(A1)
                    DBRA           D0,.glowingatthetop
                    MOVE.L         D2,D0
                    MOVEA.L        A1,A2
                    SUBQ.W         #4,A1         
.glowingonsecond    MOVE.B         (A2),D5
                    OR.L           D6,(A2)+                 ; white glowing 2.
                    MOVE.B         D6,-1(A2)
                    CMP.B          -8(A2),D5
                    BEQ.S          .setwhiteglowing
                    CLR.B          -5(A2)
                    CLR.B          -1(A2)
.setwhiteglowing    DBRA           D0,.glowingonsecond
                    OR.L           D6,(A2)+
                    CLR.B          -1(A2)
.tonextimageline    MOVE.L         D2,D0
                    ADDQ.W         #8,A0                    ; third pixel line 1
                    ADDQ.W         #8,A1                    ; third pixel line 2
                    OR.L           D6,(A2)+                 ; glowing 1. pixel
                    CLR.B          -1(A2)
                    MOVE.B         (A2),D5
                    OR.L           D6,(A2)+                 ; glowing 2. pixel
                    MOVE.B         D6,-1(A2)
                    CMP.B          -4(A1),D5
                    BEQ.S          .checkalphavalue
                    CLR.B          -1(A1)
                    CLR.B          -1(A2)
.checkalphavalue    MOVE.B         (A2),D5
                    CMP.B          -8(A2),D5
                    BNE.S          .glowingsequence
                    TST.W          D0                       ; end of line now ?
                    BNE.S          .sequencechecked
                    OR.L           D6,-4(A2)                ; glowing last pixels
                    MOVE.B         D6,-1(A2)
                    BRA.S          .lastpixelonline

.glowingsequence    OR.L           D6,-4(A2)
                    CLR.B          -1(A2)
                    CMP.B          -4(A2),D5
                    BNE.S          .sequenceglowWYY
                    OR.L           D6,-8(A2)
                    CLR.B          -5(A2)
                    MOVE.L         D6,(A2)
                    MOVE.B         D5,(A2)
                    BRA.S          .sequencechecked

.sequenceglowWYY    TST.W          D1                       ; on the last line ?
                    BEQ.S          .sequencechecked
                    OR.L           D6,-8(A2)
                    MOVE.B         D6,-5(A2)
.lastpixelonline    OR.L           D6,(A2)
                    CLR.B          3(A2)
.sequencechecked    CMP.B          (A0),D5
                    BNE.S          .verticalglowing
                    TST.W          D1                       ; on the last line ?
                    BNE.S          .verticalchecked
                    CMPI.L         #$FFFFFF00,(A1)          ; is this yellow ?
                    BEQ.S          .skipwhitebottom
                    OR.L           D6,(A1)
                    MOVE.B         D6,3(A1)                 ; white bottom line
.skipwhitebottom    CLR.B          -1(A2)
                    BRA.S          .lastverticalrow

.verticalglowing    OR.L           D6,(A1)
                    CLR.B          3(A1)
                    CMP.B          (A1),D5
                    BNE.S          .verticalglowWYY
                    OR.L           D6,(A0)
                    CLR.B          3(A0)
                    TST.W          D0                       ; end of line now ?
                    BEQ.S          .verticalchecked
                    TST.W          D1                       ; on the last line ?
                    BEQ.S          .lastverticalrow
                    MOVE.L         D6,(A2)
                    MOVE.B         D5,(A2)
                    BRA.S          .verticalchecked

.verticalglowWYY    MOVE.L         (A0),D5
                    CMP.L          (A1),D5
                    BEQ.S          .lastverticalrow
                    MOVE.L         D6,(A0)
                    MOVE.B         (A1),(A0)
.lastverticalrow    OR.L           D6,(A2)                  ; yellow last line
                    CLR.B          3(A2)
.verticalchecked    ADDQ.W         #4,A0
                    ADDQ.W         #4,A1
                    ADDQ.W         #4,A2
                    DBRA           D0,.checkalphavalue
                    DBRA           D1,.tonextimageline
                    MOVE.L         D4,D5                    ; number of pixels
                    BRA.W          .convertintoPalMap
 endif

.isPalMap2          MOVE.L         A6,$7A(A3)               ; PalMap2 = new PalMap
                    MOVEA.L        $76(A3),A4               ; PalMap1
                    MOVE.W         $10E(A4),D2              ; number of colors 1
                    MOVE.W         $10E(A6),D3              ; number of colors 2
                    CMP.W          D2,D3                    ; PalMap2 > PalMap1 ?
                    BLS.S          .PalMapsfinished
                    MOVEA.L        DOstack+$280(SP),A0      ; this task from GITL
                    CMPA.L         $974(A5),A0              ; is this Workbench ?
                    BEQ.S          .PalMapsfinished
                    TST.B          $978(A5)                 ; other GUI possible ?
                    BLE.S          .PalMapsfinished
                    MOVEA.L        $A(A0),A0                ; *name of this task
                    CMP.L          #"AmiS",(A0)+
                    BNE.S          .fixforIconEdit
                    CMP.L          #"tart",(A0)             ; is this AmiStart ?
                    BEQ.S          .PalMapsfinished
.fixforIconEdit     MOVE.W         D3,$10E(A4)              ; bugfix for IconEdit
                    BTST.B         #6,$8A(A3)               ; get truecolor flag
                    BNE.S          .clearfakedcolors        ; can store 256 RGBs
                    LEA            $4E(A3),A0               ; freelist
                    MOVE.L         A4,D1                    ; small source PalMap1
                    BSR.W          copyPalMap               ; enlarge the colormap
                    BEQ.S          .setcolorcounter1
                    MOVE.L         D0,$76(A3)               ; use a larger PalMap1
                    LEA            $4E(A3),A0               ; freelist
                    MOVEA.L        A4,A1                    ; free source PalMap1
                    MOVEA.L        D0,A4
                    BSR.W          DOFreeRemove             ; needs no iconbase    
.clearfakedcolors   MOVEA.L        $108(A4),A0              ; colormap RGB bytes
                    ADD.W          D2,A0
                    ADD.W          D2,A0
                    ADD.W          D2,A0                    ; start of unused RGBs
                    SUB.W          D2,D3
                    SUBQ.W         #1,D3
.clearunusedRGBs    CLR.B          (A0)+                    ; unused RGBs to black
 ifd MC68020
                    CLR.W          (A0)+
 else
                    CLR.B          (A0)+
                    CLR.B          (A0)+
 endif
                    DBRA           D3,.clearunusedRGBs
.setcolorcounter1   MOVE.W         D2,$10E(A4)
.PalMapsfinished    BRA.W          .returnnow

.decode_ARGB        ;-----------------------------------------------------------
 ifd MC68020
                    MOVE.L         8(A4),D0                 ; z-image size - 1
 else
                    LEA            8(A4),A0
                    MoveOddLong    A0,D0
 endif
.ARGB_zimagedata    ADDQ.L         #1,D0                    ; z-image size
                    LEA            $E(A4),A0                ; z-image buffer
.uncompressOS4img   MOVEA.L        $34(SP),A1               ; decoded image top
                    MOVE.L         A1,$38(SP)
                    MOVE.L         D4,D1
                    LSL.L          #2,D1                    ; + 4 * full size
                    ADD.L          D1,$38(SP)               ; end of full image
                    BSR.W          zlib_inflate
                    BNE.W          .readingdone
.storeblocknumber
 ifd MC68020
                    LEA            do_Gadget+gg_GadgetText(A3),A2
                    TST.L          (A2)                     ; get FileBlockNumber
                    BNE.S          .ARGBimagescaling  
                    MOVE.L         D7,D1                    ; filehandle
                    MOVEA.L        $2A(A5),A6               ; dosbase
                    JSR            _LVODupLockFromFH(A6)
                    MOVE.L         D0,D1                    ; lock on name.info
                    BEQ.S          .ARGBimagescaling
                    LSL.L          #2,D0                    ; convert BCPL pointer
                    MOVEA.L        D0,A0                    ; struct FileLock
                    MOVE.L         fl_Key(A0),(A2)          ; set FileBlockNumber  
                    JSR            _LVOUnLock(A6)
 endif
.ARGBimagescaling
 ifd Scalers
                    TST.B          $8D(A3)                  ; image scaling on ?
                    BEQ.S          .writeARGBtoPalMap
                    LEA            $30(SP),A0
                    BPL.S          .doarrayupscaling                    
                    MOVEM.W        (A0)+,D0-D1              ; image width, height
                    MOVEA.L        (A0),A0                  ; start of image
                    MOVEA.L        A0,A1
                    SUBQ.L         #1,D0                    ; original width - 1
                    SUBQ.L         #1,D1                    ; original height - 1
                    MOVEQ          #0,D6                    ; scaled line counter
.scaledownnextline  MOVE.L         D0,D2                    ; save full width - 1
                    PEA            .nextARGBpixelline(PC)
.scaledownARGBline  MOVE.L         (A0)+,(A1)+
                    SUBQ.L         #1,D0                    ; width - 1
                    BMI.S          .onelinescaleddown
                    MOVE.L         (A0)+,(A1)+
                    SUBQ.L         #1,D0                    ; width - 1
                    BMI.S          .onelinescaleddown
                    ADDQ.W         #4,A0                    ; skip the third pixel
                    DBRA           D0,.scaledownARGBline
.onelinescaleddown  RTS

.nextARGBpixelline  TST.L          D6                       ; first line scaled ?
                    BNE.S          .scaledwidthstored
                    MOVE.L         A0,D6                    ; original position
                    SUB.L          A1,D6                    ; - scaled position
                    LSR.L          #2,D6                    ; removed pixel count
                    SWAP           D6
.scaledwidthstored  SUBQ.L         #1,D1                    ; height - 1
                    BMI.S          .ARGBscaledowndone
                    MOVE.L         D2,D0                    ; original width - 1
                    BSR.S          .scaledownARGBline
                    SUBQ.L         #1,D1                    ; height - 1
                    BMI.S          .ARGBscaledowndone
                    MOVE.L         D2,D0                    ; original width - 1
                    LSL.L          #2,D2
                    ADDA.L         D2,A0
                    ADDQ.W         #4,A0                    ; skip a complete line
                    ADDQ.W         #1,D6                    ; count skipped lines
                    DBRA           D1,.scaledownnextline
.ARGBscaledowndone  SUB.L          D6,$30(SP)               ; scaled width, height
                    MOVE.L         A1,$38(SP)               ; save end of image
 endif
.writeARGBtoPalMap  MOVE.L         D4,D5                    ; full size of image
.imageneedsaPalMap  BRA.W          .createARGBborder

 ifd Scalers
.doarrayupscaling   MOVE.L         (A0),D0                  ; image width, height
                    MOVEQ          #85,D1
                    MOVEA.W        D0,A1                    ; save original height
                    LSR.W          #1,D0                    ; + 50% of height
                    CMP.W          D1,D0
                    BHI.S          .writeARGBtoPalMap       ; height is too large
                    SWAP           D0
                    MOVEQ          #0,D2   
                    MOVE.W         D0,D2                    ; save original width
                    LSR.W          #1,D0                    ; + 50% of width
                    CMP.W          D1,D0
                    BHI.S          .writeARGBtoPalMap       ; width is too large
                    SWAP           D0
                    ADD.L          D0,(A0)                  ; enlarge image size
                    MOVEM.W        (A0)+,D0-D1              ; scaled width, height
                    MULU.W         D1,D0                    ; scaled image size
                    MOVE.L         A1,D1                    ; original height
                    MOVEA.L        (A0)+,A1                 ; start of image
                    MOVEA.L        (A0),A0                  ; end of normal image
     ifd MC68020
                    LEA            (A1,D0.L*4),A1           ; end of scaled image
     else
                    LSL.L          #2,D0
                    ADDA.L         D0,A1
     endif
                    MOVE.L         A1,$38(SP)               ; save new end of image
                    MOVE.W         $30(SP),D0               ; scaled width
                    LSL.W          #2,D0
                    MOVE.W         D0,A6                    ; scaled ARGB width
                    MOVEQ          #30,D6                   ; minimal alpha value
                    SUBQ.L         #1,D2                    ; original width - 1
                    ROR.L          #1,D2                    ; handle pixel pairs
                    SUBQ.L         #1,D1                    ; original height - 1
                    ROR.L          #1,D1                    ; handle line pairs
.scaleuparraylines  PEA            .buildnewarrayline(PC)
.scaleupsecondline  MOVE.L         D2,D0                    ; original (width-1)/2
                    BPL.S          .copyinganoddpixel
.scaleuparraywidth  MOVE.L         -(A0),-(A1)              ; copy an even pixel
                    MOVE.L         (A0),D5                  ; ARGB of even pixel
                    ADD.B          -(A0),D5                 ; + blue of odd pixel
                    ROXR.B         #1,D5                    ; average of blue
                    ROR.L          #8,D5                    ; BARG
                    ADD.B          -(A0),D5                 ; + green of odd pixel
                    ROXR.B         #1,D5                    ; average of green
                    ROR.L          #8,D5                    ; GBAR
                    ADD.B          -(A0),D5                 ; + red of odd pixel
                    ROXR.B         #1,D5                    ; average of red
                    ROR.L          #8,D5                    ; RGBA
                    CMP.B          -(A0),D6
                    BHI.S          .alphabytetoosmall
                    CMP.B          D5,D6
                    BHI.S          .alphabytetoosmall
                    ADD.B          (A0),D5                  ; + alpha of odd pixel
                    ROXR.B         #1,D5                    ; average of alpha
                    BRA.S          .writenewARGBpixel

.alphabytetoosmall  CLR.B          D5
.writenewARGBpixel  ROR.L          #8,D5                    ; ARGB
                    MOVE.L         D5,-(A1)                 ; write new mixed pixel
                    ADDQ.W         #4,A0
.copyinganoddpixel  MOVE.L         -(A0),-(A1)              ; copy an odd pixel
                    DBRA           D0,.scaleuparraywidth
                    RTS
                    CNOP           0,4

.buildnewarrayline  BSET.L         D0,D1                    ; test and set bit 31
                    BEQ.S          .countdownthelines
                    MOVEA.L        A1,A2                    ; first scaled line
                    SUBA.L         A6,A1                    ; skip new scaled line
                    BSR.S          .scaleupsecondline
                    MOVE.L         D2,D0                    ; original (width-1)/2
                    BPL.S          .originalsizeisodd
.donextthreepixels  PEA            .mergesecondcouple(PC)
.mergetwoARGBpixel  MOVE.L         (A1)+,D5                 ; ARGB of 1. pixel
                    ROL.L          #8,D5                    ; RGBA  
                    CMP.B          (A2)+,D6
                    BHI.S          .toosmallalphabyte
                    CMP.B          D5,D6
                    BHI.S          .toosmallalphabyte
                    ADD.B          -1(A2),D5                ; + alpha of 2. pixel
                    ROXR.B         #1,D5                    ; average of alpha
                    BRA.S          .createnewRGBbytes

.toosmallalphabyte  CLR.B          D5
.createnewRGBbytes  ROL.L          #8,D5                    ; GBAR  
                    ADD.B          (A2)+,D5                 ; + red of 2. pixel
                    ROXR.B         #1,D5                    ; average of red
                    ROL.L          #8,D5                    ; BARG  
                    ADD.B          (A2)+,D5                 ; + green of 2. pixel
                    ROXR.B         #1,D5                    ; average of green
                    ROL.L          #8,D5                    ; ARGB  
                    ADD.B          (A2)+,D5                 ; + blue of 2. pixel
                    ROXR.B         #1,D5                    ; average of blue
                    MOVE.L         D5,-4(A1,A6)             ; write new mixed pixel
                    RTS

.mergesecondcouple  BSR.S          .mergetwoARGBpixel
.originalsizeisodd  BSR.S          .mergetwoARGBpixel
                    DBRA           D0,.donextthreepixels
                    SUBA.L         A6,A1                    ; get next scaled line
.countdownthelines  DBRA           D1,.scaleuparraylines
                    MOVE.L         D4,D5                    ; full size of image
                    LSR.L          #2,D5                    ;  25% of image size
                    ADD.L          D4,D5                    ; 125% of image size
                    ADD.L          D4,D5                    ; 225% of image size
 endif
.createARGBborder   MOVEA.L        $34(SP),A0               ; aligned image top
                    MOVEA.L        D5,A1                    ; save scaled size
.creategrayborder   MOVEQ          #70,D0                   ; transparency level
                    MOVEQ          #45,D1                   ; range of 75 % RGB
                    MOVEQ          #125,D2                  ; gray value of 125
                    SUBQ.L         #1,D5
.donextARGBpixel    MOVE.L         (A0),D6                  ; copy ARGB longword
                    SUB.B          D0,(A0)
                    BCS.S          .storeARGBpixel          ; 100 % transparent
                    SUB.B          D0,(A0)
                    BCC.S          .storeARGBpixel          ; 100 % of RGB color
                    SWAP           D6                       ; ARGB -> GBAR
                    ADD.B          D2,D6
                    ROXR.B         #1,D6                    ; average R and gray
                    ROL.L          #8,D6
                    ADD.B          D2,D6
                    ROXR.B         #1,D6                    ; average G and gray
                    ROL.L          #8,D6
                    ADD.B          D2,D6
                    ROXR.B         #1,D6                    ; average B and gray
                    ADD.B          D1,(A0)
                    BCC.S          .storeARGBpixel          ; 50% RGB + 50% gray
                    SWAP           D6                       ; ARGB -> GBAR
                    ADDQ.W         #1,A0                    ; back to original R
                    ADD.B          (A0)+,D6
                    ROXR.B         #1,D6                    ; merge with orig R
                    ROL.L          #8,D6
                    ADD.B          (A0)+,D6
                    ROXR.B         #1,D6                    ; merge with orig G
                    ROL.L          #8,D6
                    ADD.B          (A0),D6
                    ROXR.B         #1,D6                    ; merge with orig B
                    SUBQ.W         #3,A0
.storeARGBpixel     MOVE.L         D6,(A0)+                 ; store new ARGB now
                    DBRA           D5,.donextARGBpixel
.createdARGBborder  MOVE.L         A1,D5                    ; restore scaled size
.convertintoPalMap  MOVEA.W        #768,A1                  ; for 256 RGB colors
                    BSR.W          .allocmemforPalMap       ; A0 points to pixels
                    BSET.B         #6,$8A(A3)               ; set truecolor flag
                    NOT.B          $10C(A6)                 ; set transparency on
.jitcolorreduction  CLR.W          (A1)+                    ; A1 points to colors
                    CLR.B          (A1)+                    ; clear color number 0
                    MOVEM.L        D3-D4/D7/A3-A6,-(SP)     ; A0 points to pixels
                    MOVEA.L        $34+$1C(SP),A2           ; * ARGB image data
                    LEA            $24C+$1C(SP),A3          ; end of 256 word stack
                    MOVEA.W        (A6),A5                  ; scaled image width
                    MOVE.L         A5,D3
                    ROR.L          #1,D3                    ; positive = even width 
                    SUBQ.W         #1,A5
                    MOVE.W         A5,D3                    ; width - 1 for counter
                    MOVEQ          #0,D7                    ; for some flags
                    MOVE.L         #$FFF8F8F8,D2            ; RGB 5+5+5 bit filter
                    CMPI.L         #$00FFFFE2,D6            ; was glowing added ?
                    BNE.S          .glowingnotadded
                    ADDQ.B         #8,$11C(A6)              ; for a darker palette
                    MOVE.L         #$FFE3FF03,-(A3)         ; compare white yellow
                    SNE            (A1)+                    ; was checked by SoftB
                    MOVE.W         #$EA00,(A1)+             ; glow yellow orange 1
                    SNE            (A1)+
                    SNE            (A1)+
                    MOVE.B         D6,(A1)+                 ; glow white yellow 2
                    MOVEQ          #-128,D6
                    MOVE.B         D6,8+$EF(A6)             ; white palette bit
                    MOVE.B         D6,8+$0F(A6)             ; yellow palette bit
                    MOVEQ          #1,D6
                    BRA.S          .glowingwasadded

.glowingnotadded    MOVEQ          #-1,D6
.glowingwasadded    SUBQ.W         #2,A3                    ; next compare word
                    ADDQ.W         #8,A6                    ; colormap lookup table
.scanimagecolors    SUBQ.W         #1,A0                    ; point to unused byte
                    MOVEA.L        (A2),A5                  ; save the ARGB color
.fillARGBPalMap     CMP.B          #70,(A2)                 ; 8 bit alpha channel
                    SCC            (A2)                     ; set or clear alpha
                    BCC.W          .getvisiblecolor
                    ADDQ.W         #4,A2
.maketransparent    CLR.B          (A0)+                    ; map alpha<70 to pen0
.checkifdonenow     TST.W          D7                       ; colorscan finished ?
                    BPL.S          .imagecolorscan
                    DBRA           D3,.NOTcheckerflag
                    MOVE.L         A5,D3                    ; start of a new line
                    BPL.S          .comparewithend
.NOTcheckerflag     NOT.B          D7                       ; toggle checkerboard
.comparewithend     CMPA.L         $38+$1C(SP),A2
                    BCS.S          .fillARGBPalMap
                    MOVEQ          #0,D5                    ; no error code yet
                    ADDQ.L         #2,D6
                    MOVEM.L        (SP)+,D3-D4/D7/A3-A6
                    MOVE.W         D6,$10E(A6)              ; number of i-colors
 ifd RLEjit
                    CLR.B          $11F(A6)                 ; clear the dump byte
 endif
.clearonceagain     BCLR.B         #3,$11C(A6)
                    BEQ.W          .creatednewPalMap
                    MOVEQ          #-10,D0
                    ADD.L          D6,D0
                    ADD.L          D6,D0
                    ADD.L          D6,D0
                    BMI.S          .clearonceagain
                    MOVEQ          #39,D1
.darkercomponent    SUB.B          D1,-(A1)
.tonextcomponent    DBCS           D0,.darkercomponent
                    BCC.W          .creatednewPalMap
                    CLR.B          (A1)
                    BRA.S          .tonextcomponent

.endofcolorscan     BSET.L         #15,D7                   ; colorscan finished
                    BRA.S          .fillARGBPalMap

.imagecolorscan     MOVE.L         A5,-(A2)                 ; restore orig ARGB
                    MOVE.L         D3,D0                    ; copy width - 1
                    ADDQ.L         #1,D0
                    LSL.L          #2,D0
                    ADD.W          D3,D0                    ; 5 * width - 1
                    LSR.L          #1,D0                    ; skip 0.625 lines
                    CMPI.B         #64,D3
                    BCS.S          .widthisbelow65
                    CMPI.B         #170,D3
                    BCS.S          .width65upto170
                    TST.L          D7                       ; out of colors ?
                    BPL.S          .useshortoffset
                    BSET.L         #30,D7                   ; flag for last scan
                    BNE.S          .uselargeoffset
                    MOVEQ          #1,D6                    ; reset color counter
                    SUBA.W         #759,A1                  ; reset the palette
                    MOVEA.L        $34+$1C(SP),A2           ; * ARGB image data
                    LEA            $246+$1C(SP),A3          ; reset stack pointer
.uselargeoffset     ADDA.W         #290*4,A2
                    BRA.S          .checkingforend

.useshortoffset     LSR.L          #1,D0                    ; skip 0.3125 lines
.width65upto170     SUBQ.W         #4,A2
.widthisbelow65     AND.B          D2,D0                    ; round to quadwords
                    BEQ.S          .rescantheimage          ; zero for width < 4
                    ADDA.L         D0,A2
.checkingforend     CMPA.L         $38+$1C(SP),A2
                    BCS.W          .scanimagecolors
.rescantheimage     MOVEA.L        $34+$1C(SP),A2           ; * ARGB image data
                    MOVEA.L        D3,A5                    ; store width counter
                    BSET.L         #30,D7                   ; flag for last scan
                    BNE.S          .endofcolorscan
                    LSR.L          #1,D0
                    ADDA.L         D0,A2                    ; scan middle of gaps
                    BRA.W          .scanimagecolors         ; second color scan

.addanothercolor    MOVE.B         (A0),D0                  ; get the 3 green bits
                    SWAP           D1                       ; 8 blue and red bits
                    BSET.B         D0,(A6,D1.W)             ; set 434 color bitmap
                    SUBQ.W         #3,A2
                    MOVE.B         (A2)+,(A1)+
 ifd MC68020
                    MOVE.W         (A2)+,(A1)+              ; store RGB triplets
 else
                    MOVE.B         (A2)+,(A1)+
                    MOVE.B         (A2)+,(A1)+
 endif
                    SUBQ.W         #2,A3                    ; next compare word
                    ADDQ.L         #1,D6
                    MOVE.L         D6,D1
                    ADDQ.L         #1,D1
                    MOVE.B         D1,(A0)+                 ; pixel -> register
                    BRA.W          .checkifdonenow

.getvisiblecolor    LEA            3(A2),A4
                    TST.B          D7                       ; checkerboard flag ?
                    BNE.S          .pushupbluelevel         ; not used for scan
                    SUBQ.B         #2,(A4)
                    BCC.S          .pulldownthegreen
                    MOVE.B         D7,(A4)
.pulldownthegreen   SUBQ.B         #2,-(A4)
                    BCC.S          .pulldownredlevel
                    MOVE.B         D7,(A4)
.pulldownredlevel   SUBQ.B         #2,-(A4)
                    BRA.S          .checkcarryflag

.pushupbluelevel    ADDQ.B         #2,(A4)                  ; a simple dithering
                    BCC.S          .pushupgreenlevel
                    MOVE.B         D7,(A4)
.pushupgreenlevel   ADDQ.B         #2,-(A4)
                    BCC.S          .pushupredlevel
                    MOVE.B         D7,(A4)
.pushupredlevel     ADDQ.B         #2,-(A4)
.checkcarryflag     BCC.S          .reducetoHiColor
                    MOVE.B         D7,(A4)
.reducetoHiColor    AND.L          D2,(A2)                  ; RGB 5+5+5 bit filter
                    SUBQ.W         #8,A2                    ; go two pixels back
                    MOVE.L         (A2),D0                  ; get that color again
                    CMPA.L         $34+$1C(SP),A2           ; compare with start
                    ADDQ.W         #8,A2                    ; restore the position
                    BCS.S          .buildcompareword
                    AND.L          D2,D0                    ; delete lower bits
                    CMP.L          (A2),D0                  ; same color again ?
                    BNE.S          .buildcompareword
                    MOVE.B         -2(A0),(A0)+             ; same register again
                    ORI.L          #$00030303,(A2)+         ; push up brightness
                    BRA.W          .checkifdonenow

.buildcompareword   MOVEQ          #0,D0
                    MOVE.B         (A4)+,D0                 ; 00000000rrrrr000
                    MOVE.L         D0,D5
                    LSR.B          #4,D5                    ; 000000000000rrrr
                    LSL.W          #5,D0                    ; 000rrrrr00000000
                    MOVE.B         (A4)+,D0                 ; 000rrrrrggggg000
                    MOVE.B         D0,D4                    ;         ggggg000
                    ROL.W          #5,D0                    ; rrrggggg000000rr
                    OR.B           (A4),D0                  ; rrrgggggbbbbb.rr
                    MOVEQ          #-16,D1                  ; 1111111111110000
                    MOVE.W         D0,(A3)                  ; 555 compare word
                    AND.B          D0,D1                    ;         bbbb0000
                    ORI.L          #$00030303,(A2)+         ; push up brightness
                    LSR.B          #5,D4                    ;         00000ggg
                    MOVE.B         D4,(A0)                  ; save green bits
                    OR.B           D1,D5                    ; 00000000bbbbrrrr
                    MOVE.L         D5,D1
                    SWAP           D1                       ; save blue + red
 ifd MC68020
                    BTST.B         D4,(A6,D5.L)             ; check 434 bitmap
 else
                    BTST.B         D4,(A6,D5.W)
 endif
                    BEQ.S          .comparingwith333
                    MOVE.W         D6,D1                    ; number of colors-1
                    BMI.W          .addanothercolor         ; nothing to compare
.comparingwith555   MOVEA.L        A3,A4
                    ADDQ.W         #2,A4
                    LSR.B          #1,D1
                    BCS.S          .comparecolors555
                    CMP.W          (A4)+,D0
                    BNE.S          .comparedcolor555
.colorfoundodd      ADD.B          D1,D1
                    ADDQ.B         #1,D1
                    MOVE.B         D1,(A0)+                 ; pixel -> register
                    BRA.W          .checkifdonenow

                    CNOP           0,4

.comparecolors555   MOVE.L         (A4)+,D5
                    CMP.W          D0,D5
                    BEQ.S          .colorfoundodd
                    SWAP           D5
                    CMP.W          D0,D5
.comparedcolor555   DBEQ           D1,.comparecolors555
                    BNE.S          .checkfor128pens
.colorfoundeven     ADDQ.B         #1,D1
                    ADD.B          D1,D1
                    MOVE.B         D1,(A0)+                 ; pixel -> register
                    BRA.W          .checkifdonenow

.checkfor128pens    TST.B          D6                       ; (pens - 1) < 128 ?
                    BPL.W          .addanothercolor
                    MOVE.L         #$DEF3DEF3,D4            ; rr0gggg0bbbb0.rr
.comparewordisset   MOVEA.L        A3,A4
                    ADDQ.W         #2,A4
                    AND.L          D4,D0
                    MOVE.W         D6,D1
                    LSR.B          #1,D1
                    BCS.S          .compareRGBcolors
                    MOVE.W         (A4)+,D5
                    AND.L          D4,D5
                    CMP.W          D0,D5
                    BEQ.S          .colorfoundodd
                    BRA.S          .comparedRGBcolor

                    CNOP           0,4

.compareRGBcolors   MOVE.L         (A4)+,D5
                    AND.L          D4,D5
                    CMP.W          D0,D5
                    BEQ.S          .colorfoundodd
                    SWAP           D5
                    CMP.W          D0,D5
.comparedRGBcolor   DBEQ           D1,.compareRGBcolors
                    BEQ.S          .colorfoundeven
                    ADD.L          D4,D4
                    BPL.S          .comparedcolor333
.comparingwith333   CMPI.W         #223,D6                  ; (pens - 1) < 223 ?
                    BLT.W          .addanothercolor
                    MOVE.L         #$9CE39CE3,D4            ; r00ggg00bbb00.rr
                    ADDQ.B         #1,D1                    ; comparedRGB = -1 ?
                    BEQ.S          .comparewordisset        ; was 434 but not 444
                    EOR.B          D1,D5                    ; toggle red LSB
                    MOVE.B         (A0),D1                  ; get the green bits
 ifd MC68020
                    BTST.B         D1,(A6,D5.L)             ; check 434 bitmap
 else
                    BTST.B         D1,(A6,D5.W)
 endif
                    BNE.S          .comparewordisset
                    EORI.B         #$10,D5                  ; toggle blue LSB
 ifd MC68020
                    BTST.B         D1,(A6,D5.L)             ; check 434 bitmap
 else
                    BTST.B         D1,(A6,D5.W)
 endif
                    BNE.S          .comparewordisset
                    EORI.B         #1,D5                    ; toggle red LSB
 ifd MC68020
                    BTST.B         D1,(A6,D5.L)             ; check 434 bitmap
 else
                    BTST.B         D1,(A6,D5.W)
 endif
                    BNE.S          .comparewordisset
                    ADD.L          D4,D4
.comparedcolor333   BCC.S          .comparedcolor222
                    CMPI.B         #250,D6                  ; (pens - 1) < 250 ?
                    BCS.W          .addanothercolor
                    BTST.L         #11,D4                   ; D4 was shifted up
                    BEQ.S          .comparedcolor322
                    ADD.B          D4,D4
                    BPL.S          .comparedcolor332
                    MOVE.L         #$9CC39CC3,D4            ; r00ggg00bb000.rr
.comparingRGBword   BRA.S          .comparewordisset

.comparedcolor332   MOVE.L         #$98C398C3,D4            ; r00gg000bb000.rr
                    BRA.S          .comparingRGBword

.comparedcolor322   MOVE.L         #$18C318C3,D4            ; 000gg000bb000.rr
                    BRA.S          .comparingRGBword

.comparedcolor222   TST.B          D4                       ; D4 was shifted up
                    BPL.S          .comparedcolor221
                    CMPI.B         #254,D6                  ; are all pens used ?
                    BCS.W          .addanothercolor
                    MOVE.L         #$18831883,D4            ; 000gg000b0000.rr
                    BRA.S          .comparingRGBword

.comparedcolor221   SUBQ.B         #4,D4                    ; D4 was shifted up
                    BEQ.S          .comparedcolor121
                    MOVE.L         #$18821882,D4            ; 000gg000b0000.r0
                    BRA.S          .comparingRGBword

.comparedcolor121   BTST.L         #12,D4                   ; D4 was shifted up
                    BEQ.S          .comparedcolor111
                    MOVE.L         #$10821082,D4            ; 000g0000b0000.r0
                    BRA.S          .comparingRGBword

.comparedcolor111   BSET.L         #31,D7                   ; out of colors flag
                    CMP.L          A5,D3                    ; 1. pixel in line ?
                    BEQ.W          .maketransparent
                    MOVE.B         -1(A0),(A0)+             ; use previous color
                    BRA.W          .checkifdonenow

                    ;------------------------------------------------------------

.returnnow          MOVE.L         $250(SP),D2              ; real image 1 ?
                    BEQ.S          .keepreplacement
                    MOVEA.L        D2,A0
                    CMPI.W         #8,ig_Width(A0)          ; width <= 8 ?
                    BLS.S          .keepreplacement
                    MOVE.B         $F3(A5),D0               ; kill old images ?
                    BMI.S          .keepreplacement
                    CMPI.W         #3,ig_Depth(A0)          ; depth <= 3 ?
                    BLS.S          .checkrealimages         ; try to keep good
                    TST.B          D0                       ; keep old images ?
                    BNE.S          .checkrealimages         ; keep, 8->3 planes 
.keepreplacement    BRA.W          .readingdone

.useplanarimages    TST.B          $40(SP)                  ; NewIcon images ?
                    BNE.S          .returnnow
                    MOVE.L         $250(SP),D2              ; real image 1 ?
                    BEQ.S          .keepreplacement
.checkrealimages    SUBA.W         #$10,SP                  ; nothing preserved !
                    MOVE.L         $24C+$10(SP),D3          ; size of image 1
                    MOVEQ          #0,D4
                    MOVE.W         $42+$10(SP),D4           ; size of image 2
                    SUBQ.W         #1,D4
                    ADDQ.L         #1,D4                    ; change 0 into 64k
                    LEA            $4E(A3),A4               ; freelist
                    MOVEA.L        A4,A0                    ; freelist
                    MOVEA.W        #20,A1                   ; sizeof struct image
                    MOVEA.W        #MEMF_PUBLIC,A2          ; attributes
                    BSR.W          FreeAlloc                ; needs no iconbase
                    MOVE.L         D0,(SP)                  ; struct image 1 
                    BEQ.W          .realimagesdone
                    MOVEA.L        A4,A0                    ; freelist
                    MOVEA.L        D3,A1                    ; size of image 1
                    MOVEA.L        $C0(A5),A2               ; attributes (IPrefs)
                    BSR.W          FreeAlloc                ; needs no iconbase
                    MOVE.L         D0,4(SP)                 ; image 1 data
                    BEQ.S          .freestructure1 
                    TST.B          $41+$10(SP)              ; real image 2 ?
                    BEQ.S          .copyrealimages
                    MOVEA.L        A4,A0                    ; freelist
                    MOVEA.W        #20,A1                   ; sizeof struct image
                    MOVEA.W        #MEMF_PUBLIC,A2          ; attributes
                    BSR.W          FreeAlloc                ; needs no iconbase
                    MOVE.L         D0,8(SP)                 ; struct image 2 
                    BEQ.S          .freerealimage1
                    MOVEA.L        A4,A0                    ; freelist
                    MOVEA.L        D4,A1                    ; size of image 2
                    MOVEA.L        $C0(A5),A2               ; attributes (IPrefs)
                    BSR.W          FreeAlloc                ; needs no iconbase
                    MOVE.L         D0,$C(SP)                ; image 2 data
                    BNE.S          .copyrealimages
                    MOVEA.L        A4,A0                    ; freelist
                    MOVEA.L        8(SP),A1                 ; struct image 2
                    BSR.W          DOFreeRemove             ; needs no iconbase    
.freerealimage1     MOVEA.L        A4,A0                    ; freelist
                    MOVEA.L        4(SP),A1                 ; image 1 data
                    BSR.W          DOFreeRemove             ; needs no iconbase    
.freestructure1     MOVEA.L        A4,A0                    ; freelist
                    MOVEA.L        (SP),A1                  ; struct image 1
                    BSR.W          DOFreeRemove             ; needs no iconbase    
                    BRA.S          .realimagesdone
     
.copyrealimages     MOVEQ          #do_Gadget+gg_GadgetText,D0
                    MOVEA.L        $2C+$10(SP),A0           ; icon buffer
                    MOVEA.L        A3,A1                    ; struct DiskObject
                    MOVE.B         do_Type(A0),do_Type(A1)
                    BSR.W          CopyMemBlock
                    MOVEA.L        SP,A2            
                    MOVEA.L        D2,A0                    ; real image 1
                    MOVE.L         (A2),do_Gadget+gg_GadgetRender(A3)
                    MOVE.L         D3,D2                    ; size of image 1
                    BSR.S          .testfor8planes
                    TST.B          $41+$10(SP)              ; real image 2 ?
                    BEQ.S          .realimagesdone
                    MOVE.L         (A2),do_Gadget+gg_SelectRender(A3)
                    MOVE.L         D4,D2                    ; size of image 2
                    BSR.S          .testfor8planes
                    MOVE.W         #6,do_Gadget+gg_Flags(A3); has alternate image
.realimagesdone     ADDA.W         #$10,SP                  ; nothing restored !
                    BRA.S          .readingdone

.testfor8planes     MOVEQ          #3,D0
                    CMP.B          $F3(A5),D0               ; set 8 planes to 3 ?
                    BNE.S          .writerealimage
.reduce8planesto3   MOVEQ          #7,D1
                    CMP.W          ig_Depth(A0),D1          ; image depth > 7 ?
                    BCC.S          .writerealimage
                    MOVE.W         D0,ig_Depth(A0)          ; set depth to 3
                    MOVE.B         D1,ig_PlanePick(A0)      ; PlanePick %00000111
.writerealimage     MOVEQ          #20,D0                   ; sizeof struct image
                    MOVEA.L        (A2)+,A1                 ; new image structure
                    BSR.W          CopyMemBlock             ; A0/A1 are re-used
                    MOVE.L         (A2),-10(A1)             ; set ig_ImageData
                    MOVE.L         D2,D0                    ; size of image data
                    MOVEA.L        (A2)+,A1                 ; image data
                    BRA.W          CopyMemBlock

.noiconstructure    MOVE.L         D7,D1                    ; filehandle
                    MOVEA.L        $2A(A5),A6               ; dosbase
                    JSR            _LVOClose(A6)
                    MOVEQ          #$67,D0                  ; no free meomry
                    BRA.S          .done
                    
.returnnomem        ADDQ.W         #4,SP                    ; drop the RTS code
.nofreestore        MOVEQ          #$67,D5
.readingdone        MOVE.L         $76(A3),D0               ; PalMap1 created ?
                    BEQ.S          .closefile
.savegadgets        MOVE.L         $16(A3),$6E(A3)          ; GadgetRender
                    MOVE.L         $1A(A3),$72(A3)          ; SelectRender
                    MOVEQ          #3,D0                    ; filter
                    AND.B          $10+1(A3),D0             ; lower Flags & 3
                    MOVE.B         D0,$8B(A3)
.closefile          MOVE.L         D7,D1                    ; filehandle
                    BEQ.S          .filedone
                    MOVEA.L        $2A(A5),A6               ; dosbase
                    JSR            _LVOClose(A6)
.filedone           MOVEA.L        $26(A5),A6               ; execbase
                    MOVEA.L        $28(SP),A1               ; temp image buffer
                    JSR            _LVOFreeVec(A6)          ; free temp buffer
.freeiconbuffer     MOVEA.L        $2C(SP),A1
                    JSR            _LVOFreeVec(A6)          ; free icon buffer
                    MOVE.L         D5,D0                    ; any error ?
                    BEQ.S          .done
.fail               MOVEA.L        A3,A0                    ; struct DiskObject
                    MOVEA.L        A5,A6                    ; iconbase
                    JSR            _LVOFreeDiskObject(A6)
.noiconfilehandle   CLR.L          DOstack+V44DO(SP)        ; no V44 DiskObject
                    MOVE.L         D5,D0
.done               MOVEM.L        (SP)+,D2-D7/A2-A4/A6
                    LEA            $22C(SP),SP
                    RTS

;------------------------------------------------------------------

copyimage           MOVEM.L        D1-D3/A1-A2,-(SP)        ; D1 = source image
                    MOVE.L         A0,D2                    ; freelist
                    MOVE.B         D0,D3                    ; copy image data flag
                    CLR.L          (A1)                     ; clear target pointer
                    MOVEA.W        #20,A1                   ; size of struct image
                    MOVEA.W        #MEMF_PUBLIC,A2
                    BSR.W          FreeAlloc                ; needs no iconbase
                    BEQ.S          .nofreestore
                    MOVEA.L        (SP),A0                  ; source image struct
                    MOVEA.L        D0,A2                    ; new target memblock
                    MOVE.L         (A0)+,(A2)+
                    MOVEA.L        A2,A1                    ; target offset = 4 !!
                    MOVE.L         (A0)+,(A1)+              ; ====================
                    MOVE.L         (A0)+,(A1)+
                    MOVE.L         (A0)+,(A1)+
                    MOVE.L         (A0),(A1)
                    TST.B          D3                       ; copy image data ?
                    BEQ.S          .done
                    MOVEA.L        A2,A0
                    TST.W          (A0)+
                    BLE.S          .objectwrongtype
                    TST.W          (A0)+
                    BLE.S          .objectwrongtype
                    MOVE.W         (A0)+,D0                 ; depth
                    BLE.S          .objectwrongtype
                    MOVE.L         A0,D1                    ; * target image data
                    TST.L          (A0)
                    BEQ.S          .objectwrongtype
                    MOVEA.L        D2,A0                    ; freelist
                    MOVEA.L        A2,A1                    ; width, height
                    BSR.S          allocate_WxHxD
                    BNE.S          .allocfailed
                    MOVEA.L        A2,A1
                    MOVEM.W        (A1)+,D0-D2              ; width, height, depth
                    MULU.W         D1,D2
                    MOVEQ          #15,D1
                    ADD.W          D1,D0                    ; width + 15
                    LSR.W          #4,D0
                    ADD.W          D0,D0                    ; plane bytes per line
                    MULU.W         D2,D0                    ; total bytes
                    MOVEA.L        (SP),A0
                    MOVEA.L        $A(A0),A0                ; source image data
                    MOVEA.L        (A1),A1                  ; target image data
                    BSR.W          CopyMemAligned           ; large copy !
.done               MOVEQ          #0,D0                    ; set returncode = ok
                    BRA.S          .sendresult

.nofreestore        MOVEQ          #$67,D0
                    BRA.S          .error

.objectwrongtype    MOVEQ          #$6A,D3
                    ADD.L          D3,D3
                    BRA.S          .freestructure

.allocfailed        MOVE.L         D0,D3
.freestructure      SUBQ.W         #4,A2
                    MOVEA.L        D2,A0                    ; freelist
                    MOVEA.L        A2,A1                    ; image structure
                    BSR.W          DOFreeRemove             ; needs no iconbase    
                    MOVE.L         D3,D0
                    BRA.S          .error

.sendresult         SUBQ.W         #4,A2                    ; remove target offset
                    MOVEA.L        $C(SP),A1                ; ====================
                    MOVE.L         A2,(A1)
.error              MOVEM.L        (SP)+,D1-D3/A1-A2
                    RTS

;-------------------------------------------------------------------------

allocate_WxHxD      MOVEM.L        D1/A2,-(SP)              ; A0=freelist A1= w,h
                    MOVEM.W        (A1),D1/A2               ; image width, height
                    ADDQ.W         #8,D1
                    ADDQ.W         #7,D1                    ; image width + 15
                    LSR.W          #4,D1
                    ADD.W          D1,D1                    ; plane bytes per line
                    MULU.W         D1,D0                    ; * depth
                    MOVE.L         A2,D1                    ; * height
                    MULU.W         D1,D0                    ; = total bytes
 ifd MC68020
                    ADDQ.L         #8,D0                    ; + 8 for magic pointer
 endif
                    MOVEA.L        D0,A1                    ; byte size
                    CMP.L          #$10008,D0               ; is size > 64 kB + 8 ?
                    BHI.S          .fail
                    MOVEA.L        $C0(A5),A2               ; attributes (IPrefs)
                    BSR.W          FreeAlloc                ; needs no iconbase
                    MOVEA.L        (SP),A0                  ; * image data
                    MOVE.L         D0,(A0)                  ; = new image memblock
                    BNE.S          .done
.fail               MOVEQ          #$67,D0
                    BRA.S          .exit

.done               MOVEQ          #0,D0                    ; return ok
.exit               MOVEM.L        (SP)+,D1/A2
                    RTS

;--------------------------------------------------------------------------

copyPalMap          MOVEM.L        D1/D7/A0/A2/A6,-(SP)     ; A0 = freelist
                    MOVEA.L        D1,A2                    ; source PalMap
                    MOVE.W         (A2)+,D7                 ; width
                    MULU.W         (A2)+,D7                 ;       * height
 ifd RLEjit
                    TST.B          $11F-4(A2)               ; RLE compressed data ?
                    BPL.S          .chunkydatadone
                    CLR.B          $11F-4(A2)               ; color reduction dump
                    MOVEM.L        A0/A2,-(SP)
                    MOVEA.L        D7,A0                    ; full size of image
                    MOVEA.L        D1,A6                    ; PalMap
                    MOVEA.L        (A2),A1                  ; * chunky image data
                    MOVEA.L        A1,A2                    ; target = full image
                    MOVEQ          #0,D0
                    MOVE.W         (A1)+,D0                 ; offset of RLE data
                    ADDA.L         D0,A2                    ; source = *RLE z-data
                    MOVE.W         (A1)+,D0                 ; RLE compressed size
                    MOVEQ          #0,D1
                    MOVE.B         (A1),D1                  ; depth
                    SUBQ.W         #4,A1                    ; target = full image
                    BSR.W          decompressdata           ; A6 = PalMap
                    MOVEM.L        (SP)+,A0/A2              ; A6 was not preserved
                    BEQ.S          .chunkydatadone
                    MOVEQ          #0,D0
                    BRA.S          .error
 endif
.chunkydatadone     MOVE.L         D7,D0                    ; number of pixels
                    ADDQ.L         #3,D0                    ; round image size
                    AND.B          #$FC,D0                  ; up to longwords
                    MOVEA.W        #$120,A1                 ; structure + 256 pens
                    ADDA.L         D0,A1                    ; add number of pixels
                    MOVE.W         $10E-4(A2),D0            ; number of i-colors
                    ADDA.W         D0,A1
                    ADD.W          D0,D0
                    ADDA.W         D0,A1                    ; add 3*i-colors (RGB)
                    MOVEA.W        #MEMF_PUBLIC,A2
                    BSR.W          FreeAlloc                ; needs no iconbase
                    BEQ.S          .error
                    MOVEA.L        (SP),A2                  ; source PalMap
                    MOVEA.W        #$120,A6                 ; structure + 256 pens
                    EXG            D0,A6                    ; new memblock
                    MOVEA.L        A2,A0                    ; source structure
                    MOVEA.L        A6,A1                    ; target structure
                    BSR.W          CopyMemAligned           ; A1 is re-used
                    CLR.L          $11C(A6)                 ; not mapped, no padd 
                    MOVEA.L        4(A2),A0                 ; source pixel address
                    MOVE.L         A1,4(A6)                 ; target pixel address
                    MOVE.L         D7,D0                    ; copy pixel bytes
                    BSR.W          CopyMemAligned           ; large copy !
                    MOVEA.L        $108(A2),A0              ; source cmap RGB bytes
                    MOVEA.L        4(A6),A1                 ; target pixel address
                    ADDQ.L         #3,D7                    ;    round image size
                    AND.B          #$FC,D7                  ;    up to longwords
                    ADDA.L         D7,A1                    ; add number of pixels
                    MOVE.L         A1,$108(A6)              ; target cmap RGB bytes
                    MOVEA.W        $10E(A2),A2              ;    number of i-colors
                    MOVE.L         A2,D0
                    ADD.L          D0,D0
                    ADD.L          A2,D0                    ; copy 3*i-colors (RGB)
                    BSR.W          CopyMemBlock
.newPalMap          MOVE.L         A6,D0                    ; target data address
.error              MOVEM.L        (SP)+,D1/D7/A0/A2/A6
                    RTS

;-------------------------------------------------------------------------

checkimage          MOVE.L         A0,D0
                    BEQ.S          .image
                    ADDQ.W         #4,A0
                    TST.W          (A0)+                    ; width <= 0 ?
                    BLE.S          .error
                    TST.W          (A0)+                    ; height <= 0 ?
                    BLE.S          .error
                    MOVE.W         (A0)+,D0                 ; depth <= 0 ?
                    BLE.S          .error
                    SUBQ.W         #8,D0                    ; depth > 8 ?
                    BGT.S          .error
                    MOVE.L         (A0),D0                  ; * image data ?
                    BNE.S          .image
.error              MOVEQ          #0,D0
.image              RTS

;-------------------------------------------------------------------------

copyStructDO        MOVEM.L        D3-D7/A1-A4/A6,-(SP)     ; A5=iconbase
                    MOVE.L         D0,D7                    ; flags
                    MOVEQ          #0,D3                    ; set returncode = ok
                    MOVEA.L        A0,A3                    ; source DiskObject
                    CLR.L          (A1)                     ; clear target pointer
                    MOVEA.W        #MEMF_PUBLIC,A2          ; FreeAlloc attributes
                    MOVEA.L        A5,A6                    ; iconbase
                    BTST.L         #1,D7                    ; copy image struct ?
                    BEQ.S          .newDiskObject
                    MOVEA.L        $16(A3),A0               ; GadgetRender ok ?
                    BSR.S          checkimage
                    BEQ.W          .objectwrongtype
                    BTST.B         #1,$10+1(A3)             ; one image only ?
                    BEQ.S          .newDiskObject
                    MOVEA.L        $1A(A3),A0               ; SelectRender ok ?
                    BSR.S          checkimage
                    BEQ.W          .objectwrongtype
.newDiskObject      BSR.W          buildDOstructure         ; allocates a v44 DO
                    MOVEA.L        D0,A4                    ; the target structure
                    MOVE.L         D0,D4                    ; initialized v44 DO
                    BEQ.W          .nofreestore
                    MOVEQ          #$4E,D0                  ; size of DiskObject
                    ADD.L          D0,D4                    ; * freelist
                    MOVEA.L        A3,A0                    ; source DiskObject
                    MOVEA.L        A4,A1                    ; target DiskObject
                    BSR.W          CopyMemAligned
                    CLR.L          $26(A4)                  ; clear SpecialInfo
                    TST.L          do_DrawerData(A3)
                    BEQ.S          .nodrawerdata
                    CLR.L          do_DrawerData(A4)
                    BTST.L         #0,D7                    ; DrawerData needed ?
                    BEQ.S          .nodrawerdata
                    MOVEA.L        D4,A0                    ; freelist
                    MOVEA.W        #$3E,A1                  ; size of DrawerData
                    BSR.W          FreeAlloc                ; needs no iconbase
                    MOVE.L         D0,do_DrawerData(A4)
                    BEQ.W          .nofreestore
                    MOVEA.L        do_DrawerData(A3),A0
                    MOVEA.L        D0,A1
                    MOVEQ          #$3E,D0                  ; size of DrawerData
                    BSR.W          CopyMemAligned
.nodrawerdata       LEA            $1A(A4),A1
                    CLR.L          (A1)                     ; clear SelectRender
                    CLR.L          -(A1)                    ; Clear GadgetRender
                    BTST.L         #1,D7                    ; copy image struct ?
                    BEQ.S          .planarimagedone
                    BTST.L         #2,D7                    ; copy image data ?
                    SNE            D0
                    MOVE.L         $16(A3),D1               ; GadgetRender
                    MOVEA.L        D4,A0                    ; freelist
                    BSR.W          copyimage
                    MOVE.L         D0,D3
                    BNE.W          .freeDiskObject
                    BTST.B         #1,$10+1(A3)             ; one image only ?
                    BEQ.S          .planarimagedone
                    MOVE.L         $1A(A3),D1               ; SelectRender ?
                    BEQ.S          .planarimagedone
                    BTST.L         #2,D7                    ; copy image data ?
                    SNE            D0
                    MOVEA.L        D4,A0                    ; freelist
                    LEA            $1A(A4),A1
                    BSR.W          copyimage
                    MOVE.L         D0,D3
                    BNE.W          .freeDiskObject
.planarimagedone    MOVE.L         do_DefaultTool(A3),D0
                    BEQ.S          .deftooldone
                    CLR.L          do_DefaultTool(A4)
                    BTST.L         #3,D7                    ; copy default tool ?
                    BEQ.S          .deftooldone
                    MOVEA.L        D0,A1
.getendofstring     TST.B          (A1)+
                    BNE.S          .getendofstring
                    MOVEA.L        D4,A0                    ; freelist
                    SUBA.L         D0,A1                    ; string size
                    BSR.W          FreeAlloc                ; needs no iconbase
                    MOVE.L         D0,do_DefaultTool(A4)    ; save default tool mem
                    BEQ.W          .nofreestore
                    MOVEA.L        do_DefaultTool(A3),A0
                    MOVEA.L        D0,A1
.copydefstring      MOVE.B         (A0)+,(A1)+
                    BNE.S          .copydefstring
.deftooldone        MOVE.L         do_ToolTypes(A3),D6
                    BEQ.S          .tooltypesdone
                    CLR.L          do_ToolTypes(A4)
                    BTST.L         #4,D7                    ; copy tooltypes ?
                    BEQ.S          .tooltypesdone
                    MOVEA.L        D6,A1                    ; tooltype array
.nexttooltype       TST.L          (A1)+                    ; check string pointer
                    BNE.S          .nexttooltype
                    SUBA.L         D6,A1
                    MOVE.L         A1,D6                    ; size of array
                    MOVEA.L        D4,A0                    ; freelist
                    BSR.W          FreeAlloc                ; needs no iconbase
                    LEA            do_ToolTypes(A3),A3      ; source pointer
                    LEA            do_ToolTypes(A4),A4      ; target pointer
                    MOVE.L         D0,(A4)                  ; store tooltype array
                    BEQ.W          .nofreestore
                    MOVEA.L        D0,A0
                    SUBQ.L         #4,D6                    ; offset of terminator
                    CLR.L          (A0,D6.L)                ; clear final pointer
                    SUBQ.L         #4,D6                    ; last tooltype string
                    BCS.S          .notoolstrings
.nexttoolstring     MOVEA.L        (A3),A1
                    MOVE.L         (A1,D6.L),D5             ; source string
                    MOVEA.L        D5,A1
.toendofstring      TST.B          (A1)+
                    BNE.S          .toendofstring
                    SUBA.L         D5,A1                    ; string size
                    MOVEA.L        D4,A0                    ; freelist
                    BSR.W          FreeAlloc                ; needs no iconbase
                    MOVEA.L        (A4),A1
                    MOVE.L         D0,(A1,D6.L)             ; new string memblock
                    BEQ.W          .nofreestore
                    MOVEA.L        D0,A1                    ; target string
                    MOVEA.L        D5,A0                    ; source string
.copytoolstring     MOVE.B         (A0)+,(A1)+
                    BNE.S          .copytoolstring
                    SUBQ.L         #4,D6                    ; array offset - 4
                    BCC.S          .nexttoolstring
.notoolstrings      LEA            -(do_ToolTypes)(A3),A3
                    LEA            -(do_ToolTypes)(A4),A4
.tooltypesdone      MOVE.L         do_ToolWindow(A3),D0
                    BEQ.S          .toolwindowdone
                    CLR.L          do_ToolWindow(A4)
                    BTST.L         #5,D7                    ; copy tool window ?
                    BEQ.S          .toolwindowdone
                    MOVEA.L        D0,A1
.getsize            TST.B          (A1)+
                    BNE.S          .getsize
                    SUBA.L         D0,A1                    ; size
                    MOVEA.L        D4,A0                    ; freelist
                    BSR.W          FreeAlloc                ; needs no iconbase
                    MOVE.L         D0,do_ToolWindow(A4)
                    BEQ.W          .nofreestore
                    MOVEA.L        do_ToolWindow(A3),A0     ; source string
                    MOVEA.L        D0,A1                    ; target string
.copytoolwindow     MOVE.B         (A0)+,(A1)+
                    BNE.S          .copytoolwindow
.toolwindowdone     LEA            $5E(A3),A0               ; check v44 extension
                    CMPA.L         (A0),A0                  ; magic selfpointer ?
                    BNE.W          .finalsteps
                    BTST.L         #1,D7                    ; copy image struct ?
                    BEQ.S          .imagecopydone
                    MOVE.B         $8B(A3),$8B(A4)          ; copy flags
                    MOVE.L         $6E(A3),D1               ; source image 1
                    BEQ.S          .noimage1
                    MOVEQ          #1,D0                    ; copy image data too!
                    MOVEA.L        D4,A0                    ; freelist
                    LEA            $6E(A4),A1               ; target image 1
                    BSR.W          copyimage
                    MOVE.L         D0,D3
                    BNE.W          .freeDiskObject
.noimage1           MOVE.L         $72(A3),D1               ; source image 2
                    BEQ.S          .imagecopydone
                    MOVEQ          #1,D0                    ; copy image data too!
                    MOVEA.L        D4,A0                    ; freelist
                    LEA            $72(A4),A1               ; target image 2
                    BSR.W          copyimage
                    MOVE.L         D0,D3
                    BNE.W          .freeDiskObject
.imagecopydone      MOVEQ          #-5,D0                   ; clear bit 2 (deficon)
                    AND.B          $8A(A3),D0
                    MOVE.B         D0,$8A(A4)               ; store flags
                    BTST.L         #7,D7                    ; copy PalMaps only ?
                    BNE.W          .copypalmaps
                    BTST.L         #1,D7                    ; copy image struct ?
                    BEQ.W          .finalsteps
                    BTST.L         #2,D7                    ; copy image data ?
                    BEQ.W          .finalsteps
                    MOVE.L         $6A(A3),D6               ; * NewIcon data ?
                    BEQ.S          .nonewicondata
                    MOVEA.L        D6,A1
.getendofarray      TST.L          (A1)+                    ; test string pointer
                    BNE.S          .getendofarray
                    SUBA.L         D6,A1
                    MOVE.L         A1,D6                    ; size of array
                    MOVEA.L        D4,A0                    ; freelist
                    BSR.W          FreeAlloc                ; needs no iconbase
                    LEA            $6A(A3),A3
                    LEA            $6A(A4),A4
                    MOVE.L         D0,(A4)                  ; new array memblock
                    BEQ.W          .nofreestore
                    MOVEA.L        D0,A0
                    SUBQ.L         #4,D6                    ; offset of terminator
                    CLR.L          (A0,D6.L)                ; final null pointer
                    SUBQ.L         #4,D6                    ; last data string
                    BCS.S          .nodatastrings
.nextdatastring     MOVEA.L        (A3),A1                  ; source array
                    MOVE.L         (A1,D6.L),D5             ; source data string
                    MOVEA.L        D5,A1
.getendofdata       TST.B          (A1)+
                    BNE.S          .getendofdata
                    SUBA.L         D5,A1                    ; size of string
                    MOVEA.L        D4,A0                    ; freelist
                    BSR.W          FreeAlloc                ; needs no iconbase
                    MOVEA.L        (A4),A0                  ; target array
                    MOVE.L         D0,(A0,D6.L)             ; target data string
                    BEQ.S          .nofreestore
                    MOVEA.L        D0,A1                    ; target data
                    MOVEA.L        D5,A0                    ; source data
.copystringdata     MOVE.B         (A0)+,(A1)+
                    BNE.S          .copystringdata
                    SUBQ.L         #4,D6                    ; array offset - 4
                    BCC.S          .nextdatastring
.nodatastrings      LEA            -$6A(A3),A3
                    LEA            -$6A(A4),A4
.nonewicondata      MOVEA.L        $7E(A3),A0               ; source mask1
                    MOVE.L         A0,D0
                    BEQ.S          .nomask1
                    BSR.W          copyplane0
                    MOVE.L         D0,$7E(A4)               ; target mask1
                    BEQ.S          .nofreestore
.nomask1            MOVEA.L        $82(A3),A0               ; source mask2
                    MOVE.L         A0,D0
                    BEQ.S          .copypalmaps
                    BSR.W          copyplane0
                    MOVE.L         D0,$82(A4)               ; target mask2
                    BEQ.S          .nofreestore
.copypalmaps        MOVEA.L        $76(A3),A0               ; source PalMap1
                    BSR.W          checkpalmap
                    BEQ.S          .finalsteps
                    MOVE.L         A0,D1                    ; source PalMap1
                    MOVEA.L        D4,A0                    ; freelist
                    BSR.W          copyPalMap
                    MOVE.L         D0,$76(A4)               ; target PalMap1
                    BEQ.S          .nofreestore
                    MOVEA.L        $7A(A3),A0               ; source PalMap2
                    BSR.W          checkpalmap
                    BEQ.S          .finalsteps
                    MOVE.L         A0,D1                    ; source PalMap2
                    MOVEA.L        D4,A0                    ; freelist
                    BSR.W          copyPalMap
                    MOVE.L         D0,$7A(A4)               ; target PalMap2
                    BNE.S          .finalsteps
.nofreestore        MOVEQ          #$67,D3
                    BRA.W          .freeDiskObject

.finalsteps         LEA            do_Gadget(A4),A2
                    MOVEQ          #1,D0
                    MOVE.W         D0,$E(A2)                ; Activation
                    MOVE.W         D0,$10(A2)               ; GadgetType
                    MOVE.B         D0,$28+3(A2)             ; UserData
                    CLR.L          (A2)                     ; clear NextGadget
                    CLR.L          $1A(A2)                  ; clear GadgetText
                    CLR.L          $22(A2)                  ; clear SpecialInfo
                    MOVEQ          #0,D0
                    MOVE.B         do_Type(A4),D0
                    SUBQ.L         #1,D0                    ; 1 = WBDISK
                    BEQ.S          .needsdrawerdata
                    SUBQ.L         #1,D0                    ; 2 = WBDRAWER
                    BEQ.S          .needsdrawerdata
                    SUBQ.L         #3,D0                    ; 5 = WBTRASHCAN
                    BNE.S          .cleardrawerdata
.needsdrawerdata    TST.L          do_DrawerData(A4)
                    BNE.S          .hasdrawerdata
                    LEA            DefDrawerData(PC),A0
                    MOVE.L         A0,do_DrawerData(A4)
                    BRA.S          .hasdrawerdata

.cleardrawerdata    CLR.L          do_DrawerData(A4)
.hasdrawerdata      MOVEQ          #3,D0
                    AND.W          $C(A2),D0                ; flags bit 0, 1
                    SUBQ.L         #2,D0
                    BCS.S          .oneorzero
                    BNE.S          .three
                    TST.L          $16(A2)                  ; SelectRender ?
                    BNE.S          .flags_ok
.three              CLR.W          $C(A2)                   ; clear flags
.oneorzero          CLR.L          $16(A2)                  ; remove SelectRender
.flags_ok           MOVEA.L        $12(A2),A0               ; GadgetRender
                    BSR.S          initplanarimage
                    MOVEA.L        $16(A2),A0               ; SelectRender
                    BSR.S          initplanarimage
                    MOVEQ          #3,D0
                    AND.W          $C(A2),D0
                    ORI.W          #4,D0                    ; set bit 2
                    MOVE.W         D0,$C(A2)                ; write flags 0,1,2
                    MOVEA.L        do_DefaultTool(A4),A0
                    MOVE.L         A0,D0
                    BEQ.S          .deftool_ok
                    TST.B          (A0)                     ; any string ?
                    BNE.S          .deftool_ok
                    CLR.L          do_DefaultTool(A4)
.deftool_ok         MOVEA.L        do_ToolTypes(A4),A0
                    MOVE.L         A0,D0
                    BEQ.S          .tooltypes_ok
                    TST.L          (A0)                     ; empty array ?
                    BNE.S          .tooltypes_ok
                    CLR.L          do_ToolTypes(A4)
.tooltypes_ok       MOVEA.L        do_ToolWindow(A4),A0
                    MOVE.L         A0,D0
                    BEQ.S          .toolwindow_ok
                    TST.B          (A0)                     ; any string ?
                    BNE.S          .toolwindow_ok
                    CLR.L          do_ToolWindow(A4)
.toolwindow_ok      TST.L          D3                       ; check for errors
                    BEQ.S          .done
.freeDiskObject     MOVEA.L        A4,A0                    ; free new DiskObject
                    JSR            _LVOFreeDiskObject(A6)
.clearDiskObject    SUBA.L         A4,A4
.done               MOVEA.L        $14(SP),A0               ; get target pointer
                    MOVE.L         A4,(A0)                  ; return new DiskObject
                    MOVE.L         D3,D0                    ; set the return code
                    MOVEM.L        (SP)+,D3-D7/A1-A4/A6
                    RTS

.objectwrongtype    MOVEQ          #$6A,D3
                    ADD.L          D3,D3
                    BRA.S          .clearDiskObject

;-------------------------------------------------------------------------

initplanarimage     MOVE.L         A0,D0
                    BEQ.S          .return
                    CLR.L          (A0)                     ; clear position
                    MOVE.W         8(A0),D0                 ; depth = x
                    MOVEQ          #0,D1
                    BSET.L         D0,D1
                    SUBQ.L         #1,D1
                    LEA            $E(A0),A0                ; PlanePick
                    MOVE.B         D1,(A0)+                 ; activate x planes
                    CLR.B          (A0)+                    ; clear PlaneOnOff
                    CLR.L          (A0)+                    ; clear NextImage
.return             RTS

;-------------------------------------------------------------------------

copyplane0          MOVEM.L        D2/A2-A3/A6,-(SP)
                    MOVEA.L        A0,A2                    ; source planeptr
                    MOVEQ          #8,D0                    ; 8 pointer bytes
                    MOVEA.L        $26(A5),A6               ; execbase
                    MOVEQ          #MEMF_PUBLIC,D1
                    JSR            _LVOAllocMem(A6)
                    TST.L          D0
                    BEQ.S          .exit
                    MOVEA.L        D0,A3                    ; target planeptr
                    MOVEM.W        4(A2),D0-D1              ; width, height
                    ADDQ.L         #8,D0
                    ADDQ.L         #7,D0
                    LSR.L          #4,D0
                    ADD.L          D0,D0                    ; word aligned bytes
                    MULU.W         D1,D0                    ; total plane size
                    MOVE.L         D0,D2
                    MOVE.L         $C0(A5),D1               ; attributes (IPrefs)
                    JSR            _LVOAllocMem(A6)
                    MOVE.L         D0,(A3)                  ; target plane
                    BEQ.S          .freepointer
                    MOVEA.L        (A2)+,A0                 ; source plane
                    MOVE.L         (A2),4(A3)               ; width, height
                    MOVEA.L        D0,A1                    ; target plane
                    MOVE.L         D2,D0                    ; size
                    BSR.W          CopyMemAligned
                    MOVE.L         A3,D0                    ; target planeptr
                    BRA.S          .exit

.freepointer        MOVEA.L        A3,A1
                    MOVEQ          #8,D0                    ; 8 bytes
                    JSR            _LVOFreeMem(A6)
                    MOVEQ          #0,D0
.exit               MOVEM.L        (SP)+,D2/A2-A3/A6
                    RTS

;------------------------------------------------------------------

                    CNOP           0,4

; DupDiskObjectA -- Duplicate an icon (V44), most used for appicons
; icon = DupDiskObjectA(icon,tags);
; D0                    A0   A1
; struct DiskObject * DupDiskObjectA(struct DiskObject *icon, struct TagItem *tags)

DupDiskObjectA      MOVEM.L        D6-D7/A1/A3/A5-A6,-(SP)
                    CLR.L          -(SP)                    ; no new icon yet
                    MOVEA.L        A6,A5                    ; iconbase
                    MOVE.L         A0,D0
                    BEQ.W          .noiconsupplied
                    MOVEA.L        A0,A3                    ; source icon
                    MOVE.L         $1A(A3),D0               ; SelectRender ?
                    BEQ.S          .colormappingdone
                    LEA            $5E(A3),A0
                    CMPA.L         (A0),A0                  ; V44 DiskObject ?
                    BNE.S          .colormappingdone
                    MOVEA.L        $7A(A3),A1               ; PalMap2
                    MOVE.L         A1,D1
                    BEQ.S          .colormappingdone
                    TST.W          $11C(A1)                 ; colormapping done ?
                    BNE.S          .colormappingdone
                    MOVEA.L        $76(A3),A0               ; PalMap1 ?
                    MOVE.L         A0,D1
                    BEQ.S          .colormappingdone
                    TST.W          $11C(A0)                 ; colormapping done ?
                    BEQ.S          .colormappingdone
                    MOVEA.L        $86(A3),A0               ; icons screen
                    MOVEQ          #0,D7                    ; precision = good
                    BSR.W          imagecolormapping        ; D0=Select A1=PalMap2
.colormappingdone   MOVEQ          #$3F,D0                  ; initial flags = all
                    MOVEA.L        $C(SP),A0                ; taglist
                    LEA            DupDO_Tags(PC),A1        ; boolMap
                    MOVEA.L        $2E(A5),A6               ; utilbase
                    JSR            _LVOPackBoolTags(A6)
                    BTST.L         #6,D0                    ; activate image data ?
                    BEQ.S          .noactivation
                    ORI.B          #6,D0                    ; set image, img data
.noactivation       MOVE.L         D0,D7                    ; flags as a longword
                    MOVEA.L        A3,A0                    ; source icon
                    MOVEA.L        SP,A1                    ; *target icon
                    BSR.W          copyStructDO
                    MOVE.L         D0,D6                    ; error code
                    BNE.W          .errorhandling
                    CMPI.W         #$E310,(A3)              ; DiskMagic found ?
                    BEQ.S          .validsignature
                    MOVEA.L        (SP),A0                  ; target icon
                    MOVE.L         DiskObject_tool(PC),(A0) ; DiskMagic, version 1
.validsignature     BTST.L         #6,D7                    ; activate image data ?
                    BEQ.W          .remapicondone
                    LEA            $5E(A3),A0               ; magic V44 selfpointer
                    CMPA.L         (A0),A0                  ; V44 icon structure ?
                    BNE.W          .remapicondone
                    MOVEQ          #0,D1                    ; mode = find DontEdit
                    BSR.W          newicontooltypes         ; A3 = source icon
                    MOVEA.L        (SP),A3                  ; A3 = target icon
                    BEQ.S          .nonewiconimages
                    MOVEA.L        D0,A0                    ; *DontEdit toolstring
                    TST.L          $76(A3)                  ; PalMap1 ?
                    BNE.S          .nonewiconimages
                    TST.W          $C6(A5)                  ; GlobalNewIconSupport
                    BEQ.S          .nonewiconimages
                    BSR.W          newiconimages            ; A3 = target icon
.nonewiconimages    MOVEA.L        $76(A3),A0               ; PalMap1
                    BSR.W          checkpalmap
                    BEQ.W          .remapicondone
                    TST.W          $11C(A0)                 ; color mapping done ?
                    BNE.W          .remapicondone
                    LEA            $16(A3),A0               ; *GadgetRender
                    MOVE.L         (A0),$6E(A3)             ; Gadget -> V44imgage1
                    CLR.L          (A0)+                    ; remove GadgetRender
                    MOVE.L         (A0),$72(A3)             ; Select -> V44imgage2
                    CLR.L          (A0)                     ; remove SelectRender
                    MOVEQ          #3,D0                    ; mask flag 0, 1
                    AND.B          $10+1(A3),D0             ; get do_Gadget flags
                    MOVE.B         D0,$8B(A3)               ; set V44 flags
                    BSR.W          darkerPalMapCopy         ; A3=icon A6=scratched!
                    MOVEA.L        $C(SP),A0                ; taglist
                    MOVE.L         #ICONGETA_Screen,D0
                    MOVEA.L        $2E(A5),A6               ; utilbase
                    JSR            _LVOFindTagItem(A6)
                    MOVEA.L        $128(A5),D1              ; GlobalScreen
                    TST.L          D0
                    BEQ.S          .noscreensupplied
                    MOVEA.L        D0,A0
                    MOVE.L         4(A0),D1                 ; screen = tagdata
.noscreensupplied   MOVE.L         $124(A5),D0              ; GlobalPrecision
                    MOVEA.W        #1,A0                    ; no delay
                    MOVEA.L        A3,A1                    ; target icon
                    BSR.W          iconcolormapping
                    TST.L          D0                       ; colormapping error ?
                    BNE.S          .delayedmapping
                    MOVEA.L        $76(A3),A0               ; PalMap1
                    MOVE.L         (A0),$C(A3)              ; copy width, height
                    LEA            $7E(A3),A1               ; mask1
                    BSR.W          makePalMapMask           ; A0=PalMap,A5=iconbase
                    MOVEA.L        $7A(A3),A0               ; PalMap2
                    LEA            $82(A3),A1               ; mask2
                    BSR.W          makePalMapMask           ; A0=PalMap,A5=iconbase
                    BCLR.B         #0,$11(A3)               ; no backfill
                    BSET.B         #1,$11(A3)               ; hasImage2
                    BRA.S          .remapicondone

.delayedmapping     LEA            $6E(A3),A0               ; *V44image1
                    MOVE.L         (A0),$16(A3)             ; V44image1 -> Gadget
                    CLR.L          (A0)+                    ; remove V44image1
                    MOVE.L         (A0),$1A(A3)             ; V44image2 -> Select
                    CLR.L          (A0)                     ; remove V44image2
                    MOVEQ          #-4,D0                   ; clear flags 0, 1
                    AND.W          $10(A3),D0               ; get do_Gadget flags
                    OR.B           $8B(A3),D0               ; or V44 flags
                    MOVE.W         D0,$10(A3)               ; set do_Gadget flags
.remapicondone      MOVEA.L        (SP),A3                  ; A3 = target icon
                    BTST.L         #0,D7                    ; copy drawerdata ?
                    BNE.S          .checkimage
                    CLR.L          do_DrawerData(A3)
.checkimage         LEA            $16(A3),A0               ; *GadgetRender
                    BTST.L         #1,D7                    ; duplicate image ?
                    BNE.S          .checkimagedata
                    CLR.L          (A0)+                    ; clear GadgetRender
                    CLR.L          (A0)                     ; clear SelectRender
                    BRA.S          .checkdefaulttool

.noiconsupplied     MOVEQ          #$74,D6                  ; argument missing
                    BRA.S          .errorhandling

.checkimagedata     BTST.L         #2,D7                    ; duplicate imagedata ?
                    BNE.S          .checkdefaulttool
                    MOVEA.L        (A0)+,A1                 ; GadgetRender
                    MOVE.L         A1,D0
                    BEQ.S          .checkimagedata2
                    CLR.L          $A(A1)                   ; clear imagedata1
.checkimagedata2    MOVEA.L        (A0),A1                  ; SelectRender
                    MOVE.L         A1,D0
                    BEQ.S          .checkdefaulttool
                    CLR.L          $A(A1)                   ; clear imagedata2
.checkdefaulttool   BTST.L         #3,D7                    ; copy default tool ?
                    BNE.S          .checktooltypes
                    CLR.L          do_DefaultTool(A3)
.checktooltypes     BTST.L         #4,D7                    ; copy tooltypes ?
                    BNE.S          .checktoolwindow
                    CLR.L          do_ToolTypes(A3)
.checktoolwindow    BTST.L         #5,D7                    ; copy toolwindow ?
                    BNE.S          .errorhandling
                    CLR.L          do_ToolWindow(A3)
.errorhandling      MOVEA.L        $C(SP),A0                ; taglist
                    MOVE.L         #ICONA_ErrorCode,D0
                    MOVEA.L        $2E(A5),A6               ; utilbase
                    JSR            _LVOFindTagItem(A6)
                    TST.L          D0
                    BEQ.S          .noerrorcodewanted
                    MOVEA.L        D0,A0                    ; error code tagitem
                    MOVE.L         4(A0),D0                 ; errorcode address
                    BEQ.S          .noerrorcodewanted
                    MOVEA.L        D0,A0
                    MOVE.L         D6,(A0)                  ; return error code
.noerrorcodewanted  MOVE.L         D6,D1                    ; always set result2
                    MOVEA.L        $2A(A5),A6               ; dosbase
                    JSR            _LVOSetIoErr(A6)
                    MOVE.L         (SP)+,D0
                    MOVEM.L        (SP)+,D6-D7/A1/A3/A5-A6
                    RTS

;------------------------------------------------------------------

                    CNOP           0,4

; NewDiskObject -- Create an empty icon (V44)
; icon = NewDiskObject(type)
; D0                   D0
; struct DiskObject * NewDiskObject(LONG type);

NewDiskObject       CLR.L          -(SP)                    ; clear the result
                    TST.L          D0
                    BLE.S          .wrongtype
                    MOVEQ          #7,D1
                    CMP.L          D1,D0
                    BGT.S          .wrongtype
                    LEA            DiskObjectTypes(PC),A0
 ifd MC68020
                    ADDA.W         -2(A0,D0.L*2),A0
 else
                    ADD.W          D0,D0
                    ADDA.W         -2(A0,D0.W),A0
 endif
                    LEA            (SP),A1                  ; target pointer
                    MOVEQ          #%00000011,D0            ; set copy flags
                    MOVE.L         A5,-(SP)
                    MOVEA.L        A6,A5                    ; iconbase
                    BSR.W          copyStructDO             ; but no image data
                    MOVEA.L        (SP)+,A5
                    MOVE.L         D0,D1
                    BNE.S          .errorcode
                    MOVEA.L        (SP),A1                  ; new DO structure
                    MOVEA.L        $16(A1),A0               ; GadgetRender
                    MOVEQ          #5-1,D1
.clearGadgetRender  MOVE.L         D0,(A0)+                 ; clear 20 bytes
                    DBRA           D1,.clearGadgetRender
                    MOVE.L         $1A(A1),D1               ; SelectRender
                    BEQ.S          .oneimageonly            ; not really nice !
                    MOVEA.L        D1,A0
                    MOVEQ          #5-1,D1
.clearSelectRender  MOVE.L         D0,(A0)+                 ; clear 20 bytes
                    DBRA           D1,.clearSelectRender
.oneimageonly       CLR.L          $C(A1)                   ; width=0, height=0
.done               MOVE.L         (SP)+,D0
                    RTS

.wrongtype          MOVEQ          #$6A,D1
                    ADD.L          D1,D1                    ; error 212
.errorcode          MOVE.L         A6,-(SP)
                    MOVEA.L        $2A(A6),A6               ; dosbase
                    JSR            _LVOSetIoErr(A6)
                    MOVEA.L        (SP)+,A6
                    BRA.S          .done

;------------------------------------------------------------------

                    CNOP           0,4

; FreeAlloc - allocate a memory block and log this in a freelist.
; FreeAlloc(freelist, size, attributes)
;     D0         A0    A1    A2                             ; needs no A6=iconbase
; * memblock                                                ; iconPrivate7

FreeAlloc           MOVE.L         A1,D0                    ; bytes
                    BEQ.S          .quit
                    MOVEM.L        D2/A2/A6,-(SP)
                    MOVE.L         A2,D1                    ; attributes
                    MOVE.L         D0,D2                    ; bytes
                    MOVEA.L        A0,A2                    ; FreeList
                    MOVEA.L        (4).w,A6                 ; execbase
                    JSR            _LVOAllocMem(A6)
                    MOVEA.L        A2,A0                    ; FreeList
                    MOVEA.L        D2,A2                    ; bytes
                    MOVE.L         D0,D2
                    BEQ.S          .nomem
                    MOVEA.L        D0,A1                    ; memblock
                    BSR.S          fastAFL
                    BNE.S          .done
                    MOVEA.L        D2,A1                    ; memblock
                    MOVE.L         A2,D0                    ; bytes
                    JSR            _LVOFreeMem(A6)
                    MOVEQ          #0,D2
.done               MOVE.L         D2,D0
.nomem              MOVEM.L        (SP)+,D2/A2/A6
.quit               RTS

;------------------------------------------------------------------

                    CNOP           0,4

; AddFreeList - add memory to a free list.
; status = AddFreeList(free, mem, len)
;   D0                  A0    A1   A2                       ; needs no A6=iconbase
; BOOL AddFreeList(struct FreeList *, APTR, ULONG)

AddFreeList         MOVE.L         A0,D0
                    BEQ.S          quitAFL                  ; no freelist
                    MOVE.L         A1,D0
                    BEQ.S          quitAFL                  ; no memblock
                    MOVE.L         A2,D0
                    BEQ.S          quitAFL                  ; no length
fastAFL             MOVEM.L        A1-A4/A6,-(SP)
                    MOVEA.L        A0,A2                    ; V44 freelist
                    LEA            2+8(A2),A3               ; V44 *lh_TailPred
                    MOVE.L         (A3),D0                  ; lh_TailPred
                    BEQ.S          .error                   ; bad freelist
                    MOVEA.L        D0,A4                    ; goto last V44 node
.trythenextnode     MOVEA.L        (A4),A4                  ; ln_Succ
                    TST.L          (A4)                     ; is it lh_Tail ?
                    BNE.S          .trythenextnode
                    MOVE.L         4(A4),(A3)               ; update lh_TailPred
                    BEQ.S          .error                   ; bad freelist
                    SUBQ.W         #2+4,A4                  ; oldWB freelist
                    MOVE.W         (A4),(A2)                ; update fl_NumFree
                    SUBQ.W         #1,(A2)                  ; fl_NumFree - 1
                    BCC.S          .updatefreelist
                    ADDQ.W         #1,(A2)                  ; fl_NumFree + 1
                    MOVEQ          #80,D0
                    ADD.L          D0,D0                    ; 160 bytes extension
                    MOVEA.L        (4).w,A6                 ; execbase
                    MOVE.L         #MEMF_PUBLIC|MEMF_CLEAR,D1
                    JSR            _LVOAllocMem(A6)         ; node=14 + number=2
                    TST.L          D0                       ; + entry array=18*8
                    BEQ.S          .error
                    MOVEA.L        D0,A1                    ; new memlist node
                    MOVE.W         #17,(A2)                 ; fl_NumFree = 17
                    MOVE.W         #18,$E(A1)               ; ml_NumEntries = 18
                    MOVEA.L        (A3),A6                  ; A6 = lh_TailPred
                    MOVE.L         A1,(A3)                  ; new lh_TailPred=A1
                    MOVEM.L        A3/A6,(A1)               ; succ=A3, pred=A6
                    SUBQ.L         #4,(A1)                  ; last Succ=lh_Tail
                    MOVE.L         A1,(A6)                  ; A6 Succ = new node
.updatefreelist     MOVE.W         (A2),D0                  ; V44 fl_NumFree
                    MOVE.W         D0,(A4)                  ; update fl_NumFree
                    MOVEA.L        (A3),A0                  ; get the last node
                    ADDQ.W         #2+4,A4                  ; *oldWB lh_Tail
                    MOVE.L         A4,(A0)                  ; last succ=*lh_Tail
                    MOVE.L         A0,4(A4)                 ; update lh_TailPred
 ifd MC68020
                    LEA            $10(A0,D0.W*8),A0        ; goto last unused
 else
                    LSL.W          #3,D0
                    LEA            $10(A0,D0.W),A0
 endif
                    MOVE.L         (SP),(A0)+               ; store memblock
                    MOVE.L         4(SP),(A0)               ; store byte size
                    MOVEQ          #1,D0                    ; status OK
.error              MOVEM.L        (SP)+,A1-A4/A6
quitAFL             RTS

;------------------------------------------------------------------

                    CNOP           0,4

; FreeDiskObject - free all memory in a Workbench disk object.
; FreeDiskObject(diskobj)
;                 A0
; void FreeDiskObject(struct DiskObject *);

FreeDiskObject      MOVE.L         A0,D0                    ; icon ?
                    BEQ.S          .error
 ifd MC68020
                    CMPI.W         #$E310,(A0)              ; DiskMagic found ?
 else
                    CMPI.B         #$E3,(A0)
 endif
                    BNE.S          .error
                    LEA            $5E(A0),A1               ; check v44 extension
                    CMPA.L         (A1),A1                  ; magic selfpointer ?
                    BEQ.S          .freediskobject
.error              RTS

.freediskobject     MOVEM.L        A4-A6,-(SP)
                    MOVEA.L        A0,A4                    ; this icon
                    MOVEA.L        A6,A5                    ; iconbase
                    BSET.B         #1,$F1(A5)               ; V44 icon protection
                    BEQ.S          .removeiconnode
                    BSR.W          bitlockdelay

.removeiconnode     LEA            $62(A4),A1               ; remove v44 node
                    MOVEA.L        $26(A5),A6               ; execbase
                    JSR            _LVORemove(A6)
                    MOVEA.L        $76(A4),A0               ; PalMap1
                    MOVEA.L        $86(A4),A1               ; icons screen
                    BSR.W          releasepens
                    MOVEA.L        $7A(A4),A0               ; PalMap2
                    MOVEA.L        $86(A4),A1               ; icons screen
                    BSR.W          releasepens
                    SUBQ.B         #2,$F1(A5)               ; clear V44 protection
                    MOVEA.L        $32(A5),A6               ; gfxbase
                    JSR            _LVOWaitBlit(A6)
                    LEA            $7E(A4),A1               ; mask1
                    BSR.W          freerastermem
                    LEA            $82(A4),A1               ; mask2
                    BSR.W          freerastermem
                    LEA            $4E(A4),A0               ; freelist
                    MOVEA.L        A5,A6                    ; iconbase
                    BSR.S          fastFFL
                    CLR.L          (A4)                     ; remove DiskMagic to
                    MOVEQ          #71,D0                   ; prevent further usage
                    ADD.L          D0,D0                    ; 142 bytes
                    MOVEA.L        A4,A1                    ; free D0 structure
                    MOVEA.L        $26(A5),A6               ; execbase
                    JSR            _LVOFreeMem(A6)
                    MOVEM.L        (SP)+,A4-A6
                    RTS

;------------------------------------------------------------------

                    CNOP           0,4

; FreeFreeList - free all memory in a free list.
; FreeFreeList(free)
;               A0
; void FreeFreeList(struct FreeList *) this is usually not at icon offset $4E

FreeFreeList        MOVE.L         A0,D0                    ; struct FreeList
                    BEQ.S          quitFFL
fastFFL             ADDQ.W         #2,A0
                    MOVE.L         LH_TAILPRED(A0),D0
                    BEQ.S          quitFFL                  ; bad FreeList
                    CMP.L          D0,A0                    ; TailPred=*Head ?
                    BEQ.S          quitFFL                  ; empty FreeList
                    MOVEM.L        A2/A3/A6,-(SP)
                    MOVEA.L        (A0),A0                  ; first entry
                    MOVEA.L        $26(A6),A6               ; execbase
                    LEA            _LVOFreeEntry(A6),A3
                    CMPI.W         #$4EF9,(A3)              ; is it a JMP ?
                    BNE.S          .tryfirst
                    MOVEA.L        2(A3),A3                 ; use JMP target
                    BRA.S          .tryfirst

.freenext           JSR            (A3)                     ; fast FreeEntry()
                    MOVEA.L        A2,A0
.tryfirst           MOVEA.L        (A0),A2                  ; ln_succ
                    MOVE.L         A2,D0                    ; last node ?
                    BNE.S          .freenext
                    MOVEM.L        (SP)+,A2/A3/A6
quitFFL             RTS

;------------------------------------------------------------------

                    CNOP           0,4

; FreeRemove - remove a memblock from a free list.          ; iconPrivate8
; FreeRemove(free, mem)
;             A0    A1                                      ; needs no A6=iconbase
; void FreeRemove(struct FreeList *, APTR)

FreeRemove          MOVE.L         A0,D0
                    BNE.S          checkmemblock
DOFreeRemove        MOVE.L         A0,D0                    ; checks DiskObject
                    BEQ.S          quitFR                   ; no freelist
                    MOVEQ          #-$10,D1
                    ADD.L          $5E-$4E(A0),D1           ; +magic selfpointer
                    CMP.L          A0,D1
                    BNE.S          quitFR                   ; corrupt freelist
checkmemblock       MOVE.L         A1,D1
                    BEQ.S          quitFR                   ; no memblock
                    MOVEM.L        A2-A4/A6,-(SP)
                    LEA            2+LH_TAILPRED(A0),A3     ; V44 *lh_TailPred
                    ADDQ.L         #2,D0                    ; *lh_Head
                    MOVE.L         (A3),D1                  ; lh_TailPred
                    BEQ.S          .done                    ; bad FreeList
                    CMP.L          D1,D0
                    BEQ.S          .done                    ; empty FreeList
                    MOVEA.L        D1,A4                    ; goto last V44 node
.getLH_TAILfromWB   MOVEA.L        (A4),A4                  ; ln_Succ
                    TST.L          (A4)                     ; is it lh_Tail ?
                    BNE.S          .getLH_TAILfromWB
                    MOVE.L         4(A4),(A3)               ; update lh_TailPred
                    BEQ.S          .done                    ; bad FreeList
                    SUBQ.W         #2+4,A4                  ; oldWB freelist
                    MOVE.W         (A4),(A0)+               ; update fl_NumFree
.nextnode           MOVEA.L        (A0),A0
                    TST.L          (A0)                     ; tail node done ?
                    BEQ.S          .done
                    LEA            $C(A0),A2
                    MOVE.W         ML_NUMENTRIES(A0),D0
.nextentry          SUBQ.W         #1,D0
                    BCS.S          .nextnode
                    ADDQ.W         #4,A2                    ; next meu_Addr
                    CMPA.L         (A2)+,A1                 ; memblock found ?
                    BNE.S          .nextentry
                    MOVE.L         (A2),D0                  ; size = me_Length
                    MOVEA.L        (4).w,A6                 ; execbase
                    JSR            _LVOFreeMem(A6)
                    MOVE.W         (A4),D0                  ; fl_NumFree
                    MOVEA.L        (A3),A1                  ; get last node
                    CLR.L          (A2)                     ; clear me_Length
                    CLR.L          -(A2)                    ; clear meu_Addr
                    CMP.W          ML_NUMENTRIES(A1),D0
                    BCC.S          .done                    ; all entries free
 ifd MC68020
                    LEA            $10(A1,D0.W*8),A1        ; first used entry
 else
                    LSL.W          #3,D0
                    LEA            $10(A1,D0.W),A1          ; first used entry
 endif
                    MOVE.L         (A1),D0                  ; save meu_Addr
                    CLR.L          (A1)+                    ; clear old entry
                    MOVE.L         D0,(A2)+                 ; move meu_Addr
                    MOVE.L         (A1),(A2)                ; move me_Length
                    CLR.L          (A1)                     ; clear old entry
                    ADDQ.W         #1,(A4)                  ; WB fl_NumFree + 1
                    MOVE.W         (A4),-10(A3)             ; sync fl_NumFree
.done               MOVEM.L        (SP)+,A2-A4/A6
quitFR              RTS

;------------------------------------------------------------------

newicontooltypes    MOVEM.L        D6-D7/A2-A3,-(SP)        ; D1=mode A3=DiskObject
                    MOVEA.L        do_ToolTypes(A3),A2
                    MOVE.L         A2,D0                    ; tooltype array ?
                    BEQ.S          .done
                    MOVE.W         #$2000,D6                ; " ",$0
.nexttoolstring     MOVE.L         (A2)+,D0
                    BEQ.S          .done
                    MOVEA.L        D0,A0                    ; toolstring
                    CMP.W          (A0),D6                  ; " ",$0 ?
                    BNE.S          .nexttoolstring
                    MOVE.L         (A2),D0
                    BEQ.S          .done
                    MOVEA.L        D0,A0                    ; toolstring after " "
                    LEA            string_DontEdit(PC),A1
                    MOVEQ          #0,D0
.nextcharacter      MOVE.B         (A0)+,D7                 ; toolstring character
                    CMP.B          (A1)+,D7                 ; textstring character
                    BNE.S          .nexttoolstring
                    TST.B          D7                       ; end of text ?
                    BNE.S          .nextcharacter
                    TST.B          D1                       ; which mode ?
                    BEQ.S          .justfind_DontEdit
                    MOVEA.L        A2,A1
.counttooltypes     TST.L          (A1)+
                    BNE.S          .counttooltypes
                    MOVE.L         A1,D7
                    MOVEA.L        A2,A3
                    ADDQ.W         #4,A3                    ; points below DontEdit
                    SUB.L          A3,D7
                    LSR.L          #2,D7                    ; number of tooltypes
                    SUBQ.W         #4,A2                    ; points to " ",0
.nextimagecodefound ADDQ.L         #1,D0                    ; image string counter
.checkforendofarray CMP.L          D7,D0                    ; last string reached ?
                    BCC.S          .cutNewIconCodeOff
                    MOVEA.L        A3,A0                    ; next array tooltype
                    MOVEA.L        (A3)+,A1                 ; examine this string
                    CMPI.L         #"IM1=",(A1)
                    BEQ.S          .nextimagecodefound
                    CMPI.L         #"IM2=",(A1)
                    BEQ.S          .nextimagecodefound
                    MOVE.L         A1,D1
                    MOVEA.L        A3,A1                    ; target below source
                    MOVE.L         D0,D6                    ; image string counter
.shiftstringsdown   MOVE.L         -(A0),-(A1)
                    DBRA           D6,.shiftstringsdown
                    MOVE.L         D1,(A2)+                 ; lowest string to top
                    SUBQ.L         #1,D7                    ; 1 entry less to move
                    BHI.S          .checkforendofarray
.cutNewIconCodeOff  CLR.L          (A2)+                    ; snip NewIcon strings
                    MOVEA.L        $C(SP),A0                ; DiskObject
                    MOVE.L         A2,$6A(A0)               ; NewIconImage strings
.justfind_DontEdit  MOVE.L         A2,D0
.done               MOVEM.L        (SP)+,D6-D7/A2-A3
                    RTS

;------------------------------------------------------------------

newiconimages       CLR.L          -(SP)                    ; clear PalMap entry2
                    CLR.L          -(SP)                    ; clear PalMap entry1
                    MOVEM.L        D7/A2-A3/A6,-(SP)        ; A3 = DiskObject
                    LEA            $4E(A3),A2               ; freelist
                    MOVEA.L        A0,A3                    ; NewIconImage strings
                    MOVEA.L        A5,A6                    ; iconbase
                    MOVE.L         #"IM1=",D1               ; mode = image1
                    LEA            $10(SP),A1               ; *PalMap entry1
                    BSR.S          newicon2palmap           ; A3=imagetoolstrings
                    MOVE.L         D0,D7                    ; error code
                    BNE.S          .error
                    MOVE.L         #"IM2=",D1               ; mode = image2
                    LEA            $14(SP),A1               ; *PalMap entry2
                    BSR.S          newicon2palmap           ; A3=imagetoolstrings
                    MOVE.L         D0,D7                    ; error code
                    BEQ.S          .checkPalMaps
                    MOVEQ          #$32,D1
                    NOT.B          D1
                    CMP.L          D1,D0                    ; object not found ?
                    BNE.S          .error
.checkPalMaps       MOVEM.L        $10(SP),A0-A1            ; PalMap1, PalMap2
                    MOVE.L         A0,D7
                    BEQ.S          .wrongtype
                    MOVE.L         A1,D0
                    BEQ.S          .storePalMaps
                    MOVE.L         (A0),D0                  ; width1, height1
                    CMP.L          (A1),D0                  ; width2, height2
                    BEQ.S          .storePalMaps
                    MOVEA.L        A2,A0                    ; freelist
                    BSR.W          DOFreeRemove             ; needs no iconbase    
                    SUBA.L         A1,A1                    ; PalMap2 removed
.storePalMaps       MOVEA.L        8(SP),A0                 ; DiskObject A3->stack
                    MOVEM.L        D7/A1,$76(A0)            ; set PalMap1, PalMap2
                    MOVEQ          #0,D0                    ; no error
                    BRA.S          .done

.wrongtype          MOVEQ          #$6A,D7
                    ADD.L          D7,D7                    ; object of wrong type
.error              MOVEA.L        A2,A0                    ; freelist
                    MOVEA.L        $10(SP),A1               ; PalMap1
                    BSR.W          DOFreeRemove             ; needs no iconbase    
                    MOVEA.L        A2,A0                    ; freelist
                    MOVEA.L        $14(SP),A1               ; PalMap2
                    BSR.W          DOFreeRemove             ; needs no iconbase    
                    MOVE.L         D7,D0                    ; error code
.done               MOVEM.L        (SP)+,D7/A2-A3/A6
                    ADDQ.W         #8,SP
                    RTS

;------------------------------------------------------------------

newicon2palmap      LEA            -$C(SP),SP
                    MOVEM.L        D1-D7/A1-A5,-(SP)        ; A1=*PalMap, A6=ibase
                    MOVE.L         A3,D0                    ; NewIconImage strings
                    BNE.S          .nexttooltype            ; D1= "IM1=" or "IM2="
.notooltype         MOVEQ          #$32,D0
                    NOT.B          D0                       ; 205 object not found
                    BRA.W          .done

.objectwrongtype    MOVEA.L        $20(SP),A0               ; freelist A2->stack
                    MOVEA.L        $30(SP),A1               ; PalMap structure
                    BSR.W          DOFreeRemove             ; needs no iconbase
.wrongtype          MOVEQ          #$6A,D0
                    ADD.L          D0,D0                    ; 212 object wrong type
                    BRA.W          .done

.nexttooltype       MOVE.L         (A3)+,A4
                    MOVE.L         A4,D0
                    BEQ.S          .notooltype
                    CMP.L          (A4)+,D1
                    BNE.S          .nexttooltype
                    MOVEA.L        A4,A0                    ; start of image code
                    MOVEQ          #5-1,D0                  ; we need 5 characters
.checkinputchars    TST.B          (A0)+
                    DBEQ           D0,.checkinputchars
                    BEQ.S          .wrongtype
                    MOVEQ          #"B",D5                  ; "B" for transparency
                    SUB.B          (A4)+,D5
                    MOVE.L         D5,D0                    ; first char = "B" ?
                    BEQ.S          .validimagecode
                    ADDQ.B         #1,D0                    ; first char = "C" ?
                    BNE.S          .wrongtype
.validimagecode     MOVEQ          #0,D0
                    MOVEQ          #33,D3
                    NEG.W          D3                       ; digit = char - 33
                    MOVE.L         D3,D4
                    MOVE.B         (A4)+,D0
                    ADD.W          D0,D3                    ; width > 0 ?
                    BLE.S          .wrongtype
                    MOVE.B         (A4)+,D0
                    ADD.W          D0,D4                    ; height > 0 ?
                    BLE.S          .wrongtype
                    MOVEQ          #33,D0
                    NEG.B          D0                       ; digit = char - 33
                    MOVE.L         D0,D6
                    ADD.B          (A4)+,D0
                    BMI.S          .wrongtype
                    ADD.B          (A4)+,D6
                    BMI.S          .wrongtype
                    LSL.L          #6,D0
                    ADD.L          D0,D6                    ; 0 < number of colors
                    BLE.S          .wrongtype
                    CMPI.W         #257,D6                  ; > 257 ?
                    BGT.S          .wrongtype
                    MOVEA.L        D6,A1                    ; number of i-colors
                    MOVE.L         D3,D7                    ; width
                    MULU.W         D4,D7                    ; width * height
                    MOVEM.L        D7/A1,$34(SP)            ; store size, colors
                    ADDA.L         D6,A1
                    ADDA.L         D6,A1                    ; 3 * i-colors
                    MOVE.L         A1,D2                    ;   save 3 * i-colors
                    ADDQ.L         #3,D7
                    ANDI.B         #$FC,D7                  ;   round up image size
                    ADDA.L         D7,A1                    ; + image size
                    LEA            $120(A1),A1              ; + size of PalMap
                    MOVEA.L        A2,A0                    ; freelist
                    MOVEA.W        #MEMF_PUBLIC,A2
                    BSR.W          FreeAlloc                ; needs no iconbase
                    MOVE.L         D0,$30(SP)               ; store * PalMap
                    BEQ.S          .nofreemem
                    MOVEA.L        D0,A0                    ; PalMap structure
                    LEA            $120(A0),A2              ; image bytes offset
                    MOVE.W         D3,(A0)+                 ; width
                    MOVE.W         D4,(A0)+                 ; height
                    MOVE.L         A2,(A0)+                 ; * image bytes
                    MOVEQ          #64-1,D0
                    MOVEQ          #0,D3                    ; clear input character
.clear256bytes      MOVE.L         D3,(A0)+                 ; clear 256 registers
                    DBRA           D0,.clear256bytes
                    MOVEA.L        A2,A5
                    ADDA.L         D7,A5                    ; add image size
                    MOVE.L         A5,(A0)+                 ; * RGB bytes
                    CMPI.W         #256,D6                  ; > 256 colors ?
                    BLS.S          .validcolorcount
                    MOVE.W         #256,D6
.validcolorcount    TST.B          D5                       ; 1.NewIcon char = B ?
                    SEQ            (A0)+                    ; transparency flag
                    CLR.B          (A0)+                    ; transparent color
                    MOVE.W         D6,(A0)+                 ; number of colors
                    CLR.L          (A0)+                    ; no zlib-image size
                    CLR.L          (A0)+                    ; no zlib-image
                    CLR.L          (A0)+                    ; no TCbuffer yet
                    CLR.L          (A0)                     ; not mapped, no magic
                    MOVEQ          #8,D7                    ; 8 bit RGB output
                    MOVEA.W        #$FF,A1                  ; 8 bit mask
                    EXG            D7,A1
                    BRA.S          .getnextinputchar

.nofreemem          MOVEQ          #$67,D0                  ; out of memory
                    BRA.W          .done

.writeimagebytes    MOVEA.L        A2,A5                    ; * image bytes
                    MOVEM.L        $34(SP),D2/D7            ; number bytes, colors
                    SUBQ.L         #1,D7                    ; highest color number
                    MOVEQ          #0,D1                    ; bit counter
.findallusedbits    ADDQ.B         #1,D1
                    LSR.L          #1,D7                    ; shift to higher bit
                    BNE.S          .findallusedbits
                    BSET.L         D1,D7
                    SUBQ.L         #1,D7                    ; plane mask for colors
                    MOVEA.L        D1,A1                    ; number of used bits
.neednewtooltype    MOVE.L         (SP),D0                  ; "IM1=" or "IM2="
.trynexttooltype    MOVEA.L        (A3)+,A4
                    MOVE.L         A4,D4
                    BEQ.W          .objectwrongtype
                    CMP.L          (A4)+,D0
                    BNE.S          .trynexttooltype
.getnextinputchar   MOVEQ          #0,D4                    ; output data stream
                    MOVEQ          #0,D5                    ; data shift counter
                    MOVEQ          #0,D6                    ; NULL repeat counter
.trynextinputchar   MOVE.B         (A4)+,D3                 ; input character
                    BEQ.S          .neednewtooltype
.decodeinputchar    LSL.L          #7,D4                    ; shift code 7 bits up
                    MOVEQ          #32,D0                   ; 7 bit code or counter
                    SUB.B          D0,D3                    ; code = char - 32
                    MOVEQ          #80,D1
                    CMP.B          D1,D3                    ; < 80 ? char = 32-111
                    BCS.S          .ORwithCode
                    SUBI.B         #49,D3                   ; code = char - 81
                    MOVE.L         D3,D1
                    SUBI.B         #128,D1                  ; <128 ? char = 112-208
                    BCS.S          .ORwithCode
                    MOVE.L         D1,D6                    ; NULL repeat counter
                    BRA.S          .trytowrite

.neednextinput      ADD.L          A1,D5                    ; revert output shift
                    TST.L          D6                       ; repeat NULL ?
                    BLE.S          .trynextinputchar
                    SUBQ.L         #1,D6                    ; NULL repeat count - 1
                    LSL.L          #7,D4                    ; shift code 7 bit up
                    BRA.S          .trytowrite

.ORwithCode         OR.L           D3,D4                    ; OR with 7 bit code
.trytowrite         ADDQ.L         #7,D5                    ; shift count + 7
.trytowriteagain    SUB.L          A1,D5                    ; subtract output bits
                    BCS.S          .neednextinput
                    MOVE.L         D4,D0                    ; output data stream
                    LSR.L          D5,D0                    ; get highest byte
                    AND.B          D7,D0                    ; mask out color planes
                    MOVE.B         D0,(A5)+                 ; write out one byte
                    SUBQ.L         #1,D2                    ; remaining bytes
                    BHI.S          .trytowriteagain
                    MOVEA.L        $30(SP),A0               ; PalMap structure
                    CMPA.L         $108(A0),A5              ; * RGB bytes passed ?
                    BHI.S          .writeimagebytes
                    MOVEA.L        $1C(SP),A1               ; result pointer
                    MOVE.L         A0,(A1)                  ; save PalMap structure
                    MOVEQ          #0,D0                    ; no error
.done               MOVEM.L        (SP)+,D1-D7/A1-A5
                    LEA            $C(SP),SP
                    RTS

;-------------------------------------------------------------------------

; The following WBObject functions are outdated and not supported anymore.

GetWBObject                                                 ; iconPrivate1
PutWBObject                                                 ; iconPrivate2
AllocWBObject                                               ; iconPrivate6

                    MOVE.L         A6,-(SP)                 ; iconbase
                    MOVEA.L        $2A(A6),A6               ; dosbase
                    MOVEQ          #$2E,D1
                    NOT.B          D1                       ; Result2 = $D1 = 209
                    JSR            _LVOSetIoErr(A6)         ; request type unknown
                    MOVEA.L        (SP)+,A6
FreeWBObject        MOVEQ          #0,D0                    ; iconPrivate5
                    RTS

;------------------------------------------------------------------

                    CNOP           0,4

; FindToolType - find the value of a ToolType variable.
; value = FindToolType(toolTypeArray, typeName)
;   D0                      A0           A1
; STRPTR FindToolType(STRPTR *, STRPTR);

FindToolType        MOVE.L         A0,D0
                    BEQ.S          .quit
                    MOVE.L         A1,D0
                    BEQ.S          .quit
                    MOVEM.L        D2/A2-A4/A6,-(SP)
                    MOVEA.L        A0,A2                    ; toolTypeArray
                    MOVEA.L        A1,A4                    ; typeName
                    MOVEA.L        $2E(A6),A6               ; utilbase
.size               TST.B          (A1)+
                    BNE.S          .size
                    SUBQ.W         #1,A1
                    SUBA.L         A4,A1
                    MOVE.L         A1,D2                    ; name length
.next               MOVE.L         (A2)+,D0                 ; next string
                    BEQ.S          .done
                    MOVEA.L        D0,A3
                    MOVEQ          #" ",D0
.skip1              CMP.B          (A3)+,D0
                    BEQ.S          .skip1                   ; skip spaces
                    SUBQ.W         #1,A3
                    MOVE.L         D2,D0                    ; length
                    MOVEA.L        A3,A0                    ; string
                    MOVEA.L        A4,A1                    ; name
                    JSR            _LVOStrnicmp(A6)         ; localized compare
                    TST.L          D0
                    BNE.S          .next
                    ADDA.L         D2,A3
                    MOVEQ          #" ",D0
.skip2              CMP.B          (A3)+,D0
                    BEQ.S          .skip2                   ; skip spaces
                    SUBQ.W         #1,A3
                    MOVE.B         (A3)+,D1
                    BEQ.S          .none                    ; end of string ?
                    CMPI.B         #"=",D1
                    BNE.S          .next
.skip3              CMP.B          (A3)+,D0
                    BEQ.S          .skip3                   ; skip spaces
.none               SUBQ.W         #1,A3
                    MOVE.L         A3,D0
.done               MOVEM.L        (SP)+,D2/A2-A4/A6
.quit               RTS

;------------------------------------------------------------------

                    CNOP           0,4

; MatchToolValue - check a tool type variable for a particular value.
; result = MatchToolValue(typeString, value)
;   D0                        A0        A1
; BOOL MatchToolValue(STRPTR, STRPTR);

MatchToolValue      MOVEM.L        D2-D5/A2-A3/A6,-(SP)
                    MOVE.L         A0,D0
                    BEQ.W          .done
                    MOVE.L         A1,D0
                    BEQ.W          .done
                    MOVEQ          #$20,D0                  ; space character
.head0              CMP.B          (A0)+,D0
                    BEQ.S          .head0                   ; leading spaces
                    TST.B          -(A0)                    ; first char or null
                    MOVEA.L        A0,A2                    ; start of typeString
                    BEQ.S          .empty0                  ; empty string
.count0             TST.B          (A0)+
                    BNE.S          .count0
                    SUBQ.W         #1,A0
.tail0              CMP.B          -(A0),D0
                    BEQ.S          .tail0                   ; trailing spaces
                    ADDQ.W         #1,A0
.empty0             MOVE.L         A0,D2
                    SUB.L          A2,D2                    ; length of typeString
.head1              CMP.B          (A1)+,D0
                    BEQ.S          .head1                   ; leading spaces
                    TST.B          -(A1)                    ; first char or null
                    MOVEA.L        A1,A3                    ; start of value
                    BEQ.S          .empty1                  ; empty string
.count1             TST.B          (A1)+
                    BNE.S          .count1
                    SUBQ.W         #1,A1
.tail1              CMP.B          -(A1),D0
                    BEQ.S          .tail1                   ; trailing spaces
                    ADDQ.W         #1,A1
.empty1             MOVE.L         A1,D3
                    SUB.L          A3,D3                    ; length of value
                    MOVEQ          #0,D4                    ; word offset = 0
                    MOVEQ          #0,D5                    ; seek offset = 0
                    MOVEA.L        $2E(A6),A6               ; utilbase
.next               MOVEQ          #$7C,D1                  ; "|" character (wall)
                    CMP.B          (A2,D5.L),D1
                    BEQ.S          .wall
                    CMP.L          D2,D5                    ; end of typeString ?
                    BNE.S          .seek
.wall               MOVE.L         D5,D0                    ; wall = seek offset
                    SUB.L          D4,D0                    ; wall - word = size
                    MOVEA.L        A2,A0                    ; start of typeString
                    ADDA.L         D4,A0                    ; start + word offset
                    BLS.S          .size                    ; size = empty word
                    MOVEA.L        A0,A1                    ; word position
                    ADDA.L         D0,A1                    ; wall position
                    MOVEQ          #$20,D1                  ; space character
.head2              CMP.B          (A0)+,D1
                    BNE.S          .tail3
                    SUBQ.L         #1,D0                    ; size - 1
                    BHI.S          .head2                   ; leading spaces
.word               MOVE.L         D5,D4                    ; word = seek offset
                    ADDQ.L         #1,D4                    ; word offset + 1
.seek               ADDQ.L         #1,D5                    ; seek offset + 1
                    CMP.L          D2,D5                    ; offset - length ?
                    BLS.S          .next                    ; offset ok
.fail               MOVEQ          #0,D0                    ; no match
                    BRA.S          .done

                    CNOP           0,4                      ; Aligns CopyMemBlock
                                                            ; .copy64 to longword

.tail2              SUBQ.L         #1,D0                    ; size - 1
.tail3              CMP.B          -(A1),D1
                    BEQ.S          .tail2                   ; trailing spaces
                    SUBQ.W         #1,A0                    ; start of word
.size               CMP.L          D3,D0                    ; size = length ?
                    BNE.S          .word                    ; next word
                    MOVEA.L        A3,A1                    ; start of value
                    JSR            _LVOStrnicmp(A6)         ; localized compare
                    TST.L          D0
                    BNE.S          .word                    ; next word
                    MOVEQ          #1,D0                    ; match found
.done               MOVEM.L        (SP)+,D2-D5/A2-A3/A6
                    RTS

;------------------------------------------------------------------

 ifnd MC68020
CopyMemBlock        MOVE.W         D0,-(SP)
                    MOVE.W         A0,D0
                    SUB.W          A1,D0
                    ANDI.W         #1,D0
                    BEQ.S          .alignCopyMem
                    MOVE.W         (SP)+,D0
                    ROR.L          #4,D0                    ; blocks < 1 MB only
                    SUBQ.W         #1,D0
                    BMI.S          .less16
.copy16             MOVE.B         (A0)+,(A1)+
                    MOVE.B         (A0)+,(A1)+
                    MOVE.B         (A0)+,(A1)+
                    MOVE.B         (A0)+,(A1)+
                    MOVE.B         (A0)+,(A1)+
                    MOVE.B         (A0)+,(A1)+
                    MOVE.B         (A0)+,(A1)+
                    MOVE.B         (A0)+,(A1)+
                    MOVE.B         (A0)+,(A1)+
                    MOVE.B         (A0)+,(A1)+
                    MOVE.B         (A0)+,(A1)+
                    MOVE.B         (A0)+,(A1)+
                    MOVE.B         (A0)+,(A1)+
                    MOVE.B         (A0)+,(A1)+
                    MOVE.B         (A0)+,(A1)+
                    MOVE.B         (A0)+,(A1)+
                    DBRA           D0,.copy16
.less16             CLR.W          D0
                    ROL.L          #3,D0
                    BMI.S          .copy1
                    BRA.S          .test2

.copy2              MOVE.B         (A0)+,(A1)+
.copy1              MOVE.B         (A0)+,(A1)+
.test2              DBRA           D0,.copy2
.done               RTS

.alignCopyMem       MOVE.W         (SP),D0
                    MOVE.W         A0,(SP)
                    ANDI.W         #1,(SP)+
                    BEQ.S          CopyMemAligned
                    SUBQ.L         #1,D0
                    BMI.S          .done
                    MOVE.B         (A0)+,(A1)+              ; for some PNG icons
 else
CopyMemBlock
 endif
CopyMemAligned      ROR.L          #6,D0                    ; blocks < 4 MB only
                    SUBQ.W         #1,D0                    ; size - 16 longwords
                    BCS.S          .less64
.copy64             MOVE.L         (A0)+,(A1)+
                    MOVE.L         (A0)+,(A1)+
                    MOVE.L         (A0)+,(A1)+
                    MOVE.L         (A0)+,(A1)+
                    MOVE.L         (A0)+,(A1)+
                    MOVE.L         (A0)+,(A1)+
                    MOVE.L         (A0)+,(A1)+
                    MOVE.L         (A0)+,(A1)+
                    MOVE.L         (A0)+,(A1)+
                    MOVE.L         (A0)+,(A1)+
                    MOVE.L         (A0)+,(A1)+
                    MOVE.L         (A0)+,(A1)+
                    MOVE.L         (A0)+,(A1)+
                    MOVE.L         (A0)+,(A1)+
                    MOVE.L         (A0)+,(A1)+
                    MOVE.L         (A0)+,(A1)+              ; 16 longwords copied
                    DBRA           D0,.copy64
.less64             ROL.L          #4,D0                    ; D0.W from -1 to -16
                    NOT.L          D0                       ; D0.W 0-15 longwords
 ifd MC68020
                    JMP            .long(PC,D0.W*2)
 else
                    ADD.W          D0,D0
                    JMP            .long(PC,D0.W)
 endif
.long               MOVE.L         (A0)+,(A1)+
                    MOVE.L         (A0)+,(A1)+
                    MOVE.L         (A0)+,(A1)+
                    MOVE.L         (A0)+,(A1)+
                    MOVE.L         (A0)+,(A1)+
                    MOVE.L         (A0)+,(A1)+
                    MOVE.L         (A0)+,(A1)+
                    MOVE.L         (A0)+,(A1)+
                    MOVE.L         (A0)+,(A1)+
                    MOVE.L         (A0)+,(A1)+
                    MOVE.L         (A0)+,(A1)+
                    MOVE.L         (A0)+,(A1)+
                    MOVE.L         (A0)+,(A1)+
                    MOVE.L         (A0)+,(A1)+
                    MOVE.L         (A0)+,(A1)+
                    ADD.L          D0,D0
                    BCS.S          .byte
                    MOVE.W         (A0)+,(A1)+
                    TST.L          D0
.byte               BMI.S          .done
                    MOVE.B         (A0)+,(A1)+
.done               RTS                                     ; A0, A1 incremented !

;------------------------------------------------------------------

                    CNOP           0,4

; PutIconTagList -- Store an icon (V44)
; success = PutIconTagList(name,icon,tags);
; D0                       A0   A1   A2
; BOOL PutIconTagList(STRPTR name,struct DiskObject *icon,
;                     struct TagItem *tags);

PutIconTagList      CLR.L          -(SP)                    ; $B0 pr_WindowPtr
                    CLR.L          -(SP)                    ; $AC this task
                    CLR.L          -(SP)                    ; $A8 * errorcode
                    LEA            -$78(SP),SP              ; $30-$A7 name
                    MOVEM.L        D2-D7/A0-A3/A5-A6,-(SP)
                    MOVEQ          #1,D3                    ; option flags
                    MOVEQ          #0,D4                    ; default type
                    MOVEQ          #0,D5                    ; default name
                    MOVEQ          #0,D6                    ; io error code
                    MOVEQ          #0,D7                    ; return failure
                    BRA.S          PITL_ReadTagList

PITL_Skip           SUBQ.L         #1,D0
                    BNE.S          PITL_TagItem
                    MOVE.L         (A2),D0
                    LSL.L          #3,D0
                    ADDA.L         D0,A2
PITL_Ignore         ADDQ.W         #4,A2
PITL_Next           MOVE.L         (A2)+,D0
                    BMI.S          PITL_TagItem
                    BEQ.S          PITL_TagDone
                    SUBQ.L         #2,D0
                    BCS.S          PITL_Ignore
                    BNE.S          PITL_Skip
                    MOVEA.L        (A2),A2
PITL_ReadTagList    MOVE.L         A2,D0
                    BNE.S          PITL_Next
PITL_TagDone        BRA.S          PITL_TagsDone

PITL_ErrorCode      MOVE.L         D2,$A8(SP)
PITL_NextTag        ADDQ.W         #8,A2                    ; next TagItem
                    BRA.S          PITL_Next

PITL_TagItem        MOVE.L         (A2),D2                  ; TagData
                    MOVE.L         -(A2),D0                 ; TagItem
                    SUBI.L         #$80009001,D0
                    BEQ.S          PITL_ErrorCode
                    MOVEQ          #$34,D1
                    SUB.L          D1,D0
                    BEQ.S          NotifyWorkbench
                    BCS.S          PITL_NextTag
                    SUBQ.L         #2,D0
                    BCS.S          PutDefaultType
                    BEQ.S          PutDefaultName
                    SUBQ.L         #2,D0
                    BCS.S          DropPlanarImages         ; use dot image
                    BEQ.S          DropChunkyImages
                    SUBQ.L         #2,D0
                    BCS.S          DropNIconToolTypes
                 ;  BEQ.S          OptimizeImageSpace       ; always enabled
                    MOVEQ          #$D,D1
                    SUB.L          D1,D0
                    BEQ.S          OnlyUpdatePosition
                    MOVEQ          #$C,D1
                    SUB.L          D1,D0
                    BNE.S          PITL_NextTag
PreserveOldIconImages
                    TST.L          D2                       ; default true
                    BNE.S          PITL_NextTag
                    BCLR.L         #0,D3                    ; clear D3 Bit0
                    BRA.S          PITL_NextTag

DropNIconToolTypes  TST.L          D2                       ; default is 0
                    BEQ.S          PITL_NextTag
                    BSET.L         #1,D3                    ; flag D3 Bit1
                    BRA.S          PITL_NextTag

DropChunkyImages    TST.L          D2                       ; default is 0
                    BEQ.S          PITL_NextTag
                    BSET.L         #2,D3                    ; flag D3 Bit2
                    BRA.S          PITL_NextTag

;OptimizeImageSpace TST.L          D2                       ; default is 0
;                   BEQ.S          PITL_NextTag
;  always enabled   BSET.L         #3,D3                    ; flag D3 Bit3
;                   BRA.S          PITL_NextTag

DropPlanarImages    TST.L          D2                       ; default is 0
                    BEQ.S          PITL_NextTag
                    BSET.L         #4,D3                    ; flag D3 Bit4
                    BRA.S          PITL_NextTag             ; use dot image

OnlyUpdatePosition  TST.L          D2                       ; default is 0
                    BEQ.S          PITL_NextTag
                    BSET.L         #5,D3                    ; flag D3 Bit5
                    BRA.S          PITL_NextTag

NotifyWorkbench     TST.L          D2                       ; default is 0
                    BEQ.S          PITL_NextTag
                    BSET.L         #6,D3                    ; flag D3 Bit6
                    BRA.S          PITL_NextTag

PutDefaultType      MOVE.L         D2,D4
                    BRA.S          PITL_NextTag

PutDefaultName      MOVE.L         D2,D5
                    BRA.S          PITL_NextTag

PITL_TagsDone       MOVEA.L        A6,A5                    ; iconbase
                    MOVE.L         A1,D0                    ; DiskObject ?
                    BEQ.W          PITL_argmissing
 ifd MC68020
                    CMPI.W         #$E310,(A1)              ; DiskMagic found ?
 else
                    CMPI.B         #$E3,(A1)
 endif
                    BNE.W          PITL_wrongtype
                    TST.L          D4                       ; default type ?
                    BNE.S          .usedeftype
                    MOVE.B         do_Type(A1),D4
                    TST.L          D5                       ; default name ?
                    BNE.S          .usedefname
                    BRA.W          .useiconname             ;-------------------

.usedeftype         MOVEQ          #7,D0
                    CMP.L          D4,D0
                    BCS.W          PITL_wrongtype
.usedefname         MOVEA.L        $26(A5),A6               ; execbase
                    MOVEA.L        ThisTask(A6),A0
                    MOVE.L         A0,$AC(SP)               ; store this task
                    MOVE.L         pr_WindowPtr(A0),$B0(SP)
                    MOVEQ          #-1,D0
                    MOVE.L         D0,pr_WindowPtr(A0)      ; block requesters
                    LEA            ENVARC_sys_def_(PC),A0   ; 15 chars + 0
                    LEA            $30(SP),A3               ; 120 bytes buffer
                    MOVEA.L        A3,A1
.copystring         MOVE.B         (A0)+,(A1)+
                    BNE.S          .copystring
                    MOVEA.L        D5,A0                    ; default name ?
                    MOVE.L         A0,D0
                    BNE.S          .defaultname
                    LEA            DiskObjectNames(PC),A0
 ifd MC68020
                    ADDA.W         -2(A0,D4.L*2),A0         ; def_name by type
 else
                    MOVE.W         D4,D0
                    ADD.W          D0,D0
                    ADDA.W         -2(A0,D0.W),A0
 endif
                    MOVE.L         A0,D0
.defaultname        MOVEQ          #102,D1                  ; max 102 chars + 0
                    SUBQ.W         #1,A1                    ; point to 0 again
.catdef_name        MOVE.B         (A0)+,(A1)+
                    DBEQ           D1,.catdef_name
                    BNE.W          PITL_badname             ; name is too long
                    ADDQ.W         #3,A0                    ; - 1 char + "def_"
                    SUBA.L         D0,A0                    ; filepart length
                    CMPA.W         $CA(A5),A0               ; GlobalMaxNameLength
                    BHI.W          PITL_badname
                    MOVEA.L        A3,A1                    ; file name
                    MOVE.L         $1C(SP),D0               ; DiskObject
                    BSR.W          writeDiskObject          ; D2 trashed, D4=type
                    MOVE.L         D0,D6
                    BNE.W          PITL_failure
                    MOVEA.L        A3,A1                    ; file ENVARC:Sys/
                    ADDQ.W         #3,A1                    ; points to ARC:Sys
 ifd MC68020
                    MOVE.L         #"ENV:",(A1)             ; change to ENV:Sys
 else
                    MOVE.B         #"E",(A1)
                    MOVE.W         #"NV",1(A1)              ; change to ENV:Sys
 endif
                    MOVE.L         $1C(SP),D0               ; DiskObject
                    BSR.W          writeDiskObject          ; D2 trashed, D4=type
                    MOVE.L         D0,D6
                    BEQ.W          PITL_success
                    BRA.W          PITL_failure             ;--------------------

.testfortheroot     CMPA.L         A0,A2                    ; only one part ?
                    BNE.W          .diskisonroot
                    MOVEQ          #0,D1                    ; get path of "disk"
                    JSR            _LVOCurrentDir(A6)
                    MOVE.L         D3,-(SP)
                    MOVE.L         D0,D5                    ; save old dir lock
                    MOVE.L         D0,D1
                    JSR            _LVOCurrentDir(A6)
                    MOVE.L         D5,D1                    ; current dir lock
                    MOVEQ          #$30+4,D2                ; the stack offset
                    ADD.L          SP,D2                    ; + stack pointer
                    MOVEQ          #112,D3                  ; 112 bytes size
                    JSR            _LVONameFromLock(A6)
                    MOVE.L         (SP)+,D3
                    TST.L          D0
                    BEQ.W          .disktestdone
                    LEA            $30(SP),A0               ; current dir name
                    MOVEQ          #111,D0
.getendofstring     TST.B          (A0)+
                    DBEQ           D0,.getendofstring
 ifd MC68020
                    CMPI.W         #$3A00,-(A0)             ; is it the root ?
                    BNE.W          .disktestdone
 else
                    MOVEQ          #$3A,D0
                    SUBQ.W         #2,A0
                    SUB.B          (A0)+,D0
                    OR.B           (A0),D0
                    BNE.W          .disktestdone
 endif
                    MOVEQ          #WBDISK,D0
                    CMP.L          D0,D4
                    BEQ.S          .comparewithRam
                    MOVE.L         D0,D4                    ; force disk type
                    BSET.L         #7,D3                    ; set disk type flag
.comparewithRam     LEA            string_Ram.(PC),A0       ; "Ram:",0
                    MOVE.L         A0,D1
                    MOVEQ          #ACCESS_READ,D2
                    JSR            _LVOLock(A6)
                    MOVE.L         D5,D1                    ; current dir lock
                    MOVE.L         D0,D2                    ; lock on Ram:
                    JSR            _LVOSameLock(A6)
                    MOVE.L         D2,D1                    ; unlock Ram:
                    MOVE.L         D0,D2
                    JSR            _LVOUnLock(A6)
                    TST.L          D2                       ; current dir = Ram: ?
                    BEQ.W          .RamDiskfound
                    BRA.W          .disktestdone

.useiconname        MOVEM.L        $18(SP),A2-A3            ; name, DiskObject
                    MOVE.L         A2,D1                    ; icon name ?
                    BEQ.W          PITL_argmissing
                    MOVEA.L        $2A(A5),A6               ; dosbase
                    JSR            _LVOPathPart(A6)
                    MOVEA.L        D0,A0
                    CMPI.B         #"/",(A0)                ; file in subdir ?
                    BEQ.W          .disktestdone
 ifd MC68020
                    MOVE.L         (A0),D0
 else
                    MoveOddLong    A0,D0
                    SUBQ.W         #4,A0
 endif
                    OR.L           lowercasefilter(PC),D0
                    CMP.L          longwordfordisk(PC),D0   ; filename = disk ?
                    BNE.S          .testfordrive
                    TST.B          4(A0)
                    BEQ.W          .testfortheroot
.testfordrive       CMPA.L         A0,A2                    ; only a file part ?
 ifd MC68020
                    BEQ.S          .disktestdone
 else
                    BEQ.W          .disktestdone
 endif
                    LEA            $30(SP),A1               ; string buffer
                    MOVEA.L        A2,A0
                    MOVEA.L        A1,A2
                    MOVEQ          #107,D0                  ; max 107 chars + 0
.copyname           MOVE.B         (A0)+,(A1)+
                    DBEQ           D0,.copyname
 ifd MC68020
                    BNE.S          PITL_badname             ; name is too long
 else
                    BNE.W          PITL_badname
 endif
                    SUBQ.W         #2,A1
                    CMPI.B         #":",(A1)+               ; is it the root ?
                    BNE.S          .disktestdone            ; should not happen
 ifd MC68020
                    MOVE.L         #"disk",(A1)+            ; append "disk"
 else
                    MOVE.B         #"d",(A1)+
                    MOVE.B         #"i",(A1)+
                    MOVE.B         #"s",(A1)+
                    MOVE.B         #"k",(A1)+
 endif
                    CLR.B          (A1)                     ; terminate string
                    MOVE.L         A2,$18(SP)               ; new name string
.diskisonroot       MOVEQ          #WBDISK,D0
                    CMP.L          D0,D4
                    BEQ.S          .checkramdisk
                    MOVE.L         D0,D4                    ; force disk type
                    BSET.L         #7,D3                    ; set disk type flag
.checkramdisk
 ifd MC68020
                    MOVEM.L        (A2),D0-D1
 else
                    MoveOddLong    A2,D0
                    MoveOddLong    A2,D1
                    SUBQ.W         #8,A2
 endif
                    OR.L           lowercase3bytes(PC),D0
                    CMP.L          longwordforram.(PC),D0   ; "ram:" ?
                    BEQ.S          .RamDiskfound
                    CMP.L          longwordforram_(PC),D0   ; "ram " ?
                    BNE.S          .disktestdone
                    OR.L           lowercasefilter(PC),D1
                    CMP.L          longwordfordisk(PC),D1   ; "ram disk" ?
                    BNE.S          .disktestdone
.RamDiskfound       MOVEA.L        A5,A6                    ; iconbase
                    LEA            ENV_sys_def_RAM(PC),A0
                    MOVEA.L        A3,A1                    ; icon
                    JSR            _LVOPutDiskObject(A6)
                    MOVEA.L        A3,A1                    ; icon
                    LEA            ENVARC_sys_def_RAM(PC),A0
                    JSR            _LVOPutDiskObject(A6)
                    BRA.S          PITL_validname

.disktestdone       MOVE.L         A2,D1                    ; filename
                    JSR            _LVOFilePart(A6)
                    MOVEA.L        D0,A0
.countfilepart      TST.B          (A0)+
                    BNE.S          .countfilepart
                    SUBQ.W         #1,A0
                    SUBA.L         D0,A0                    ; filepart length
                    CMPA.W         $CA(A5),A0               ; GlobalMaxNameLength
                    BLS.S          PITL_validname
PITL_badname        MOVEQ          #$26,D6
                    NOT.B          D6                       ; 217=too many levels
                    BRA.S          PITL_success             ; pretend success !

PITL_argmissing     MOVEQ          #$74,D6
                    BRA.S          PITL_failure

PITL_wrongtype      MOVEQ          #$6A,D6
                    ADD.L          D6,D6
                    BRA.S          PITL_failure

PITL_validname      BTST.L         #5,D3                    ; OnlyUpdatePosition
                    BEQ.S          PITL_writeicon
                    BSR.S          saveiconposition
                    BMI.S          PITL_writeicon           ; it is a PNG icon
                    CMPI.W         #205,D0                  ; icon file not found ?
                    BNE.S          PITL_finished
PITL_writeicon      MOVEA.L        A2,A1                    ; filename
                    MOVE.L         A3,D0                    ; DiskObject
                    BSR.W          writeDiskObject          ; D2 trashed, D4=type
PITL_finished       MOVE.L         D0,D6                    ; errorcode
                    BNE.S          PITL_failure
                    BTST.L         #6,D3                    ; NotifyWorkbench ?
                    BEQ.S          PITL_success
                    MOVEA.L        A2,A1                    ; file name
                    MOVEQ          #UPDATEWB_ObjectAdded,D0
                    BSR.W          UpdateWorkbench
PITL_success        MOVEQ          #1,D7                    ; returncode OK
PITL_failure        MOVE.L         $A8(SP),D0               ; * errorcode
                    BEQ.S          .nocode
                    MOVEA.L        D0,A0
                    MOVE.L         D6,(A0)                  ; store errorcode
.nocode             MOVE.L         $AC(SP),D0               ; this task
                    BEQ.S          .notask
                    MOVEA.L        D0,A0
                    MOVE.L         $B0(SP),pr_WindowPtr(A0)
.notask             MOVE.L         D6,D1                    ; set IO errorcode
                    MOVEA.L        $2A(A5),A6               ; dosbase
                    JSR            _LVOSetIoErr(A6)         ; always clear/set RC2
                    MOVE.L         D7,D0                    ; set returncode
                    MOVEM.L        (SP)+,D2-D7/A0-A3/A5-A6
                    LEA            $84(SP),SP
                    RTS

;------------------------------------------------------------------

saveiconposition    LEA            -$3C(SP),SP              ; read buffer
                    MOVEM.L        D2-D6/A4-A6,-(SP)        ; A2=name A3=DiskObject
                    MOVEA.L        A2,A1                    ; icon name
                    BSR.W          allocnamecat_info
                    MOVE.L         D0,D1                    ; name.info string
                    BEQ.S          .nomem
                    MOVEA.L        D0,A4                    ; save *memblock
                    MOVEQ          #ACCESS_WRITE,D2
                    MOVEA.L        $2A(A5),A6               ; dosbase
                    JSR            _LVOLock(A6)
                    MOVEQ          #0,D6                    ; no filehandle yet
                    MOVE.L         D0,D4                    ; lock ?
                    BEQ.S          .ioerror
                    MOVE.L         D4,D1                    ; lock
                    JSR            _LVOOpenFromLock(A6)
                    MOVE.L         D0,D6                    ; filehandle ?
                    BNE.S          .opened
                    JSR            _LVOIoErr(A6)
                    MOVE.L         D0,D5                    ; error code
                    BEQ.S          .notopen
                    MOVEQ          #$2E,D0
                    NOT.B          D0
                    CMP.L          D0,D5                    ; packet error 209 ???
                    BNE.S          .unlock
.notopen            MOVE.L         D4,D1                    ; lock
                    JSR            _LVOUnLock(A6)
                    MOVEQ          #0,D4                    ; no lock
                    MOVE.L         A4,D1                    ; name.info
                    MOVE.L         #MODE_READWRITE,D2
                    JSR            _LVOOpen(A6)
                    MOVE.L         D0,D6                    ; filehandle ?
                    BEQ.S          .ioerror
.opened             MOVEQ          #0,D4                    ; no lock
                    MOVE.L         D6,D1                    ; filehandle
                    LEA            $20(SP),A1
                    MOVE.L         A1,D2                    ; read buffer
                    MOVEQ          #do_CurrentX,D3          ; length = $3A
                    JSR            _LVORead(A6)
                    CMP.L          D3,D0
                    BNE.S          .ioerror
                    CMPI.L         #$E3100001,$20(SP)       ; DISKMAGIC, version=1
                    BEQ.S          .writeCurrentXY
                    MOVEQ          #$6A,D5                  ; PNG files etc
                    ADD.L          D5,D5                    ; object wrong type
                    BRA.S          .closefile

.nomem              MOVEQ          #$67,D0                  ; out of memory
                    BRA.S          .exit

.writeCurrentXY     MOVE.L         D6,D1                    ; filehandle
                    MOVEQ          #do_CurrentX,D2
                    ADD.L          A3,D2                    ; struct DiskObject
                    MOVEQ          #8,D3                    ; 8 bytes
                    JSR            _LVOWrite(A6)
                    SUBQ.L         #8,D0
                    BEQ.S          .noerror
.ioerror            JSR            _LVOIoErr(A6)
.noerror            MOVE.L         D0,D5                    ; error code
.closefile          MOVE.L         D6,D1                    ; filehandle ?
                    BEQ.S          .unlock
                    JSR            _LVOClose(A6)
.unlock             MOVE.L         D4,D1                    ; lock
                    JSR            _LVOUnLock(A6)
                    MOVEA.L        A4,A1                    ; memblock
                    MOVEA.L        $26(A5),A6               ; execbase
                    JSR            _LVOFreeVec(A6)
                    CMPI.L         #$89504E47,$20(SP)       ; is it a PNG icon ?
                    BNE.S          .done
                    MOVEQ          #-1,D5                   ; return -1 for PNG
.done               MOVE.L         D5,D0                    ; error code
.exit               MOVEM.L        (SP)+,D2-D6/A4-A6
                    LEA            $3C(SP),SP
                    RTS

;-------------------------------------------------------------------------

; PITLtags 7=disk 6=updateWB 5=snapshot 4=usedot (3=optimize) 2=nochunky 1=noNI 0=useold
; DUPflags 7=PalMaps 6=remap 5=toolwin 4=tooltypes 3=deftool 2=imgdata 1=img 0=drawerdata

writeDiskObject     CLR.L          -(SP)                    ; buffer pointer
                    CLR.L          -(SP)                    ; target icon
                    LEA            -$38(SP),SP              ; $28-$5F
                    MOVEQ          #0,D2                    ; used for flags
                    MOVEM.L        D2-D7/A1-A3/A6,-(SP)     ; A1=file name
                    MOVE.B         D3,(SP)                  ; option flags
                    MOVEA.L        D0,A2                    ; source DiskObject
                    BSR.W          allocnamecat_info
                    MOVE.L         D0,$5C(SP)               ; store *name.info
                    BEQ.W          .nofreememory
                    MOVEA.L        $2A(A5),A6               ; dosbase
                    MOVE.L         D0,D1                    ; * name.info
                    MOVEQ          #ACCESS_READ,D2
                    JSR            _LVOLock(A6)
                    MOVE.L         D0,D3                    ; lock on name.info
                    BEQ.S          .creatingnewicon
                    MOVE.L         $18(SP),D1               ; * file name
                    JSR            _LVOLock(A6)
                    MOVE.L         D3,D1                    ; lock on name.info
                    MOVE.L         D0,D2                    ; lock on file name
                    JSR            _LVOSameLock(A6)
                    MOVE.L         D0,D5
                    MOVE.L         D2,D1                    ; unlock file name
                    JSR            _LVOUnLock(A6)
                    MOVE.L         D3,D1                    ; unlock name.info
                    JSR            _LVOUnLock(A6)
                    MOVE.L         D5,D7                    ; name = name.info ?
                    BNE.S          .creatingnewicon
                    BCLR.B         #6,7(SP)                 ; don't notify Workbench
                    BRA.W          .errorhandling           ; don't overwrite file

.creatingnewicon    LEA            $5E(A2),A0               ; V44 extension
                    CMPA.L         (A0),A0                  ; magic selfpointer ?
                    SEQ            2(SP)                    ; is a V44 DiskObject
 ifd MC68020
                    BNE.W          .writediskobject
.checkconversion    TST.B          $97C(A5)                 ; always convert icons?
                    BNE.W          .writediskobject
                    MOVE.L         do_Gadget+gg_GadgetText(A2),D7 ; FileBlockNumber
                    BEQ.W          .diskobject_type
                    MOVE.L         $5C(SP),D1               ; *name.info
                    MOVEQ          #ACCESS_READ,D2
                    JSR            _LVOLock(A6)
                    MOVE.L         D0,D1                    ; lock on name.info
                    BEQ.W          .writediskobject
                    LSL.L          #2,D0                    ; convert BCPL pointer
                    MOVEA.L        D0,A0                    ; struct FileLock
                    MOVE.L         fl_Key(A0),D2            ; new FileBlockNumber  
                    JSR            _LVOUnLock(A6)
                    CMP.L          D2,D7                    ; same icon again ?
                    BNE.W          .writediskobject
                    MOVEQ          #0,D1                    ; temporary dir boot fs
                    JSR            _LVOCurrentDir(A6)
                    MOVE.L         D0,D1
                    MOVE.L         D0,D2                    ; oldLock = current dir
                    JSR            _LVODupLock(A6)
                    MOVE.L         D0,D7                    ; add current dir lock
                    MOVE.L         D2,D1
                    JSR            _LVOCurrentDir(A6)
                    MOVEQ          #1,D0                    ; undefined dir lock
                    MOVE.L         $AE(A5),D2               ; get stored dir lock
                    MOVE.L         D0,$AE(A5)
                    CMP.L          D0,D2                    ; no dir lock stored ?
                    BEQ.S          .displayrequester
                    MOVE.L         D7,D1
                    TST.L          D2
                    BMI.S          .inverteddirlock
                    JSR            _LVOSameLock(A6)
                    MOVE.L         D0,D3
                    MOVE.L         D2,D1                    ; unlock old stored dir
                    JSR            _LVOUnLock(A6)
                    TST.L          D3                       ; current = stored dir?
                    BEQ.S          .storenewdirlock
                    BRA.S          .displayrequester

.inverteddirlock    NOT.L          D2
                    JSR            _LVOSameLock(A6)
                    MOVE.L         D0,D3
                    MOVE.L         D2,D1                    ; unlock old stored dir
                    JSR            _LVOUnLock(A6)
                    TST.L          D3                       ; current = inverted dir?
                    BEQ.W          .convertaborted
.displayrequester   LEA            -108(SP),SP
                    MOVE.L         D7,D1                    ; current dir lock
                    MOVE.L         SP,D2                    ; dir name buffer
                    MOVEQ          #107,D3                  ; max name length
                    JSR            _LVONameFromLock(A6)
                    MOVEA.L        108+$18(SP),A0           ; arg0 = *icon name               
                    MOVEA.L        SP,A1                    ; arg1 = *dir name
                    MOVEM.L        A0-A3,-(SP)
                    SUBA.L         A0,A0                    ; no window, open on WB
                    LEA            converticonrequest(PC),A1
                    SUBA.L         A2,A2                    ; no *IDCMP flags
                    MOVEA.L        SP,A3                    ; *args for %s
                    MOVEA.L        $36(A5),A6               ; intuibase
                    JSR            _LVOEasyRequestArgs(A6)
                    MOVEA.L        $2A(A5),A6               ; dosbase
                    MOVEM.L        (SP)+,A0-A3
                    LEA            108(SP),SP
                    MOVE.L         D7,D1                    ; current dir lock
                    SUBQ.L         #1,D0
                    BHI.S          .choicehigherone
                    BCS.S          .iconofwrongtype         ; request cancelled
.alwaysconverted    JSR            _LVOUnLock(A6)
                    BRA.S          .writediskobject

.iconofwrongtype    JSR            _LVOUnLock(A6)
                    BRA.W          .wrongtype

.choicehigherone    SUBQ.L         #2,D0
                    SHI            $97C(A5)                 ; flag = always convert
                    BHI.S          .alwaysconverted
                    BEQ.W          .convertaborted          ; dont conv in this dir
.storenewdirlock    MOVE.L         D7,$AE(A5)               ; convert in this dir
 endif
.writediskobject    MOVEQ          #0,D7                    ; no filehandle yet
.diskobject_type    MOVE.L         D4,D6                    ; do_Type <= 0 ?
                    BLE.W          .wrongtype
                    SUBQ.L         #8,D4                    ; do_Type > 8 ?
                    BHI.W          .wrongtype
                    BNE.S          .copyiconstructure
                    MOVEQ          #4,D6                    ; set AppIcon = Project
.copyiconstructure  MOVEA.L        A2,A0                    ; source icon
                    LEA            $60(SP),A1               ; target icon pointer
                    MOVEQ          #%01111111,D0            ; copy flags
                    ROR.B          #1,D0                    ; set flags = 10111111
                    BSR.W          copyStructDO             ; but copy the PalMaps
                    MOVE.L         D0,D5                    ; error code
                    BNE.W          .errorhandling
                    MOVEA.L        $60(SP),A3               ; target icon structure
                    MOVE.L         DiskObject_tool(PC),(A3) ; do_Magic = $E3100001
                    LEA            do_StackSize(A3),A1
                    MOVEQ          #64,D4
                    LSL.L          #6,D4
                    CMP.L          (A1),D4                  ; stacksize >= 4096 ?
                    BLE.S          .minstack4096
                    MOVE.L         D4,(A1)                  ; set stack = 4096
.minstack4096       LEA            $2C+3(A3),A1             ; *(UserData+3)
                    MOVE.B         #1,(A1)+                 ; dd_Flags+dd_ViewModes
                    MOVE.B         D6,(A1)+                 ; store new do_Type
 ifd DTtype
                    CLR.B          (A1)                     ; no default type icon
 endif
                    MOVE.L         $5C(SP),D1               ; target name.info
                    MOVE.L         #MODE_NEWFILE,D2         ; create name.info
                    JSR            _LVOOpen(A6)
                    MOVE.L         D0,D7                    ; save filehandle
                    BEQ.W          .geterrorcode
                    MOVE.L         D7,D1                    ; filehandle
                    MOVEQ          #0,D2                    ; new buffer
                    MOVEQ          #1,D3                    ; mode never flush
                    JSR            _LVOSetVBuf(A6)          ; D4 = 4096 bytes
                    TST.B          2(SP)                    ; V44 DiskObject ?
                    BEQ.W          .planarimagesdone
                    TST.L          $76(A3)                  ; copy of PalMap1 ?
                    SNE            2(SP)                    ; PalMap1 is ok
.checknewiconimage  TST.L          $6A(A2)                  ; newicon images ?
                    BEQ.S          .checkforwbdisk
                    BTST.B         #1,$8A(A2)               ; NewIcon flag set ?
                    BEQ.S          .checkforwbdisk
                    ADDQ.B         #1,3(SP)                 ; use newicon images
                    TST.L          do_ToolTypes(A3)
                    BNE.S          .checkforwbdisk
                    MOVE.L         $6A(A2),do_ToolTypes(A3) ; newicon -> tooltypes
                    ADDQ.B         #1,1(SP)                 ; only NI tooltypes
.checkforwbdisk     MOVEQ          #WBDISK,D0
                    CMP.B          D0,D6                    ; do_Type = disk ?
                    BNE.S          .testfordrawers
                    BTST.B         #7,(SP)                  ; disk type forced ?
                    BEQ.S          .testfordrawers
                    TST.B          2(SP)                    ; is PalMap 1 ok ?
                    BEQ.W          .planarimagesdone
                    LEA            Gadget_disk(PC),A1
.updateoneimage     MOVEQ          #5,D1                    ; inverse no backgrnd
                    CLR.L          $1A(A3)                  ; clear SelectRender
                    BRA.W          .updateoldimages

.convertaborted     NOT.L          D7
                    MOVE.L         D7,$AE(A5)               ; inverted dir lock
.wrongtype          MOVEA.L        $5C(SP),A1               ; *name.info buffer
                    MOVEA.L        $26(A5),A6               ; execbase
                    JSR            _LVOFreeVec(A6)
                    MOVEQ          #$6A,D0
                    ADD.L          D0,D0                    ; object of wrong type
                    BRA.W          .done

.testforrealfile    TST.L          D3                       ; was "disk" locked ?
                    BEQ.W          .checkdrawerdata
                    MOVEQ          #WBTOOL,D0               ; change into a tool
                    LEA            Gadget_tool(PC),A1
                    BRA.S          .updateoneimage

.trashcanimages     TST.B          2(SP)                    ; is PalMap 1 ok ?
                    BEQ.W          .planarimagesdone
                    TST.L          $1A(A3)                  ; has SelectRender ?
                    BNE.W          .checkdrawerdata         ; IconEdit is possible
                    LEA            Select_trashcan(PC),A1
                    MOVE.L         A1,$1A(A3)               ; SelectRender image
                    LEA            Gadget_trashcan(PC),A1
                    BRA.W          .updatetwoimages

.checkicontypes     TST.B          2(SP)                    ; is PalMap 1 ok ?
                    BEQ.W          .planarimagesdone
                    SUBQ.B         #WBDISK,D6
                    BEQ.S          .testforrealfile
                    SUBQ.B         #1,D6                    ; = drawer ?
                    BEQ.W          .checkdrawerdata
                    SUB.L          A1,A1                    ; needs no drawerdata
                    BRA.W          .assigndrawerdata

.testfordrawers     MOVEA.L        $18(SP),A0               ; filename or dirname
                    TST.B          (A0)                     ; no name supplied ?
                    BEQ.W          .keepoldimagetest
                    MOVEQ          #WBGARBAGE,D0
                    CMP.B          D0,D6
                    BEQ.S          .trashcanimages
                    MOVE.L         A0,D1
                    MOVEQ          #ACCESS_READ,D2
                    JSR            _LVOLock(A6)
                    MOVE.L         D0,D3                    ; file lock
                    BEQ.S          .checkicontypes
                    LEA            -$104(SP),SP             ; FIB size = $104
                    MOVE.L         SP,D2
                    ANDI.B         #$FC,D2                  ; align stack address
                    SUBQ.W         #4,SP                    ; for the alignment
                    MOVE.L         D2,D0                    ; FileInfoBlock
                    MOVE.L         D3,D1                    ; file lock
                    JSR            _LVOExamine(A6)
                    MOVEA.L        D2,A0
                    MOVE.L         fib_DirEntryType(A0),D2
                    LEA            $108(SP),SP              ; release FIB memory
                    MOVE.L         D3,D1
                    JSR            _LVOUnLock(A6)
                    TST.L          D2                       ; type < 0 for files
                    BLE.S          .checkicontypes
                    SUBQ.L         #WBPROJECT,D6
                    BEQ.S          .keepoldimagetest        ; don't convert now
.settypetodrawer    MOVEQ          #WBDRAWER,D0
                    TST.B          2(SP)                    ; is PalMap 1 ok ?
                    BNE.S          .checktypedrawer
                    MOVE.B         D0,do_Type(A3)           ; set do_Type = drawer
.checktypedrawer    CMP.B          do_Type(A3),D0           ; do_Type = drawer ?
                    BEQ.S          .checkdrawerdata
                    LEA            Select_drawer(PC),A1
                    MOVE.L         A1,$1A(A3)               ; SelectRender image
                    LEA            Gadget_drawer(PC),A1
.updatetwoimages    MOVEQ          #6,D1                    ; alternative image
.updateoldimages    MOVE.B         D0,do_Type(A3)           ; set do_Type correct
                    MOVE.L         4(A1),$C(A3)             ; width, height
                    MOVE.W         D1,$10(A3)               ; gadget flags
                    MOVE.L         A1,$16(A3)               ; GadgetRender image
.releaseposition    MOVEQ          #1,D0
                    ROR.L          #1,D0                    ; NO_ICON_POSITION
                    MOVE.L         D0,do_CurrentX(A3)
                    MOVE.L         D0,do_CurrentY(A3)
.checkdrawerdata    TST.L          do_DrawerData(A3)
                    BNE.S          .keepoldimagetest
                    LEA            DefDrawerData(PC),A1
.assigndrawerdata   MOVE.L         A1,do_DrawerData(A3)
.keepoldimagetest   TST.B          2(SP)                    ; is PalMap 1 ok ?
                    BEQ.S          .chunkycheckdone
                    BTST.B         #0,(SP)                  ; preserve old images ?
                    BEQ.S          .usedotimagetest         ; this is the default
                    MOVEA.L        $6E(A2),A1               ; (V44) *old image1
                    MOVE.L         A1,D0
                    BEQ.S          .usedotimagetest
                    MOVE.L         4(A1),$C(A3)             ; width, height
                    MOVE.L         A1,$16(A3)               ; Gadget = old image1
                    MOVE.L         $72(A2),$1A(A3)          ; Select = old image2
                    LEA            $11(A3),A1               ; gg_Flags
                    MOVEQ          #-4,D0
                    AND.B          (A1),D0                  ; clear bit 0 and 1
                    OR.B           $8B(A2),D0               ; or with V44 flags
                    MOVE.B         D0,(A1)                  ; store new gg_Flags
.usedotimagetest    BTST.B         #4,(SP)                  ; drop planar images ?
                    BEQ.S          .planarimagesdone
                    LEA            $154(A5),A1              ; *DotImage
                    MOVE.L         4(A1),$C(A3)             ; width, height
                    MOVEQ          #4,D0
                    MOVE.W         D0,$10(A3)               ; flags = invert image
                    MOVE.L         A1,$16(A3)               ; GadgetRender = dot
                    CLR.L          $1A(A3)                  ; no SelectRender
.planarimagesdone   BTST.B         #2,(SP)                  ; drop chunky images ?
                    BEQ.S          .chunkycheckdone
                    CLR.B          2(SP)                    ; no chunky images
.chunkycheckdone    TST.B          $97E(A5)                 ; WB 3.0/3.1 ?
                    BEQ.S          .checkNItooltypes
                    TST.W          $C8(A5)                  ; GlobalColorIconSupport ?
                    BNE.S          .checkGNIsupport
                    CLR.B          2(SP)                    ; no chunky images
                    BRA.S          .dropNItooltypes

.checkGNIsupport    TST.W          $C6(A5)                  ; GlobalNewIconSupport ?
                    BNE.S          .checkNItooltypes
.dropNItooltypes    MOVEQ          #1,D1                    ; mode = snip images
                    BSET.B         D1,(SP)                  ; drop NI tooltypes
                    BSR.W          newicontooltypes         ; A3 = DiskObject
.checkNItooltypes   BTST.B         #1,(SP)                  ; drop NI tooltypes ?
                    BEQ.S          .writefirstblock
                    CLR.B          3(SP)                    ; no NewIcon images
                    TST.B          1(SP)                    ; only NI tooltypes ?
                    BEQ.S          .writefirstblock
                    CLR.L          do_ToolTypes(A3)
.writefirstblock
.storediskobject    MOVE.L         A3,D2                    ; buffer = DiskObject
                    MOVEQ          #$4E,D3                  ; size of DiskObject
.diskobjectblock    BSR.W          .writeoneblock
                    MOVE.L         do_DrawerData(A3),D2     ; buffer = DrawerData
                    BEQ.S          .drawerdatadone
                    MOVEQ          #$38,D3                  ; size of DrawerData
                    BSR.W          .writeoneblock
.drawerdatadone     MOVE.L         $16(A3),D2               ; GadgetRender
                    BEQ.S          .storedoldimages         ; should not happen !
                    MOVEQ          #20,D3                   ; size of image
                    BSR.W          .writeoneblock
                    BSR.W          .writeimagedata
                    MOVE.L         $1A(A3),D2               ; SelectRender
                    BEQ.S          .storedoldimages
                    MOVEQ          #20,D3                   ; size of image
                    BSR.W          .writeoneblock
                    BSR.W          .writeimagedata
.storedoldimages    MOVEA.L        do_DefaultTool(A3),A0
                    MOVE.L         A0,D0
                    BEQ.S          .defaulttooldone
                    BSR.W          .writetoolstring
.defaulttooldone    MOVEQ          #4,D3                    ; for the NULL pointer
                    LEA            $38(SP),A1               ; size of tt-array
                    MOVE.L         D3,(A1)
                    TST.B          3(SP)                    ; use newicon images?
                    BEQ.S          .skipNItooltypes
                    MOVEA.L        $6A(A2),A0               ; newicon tooltypes
.countNItooltypes   ADD.L          D3,(A1)                  ; + another pointer
                    TST.L          (A0)+                    ; NULL = end of array
                    BNE.S          .countNItooltypes
                    TST.B          1(SP)                    ; only NI tooltypes ?
                    BNE.S          .onlyNItooltypes
.skipNItooltypes    MOVEA.L        do_ToolTypes(A3),A3
                    MOVE.L         A3,D0
                    BEQ.S          .onlyNItooltypes
                    MOVEA.L        A3,A0                    ; do_ToolTypes
                    BRA.S          .test4nullpointer

.counttooltypes     ADD.L          D3,(A1)                  ; + another pointer
.test4nullpointer   TST.L          (A0)+
                    BNE.S          .counttooltypes
                    MOVE.L         A1,D2                    ; size of tt-array
                    BSR.W          .writeoneblock
.nexttoolstring     MOVEA.L        (A3)+,A0                 ; normal toolstring
                    MOVE.L         A0,D0
                    BEQ.S          .normaltoolsdone
                    BSR.W          .writetoolstring
                    BRA.S          .nexttoolstring

.onlyNItooltypes    TST.B          3(SP)                    ; use newicon images?
                    BEQ.S          .alltooltypesdone
                    MOVE.L         A1,D2                    ; size of tt-array
                    BSR.W          .writeoneblock
.normaltoolsdone    TST.B          3(SP)                    ; use newicon images?
                    BEQ.S          .alltooltypesdone
                    LEA            string_Space(PC),A0
                    BSR.W          .writetoolstring
                    MOVEA.L        $6A(A2),A3               ; newicon tooltypes
.nextNItoolstring   MOVEA.L        (A3)+,A0                 ; newicon toolstring
                    MOVE.L         A0,D0
                    BEQ.S          .alltooltypesdone
                    BSR.W          .writetoolstring
                    BRA.S          .nextNItoolstring

.alltooltypesdone   MOVEA.L        $60(SP),A3               ; target DiskObject
                    MOVEA.L        do_ToolWindow(A3),A0
                    MOVE.L         A0,D0
                    BEQ.S          .toolwindowdone
                    BSR.W          .writetoolstring
.toolwindowdone     MOVE.L         do_DrawerData(A3),D2
                    BEQ.S          .hasnodrawerdata
                    MOVEQ          #dd_Flags,D0             ; offset of flags
                    ADD.L          D0,D2                    ; buffer = *flags
                    MOVEQ          #6,D3                    ; size = 6 bytes
                    BSR.W          .writeoneblock
.hasnodrawerdata    TST.B          3(SP)                    ; use newicon images?
                    BNE.W          .errorhandling
                    TST.B          2(SP)                    ; use chunky images?
                    BEQ.W          .errorhandling
                    MOVEA.L        $76(A3),A0               ; copy of PalMap1
                    MOVEM.W        (A0),D0/D6               ; width, height
                    MULU.W         D0,D6                    ; number of pixels
                    MOVEQ          #96,D0                   ; 80 should be fine
                    LSL.L          #4,D0                    ; 256 RGB + 512 RLE
                    ADD.L          D6,D0                    ; + full size image
                    ADD.L          D0,D0                    ; for both PalMaps
                    MOVEQ          #MEMF_PUBLIC,D1
                    MOVEA.L        $26(A5),A6               ; execbase
                    JSR            _LVOAllocVec(A6)
                    MOVE.L         D0,$64(SP)               ; RGB & image buffer
                    BEQ.W          .nofreememory
                    MOVEQ          #0,D4                    ; no PalMap2 yet
                    BTST.B         #4,$8A(A2)               ; NoImage2 flag set?
                    BNE.S          .colorcomparedone
                    MOVE.L         $7A(A3),D4               ; copy of PalMap2 ?
                    BEQ.S          .colorcomparedone
                    MOVEA.L        $76(A3),A0               ; PalMap1
                    MOVEA.L        D4,A6                    ; PalMap2
                    MOVE.B         $10D(A0),D1              ;     compare the
                    CMP.B          $10D(A6),D1              ; transparent colors
                    BNE.S          .colorcomparedone
                    MOVE.W         $10E(A0),D1              ; number of colors 1
                    CMP.W          $10E(A6),D1              ; same color count ?
                    BNE.S          .colorcomparedone
                    MOVEA.L        $108(A0),A0              ; RGB bytes PalMap1
                    MOVEA.L        $108(A6),A1              ; RGB bytes PalMap2
                    MOVE.W         D1,D2
                    ADD.W          D2,D2
                    ADD.W          D2,D1
                    SUBQ.W         #1,D1
.comparecolormaps   CMPM.B         (A0)+,(A1)+              ; compare RGB bytes
                    DBNE           D1,.comparecolormaps
                    BNE.S          .colorcomparedone
                    MOVE.W         D1,$10E(A6)              ; use colormap 1 only
.colorcomparedone   MOVEA.L        $76(A3),A0               ; PalMap1
                    MOVEA.L        D0,A6                    ; buffer for PalMap1
                    SUBQ.L         #1,D6                    ; size of image - 1
                    BSR.W          optimize_compress
                    MOVEM.L        D1-D2,$30(SP)            ; used bits, size 1
                    MOVE.L         D0,$2C(SP)               ; size of colormap 1
                    MOVE.L         D4,D1                    ; IMAG size = PalMap2
                    BEQ.S          .writeFORMheader
                    MOVE.L         A6,D0                    ; unaligned buffer
                    ADDQ.L         #3,D0
                    ANDI.B         #$FC,D0                  ; round to longwords
                    MOVE.L         D0,$28(SP)               ; new buffer offset
                    MOVEA.L        D4,A0                    ; PalMap2
                    MOVEA.L        D0,A6                    ; buffer for PalMap2
                    BSR.W          optimize_compress
                    MOVEM.L        D1-D2,$38(SP)            ; used bits, size 2
                    CLR.B          $56(SP)                  ; clear FORM flags
                    MOVE.L         D0,D6                    ; size of colormap 2
                    MOVEQ          #18+1,D1                 ; ARGB / IMAG 2 size
.useIMAG2           ADD.L          D2,D1                    ; + size of z-image 2
                    ADD.L          D6,D1                    ; + size of colormap 2
.useARGB2           ANDI.B         #$FE,D1                  ; round up to words
.writeFORMheader    MOVE.L         $2C(SP),D5               ; size of colormap 1
                    MOVEQ          #36+1,D0                 ; FORM+IMAG/ARGB size
.useIMAG1           ADD.L          $34(SP),D0               ; + size of z-image 1
                    ADD.L          D5,D0                    ; + size of colormap 1
.useARGB1           ANDI.B         #$FE,D0                  ; round up to words
                    ADD.L          D1,D0
                    LEA            $40(SP),A0               ; * FORM buffer
                    MOVE.L         A0,D2                    ; save for writing
                    MOVE.L         #"FORM",(A0)+
                    MOVE.L         D0,(A0)+                 ; size of FORM data
                    MOVE.L         #"ICON",(A0)+
                    MOVE.L         #"FACE",(A0)+
                    MOVEQ          #6,D0                    ; size of FACE data
                    MOVE.L         D0,(A0)+
                    MOVEA.L        $76(A3),A3               ; PalMap1
                    MOVEM.W        (A3),D0-D1               ; width, height
                    SUBQ.L         #1,D0
                    MOVE.B         D0,(A0)+                 ; save width - 1
                    SUBQ.L         #1,D1
                    MOVE.B         D1,(A0)+                 ; save height - 1
                    MOVEQ          #0,D0
                    BTST.B         #0,$8A(A2)               ; frameless flag set ?
                    BEQ.S          .framechecked
                    ADDQ.B         #1,D0                    ; icon is frameless
.framechecked       ADD.B          D0,(A0)+                 ; save frame flag
                    BTST.B         #2,$8A(A2)               ; is this a deficon ?
                    BEQ.S          .deficonchecked
 ifd WB47fix
                    BTST.B         #5,$F1(A5)               ; WB v47 update fix ?
                    BNE.S          .deficonchecked
 endif
                    BSET.B         #6,7(SP)                 ; notify Workbench
.deficonchecked     MOVE.B         #$11,(A0)+               ; aspect ratio = 1:1
                    MOVE.W         $10E(A3),D0              ; number of colors 1 
                    TST.L          D4                       ; is there a PalMap2 ?
                    BEQ.S          .largercolormap
                    MOVEA.L        $7A(A2),A1               ; PalMap2
                    MOVE.W         $10E(A1),D1              ; number of colors 2 
                    CMP.W          D1,D0                    ; compare size 1 - 2
                    BGE.S          .largercolormap
                    MOVE.W         D1,D0                    ; size of colormap 2
.largercolormap     MOVE.W         D0,(A0)                  ; larger colormap
                    MOVEQ          #26,D3                   ; number of bytes
                    MOVEA.L        $2A(A5),A6               ; dosbase
                    BSR.S          .writeoneblock
                    MOVEA.L        A3,A0                    ; PalMap1
                    MOVEA.L        $30(SP),A1               ; required bits 1
                    MOVEA.L        $64(SP),A3               ; temp buffer
                    MOVE.L         $34(SP),D1               ; size of z-image 1
                    BSR.W          writePalMapimage
                    BNE.S          .geterrorcode
                    TST.L          D4                       ; is there a PalMap2 ?
                    BEQ.S          .saveerrorcode
                    MOVEA.L        D4,A0                    ; PalMap2
                    MOVEA.L        $38(SP),A1               ; required bits 2
                    MOVEA.L        $28(SP),A3               ; temp buffer
                    MOVE.L         $3C(SP),D1               ; size of z-image 2
                    MOVE.L         D6,D5                    ; size of colormap 2
                    BSR.W          writePalMapimage
                    BNE.S          .geterrorcode
                    BRA.S          .saveerrorcode

.nofreememory       MOVEQ          #$67,D5
                    BRA.S          .errorhandling

.writetoolstring    MOVEA.L        A0,A1                    ; toolstring
.countcharacters    TST.B          (A1)+
                    BNE.S          .countcharacters
                    SUBA.L         A0,A1
                    MOVE.L         D4,-(SP)
                    MOVE.L         A1,-(SP)                 ; save length
                    MOVE.L         D7,D1                    ; filehandle
                    MOVE.L         SP,D2                    ; buffer = *length
                    MOVEQ          #4,D3                    ; 4 bytes
                    MOVEQ          #1,D4                    ; 1 block
                    MOVE.L         A0,-(SP)                 ; save toolstring
                    MOVEA.L        $2A(A5),A6               ; dosbase
                    JSR            _LVOFWrite(A6)
                    MOVEM.L        (SP)+,D2-D4              ; string, length
                    SUBQ.L         #1,D0                    ; 1 block written ?
                    BEQ.S          .writeoneblock           ; returns to caller
                    BRA.S          .escapeonerror

.writeimagedata     MOVEA.L        D2,A0                    ; struct image
                    ADDQ.W         #4,A0
                    MOVEM.W        (A0)+,D1-D3              ; width, height, depth
                    MULU.W         D2,D3
                    MOVEQ          #15,D2
                    ADD.W          D2,D1                    ; width + 15
                    LSR.W          #4,D1
                    ADD.W          D1,D1                    ; bytes/line
                    MOVE.L         (A0),D2                  ; image data
                    MULU.W         D1,D3                    ; size of data
.writeoneblock      MOVE.L         D4,-(SP)                 ; it's a subroutine
                    MOVE.L         D7,D1                    ; filehandle
                    MOVEQ          #1,D4                    ; 1 block
                    JSR            _LVOFWrite(A6)
                    MOVE.L         (SP)+,D4
                    SUBQ.L         #1,D0                    ; 1 block written ?
                    BEQ.S          .returntocaller
.escapeonerror      ADDQ.W         #4,SP                    ; drop rts address
.geterrorcode       JSR            _LVOIoErr(A6)
.saveerrorcode      MOVE.L         D0,D5                    ; error code
.errorhandling      MOVEA.L        $5C(SP),A3               ; *name.info
                    MOVE.L         D7,D1                    ; filehandle
                    BEQ.S          .freememblocks
                    MOVEA.L        $2A(A5),A6               ; dosbase
                    JSR            _LVOClose(A6)
                    TST.L          D5                       ; any errors ?
                    BEQ.S          .freememblocks
                    MOVE.L         A3,D1                    ; *name.info
                    BEQ.S          .freememblocks
                    JSR            _LVODeleteFile(A6)
.freememblocks      MOVEA.L        $64(SP),A1               ; temp buffer
                    MOVEA.L        $26(A5),A6               ; execbase
                    JSR            _LVOFreeVec(A6)
                    MOVEA.L        A3,A1                    ; *name.info buffer
                    JSR            _LVOFreeVec(A6)
                    MOVEA.L        $60(SP),A0               ; target DiskObject
                    MOVEA.L        A5,A6                    ; iconbase
                    JSR            _LVOFreeDiskObject(A6)
                    MOVE.L         D5,D0                    ; return error code
.done               MOVEM.L        (SP)+,D2-D7/A1-A3/A6
                    LEA            $40(SP),SP
.returntocaller     RTS

;-------------------------------------------------------------------------

optimize_compress   MOVE.W         $10E(A0),D0              ; number of colors ?
                    BEQ.W          .getrequiredbits         ; no cmap2, D5 reused
                    MOVEM.L        D4/D7/A0/A2-A3,-(SP)     ; A0=PalMap A6=buf
                    MOVEA.W        D0,A3
                    TST.B          $10C(A0)                 ; use tansparency ?
                    SEQ.B          D3
 ifd MC68020
                    EXTB.L         D3
 else
                    EXT.W          D3
                    EXT.L          D3
 endif
                    MOVE.B         $10D(A0),D3              ; transparent color
                    MOVEA.L        4(A0),A2                 ; pixel bytes
                    MOVEA.L        $108(A0),A0              ; RGB color bytes
                    MOVE.L         (A0),(A6)+               ; RGB of 1. color
                    CLR.B          -(A6)                    ; set long to RGB0
                    MOVE.L         D3,D4
                    BNE.S          .transparency0done
                    ADDQ.B         #1,(A6)                  ; transparent color0
.transparency0done  SUBQ.W         #3,A6                    ; start of buffer
                    MOVEQ          #0,D5                    ; highest color #
                    MOVEQ          #0,D1                    ; number of color
                    MOVEQ          #0,D7                    ; remember color
.startatfirstpixel  MOVE.L         D6,D0                    ; size of image - 1
.getnextpixelcolor  MOVEQ          #0,D2
                    MOVE.B         (A2),D2                  ; pixel color byte
                    CMP.B          D2,D7                    ; same color again?
                    BEQ.S          .writecoloragain
                    MOVE.L         D2,D7                    ; remember color
                    ADD.L          D2,D2
                    ADD.L          D7,D2                    ; 3 * color number
 ifd MC68020
                    MOVE.L         (A0,D2.L),D2
 else
                    MOVEA.L        A0,A1
                    ADDA.L         D2,A1
                    MoveOddLong    A1,D2
 endif
                    CLR.B          D2                       ; RGB0 of the pixel
                    CMP.L          D7,D4
                    BNE.S          .transparencydone
                    ADDQ.B         #1,D2                    ; it's transparent
.transparencydone   MOVE.L         D5,D1                    ; highest color #
                    MOVEA.L        A6,A1                    ; comparison buffer
.comparenextcolor   CMP.L          (A1)+,D2
                    DBEQ           D1,.comparenextcolor
                    BEQ.S          .writecolornumber
                    ADD.W          A3,D1                    ; -1 + color count
                    SUB.W          D5,D1                    ; end of colormap ?
                    BEQ.S          .writecoloragain         ; avoid an overflow
                    ADDQ.L         #1,D5                    ; found a new color
                    MOVE.L         D2,(A1)+
                    TST.B          D2
                    BEQ.S          .writecolornumber
                    MOVE.B         D5,D3                    ; transparent color
.writecolornumber   SUBQ.W         #4,A1
                    SUBA.L         A6,A1
                    MOVE.L         A1,D1
                    LSR.L          #2,D1
.writecoloragain    MOVE.B         D1,(A2)+
                    DBRA           D0,.getnextpixelcolor
                    MOVE.L         (SP),D0                  ; was PalMap2 done ?
                    BEQ.S          .colormapcomplete
                    MOVEA.L        D0,A1                    ; PalMap2
                    TST.W          $10E(A1)                 ; color count of 2
                    BPL.S          .colormapcomplete
                    MOVE.B         D3,$10D(A1)              ; transparent color
                    ADDQ.W         #1,$10E(A1)              ; color count 2 = 0
                    MOVEA.L        4(A1),A2                 ; pixel bytes of 2
                    BRA.S          .startatfirstpixel       ; shared colormap1

.colormapcomplete   MOVEA.L        A6,A1                    ; comparison buffer
                    MOVE.L         D5,D0
.writecolortable    MOVE.B         (A1)+,(A0)+
 ifd MC68020
                    MOVE.W         (A1)+,(A0)+
 else
                    MOVE.B         (A1)+,(A0)+
                    MOVE.B         (A1)+,(A0)+
 endif
                    ADDQ.W         #1,A1
                    DBRA           D0,.writecolortable
                    MOVEM.L        (SP)+,D4/D7/A0/A2-A3
                    MOVE.B         D3,$10D(A0)              ; transparent color
                    ADDQ.L         #1,D5
                    MOVE.W         D5,$10E(A0)              ; save color count
.getrequiredbits    SUBQ.L         #1,D5                    ; highest color #
                    MOVEQ          #0,D1                    ; bit counter
.findallusedbits    ADDQ.B         #1,D1
                    LSR.B          #1,D5                    ; next higher bit
                    BNE.S          .findallusedbits
                    MOVE.W         $10E(A0),D5              ; number of colors
                    MOVEA.L        4(A0),A0                 ; image bytes PalMap
                    LEA            18(A6),A6                ; skip IMAG header
                    MOVE.L         A6,D2                    ; compression buffer
                                                            ; joined together 
datacompression     LEA            -$88(SP),SP              ; A0=image, A6=z-img
                    MOVEM.L        D0-D7/A0/A2/A5,-(SP)     ; D1 = bit depth
                    CLR.L          (SP)                     ; set to copy mode
                    LEA            2(SP),A1                 ; *previous color
                    MOVE.L         D6,$2C(SP)               ; pixel count - 1
                    MOVEQ          #8,D2                    ; to compare 8 bits
                    MOVE.B         (A0)+,D3                 ; first pixel color
                    MOVEQ          #0,D5                    ; bit shifter
                    MOVEQ          #0,D7                    ; available bits
.getstartofbuffer   LEA            $30(SP),A2
.newpixeltobuffer   MOVE.B         D3,(A2)                  ; 128 bytes buffer
                    MOVEQ          #1,D6                    ; buffer offset = 1
                    SUBA.L         A5,A5                    ; non repeated count
.getnextpixelbyte   MOVE.B         D3,(A1)                  ; previous = new
                    SUBQ.L         #1,$2C(SP)               ; pixel count - 1
                    BCS.W          .allpixeldonenow
                    MOVE.B         (A0)+,D3                 ; new = next color
                    MOVE.B         D3,(A2,D6.L)             ; 128 bytes buffer
                    MOVEQ          #-128,D4
                    ADDQ.L         #1,D6                    ; buffer offset + 1
                    TST.B          (SP)                     ; compress mode set ?
                    BNE.W          .trycompressmode
                    ADD.L          D6,D4                    ; offset - 128 ?
                    BLE.S          .offsetLE128
                    CMP.L          D2,D7                    ; 1 byte available ?
                    BLT.S          .lessthanabyte
                    SUBQ.L         #8,D7                    ; available bits - 8
                    MOVE.L         D5,D0                    ; bit shifter
                    LSR.L          D7,D0                    ; get high byte down
                    MOVE.B         D0,(A6)+                 ; write one byte
.lessthanabyte      LSL.L          #8,D5                    ; shift up 1 byte
                    MOVEQ          #128-1,D0                ; non repeated count
                    MOVE.B         D0,D5                    ; bit shifter
.writenextbyte      MOVE.L         D5,D4                    ; bit shifter
                    LSR.L          D7,D4                    ; get high byte down
                    MOVE.B         D4,(A6)+                 ; write one byte
.fillbitshifter     LSL.L          D1,D5                    ; shift by bit depth
                    OR.B           (A2)+,D5                 ; bit shifter
                    ADD.L          D1,D7                    ; available + depth
                    DBRA           D0,.checkavailable
                    BRA.S          .getstartofbuffer

.checkavailable     CMP.L          D2,D7                    ; 1 byte available ?
                    BLT.S          .fillbitshifter
                    SUBQ.L         #8,D7                    ; available bits - 8
                    BRA.S          .writenextbyte

.offsetLE128        CMP.B          (A1),D3                  ; new = previous ?
                    BEQ.S          .samecoloragain
                    MOVEA.L        D6,A5                    ; copy buffer offset
                    SUBQ.W         #1,A5                    ; buffer offset - 1
                    BRA.S          .getnextpixelbyte

.samecoloragain     MOVE.L         A5,D0                    ; non repeated count
                    BLE.S          .setcompressmode
                    MOVE.L         D6,D4                    ; copy buffer offset
                    SUB.L          A5,D4                    ; sub non repeated
                    MOVEQ          #15,D0
                    SUB.L          D1,D0                    ; 15 bit - depth
                    LSR.L          #1,D0                    ; (15 - depth) >> 1
                    CMP.L          D0,D4                    ; low repeat count ?
                    BLT.S          .getnextpixelbyte
                    CMP.L          D2,D7                    ; 1 byte available ?
                    BLT.S          .lessthan1byte
                    SUBQ.L         #8,D7                    ; available bits - 8
                    MOVE.L         D5,D0                    ; bit shifter
                    LSR.L          D7,D0                    ; get high byte down
                    MOVE.B         D0,(A6)+                 ; write one byte
.lessthan1byte      MOVE.L         A5,D6                    ; non repeated count
                    SUBQ.L         #1,D6
                    LSL.L          #8,D5                    ; shift up 1 byte
                    MOVE.B         D6,D5                    ; bit shifter
                    MOVEA.L        A2,A5                    ; go to buffer start
                    ADDQ.L         #8,D7                    ; available bits + 8
.writenonrepeated   CMP.L          D2,D7                    ; 1 byte available ?
                    BLT.S          .lessthan8bits
                    SUBQ.L         #8,D7                    ; available bits - 8
                    MOVE.L         D5,D0                    ; bit shifter
                    LSR.L          D7,D0                    ; get high byte down
                    MOVE.B         D0,(A6)+                 ; write one byte
.lessthan8bits      LSL.L          D1,D5                    ; shift by bit depth
                    OR.B           (A5)+,D5                 ; 128 bytes buffer
                    ADD.L          D1,D7                    ; available + depth
                    DBRA           D6,.writenonrepeated
                    MOVE.L         D4,D0                    ; count of repeated
                    SUBQ.L         #1,D0
.shiftbufferleft    MOVE.B         (A5)+,(A2)+              ; 128 bytes buffer
                    DBRA           D0,.shiftbufferleft
                    SUBA.L         D4,A2                    ; go to buffer start
                    MOVE.L         D4,D6                    ; offset last repeat
                    SUBA.L         A5,A5                    ; non repeated = 0
.setcompressmode    ADDQ.B         #1,(SP)
                    BRA.W          .getnextpixelbyte

.trycompressmode    MOVE.L         A5,D0                    ; non repeated count
                    SUB.L          D6,D0                    ; minus buffer offset
                    CMP.B          (A1),D3                  ; new = previous ?
                    BNE.S          .differentormax
                    CMP.L          D4,D0                    ; -repeated > -128 ?
                    BGE.W          .getnextpixelbyte
.differentormax     CMP.L          D2,D7                    ; 1 byte available ?
                    BLT.S          .nocompletebyte
                    SUBQ.L         #8,D7                    ; available bits - 8
                    MOVE.L         D5,D4                    ; bit shifter
                    LSR.L          D7,D4                    ; get high byte down
                    MOVE.B         D4,(A6)+                 ; write one byte
.nocompletebyte     ADDQ.L         #2,D0                    ; -repeated + 2
                    LSL.L          #8,D5                    ; shift 1 byte left
                    MOVE.B         D0,D5                    ; bit shifter
                    MOVE.L         D5,D0
                    LSR.L          D7,D0                    ; get high byte down
                    MOVE.B         D0,(A6)+                 ; write one byte
                    LSL.L          D1,D5                    ; shift up by depth
                    OR.B           (A1),D5                  ; OR with previous
                    ADD.L          D1,D7                    ; available + depth
                    CLR.B          (SP)                     ; set to copy mode
                    BRA.W          .newpixeltobuffer

.allpixeldonenow    CMP.L          D2,D7                    ; 1 byte available ?
                    BLT.S          .nobytecomplete
                    SUBQ.L         #8,D7                    ; available bits - 8
                    MOVE.L         D5,D0                    ; bit shifter
                    LSR.L          D7,D0                    ; get high byte down
                    MOVE.B         D0,(A6)+                 ; write one byte
.nobytecomplete     TST.B          (SP)                     ; compress mode set ?
                    BNE.S          .usecompressmode
                    LSL.L          #8,D5                    ; shift 1 byte left
                    SUBQ.L         #1,D6                    ; buffer offset - 1
                    MOVE.B         D6,D5                    ; to bit shifter
                    ADDQ.L         #8,D7                    ; available bits + 8
.flushthebuffer     CMP.L          D2,D7                    ; 1 byte available ?
                    BLT.S          .getsomemorebits
                    SUBQ.L         #8,D7                    ; available bits - 8
                    MOVE.L         D5,D0                    ; bit shifter
                    LSR.L          D7,D0                    ; get high byte down
                    MOVE.B         D0,(A6)+                 ; write one byte
.getsomemorebits    LSL.L          D1,D5                    ; shift up by depth
                    OR.B           (A2)+,D5                 ; OR only depth bits
                    ADD.L          D1,D7                    ; available + depth
                    DBRA           D6,.flushthebuffer
                    BRA.S          .writethelastword

.usecompressmode    MOVEQ          #1,D0                    ; 1
                    ADD.L          A5,D0                    ; + non repeated
                    SUB.L          D6,D0                    ; - buffer offset
                    LSL.L          #8,D5                    ; bit shifter
                    MOVE.B         D0,D5                    ; OR repeat count
                    MOVE.L         D5,D0                    ; bit shifter
                    LSR.L          D7,D0                    ; get high byte down
                    MOVE.B         D0,(A6)+                 ; write one byte
                    LSL.L          D1,D5                    ; shift up by depth
                    OR.B           (A1),D5                  ; OR with previous
                    ADD.L          D1,D7                    ; available + depth
.writethelastword   MOVEQ          #16,D0                   ; maximal 16 bits
                    SUB.L          D7,D0                    ; - available bits
                    LSL.L          D0,D5                    ; shift up free bits
.writethelastbyte   ROR.W          #8,D5                    ; get high byte down
                    MOVE.B         D5,(A6)+                 ; write one byte
                    SUBQ.L         #8,D7                    ; available bits - 8
                    BGT.S          .writethelastbyte
                    MOVEM.L        (SP)+,D0-D7/A0/A2/A5
                    LEA            $88(SP),SP
                    SUB.L          A6,D2                    ; first - last
                    NEG.L          D2                       ; size of z-image
                    CMP.L          D6,D2                    ; z-image < image ?
                    BLS.S          .done
                    MOVEA.L        A6,A1                    ; old buffer position
                    SUBA.L         D2,A1                    ; go back in buffer
                    MOVE.L         D6,D2
                    ADDQ.L         #1,D2                    ; full size of image
                    MOVE.L         D2,D0
                    BSR.W          CopyMemBlock             ; A1 is re-used
                    MOVEA.L        A1,A6                    ; new buffer position
                    MOVEQ          #0,D1                    ; clear used bits
.done               MOVE.L         D5,D0                    ; number of colors
                    ADD.L          D0,D0
                    ADD.L          D5,D0                    ; size of colormap
                    RTS

;-------------------------------------------------------------------------------

writePalMapimage    MOVEM.L        D1/D4/A2,-(SP)           ; D7=fh A3=buffer
                    MOVEA.L        A0,A2                    ; PalMap
                    MOVEA.L        A3,A0                    ; temp buffer
                    MOVEQ          #10,D0                   ; size of header
.writePalMapimage   ADD.L          D1,D0                    ; + size of image
                    ADD.L          D5,D0                    ; + colormap size
                    MOVE.L         #"IMAG",(A0)+            ; IMAG label
                    MOVE.L         D0,(A0)+                 ; IMAG chunk size
                    CLR.L          (A0)+
                    CLR.L          (A0)+
                    TST.B          $10C(A2)                 ; transparency ?
                    BEQ.S          .transparencydone
                    MOVE.B         $10D(A2),8(A3)           ; transparent color
                    ADDQ.B         #1,$A(A3)                ; transparency flag
.transparencydone   LEA            $D(A3),A0
                    MOVE.L         A1,D0                    ; required bits
                    BNE.S          .compressedimage
                    MOVEQ          #8,D0                    ; no compression
                    BRA.S          .saverequiredbits

.compressedimage    ADDQ.B         #1,$B(A3)
.saverequiredbits   MOVE.B         D0,(A0)+
                    SUBQ.L         #1,D1
                    MOVE.W         D1,(A0)+                 ; image size - 1
                    MOVE.L         D5,D0                    ; colormap size
                    BEQ.S          .colormapsizedone
                    SUBQ.L         #1,D0
                    MOVE.W         D0,(A0)                  ; colormap size - 1
                    SUBQ.W         #7,A0
                    MOVE.W         $10E(A2),D0              ; number of colors
                    SUBQ.W         #1,D0
                    MOVE.B         D0,(A0)+                 ; store colors - 1
                    ADDQ.B         #2,(A0)                  ; has a colormap
.colormapsizedone   MOVE.L         A3,D2                    ; IMAG header
                    MOVEQ          #18,D3                   ; size of header
                    ADD.L          (SP),D3                  ; size of image
                    BSR.S          .writeoneblock
                    MOVE.L         D5,D3                    ; colormap size
                    BEQ.S          .chunksizeoddtest
                    MOVE.L         $108(A2),D2              ; colormap bytes
.writesecondblock   BSR.S          .writeoneblock
.chunksizeoddtest   BTST.B         #0,4+3(A3)               ; IMAG chunk odd ?
                    BEQ.S          .done
                    MOVE.L         A3,D2
                    ADDQ.L         #4,D2                    ; pad a NULL byte
                    MOVEQ          #1,D3                    ; length = 1 byte
                    PEA            .done(PC)                ; don't come back !
.writeoneblock      MOVE.L         D7,D1                    ; filehandle
                    MOVEQ          #1,D4                    ; write 1 block
                    JSR            _LVOFWrite(A6)
                    SUB.L          D4,D0                    ; 1 block written ?
                    BEQ.S          .returntocaller
                    ADDQ.W         #4,SP                    ; drop rts address
.done               MOVEM.L        (SP)+,D1/D4/A2
.returntocaller     RTS

;-------------------------------------------------------------------------

bitlockdelay   MOVEM.L D0-D1/A0-A1/A6,-(SP)
               MOVEQ   #1,D1                   ; set delay to 1 tick
               MOVEA.L $2A(A5),A6              ; dosbase
               JSR     _LVODelay(A6)           ; happens very rarely
               MOVEM.L (SP)+,D0-D1/A0-A1/A6
               SUBQ.L  #8,(SP)
               SUBQ.L  #4,(SP)                 ; pull RTS 12 bytes back
               RTS

;###############################################################################

 ifd MC68020
converticontitle    DC.B           " ICON FORMAT CHANGE",0
converticontext     DC.B           "=> %s.info\N\N"
                    DC.B           "Dir = %s\N\N\N"
                    DC.B           "Saving converts TrueColor icons\N"
                    DC.B           "to the OS 3.5 format. Continue?\N",0
converticongadget   DC.B           "Yes, this icon|Ok for this dir|Not in this dir|ALWAYS|CANCEL",0
string_ArosLib      DC.B           "aros.library", 0
string_CyberGfxLib  DC.B           "NIL:cybergraphics.library", 0
string_DirOpus      DC.B           "Directory Opus", 0
string_FBlit        DC.B           "FBlit", 0
string_SCALOS       DC.B           "SCALOS",0
string_MoreLibSpace DC.B           "morelibspace", 0
 endif
 ifd DTtype
string_DatatypesLib DC.B           "datatypes.library", 0
string_System       DC.B           "System", 0
string_Text         DC.B           "Text", 0
string_Document     DC.B           "Document", 0
string_Sound        DC.B           "Sound", 0
string_Instrument   DC.B           "Instrument", 0
string_Music        DC.B           "Music", 0
string_Picture      DC.B           "Picture", 0
string_Animation    DC.B           "Animation", 0
string_Movie        DC.B           "Movie", 0
 endif
ENV_sys_def_        DC.B           "ENV:sys/def_",0
ENVARC_sys_def_     DC.B           "ENVARC:sys/def_",0
ENV_sys_def_RAM     DC.B           "ENV:sys/def_RAM",0
ENVARC_sys_def_RAM  DC.B           "ENVARC:sys/def_RAM",0
string_copy_of_     DC.B           "Copy_of_",0
string_copy_xld_of_ DC.B           "Copy_%ld_of_",0

string_disk         DC.B           "disk",0
string_drawer       DC.B           "drawer",0
string_tool         DC.B           "tool",0
string_project      DC.B           "project",0
string_trashcan     DC.B           "trashcan",0
string_device       DC.B           "device",0
string_kick         DC.B           "kick",0
string_RAM          DC.B           "RAM",0
string_Ram.         DC.B           "Ram:",0

                    CNOP 0,4

string_DontEdit     DC.B           "*** DON'T EDIT THE FOLLOWING LINES!! ***",0
string_Space        DC.B           " ",0

 ifd DTtype
                    CNOP 0,4

datatypegroup       DC.L           GID_SYSTEM
                    DC.L           GID_TEXT
                    DC.L           GID_DOCUMENT
                    DC.L           GID_SOUND
                    DC.L           GID_INSTRUMENT
                    DC.L           GID_MUSIC
                    DC.L           GID_PICTURE
                    DC.L           GID_ANIMATION
                    DC.L           GID_MOVIE

datatype2name       DC.W           string_System     - datatype2name
                    DC.W           string_Text       - datatype2name
                    DC.W           string_Document   - datatype2name
                    DC.W           string_Sound      - datatype2name
                    DC.W           string_Instrument - datatype2name
                    DC.W           string_Music      - datatype2name
                    DC.W           string_Picture    - datatype2name
                    DC.W           string_Animation  - datatype2name
                    DC.W           string_Movie      - datatype2name
 endif
                    CNOP 0,4
 ifd MC68020
converticonrequest  DC.L           $14
                    DC.L           $0
                    DC.L           converticontitle
                    DC.L           converticontext
                    DC.L           converticongadget
 endif

lowercase3bytes     DC.L           $20202000
lowercasefilter     DC.L           $20202020
longwordforram.     DC.L           "ram:"
longwordforram_     DC.L           "ram "
longwordfordisk     DC.L           "disk"

AreaFillPattern     DC.L           $44441111

DiskObjectNames     DC.W           string_disk     - DiskObjectNames
                    DC.W           string_drawer   - DiskObjectNames
                    DC.W           string_tool     - DiskObjectNames
                    DC.W           string_project  - DiskObjectNames
                    DC.W           string_trashcan - DiskObjectNames
                    DC.W           string_device   - DiskObjectNames
                    DC.W           string_kick     - DiskObjectNames

DiskObjectTypes     DC.W           DiskObject_disk     - DiskObjectTypes
                    DC.W           DiskObject_drawer   - DiskObjectTypes
                    DC.W           DiskObject_tool     - DiskObjectTypes
                    DC.W           DiskObject_project  - DiskObjectTypes
                    DC.W           DiskObject_trashcan - DiskObjectTypes
                    DC.W           DiskObject_device   - DiskObjectTypes
                    DC.W           DiskObject_kick     - DiskObjectTypes

                    CNOP 0,4

DiskObject_disk     DC.W           WB_DISKMAGIC     ; do_Magic
                    DC.W           $1               ; do_Version
longwordfor0000     DC.L           $0               ;  NextGadget
                    DC.W           $0               ;  LeftEdge
                    DC.W           $0               ;  TopEdge
                    DC.W           $23              ;  Width
                    DC.W           $12              ;  Height
                    DC.W           $5               ;  Flags
                    DC.W           $3               ;  Activation
                    DC.W           $1               ;  GadgetType
                    DC.L           Gadget_disk      ;  GadgetRender
                    DC.L           $0               ;  SelectRender
                    DC.L           $0               ;  GadgetText
                    DC.L           $0               ;  MutualExclude
                    DC.L           $0               ;  SpecialInfo
                    DC.W           $0               ;  GadgetID
                    DC.L           $1               ;  UserData
                    DC.B           WBDISK, 0        ; do_Type = 1
                    DC.L           $0               ; do_DefaultTool
                    DC.L           $0               ; do_ToolTypes
                    DC.L           NO_ICON_POSITION ; do_CurrentX
                    DC.L           NO_ICON_POSITION ; do_CurrentY
                    DC.L           DefDrawerData    ; do_DrawerData
                    DC.L           $0               ; do_ToolWindow
                    DC.L           $0               ; do_StackSize

DiskObject_drawer   DC.W           WB_DISKMAGIC     ; do_Magic
                    DC.W           $1               ; do_Version
                    DC.L           $0               ;  NextGadget
                    DC.W           $0               ;  LeftEdge
                    DC.W           $0               ;  TopEdge
                    DC.W           $30              ;  Width
                    DC.W           $E               ;  Height
                    DC.W           $6               ;  Flags
                    DC.W           $3               ;  Activation
                    DC.W           $1               ;  GadgetType
                    DC.L           Gadget_drawer    ;  GadgetRender
                    DC.L           Select_drawer    ;  SelectRender
                    DC.L           $0               ;  GadgetText
                    DC.L           $0               ;  MutualExclude
                    DC.L           $0               ;  SpecialInfo
                    DC.W           $0               ;  GadgetID
                    DC.L           $1               ;  UserData
                    DC.B           WBDRAWER, 0      ; do_Type = 2
                    DC.L           $0               ; do_DefaultTool
                    DC.L           $0               ; do_ToolTypes
                    DC.L           NO_ICON_POSITION ; do_CurrentX
                    DC.L           NO_ICON_POSITION ; do_CurrentY
                    DC.L           DefDrawerData    ; do_DrawerData
                    DC.L           $0               ; do_ToolWindow
                    DC.L           $0               ; do_StackSize

DiskObject_tool     DC.W           WB_DISKMAGIC     ; do_Magic
                    DC.W           $1               ; do_Version
                    DC.L           $0               ;  NextGadget
                    DC.W           $0               ;  LeftEdge
                    DC.W           $0               ;  TopEdge
                    DC.W           $30              ;  Width
                    DC.W           $15              ;  Height
                    DC.W           $4               ;  Flags
                    DC.W           $1               ;  Activation
                    DC.W           $1               ;  GadgetType
                    DC.L           Gadget_tool      ;  GadgetRender
                    DC.L           $0               ;  SelectRender
                    DC.L           $0               ;  GadgetText
                    DC.L           $0               ;  MutualExclude
                    DC.L           $0               ;  SpecialInfo
                    DC.W           $0               ;  GadgetID
                    DC.L           $1               ;  UserData
                    DC.B           WBTOOL, 0        ; do_Type = 3
                    DC.L           $0               ; do_DefaultTool
                    DC.L           $0               ; do_ToolTypes
                    DC.L           NO_ICON_POSITION ; do_CurrentX
                    DC.L           NO_ICON_POSITION ; do_CurrentY
                    DC.L           $0               ; do_DrawerData
                    DC.L           $0               ; do_ToolWindow
                    DC.L           $0               ; do_StackSize

DiskObject_project  DC.W           WB_DISKMAGIC     ; do_Magic
                    DC.W           $1               ; do_Version
                    DC.L           $0               ;  NextGadget
                    DC.W           $0               ;  LeftEdge
                    DC.W           $0               ;  TopEdge
                    DC.W           $30              ;  Width
                    DC.W           $15              ;  Height
                    DC.W           $4               ;  Flags
                    DC.W           $1               ;  Activation
                    DC.W           $1               ;  GadgetType
                    DC.L           Gadget_project   ;  GadgetRender
                    DC.L           $0               ;  SelectRender
                    DC.L           $0               ;  GadgetText
                    DC.L           $0               ;  MutualExclude
                    DC.L           $0               ;  SpecialInfo
                    DC.W           $0               ;  GadgetID
                    DC.L           $1               ;  UserData
                    DC.B           WBPROJECT, 0     ; do_Type = 4
                    DC.L           $0               ; do_DefaultTool
                    DC.L           $0               ; do_ToolTypes
                    DC.L           NO_ICON_POSITION ; do_CurrentX
                    DC.L           NO_ICON_POSITION ; do_CurrentY
                    DC.L           $0               ; do_DrawerData
                    DC.L           $0               ; do_ToolWindow
                    DC.L           $0               ; do_StackSize

DiskObject_trashcan DC.W           WB_DISKMAGIC     ; do_Magic
                    DC.W           $1               ; do_Version
                    DC.L           $0               ;  NextGadget
                    DC.W           $0               ;  LeftEdge
                    DC.W           $0               ;  TopEdge
                    DC.W           $30              ;  Width
                    DC.W           $1F              ;  Height
                    DC.W           $6               ;  Flags
                    DC.W           $3               ;  Activation
                    DC.W           $1               ;  GadgetType
                    DC.L           Gadget_trashcan  ;  GadgetRender
                    DC.L           Select_trashcan  ;  SelectRender
                    DC.L           $0               ;  GadgetText
                    DC.L           $0               ;  MutualExclude
                    DC.L           $0               ;  SpecialInfo
                    DC.W           $0               ;  GadgetID
                    DC.L           $1               ;  UserData
                    DC.B           WBGARBAGE, 0     ; do_Type = 5
                    DC.L           $0               ; do_DefaultTool
                    DC.L           $0               ; do_ToolTypes
                    DC.L           NO_ICON_POSITION ; do_CurrentX
                    DC.L           NO_ICON_POSITION ; do_CurrentY
                    DC.L           DefDrawerData    ; do_DrawerData
                    DC.L           $0               ; do_ToolWindow
                    DC.L           $0               ; do_StackSize

DiskObject_device   DC.W           WB_DISKMAGIC     ; do_Magic
                    DC.W           $1               ; do_Version
                    DC.L           $0               ;  NextGadget
                    DC.W           $0               ;  LeftEdge
                    DC.W           $0               ;  TopEdge
                    DC.W           $23              ;  Width
                    DC.W           $12              ;  Height
                    DC.W           $5               ;  Flags
                    DC.W           $3               ;  Activation
                    DC.W           $1               ;  GadgetType
                    DC.L           Gadget_disk      ;  GadgetRender
                    DC.L           $0               ;  SelectRender
                    DC.L           $0               ;  GadgetText
                    DC.L           $0               ;  MutualExclude
                    DC.L           $0               ;  SpecialInfo
                    DC.W           $0               ;  GadgetID
                    DC.L           $1               ;  UserData
                    DC.B           WBDEVICE, 0      ; do_Type = 6
                    DC.L           $0               ; do_DefaultTool
                    DC.L           $0               ; do_ToolTypes
                    DC.L           NO_ICON_POSITION ; do_CurrentX
                    DC.L           NO_ICON_POSITION ; do_CurrentY
                    DC.L           $0               ; do_DrawerData
                    DC.L           $0               ; do_ToolWindow
                    DC.L           $0               ; do_StackSize

DiskObject_kick     DC.W           WB_DISKMAGIC     ; do_Magic
                    DC.W           $1               ; do_Version
                    DC.L           $0               ;  NextGadget
                    DC.W           $0               ;  LeftEdge
                    DC.W           $0               ;  TopEdge
                    DC.W           $23              ;  Width
                    DC.W           $12              ;  Height
                    DC.W           $5               ;  Flags
                    DC.W           $3               ;  Activation
                    DC.W           $1               ;  GadgetType
                    DC.L           Gadget_disk      ;  GadgetRender
                    DC.L           $0               ;  SelectRender
                    DC.L           $0               ;  GadgetText
                    DC.L           $0               ;  MutualExclude
                    DC.L           $0               ;  SpecialInfo
                    DC.W           $0               ;  GadgetID
                    DC.L           $1               ;  UserData
                    DC.B           WBKICK, 0        ; do_Type = 7
                    DC.L           $0               ; do_DefaultTool
                    DC.L           $0               ; do_ToolTypes
                    DC.L           NO_ICON_POSITION ; do_CurrentX
                    DC.L           NO_ICON_POSITION ; do_CurrentY
                    DC.L           $0               ; do_DrawerData
                    DC.L           $0               ; do_ToolWindow
                    DC.L           $0               ; do_StackSize

                                                    ;  (NewWindow) 
DefDrawerData       DC.W           $32              ;  LeftEdge  50
                    DC.W           $32              ;  TopEdge   50
                    DC.W           $190             ;  Width    400
                    DC.W           $64              ;  Height   100
                    DC.B           -$1              ;  DetailPen   
                    DC.B           -$1              ;  BlockPen    
                    DC.L           $0               ;  IDCMPFlags  
                    DC.L           $0240027F        ;  Flags       
                    DC.L           $0               ;  FirstGadget 
                    DC.L           $0               ;  CheckMark   
                    DC.L           $0               ;  Title       
                    DC.L           $0               ;  Screen      
                    DC.L           $0               ;  BitMap      
                    DC.W           $5A              ;  MinWidth  90
                    DC.W           $28              ;  MinHeight 40
                    DC.W           -$1              ;  MaxWidth    
                    DC.W           -$1              ;  MaxHeight   
                    DC.W           $1               ;  Type        
                    DC.L           $0               ; dd_CurrentX  
                    DC.L           $0               ; dd_CurrentY  
                    DC.L           $0               ; dd_Flags     
                    DC.W           $0               ; dd_ViewModes 

Gadget_disk         DC.W           $0               ; LeftEdge
                    DC.W           $0               ; TopEdge
                    DC.W           $23              ; Width
                    DC.W           $11              ; Height
                    DC.W           $2               ; Depth
                    DC.L           Image1_disk      ; ImageData
                    DC.B           $3               ; PlanePick
                    DC.B           $0               ; PlaneOnOff
                    DC.L           $0               ; NextImage

Gadget_drawer       DC.W           $0               ; LeftEdge
                    DC.W           $0               ; TopEdge
                    DC.W           $30              ; Width
                    DC.W           $E               ; Height
                    DC.W           $2               ; Depth
                    DC.L           Image1_drawer    ; ImageData
                    DC.B           $3               ; PlanePick
                    DC.B           $0               ; PlaneOnOff
                    DC.L           $0               ; NextImage

Select_drawer       DC.W           $0               ; LeftEdge
                    DC.W           $0               ; TopEdge
                    DC.W           $30              ; Width
                    DC.W           $E               ; Height
                    DC.W           $2               ; Depth
                    DC.L           Image2_drawer    ; ImageData
                    DC.B           $3               ; PlanePick
                    DC.B           $0               ; PlaneOnOff
                    DC.L           $0               ; NextImage

Gadget_tool         DC.W           $0               ; LeftEdge
                    DC.W           $0               ; TopEdge
                    DC.W           $30              ; Width
                    DC.W           $14              ; Height
                    DC.W           $2               ; Depth
                    DC.L           Image1_tool      ; ImageData
                    DC.B           $3               ; PlanePick
                    DC.B           $0               ; PlaneOnOff
                    DC.L           $0               ; NextImage

Gadget_project      DC.W           $0               ; LeftEdge
                    DC.W           $0               ; TopEdge
                    DC.W           $30              ; Width
                    DC.W           $14              ; Height
                    DC.W           $2               ; Depth
                    DC.L           Image1_project   ; ImageData
                    DC.B           $3               ; PlanePick
                    DC.B           $0               ; PlaneOnOff
                    DC.L           $0               ; NextImage

Gadget_trashcan     DC.W           $0               ; LeftEdge
                    DC.W           $0               ; TopEdge
                    DC.W           $30              ; Width
                    DC.W           $1E              ; Height
                    DC.W           $2               ; Depth
                    DC.L           Image1_trashcan  ; ImageData
                    DC.B           $3               ; PlanePick
                    DC.B           $0               ; PlaneOnOff
                    DC.L           $0               ; NextImage

Select_trashcan     DC.W           $0               ; LeftEdge
                    DC.W           $0               ; TopEdge
                    DC.W           $30              ; Width
                    DC.W           $1E              ; Height
                    DC.W           $2               ; Depth
                    DC.L           Image2_trashcan  ; ImageData
                    DC.B           $3               ; PlanePick
                    DC.B           $0               ; PlaneOnOff
                    DC.L           $0               ; NextImage

                    CNOP           0,4

Image1_disk         DC.W           $7F80, $001F, $8000
                    DC.W           $FF80, $071F, $E000
                    DC.W           $FF80, $071F, $E000
                    DC.W           $FF80, $071F, $E000
                    DC.W           $FF80, $071F, $E000
                    DC.W           $FFC0, $003F, $E000
                    DC.W           $FFFF, $FFFF, $E000
                    DC.W           $FFFF, $FFFF, $E000
                    DC.W           $F800, $0003, $E000
                    DC.W           $F000, $0001, $E000
                    DC.W           $F000, $06C1, $E000
                    DC.W           $F000, $0D81, $E000
                    DC.W           $F000, $1B01, $E000
                    DC.W           $F01B, $3601, $E000
                    DC.W           $F00D, $EC01, $E000
                    DC.W           $9006, $D801, $E000
                    DC.W           $F000, $0001, $E000
                    DC.W           $007F, $FFE0, $0000
                    DC.W           $007F, $F8E0, $0000
                    DC.W           $007F, $F8E0, $0000
                    DC.W           $007F, $F8E0, $0000
                    DC.W           $007F, $F8E0, $0000
                    DC.W           $003F, $FFC0, $0000
                    DC.W           $0000, $0000, $0000
                    DC.W           $0000, $0000, $0000
                    DC.W           $07FF, $FFFC, $0000
                    DC.W           $0FFF, $FFFE, $0000
                    DC.W           $0FFF, $F93E, $0000
                    DC.W           $0FFF, $F27E, $0000
                    DC.W           $0FFF, $E4FE, $0000
                    DC.W           $0FE4, $C9FE, $0000
                    DC.W           $0FF2, $13FE, $0000
                    DC.W           $0FF9, $27FE, $0000
                    DC.W           $0FFF, $FFFE, $0000

Image1_drawer       DC.W           $0000, $0000, $0000
                    DC.W           $0FFF, $FFFF, $FFE4
                    DC.W           $0C00, $0000, $0004
                    DC.W           $0800, $0000, $0024
                    DC.W           $0800, $9FF2, $0024
                    DC.W           $0800, $9D52, $0024
                    DC.W           $0800, $8002, $0024
                    DC.W           $0800, $7FFC, $0024
                    DC.W           $0800, $0000, $0024
                    DC.W           $09FF, $FFFF, $FFE4
                    DC.W           $0000, $0000, $0004
                    DC.W           $0FFF, $FFFF, $FFFC
                    DC.W           $0000, $0000, $0000
                    DC.W           $0000, $0000, $0000
                    DC.W           $3FFF, $FFFF, $FFF8
                    DC.W           $3000, $0000, $0018
                    DC.W           $33FF, $FFFF, $FFF8
                    DC.W           $37FF, $FFFF, $FFD8
                    DC.W           $37FF, $600D, $FFD8
                    DC.W           $37FF, $62AD, $FFD8
                    DC.W           $37FF, $7FFD, $FFD8
                    DC.W           $37FF, $8003, $FFD8
                    DC.W           $37FF, $FFFF, $FFD8
                    DC.W           $3600, $0000, $0018
                    DC.W           $3FFF, $FFFF, $FFF8
                    DC.W           $0000, $0000, $0000
                    DC.W           $0000, $0000, $0000
                    DC.W           $0000, $0000, $0000

Image2_drawer       DC.W           $0000, $0000, $0000
                    DC.W           $0FFF, $FFFF, $FFE4
                    DC.W           $1AAA, $AAAA, $AAB4
                    DC.W           $3555, $5555, $555C
                    DC.W           $7FFF, $FFFF, $FFFC
                    DC.W           $4000, $0000, $0004
                    DC.W           $4000, $0000, $0006
                    DC.W           $4000, $9FF2, $0006
                    DC.W           $4000, $9D52, $0006
                    DC.W           $4000, $8002, $0006
                    DC.W           $4000, $7FFC, $0006
                    DC.W           $4000, $0000, $0006
                    DC.W           $7FFF, $FFFF, $FFFE
                    DC.W           $02AA, $AAAA, $AAAA
                    DC.W           $3FFF, $FFFF, $FFF8
                    DC.W           $3000, $0000, $0018
                    DC.W           $22AA, $AAAA, $AAA8
                    DC.W           $0555, $5555, $5550
                    DC.W           $0000, $0000, $0000
                    DC.W           $3FFF, $FFFF, $FFF8
                    DC.W           $3FFF, $FFFF, $FFF8
                    DC.W           $3FFF, $600D, $FFF8
                    DC.W           $3FFF, $62AD, $FFF8
                    DC.W           $3FFF, $7FFD, $FFF8
                    DC.W           $3FFF, $8003, $FFF8
                    DC.W           $3FFF, $FFFF, $FFF8
                    DC.W           $0000, $0000, $0000
                    DC.W           $0000, $0000, $0000

Image1_tool         DC.W           $0000, $0000, $0001
                    DC.W           $0000, $0000, $0003
                    DC.W           $0000, $0000, $0003
                    DC.W           $0000, $0000, $0003
                    DC.W           $3F00, $FFFE, $0003
                    DC.W           $2083, $0001, $C003
                    DC.W           $207C, $0000, $3803
                    DC.W           $2000, $0000, $0603
                    DC.W           $2000, $0000, $0103
                    DC.W           $2000, $0000, $0083
                    DC.W           $207C, $0001, $FC43
                    DC.W           $2082, $0002, $0323
                    DC.W           $3F01, $800C, $00D3
                    DC.W           $0000, $6030, $0033
                    DC.W           $0000, $2020, $0003
                    DC.W           $0000, $2020, $0003
                    DC.W           $0000, $2020, $0003
                    DC.W           $0000, $3FE0, $0003
                    DC.W           $0000, $0000, $0003
                    DC.W           $7FFF, $FFFF, $FFFF
                    DC.W           $FFFF, $FFFF, $FFFE
                    DC.W           $D555, $5555, $5554
                    DC.W           $D555, $5555, $5554
                    DC.W           $D555, $5555, $5554
                    DC.W           $C055, $0001, $5554
                    DC.W           $C054, $0000, $1554
                    DC.W           $C000, $0000, $0554
                    DC.W           $C000, $0000, $0154
                    DC.W           $C000, $0000, $0054
                    DC.W           $C000, $0000, $0054
                    DC.W           $C000, $0000, $0014
                    DC.W           $C054, $0001, $5414
                    DC.W           $C054, $0001, $5504
                    DC.W           $D555, $0005, $5544
                    DC.W           $D555, $4015, $5554
                    DC.W           $D555, $4015, $5554
                    DC.W           $D555, $4015, $5554
                    DC.W           $D555, $4015, $5554
                    DC.W           $D555, $5555, $5554
                    DC.W           $8000, $0000, $0000

Image1_project      DC.W           $0000, $0000, $0001
                    DC.W           $0000, $0000, $0003
                    DC.W           $0000, $0000, $0003
                    DC.W           $0000, $0000, $0003
                    DC.W           $0003, $8000, $0003
                    DC.W           $0007, $C000, $0003
                    DC.W           $000E, $E000, $0003
                    DC.W           $001C, $7000, $0003
                    DC.W           $0038, $3800, $0003
                    DC.W           $0070, $1C00, $0003
                    DC.W           $00FF, $FE01, $FFC3
                    DC.W           $007F, $FE00, $0003
                    DC.W           $0000, $0001, $F803
                    DC.W           $0000, $0000, $0003
                    DC.W           $0000, $007F, $FFF3
                    DC.W           $0000, $0000, $0003
                    DC.W           $0000, $007F, $FF03
                    DC.W           $0000, $0000, $0003
                    DC.W           $0000, $0000, $0003
                    DC.W           $7FFF, $FFFF, $FFFF
                    DC.W           $FFFF, $FFFF, $FFFE
                    DC.W           $D555, $5555, $5554
                    DC.W           $DFFF, $FFFD, $5554
                    DC.W           $D000, $0005, $5554
                    DC.W           $D003, $0005, $5554
                    DC.W           $D007, $8005, $5554
                    DC.W           $D00C, $C005, $5554
                    DC.W           $D018, $6005, $FFFC
                    DC.W           $D030, $3005, $FFFC
                    DC.W           $D060, $1805, $FFFC
                    DC.W           $D0FF, $FC04, $003C
                    DC.W           $D000, $0005, $FFFC
                    DC.W           $D000, $0004, $07FC
                    DC.W           $DFFF, $FFFD, $FFFC
                    DC.W           $D555, $5780, $000C
                    DC.W           $D555, $57FF, $FFFC
                    DC.W           $D555, $5780, $00FC
                    DC.W           $D555, $57FF, $FFFC
                    DC.W           $D555, $57FF, $FFFC
                    DC.W           $8000, $0000, $0000

Image1_trashcan     DC.W           $0000, $0000, $0000
                    DC.W           $0000, $0000, $0000
                    DC.W           $0000, $0000, $0000
                    DC.W           $0000, $0000, $0000
                    DC.W           $0000, $3FE0, $0000
                    DC.W           $0000, $E038, $0000
                    DC.W           $07FF, $FFFF, $FFC0
                    DC.W           $0FFF, $FFFF, $FFE0
                    DC.W           $1FFF, $FFFF, $FFF0
                    DC.W           $1FFF, $FFFF, $FFF0
                    DC.W           $0FFF, $FFFF, $FFE0
                    DC.W           $0FFF, $FFFF, $FFE0
                    DC.W           $0FFF, $FFFF, $FFE0
                    DC.W           $0FFF, $FFFF, $FFE0
                    DC.W           $0FFF, $FFFF, $FFE0
                    DC.W           $0FFF, $FFFF, $FFE0
                    DC.W           $07FF, $FFFF, $FFE0
                    DC.W           $07FF, $FFFF, $FFC0
                    DC.W           $07FF, $FFFF, $FFC0
                    DC.W           $07FF, $FFFF, $FFC0
                    DC.W           $07FF, $FFFF, $FFC0
                    DC.W           $07FF, $FFFF, $FFC0
                    DC.W           $07FF, $FFFF, $FFC0
                    DC.W           $03FF, $FFFF, $FF80
                    DC.W           $03FF, $FFFF, $FF80
                    DC.W           $03FF, $FFFF, $FF80
                    DC.W           $03FF, $FFFF, $FFF8
                    DC.W           $03FF, $FFFF, $FFFF
                    DC.W           $01FF, $FFFF, $FFFF
                    DC.W           $000F, $FFFF, $FFFC
                    DC.W           $0000, $0000, $0000
                    DC.W           $0000, $0000, $0000
                    DC.W           $0000, $0000, $0000
                    DC.W           $0000, $0000, $0000
                    DC.W           $0000, $0000, $0000
                    DC.W           $0000, $0000, $0000
                    DC.W           $0000, $0000, $0000
                    DC.W           $03FF, $FFF5, $5500
                    DC.W           $07FF, $FFFF, $AA80
                    DC.W           $0000, $0000, $0000
                    DC.W           $03FF, $FF55, $5400
                    DC.W           $03FF, $FFFF, $AA80
                    DC.W           $038F, $FC7D, $4200
                    DC.W           $0317, $F8BE, $8880
                    DC.W           $0337, $F9BF, $9100
                    DC.W           $0313, $F9BF, $1000
                    DC.W           $019B, $F9BE, $9100
                    DC.W           $019B, $F93F, $1200
                    DC.W           $019B, $F9BE, $9100
                    DC.W           $019B, $F93F, $2200
                    DC.W           $019B, $F9BE, $2500
                    DC.W           $0189, $F93F, $2200
                    DC.W           $01CD, $F9BE, $2400
                    DC.W           $00C9, $F93D, $2A00
                    DC.W           $00CD, $F9BE, $4400
                    DC.W           $00C7, $F9FE, $4A00
                    DC.W           $00E3, $FE75, $1400
                    DC.W           $007F, $FFEA, $A800
                    DC.W           $0000, $0000, $0000
                    DC.W           $0000, $0000, $0000

Image2_trashcan     DC.W           $0003, $FFFF, $8000
                    DC.W           $00FF, $FFFF, $FE00
                    DC.W           $07FF, $FFFF, $FFC0
                    DC.W           $0FFF, $FFFF, $FFE0
                    DC.W           $1FFF, $FFFF, $FFF0
                    DC.W           $1FFF, $FFFF, $FFF0
                    DC.W           $0FFF, $FFFF, $FFE0
                    DC.W           $00FF, $FFFF, $FE00
                    DC.W           $0003, $FFFF, $8000
                    DC.W           $1FFF, $FFFF, $FFF0
                    DC.W           $0FFF, $FFFF, $FFE0
                    DC.W           $0FFF, $FFFF, $FFE0
                    DC.W           $0FFF, $FFFF, $FFE0
                    DC.W           $0FFF, $FFFF, $FFE0
                    DC.W           $0FFF, $FFFF, $FFE0
                    DC.W           $0FFF, $FFFF, $FFE0
                    DC.W           $07FF, $FFFF, $FFE0
                    DC.W           $07FF, $FFFF, $FFC0
                    DC.W           $07FF, $FFFF, $FFC0
                    DC.W           $07FF, $FFFF, $FFC0
                    DC.W           $07FF, $FFFF, $FFC0
                    DC.W           $07FF, $FFFF, $FFC0
                    DC.W           $07FF, $FFFF, $FFC0
                    DC.W           $03FF, $FFFF, $FF80
                    DC.W           $03FF, $FFFF, $FF80
                    DC.W           $03FF, $FFFF, $FF80
                    DC.W           $03FF, $FFFF, $FFF8
                    DC.W           $03FF, $FFFF, $FFFF
                    DC.W           $01FF, $FFFF, $FFFF
                    DC.W           $000F, $FFFF, $FFFC
                    DC.W           $0000, $0000, $0000
                    DC.W           $0003, $FFFF, $8000
                    DC.W           $00FC, $0000, $7E00
                    DC.W           $0702, $AAAA, $81C0
                    DC.W           $0855, $6AB5, $5420
                    DC.W           $02AA, $AAAA, $ABC0
                    DC.W           $00FD, $5555, $7E00
                    DC.W           $0003, $FFFF, $8000
                    DC.W           $0000, $0000, $0000
                    DC.W           $0000, $0000, $0000
                    DC.W           $03FF, $FF55, $5400
                    DC.W           $03FF, $FFFF, $AA80
                    DC.W           $038F, $FC7D, $4200
                    DC.W           $0317, $F8BE, $8880
                    DC.W           $0337, $F9BF, $9100
                    DC.W           $0313, $F9BF, $1000
                    DC.W           $019B, $F9BE, $9100
                    DC.W           $019B, $F93F, $1200
                    DC.W           $019B, $F9BE, $9100
                    DC.W           $019B, $F93F, $2200
                    DC.W           $019B, $F9BE, $2500
                    DC.W           $0189, $F93F, $2200
                    DC.W           $01CD, $F9BE, $2400
                    DC.W           $00C9, $F93D, $2A00
                    DC.W           $00CD, $F9BE, $4400
                    DC.W           $00C7, $F9FE, $4A00
                    DC.W           $00E3, $FE75, $1400
                    DC.W           $007F, $FFEA, $A800
                    DC.W           $0000, $0000, $0000
                    DC.W           $0000, $0000, $0000

                    CNOP           0,4

Dot_ImageData       DC.W           %0000000000000000
                    DC.W           %0011110000000000
                    DC.W           %0111111000000000
                    DC.W           %0111111000000000
                    DC.W           %0111111000000000
                    DC.W           %0111111000000000
                    DC.W           %0011110000000000
                    DC.W           %0000000000000000

DontFail_Tags       DC.L           ICONGETA_FailIfUnavailable    ; $8000902F
                    DC.L           $0                            ; array end
                    DC.L           TAG_DONE

GetDO_Planar_Tags   DC.L           ICONGETA_GetPaletteMappedIcon ; $80009030
                    DC.L           $0
                    DC.L           ICONGETA_GenerateImageMasks   ; $80009033
                    DC.L           $0
                    DC.L           TAG_DONE

Snapshot_Tags       DC.L           ICONPUTA_OnlyUpdatePosition   ; $80009048
                    DC.L           $1
                    DC.L           TAG_DONE

PutDO_Tags          DC.L           ICONPUTA_NotifyWorkbench      ; $80009035
                    DC.L           $1
                    DC.L           TAG_DONE

DupDO_Tags          DC.L           ICONDUPA_DuplicateDrawerData  ; $8000903C
                    DC.L           $1
                    DC.L           ICONDUPA_DuplicateImages      ; $8000903D
                    DC.L           $2
                    DC.L           ICONDUPA_DuplicateImageData   ; $8000903E
                    DC.L           $4
                    DC.L           ICONDUPA_DuplicateDefaultTool ; $8000903F
                    DC.L           $8
                    DC.L           ICONDUPA_DuplicateToolTypes   ; $80009040
                    DC.L           $10
                    DC.L           ICONDUPA_DuplicateToolWindow  ; $80009041
                    DC.L           $20
                    DC.L           ICONDUPA_ActivateImageData    ; $80009052
                    DC.L           $40
EmptyTagList        DC.L           TAG_DONE

;--------------------------------------------------------------------zzz
 
zlib_inflate   subq.l  #4,D0                   ; z-stream size < 4 ?
               bmi.w   exitinflate
               movem.l D2/D6/A2-A3/A6,-(sp)
               LEA     -$14(SP),SP
               ADD.L   A0,D0
               ADD.L   A1,D1
               MOVEA.L A0,A2                   ; zlib input stream
               MOVE.L  D0,D2                   ; end of z-stream (CRC)
               MOVEA.L A1,A3                   ; output buffer
               MOVE.L  D1,D6                   ; end of output buffer
 ifd MC68020
               PEA     $B80(A5)                ; 1444 longwords buffer
               TST.B   $EE(A5)                 ; flag for MoreLibSpace
               BEQ.S   .protectionON
               clr.l   (SP)                    ; used by MoreLibSpace
 else
               clr.l   -(SP)
 endif
.protectionON  BSET.B  #0,$F1(A5)              ; enable buffer protection
               BEQ.S   .getthebuffer
               BSR.W   bitlockdelay

.getthebuffer  MOVE.L  $970(A5),D0
               BNE.W   reusebuffer             ; -------------------------
 ifd MC68020
               MOVE.W  #$38+$140+$880,D0       ; 56 + 320 bytes + bigtabs
               TST.L   (SP)
               BNE.S   .memsizedone
               ADDI.W  #$1690+$280,D0          ; + 1444 longs + 320 words
.memsizedone
 else
               MOVE.W  #$38+$140+$880+$1690+$280,D0
 endif
               MOVEQ   #MEMF_PUBLIC,D1
               MOVEA.L $26(A5),A6              ; execbase
               JSR     _LVOAllocVec(A6)
               MOVEQ   #14-1,D1                ; bitmask counter or error
               MOVE.L  D0,$970(A5)             ; store the memblock
               beq.w   returnerror
               MOVEM.L D0/D2-D6,-(SP)
               PEA     bigtabsdone(PC)

               MOVEA.W #$1FFF,A0               ; bitmask for 13 bits
               EXG     D0,A0                   ; table for 14 long bitmasks
               ADDA.W  #$38,A0                 ; records (320 bytes buffer)
               MOVEA.L A0,A1
.nextbitmask   MOVE.L  D0,-(A1)
               LSR.L   #1,D0
               DBRA.S  D1,.nextbitmask

               LEA     $140(A0),A1             ; the bigtabs
               MOVEQ   #9-1+2,D2               ; 9-bit table
              
               MOVE.L  #$60070100,(A0)         ; end of block
               MOVEQ   #4-1,D4                 ; record count
               BSR.W   writerecords
              
               MOVE.L  #$50070003,(A0)         ; length
               MOVEQ   #8-1,D5                 ; block count 
               MOVEQ   #1,D3                   ; add to data
               BSR.S   recordblock
               MOVEQ   #4-1,D5                 ; block count 
               BSR.S   recordblock
               BSR.S   recordblock
               BSR.S   recordblock
               MOVEQ   #3-1,D5                 ; block count 
               BSR.S   recordblock
              
               CLR.L   (A0)                    ; literal bytes
               ADDQ.W  #8,(A0)                 ; 8 bits
               MOVE.W  #144-1,D5               ; block count
               MOVEQ   #1,D3                   ; add to data
               MOVEQ   #2-1,D4                 ; record count
               BSR.S   recordblock

               MOVE.L  #$54080073,(A0)         ; length
               MOVEQ   #1-1,D5                 ; block count 
               MOVEQ   #16,D3                  ; add to data
               BSR.S   recordblock
               MOVEQ   #4-1,D5                 ; block count 
               BSR.S   recordblock
              
               MOVE.L  #$50080102,(A0)         ; length 258
               BSR.S   writerecords
              
               MOVE.L  #$C0080000,(A0)         ; never used
               BSR.S   writerecords            ; code 286
               BSR.S   writerecords            ; code 287

               MOVE.L  #$00090090,(A0)         ; literal bytes
               MOVE.W  #112-1,D5               ; block count
               MOVEQ   #1,D3                   ; add to data
               MOVEQ   #1-1,D4                 ; record count
               BSR.S   recordblock
              
               ADDA.W  #2048,A1
               MOVEQ   #0,D0                   ; address
               MOVEQ   #5-1+2,D2               ; 5-bit table
              
               MOVE.L  #$50050001,(A0)         ; distances
               MOVEQ   #4-1,D5                 ; block count 
               MOVEQ   #1,D3                   ; add to data
               BSR.S   recordblock
               MOVEQ   #2-1,D5                 ; block count
               MOVEQ   #13-1,D6                ; repeat count
.writeblock    BSR.S   recordblock
               DBRA.S  D6,.writeblock
              
               MOVE.L  #$C0056001,(A0)         ; never used
               MOVEQ   #2-1,D4                 ; record count
               BRA.S   writerecords
              
recordblock
               MOVE.L  D5,-(SP)                ; block count
.newrecord     BSR.S   writerecords
               ADD.L   D3,(A0)                 ; add to data
               DBRA.S  D5,.newrecord
               ADDQ.B  #1,(A0)                 ; more extra bits
               ADD.L   D3,D3
               MOVE.L  (SP)+,D5
               RTS
              
writerecords                                   ; (A0)=record D0=address
               MOVE.L  D4,-(SP)                ; record count
.nextrecord    BSR.S   reversebits
               ADDQ.L  #1,D0
 ifd MC68020
               MOVE.L  (A0),(A1,D1.L)
 else
               MOVE.L  (A0),(A1,D1.W)
 endif
               DBRA    D4,.nextrecord
               MOVE.L  (SP)+,D4
               RTS
              
reversebits                                    ; D0=address D2=table bits
               MOVEM.L D0/D2,-(SP)
               MOVEQ   #0,D1
.nextbit       LSR.L   #1,D0
               ADDX.L  D1,D1
               DBRA.S  D2,.nextbit
               MOVEM.L (SP)+,D0/D2
               RTS

bigtabsdone    MOVEM.L (SP)+,D0/D2-D6
reusebuffer    MOVEQ   #$F,D1                  ; ------------------------
               AND.B   (A2),D1                 ; get 4 zlib stream bits
               SUBQ.L  #8,D1                   ; is the method = 8 ?
               bne.s   returnerror
 ifd MC68020
               move.w  (A2)+,d1                ; read 1. zlib stream word
 else
               move.B  (A2)+,-(SP)
               MOVE.W  (SP)+,D1
               move.B  (A2)+,D1
 endif
               btst    #5,d1                   ; test the dictionary flag
               bne.s   returnerror
               divu.w  #31,d1                  ; must be multiple of 31
               CLR.W   D1                      ; clear the quotient word
returnerror    tst.l   d1
               bne.w   quitinflate
 ifd MC68020
               TST.L   (SP)
               BNE.S   decoding
 endif
               MOVEA.L D0,A0                   ; allocated memblock
               ADDA.W  #$38+$140+$880,A0
               MOVE.L  A0,(SP)                 ; 1444 longwords buffer
decoding:      ;---------------------------------------------------------
               movem.l d2-d5/d7/a4-a6,-(sp)
               MOVEA.L D0,A4                   ; table with 14 bitmasks
               moveq   #0,d2                   ; remaining bits in buffer
               moveq   #0,d5                   ; input bit shift buffer
mainloop:
               CMPA.L  (SP),A2                 ; end of z-stream data ?
               BCC.W   decodingerror1
               subq.l  #3,d2                   ; 3 header bits wanted
               bcc.s   .enoughbits
               addq.l  #3,d2
               moveq   #0,d0
               move.b  (A2)+,d0                ; read another byte
               lsl.l   d2,d0
               or.l    d0,d5
               addq.l  #5,d2                   ; 8 bits read, - 3 used
.enoughbits
               moveq   #1,d0
               and.l   d5,d0                   ; BFINAL = last block
               SUBQ.L  #1,D0
               move.l  d0,$30(SP)              ; decoding done flag
               MOVEQ   #6,D0
               AND.L   D5,D0                   ; case 0, 2, 4, 6=error
               lsr.l   #3,d5
               subq.l  #2,d0                   ; case 2 = fixed codes?
               beq.w   usethebigtabs           ; BIGTABS for Kens icons
               subq.l  #2,d0
               beq.s   dynamiccoding           ; case 4 = dynamic codes?
               bgt.w   decodingerror1          ; case 6 = error
               moveq   #7,d0                   ; VERY RARELY USED BELOW
               and.l   d2,d0                   ; case 0 = no compression
               lsr.l   d0,d5                   ; any remaining bits ?
               sub.l   d0,d2
               moveq   #32,d1                  ; 32 bits for LEN + NLEN
.readnextbyte
               MOVEQ   #0,D0
               move.b  (A2)+,d0
               lsl.l   d2,d0
               or.l    d0,d5
               addq.l  #8,d2
               cmp.l   D1,D2
               bcs.s   .readnextbyte
               MOVE.L  D5,D1
               NOT.L   D1
               CLR.W   D1
               SWAP    D1
               CMP.W   D5,D1                   ; NLEN = NOT LEN ?
               bne.w   decodingerror1
               MOVEQ   #0,D2                   ; no remaining bits
               MOVEQ   #0,D5                   ; clear bit shift buffer
               MOVE.L  (SP),D0                 ; end of input =>(CRC)
               SUB.L   A2,D0                   ; - next byte to read
               cmp.l   D1,D0                   ; input size - LEN
               BCS.W   decodingerror1
               subq.l  #1,D1
               bcs.s   checkifdone
.copyinputout
               move.b  (A2)+,(A3)+             ; not optimized here !
               DBRA    D1,.copyinputout        ; very rarely used code
checkifdone
               move.l  $30(SP),D1
               bne.s   mainloop
               bra.w   decodingdone

dynamiccoding  ;-------------------------------------------------------
               MOVEM.L D0/D6/A3-A4,-(SP)       ; save the pointers
               ADDA.W  #$38,A4                 ; 320 byte buffer
               MOVE.L  $20+$10(SP),D6          ; 1444 longwords buffer
               moveq   #14,D4                  ; 14 bits wanted
.readnextbyte
               MOVEQ   #0,D0
               move.b  (A2)+,d0
               lsl.l   d2,d0
               or.l    d0,d5
               addq.l  #8,d2
               cmp.l   D4,D2
               bcs.s   .readnextbyte
               move.l  d5,d0
               moveq   #$1f,d1
               and.l   d1,d0                   ; 5 bits HLIT (257-286)
               moveq   #29,d7
               cmp.l   D7,D0                   ; > 29 ?
               bhi.w   decodingerror2
               LSR.L   #5,D5
               AND.L   D5,D1                   ; 5 bits HDIST (1-32)
               cmp.l   D7,D1                   ; > 29 ?
               bhi.w   decodingerror2
               movem.w D0-D1,(SP)              ; save HLIT and HDIST
               LSR.L   #5,D5
               MOVEQ   #$F,D3
               AND.L   D5,D3                   ; upper 4 bits
               LSR.L   #4,D5
               sub.l   d4,d2
               addq.l  #3,d3                   ; HCLEN 3-18
               move.l  d3,d4
               LEA     table19(pc),A0          ; 10,11,12,00,08,07,09,06,0a,05
                                               ; 0b,04,0c,03,0d,02,0e,01,0f
               moveq   #0,d0
nextthreebits
               subq.l  #3,D2                   ; 3 code length bits wanted
               bcc.s   .enoughbits
               addq.l  #3,D2
               move.b  (A2)+,d0                ; read another byte
               lsl.l   d2,d0
               or.l    d0,d5
               addq.l  #5,d2
.enoughbits
               moveq   #7,d0
               and.l   d5,d0
               lsr.l   #3,d5
               move.b  (A0)+,D1                ; the HCLEN order offset 0-18
 ifd MC68020
               move.b  D0,(A4,D1.L)            ; 3 bits into 320 byte buffer
 else
               move.b  D0,(A4,D1.W)
 endif
               dbra.s  D4,nextthreebits
               moveq   #17,D4
               sub.l   D3,D4
               bcs.b   stored19bytes
clearupto19th
               move.b  (A0)+,D1
 ifd MC68020
               clr.b   (A4,D1.L)               ; clear 320 byte buffer < 19
 else
               clr.b   (A4,D1.W)
 endif
               DBRA    D4,clearupto19th
stored19bytes
               CLR.L   -(SP)                   ; no Huffman table required
               MOVEA.W #19,A0                  ; max 19 codes
               MOVEA.W #7,A1                   ; initial tabsize = 7 bits
               MOVE.L  A0,-(SP)                ; min 19
               MOVEQ   #0,D1                   ; output starts at offset 0
               bsr.w   tablegenerator          ; D6 = 1444 longwords buffer
               ADDQ.W  #8,SP
               MOVEM.W (SP),D0-D1              ; HLIT (0-29), HDIST (0-29)
               MOVEA.W #258,A3
               ADDA.L  D0,A3
               ADDA.L  D1,A3                   ; max symbol count (316)
               MOVEA.L $C(SP),A6               ; pointer to the bitmasks
 ifd MC68020
               move.l  (A6,A1.L*4),D7          ; used bitmask
 else
               MOVE.L  A1,D0
               ADD.B   D0,D0
               ADD.B   D0,D0
               move.l  (A6,D0.W),D7
 endif
               SUBA.L  A5,A5                   ; symbol counter = 0
               bra.s   dynamicloop             ; going into dynamicloop
repeatcodelen                                  ; -----------------------
               moveq   #18,D0                  ; coming from dynamicloop
               cmp.l   D0,D4
               beq.b   .repeatcode18
               moveq   #-14,D1
               add.l   D4,D1                   ; 16-14=2, 17-14=3 bits
               moveq   #3,D3                   ; 3-10 repeats of len 0
               bra.s   .getextrabits
.repeatcode18
               moveq   #7,D1                   ; 7 more bits required
               moveq   #11,D3                  ; 11-138 repeats of 0
.getextrabits
               cmp.l   D1,D2
               bcc.s   .enoughbits
.readnextbyte
               move.b  (A2)+,d0
               lsl.l   d2,d0
               or.l    d0,d5
               addq.l  #8,d2
.enoughbits
               move.l  d5,d0
               lsr.l   D1,d5
               sub.l   D1,d2
 ifd MC68020
               and.l   (A6,D1.L*4),d0          ; mask out extra bits
 else
               ADD.B   D1,D1
               ADD.B   D1,D1
               and.l   (A6,D1.W),d0
 endif
               ADD.L   D0,D3
               MOVE.L  A5,D0                   ; symbol counter
               ADD.L   D3,D0
               cmp.l   A3,D0
               bhi.w   decodingerror2
 ifd MC68020
               LEA     (A4,A5.L),A0            ; 320 bytes buffer
 else
               LEA     (A4,A5.W),A0
 endif
               MOVEQ   #0,D1                   ; default codelen = 0
               moveq   #16,d0
               cmp.l   D0,D4
               bne.b   repeatlenzero
               move.l  A5,D0                   ; symbol counter = 0 ?
               beq.w   decodingerror2
               move.b  -1(A0),D1               ; previous codelen = 0-15
repeatlenzero
               move.l  D3,D0                   ; repeat count for codelen
               SUBQ.L  #1,D0
.repeatthelen  MOVE.B  D1,(A0)+                ; 320 bytes buffer + offset
               DBRA    D0,.repeatthelen
               ADDA.L  D3,A5
               cmpa.l  A3,A5                   ; symbol counter
               bcc.s   dynamictables
dynamicloop:                                   ; ------------------------
               cmp.l   A1,D2                   ; 7 bits or less wanted
               bcc.s   .enoughbits             ; IMPORTANT: D1 < 256 !
               move.b  (A2)+,D1                ; read another byte
               lsl.l   D2,D1
               or.l    D1,D5
               addq.l  #8,d2
.enoughbits
               move.l  d5,d0
               and.l   d7,d0                   ; bitmask
               movea.l D6,a0                   ; 1444 longwords buffer
 ifd MC68020
               movem.w (a0,d0.l*4),D3-D4
 else
               ADD.W   D0,D0
               ADD.W   D0,D0
               movem.w (a0,d0.W),D3-D4
 endif
               lsr.l   d3,d5                   ; drop used bits (mod 64)
               sub.b   d3,d2                   ; sub used bits
               moveq   #15,D1
               cmp.l   D1,D4
 ifd MC68020
               bhi.s   repeatcodelen
               move.b  D4,(A4,A5.L)            ; 320 byte buffer
 else
               bhi.w   repeatcodelen
               move.b  D4,(A4,A5.W)            ; store code length 0 - 15
 endif
               addq.w  #1,A5                   ; symbol counter + 1
               cmpa.l  A3,A5                   ; = maximal symbol count ?
               bcs.s   dynamicloop             ; ------------------------
dynamictables
               MOVEM.W (SP),D3/D7              ; HLIT (0-29), HDIST (0-29)
               ADDQ.L  #1,D7                   ; HDIST (1-30)
               movea.w #257,a0
               add.l   a0,D3                   ; HLIT + 257
               pea     Lengths(pc)             ; Huffman table for lengths
               MOVE.L  A0,-(SP)                ; min 257
               move.l  D3,A0                   ; max 286 literal / lengths
               MOVEA.W #9,A1                   ; initial size = 9 bits
               MOVEQ   #0,D1                   ; offset = 0
               bsr.w   tablegenerator          ; updates D1 for next call
               ADDQ.W  #8,SP
               ADDA.L  D3,A4                   ; 320 bytes buffer + offset
               MOVEA.L A6,A5                   ; generated table1
               MOVE.L  A1,D3
               pea     Distances(pc)           ; Huffman table Distances
               clr.l   -(sp)                   ; min 0
               move.l  D7,A0                   ; max 30 distance codes
               MOVEA.W #6,A1                   ; initial size = 6 bits
               bsr.w   tablegenerator          ; use D1 offset from 1. call
               ADDQ.W  #8,SP
               MOVEM.L (SP)+,D0/D6/A3-A4       ; restore the pointers
               BRA.S   storebitmasks

               CNOP    0,4
usethebigtabs                                  ; ==========================
               LEA     $38+$140(A4),A5         ; bigtab1, 2048 bytes 9-bit
               LEA     $800(A5),A6             ; bigtab2,  128 bytes 5-bit
               MOVEQ   #9,D3                   ; static 9 bits for bigtab1
               MOVEA.W #5,A1                   ; static 5 bits for bigtab2
storebitmasks  LEA     $24(SP),A0
               MOVE.W  D3,(A0)+
               MOVE.W  A1,(A0)+
 ifd MC68020
               MOVE.L  (A4,D3.l*4),(A0)+       ; bitmask filter for table1
               MOVE.L  (A4,A1.l*4),(A0)        ; bitmask filter for table2
 else
               ADD.B   D3,D3
               ADD.B   D3,D3
               move.l  (A4,D3.W),(A0)+
               ADDA.L  A1,A1
               ADDA.L  A1,A1
               move.l  (A4,A1.W),(A0)
 endif
               SUBQ.L  #5,(SP)                 ; set end of input stream
               move.l  D6,D3                   ; end of output
               sub.l   A3,D3                   ; - pointer = bytes to write
readthetables  ;-----------------------------------------------------------
               CMPA.L  (SP),A2                 ; 40 bits left on input ?
               bhi.w   finaldecoding
               moveq   #19,D4                  ; more than 19 bits wanted
               cmp.l   D4,D2
               BHI.S   .enoughbits
.readnextbyte
               MOVEQ   #0,D0
               move.b  (A2)+,d0
               lsl.l   D2,d0
               or.l    d0,D5
               addq.l  #8,D2
               cmp.l   D4,D2
               BLS.S   .readnextbyte
.enoughbits
               move.l  D5,D0
               and.l   $28(SP),D0              ; bitmask for table1
 ifd MC68020
               lea     (A5,D0.L*4),A0          ; bigtab1 or gentab1
 else
               ADD.W   D0,D0
               ADD.W   D0,D0
               lea     (A5,D0.W),A0
 endif
readingtable1  ;============================== ; MOST OFTEN USED LOOP !
               move.l  (A0),D1                 ; read word1 from table1
               move.w  (A0),D0                 ; read byte1 from table1
               lsr.l   D0,D5                   ; drop actual used bits
               sub.b   D0,D2
               move.b  (A0),D4                 ; read byte0 from table1
               beq.s   writeout1byte
               MOVEQ   #16,D0
               AND.B   D4,D0                   ; bit 4 set ?
               bne.s   readthelength
               MOVEQ   #64,D0
               AND.B   D4,D0                   ; bit 6 set ?
               bne.w   doneormainloop
               PEA     readingtable1(PC)       ; return to readingtable1
extratooffset  ;------------------------------
               move.l  D5,D0                   ; copy the bit buffer
 ifd MC68020
               and.l   (A4,D4.l*4),D0          ; mask out the extra bits
               add.w   D0,D1                   ; add extra bits to word1
               lea     (A0,D1.w*4),A0          ; get word1 +extra offset
 else
               ADD.B   D4,D4
               ADD.B   D4,D4
               and.l   (A4,D4.W),D0
               ADD.W   D0,D1
               ADD.W   D1,D1
               ADD.W   D1,D1
               lea     (A0,D1.W),A0
 endif
               RTS     ;====================== ; readingtable1 or table2
writeout1byte
               subq.l  #1,D3
               BMI.S   notenoughspace
               move.b  D1,(A3)+                ; write out literal byte3
               BRA.S   readthetables

readthelength  move.l  D5,D0
               MOVEQ   #$F,D7
               and.l   D7,D4                   ; extract extra bits size
               lsr.l   D4,D5
               sub.b   D4,D2
               move.w  D1,D7                   ; copy length from table1
 ifd MC68020
               and.l   (A4,D4.l*4),d0          ; get extra bits of input
 else
               ADD.B   D4,D4
               ADD.B   D4,D4
               and.l   (A4,D4.W),d0
 endif
               add.l   D0,D7                   ; add this to the length
               moveq   #14,D1                  ; 14 bits wanted
               cmp.l   D1,D2
               BCC.S   .enoughbits
.readnextbyte
               MOVEQ   #0,D0
               move.b  (A2)+,d0
               lsl.l   D2,d0
               or.l    d0,D5
               addq.l  #8,D2
               cmp.l   D1,D2
               BCS.S   .readnextbyte
.enoughbits
               move.l  D5,d0
               and.l   $2C(SP),d0              ; bitmask for table2
 ifd MC68020
               lea     (A6,d0.l*4),a0          ; bigtab2 or gentab2
 else
               ADD.W   D0,D0
               ADD.W   D0,D0
               lea     (A6,d0.w),a0
 endif
readingtable2  ;==============================
               move.l  (A0),D1                 ; read word1 from table2
               move.w  (A0),D0                 ; read byte1 from table2
               lsr.l   D0,D5
               sub.b   D0,D2
               move.b  (A0),D4                 ; read byte0 from table2
               MOVEQ   #16,D0
               AND.B   D4,D0                   ; bit 4 set ?
               bne.s   mainblockcopy
               MOVEQ   #64,D0
               AND.B   D4,D0                   ; bit 6 set ?
notenoughspace bne.w   decodingerror1
               PEA     readingtable2(PC)       ; return to readingtable2
               BRA.S   extratooffset ;========

mainblockcopy  moveq   #$F,D0
               and.l   D0,D4                   ; extract extra bits size
               MOVEA.W D1,A0                   ; copy distance of table2
.readnextbyte
               cmp.l   D4,D2
               bcc.s   .enoughbits
               MOVEQ   #0,D0
               move.b  (A2)+,d0
               lsl.l   D2,d0
               or.l    d0,D5
               addq.l  #8,D2
               BRA.S   .readnextbyte
.enoughbits
               move.l  D5,d0
               lsr.l   D4,D5
               sub.l   D4,D2
 ifd MC68020
               and.l   (A4,D4.l*4),d0          ; get extra bits of input
 else
               ADD.W   D4,D4
               ADD.W   D4,D4
               and.l   (A4,D4.W),d0
 endif
               add.l   A0,D0                   ; add the distance to this
writeoneblock
               movea.l A3,A0                   ; current output position
               suba.l  D0,A0                   ; - distance = source
               sub.l   D7,D3                   ; remaining bytes on output
               BMI.S   notenoughspace
               LSR.L   #1,D7
               BCC.S   trytwobytes
               move.b  (A0)+,(A3)+             ; copy 1 byte if odd count
trytwobytes    LSR.L   #1,D7
               BCS.S   copytwobytes
               BRA.S   tryfourbytes
copyfourbytes
               move.b  (A0)+,(A3)+             ; overlapping copy possible
               move.b  (A0)+,(A3)+
copytwobytes
               move.b  (A0)+,(A3)+
               move.b  (A0)+,(A3)+
tryfourbytes   DBRA    D7,copyfourbytes
               bra.w   readthetables

finaldecoding  ;-------------------------------------------------------
               move.w  $24(SP),D4              ; required table1 bits
               movea.l A5,A1                   ; bigtab1 or gentab1
decodingagain  ;-------------------------------------------------------
               PEA     writeremaining(PC)      ; rts to writeremaining
decodingblock
               cmp.l   D4,D2
               bcc.s   .enoughbits
.readnextbyte
               MOVEQ   #0,D0
               move.b  (A2)+,d0
               lsl.l   d2,d0
               or.l    d0,D5
               addq.l  #8,d2
               cmp.l   D4,D2
               bcs.s   .readnextbyte
.enoughbits
               move.l  D5,d0
 ifd MC68020
               and.l   (A4,D4.l*4),D0          ; bitmask
               lea     (A1,D0.l*4),A0          ; table1 or table2
 else
               ADD.B   D4,D4
               ADD.B   D4,D4
               and.l   (A4,D4.W),d0
               ADD.W   D0,D0
               ADD.W   D0,D0
               lea     (A1,D0.W),a0
 endif
               move.w  (a0),d0                 ; used number of bits
               lsr.l   d0,D5
               sub.b   d0,d2
               move.l  (a0),d1                 ; get word1 = data
 ifd MC68020
               lea     (a0,d1.w*4),a1          ; skip word1 entries
 else
               MOVE.W  D1,D0
               ADD.W   D0,D0
               ADD.W   D0,D0
               lea     (A0,D0.W),A1
 endif
               move.b  (a0),D4                 ; flags and extra bits
               RTS
writeremaining
               beq.w   writeout1byte           ; write a literal byte
               MOVEQ   #16,D0
               AND.B   D4,D0                   ; bit 4 set ?
               bne.s   writing1block
               MOVEQ   #64,D0
               AND.B   D4,D0                   ; bit 6 set ?
               beq.s   decodingagain
doneormainloop
               MOVEQ   #32,D0
               AND.B   D4,D0                   ; bit 5 set ?
               beq.s   decodingerror1
               move.l  $30(SP),D1              ; decoding done flag
               beq.s   decodingdone
               moveq   #8,d0
               cmp.l   d0,d2                   ; less than 8 bits ?
               bcs.s   lessthan1byte
               subq.l  #8,d2
               subq.w  #1,A2                   ; go 1 byte backwards
lessthan1byte
               ADDQ.L  #5,(SP)                 ; reset end of input
               bra.w   mainloop

writing1block  ; ----------------------------------------------------
               moveq   #7,D0
               and.l   D0,D4                   ; mask out extra bits
               cmp.l   D4,D2                   ; maximal 5 extra bits
               bcc.s   .enoughbits
               move.b  (A2)+,d0
               lsl.l   d2,d0
               or.l    d0,D5
               addq.l  #8,d2
.enoughbits
               move.l  D5,D7
               lsr.l   D4,D5
               sub.l   D4,D2
 ifd MC68020
               and.l   (A4,D4.l*4),D7          ; length extra bits
 else
               ADD.B   D4,D4
               ADD.B   D4,D4
               and.l   (A4,D4.W),D7
 endif
               ADD.W   D1,D7                   ; the new block length
               move.w  $26(SP),D4              ; required table2 bits
               movea.l A6,A1                   ; bigtab2 or gentab2
moreblockdata                                  ; --------------------
 ifd MC68020
               BSR.S   decodingblock
 else
               BSR.W   decodingblock
 endif
               MOVEQ   #16,D0
               AND.B   D4,D0                   ; bit 4 set ?
               bne.W   mainblockcopy
               MOVEQ   #64,D0
               AND.B   D4,D0                   ; bit 6 set ?
               beq.s   moreblockdata
               bra.s   decodingerror1

decodingerror3 ;------------------------------------------------------
               LEA     $114(SP),SP             ; drop stack, RTS + 8
decodingerror2
               LEA     $10(SP),SP              ; drop the pointers
decodingerror1
               MOVEQ   #-1,D1
decodingdone   movem.l (SP)+,d2-d5/d7/a4-a6

quitinflate    SUBQ.B  #1,$F1(A5)              ; release the buffers
               LEA     $18(SP),SP
               movem.l (SP)+,D2/D6/A2-A3/A6
               move.l  D1,D0                   ; return error condition
exitinflate    RTS

tablegenerator ;------------------------------------------------------
               MOVEQ   #16-1,D0
clearcounters  CLR.L   -(SP)                   ; $C8-$107  16 counters
               DBRA    D0,clearcounters
               LEA     -$94(SP),SP
               movem.l d1-d7/a1-a6,-(sp)       ; D1 = (SP) gentable offset
               move.l  A4,D3                   ; 320 bytes buffer
               LEA     $C8(SP),A5
               MOVEQ   #0,D0
               move.l  A0,D1                   ; 19, 257-286 or 1-30 codes
               MOVE.L  A0,D7
               LSR.L   #1,D1
               BCS.S   .count1symbol
               BRA.S   .checkcounted
 ifd MC68020
.next2symbols
               move.b  (A4)+,d0                ; 320 bytes buffer (+ offset)
               addq.l  #1,(A5,d0.l*4)
.count1symbol
               move.b  (A4)+,d0
               addq.l  #1,(A5,d0.l*4)          ; counting the code lengths
.checkcounted
               DBRA    d1,.next2symbols
               CMP.L   (A5)+,A0                ; are all codes zero length ?
               beq.s   decodingerror3          ; it has never happened yet
               moveq   #16-2,d1
               MOVEA.L A5,A4                   ; start with second counter
getfirstcount
               tst.l   (A4)+
               dbne.s  d1,getfirstcount        ; find the minimum length
 else
.next2symbols
               move.b  (A4)+,d0
               ADD.B   D0,D0
               addq.w  #1,(A5,d0.W)
.count1symbol
               move.b  (A4)+,d0
               ADD.B   D0,D0
               addq.w  #1,(A5,d0.W)
.checkcounted
               DBRA    d1,.next2symbols
               CMP.W   (A5)+,A0
               beq.s   decodingerror3
               moveq   #16-2,d1
               MOVEA.L A5,A4
getfirstcount
               tst.w   (A4)+
               dbne.s  d1,getfirstcount
 endif
               moveq   #15,d2
               sub.l   d1,d2                   ; 1 - 15 bits are minimum
               cmp.l   A1,D2                   ; > initial table bits ?
               bls.b   .notmorebits
               movea.l D2,A1                   ; make the table larger
.notmorebits
               moveq   #16-1,d5
 ifd MC68020
               lea     60(A5),a0               ; go behind the last counter
findlastcount
               tst.l   -(a0)
 else
               lea     30(A5),a0
findlastcount
               tst.w   -(a0)
 endif
               dbne    d5,findlastcount        ; find the maximum length
               cmp.l   A1,D5                   ; < initial table bits ?
               bcc.b   .notlessbits
               movea.l D5,A1                   ; make the table smaller
.notlessbits
               move.l  A1,$1C(SP)              ; return actual table bits
               MOVE.L  A1,D0
               movem.l D0/D2/D5,$40(SP)        ; bits, min & max counter #
               moveq   #1,d1
               lsl.l   d2,d1
               move.l  d5,d0
               sub.l   d2,d0
               BLE.S   storemaxcount
               SUBQ.L  #1,D0
 ifd MC68020
               SUBQ.W  #4,A4                   ; to minimum length counter
adjustmaximum
               sub.l   (A4)+,D1
               add.l   d1,d1
               DBCS    D0,adjustmaximum
               BCS.W   decodingerror3
storemaxcount
               MOVE.L  (A0),D0                 ; old maximum length count
               MOVE.L  D1,(A0)                 ; new maximum length count

 else
               SUBQ.W  #2,A4
adjustmaximum
               sub.w   (A4)+,D1
               add.w   d1,d1
               DBCS    D0,adjustmaximum
               BCS.W   decodingerror3
storemaxcount
               MOVE.W  (A0),D0
               MOVE.W  D1,(A0)
 endif
               sub.l   d0,d1                   ; new-old max length count
               bmi.w   decodingerror3
               move.l  d1,$38(SP)              ; store max length diff
               MOVEQ   #0,D0
               MOVEA.L A5,A0                   ; the second counter
 ifd MC68020
               SUBQ.W  #4,A5                   ; the first counter again
               lea     4+$4C(SP),a2            ; value table for lengths
               move.l  d0,(A2)+
 else
               SUBQ.W  #2,A5
               lea     2+$4C(SP),a2
               move.w  d0,(A2)+
 endif
               subq.l  #1,d5                   ; max length counter# - 1
               beq.b   offsetsstored
storeanoffset
 ifd MC68020
               add.l   (a0)+,D0
               move.l  D0,(a2)+
 else
               add.w   (a0)+,D0
               move.w  D0,(a2)+
 endif
               DBRA    D5,storeanoffset
               MOVEQ   #0,D5
offsetsstored
               MOVEQ   #0,D2
               movea.l D3,A1                   ; 320 bytes buffer
               lea     $4C(SP),a2              ; value table for lengths
               MOVEA.L D6,A0                   ; 1444 longwords buffer
               LEA     $1690(A0),A4            ;  320 words buffer
               LSR.L   #1,D7                   ; 19, 257-286 or 1-30 codes
               BCS.S   nextbitlength
               SUBQ.L  #1,D7
orderbylength
               move.b  (A1)+,d2                ; bit length 0 - 15
               beq.b   bitlengthzero
 ifd MC68020
               LEA     (A2,D2.L*4),A0
               MOVE.L  (A0),D1
               addq.l  #1,(A0)
               move.w  d5,(A4,d1.l*2)
 else
               ADD.W   D2,D2
               LEA     (A2,D2.W),A0
               MOVE.W  (A0),D1
               addq.w  #1,(A0)
               ADD.W   D1,D1
               move.w  d5,(A4,d1.W)
 endif
bitlengthzero
               addq.l  #1,d5
nextbitlength
               move.b  (A1)+,d2                ; bit length 0 - 15
               beq.b   zerobitlength
 ifd MC68020
               LEA     (A2,D2.L*4),A0
               MOVE.L  (A0),D1
               addq.l  #1,(A0)
               move.w  d5,(A4,d1.l*2)
 else
               ADD.W   D2,D2
               LEA     (A2,D2.W),A0
               MOVE.W  (A0),D1
               addq.w  #1,(A0)
               ADD.W   D1,D1
               move.w  d5,(A4,d1.W)
 endif
zerobitlength
               addq.l  #1,d5
               DBRA    D7,orderbylength
               move.l  $48(SP),d7              ; maximum length counter#
 ifd MC68020
               move.l  (a2,d7.l*4),D0
               clr.l   (A2)                    ; value table for lengths
               LEA     (a4,d0.l*2),A0          ; 320 words buffer offset
 else
               ADD.W   D7,D7
               move.w  (a2,d7.W),D0
               clr.w   (A2)
               ADD.W   D0,D0
               LEA     (a4,d0.W),A0
 endif
               MOVE.L  A0,$3C(SP)              ; 320 words final offset
               MOVEQ   #0,D5
               CLR.L   $8C(SP)
               MOVE.L  $40(SP),D6              ; get actual table bits
               NEG.L   D6
               MOVEA.W #-2,A6
               bra.w   checkcounters           ; D0 = min length counter#

donextcounter  ;--------------------------------------------------------
 ifd MC68020
               LEA     (A5,D0.L*4),A0          ; the 16 counters
               move.l  (A0)+,D7                ; the active count
 else
               ADD.L   D0,D0
               LEA     (A5,D0.W),A0
               move.w  (A0)+,D7
 endif
               beq.w   counteriszero           ; never zero on first run
               move.l  A0,$34(SP)              ; * following counter
foreverycount                                  ; -----------------------
               movem.l $40(SP),d1-d2           ; bits, min length counter
               movea.l d1,a1                   ; get actual table bits
               adda.l  d6,a1
               cmpa.l  d2,a1
               bge.w   testtheoffset           ; branch is used by 88 %
getnextoffset                                  ; -----------------------
               addq.w  #2,A6
               MOVEA.L $48(SP),A3              ; maximum length counter#
               move.l  a1,d6
               suba.l  d6,a3
               cmpa.l  d1,a3
               bls.b   islowerorsame
               movea.l d1,a3
islowerorsame
               sub.l   d6,d2
               moveq   #1,d1
               lsl.l   d2,d1
               cmp.l   D7,D1                   ; less or same as count ?
               bls.b   saveblocksize
               cmpa.l  d2,a3
               bls.b   saveblocksize
               MOVEA.L $34(SP),A0              ; * following counter
               sub.l   D7,d1                   ; subtract active count
findblocksize
               addq.l  #1,d2
               cmpa.l  d2,a3
               bls.b   calcblocksize
               add.l   d1,d1
 ifd MC68020
               sub.l   (a0)+,d1
 else
               sub.w   (a0)+,d1
 endif
               bhi.b   findblocksize
calcblocksize
               moveq   #1,d1
               lsl.l   d2,d1
saveblocksize
               movea.l d1,a3                   ; save new table block size
               movea.l $14(SP),a2              ; 1444 longwords buffer
               move.l  (SP),D0                 ; previous table entry or 0
               ADD.L   D1,(SP)                 ; new current table entry
               add.l   D0,D1
               cmpi.w  #1444,D1                ; table entry > 1444 ?
               bhi.w   decodingerror3
 ifd MC68020
               lea     (a2,d0.l*4),a2          ; 1444 longwords buf offset
               move.l  a2,$8C(SP,A6.l*2)       ; store the offset position
 else
               ADD.W   D0,D0
               ADD.W   D0,D0
               lea     (a2,D0.W),a2
               MOVEQ   #$8C/2,D0
               ADD.L   A6,D0
               ADD.W   D0,D0
               move.l  a2,(SP,D0.W)
 endif
               move.l  $40(SP),d1              ; get actual table bits
               move.l  A6,D0
               bne.b   buildprevious
               MOVE.L  A2,$30(SP)              ; save start of new table
               bra.b   atfirstoffset
buildprevious
 ifd MC68020
               move.l  d5,$4C(SP,A6.l*2)       ; value table for lengths
 else
               move.w  d5,$4C(SP,A6.W)
 endif
               MOVE.B  D2,D3                   ; flags and extra bits
               LSL.W   #8,D3
               MOVE.B  D1,D3                   ; required bits
               move.l  a1,d4
               sub.l   d1,d4
               move.l  d5,d2
               lsr.l   d4,d2
 ifd MC68020
               movea.l $88(SP,A6.l*2),a0
 else
               MOVEQ   #$88/2,D0
               ADD.L   A6,D0
               ADD.W   D0,D0
               movea.l (SP,d0.W),a0
 endif
               move.l  a2,d4                   ; 1444 longwords offset1
               sub.l   a0,d4
               asr.l   #2,d4
               sub.l   d2,d4                   ; data byte, len or dist
 ifd MC68020
               movem.w D3-D4,(a0,d2.l*4)
 else
               ADD.W   D2,D2
               ADD.W   D2,D2
               movem.w D3-D4,(a0,d2.W)
 endif
atfirstoffset
               adda.l  d1,a1
               MOVE.L  $44(SP),D2              ; minimum length counter#
               cmpa.l  D2,a1
               blt.w   getnextoffset           ; -----------------------
testtheoffset
               cmpa.l  $3C(SP),a4              ; *buffer < final offset ?
               bcc.b   atfinaloffset
               MOVEQ   #0,D1
               move.w  (a4)+,d1                ; 320 word buffer ++
               move.l  d1,d4
               sub.l   $10C(SP),d1             ; -19, -257 or -0
               bcc.b   readhufftable
               cmpi.w  #256,d4                 ; < 256 literal data byte
               scc     D3
               andi.b  #$60,D3                 ; D3 = %0110 0000 or 0=data
               bra.b   skiphufftable
atfinaloffset
               moveq   #$3f,D3                 ; code never executed !
               not.b   D3                      ; D3 = %1100 0000
               bra.b   skiphufftable
readhufftable
               movea.l $110(SP),a0             ; hufftab lengths or dists
 ifd MC68020
               movem.w (A0,d1.l*4),d3-d4       ; %0101 xxxx or %1100 0000
 else
               ADD.W   D1,D1
               ADD.W   D1,D1
               movem.w (a0,d1.W),d3-d4         ; flags + extra bits; data
 endif
skiphufftable
               move.l  $44(SP),d0              ; minimum length counter#
               move.l  d5,d2
               lsr.l   d6,d2
               cmpa.l  d2,a3                   ; > table block size ?
               bls.b   blockcomplete
               movea.l d0,a1
               sub.l   d6,d0
               LSL.W   #8,D3                   ; %0101 xxxx extra bits
               MOVE.B  D0,D3                   ; required record bits
               moveq   #1,d1
               lsl.l   d0,d1
 ifd MC68020
               lea     (a2,d2.l*4),a0          ; 1444 longwords offset2
 else
               MOVE.W  D2,D0
               ADD.W   D0,D0
               ADD.W   D0,D0
               lea     (a2,D0.W),a0
 endif
               move.l  d1,d0
               lsl.l   #2,d0
               SUB.L   A3,D2
savenextentry
               movem.w d3-d4,(a0)              ; generate a table entry
               adda.l  d0,a0
               add.l   d1,d2
               BMI.S   savenextentry
               move.l  a1,d0
blockcomplete
               moveq   #1,d2
               lsl.l   d0,d2
getnewbitsize
               lsr.l   #1,d2
               move.l  d5,d0
               eor.l   d2,d5
               and.l   d2,d0
               bne.b   getnewbitsize
 ifd MC68020
               lea     4+$4C(SP,A6.l*2),a0     ; value table for lengths
 else
               LEA     2+$4C(SP,A6.W),a0
 endif
               move.l  d5,d0
               moveq   #1,d1
               lsl.l   d6,d1
               subq.l  #1,d1
               and.l   d1,d0
               move.l  $40(SP),d2              ; get actual table bits
               bra.b   comparelength
reducebitsize
               subq.w  #2,A6
               sub.l   d2,d6                   ; subtract number of bits
               lsr.l   d2,d0                   ; drop number of bits
comparelength
 ifd MC68020
               cmp.l   -(A0),d0
 else
               cmp.w   -(A0),d0
 endif
               bne.b   reducebitsize
               subq.l  #1,D7                   ; reduce the active count
               bne.w   foreverycount           ; -----------------------
counteriszero
               addq.l  #1,$44(SP)              ; min length counter# ++
checkcounters
               LEA     $44(SP),A0
               move.l  (A0)+,d0                ; min length counter#
               cmp.l   (A0),d0                 ; <= max length counter# ?
               ble.w   donextcounter           ; -----------------------
               tst.l   $38(SP)
               beq.b   tablecomplete
               subq.l  #1,(A0)                 ; max length counter# --
               bne.w   decodingerror3
tablecomplete
               movem.l (sp)+,d1-d7/a1-a6
               LEA     $D4(SP),SP
               RTS

table19:
               dc.b    $10
               dc.b    $11
               dc.b    $12
               dc.b    $00
               dc.b    $08
               dc.b    $07
               dc.b    $09
               dc.b    $06
               dc.b    $0a
               dc.b    $05
               dc.b    $0b
               dc.b    $04
               dc.b    $0c
               dc.b    $03
               dc.b    $0d
               dc.b    $02
               dc.b    $0e
               dc.b    $01
               dc.b    $0f

               CNOP    0,4
Lengths:
               dc.w    $50 + 0   , 3
               dc.w    $50 + 0   , 4
               dc.w    $50 + 0   , 5
               dc.w    $50 + 0   , 6
               dc.w    $50 + 0   , 7
               dc.w    $50 + 0   , 8
               dc.w    $50 + 0   , 9
               dc.w    $50 + 0   , $a
               dc.w    $50 + 1   , $b
               dc.w    $50 + 1   , $d
               dc.w    $50 + 1   , $f
               dc.w    $50 + 1   , $11
               dc.w    $50 + 2   , $13
               dc.w    $50 + 2   , $17
               dc.w    $50 + 2   , $1b
               dc.w    $50 + 2   , $1f
               dc.w    $50 + 3   , $23
               dc.w    $50 + 3   , $2b
               dc.w    $50 + 3   , $33
               dc.w    $50 + 3   , $3b
               dc.w    $50 + 4   , $43
               dc.w    $50 + 4   , $53
               dc.w    $50 + 4   , $63
               dc.w    $50 + 4   , $73
               dc.w    $50 + 5   , $83
               dc.w    $50 + 5   , $a3
               dc.w    $50 + 5   , $c3
               dc.w    $50 + 5   , $e3
               dc.w    $50 + 0   , $102
               dc.w    $50 + $70 , 0
               dc.w    $50 + $70 , 0
Distances:
               dc.w    $50 + 0   , 1
               dc.w    $50 + 0   , 2
               dc.w    $50 + 0   , 3
               dc.w    $50 + 0   , 4
               dc.w    $50 + 1   , 5
               dc.w    $50 + 1   , 7
               dc.w    $50 + 2   , 9
               dc.w    $50 + 2   , $d
               dc.w    $50 + 3   , $11
               dc.w    $50 + 3   , $19
               dc.w    $50 + 4   , $21
               dc.w    $50 + 4   , $31
               dc.w    $50 + 5   , $41
               dc.w    $50 + 5   , $61
               dc.w    $50 + 6   , $81
               dc.w    $50 + 6   , $c1
               dc.w    $50 + 7   , $101
               dc.w    $50 + 7   , $181
               dc.w    $50 + 8   , $201
               dc.w    $50 + 8   , $301
               dc.w    $50 + 9   , $401
               dc.w    $50 + 9   , $601
               dc.w    $50 + $a  , $801
               dc.w    $50 + $a  , $c01
               dc.w    $50 + $b  , $1001
               dc.w    $50 + $b  , $1801
               dc.w    $50 + $c  , $2001
               dc.w    $50 + $c  , $3001
               dc.w    $50 + $d  , $4001
               dc.w    $50 + $d  , $6001

EndCode

;##################################################################
;
; icon.library structure
;
;   $00   $22 struct library
;   $22    $4 * segmentlist
;   $26    $4 * execbase
;   $2A    $4 * dosbase
;   $2E    $4 * utilbase
;   $32    $4 * gfxbase
;   $36    $4 * intuibase
;   $3A    $4 * zlibbase
;   $3E   $64 struct RastPort for MakePlanarMask with FloodFill
;   $A2    $C list of v44 DiskObject nodes (icon offset $62)
;   $AE    $4 current directory lock
;   $B2    $2 delta width  of GlobalEmbossRectangle
;   $B4    $2 delta height of GlobalEmbossRectangle
;   $B6    $2 1 GlobalEmbossRectangle MinX
;   $B8    $2 1 GlobalEmbossRectangle MinY
;   $BA    $2 2 SHINEPEN
;   $BC    $2 1 SHADOWPEN
;   $BE    $2 0 BACKGROUNDPEN
;   $C0    $4 3 AllocAttributes MEMF_PUBLIC | MEMF_CHIP
;   $C4    $2 1 GlobalFrameless TRUE
;   $C6    $2 1 GlobalNewIconsSupport  TRUE
;   $C8    $2 1 GlobalColorIconSupport TRUE
;   $CA    $2 $19 GlobalMaxNameLength = 25
;   $CC    $C systemcolors 4 RGB triplets
;   $D8    $4 * GlobalIdentifyHook
;   $DC    $4 * memblock for GfxPatch
;   $E0    $4 * CRC table 256 longwords
;   $E4    $4 free, but used for the Aros screen on RTG
;   $E8    $1 flag for planar frames only
;   $E9    $1 flag for original CGX4 Phase5 (once was for NoDelayedImage2)
;   $EA    $1 flag for SetGlobalMaxNameLength was called
;   $EB    $1 flag for DOnoColorMapping
;   $EC    $1 flag for DOpus5 no disk.info found
;   $ED    $1 flag for aros.library resident structure
;   $EE    $1 flag for MoreLibSpace
;   $EF    $1 ghosting mask byte for 50 % transparency
;   $F0    $1 no scaling=0, 150% upscaling=+1, 66% downscaling=-1
;   $F1    $1 buffer protection bit 0=zlib, 1=V44, 2=hook 3=z-info, 4=GZip, 5=WB47, 7=reserved
;   $F2    $1 flag fake planar icon size for AfA_OS in OS4 icons on/off
;   $F3    $1 flag kill planar images in ColorIcons = -1, good=0, keep=1, three=3
;   $F4   $20 free, but used for z-image buffer on RTG
;  $114    $4 * DefIcons IdentifyHook used for the IdentifyBuffer tag
;  $118    $4 free, but used for TrickyDragn on RTG
 
;  $11C    $4 * dtbase
;  $120    $4 * cgxbase
;  $124    $4 0 GlobalPrecision
;  $128    $4 * GlobalScreen
;  $12C    $4 * ScreenDrawInfo

;  $130   $10 16 bytes free

;  $140   $14 free, but used by FastWB on RTG
;  $154   $14 Dot image structure, image data at $15E
;  $168  $400 cache for the screens color map
;  $568    $2 NShared, the number of shared screen colors
;  $56A  $3FE color distance table, TabBase = $768
;  $968    $4 *ColorMap structure used by the cache
;  $96C    $4 DOpus5 program main task 
;  $970    $4 * zlib buffer
;  $974    $4 Workbench task
;  $978    $1 other GUI used = -1, WB = +1
;  $979    $1 byte for outline=-1, shadow=1, normal text=0
;  $97A    $1 byte for RTG mode, unknown=0 WB RTG=-1 DOpus5 RTG=1
;  $97B    $1 flag for ghosting deficons -1=off
;  $97C    $1 converting truecolor icons: ask=0, always convert=1
;  $97D    $1 flag for grayscale colormapping
;  $97E    $1 flag for Workbench 3.0/3.1
;  $97F    $1 turbo colormap newpen dump for normal mode
;  $980  $200 turbo colormap cache for 512 9-bit colors
;  $B80 $1690 1444 longwords buffer for zlib at 2944
; $2210  $280  320 words buffer for zlib
;
;
; DiskObject:
;
;  $4e     78  sizeof(DiskObject)
; =================================
;  $00      0     2  do_Magic=$E310
;  $02      2     2  do_Version
;  -------------(44)--(do_Gadget)--
;  $04 $00  4  0  4   NextGadget
;  $08 $04  8  4  2   LeftEdge
;  $0A $06 10  6  2   TopEdge
;  $0C $08 12  8  2   Width
;  $0E $0a 14 10  2   Height
;  $10 $0c 16 12  2   Flags
;  $12 $0e 18 14  2   Activation
;  $14 $10 20 16  2   GadgetType
;  $16 $12 22 18  4   * GadgetRender
;  $1A $16 26 22  4   * SelectRender
;  $1E $1a 30 26  4   GadgetText    for FileBlockNumber of TrueColor icons
;  $22 $1e 34 30  4   MutualExclude DOpus5 icon position
;  $26 $22 38 34  4   SpecialInfo   pointer in GetIcon() to V44 DiskObject
;  $2A $26 42 38  2   GadgetID
;  $2C $28 44 40  3+1 UserData Rev# 1 = v36+ has dd_Flags and dd_ViewModes
;  ---($2c)--(44)------------------
;  $30     48     1  do_Type
;  $31     49     1  do_PAD_BYTE
;  $32     50     4  do_DefaultTool
;  $36     54     4  do_ToolTypes
;  $3a     58     4  do_CurrentX
;  $3e     62     4  do_CurrentY
;  $42     66     4  do_DrawerData
;  $46     70     4  do_ToolWindow  FastWB: the window an icon belongs to
;  $4a     74     4  do_StackSize
; --------------(16)-(FreeList)---- V44 DiskObject extension starts here
;  $4e $00 78  0  2  fl_NumFree
;  $50 $02 80  2 14  fl_MemListNode
; ----($10)--(16)------------------
;  $5e     94     4  selfpointer privat
;  $62     98     8  struct node for v44 icons
;  $6a    106     4  * NewIcon image or decoding buffer for 1. TC image
;  $6e    110     4  * GadgetRender
;  $72    114     4  * SelectRender
;  $76    118     4  * PalMap1 v44
;  $7a    122     4  * PalMap2 v44
;  $7e    126     4  * Mask1 Gadget for transparent or backfill color
;  $82    130     4  * Mask2 Select for transparent or backfill color
;  $86    134     4  * Screen
;  $8a    138     1  NoFrame=0 UseNI=1 DefIcon=2 GlobalScr=3 NoImage2=4 SkipMask2=5 TrueColor=6 noPalMaps=7
;  $8b    139     1  do_Flags & 3
;  $8c    140     1  AspectRatio not supported, set to 0x11
;  $8d    141     1  icon scaling state, down=-1, none=0, up=1
;  $8e    142  size with extensions
;
;  GFLG_GADGHCOMP  EQU 0 Complement the select box
;  GFLG_GADGHBOX   EQU 1 Draw a box around the image
;  GFLG_GADGHIMAGE EQU 2 Blast in this alternate image
;  GFLG_GADGHNONE  EQU 3 don't highlight
;  GFLG_GADGIMAGE  EQU 4 Gadget and Select point to Image
;
;
;  0x69634F6E  PNG "icOn" chunk extensions
;
;  0x80001001  ICONX or NO_CURRENT_POSITION
;  0x80001002  ICONY or NO_CURRENT_POSITION
;  0x80001003  DRAWERX
;  0x80001004  DRAWERY
;  0x80001005  DRAWERWIDTH
;  0x80001006  DRAWERHEIGHT
;  0x80001007  DRAWERFLAGS
;  0x80001008  tool window string (reserved for future use)
;  0x80001009  STACKSIZE
;  0x8000100a  DEFAULTTOOL string
;  0x8000100b  TOOLTYPE string
;  0x8000100c  VIEWMODES
;  0x8000100D  drawer view X offset (int32)
;  0x8000100E  drawer view Y offset (int32)
;  0x8000100F  TYPE (1=DISK,2=DRAWER,3=TOOL,4=PROJECT,5=GARBAGE,6=DEV,7=KICK,8=APP)
;  0x80001010  force frameless flag = 1, not defined or 0 = global frame settings
;  0x80001011  drawer flags         (uint32) ??
;  0x80001012  drawer view modes    (uint32) ??
;
;
; IMAG chunk header:
;
;  $00 byte transparent color number
;  $01 byte number of icon colors - 1
;  $02 byte flags bit0=transparency? bit1=sharedcolormap?
;  $03 byte BOOL compressed image ?
;  $04 byte BOOL compressed colormap ?
;  $05 byte depth
;  $06 word compressed image size - 1
;  $08 word compressed colormap size - 1
;
;
; Image:
;
;  $14     20  sizeof(Image)
; ================================
;  $00      0     2  LeftEdge
;  $02      2     2  TopEdge
;  $04      4     2  Width
;  $06      6     2  Height
;  $08      8     2  Depth
;  $0a     10     4  * ImageData
;  $0e     14     1  PlanePick
;  $0f     15     1  PlaneOnOff
;  $10     16     4  * NextImage
;
;
; DrawerData:
;
;  $3e     62  sizeof(DrawerData)
;  $30     48  sizeof(NewWindow)
; ================================
;  $00      0     2   LeftEdge
;  $02      2     2   TopEdge
;  $04      4     2   Width
;  $06      6     2   Height
;  $08      8     1   DetailPen
;  $09      9     1   BlockPen
;  $0a     10     4   IDCMPFlags
;  $0e     14     4   Flags
;  $12     18     4   FirstGadget
;  $16     22     4   CheckMark
;  $1a     26     4   Title
;  $1e     30     4   Screen
;  $22     34     4   BitMap
;  $26     38     2   MinWidth
;  $28     40     2   MinHeight
;  $2a     42     2   MaxWidth
;  $2c     44     2   MaxHeight
;  $2e     46     2   Type
;  ------------------------------
;  $30     48     4  dd_CurrentX
;  $34     52     4  dd_CurrentY
;  $38     56     4  dd_Flags     if gg_UserData=1
;  $3c     60     2  dd_ViewModes if gg_UserData=1
;
;
; FreeList:
;
;  $10     16  sizeof(FreeList)
; ===============================
;  $00      0     2  fl_NumFree
;  $02      2    14  fl_MemListNode
;
;
; PalMap:
;
; $120+   288+ sizeof(PalMap)
; =================================================
;  $00      0     2   width
;  $02      2     2   height
;  $04      4     4   * image bytes (->offset $120)
;  $08      8   256   colormap CLUT (->screen pens)
; $108    264     4   * colormap RGB bytes (below)
; $10c    268     1   transparency flag
; $10d    269     1   transparent color reg number
; $10e    270     2   number of icon colors
; $110    272     4   0 or size of ARGB zlib-image
; $114    276     4   0 or * compressed ARGB image
; $118    280     4   0 or * TCbuffer and freelist
; $11c    284     2   number of icon colors mapped
; $11e    286     1   dirty TCbuf1=1, is TCbuf2=-1
; $11f    287     1   dump byte in color reduction
; -------------------------------------------------
; $120    288   xxx   image bytes (->colormap CLUT)
; $???    ???   xxx   colormap RGB bytes (24 bit)
;
;
; BitMap:
;
;  $28     40  sizeof(BitMap)
; ===============================
;  $00      0     2   BytesPerRow
;  $02      2     2   Rows
;  $04      4     1   Flags
;  $05      5     1   Depth
;  $06      6     2   pad
;  $08      8    4-32 Planes[0-7]
;
;
; RastPort:
;
;  $64    100  sizeof(RastPort)
; ===============================
;  $00      0     4   Layer
;  $04      4     4   BitMap
;  $08      8     4   AreaPtrn
;  $0c     12     4   TmpRas
;  $10     16     4   AreaInfo
;  $14     20     4   GelsInfo
;  $18     24     1   Mask
;  $19     25     1   FgPen
;  $1a     26     1   BgPen
;  $1b     27     1   AOlPen
;  $1c     28     1   DrawMode
;  $1d     29     1   AreaPtSz
;  $1e     30     1   linpatcnt
;  $1f     31     1   dummy
;  $20     32     2   Flags
;  $22     34     2   LinePtrn
;  $24     36     2   cp_x
;  $26     38     2   cp_y
;  $28     40     1   minterms[0]
;  $30     48     2   PenWidth
;  $32     50     2   PenHeight
;  $34     52     4   Font
;  $38     56     1   AlgoStyle
;  $39     57     1   TxFlags
;  $3a     58     2   TxHeight
;  $3c     60     2   TxWidth
;  $3e     62     2   TxBaseline
;  $40     64     2   TxSpacing
;  $42     66     4   RP_User
;  $46     70     4   longreserved[0]
;  $4e     78     2   wordreserved[0]
;  $5c     92     1   reserved[0]
;
;
; FileInfoBlock:
;
; $104    260  sizeof(FileInfoBlock)
; =================================
;  $00      0     4   fib_DiskKey
;  $04      4     4   fib_DirEntryType
;  $08      8     1   fib_FileName[0]
;  $74    116     4   fib_Protection
;  $78    120     4   fib_EntryType
;  $7c    124     4   fib_Size
;  $80    128     4   fib_NumBlocks
;  $84    132    12   fib_Date
;  $90    144     1   fib_Comment[0]
;  $e0    224     2   fib_OwnerUID
;  $e2    226     2   fib_OwnerGID
;  $e4    228     1   fib_Reserved[0]
;
