/*
 * frmPatternEditor.java
 *
 * 
 */

package symreader;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import symreader.SymReaderView.UIManager;
import symreader.Song;



/**
 *
 * @author  menpa
 */
public class frmPatternEditor extends javax.swing.JFrame {
    
    /** Creates new form frmPatternEditor */
    public frmPatternEditor() {
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        PEDInfoLabel = new javax.swing.JLabel();
        jToolBar1 = new javax.swing.JToolBar();
        PEDRecording = new javax.swing.JCheckBox();
        jLabel1 = new javax.swing.JLabel();
        PEDPatternNrjSpinner = new javax.swing.JSpinner();
        jLabel2 = new javax.swing.JLabel();
        PEDInstrNrSpinner = new javax.swing.JSpinner();
        jLabel3 = new javax.swing.JLabel();
        PEDKbdTunejSpinner = new javax.swing.JSpinner();
        jLabel4 = new javax.swing.JLabel();
        PEDEditVol = new javax.swing.JSpinner();
        jLabel5 = new javax.swing.JLabel();
        PEDEditStepLen = new javax.swing.JSpinner();
        PEDPane = new javax.swing.JScrollPane();
        PEDContent = new javax.swing.JTextField();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        org.jdesktop.application.ResourceMap resourceMap = org.jdesktop.application.Application.getInstance(symreader.SymReaderApp.class).getContext().getResourceMap(frmPatternEditor.class);
        setTitle(resourceMap.getString("Pattern Designer.title")); // NOI18N
        setName("Pattern Designer"); // NOI18N
        addWindowFocusListener(new java.awt.event.WindowFocusListener() {
            public void windowGainedFocus(java.awt.event.WindowEvent evt) {
                formWindowGainedFocus(evt);
            }
            public void windowLostFocus(java.awt.event.WindowEvent evt) {
            }
        });
        addComponentListener(new java.awt.event.ComponentAdapter() {
            public void componentResized(java.awt.event.ComponentEvent evt) {
                formComponentResized(evt);
            }
            public void componentShown(java.awt.event.ComponentEvent evt) {
                formComponentShown(evt);
            }
        });
        addHierarchyBoundsListener(new java.awt.event.HierarchyBoundsListener() {
            public void ancestorMoved(java.awt.event.HierarchyEvent evt) {
            }
            public void ancestorResized(java.awt.event.HierarchyEvent evt) {
                formAncestorResized(evt);
            }
        });
        addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                formFocusGained(evt);
            }
        });
        addWindowStateListener(new java.awt.event.WindowStateListener() {
            public void windowStateChanged(java.awt.event.WindowEvent evt) {
                formWindowStateChanged(evt);
            }
        });
        addHierarchyListener(new java.awt.event.HierarchyListener() {
            public void hierarchyChanged(java.awt.event.HierarchyEvent evt) {
                formHierarchyChanged(evt);
            }
        });

        PEDInfoLabel.setText(resourceMap.getString("PEDInfoLabel.text")); // NOI18N
        PEDInfoLabel.setName("PEDInfoLabel"); // NOI18N

        jToolBar1.setFloatable(false);
        jToolBar1.setRollover(true);
        jToolBar1.setName("jToolBar1"); // NOI18N

        PEDRecording.setText(resourceMap.getString("PEDRecording.text")); // NOI18N
        PEDRecording.setBorder(new javax.swing.border.SoftBevelBorder(javax.swing.border.BevelBorder.RAISED));
        PEDRecording.setBorderPainted(true);
        PEDRecording.setFocusable(false);
        PEDRecording.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        PEDRecording.setName("PEDRecording"); // NOI18N
        PEDRecording.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jToolBar1.add(PEDRecording);

        jLabel1.setLabelFor(PEDPatternNrjSpinner);
        jLabel1.setText(resourceMap.getString("jLabel1.text")); // NOI18N
        jLabel1.setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 10, 1, 1));
        jLabel1.setName("jLabel1"); // NOI18N
        jToolBar1.add(jLabel1);

        PEDPatternNrjSpinner.setName("PEDPatternNrjSpinner"); // NOI18N
        PEDPatternNrjSpinner.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                PEDPatternNrjSpinnerStateChanged(evt);
            }
        });
        PEDPatternNrjSpinner.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                PEDPatternNrjSpinnerKeyPressed(evt);
            }
        });
        jToolBar1.add(PEDPatternNrjSpinner);

        jLabel2.setLabelFor(PEDInstrNrSpinner);
        jLabel2.setText(resourceMap.getString("jLabel2.text")); // NOI18N
        jLabel2.setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 10, 1, 1));
        jLabel2.setName("jLabel2"); // NOI18N
        jToolBar1.add(jLabel2);

        PEDInstrNrSpinner.setName("PEDInstrNrSpinner"); // NOI18N
        jToolBar1.add(PEDInstrNrSpinner);

        jLabel3.setLabelFor(PEDKbdTunejSpinner);
        jLabel3.setText(resourceMap.getString("jLabel3.text")); // NOI18N
        jLabel3.setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 10, 1, 1));
        jLabel3.setName("jLabel3"); // NOI18N
        jToolBar1.add(jLabel3);

        PEDKbdTunejSpinner.setName("PEDKbdTunejSpinner"); // NOI18N
        PEDKbdTunejSpinner.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                PEDKbdTunejSpinnerStateChanged(evt);
            }
        });
        jToolBar1.add(PEDKbdTunejSpinner);

        jLabel4.setText(resourceMap.getString("jLabel4.text")); // NOI18N
        jLabel4.setName("jLabel4"); // NOI18N
        jToolBar1.add(jLabel4);

        PEDEditVol.setName("PEDEditVol"); // NOI18N
        PEDEditVol.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                PEDEditVolStateChanged(evt);
            }
        });
        jToolBar1.add(PEDEditVol);

        jLabel5.setLabelFor(PEDKbdTunejSpinner);
        jLabel5.setText(resourceMap.getString("jLabel5.text")); // NOI18N
        jLabel5.setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 10, 1, 1));
        jLabel5.setName("jLabel5"); // NOI18N
        jToolBar1.add(jLabel5);

        PEDEditStepLen.setName("PEDEditStepLen"); // NOI18N
        PEDEditStepLen.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                PEDEditStepLenStateChanged(evt);
            }
        });
        jToolBar1.add(PEDEditStepLen);

        PEDPane.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        PEDPane.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS);
        PEDPane.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
        PEDPane.setFocusable(false);
        PEDPane.setName("PEDPane"); // NOI18N
        PEDPane.setRequestFocusEnabled(false);
        PEDPane.setVerifyInputWhenFocusTarget(false);

        PEDContent.setEditable(false);
        PEDContent.setText(resourceMap.getString("PEDContent.text")); // NOI18N
        PEDContent.setName("PEDContent"); // NOI18N
        PEDContent.setOpaque(false);
        PEDContent.addComponentListener(new java.awt.event.ComponentAdapter() {
            public void componentResized(java.awt.event.ComponentEvent evt) {
                PEDContentComponentResized(evt);
            }
        });
        PEDContent.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseMoved(java.awt.event.MouseEvent evt) {
                PEDContentMouseMoved(evt);
            }
        });
        PEDContent.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                PEDContentActionPerformed(evt);
            }
        });
        PEDContent.addHierarchyBoundsListener(new java.awt.event.HierarchyBoundsListener() {
            public void ancestorMoved(java.awt.event.HierarchyEvent evt) {
                PEDContentAncestorMoved(evt);
            }
            public void ancestorResized(java.awt.event.HierarchyEvent evt) {
            }
        });
        PEDContent.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                PEDContentFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                PEDContentFocusLost(evt);
            }
        });
        PEDContent.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                PEDContentKeyPressed(evt);
            }
            public void keyTyped(java.awt.event.KeyEvent evt) {
                PEDContentKeyTyped(evt);
            }
        });
        PEDPane.setViewportView(PEDContent);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jToolBar1, javax.swing.GroupLayout.DEFAULT_SIZE, 546, Short.MAX_VALUE)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(PEDInfoLabel, javax.swing.GroupLayout.DEFAULT_SIZE, 251, Short.MAX_VALUE)
                .addGap(285, 285, 285))
            .addComponent(PEDPane, javax.swing.GroupLayout.DEFAULT_SIZE, 546, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(jToolBar1, javax.swing.GroupLayout.PREFERRED_SIZE, 25, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(12, 12, 12)
                .addComponent(PEDInfoLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(PEDPane, javax.swing.GroupLayout.DEFAULT_SIZE, 390, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void formComponentResized(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_formComponentResized
        // TODO add your handling code here:
        DrawAll(false);
    }//GEN-LAST:event_formComponentResized

    private void formComponentShown(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_formComponentShown
        // TODO add your handling code here:
        DrawAll(true);
    }//GEN-LAST:event_formComponentShown

    private void formWindowStateChanged(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowStateChanged
        // TODO add your handling code here:
        DrawAll(true);
    }//GEN-LAST:event_formWindowStateChanged

    private void formAncestorResized(java.awt.event.HierarchyEvent evt) {//GEN-FIRST:event_formAncestorResized
        // TODO add your handling code here:
        //DrawAll(false);
    }//GEN-LAST:event_formAncestorResized

    private void PEDPatternNrjSpinnerStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_PEDPatternNrjSpinnerStateChanged
        // TODO add your handling code here:
        int Value;
        Value = SymphManager.checkSpinnerLimits(PEDPatternNrjSpinner, 0, SongLinked.getNumbOfPatterns()-1);

        SongPattern Pat = SymphManager.SymSong.getPattern(Value);
        if (Pat.getNumbOfVoices() == 0) Pat.init(8);
        
        this.ActualPatternNr = Value;
        this.DrawAll(true);
        //.init(8);
        
}//GEN-LAST:event_PEDPatternNrjSpinnerStateChanged

    private void formWindowGainedFocus(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowGainedFocus
        // TODO add your handling code here:
//        DrawAll(true);
    }//GEN-LAST:event_formWindowGainedFocus

    private void formFocusGained(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_formFocusGained
        // TODO add your handling code here:
        DrawAll(true);
    }//GEN-LAST:event_formFocusGained

    private void formHierarchyChanged(java.awt.event.HierarchyEvent evt) {//GEN-FIRST:event_formHierarchyChanged
        // TODO add your handling code here:
//        DrawAll(true);
    }//GEN-LAST:event_formHierarchyChanged

    private void PEDPatternNrjSpinnerKeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_PEDPatternNrjSpinnerKeyPressed
        // TODO add your handling code here:
}//GEN-LAST:event_PEDPatternNrjSpinnerKeyPressed

    private void PEDContentKeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_PEDContentKeyPressed
        // TODO add your handling code here:
        ProcessKeyboardEvents(evt);
}//GEN-LAST:event_PEDContentKeyPressed

    private void PEDContentFocusGained(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_PEDContentFocusGained
        // TODO add your handling code here:
        DrawAll(true);
    }//GEN-LAST:event_PEDContentFocusGained

    private void PEDContentKeyTyped(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_PEDContentKeyTyped
        // TODO add your handling code here:
        //ProcessKeyboardEvents(evt);
    }//GEN-LAST:event_PEDContentKeyTyped

    

    
    
    
    private void PEDContentComponentResized(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_PEDContentComponentResized
        // TODO add your handling code here:
        DrawAll(true);
    }//GEN-LAST:event_PEDContentComponentResized

    private void PEDContentMouseMoved(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_PEDContentMouseMoved
        // TODO add your handling code here:
        DrawMouseCrsr(evt);
    }//GEN-LAST:event_PEDContentMouseMoved

    private void PEDContentFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_PEDContentFocusLost
        // TODO add your handling code here:
        DrawAll(true);
    }//GEN-LAST:event_PEDContentFocusLost

    private void PEDKbdTunejSpinnerStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_PEDKbdTunejSpinnerStateChanged
        // TODO add your handling code here:
        setKbdTune( SymphManager.checkSpinnerLimits(PEDKbdTunejSpinner, -36, +36));
}//GEN-LAST:event_PEDKbdTunejSpinnerStateChanged

    private void PEDContentAncestorMoved(java.awt.event.HierarchyEvent evt) {//GEN-FIRST:event_PEDContentAncestorMoved
        // TODO add your handling code here:
    }//GEN-LAST:event_PEDContentAncestorMoved

    private void PEDContentActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_PEDContentActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_PEDContentActionPerformed

    private void PEDEditVolStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_PEDEditVolStateChanged
        // TODO add your handling code here:
        int Value;
        Value = SymphManager.checkSpinnerLimits(PEDEditVol, 0, 100);
    }//GEN-LAST:event_PEDEditVolStateChanged

    private void PEDEditStepLenStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_PEDEditStepLenStateChanged
        // TODO add your handling code here:
}//GEN-LAST:event_PEDEditStepLenStateChanged
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new frmPatternEditor().setVisible(true);
            }
        });
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField PEDContent;
    private javax.swing.JSpinner PEDEditStepLen;
    private javax.swing.JSpinner PEDEditVol;
    private javax.swing.JLabel PEDInfoLabel;
    private javax.swing.JSpinner PEDInstrNrSpinner;
    private javax.swing.JSpinner PEDKbdTunejSpinner;
    private javax.swing.JScrollPane PEDPane;
    private javax.swing.JSpinner PEDPatternNrjSpinner;
    private javax.swing.JCheckBox PEDRecording;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JToolBar jToolBar1;
    // End of variables declaration//GEN-END:variables
    
    
    private Song SongLinked = null;
    private int ActualPatternNr = 0;
    
    // Layout in Pixel
    //private int NumbOfVoices;
    
    // View
    private float ViewX;
    private float ViewY;
    private float ViewW;
    private float ViewH;
    
    // Title Area
    private float TitleX;
    private float TitleY;
    private float TitleH = 16;
    private float TitleW;
    
    // Voices
    private float VoiceFrameX;
    private float VoiceFrameY;
    private float VoiceFrameW;
    private float VoiceFrameH;
    private float dVoiceFrameToBorders = 2.0f;
    
    private float VoiceX;
    private float VoiceY;
    private float VoiceW;
    private float VoiceH;
    private float dVoiceX = 2.0f;
    
    private float CellW, CellH;
    private UIManager SymphManager;
    
    // Colors
    Color ColorGeneral  = new Color(200,200,200);
    Color ColorVol      = new Color(200,200,255);
    Color ColorPitch    = new Color(180,255,180);
    Color ColorSample   = new Color(180,180,180);
    Color ColorSpeed    = new Color(160,255,160);
    Color ColorDSP      = new Color(255,160,160);
    
    PEDEditCrsr EditCrsr = new PEDEditCrsr(0,255,0);    
    PEDEditCrsr MouseCrsr = new PEDEditCrsr(255,255,255);
    
    
    public void setDefaultEditValues() {
        PEDRecording.getModel().setSelected(false);
        PEDEditVol.getModel().setValue(100);
        PEDEditStepLen.getModel().setValue(4);
    }
    
    
    // Sync with other UI Elements
    void SyncInstrumentNr(int i) {
        PEDInstrNrSpinner.setValue(i);
    }
    
    // PED Management
    private int KbdTune = 0;
    int getKbdTune() {return(KbdTune);}
    void setKbdTune(int i) {KbdTune=i;}
    int getActualPatternNr() {return(ActualPatternNr);}
    void setActualPatternNr(int NewActualPatternNr) {
        ActualPatternNr = NewActualPatternNr;
    }
    
    // Crsr Handling
    private class PEDEditCrsr {
        private int x,y;
        private int MaxX, MaxY;
        private boolean valid = false;
        Color CrsrColor;  
        
        PEDEditCrsr(int r,int g,int b) {
            this.CrsrColor = new Color(r,g,b); 
            valid = false;
        }
        
        void setMaxXY(int NewMaxX, int NewMaxY) {
            MaxX = NewMaxX;
            MaxY = NewMaxY;
        }
        
        void setPos(int xpos, int ypos) {
            x = xpos; 
            y = ypos;
            valid = true;
        }
        boolean isValid() {return(valid);}
        void invalidateCrsrPos() {valid=false;}
        int getX() {return(x);}
        int getY() {return(y);}

        
        public void moveUp(Graphics g) {
            undraw(g);
            y--;
            checkXYValid();
            drawAtNewPos(g);
        }
        
        
       public void moveDown(Graphics g) {
            undraw(g);
            y++;
            if(y>MaxY) y = 0;
            checkXYValid();
            drawAtNewPos(g);
        }
        
        
        public void moveRight(Graphics g) {
            undraw(g);
            x++;
            checkXYValid();
            drawAtNewPos(g);
        }
        public void moveLeft(Graphics g) {
            undraw(g);
            x--;
            checkXYValid();
            drawAtNewPos(g);
        }
        
        void checkXYValid() {
            if(x<0) x = 0;
            if(y<0) y = 0;
            if(x>MaxX) x = MaxX;
            if(y>MaxY) y = MaxY;
        }

        private void undraw(Graphics g) {
            if(isValid()==true) {
                drawVoiceEventsAtCell(g, getX(), getY(), null);
            }
        }
        
        public void drawAtNewPos(Graphics g) {
            drawVoiceEventsAtCell(g, getX(), getY(), this);
        }
        
        public void drawAtNewPos(Graphics g, int newx, int newy) {
            undraw(g);
            setPos(newx, newy);            
            drawVoiceEventsAtCell(g, getX(), getY(), this);
        }

         void draw(Graphics g) {
            undraw(g);
            drawVoiceEventsAtCell(g, getX(), getY(), this);
            this.valid = true;
        }
       
    }


    
    
    
    void initUIManager(UIManager mySymphManager) {
        this.SymphManager = mySymphManager;
    }
    
    int getNumbOfRows() {
        if((SongLinked!=null) && (SongLinked.hasContent())) {
            return(SongLinked.getNumbOfRows());
        } else {
            return(1);
        }
    }
    
    float getCellX(int VoiceIndex) {
        return( (VoiceIndex * (VoiceW + dVoiceX)) + 4 );
    }
    
    float getCellY(int RowNr) {
        return( VoiceY + (RowNr*VoiceH));
    }

    float getCellY(float TimePosition) {
        return( VoiceY + ((TimePosition / getNumbOfRows() ) *VoiceH));
    }
    
    int getVoiceNrAtX(float x) {
        int VoiceNr;
        VoiceNr = (int) ((x-4) / (VoiceW + dVoiceX) );
        if(VoiceNr<0) VoiceNr = 0;
        if(VoiceNr>(getNumbOfVoices()-1) ) VoiceNr = getNumbOfVoices()-1;
        return(VoiceNr);
    }
    
    int getRowNrAtY(float y) {
        int RowNr = (int) ( (y-VoiceY) / (CellH) );
        if(RowNr<0) RowNr = 0;
        if(RowNr>(getNumbOfRows()-1)) RowNr = getNumbOfRows()-1;
        return(RowNr);
    }
    
    int getNumbOfVoices() {
        if((SongLinked!=null) && (SongLinked.hasContent())) {
            return(SongLinked.getNumbOfVoices());
        } else {
            return(0);
        }  
    }
    
    public void initPED(Song mySongLinked) {
        SongLinked = mySongLinked;
        assert(SongLinked==null);
        EditCrsr.setPos(0, 0);
    }
    
    public void moveEditCrsrToRowNr(int RowNr) {
        assert(SongLinked==null);
        Graphics g = PEDContent.getGraphics();
        EditCrsr.drawAtNewPos(g, EditCrsr.getX(), RowNr);
    }

    void CalcLayout(Graphics g, float x,float y,float w,float h) {
        TitleX = x + dVoiceFrameToBorders;
        TitleY = y;
        
        VoiceFrameX = x + dVoiceFrameToBorders;
        VoiceFrameW = w - ((2*dVoiceFrameToBorders) + TitleH);
        VoiceFrameY = y + TitleH + dVoiceFrameToBorders;
        VoiceFrameH = h - ((2*dVoiceFrameToBorders) + TitleH);
        if(VoiceFrameW<1) VoiceFrameW = 1;
        if(VoiceFrameH<1) VoiceFrameH = 1;
        
        VoiceX = VoiceFrameX;
        VoiceY = VoiceFrameY+1;
        VoiceW = (w - (dVoiceX*getNumbOfVoices())) / getNumbOfVoices();
        TitleW = VoiceW;
        VoiceH = VoiceFrameH-2;
        
        CellW = VoiceW-2;
        CellH = VoiceH / getNumbOfRows();
        
        if(VoiceW<1) VoiceW = 1;
        EditCrsr.setMaxXY(getNumbOfVoices()-1, getNumbOfRows()-1);
        MouseCrsr.setMaxXY(getNumbOfVoices()-1, getNumbOfRows()-1);
    }    
    
    public void DrawAll(boolean ClearBackground){
        PEDContent.getBounds();
        ViewW = PEDContent.getBounds().width-3;
        ViewH = PEDContent.getBounds().height-4;
        ViewX = 1.0f;
        ViewY = 2.0f;
        
        if((SongLinked!=null) && (SongLinked.hasContent())) {
            Graphics g = PEDContent.getGraphics();

            CalcLayout(g,ViewX,ViewY,ViewW,ViewH);
            if(ClearBackground) ClearPatternBackground(g,ViewX,ViewY,ViewW,ViewH);
            drawPatternBackground(g);
            drawAllEvents(g);
            drawPatternTitles(g);
            MouseCrsr.invalidateCrsrPos();
            EditCrsr.invalidateCrsrPos();
            MouseCrsr.draw(g);
            EditCrsr.draw(g);
        }
    }
    
    public void DrawVoiceVolumeBar(int VoiceNr, float Value) {
       float x = getCellX(VoiceNr);
       float w = CellW * Value / 100;
       Graphics g = PEDContent.getGraphics();
       g.setColor(Color.BLACK);
       g.fillRect((int) x,(int) TitleY-2,(int) CellW,(int) 3);
       g.setColor(Color.WHITE);
       g.fillRect((int) x,(int) TitleY-2,(int) w,(int) 3);
    }
    
    
    
    public void DrawMouseCrsr(java.awt.event.MouseEvent evt) {
        if((SongLinked!=null) && (SongLinked.hasContent())) {
            float x,y;
            int RowNr, VoiceNr;
            Graphics g = PEDContent.getGraphics();
            
            x = evt.getX();
            y = evt.getY();
            RowNr = getRowNrAtY(y);
            VoiceNr = getVoiceNrAtX(x);
            MouseCrsr.drawAtNewPos(g,VoiceNr, RowNr);
            PEDInfoLabel.setText("Crsr:" + VoiceNr + "/" + RowNr);
            //EditCrsr.draw(g);
        }
    }
    
    
    void ClearPatternBackground(Graphics g, float x,float y,float w,float h) {
        g.clearRect((int) x,(int) y,(int) w,(int) h);
    }
    
    void drawPatternTitles(Graphics g) {
        float x = TitleX;
        g.setColor(Color.BLACK);
        for(int i=0;i<getNumbOfVoices();i++) {
            g.drawRect((int) x,(int) TitleY,(int) TitleW,(int) TitleH);
            g.drawString("Voc " + i, (int) x, (int) (TitleY + TitleH -2 ));
            x += (TitleW + dVoiceX);
        }
    }

    void drawPatternBackground(Graphics g) {
        float x = VoiceX;
        
        g.setColor(Color.BLACK);
        for(int i=0;i<getNumbOfVoices();i++) {
            g.drawRect((int) x,(int) VoiceY,(int) VoiceW,(int) VoiceH);
            x += (VoiceW + dVoiceX);
         
        }
    }
    
    void drawAllEvents(Graphics g) {
        float x = VoiceX;
        
        for(int i=0;i<getNumbOfVoices();i++) {
            drawVoiceEvents(g,i);
            x += (VoiceW + dVoiceX);
        }
    }
            
    void drawVoiceEvents(Graphics g, int VoiceIndex) {
        SongPattern Pat = SongLinked.getPattern(this.ActualPatternNr);
        PatternVoice PatVoc = Pat.PatternVoices[VoiceIndex];
        for(int i=0;i<Pat.getNumbOfRows();i++) {
            
            SongEventPool sep = PatVoc.getSongEventPool(i);
            if(sep!=null) {
                    
                for(int j=0;j<sep.getNumberOfSongEvents();j++) {
                    drawSongEvent(g, PatVoc, sep, sep.getSongEvent(j), VoiceIndex, null);
                }
            }
        }
    }
    
    boolean checkPositionValid(int VoiceIndex, int RowNr) {
        if(SongLinked == null) return(false);
        if(SongLinked.hasContent() == false) return(false);
        
        SongPattern Pat = SongLinked.getPattern(ActualPatternNr);
        if(Pat == null) return(false);
        
        if(VoiceIndex > Pat.getNumbOfVoices()) return(false);
        PatternVoice PatVoc = Pat.PatternVoices[VoiceIndex];
        if(PatVoc == null) return(false);
        
        SongEventPool sep = PatVoc.getSongEventPool(RowNr);
        if(sep == null) return(false);
        if(sep.getNumberOfSongEvents() == 0) return(false);
        return(true);
    }
    
    void drawVoiceEventsAtCell(Graphics g, int VoiceIndex, int RowNr, PEDEditCrsr PEDCrsr) {
        if(checkPositionValid(VoiceIndex, RowNr) ) {
        
            SongPattern Pat = SongLinked.getPattern(ActualPatternNr);
            PatternVoice PatVoc = Pat.PatternVoices[VoiceIndex];
            SongEventPool sep = PatVoc.getSongEventPool(RowNr);
            if(sep!=null) {
                if(sep.getNumberOfSongEvents() > 0){
                    for(int j=0;j<sep.getNumberOfSongEvents();j++) {
                        if(sep.getSongEvent(j).SongFXType != SongEventType.FX_NONE) {
                            drawSongEvent(g, PatVoc, sep, sep.getSongEvent(j), VoiceIndex, PEDCrsr);
                        } else {
                            drawNullEvent(g, sep.TimePosition, VoiceIndex, PEDCrsr);
                        }
                    }    
                } else {
                    drawNullEvent(g, RowNr, VoiceIndex, PEDCrsr);
                }
                
            } else {
                drawNullEvent(g, RowNr, VoiceIndex, PEDCrsr);
            }
        }
        //drawNullEvent(g, RowNr, VoiceIndex, PEDCrsr);
    }
    
    void drawSongEvent(Graphics g, PatternVoice PatVoc, SongEventPool sep, SongEvent se, int VoiceIndex, PEDEditCrsr PEDCrsr) {
        float x = getCellX(VoiceIndex);
        float y = getCellY(sep.TimePosition);
        if(se.SongFXType != SongEventType.FX_NONE) {
            switch(se.FXClass) {
                case SongEventClass.GENERAL: g.setColor(ColorGeneral);break;
                case SongEventClass.VOLUME: g.setColor(ColorVol);break;
                case SongEventClass.PITCH: g.setColor(ColorPitch);break;
                case SongEventClass.SAMPLE: g.setColor(ColorSample);break;
                case SongEventClass.SPEED: g.setColor(ColorSpeed);break;
                case SongEventClass.DSP: g.setColor(ColorDSP);break;
            }
            if(PEDCrsr != null) {
                g.setColor(PEDCrsr.CrsrColor);
            }
            g.fillRect((int) x,(int) y,(int) CellW,(int) CellH);
            
            g.setColor(Color.BLACK);
            g.drawString(getSongEventString(se), (int) x, (int) (y+CellH)-2) ;
        } else {
            if(PEDCrsr != null) {
                //drawNullEvent(g, sep.TimePosition, VoiceIndex, PEDCrsr);
            }            
        }
    }

    void drawNullEvent(Graphics g, float TimePosition, int VoiceIndex, PEDEditCrsr PEDCrsr) {
        float x = getCellX(VoiceIndex);
        float y = getCellY(TimePosition);
        if(PEDCrsr != null) {
            g.setColor(PEDCrsr.CrsrColor);
            g.fillRect((int) x,(int) y,(int) CellW,(int) CellH);
        } else {
            ClearPatternBackground(g, x,y,CellW,CellH);
        }
    }
    
    
    
    
    String getSongEventString(SongEvent se) {
        return(BuildEventString(se));
    }
    
    String BuildEventString(SongEvent e) {
        String AsString = "";
        String ShortString = "";
        
        switch(e.SongFXType){
            case(SongEventType.FX_KEYON):
                AsString="KeyOn:" + PitchToString(e.B) + " Instr:" + e.A + " Volume:" + e.C;
                ShortString = PitchToString(e.B) + " I" + e.A + " " + e.C;
                break;
            case SongEventType.FX_KEYOFF:
                AsString="KeyOff()";
                ShortString = "KeyOff";
                break;
            case SongEventType.FX_STARTSAMPLE:
                AsString="Start Sample()";
                ShortString = "Start";
                break;
            case SongEventType.FX_CONTSAMPLE:
                AsString="Continue Sample()";
                ShortString = "On";
                break;
            case SongEventType.FX_STOPSAMPLE:
                AsString="Stop Sample()";
                ShortString = "Off";
                break;
            
            // Speed
            case SongEventType.FX_SPEEDDOWN:
                AsString="Slower()";
                ShortString = "Slower";
                break;
            case SongEventType.FX_SPEEDUP:
                AsString="Faster()";
                ShortString = "Faster";
                break;
            
            // Pitch
            case SongEventType.FX_PITCHDOWN:
                AsString="PitchDown()";
                ShortString = "PDwn";
                break;
            case SongEventType.FX_PITCHDOWN2:
                AsString="PitchDown2()";
                ShortString = "PDwn2";
                break;
            case SongEventType.FX_PITCHDOWN3:
                AsString="PitchDown3()";
                ShortString = "PDwn3";
                break;
            case SongEventType.FX_PITCHUP:
                AsString="PitchDown()";
                ShortString = "PDwn";
                break;
            case SongEventType.FX_PITCHUP2:
                AsString="PitchDown2()";
                ShortString = "PDwn2";
                break;
            case SongEventType.FX_PITCHUP3:
                AsString="PitchDown3()";
                ShortString = "PDwn3";
                break;
            case SongEventType.FX_SETPITCH:
                AsString="Set Pitch()";
                ShortString = "Set Pitch:" + PitchToString(e.B);
                break;
            case(SongEventType.FX_ADDVOLUME):
                AsString="AddVolume()";
                ShortString = "AddV";
                break;
            case(SongEventType.FX_CV):
                AsString="Set Channel Volume()";
                ShortString = "CV " + e.C;
                break;
            case(SongEventType.FX_CVADD):
                AsString="Add Channel Volume()";
                ShortString = "+CV";
               break;
            case(SongEventType.FX_VIBRATO):
                AsString="Vibrato()";
                ShortString = "VIBR";
                break;
            case(SongEventType.FX_VOLUMESLIDEDOWN):
                AsString="Volume Slide Down()";
                ShortString = "VSliD " + e.C;
                break;
            case(SongEventType.FX_VOLUMESLIDEUP):
                AsString="Volume Slide Up()";
                ShortString = "VSliU " + e.C;
                break;
            case(SongEventType.FX_SETVOLUME):
                AsString="Set Volume()";
                ShortString = "Vol=" + e.C;
                break;

                // Pitch FX
            case(SongEventType.FX_ADDPITCH):
                AsString="AddPitch()";
                ShortString = "AddP";
                break;
            case(SongEventType.FX_ADDHALVTONE):
                AsString="AddHalveTone()";
                ShortString = "+HT";
                break;
            case(SongEventType.FX_PITCHSLIDEDOWN):
                AsString="Pitch Slide Down()";
                ShortString = "PSliD " + e.C;
                break;
            case(SongEventType.FX_PITCHSLIDEUP):
                AsString="Pitch Slide Up()";
                ShortString = "PSliU " + e.C;
                break;
            case(SongEventType.FX_PSLIDETO):
                AsString="Pitch Slide To()";
                ShortString = "PTo";
                break;
            case(SongEventType.FX_TREMOLO):
                AsString="Tremolo()";
                ShortString = "TREM";
                break;

            // DSP Fx
            case(SongEventType.FX_DSPCHOR):
                AsString="DSP Chorus Experimental()";
                ShortString = "CHOR";
                break;
            case(SongEventType.FX_DSPDELAY):
                AsString="DSP Delay()";
                ShortString = "DELY";
                break;
            case(SongEventType.FX_DSPECHO):
                AsString="DSP Echo()";
                ShortString = "ECHO";
                break;
            // Other FX
            case(SongEventType.FX_EMPHASIS):
                AsString="Key Emphasis()";
                ShortString = "EMPH";
                break;
            case(SongEventType.FX_CHANNELFILTER):
                AsString="Resonant Filter()";
                ShortString = "FILT";
                break;
            case(SongEventType.FX_SETSPEED):
                AsString="Set Speed()";
                ShortString = "SPD";
                break;

                // Sample Pointer FX
            case(SongEventType.FX_FROMADD):
                AsString="Sample Pointer Add()";
                ShortString = "+FRM";
                break;
            case(SongEventType.FX_FROMANDPITCH):
                AsString="Sample Pointer Set & Pitch() ";
                ShortString = "FR&P ";
                String tempPitch = this.PitchToString(e.B);
                AsString +=    tempPitch + " Instr:" + e.A  +  " " + (int) (e.C / 2.55) + "%";
                ShortString += tempPitch + " I" + e.A + " " + (int) (e.C / 2.55) + "%";
                break;
           case(SongEventType.FX_REPLAYFROM):
                AsString="Sample Pointer Set()";
                ShortString = "FROM " + (int) (e.C / 2.55) + "%";
                break;
            case(SongEventType.FX_RETRIG):
                AsString="Retrigger()";
                ShortString = "RETR";
                break;
            case(SongEventType.FX_SAMPLEVIB):
                AsString="Samplepos Vibrato()";
                ShortString = "VIBR";
                break;
            case(SongEventType.FX_SETFROMADD):
                AsString="FX_SETFROMADD()";
                ShortString = "+FRM";
                break;
        
        
        }

        
        
        
        
        
        
        
        /*
        
                    }
                } else {
                    if(tempPitch.length() != 0) {
                        AsString="KeyOn:" + tempPitch + " Instr:" + e.A + " Volume:" + e.C;
                        ShortString = tempPitch + " I" + e.A + " " + e.C;
                    }
                }
                break;

            // Volume FX
            case(SongEventType.FX_ADDVOLUME):
                AsString="AddVolume()";
                ShortString = "AddV";
                break;
            case(SongEventType.FX_CV):
                AsString="Set Channel Volume()";
                ShortString = "CV " + e.C;
                break;
            case(SongEventType.FX_CVADD):
                AsString="Add Channel Volume()";
                ShortString = "+CV";
               break;
            case(SongEventType.FX_VIBRATO):
                AsString="Vibrato()";
                ShortString = "VIBR";
                break;
            case(SongEventType.FX_VOLUMESLIDEDOWN):
                AsString="Volume Slide Down()";
                ShortString = "VSliD " + e.C;
                break;
            case(SongEventType.FX_VOLUMESLIDEUP):
                AsString="Volume Slide Up()";
                ShortString = "VSliU " + e.C;
                break;

                // Pitch FX
            case(SongEventType.FX_ADDPITCH):
                AsString="AddPitch()";
                ShortString = "AddP";
                break;
            case(SongEventType.FX_ADDHALVTONE):
                AsString="AddHalveTone()";
                ShortString = "+HT";
                break;
            case(SymphonieEventType.FX_PITCHSLIDEDOWN):
                AsString="Pitch Slide Down()";
                ShortString = "PSliD " + e.C;
                break;
            case(SymphonieEventType.FX_PITCHSLIDEUP):
                AsString="Pitch Slide Up()";
                ShortString = "PSliU " + e.C;
                break;
            case(SymphonieEventType.FX_PSLIDETO):
                AsString="Pitch Slide To()";
                ShortString = "PTo";
                break;
            case(SymphonieEventType.FX_TREMOLO):
                AsString="Tremolo()";
                ShortString = "TREM";
                break;

            // DSP Fx
            case(SymphonieEventType.FX_DSPCHOR):
                AsString="DSP Chorus Experimental()";
                ShortString = "CHOR";
                break;
            case(SymphonieEventType.FX_DSPDELAY):
                AsString="DSP Delay()";
                ShortString = "DELY";
                break;
            case(SymphonieEventType.FX_DSPECHO):
                AsString="DSP Echo()";
                ShortString = "ECHO";
                break;
            // Other FX
            case(SymphonieEventType.FX_EMPHASIS):
                AsString="Key Emphasis()";
                ShortString = "EMPH";
                break;
            case(SymphonieEventType.FX_FILTER):
                AsString="Resonant Filter()";
                ShortString = "FILT";
                break;
            case(SymphonieEventType.FX_SETSPEED):
                AsString="Set Speed()";
                ShortString = "SPD";
                break;

                // Sample Pointer FX
            case(SymphonieEventType.FX_FROMADD):
                AsString="Sample Pointer Add()";
                ShortString = "+FRM";
                break;
            case(SymphonieEventType.FX_FROMANDPITCH):
                AsString="Sample Pointer Set & Pitch() ";
                ShortString = "FR&P ";
                tempPitch = this.PitchToString(e.B);
                AsString +=    tempPitch + " Instr:" + e.A  +  " " + (int) (e.C / 2.55) + "%";
                ShortString += tempPitch + " I" + e.A + " " + (int) (e.C / 2.55) + "%";
                break;
           case(SymphonieEventType.FX_REPLAYFROM):
                AsString="Sample Pointer Set()";
                ShortString = "FROM " + (int) (e.C / 2.55) + "%";
                break;
            case(SymphonieEventType.FX_RETRIG):
                AsString="Retrigger()";
                ShortString = "RETR";
                break;
            case(SymphonieEventType.FX_SAMPLEVIB):
                AsString="Samplepos Vibrato()";
                ShortString = "VIBR";
                break;
            case(SymphonieEventType.FX_SETFROMADD):
                AsString="FX_SETFROMADD()";
                ShortString = "+FRM";
                break;
            }
        }
        */
         return(ShortString);
    }

    String[] SymphonieTonleiter = {"C","C#","D","D#","E","F","F#","G","G#","A","A#","H"};
    String PitchToString(float fPitch) {
        String s = "";
        int Pitch = (int) fPitch;
        int Octave;
        Octave = Pitch / 12;
        Pitch = Pitch - (Octave * 12);
        
        if((Pitch<SymphonieTonleiter.length) && (Pitch>0)) {
            s = SymphonieTonleiter[Pitch];
            s = s + Octave;
        }
       return(s);
    }    



    void ProcessKeyboardEvents(java.awt.event.KeyEvent evt) {
        int EditPitch;
        int KeyCode = evt.getKeyCode();
        Graphics g = PEDContent.getGraphics();
        
        switch(KeyCode) {
            case KeyEvent.VK_PAGE_UP:   
                SymphManager.MoveInstrNext();
                break;
            case KeyEvent.VK_PAGE_DOWN:   
                SymphManager.MoveInstrPrev();
                break;
            case KeyEvent.VK_ESCAPE:   
                SymphManager.stopAllStopSong();
                break;
            case KeyEvent.VK_DOWN:   
                EditCrsr.moveDown(g);
                break;
            case KeyEvent.VK_LEFT:   
                EditCrsr.moveLeft(g);
                break;
            case KeyEvent.VK_RIGHT:   
                EditCrsr.moveRight(g);
                break;
            case KeyEvent.VK_UP:      
                EditCrsr.moveUp(g);
                break;
            case KeyEvent.VK_SPACE:   
                setNoneEvent();
                moveEditCrsrDownSteps();
                break;
        }
        SymphManager.KeyboardPlayChar(evt.getKeyChar(), getKbdTune() );
        
        // Add Keyon Events
        EditPitch = SymphManager.getKeyboardCharToPitch(evt.getKeyChar(), getKbdTune() );
        if((PEDRecording.isSelected() && (EditPitch!=-1)  ) ){
            int Vol = SymphManager.getSpinnerValue(PEDEditVol);
            addKeyOnEvent(SymphManager.getActualInstrumentIndex(), EditPitch, Vol );
            moveEditCrsrDownSteps();
        }
    }
    
    private void moveEditCrsrDownSteps() {
        Graphics g = PEDContent.getGraphics();    
        for(int i = 0;i<SymphManager.getSpinnerValue(PEDEditStepLen);i++) {
            EditCrsr.moveDown(g);
        }        
    }
    
    
    void addKeyOnEvent(int InstrIndex, int Pitch, int Vol) {
        SymphManager.SymSong.addKeyOnEvent(SymphManager.PED.getActualPatternNr(),
                EditCrsr.getX(),
                EditCrsr.getY(),
                InstrIndex,
                Pitch,
                Vol
            );
    }
    
    void setNoneEvent() {
        SymphManager.SymSong.clrEvent(SymphManager.PED.getActualPatternNr(),
                EditCrsr.getX(),
                EditCrsr.getY()
            );
    }
    


}




