/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package symreader;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import java.lang.Math;

/**
 *
 * @author (c) Patrick Meng 2008
 */

//global



interface SymphonieDSPType {
    int Off     =   0;
    int CrEcho  =   1;
    int Echo    =   2;
    int Delay   =   3;
    int CrDelay =   4;
}

class SymphonieDSP {
    boolean Running = false;
    int NumbOfChannels = 2;
    private int RingBufferLenSamples = (64000 * NumbOfChannels);
    
    private int NewFXLength = RingBufferLenSamples;
    private int FXLength = RingBufferLenSamples;
    
    private float[] RingBuffer;
    private int readPtrDelay = 100;
    private int readPtrIndex = 0;
    private int writePtrIndex = 0;
    int InputChannels = 0;
    float DSPIntensity = 0.5f;
    float WetMixVolume = 0.75f; // 1 = Max
    private int FxType = 0;
    private boolean OverWritePrevSample = false;
    private int BufferLenSub = 1;           // 1 does a crossfx, as the length is not even with 2 Channels
    
    private boolean LengthInBeats;
    private int BeatLength;
    private int MaxBeatsDspLen;
    
    
    SymphonieDSP(int NumbOfInputChannels) {
        InputChannels = NumbOfInputChannels; 
        allocMemory();
        emptyRingBuffers();
        setDelay(RingBufferLenSamples); 
        setSyncToBeat(false);
    }
    
    // management
    private void allocMemory() {
        RingBuffer = new float[RingBufferLenSamples + 2]; // 2 reserve
    }
   
    void init() {
        allocMemory();
        SetFxClass(0);
    }
    
    void setBeatLength(int len) {
        BeatLength = len;
        recalcNumbOfBeats();
    }
    
    
    private void recalcNumbOfBeats() {
        if(BeatLength == 0) BeatLength = 600;
        MaxBeatsDspLen = (RingBufferLenSamples) / BeatLength;
    }
    
    void setSyncToBeat(boolean b) {
        LengthInBeats = b;
        recalcNumbOfBeats();
    }

    int getMaxBeatsDspLen() {
        recalcNumbOfBeats();
        return(MaxBeatsDspLen);
    }
    
    // Init DSP Fx
    void SetFxClass(int myFxType) {
        stop();
        FxType = myFxType;
        OverWritePrevSample = true;
        if((FxType == SymphonieDSPType.CrEcho) || (FxType == SymphonieDSPType.Echo) ) {
            OverWritePrevSample = false;
        }
        if(FxType == SymphonieDSPType.Echo) {
            BufferLenSub = 1;
        } else {
            BufferLenSub = 2;
        }
        if(FxType != SymphonieDSPType.Off) {
            start();
        }
    }
    
    void emptyRingBuffers() {
        java.util.Arrays.fill(RingBuffer, 0.0f);
    }
    
    void setNewLength(int len) { // Lenght of Total FX
        if(Running) {
            stop();
            
            if(LengthInBeats==false) {
                NewFXLength = (RingBufferLenSamples * len) / 100;
            } else {
                NewFXLength = BeatLength * len;
            }
            start();
        }
    }
    
    private void initLenghts() {
        int NewDelayLen;
        // init fx total length
        FXLength = NewFXLength;
        
        // read ptr to start
        readPtrIndex = 0;
        
        // offset write ptr to first delay length
        NewDelayLen = (((FXLength-2) * readPtrDelay) / 100); 
        NewDelayLen = NewDelayLen & 0xfffffffe;
        
        // force Initial Delay in even or odd channel
        if( (FxType == SymphonieDSPType.CrDelay) || (FxType == SymphonieDSPType.Echo) ) {
            writePtrIndex = NewDelayLen - 1; // Even Length with 2 Channels
        } else {
            writePtrIndex = NewDelayLen; // Even Length with 2 Channels
        }
        
        if(writePtrIndex<0) writePtrIndex = 0;
    }
    
    void setDelay(int len) {
        if(Running) {
            stop();
            readPtrDelay = len;
            start();
        }
    }
    
    
    // activation
    void start() {
        stop();
        emptyRingBuffers();
        initLenghts();
        if(NewFXLength > 0) {
            Running = true;
        }
    }
    
    void stop() {
        Running = false;
    }
    
    // Do the DSP Fx
    void doDSP() {
        if(Running && (FxType != SymphonieDSPType.Off) )
            switch(FxType) {
                case SymphonieDSPType.CrEcho:
                    RingBuffer[readPtrIndex] = RingBuffer[readPtrIndex] * DSPIntensity;
                    break;
                case SymphonieDSPType.Echo:
                    RingBuffer[readPtrIndex] = RingBuffer[readPtrIndex] * DSPIntensity;
                    break;
                case SymphonieDSPType.Delay:
                    RingBuffer[readPtrIndex] = RingBuffer[readPtrIndex] * DSPIntensity;
                    break;
                case SymphonieDSPType.CrDelay:
                    RingBuffer[readPtrIndex] = RingBuffer[readPtrIndex] * DSPIntensity;
                    break;
                
            }
    }
           
   // Add Source Samples into DSP
    void advanceWritePtr() {
        if(Running) {
            if(writePtrIndex==0) FXLength = NewFXLength;
            writePtrIndex = advanceRingBufferPtr(writePtrIndex);
        }
    }
   
    void addVoiceSampleIntoDSP(float Sample) {
        if(Running) {
            RingBuffer[writePtrIndex] += Sample;
        }
    }
    
    // Read Samples after DSP processing
    float getWetMixSample() {
        if(Running) {
            doDSP();
            // Clear Old Sample if Overwrite Mode
            float Sample = RingBuffer[readPtrIndex];
            if(OverWritePrevSample==true) RingBuffer[readPtrIndex] = 0.0f;
            return(Sample * WetMixVolume);
        } else {
            return(0.0f);
        }
    }
    
    private int advanceRingBufferPtr(int myptr) {
        myptr++;
        if(myptr >= (FXLength-BufferLenSub) ) myptr=0;
        return(myptr);
    }
    
    void advanceReadPtr() {
        if(Running) {
            // advance ptr
            readPtrIndex = advanceRingBufferPtr(readPtrIndex);
        }
    }
}

// Declicking System
class VoiceSmoother { 
    private boolean SampleSmoothing;
    private boolean FadeOut = false;
    private int SampleSmoothingRemaining = 0;
    private float PrevSample;
    int SmoothNumbOfSamples = 25;

    VoiceSmoother() {
        SampleSmoothing = false;
        FadeOut = false;
    }
    
    void setSmoothingLen(int len) {
        SmoothNumbOfSamples = len;
    }
    
    void stop() {
        SampleSmoothing = false;
        FadeOut = false;
    }
    
    void activateSampleSmoothing() {
        SampleSmoothing = false;
        SampleSmoothingRemaining = (int) SmoothNumbOfSamples;
        SampleSmoothing = true;
        FadeOut = false;
    }
    
    void activateFadeOut() {
        SampleSmoothing = false;
        SampleSmoothingRemaining = (int) SmoothNumbOfSamples;
        SampleSmoothing = true;
        FadeOut = true;     
    }

    void activateFadeIn() {
        SampleSmoothing = false;
        SampleSmoothingRemaining = (int) SmoothNumbOfSamples;
        PrevSample = 0.0f;
        SampleSmoothing = true;
        FadeOut = false;     
    }
    
    boolean isFadeingOut() {
        return(SampleSmoothing && FadeOut);
    }
    
    float getSmoothedSample(float Sample) {
        
        if( (SampleSmoothing == true) && (SampleSmoothingRemaining > 0) ){
            if(FadeOut==true) {
                Sample = 0.0f;
            }
            float OriginalPart = SampleSmoothingRemaining;
            OriginalPart = OriginalPart / SmoothNumbOfSamples;
            Sample = (OriginalPart * PrevSample) + 
                    (Sample * ( 1 - OriginalPart   ) );
            SampleSmoothingRemaining--;
            if(SampleSmoothingRemaining<=0) SampleSmoothing = false;
        } else {
            SampleSmoothing = false;
            this.PrevSample = Sample;
        }
        return(Sample);
    }
}

class VoiceLFO {
    private boolean Running = false;
    private boolean BPMrelative = true;
    private boolean FadeToValue = false;
    private float MinValue, MaxValue;
    private float FadeToValueSpeed;
    private float DestValue;
    private float dValue;
    
    // Can additionally be activated
    private boolean SinusRunning = false;
    private float SinusIntensity = 100.0f; // 100 = Full Value Range
    private float SinusSpeed = 1.0f;
    
    
    VoiceLFO(float Min, float Max) {
        Running = false;
        SinusRunning = false;
        MinValue = Min;
        MaxValue = Max;
    }
    
    // Sinus Section
    float applySinusToValue(float Value) {
        if(SinusRunning==true) {
            //Value += sinus()
        }
        return(Value);
    }
    
    // Slide Section
    float checkLimits(float Value) {
        if((Value >= MaxValue) && (dValue>0)) {
            stop();
            Value = MaxValue;
        }
        
        if((Value <= MinValue) && (dValue<0)) {
            stop();
            Value = MinValue;
        }
        return(Value);
    }
    
    float applyToValue(float Value) {
        if(Running==true) {
            
            // Fade Up / Down
            if(FadeToValue == false) {
                Value += dValue;
                Value = checkLimits(Value);
            
            // Fade To Value
            } else {
                dValue = (DestValue - Value) / FadeToValueSpeed;
                if(dValue == 0) {
                    Running = false;
                } else {
                
                    if(dValue > 0) {
                        if((Value + dValue) >= DestValue) {
                            Value = DestValue;
                            Running = false;
                        }
                    } else {
                        if((Value + dValue) <= DestValue) {
                            Value = DestValue;
                            Running = false;
                        }
                    }
                    
                    if(Running == true) Value += dValue;
                    Value = checkLimits(Value);
                }
            }
        }
        return(Value);
    }
    
    void initSlide(float NewdValue) {
        
        Running = false;
        if(NewdValue != 0) {
            FadeToValue = false;
            dValue = NewdValue;
            Running = true;
        }
    }
    
     void initSlideToValue(float NewDestValue, float Speed) {
        Running = false;
        if( (DestValue >= MinValue) && (DestValue <= MaxValue ) && 
                (Speed != 0)
        ) {
            FadeToValue = true;
            DestValue = NewDestValue;
            FadeToValueSpeed = Speed;
            Running = true;
        }
    }
    
    
    boolean isRunning() {
        return(Running);
    }
    
    void stop() {
        Running = false;
    }
}

class Voice {
    boolean inUse = false;
    float ChannelVolume = 0.0f;
    float PlayFrequency = 440.0f;
    float SourceFrequency = 44100.0f;
    float SamplePtr = 0.0f;
    float SampleEndPtr = 0.0f;
    
    // Looping
    private int NumbOfLoopsRemaining = 0;
    float LastSample = 0.0f; // Last Sample heard from this voice
    boolean isPausing = false;
    SymphonieInstrument si;
    
    // LFO
    VoiceLFO LFOChannelVol;
    VoiceLFO LFOPitch;
    VoiceLFO LFOSample;
    
    // Anticlicksystem
    VoiceSmoother Smoother;
    
    Voice() {
        LFOChannelVol = new VoiceLFO(0,100);
        LFOPitch = new VoiceLFO(100,200);
        LFOSample = new VoiceLFO(0,255);
        Smoother = new VoiceSmoother();
    }
    
    void processAllLFOs() {
        if(LFOChannelVol.isRunning()==true) {
            ChannelVolume = LFOChannelVol.applyToValue(ChannelVolume);
        }
    }
    
    void pausePlaying() {
        isPausing = true;
    }
    void continuePlaying() {
        isPausing = false;
    }
    
    void setNumbOfLoopsRemaining(int NumbOfLoops) {
        NumbOfLoopsRemaining = NumbOfLoops;
    }
    int getNumbOfLoopsRemaining() {
        return(NumbOfLoopsRemaining);
    }
    void decNumbOfLoopsRemaining() {
        if(NumbOfLoopsRemaining>0) NumbOfLoopsRemaining--;
    }
}

public class VoiceExpander {
    boolean isReady = false;
    boolean InitError = false;
    String ErrorString = "";
    
    float MixFrequency = 44100.0f;      // Output Mix Frequency of all Channels
    float BPM = 120.0f;                 // Used for Beat Synced FX
    float NewBPM = 120.0f;          
    private int BPMTune = 100;          // 100% = Original Speed
    
    float MasterVolume = 100.0f;        // Global Mix Volume
    float MasterTune = 0.0f;
    int NumbOfVoices = 64;              // Numb of Sound Channels
    
    int MinPitch = 0;
    int MaxPitch = 257;
    private int BasePitchOffset = 24;
    private float FreqTableFactor = 0.095f;
    
    int MixChannels = 2;
    int MixBufferLenSamples = 1024 * MixChannels;
    
    boolean Declicking = true;
    int InterpolationType = 1;      // 0 = no, 1 = linear
    int Dithering = 0;
    int DSPFxIndex = 0;
    
    byte[] MixBuffer = new byte[MixBufferLenSamples*2];    
    Voice[] Voices;
    float[] FreqBase = {1.0000f,1.0595f,1.1225f,1.1892f,1.2599f,1.3348f,1.4142f,1.4983f,1.5874f,1.6818f,1.7818f,1.8878f}; // Gleichschwebend
    float[] FreqTable;
    SymphonieDSP DSP = new SymphonieDSP(16);
    
    private Song LinkedSong = null;
    
    private int InitSamplesTillSongEvent = 5000;
    private int SamplesTillSongEvent = 0;

    //public java.util.LinkedList LogList;
    
    boolean LogEvents = true;
    int EventCounter = 0;
    
    int getInitSamplesTillSongEvent() {
        return( (InitSamplesTillSongEvent * 100) / BPMTune);
    }
    
    VoiceExpander() {
        Voices = new Voice[NumbOfVoices];
        FreqTable = new float[MaxPitch + 1];
        InitFreqTable();
        //LogList = new java.util.LinkedList();
        //LogList.clear();
    }

    //public void addLog(String s) {
    //    if(LogEvents) LogList.add(EventCounter +":"+ s);
    //}
    
    
    // Set System Parameters
    void setDeclicking(boolean b) {
        Declicking = b;
    }
    
    void setDSPFxIndex(int myDSP) {
        DSPFxIndex = myDSP;
        this.DSP.setBeatLength(this.getInitSamplesTillSongEvent());
        if(DSPFxIndex == 0) {
            DSP.stop();
        } else {
            DSP.stop();
            DSP.SetFxClass(DSPFxIndex);
            DSP.start();
        }
    }

    void setWetMixVolume(float DSPVolume) {
        DSP.WetMixVolume = DSPVolume / 100;
    }
    
    void setDSPPreDelay(int len) {
        DSP.setDelay(len);
    }
    
    void setDSPLength(int len) {
        DSP.setNewLength(len);
    }
   
    void setDSPFeedback(float DSPVolume) {
        DSP.DSPIntensity = DSPVolume / 100;
    }
    
/*
 void setBPM(int f) {
        NewBPM = f;
        if(NewBPM != BPM) {
            InitSamplesTillSongEvent = (int) ((MixFrequency*6) / f); 
            BPM = NewBPM;
        }
        this.DSP.setBeatLength(this.getInitSamplesTillSongEvent());
    }
 */
    
    void setBPMTune(int myBPM) {
        BPMTune = myBPM;
    }

    // Song Interface
    void setSong(Song s) {
        this.LinkedSong = s;
        this.SamplesTillSongEvent = this.getInitSamplesTillSongEvent();
    }
    
    void setSongSpeed(float BPM, int Cycle) {
        float NewSpeed = 178900 * Cycle / BPM; //1789 
        this.InitSamplesTillSongEvent = (int) NewSpeed;
        this.DSP.setBeatLength(this.getInitSamplesTillSongEvent());
    }
   
    
    
    void checkSongEvent() {
        if(this.LinkedSong!=null) {
            if(this.LinkedSong.SongPlaying) {
                
                if(SamplesTillSongEvent>0) {
                    SamplesTillSongEvent--;
                    if(SamplesTillSongEvent<=0) {
                        int tempSamplesTillSongEvent;
                        
                        tempSamplesTillSongEvent = this.LinkedSong.PlaySongEvent(this);
                        if(tempSamplesTillSongEvent != 0) {
                            this.InitSamplesTillSongEvent = tempSamplesTillSongEvent;
                        }
                        SamplesTillSongEvent = getInitSamplesTillSongEvent();
                    }
                }
            }
        }
    }
    
    int getNumbOfPitches() {
        return(MaxPitch-MinPitch);
    }
    
    void InitFreqTable(){
        int counter = 0;
        float factor = FreqTableFactor;
        for(int i=0;i<getNumbOfPitches();i++) {
            FreqTable[i]= FreqBase[counter] * factor;
            counter++;
            if(counter > FreqBase.length-1) {
                factor = factor * 2;
                counter = 0;
            }
        }
    }
    
   float getPitchToFreq(int Pitch, int Finetune) {
        float f;
        Pitch += BasePitchOffset;
        if(Pitch < MinPitch) Pitch = MinPitch;
        if(Pitch > MaxPitch-1) Pitch = MaxPitch-1;
        
        f = FreqTable[Pitch] * 110.0f;
        if(Finetune>0) {
            float f1 = FreqTable[Pitch+1] * 110.0f;
            f = f + ((f1-f) * (Finetune / 127));
        }
        if(Finetune<0) {
            float f1 = FreqTable[Pitch-1] * 110.0f;
            f = f + ((f-f1) * (Finetune / 128));
        }
        return(f);
    }
    
/*
 float getPitchToFreq(int Pitch) {
        float f;
        Pitch += BasePitchOffset;
        if(Pitch < MinPitch) Pitch = MinPitch;
        if(Pitch > MaxPitch) Pitch = MaxPitch;
        f = FreqTable[Pitch] * 110.0f;
        return(f);
    }
 */
   
    Voice getFreeVoice() {
        for(int i = 0; i<NumbOfVoices;i++) {
            if(Voices[i] == null) {
                Voices[i] = new Voice();
                return(Voices[i]);
            } else {
                if(Voices[i].inUse == false) {
                    return(Voices[i]);
                }
            }
        }
        return(null);
    }
    
    Voice getVoiceNr(int i) { 
        if(Voices[i] == null) {
            Voices[i] = new Voice();
            return(Voices[i]);
        } else {
            return(Voices[i]);
        }
    }

    boolean PlayInstrument(SymphonieInstrument si, float freq, float vol) {
        Voice v;

        v = getFreeVoice();
        if((v != null) && (si != null)) {
            v.si = si;
            if( (v.si.sp != null) && (v.si.sp.getNumbOfSamples()>1) ) {
                v.SampleEndPtr = v.si.sp.getNumbOfSamples()-1;
                v.ChannelVolume = vol;
                v.PlayFrequency = freq;
                v.SourceFrequency = v.si.ImportSample.SampledFrequency;
                v.inUse = true;
                v.SamplePtr = 0.0f;
                

                v.Smoother.activateFadeIn(); // Fade in from Zero

                
                assert(v.SourceFrequency == 0.0f);
                return(true);
            }
        }
        return(false);
    }

    
    void SongEventVSlide(int VoiceNr, float VolChangeSpeed) {
        SetVoiceVSlide(VoiceNr, VolChangeSpeed);
    }    
    
    void SongEventSetVolume(int VoiceNr, float vol) {

        float oldvol = GetVoiceVolume(VoiceNr);
        stopVolumeLFO(VoiceNr);
        if( java.lang.Math.abs(vol - oldvol) > 40.0f ) {
            Voice v = getVoiceNr(VoiceNr);

            v.Smoother.activateSampleSmoothing();

        }
        SetVoiceVolume(VoiceNr, vol);
    }    
    
    void SongEventAddVolume(int VoiceNr, float vol) {
        stopVolumeLFO(VoiceNr);
        SetVoiceVolume(VoiceNr, GetVoiceVolume(VoiceNr) + vol);
    }    
    
    void SongEventKeyOn(SymphonieInstrument si, int VoiceNr, int NoteIndex, float vol) {
        stopVolumeLFO(VoiceNr);
        int PosTuneOffset = 0;
        if(si.AllowPosDetune==true) {
            PosTuneOffset = this.LinkedSong.PosTuneOffset;
        }
        SongEventKeyOnFreq(si, VoiceNr, getPitchToFreq(NoteIndex+si.Tune+PosTuneOffset, si.FineTune), vol);
    }
    
    void SongEventSetPitch(SymphonieInstrument si, int VoiceNr, int NoteIndex) {
        int PosTuneOffset = 0;
        if(si.AllowPosDetune==true) {
            PosTuneOffset = this.LinkedSong.PosTuneOffset;
        }
        SetVoiceFreq(si, VoiceNr, getPitchToFreq(NoteIndex+si.Tune+PosTuneOffset, si.FineTune));
    }    

    void SongEventKeyOnSamplePos(SymphonieInstrument si, int VoiceNr, int NoteIndex, float SamplePos) {
        int PosTuneOffset = 0;
        SongEventContinue(VoiceNr, false);
        if(si.AllowPosDetune==true) {
            PosTuneOffset = this.LinkedSong.PosTuneOffset;
        }
        SetVoiceSamplePos(si, VoiceNr, getPitchToFreq(NoteIndex+si.Tune+PosTuneOffset, si.FineTune), SamplePos);
    }
    
    void SongEventPausePlaying(int VoiceNr) {

        Voice v = getVoiceNr(VoiceNr);
        if(v != null) {
            v.pausePlaying();

            v.Smoother.activateFadeOut();


        }
    }

    void SongEventContinue(int VoiceNr, boolean ActivateFadeIn) {

        Voice v = getVoiceNr(VoiceNr);
        if(v != null) {
            if(ActivateFadeIn) v.Smoother.activateFadeIn();
            v.continuePlaying();
        }
    }
    
    void SongEventKeyOnFreq(SymphonieInstrument si, int VoiceNr, float Freq, float vol) {
        PlayInstrument(si, VoiceNr, Freq, vol);
    }
    
    float GetVoiceVolume(int VoiceNr) {
        Voice v = getVoiceNr(VoiceNr);
        if(v != null) {
            return(v.ChannelVolume); 
        }
        return(0.0f);
    }
    
    void SetVoiceVolume(int VoiceNr, float Vol) {
        Voice v = getVoiceNr(VoiceNr);
        if(v != null) {
            if( (Vol >= 0) &&(Vol<=100)) v.ChannelVolume = Vol;
        }
    }

    void SetVoiceVSlide(int VoiceNr, float VolChangeSpeed) {
        Voice v = getVoiceNr(VoiceNr);
        if(v != null) {
            v.LFOChannelVol.initSlide(VolChangeSpeed/6500);
        }
    }
    
    void stopVolumeLFO(int VoiceNr) {
        Voice v = getVoiceNr(VoiceNr);
        if(v != null) {
            v.LFOChannelVol.stop();
        }
    }
    
    void SetVoiceFreq(SymphonieInstrument si, int VoiceNr, float freq) {
        Voice v = getVoiceNr(VoiceNr);
        if((v != null) && (si.checkReady()==true )) {
            v.si = si;
            v.PlayFrequency = freq;
            assert(v.SourceFrequency == 0.0f);
        }
    }
    
    void SetVoiceSamplePos(SymphonieInstrument si, int VoiceNr, float freq, float SamplePos) {
        Voice v = getVoiceNr(VoiceNr);
        if((v != null) && (si.checkReady()==true )) {
            v.si = si;
                if(v.inUse == true) {
                    v.Smoother.activateSampleSmoothing();
                } else {
                    v.Smoother.activateFadeIn();
                }
            
            
                v.SampleEndPtr = v.si.sp.getNumbOfSamples()-1;
                v.ChannelVolume = 100.0f;
                v.PlayFrequency = freq;
                v.SourceFrequency = v.si.ImportSample.SampledFrequency;
                v.inUse = true;
                if( (SamplePos>=0) && (SamplePos<=255.0f) ){
                    v.SamplePtr = SamplePos / 255 * (v.SampleEndPtr-1);
                } else {
                    v.SamplePtr =0.0f;
                }
                assert(v.SourceFrequency == 0.0f);
            //}
        }        
    }
    
    // Plays into forced channel Number
    void PlayInstrument(SymphonieInstrument si, int VoiceNr, float freq, float vol) {

        Voice v = getVoiceNr(VoiceNr);
        if((v != null) && (si.checkReady()==true )) {
            if(v.inUse == true) {
                v.Smoother.activateSampleSmoothing();

            } else {
                v.Smoother.activateFadeIn();
            }
            v.continuePlaying();
            v.si = si;
            v.SampleEndPtr = v.si.sp.getNumbOfSamples()-1;
            v.setNumbOfLoopsRemaining(v.si.sp.getNumbOfLoops());
            v.ChannelVolume = vol;
            v.PlayFrequency = freq;
            v.SourceFrequency = v.si.ImportSample.SampledFrequency;
            v.SamplePtr = 0.0f;
            v.isPausing = false;
            v.inUse = true;
            assert(v.SourceFrequency == 0.0f);
        }
    }
    
    void PlayInstrumentNote(SymphonieInstrument si, int NoteIndex, float vol) {
        float f = getPitchToFreq(NoteIndex+si.Tune, si.FineTune);
        PlayInstrument(si, f, vol);
    }
    
    void stopVoice(int index) {
        Voice v = Voices[index];
        v.LFOChannelVol.stop();
        v.LFOPitch.stop();
        v.LFOSample.stop();
        v.inUse = false;
        v.Smoother.stop();
        v.isPausing = false;
        v.LastSample = 0.0f;
    }
    
    void stopAll() {
        for(int i=0; i<NumbOfVoices; i++) {
            if(isVoicePlaying(i)==true) stopVoice(i);
        }
    }
    
    void setVoiceSmoothingLen(int len) {
        for(int i=0; i<NumbOfVoices; i++) {
            this.Voices[i].Smoother.setSmoothingLen(len);
        }
    }
    
    void endVoice(Voice v, float LastSamplePlayed) {
        v.inUse = false;
        if(LastSamplePlayed != 0.0f) {
            v.LastSample = LastSamplePlayed;
            v.Smoother.activateFadeOut();
        }
    }
    
    boolean isVoicePlaying(int i) { // check if voice does play currently 
        
        if( (Voices[i] != null) && (Voices[i].si!=null) && ((Voices[i].inUse==true) || 
                (Voices[i].Smoother.isFadeingOut()==true))  ) {
            return(true);
        } else {
            return(false);
        }
    }
    
    boolean isVoicePausing(int i) { // check if voice is active but is pausing sample output
        if(Declicking==true) { // Declicking activated
            if( (Voices[i] != null) && ((Voices[i].isPausing)) && (!Voices[i].Smoother.isFadeingOut()) ) {
                return(true);
            } else {
                return(false);
            }
        } else { // without Declicking activated
            if( (Voices[i] != null) && ((Voices[i].isPausing))  ) {
                return(true);
            } else {
                return(false);
            }
        }
    }
    
    int getNumbOfVoicesPlaying() {
        int counter = 0;
        for(int i=0; i<NumbOfVoices; i++) {
            if(isVoicePlaying(i)==true) counter++;
        }
        return(counter);        
    }
    
    float getNextMixSample(int ChannelNr) { // 0 = Left, 1 = Right
        float SampleMix = 0.0f;
        int ChannelStep = MixChannels;
        
        for(int i=0; i<NumbOfVoices; i+=ChannelStep) {
            if( (isVoicePlaying(i+ChannelNr)==true) && isVoicePausing(i+ChannelNr)==false) {
                SampleMix += getNextVoiceSample(i+ChannelNr);
            }
        }
        checkSongEvent(); // check if song is playing, if so do play events
        return(SampleMix);
    }
    
    float getNextVoiceSample(int i) {
        Voice v;
        float Sample = 0.0f;
        float dSample;
        v = Voices[i];
        float vol;
        int ptr;
        float fract;
        
        v.processAllLFOs();
        vol = v.ChannelVolume;
        
        // Get Sample
        if(v.inUse == true) {
            switch(InterpolationType){
                case 0:
                    Sample = v.si.sp.Samples[(int) v.SamplePtr];
                    break;
                case 1:
                    ptr = (int) v.SamplePtr;
                    if((ptr+1)<=v.SampleEndPtr) {
                        fract = v.SamplePtr - ptr;
                        Sample = v.si.sp.Samples[ptr+1] * fract;
                        Sample += v.si.sp.Samples[ptr] * (1-fract);
                    } else {
                        Sample = v.si.sp.Samples[ptr];
                    }
                    break;
            }
            
            // Do Sample Smoothing
//            if(this.Declicking) {
//                Sample = v.Smoother.getSmoothedSample(Sample);
//            }
            Sample =  (Sample * vol) / 100;
            Sample = (Sample * v.si.Volume) / 100;                          // Apply Final Volume

            if(this.Declicking) {
                Sample = v.Smoother.getSmoothedSample(Sample);
            }
            
            
            dSample = (1.1f + (MasterTune/50)) * v.PlayFrequency / 440.0f;  // Apply Master Tune
            
            // Advance Samplepointer
            v.SamplePtr += dSample;
            
            // Check End of Loop Reached
            if(v.si.sp.hasLoop()==true) {
                ProcessLoopSystem(v);
            }
            
            if(v.SamplePtr > v.SampleEndPtr) {
                endVoice(v, Sample);
            }
            if(v.SamplePtr < 0.0f) {
                endVoice(v, Sample);
            }
        }
        
        if(v.si.NoDsp==false) {
            this.DSP.addVoiceSampleIntoDSP(Sample);
        }
        return(Sample);
    }
    
    void ProcessLoopSystem(Voice v) {
        if ( (v.getNumbOfLoopsRemaining() > 0) || (v.si.sp.getEndlessLoop()==true) ) {
            if(v.SamplePtr > v.si.sp.getLoopEndSampleIndex()) {
                v.SamplePtr = v.si.sp.getLoopStart();
                v.Smoother.activateSampleSmoothing();
                if(v.si.sp.getEndlessLoop() == false) v.decNumbOfLoopsRemaining();
            }
        }
    }
    
    void SampleToBuffer(float fSample, byte[] Dest, int i) {
        // Clipping
       if(fSample>32767.0f) fSample=32767.0f;
       if(fSample<-32767.0f) fSample=-32767.0f;
       
       // Conversion to 16 Bit
       short Sample = (short) fSample;
       Dest[i+1] = (byte) Sample;
       Dest[i] = (byte) java.lang.Short.reverseBytes(Sample);
    }
    
    SourceDataLine line;
    javax.sound.sampled.AudioFormat format;
    DataLine.Info info;
    
    void OpenMixSystem(){
        float Freq = 44100.0f;
        //int NumbOfChannels = MixChannels;
        int Frames = 2; // 2 Byte pro Channel
        int NumbOfBits = 16;
        
        //((sampleSizeInBits + 7) / 8) * channels
        
        // Small Buffer good, realtime performance
        format = new AudioFormat(javax.sound.sampled.AudioFormat.Encoding.PCM_SIGNED, Freq, NumbOfBits,
		       MixChannels, Frames * MixChannels, Freq, true); // (Freq / Frames) /2
        info = new DataLine.Info(SourceDataLine.class, format); // format is an AudioFormat object
        
        try{
            line = (SourceDataLine) AudioSystem.getLine(info);
            try{
                line.open(format);
                line.start();
                isReady = true;
                InitError = false;
                ErrorString = "Fast Mode (realtime performance)";

                } catch(Exception ex) {
                    ErrorString = ex.getMessage();
                    isReady = false;
                    InitError = true;
            }        
        } catch(Exception ex) {
            ErrorString = ex.getMessage();
            isReady = false;
            InitError = true;
        }        
    
        if(InitError == true) {
            OpenMixSystemSafe();
        }
    }

    private void OpenMixSystemSafe(){
        format = new AudioFormat(44100f, 16, 1, true, true); 
        info = new DataLine.Info(SourceDataLine.class, format); // format is an AudioFormat object
        
        try{
            line = (SourceDataLine) AudioSystem.getLine(info);
            try{
                line.open(format);
                line.start();
                isReady = true;
                InitError = false;
                ErrorString = "Safe Mode (slow)";

                } catch(Exception ex) {
                    ErrorString = ex.getMessage();
                    isReady = false;
                    InitError = true;
            }        
        } catch(Exception ex) {
            ErrorString = ex.getMessage();
            isReady = false;
            InitError = true;
            
        }        
    }
   
    java.util.Random r = new java.util.Random();
    
    float ProcessDithering(float Sample) {
        float e = r.nextFloat();
        return(Sample + (e*23));
    }
    
    void PlayActualMixThread() {
        while(true) {
            float Sample, DSPSample = 0;
            for(int i = 0;i<MixBufferLenSamples;i+=MixChannels ) {
                
                for(int ChannelNr = 0;ChannelNr<MixChannels;ChannelNr++) { // 2= Stereo
                    
                    Sample = getNextMixSample(ChannelNr);// Get Dry Stream
                    
                    // Add Wet DSP Stream
                    this.DSP.advanceWritePtr();
                    DSPSample = this.DSP.getWetMixSample();
                    this.DSP.advanceReadPtr();
                    
                    Sample = (Sample+DSPSample) * (MasterVolume/100) * 10000;// Master Volume
                    if(this.Dithering==1) Sample = ProcessDithering(Sample);// Dithering
                    SampleToBuffer(Sample, MixBuffer, (i+ChannelNr)*2 );// Send to Audio Subsystem
                }
            }
            
            // Send Samples to Java Audiosystem
            line.write(MixBuffer, 0, MixBufferLenSamples*2);
            Thread.yield();
        }
    }
}


